/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.Azione;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.ProprietariDocumento;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.utils.jdbc.BytesJDBCAdapter;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverRegistroServiziDB_LIB {
    public static Logger log = Logger.getLogger((String)"DRIVER_DB_REGISTRO");
    private static String tipoDB = null;
    private static boolean initialize = false;

    public static void initStaticLogger(Logger aLog) {
        if (!initialize) {
            if (aLog != null) {
                log = aLog;
            }
            initialize = true;
        }
    }

    public static boolean isStaticLoggerInitialized() {
        return initialize;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    /*
     * Loose catch block
     */
    public static void CRUDPortaDominio(int type, PortaDominio pdd, Connection con) throws DriverRegistroServiziException {
        block22: {
            if (pdd == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPdd] Parametro non valido.");
            }
            String nome = pdd.getNome();
            String descrizione = pdd.getDescrizione();
            String implementazione = pdd.getImplementazione();
            String subject = pdd.getSubject();
            String client_auth = pdd.getClientAuth();
            String superuser = pdd.getSuperUser();
            Statement updateStmt = null;
            String updateQuery = "";
            Statement selectStmt = null;
            String selectQuery = "";
            ResultSet selectRS = null;
            int n = 0;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("pdd");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("implementazione", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("client_auth", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject);
                    updateStmt.setString(5, client_auth);
                    updateStmt.setString(6, superuser);
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(7, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione, implementazione, subject, client_auth)));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        pdd.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    break;
                }
                case 2: {
                    long idPdd;
                    String nomePdd = pdd.getOldNomeForUpdate();
                    if (nomePdd == null || "".equals(nomePdd)) {
                        nomePdd = pdd.getNome();
                    }
                    if ((idPdd = DBUtils.getIdPortaDominio(nomePdd, con, tipoDB)) <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(UPDATE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("pdd");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("implementazione", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("client_auth", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    updateStmt.setString(3, implementazione);
                    updateStmt.setString(4, subject);
                    updateStmt.setString(5, client_auth);
                    updateStmt.setString(6, superuser);
                    int param_index = 6;
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(++param_index, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setLong(++param_index, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, descrizione, implementazione, subject, client_auth, idPdd)));
                    break;
                }
                case 3: {
                    long idPdd = DBUtils.getIdPortaDominio(nome, con, tipoDB);
                    if (idPdd <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortaDominio(DELETE)] Id Porta di Dominio non valido.");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("pdd");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idPdd);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDPdd type = " + type + " row affected =" + n));
                    log.debug((Object)("CRUDPdd DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idPdd)));
                }
            }
            Object var21_24 = null;
            try {
                updateStmt.close();
                selectRS.close();
                selectStmt.close();
            }
            catch (Exception e) {}
            break block22;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] SQLException [" + se.getMessage() + "].");
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverControlStationDB_LIB::CRUDPdd] Exception [" + se.getMessage() + "].");
                }
            }
            catch (Throwable throwable) {
                Object var21_25 = null;
                try {
                    updateStmt.close();
                    selectRS.close();
                    selectStmt.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDConnettore(int type, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        long l;
        PreparedStatement stm = null;
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere NULL.");
        }
        if (type != 3) {
            if (connettore.getNome() == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] il nome connettore non puo essere NULL.");
            if (connettore.getNome().trim().equals("")) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] il nome connettore non puo essere NULL.");
            }
        }
        String nomeConnettore = null;
        String endpointtype = null;
        boolean debug = false;
        String url = null;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        String nomeProperty = null;
        String valoreProperty = null;
        nomeConnettore = connettore.getNome();
        endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (!nomeProperty.equals("location")) continue;
                url = valoreProperty;
                continue;
            }
            if (!TipiConnettore.JMS.getNome().equals(endpointtype)) continue;
            if (nomeProperty.equals("location")) {
                nome = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("tipo")) {
                tipo = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("user")) {
                utente = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("password")) {
                password = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.factory.initial")) {
                initcont = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                urlpkg = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("context-java.naming.provider.url")) {
                provurl = valoreProperty;
                continue;
            }
            if (nomeProperty.equals("connection-factory")) {
                connectionfactory = valoreProperty;
                continue;
            }
            if (!nomeProperty.equals("send-as")) continue;
            sendas = valoreProperty;
        }
        try {
            try {
                String sqlQuery;
                long idConnettore = 0L;
                switch (type) {
                    case 1: {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("connettori");
                        sqlQueryObject.addInsertField("endpointtype", "?");
                        sqlQueryObject.addInsertField("url", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("utente", "?");
                        sqlQueryObject.addInsertField("password", "?");
                        sqlQueryObject.addInsertField("initcont", "?");
                        sqlQueryObject.addInsertField("urlpkg", "?");
                        sqlQueryObject.addInsertField("provurl", "?");
                        sqlQueryObject.addInsertField("connection_factory", "?");
                        sqlQueryObject.addInsertField("send_as", "?");
                        sqlQueryObject.addInsertField("nome_connettore", "?");
                        sqlQueryObject.addInsertField("debug", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, endpointtype);
                        stm.setString(2, url);
                        stm.setString(3, nome);
                        stm.setString(4, tipo);
                        stm.setString(5, utente);
                        stm.setString(6, password);
                        stm.setString(7, initcont);
                        stm.setString(8, urlpkg);
                        stm.setString(9, provurl);
                        stm.setString(10, connectionfactory);
                        stm.setString(11, sendas);
                        stm.setString(12, nomeConnettore);
                        if (debug) {
                            stm.setInt(13, 1);
                        } else {
                            stm.setInt(13, 0);
                        }
                        log.debug((Object)("CRUDConnettore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore)));
                        break;
                    }
                    case 2: {
                        idConnettore = connettore.getId();
                        if (idConnettore <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("connettori");
                        sqlQueryObject.addUpdateField("endpointtype", "?");
                        sqlQueryObject.addUpdateField("url", "?");
                        sqlQueryObject.addUpdateField("nome", "?");
                        sqlQueryObject.addUpdateField("tipo", "?");
                        sqlQueryObject.addUpdateField("utente", "?");
                        sqlQueryObject.addUpdateField("password", "?");
                        sqlQueryObject.addUpdateField("initcont", "?");
                        sqlQueryObject.addUpdateField("urlpkg", "?");
                        sqlQueryObject.addUpdateField("provurl", "?");
                        sqlQueryObject.addUpdateField("connection_factory", "?");
                        sqlQueryObject.addUpdateField("send_as", "?");
                        sqlQueryObject.addUpdateField("nome_connettore", "?");
                        sqlQueryObject.addUpdateField("debug", "?");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLUpdate();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, endpointtype);
                        stm.setString(2, url);
                        stm.setString(3, nome);
                        stm.setString(4, tipo);
                        stm.setString(5, utente);
                        stm.setString(6, password);
                        stm.setString(7, initcont);
                        stm.setString(8, urlpkg);
                        stm.setString(9, provurl);
                        stm.setString(10, connectionfactory);
                        stm.setString(11, sendas);
                        stm.setString(12, nomeConnettore);
                        if (debug) {
                            stm.setInt(13, 1);
                        } else {
                            stm.setInt(13, 0);
                        }
                        stm.setLong(14, idConnettore);
                        log.debug((Object)("CRUDConnettore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, idConnettore)));
                        break;
                    }
                    case 3: {
                        idConnettore = connettore.getId();
                        if (idConnettore <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("connettori");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, idConnettore);
                        log.debug((Object)("CRUDConnettore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore)));
                        break;
                    }
                }
                int n = stm.executeUpdate();
                log.debug((Object)("CRUDConnettore type = " + type + " row affected =" + n));
                if (type == 1) {
                    stm.close();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addFromTable("connettori");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_connettore = ?");
                    sqlQueryObject.addWhereCondition("endpointtype = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, nomeConnettore);
                    stm.setString(2, endpointtype);
                    log.debug((Object)("Recupero idConnettore inserito : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas)));
                    ResultSet rs = stm.executeQuery();
                    if (!rs.next()) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                    idConnettore = rs.getLong("id");
                    rs.close();
                    stm.close();
                }
                connettore.setId(idConnettore);
                l = idConnettore;
                Object var26_30 = null;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
            }
            catch (DriverException e) {
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var26_31 = null;
            try {
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        stm.close();
        return l;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDSoggetto(int type, SoggettoSpcoop soggetto, Connection con) throws DriverRegistroServiziException {
        block44: {
            block43: {
                if (soggetto == null) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro non valido.");
                }
                nome = soggetto.getNome();
                tipo = soggetto.getTipo();
                if (nome == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
                if (nome.equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
                }
                if (tipo == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
                if (tipo.equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
                }
                descizione = soggetto.getDescrizione();
                identificativoPorta = soggetto.getIdentificativoPorta();
                server = soggetto.getPortaDominio();
                connettore = soggetto.getConnettore();
                if (connettore == null && type != 1 && type != 3) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Il connettore del soggetto e' null.");
                }
                updateStmt = null;
                updateQuery = "";
                selectStmt = null;
                selectQuery = "";
                selectRS = null;
                idSoggetto = 0L;
                n = 0;
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("soggetti");
                                sqlQueryObject.addInsertField("nome_soggetto", "?");
                                sqlQueryObject.addInsertField("descrizione", "?");
                                sqlQueryObject.addInsertField("identificativo_porta", "?");
                                sqlQueryObject.addInsertField("tipo_soggetto", "?");
                                sqlQueryObject.addInsertField("id_connettore", "?");
                                sqlQueryObject.addInsertField("server", "?");
                                sqlQueryObject.addInsertField("superuser", "?");
                                sqlQueryObject.addInsertField("privato", "?");
                                sqlQueryObject.addInsertField("profilo", "?");
                                if (soggetto.getOraRegistrazione() != null) {
                                    sqlQueryObject.addInsertField("ora_registrazione", "?");
                                }
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                if (connettore == null) {
                                    connettore = new Connettore();
                                    connettore.setNome("CNT_" + tipo + "_" + nome);
                                }
                                if (connettore.getNome() == null || connettore.getNome().equals("")) {
                                    connettore.setNome("CNT_" + tipo + "_" + nome);
                                }
                                idConnettore = DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                                updateStmt.setString(1, nome);
                                updateStmt.setString(2, descizione);
                                updateStmt.setString(3, identificativoPorta);
                                updateStmt.setString(4, tipo);
                                updateStmt.setLong(5, idConnettore);
                                updateStmt.setString(6, server);
                                updateStmt.setString(7, soggetto.getSuperUser());
                                if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                                    updateStmt.setInt(8, 1);
                                } else {
                                    updateStmt.setInt(8, 0);
                                }
                                updateStmt.setString(9, soggetto.getProfilo());
                                if (soggetto.getOraRegistrazione() != null) {
                                    updateStmt.setTimestamp(10, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                                }
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{nome, descizione, identificativoPorta, tipo, idConnettore, server})));
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable("soggetti");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setString(1, nome);
                                selectRS = selectStmt.executeQuery();
                                if (selectRS.next()) {
                                    idSoggetto = selectRS.getLong("id");
                                }
                                soggetto.setId(idSoggetto);
                                selectRS.close();
                                selectStmt.close();
                                break;
                            }
                            case 2: {
                                oldNomeSoggetto = soggetto.getOldNomeForUpdate();
                                oldTipoSoggetto = soggetto.getOldTipoForUpdate();
                                if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                                    oldNomeSoggetto = nome;
                                }
                                if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                                    oldTipoSoggetto = tipo;
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("soggetti");
                                sqlQueryObject.addUpdateField("nome_soggetto", "?");
                                sqlQueryObject.addUpdateField("descrizione", "?");
                                sqlQueryObject.addUpdateField("identificativo_porta", "?");
                                sqlQueryObject.addUpdateField("tipo_soggetto", "?");
                                sqlQueryObject.addUpdateField("server", "?");
                                sqlQueryObject.addUpdateField("superuser", "?");
                                sqlQueryObject.addUpdateField("privato", "?");
                                sqlQueryObject.addUpdateField("profilo", "?");
                                if (soggetto.getOraRegistrazione() != null) {
                                    sqlQueryObject.addUpdateField("ora_registrazione", "?");
                                }
                                sqlQueryObject.addWhereCondition("id=?");
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(oldNomeSoggetto, oldTipoSoggetto, con);
                                connettore.setId(idConnettore);
                                idSoggetto = DBUtils.getIdSoggetto(oldNomeSoggetto, oldTipoSoggetto, con, DriverRegistroServiziDB_LIB.tipoDB);
                                if (idSoggetto <= 0L) {
                                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(UPDATE)] Id Soggetto non valido.");
                                }
                                updateStmt.setString(1, nome);
                                updateStmt.setString(2, descizione);
                                updateStmt.setString(3, identificativoPorta);
                                updateStmt.setString(4, tipo);
                                updateStmt.setString(5, server);
                                updateStmt.setString(6, soggetto.getSuperUser());
                                if (soggetto.getPrivato() != null && soggetto.getPrivato().booleanValue()) {
                                    updateStmt.setInt(7, 1);
                                } else {
                                    updateStmt.setInt(7, 0);
                                }
                                updateStmt.setString(8, soggetto.getProfilo());
                                if (soggetto.getOraRegistrazione() != null) {
                                    updateStmt.setTimestamp(9, new Timestamp(soggetto.getOraRegistrazione().getTime()));
                                    updateStmt.setLong(10, idSoggetto);
                                } else {
                                    updateStmt.setLong(9, idSoggetto);
                                }
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                newNomeConnettore = "CNT_" + tipo + "_" + nome;
                                connettore.setNome(newNomeConnettore);
                                DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{nome, descizione, identificativoPorta, tipo, idSoggetto})));
                                break;
                            }
                            case 3: {
                                idSoggetto = DBUtils.getIdSoggetto(nome, tipo, con, DriverRegistroServiziDB_LIB.tipoDB);
                                idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreSoggetto(nome, tipo, con);
                                if (idSoggetto <= 0L) {
                                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto(DELETE)] Id Soggetto non valido.");
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("soggetti");
                                sqlQueryObject.addWhereCondition("id=?");
                                sqlQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(sqlQuery);
                                updateStmt.setLong(1, idSoggetto);
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                connettore = new Connettore();
                                connettore.setId(idConnettore);
                                DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDSoggetto DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{idSoggetto})));
                                break;
                            }
                        }
                        if (type == 1) {
                            var19_17 = idSoggetto;
                            var25_29 = null;
                            break block43;
                        }
                        var19_18 = n;
                        break block44;
                    }
                    catch (DriverException e) {
                        throw new DriverRegistroServiziException(e);
                    }
                    catch (SQLException se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
                    }
                    catch (Exception se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDSoggetto] Exception [" + se.getMessage() + "].", se);
                    }
                }
                catch (Throwable var24_35) {
                    var25_31 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var24_35;
                        updateStmt.close();
                        throw var24_35;
                    }
                    catch (Exception e) {
                        throw var24_35;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [9 : 1749->1788)] { 
lbl182:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return var19_17;
            updateStmt.close();
            return var19_17;
lbl189:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var19_17;
        }
        var25_30 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return var19_18;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return var19_18;
        updateStmt.close();
        return var19_18;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDServizio(int type, ServizioSpcoop servizio, Connection con) throws DriverRegistroServiziException {
        long l;
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Servizio non valido.");
        }
        String nomeProprietario = servizio.getNomeSoggettoErogatore();
        String tipoProprietario = servizio.getTipoSoggettoErogatore();
        String nomeServizio = servizio.getNome();
        String tipoServizio = servizio.getTipo();
        String descrizione = servizio.getDescrizione();
        String stato = servizio.getStatoPackage();
        if (nomeProprietario == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Nome Proprietario non valido.");
        if (nomeProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Nome Proprietario non valido.");
        }
        if (tipoProprietario == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Tipo Proprietario non valido.");
        if (tipoProprietario.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Tipo Proprietario non valido.");
        }
        if (nomeServizio == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Nome Servizio non valido.");
        if (nomeServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Nome Servizio non valido.");
        }
        if (tipoServizio == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Tipo Servizio non valido.");
        if (tipoServizio.equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametro Tipo Servizio non valido.");
        }
        Connettore connettore = servizio.getConnettore();
        String wsdlImplementativoErogatore = servizio.getByteWsdlImplementativoErogatore() != null ? new String(servizio.getByteWsdlImplementativoErogatore()) : null;
        String wsdlImplementativoFruitore = servizio.getByteWsdlImplementativoFruitore() != null ? new String(servizio.getByteWsdlImplementativoFruitore()) : null;
        String wsag_sla = servizio.getByteWsagSla() != null ? new String(servizio.getByteWsagSla()) : null;
        wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
        wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
        wsag_sla = wsag_sla != null && !"".equals(wsag_sla.trim().replaceAll("\n", "")) ? wsag_sla : null;
        String firma = servizio.getByteFirma() != null ? new String(servizio.getByteFirma()) : null;
        firma = firma != null && !"".equals(firma.trim().replaceAll("\n", "")) ? firma : null;
        String superUser = servizio.getSuperUser();
        String servizioCorrelato = servizio.getServizioCorrelato() ? "abilitato" : "disabilitato";
        String port_type = servizio.getPortType() != null ? servizio.getPortType() : null;
        String tipo_adesione = servizio.getTipoAdesione() != null ? servizio.getTipoAdesione() : null;
        long idSoggetto = -1L;
        long idAccordoLong = -1L;
        try {
            if (type != 3) {
                String uriAccordo = servizio.getAccordoServizio();
                if (uriAccordo == null) throw new DriverRegistroServiziException("L'uri dell'Accordo di Servizio non puo essere null.");
                if (uriAccordo.equals("")) {
                    throw new DriverRegistroServiziException("L'uri dell'Accordo di Servizio non puo essere null.");
                }
                IDAccordo idAccordo = IDAccordo.getIDAccordoFromUri(uriAccordo);
                idAccordoLong = DBUtils.getIdAccordoServizio(idAccordo, con, tipoDB);
            }
        }
        catch (DriverException e) {
            log.error((Object)("Driver Error for get IDAccordo nome:[" + servizio.getAccordoServizio() + "]."), (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        try {
            String nomeS = nomeProprietario;
            String tipoS = tipoProprietario;
            idSoggetto = DBUtils.getIdSoggetto(nomeS, tipoS, con, tipoDB);
        }
        catch (DriverException e) {
            log.error((Object)"Driver Error.", (Throwable)e);
            throw new DriverRegistroServiziException(e);
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametri non validi. Impossibile risalire all'id del soggettoo");
        }
        if (idAccordoLong <= 0L && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Parametri non validi. Impossibile risalire all'id dell'accordo");
        }
        if (connettore == null && type != 1 && type != 3) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Il Connettore non puo essere nullo.");
        }
        Statement updateStmt = null;
        ResultSet updateRS = null;
        String updateQuery = "";
        try {
            try {
                long idServizio = 0L;
                int n = 0;
                int sizeFruitori = 0;
                servizio.setIdAccordo(idAccordoLong);
                switch (type) {
                    case 1: {
                        Documento doc;
                        int i;
                        if (connettore == null) {
                            connettore = new Connettore();
                            connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio);
                        }
                        if (connettore.getNome() == null || connettore.getNome().equals("")) {
                            connettore.setNome("CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio);
                        }
                        long idConnettore = DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("servizi");
                        sqlQueryObject.addInsertField("nome_servizio", "?");
                        sqlQueryObject.addInsertField("tipo_servizio", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        sqlQueryObject.addInsertField("id_accordo", "?");
                        sqlQueryObject.addInsertField("servizio_correlato", "?");
                        sqlQueryObject.addInsertField("id_connettore", "?");
                        sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                        sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                        sqlQueryObject.addInsertField("wsag_sla", "?");
                        sqlQueryObject.addInsertField("superuser", "?");
                        sqlQueryObject.addInsertField("privato", "?");
                        sqlQueryObject.addInsertField("port_type", "?");
                        sqlQueryObject.addInsertField("profilo", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("firma", "?");
                        if (tipo_adesione != null) {
                            sqlQueryObject.addInsertField("tipo_adesione", "?");
                        }
                        if (stato != null) {
                            sqlQueryObject.addInsertField("stato", "?");
                        }
                        if (servizio.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQueryObject.addInsertField("data_pubblicazione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, nomeServizio);
                        updateStmt.setString(2, tipoServizio);
                        updateStmt.setLong(3, idSoggetto);
                        updateStmt.setLong(4, idAccordoLong);
                        updateStmt.setString(5, servizioCorrelato);
                        updateStmt.setLong(6, idConnettore);
                        updateStmt.setString(7, wsdlImplementativoErogatore);
                        updateStmt.setString(8, wsdlImplementativoFruitore);
                        updateStmt.setString(9, wsag_sla);
                        updateStmt.setString(10, superUser);
                        if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) {
                            updateStmt.setInt(11, 1);
                        } else {
                            updateStmt.setInt(11, 0);
                        }
                        updateStmt.setString(12, port_type);
                        updateStmt.setString(13, servizio.getProfilo());
                        updateStmt.setString(14, descrizione);
                        updateStmt.setString(15, firma);
                        int index = 16;
                        if (tipo_adesione != null) {
                            updateStmt.setString(index, tipo_adesione);
                            ++index;
                        }
                        if (stato != null) {
                            updateStmt.setString(index, stato);
                            ++index;
                        }
                        if (servizio.getOraRegistrazione() != null) {
                            updateStmt.setTimestamp(index, new Timestamp(servizio.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        if (servizio.getDataPubblicazione() != null) {
                            updateStmt.setTimestamp(index, new Timestamp(servizio.getDataPubblicazione().getTime()));
                        } else {
                            updateStmt.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
                        }
                        ++index;
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDServizio CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, wsag_sla, superUser)));
                        log.debug((Object)("CRUDServizio type = " + type + " row affected =" + n));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("servizi");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("nome_servizio = ?");
                        sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLQuery();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, nomeServizio);
                        updateStmt.setString(2, tipoServizio);
                        updateStmt.setLong(3, idSoggetto);
                        log.debug((Object)("CRUDServizio recupero l'id del servizio appena creato : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto)));
                        updateRS = updateStmt.executeQuery();
                        if (updateRS.next()) {
                            idServizio = updateRS.getLong("id");
                        }
                        updateRS.close();
                        updateStmt.close();
                        if (idServizio <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio(addFruitore)] id servizio non recuperato");
                        }
                        servizio.setId(idServizio);
                        sizeFruitori = servizio.sizeFruitoreList();
                        Fruitore fruitore = null;
                        for (int i2 = 0; i2 < sizeFruitori; ++i2) {
                            fruitore = servizio.getFruitore(i2);
                            DriverRegistroServiziDB_LIB.CRUDServizioFruitore(1, fruitore, con, servizio);
                        }
                        ArrayList<Documento> documenti = new ArrayList<Documento>();
                        for (i = 0; i < servizio.sizeAllegatoList(); ++i) {
                            doc = servizio.getAllegato(i);
                            doc.setRuolo(RuoliDocumento.allegato.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaSemiformaleList(); ++i) {
                            doc = servizio.getSpecificaSemiformale(i);
                            doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaLivelloServizioList(); ++i) {
                            doc = servizio.getSpecificaLivelloServizio(i);
                            doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaSicurezzaList(); ++i) {
                            doc = servizio.getSpecificaSicurezza(i);
                            doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                            documenti.add(doc);
                        }
                        DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idServizio, ProprietariDocumento.servizio, con);
                        break;
                    }
                    case 2: {
                        Documento doc;
                        int i;
                        String oldNomeSoggetto = servizio.getOldNomeSoggettoErogatoreForUpdate();
                        String oldTipoSoggetto = servizio.getOldTipoSoggettoErogatoreForUpdate();
                        String oldNomeServizio = servizio.getOldNomeForUpdate();
                        String oldTipoServizio = servizio.getOldTipoForUpdate();
                        if (oldNomeServizio == null || oldNomeServizio.equals("")) {
                            oldNomeServizio = nomeServizio;
                        }
                        if (oldTipoServizio == null || oldTipoServizio.equals("")) {
                            oldTipoServizio = tipoServizio;
                        }
                        if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                            oldNomeSoggetto = nomeProprietario;
                        }
                        if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                            oldTipoSoggetto = tipoProprietario;
                        }
                        if ((idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, oldNomeSoggetto, oldTipoSoggetto, con, tipoDB)) <= 0L) {
                            idServizio = DBUtils.getIdServizio(oldNomeServizio, oldTipoServizio, nomeProprietario, tipoProprietario, con, tipoDB);
                        }
                        if (idServizio <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio(UPDATE)] Id Servizio non valido.");
                        }
                        long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, oldNomeSoggetto, oldTipoSoggetto, con);
                        if (idConnettore <= 0L) {
                            idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(oldNomeServizio, oldTipoServizio, nomeProprietario, tipoProprietario, con);
                        }
                        if (idConnettore <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] id connettore nullo.");
                        }
                        connettore.setId(idConnettore);
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("servizi");
                        sqlQueryObject.addUpdateField("nome_servizio", "?");
                        sqlQueryObject.addUpdateField("tipo_servizio", "?");
                        sqlQueryObject.addUpdateField("id_soggetto", "?");
                        sqlQueryObject.addUpdateField("id_accordo", "?");
                        sqlQueryObject.addUpdateField("servizio_correlato", "?");
                        sqlQueryObject.addUpdateField("id_connettore", "?");
                        sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                        sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                        sqlQueryObject.addUpdateField("wsag_sla", "?");
                        sqlQueryObject.addUpdateField("superuser", "?");
                        sqlQueryObject.addUpdateField("privato", "?");
                        sqlQueryObject.addUpdateField("port_type", "?");
                        sqlQueryObject.addUpdateField("profilo", "?");
                        sqlQueryObject.addUpdateField("descrizione", "?");
                        sqlQueryObject.addUpdateField("firma", "?");
                        if (tipo_adesione != null) {
                            sqlQueryObject.addUpdateField("tipo_adesione", "?");
                        }
                        if (stato != null) {
                            sqlQueryObject.addUpdateField("stato", "?");
                        }
                        if (servizio.getOraRegistrazione() != null) {
                            sqlQueryObject.addUpdateField("ora_registrazione", "?");
                        }
                        sqlQueryObject.addUpdateField("data_pubblicazione", "?");
                        sqlQueryObject.addWhereCondition("id=?");
                        updateQuery = sqlQueryObject.createSQLUpdate();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, nomeServizio);
                        updateStmt.setString(2, tipoServizio);
                        updateStmt.setLong(3, idSoggetto);
                        updateStmt.setLong(4, idAccordoLong);
                        updateStmt.setString(5, servizioCorrelato);
                        updateStmt.setLong(6, idConnettore);
                        updateStmt.setString(7, wsdlImplementativoErogatore);
                        updateStmt.setString(8, wsdlImplementativoFruitore);
                        updateStmt.setString(9, wsag_sla);
                        updateStmt.setString(10, superUser);
                        if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) {
                            updateStmt.setInt(11, 1);
                        } else {
                            updateStmt.setInt(11, 0);
                        }
                        updateStmt.setString(12, port_type);
                        updateStmt.setString(13, servizio.getProfilo());
                        updateStmt.setString(14, descrizione);
                        updateStmt.setString(15, firma);
                        int index = 16;
                        if (tipo_adesione != null) {
                            updateStmt.setString(index, tipo_adesione);
                            ++index;
                        }
                        if (stato != null) {
                            updateStmt.setString(index, stato);
                            ++index;
                        }
                        if (servizio.getOraRegistrazione() != null) {
                            updateStmt.setTimestamp(index, new Timestamp(servizio.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        if (servizio.getDataPubblicazione() != null) {
                            updateStmt.setTimestamp(index, new Timestamp(servizio.getDataPubblicazione().getTime()));
                        } else {
                            updateStmt.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
                        }
                        updateStmt.setLong(++index, idServizio);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDServizio type = " + type + " row affected =" + n));
                        String newNomeConnettore = "CNT_" + tipoProprietario + "/" + nomeProprietario + "_" + tipoServizio + "/" + nomeServizio;
                        connettore.setNome(newNomeConnettore);
                        DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                        sizeFruitori = servizio.sizeFruitoreList();
                        Fruitore fruitore = null;
                        DriverRegistroServiziDB_LIB.deleteAllFruitoriServizio(idServizio, con);
                        for (i = 0; i < sizeFruitori; ++i) {
                            fruitore = servizio.getFruitore(i);
                            DriverRegistroServiziDB_LIB.CRUDServizioFruitore(1, fruitore, con, servizio);
                        }
                        log.debug((Object)("CRUDServizio UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nomeServizio, tipoServizio, idSoggetto, idAccordoLong, servizioCorrelato, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore, wsag_sla, superUser, idServizio)));
                        ArrayList<Documento> documenti = new ArrayList<Documento>();
                        for (i = 0; i < servizio.sizeAllegatoList(); ++i) {
                            doc = servizio.getAllegato(i);
                            doc.setRuolo(RuoliDocumento.allegato.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaSemiformaleList(); ++i) {
                            doc = servizio.getSpecificaSemiformale(i);
                            doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaLivelloServizioList(); ++i) {
                            doc = servizio.getSpecificaLivelloServizio(i);
                            doc.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                            documenti.add(doc);
                        }
                        for (i = 0; i < servizio.sizeSpecificaSicurezzaList(); ++i) {
                            doc = servizio.getSpecificaSicurezza(i);
                            doc.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                            documenti.add(doc);
                        }
                        DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idServizio, ProprietariDocumento.servizio, con);
                        break;
                    }
                    case 3: {
                        idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB);
                        if (idServizio <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio(DELETE)] Id Servizio non valido.");
                        }
                        long idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con);
                        if (idConnettore <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio(DELETE)] Id Connettore non valido.");
                        }
                        sizeFruitori = servizio.sizeFruitoreList();
                        Fruitore fruitore = null;
                        for (int i = 0; i < sizeFruitori; ++i) {
                            fruitore = servizio.getFruitore(i);
                            DriverRegistroServiziDB_LIB.CRUDServizioFruitore(3, fruitore, con, servizio);
                        }
                        DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idServizio, ProprietariDocumento.servizio, con);
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("servizi");
                        sqlQueryObject.addWhereCondition("id=?");
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(sqlQuery);
                        updateStmt.setLong(1, idServizio);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDServizio type = " + type + " row affected =" + n));
                        connettore = new Connettore();
                        connettore.setId(idConnettore);
                        DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                        log.debug((Object)("CRUDServizio CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, idServizio)));
                        break;
                    }
                }
                l = n;
                Object var43_57 = null;
            }
            catch (DriverException e) {
                throw new DriverRegistroServiziException(e);
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] SQLException [" + se.getMessage() + "].", se);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizio] Exception [" + se.getMessage() + "].", se);
            }
        }
        catch (Throwable throwable) {
            Object var43_58 = null;
            try {
                if (updateRS != null) {
                    updateRS.close();
                }
                if (updateStmt == null) throw throwable;
                updateStmt.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            // empty catch block
            return l;
        }
        if (updateRS != null) {
            updateRS.close();
        }
        if (updateStmt == null) return l;
        updateStmt.close();
        return l;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDServizioFruitore(int type, Fruitore fruitore, Connection con, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        block43: {
            block42: {
                updateStmt = null;
                selectStmt = null;
                selectQuery = "";
                selectRS = null;
                idServizio = -1L;
                try {
                    tipoServ = servizio.getTipo();
                    nomeServ = servizio.getNome();
                    tipoSogg = servizio.getTipoSoggettoErogatore();
                    nomeSogg = servizio.getNomeSoggettoErogatore();
                    idServizio = DBUtils.getIdServizio(nomeServ, tipoServ, nomeSogg, tipoSogg, con, DriverRegistroServiziDB_LIB.tipoDB);
                }
                catch (DriverException e1) {
                    DriverRegistroServiziDB_LIB.log.error((Object)"Driver Error.", (Throwable)e1);
                    throw new DriverRegistroServiziException(e1);
                }
                if (idServizio <= 0L) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] ID Servizio non valido.");
                }
                connettore = fruitore.getConnettore();
                if (connettore == null && type != 1 && type != 3) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] il connettore non puo essere nullo.");
                }
                nomeSoggetto = fruitore.getNome();
                tipoSoggetto = fruitore.getTipo();
                if (nomeSoggetto == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] Nome Fruitore non valido.");
                if (nomeSoggetto.equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] Nome Fruitore non valido.");
                }
                if (tipoSoggetto == null) throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] Tipo Fruitore non valido.");
                if (tipoSoggetto.equals("")) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] Tipo Fruitore non valido.");
                }
                stato = fruitore.getStatoPackage();
                idSoggettoFruitore = -1L;
                try {
                    idSoggettoFruitore = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, DriverRegistroServiziDB_LIB.tipoDB);
                }
                catch (DriverException e1) {
                    DriverRegistroServiziDB_LIB.log.error((Object)"Driver Error.", (Throwable)e1);
                    throw new DriverRegistroServiziException(e1);
                }
                if (idSoggettoFruitore <= 0L) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDServizioFruitore] Id Soggetto Fruitore non valido.");
                }
                wsdlImplementativoErogatore = fruitore.getByteWsdlImplementativoErogatore() != null ? new String(fruitore.getByteWsdlImplementativoErogatore()) : null;
                wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && "".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) == false ? wsdlImplementativoErogatore : null;
                wsdlImplementativoFruitore = fruitore.getByteWsdlImplementativoFruitore() != null ? new String(fruitore.getByteWsdlImplementativoFruitore()) : null;
                wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && "".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) == false ? wsdlImplementativoFruitore : null;
                wsag_sla = fruitore.getByteWsagSla() != null ? new String(fruitore.getByteWsagSla()) : null;
                wsag_sla = wsag_sla != null && "".equals(wsag_sla.trim().replaceAll("\n", "")) == false ? wsag_sla : null;
                clientAuth = fruitore.getClientAuth();
                idConnettore = 0L;
                n = 0L;
                try {
                    try {
                        switch (type) {
                            case 1: {
                                if (connettore == null) {
                                    connettore = new Connettore();
                                }
                                connettore.setNome("CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome());
                                DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
                                idConnettore = connettore.getId();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("servizi_fruitori");
                                sqlQueryObject.addInsertField("id_servizio", "?");
                                sqlQueryObject.addInsertField("id_soggetto", "?");
                                sqlQueryObject.addInsertField("id_connettore", "?");
                                sqlQueryObject.addInsertField("wsdl_implementativo_erogatore", "?");
                                sqlQueryObject.addInsertField("wsdl_implementativo_fruitore", "?");
                                sqlQueryObject.addInsertField("wsag_sla", "?");
                                sqlQueryObject.addInsertField("profilo", "?");
                                sqlQueryObject.addInsertField("client_auth", "?");
                                if (stato != null) {
                                    sqlQueryObject.addInsertField("stato", "?");
                                }
                                if (fruitore.getOraRegistrazione() != null) {
                                    sqlQueryObject.addInsertField("ora_registrazione", "?");
                                }
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idServizio);
                                updateStmt.setLong(2, idSoggettoFruitore);
                                updateStmt.setLong(3, idConnettore);
                                updateStmt.setString(4, wsdlImplementativoErogatore);
                                updateStmt.setString(5, wsdlImplementativoFruitore);
                                updateStmt.setString(6, wsag_sla);
                                updateStmt.setString(7, fruitore.getProfilo());
                                updateStmt.setString(8, clientAuth);
                                index = 9;
                                if (stato != null) {
                                    updateStmt.setString(index, stato);
                                    ++index;
                                }
                                if (fruitore.getOraRegistrazione() != null) {
                                    updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                                    ++index;
                                }
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDServizioFruitore CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{idServizio, idSoggettoFruitore, idConnettore, wsdlImplementativoErogatore, wsdlImplementativoFruitore})));
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable("servizi_fruitori");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("id_servizio = ?");
                                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                                sqlQueryObject.addWhereCondition("id_connettore = ?");
                                sqlQueryObject.setANDLogicOperator(true);
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setLong(1, idServizio);
                                selectStmt.setLong(2, idSoggettoFruitore);
                                selectStmt.setLong(3, idConnettore);
                                break;
                            }
                            case 2: {
                                idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                                if (idConnettore < 0L) {
                                    throw new DriverRegistroServiziException("Il connettore del Fruitore del Servizio e' invalido id<0");
                                }
                                connettore.setId(idConnettore);
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("servizi_fruitori");
                                sqlQueryObject.addUpdateField("wsdl_implementativo_erogatore", "?");
                                sqlQueryObject.addUpdateField("wsdl_implementativo_fruitore", "?");
                                sqlQueryObject.addUpdateField("wsag_sla", "?");
                                sqlQueryObject.addUpdateField("profilo", "?");
                                sqlQueryObject.addUpdateField("client_auth", "?");
                                if (stato != null) {
                                    sqlQueryObject.addUpdateField("stato", "?");
                                }
                                if (fruitore.getOraRegistrazione() != null) {
                                    sqlQueryObject.addUpdateField("ora_registrazione", "?");
                                }
                                sqlQueryObject.addWhereCondition("id_servizio=?");
                                sqlQueryObject.addWhereCondition("id_soggetto=?");
                                sqlQueryObject.addWhereCondition("id_connettore=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, wsdlImplementativoErogatore);
                                updateStmt.setString(2, wsdlImplementativoFruitore);
                                updateStmt.setString(3, wsag_sla);
                                updateStmt.setString(4, fruitore.getProfilo());
                                updateStmt.setString(5, clientAuth);
                                index = 6;
                                if (stato != null) {
                                    updateStmt.setString(index, stato);
                                    ++index;
                                }
                                if (fruitore.getOraRegistrazione() != null) {
                                    updateStmt.setTimestamp(index, new Timestamp(fruitore.getOraRegistrazione().getTime()));
                                    ++index;
                                }
                                updateStmt.setLong(index, idServizio);
                                updateStmt.setLong(++index, idSoggettoFruitore);
                                updateStmt.setLong(++index, idConnettore);
                                ++index;
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDServizioFruitore UPDATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{wsdlImplementativoErogatore, wsdlImplementativoFruitore, idServizio, idSoggettoFruitore, idConnettore})));
                                DriverRegistroServiziDB_LIB.log.debug((Object)("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + connettore.getNome() + "]..."));
                                newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + "_" + servizio.getTipoSoggettoErogatore() + "/" + servizio.getNomeSoggettoErogatore() + "_" + servizio.getTipo() + "/" + servizio.getNome();
                                connettore.setNome(newNomeConnettore);
                                DriverRegistroServiziDB_LIB.log.debug((Object)("nuovo nome connettore [" + newNomeConnettore + "]"));
                                DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                                break;
                            }
                            case 3: {
                                idConnettore = DriverRegistroServiziDB_LIB.getIdConnettoreServizioFruitore(idServizio, nomeSoggetto, tipoSoggetto, con);
                                connettore.setId(idConnettore);
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("servizi_fruitori");
                                sqlQueryObject.addWhereCondition("id_servizio=?");
                                sqlQueryObject.addWhereCondition("id_soggetto=?");
                                sqlQueryObject.addWhereCondition("id_connettore=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                sqlQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(sqlQuery);
                                updateStmt.setLong(1, idServizio);
                                updateStmt.setLong(2, idSoggettoFruitore);
                                updateStmt.setLong(3, idConnettore);
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDServizioFruitore DELETE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, new Object[]{idServizio, idSoggettoFruitore, idConnettore})));
                                connettore = new Connettore();
                                connettore.setId(idConnettore);
                                DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
                                break;
                            }
                        }
                        DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDServizioFruitore type = " + type + " row affected =" + n));
                        if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                            sqlQueryObject = selectRS.getLong("id");
                            var30_34 = null;
                            break block42;
                        }
                        sqlQueryObject = n;
                        break block43;
                    }
                    catch (DriverException e) {
                        throw new DriverRegistroServiziException(e);
                    }
                    catch (SQLException se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] SQLException : " + se.getMessage(), se);
                    }
                    catch (Exception se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDFruitore] Exception : " + se.getMessage(), se);
                    }
                }
                catch (Throwable var29_40) {
                    var30_36 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var29_40;
                        updateStmt.close();
                        throw var29_40;
                    }
                    catch (Exception e) {
                        throw var29_40;
                    }
                }
            }
            ** try [egrp 4[TRYBLOCK] [11 : 2108->2147)] { 
lbl203:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl210:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var30_35 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDAzione(int type, AccordoServizio as, Azione azione, Connection con, long idAccordo) throws DriverRegistroServiziException {
        block28: {
            block27: {
                updateStmt = null;
                selectStmt = null;
                selectQuery = "";
                selectRS = null;
                n = 0L;
                if (idAccordo <= 0L) {
                    new Exception("[DriverRegistroServiziDB_LIB::CRUDAzione] ID Accordo non valido.");
                }
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("accordi_azioni");
                                sqlQueryObject.addInsertField("id_accordo", "?");
                                sqlQueryObject.addInsertField("nome", "?");
                                sqlQueryObject.addInsertField("profilo_azione", "?");
                                sqlQueryObject.addInsertField("filtro_duplicati", "?");
                                sqlQueryObject.addInsertField("conferma_ricezione", "?");
                                sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                                sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                                sqlQueryObject.addInsertField("scadenza", "?");
                                sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                                sqlQueryObject.addInsertField("correlata", "?");
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idAccordo);
                                updateStmt.setString(2, azione.getNome());
                                updateStmt.setString(3, azione.getProfAzione());
                                DriverRegistroServiziDB_LIB.log.debug((Object)("Aggiungo azione [" + azione.getNome() + "] con profilo [" + azione.getProfAzione() + "]"));
                                if ("ridefinito".equals(azione.getProfAzione())) {
                                    DriverRegistroServiziDB_LIB.log.debug((Object)"ridefinizione...");
                                    updateStmt.setString(4, azione.getFiltroDuplicati());
                                    updateStmt.setString(5, azione.getConfermaRicezione());
                                    updateStmt.setString(6, azione.getIdCollaborazione());
                                    updateStmt.setString(7, azione.getConsegnaInOrdine());
                                    updateStmt.setString(8, azione.getScadenza());
                                    updateStmt.setString(9, azione.getProfiloCollaborazione());
                                } else {
                                    updateStmt.setString(4, as.getFiltroDuplicati());
                                    updateStmt.setString(5, as.getConfermaRicezione());
                                    updateStmt.setString(6, as.getIdCollaborazione());
                                    updateStmt.setString(7, as.getConsegnaInOrdine());
                                    updateStmt.setString(8, as.getScadenza());
                                    updateStmt.setString(9, as.getProfiloCollaborazione());
                                }
                                updateStmt.setString(10, azione.getCorrelata());
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione CREATE :\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{idAccordo, azione.getNome(), azione.getProfAzione()})));
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable("accordi_azioni");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("id_accordo = ?");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                sqlQueryObject.setANDLogicOperator(true);
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setLong(1, idAccordo);
                                selectStmt.setString(2, azione.getNome());
                                break;
                            }
                            case 2: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("accordi_azioni");
                                sqlQueryObject.addUpdateField("profilo_azione", "?");
                                sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                                sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                                sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                                sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                                sqlQueryObject.addUpdateField("scadenza", "?");
                                sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                                sqlQueryObject.addUpdateField("correlata", "?");
                                sqlQueryObject.addWhereCondition("id_accordo=?");
                                sqlQueryObject.addWhereCondition("nome=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, azione.getProfAzione());
                                if ("ridefinito".equals(azione.getProfAzione())) {
                                    updateStmt.setString(2, azione.getFiltroDuplicati());
                                    updateStmt.setString(3, azione.getConfermaRicezione());
                                    updateStmt.setString(4, azione.getIdCollaborazione());
                                    updateStmt.setString(5, azione.getConsegnaInOrdine());
                                    updateStmt.setString(6, azione.getScadenza());
                                    updateStmt.setString(7, azione.getProfiloCollaborazione());
                                } else {
                                    updateStmt.setString(2, as.getFiltroDuplicati());
                                    updateStmt.setString(3, as.getConfermaRicezione());
                                    updateStmt.setString(4, as.getIdCollaborazione());
                                    updateStmt.setString(5, as.getConsegnaInOrdine());
                                    updateStmt.setString(6, as.getScadenza());
                                    updateStmt.setString(7, as.getProfiloCollaborazione());
                                }
                                updateStmt.setString(8, azione.getCorrelata());
                                updateStmt.setLong(9, idAccordo);
                                updateStmt.setString(10, azione.getNome());
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                                break;
                            }
                            case 3: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("accordi_azioni");
                                sqlQueryObject.addWhereCondition("id_accordo=?");
                                sqlQueryObject.addWhereCondition("nome=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                sqlQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(sqlQuery);
                                updateStmt.setLong(1, idAccordo);
                                updateStmt.setString(2, azione.getNome());
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione type = " + type + " row affected =" + n));
                                break;
                            }
                        }
                        if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                            azione.setId(selectRS.getLong("id"));
                            sqlQueryObject = azione.getId();
                            var16_18 = null;
                            break block27;
                        }
                        sqlQueryObject = n;
                        break block28;
                    }
                    catch (SQLException se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzione] SQLException : " + se.getMessage(), se);
                    }
                    catch (Exception se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzione] Exception : " + se.getMessage(), se);
                    }
                }
                catch (Throwable var15_24) {
                    var16_20 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var15_24;
                        updateStmt.close();
                        throw var15_24;
                    }
                    catch (Exception e) {
                        throw var15_24;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 1397->1436)] { 
lbl140:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl147:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var16_19 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDPortType(int type, AccordoServizio as, PortType pt, Connection con, long idAccordo) throws DriverRegistroServiziException {
        long idPT3;
        Statement updateStmt = null;
        Statement selectStmt = null;
        ResultSet selectRS = null;
        long n = 0L;
        if (idAccordo <= 0L) {
            new Exception("[DriverRegistroServiziDB_LIB::CRUDPortType] ID Accordo non valido.");
        }
        try {
            try {
                int i;
                switch (type) {
                    case 1: {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("port_type");
                        sqlQueryObject.addInsertField("id_accordo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("profilo_pt", "?");
                        sqlQueryObject.addInsertField("filtro_duplicati", "?");
                        sqlQueryObject.addInsertField("conferma_ricezione", "?");
                        sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                        sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                        sqlQueryObject.addInsertField("scadenza", "?");
                        sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                        sqlQueryObject.addInsertField("soap_style", "?");
                        String updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordo);
                        updateStmt.setString(2, pt.getNome());
                        updateStmt.setString(3, pt.getDescrizione());
                        updateStmt.setString(4, pt.getProfiloPT());
                        log.debug((Object)("Aggiungo port-type [" + pt.getNome() + "] con profilo [" + pt.getProfiloPT() + "]"));
                        if ("ridefinito".equals(pt.getProfiloPT())) {
                            log.debug((Object)"ridefinizione...");
                            updateStmt.setString(5, pt.getFiltroDuplicati());
                            updateStmt.setString(6, pt.getConfermaRicezione());
                            updateStmt.setString(7, pt.getIdCollaborazione());
                            updateStmt.setString(8, pt.getConsegnaInOrdine());
                            updateStmt.setString(9, pt.getScadenza());
                            updateStmt.setString(10, pt.getProfiloCollaborazione());
                        } else {
                            if (pt.getFiltroDuplicati() != null) {
                                updateStmt.setString(5, pt.getFiltroDuplicati());
                            } else {
                                updateStmt.setString(5, as.getFiltroDuplicati());
                            }
                            if (pt.getConfermaRicezione() != null) {
                                updateStmt.setString(6, pt.getConfermaRicezione());
                            } else {
                                updateStmt.setString(6, as.getConfermaRicezione());
                            }
                            if (pt.getIdCollaborazione() != null) {
                                updateStmt.setString(7, pt.getIdCollaborazione());
                            } else {
                                updateStmt.setString(7, as.getIdCollaborazione());
                            }
                            if (pt.getConsegnaInOrdine() != null) {
                                updateStmt.setString(8, pt.getConsegnaInOrdine());
                            } else {
                                updateStmt.setString(8, as.getConsegnaInOrdine());
                            }
                            if (pt.getScadenza() != null) {
                                updateStmt.setString(9, pt.getScadenza());
                            } else {
                                updateStmt.setString(9, as.getScadenza());
                            }
                            if (pt.getProfiloCollaborazione() != null) {
                                updateStmt.setString(10, pt.getProfiloCollaborazione());
                            } else {
                                updateStmt.setString(10, as.getProfiloCollaborazione());
                            }
                        }
                        updateStmt.setString(11, pt.getStyle());
                        n = updateStmt.executeUpdate();
                        log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                        break;
                    }
                    case 2: {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("port_type");
                        sqlQueryObject.addUpdateField("descrizione", "?");
                        sqlQueryObject.addUpdateField("profilo_pt", "?");
                        sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                        sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                        sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                        sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                        sqlQueryObject.addUpdateField("scadenza", "?");
                        sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                        sqlQueryObject.addUpdateField("soap_style", "?");
                        sqlQueryObject.addWhereCondition("id_accordo=?");
                        sqlQueryObject.addWhereCondition("nome=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        String updateQuery = sqlQueryObject.createSQLUpdate();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, pt.getDescrizione());
                        updateStmt.setString(2, pt.getProfiloPT());
                        if ("ridefinito".equals(pt.getProfiloPT())) {
                            updateStmt.setString(3, pt.getFiltroDuplicati());
                            updateStmt.setString(4, pt.getConfermaRicezione());
                            updateStmt.setString(5, pt.getIdCollaborazione());
                            updateStmt.setString(6, pt.getConsegnaInOrdine());
                            updateStmt.setString(7, pt.getScadenza());
                            updateStmt.setString(8, pt.getProfiloCollaborazione());
                        } else {
                            if (pt.getFiltroDuplicati() != null) {
                                updateStmt.setString(3, pt.getFiltroDuplicati());
                            } else {
                                updateStmt.setString(3, as.getFiltroDuplicati());
                            }
                            if (pt.getConfermaRicezione() != null) {
                                updateStmt.setString(4, pt.getConfermaRicezione());
                            } else {
                                updateStmt.setString(4, as.getConfermaRicezione());
                            }
                            if (pt.getIdCollaborazione() != null) {
                                updateStmt.setString(5, pt.getIdCollaborazione());
                            } else {
                                updateStmt.setString(5, as.getIdCollaborazione());
                            }
                            if (pt.getConsegnaInOrdine() != null) {
                                updateStmt.setString(6, pt.getConsegnaInOrdine());
                            } else {
                                updateStmt.setString(6, as.getConsegnaInOrdine());
                            }
                            if (pt.getScadenza() != null) {
                                updateStmt.setString(7, pt.getScadenza());
                            } else {
                                updateStmt.setString(7, as.getScadenza());
                            }
                            if (pt.getProfiloCollaborazione() != null) {
                                updateStmt.setString(8, pt.getProfiloCollaborazione());
                            } else {
                                updateStmt.setString(8, as.getProfiloCollaborazione());
                            }
                        }
                        updateStmt.setString(9, pt.getStyle());
                        updateStmt.setLong(10, idAccordo);
                        updateStmt.setString(11, pt.getNome());
                        n = updateStmt.executeUpdate();
                        log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                        break;
                    }
                    case 3: {
                        Long idPT2 = 0L;
                        if (pt.getId() == null || pt.getId() <= 0L) {
                            idPT2 = DBUtils.getIdPortType(idAccordo, pt.getNome(), con);
                            if (idPT2 == null) throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                            if (idPT2 <= 0L) {
                                throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                            }
                        }
                        for (i = 0; i < pt.sizeAzioneList(); ++i) {
                            DriverRegistroServiziDB_LIB.CRUDAzionePortType(3, as, pt, pt.getAzione(i), con, idPT2);
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("port_type");
                        sqlQueryObject.addWhereCondition("id_accordo=?");
                        sqlQueryObject.addWhereCondition("nome=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        String updateQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordo);
                        updateStmt.setString(2, pt.getNome());
                        n = updateStmt.executeUpdate();
                        log.debug((Object)("CRUDPortType type = " + type + " row affected =" + n));
                        break;
                    }
                }
                if (1 == type || 2 == type) {
                    Long idPT3 = DBUtils.getIdPortType(idAccordo, pt.getNome(), con);
                    if (idPT3 == null) throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                    if (idPT3 <= 0L) {
                        throw new Exception("ID del porttype[" + pt.getNome() + "] idAccordo[" + idAccordo + "] non trovato");
                    }
                    log.debug((Object)("ID port type: " + idPT3));
                    if (2 == type) {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("port_type_azioni");
                        sqlQueryObject.addWhereCondition("id_port_type=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        updateStmt = con.prepareStatement(sqlQuery);
                        updateStmt.setLong(1, idPT3);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.info((Object)("Cancellate " + n + " azioni del port type [" + idPT3 + "] associate all'accordo " + idAccordo));
                    }
                    Operation azione = null;
                    for (i = 0; i < pt.sizeAzioneList(); ++i) {
                        azione = pt.getAzione(i);
                        DriverRegistroServiziDB_LIB.CRUDAzionePortType(1, as, pt, azione, con, idPT3);
                    }
                    log.debug((Object)("inserite " + pt.sizeAzioneList() + " azioni relative al port type[" + pt.getNome() + "] id-porttype[" + pt.getId() + "] dell'accordo :" + IDAccordo.getUriFromAccordo(as) + " id-accordo :" + idAccordo));
                }
                idPT3 = n;
                Object var16_17 = null;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortType] SQLException : " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDPortType] Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt == null) throw throwable;
                updateStmt.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return idPT3;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return idPT3;
        updateStmt.close();
        return idPT3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDAzionePortType(int type, AccordoServizio as, PortType pt, Operation azione, Connection con, long idPortType) throws DriverRegistroServiziException {
        block84: {
            block83: {
                updateStmt = null;
                selectStmt = null;
                selectQuery = "";
                selectRS = null;
                n = 0L;
                if (idPortType <= 0L) {
                    new Exception("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] ID Port Type non valido.");
                }
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("port_type_azioni");
                                sqlQueryObject.addInsertField("id_port_type", "?");
                                sqlQueryObject.addInsertField("nome", "?");
                                sqlQueryObject.addInsertField("profilo_pt_azione", "?");
                                sqlQueryObject.addInsertField("filtro_duplicati", "?");
                                sqlQueryObject.addInsertField("conferma_ricezione", "?");
                                sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
                                sqlQueryObject.addInsertField("consegna_in_ordine", "?");
                                sqlQueryObject.addInsertField("scadenza", "?");
                                sqlQueryObject.addInsertField("profilo_collaborazione", "?");
                                sqlQueryObject.addInsertField("soap_style", "?");
                                sqlQueryObject.addInsertField("soap_action", "?");
                                sqlQueryObject.addInsertField("soap_use_msg_input", "?");
                                sqlQueryObject.addInsertField("soap_use_msg_output", "?");
                                sqlQueryObject.addInsertField("correlata_servizio", "?");
                                sqlQueryObject.addInsertField("correlata", "?");
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idPortType);
                                updateStmt.setString(2, azione.getNome());
                                updateStmt.setString(3, azione.getProfAzione());
                                DriverRegistroServiziDB_LIB.log.debug((Object)("Aggiungo azione [" + azione.getNome() + "] pt [" + pt.getNome() + "] con profilo [" + azione.getProfAzione() + "]"));
                                if ("ridefinito".equals(azione.getProfAzione())) {
                                    DriverRegistroServiziDB_LIB.log.debug((Object)"ridefinizione...");
                                    updateStmt.setString(4, azione.getFiltroDuplicati());
                                    updateStmt.setString(5, azione.getConfermaRicezione());
                                    updateStmt.setString(6, azione.getIdCollaborazione());
                                    updateStmt.setString(7, azione.getConsegnaInOrdine());
                                    updateStmt.setString(8, azione.getScadenza());
                                    updateStmt.setString(9, azione.getProfiloCollaborazione());
                                } else {
                                    if (azione.getFiltroDuplicati() != null) {
                                        updateStmt.setString(4, azione.getFiltroDuplicati());
                                    } else if (pt.getFiltroDuplicati() != null) {
                                        updateStmt.setString(4, pt.getFiltroDuplicati());
                                    } else {
                                        updateStmt.setString(4, as.getFiltroDuplicati());
                                    }
                                    if (azione.getConfermaRicezione() != null) {
                                        updateStmt.setString(5, azione.getConfermaRicezione());
                                    } else if (pt.getConfermaRicezione() != null) {
                                        updateStmt.setString(5, pt.getConfermaRicezione());
                                    } else {
                                        updateStmt.setString(5, as.getConfermaRicezione());
                                    }
                                    if (azione.getIdCollaborazione() != null) {
                                        updateStmt.setString(6, azione.getIdCollaborazione());
                                    } else if (pt.getIdCollaborazione() != null) {
                                        updateStmt.setString(6, pt.getIdCollaborazione());
                                    } else {
                                        updateStmt.setString(6, as.getIdCollaborazione());
                                    }
                                    if (azione.getConsegnaInOrdine() != null) {
                                        updateStmt.setString(7, azione.getConsegnaInOrdine());
                                    } else if (pt.getConsegnaInOrdine() != null) {
                                        updateStmt.setString(7, pt.getConsegnaInOrdine());
                                    } else {
                                        updateStmt.setString(7, as.getConsegnaInOrdine());
                                    }
                                    if (azione.getScadenza() != null) {
                                        updateStmt.setString(8, azione.getScadenza());
                                    } else if (pt.getScadenza() != null) {
                                        updateStmt.setString(8, pt.getScadenza());
                                    } else {
                                        updateStmt.setString(8, as.getScadenza());
                                    }
                                    if (azione.getProfiloCollaborazione() != null) {
                                        updateStmt.setString(9, azione.getProfiloCollaborazione());
                                    } else if (pt.getProfiloCollaborazione() != null) {
                                        updateStmt.setString(9, pt.getProfiloCollaborazione());
                                    } else {
                                        updateStmt.setString(9, as.getProfiloCollaborazione());
                                    }
                                }
                                updateStmt.setString(10, azione.getStyle());
                                updateStmt.setString(11, azione.getSoapAction());
                                if (azione.getMessageInput() != null) {
                                    updateStmt.setString(12, azione.getMessageInput().getUse());
                                } else {
                                    updateStmt.setString(12, null);
                                }
                                if (azione.getMessageOutput() != null) {
                                    updateStmt.setString(13, azione.getMessageOutput().getUse());
                                } else {
                                    updateStmt.setString(13, null);
                                }
                                updateStmt.setString(14, azione.getCorrelataServizio());
                                updateStmt.setString(15, azione.getCorrelata());
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDPortTypeAzione CREATE :\n" + updateQuery));
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable("port_type_azioni");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("id_port_type = ?");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                sqlQueryObject.setANDLogicOperator(true);
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setLong(1, idPortType);
                                selectStmt.setString(2, azione.getNome());
                                break;
                            }
                            case 2: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("port_type_azioni");
                                sqlQueryObject.addUpdateField("profilo_azione", "?");
                                sqlQueryObject.addUpdateField("filtro_duplicati", "?");
                                sqlQueryObject.addUpdateField("conferma_ricezione", "?");
                                sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
                                sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
                                sqlQueryObject.addUpdateField("scadenza", "?");
                                sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
                                sqlQueryObject.addUpdateField("soap_style", "?");
                                sqlQueryObject.addUpdateField("soap_action", "?");
                                sqlQueryObject.addUpdateField("soap_use_msg_input", "?");
                                sqlQueryObject.addUpdateField("soap_use_msg_output", "?");
                                sqlQueryObject.addUpdateField("correlata_servizio", "?");
                                sqlQueryObject.addUpdateField("correlata", "?");
                                sqlQueryObject.addWhereCondition("id_port_type=?");
                                sqlQueryObject.addWhereCondition("nome=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, azione.getProfAzione());
                                if ("ridefinito".equals(azione.getProfAzione())) {
                                    updateStmt.setString(2, azione.getFiltroDuplicati());
                                    updateStmt.setString(3, azione.getConfermaRicezione());
                                    updateStmt.setString(4, azione.getIdCollaborazione());
                                    updateStmt.setString(5, azione.getConsegnaInOrdine());
                                    updateStmt.setString(6, azione.getScadenza());
                                    updateStmt.setString(7, azione.getProfiloCollaborazione());
                                } else {
                                    if (azione.getFiltroDuplicati() != null) {
                                        updateStmt.setString(2, azione.getFiltroDuplicati());
                                    } else if (pt.getFiltroDuplicati() != null) {
                                        updateStmt.setString(2, pt.getFiltroDuplicati());
                                    } else {
                                        updateStmt.setString(2, as.getFiltroDuplicati());
                                    }
                                    if (azione.getConfermaRicezione() != null) {
                                        updateStmt.setString(3, azione.getConfermaRicezione());
                                    } else if (pt.getConfermaRicezione() != null) {
                                        updateStmt.setString(3, pt.getConfermaRicezione());
                                    } else {
                                        updateStmt.setString(3, as.getConfermaRicezione());
                                    }
                                    if (azione.getIdCollaborazione() != null) {
                                        updateStmt.setString(4, azione.getIdCollaborazione());
                                    } else if (pt.getIdCollaborazione() != null) {
                                        updateStmt.setString(4, pt.getIdCollaborazione());
                                    } else {
                                        updateStmt.setString(4, as.getIdCollaborazione());
                                    }
                                    if (azione.getConsegnaInOrdine() != null) {
                                        updateStmt.setString(5, azione.getConsegnaInOrdine());
                                    } else if (pt.getConsegnaInOrdine() != null) {
                                        updateStmt.setString(5, pt.getConsegnaInOrdine());
                                    } else {
                                        updateStmt.setString(5, as.getConsegnaInOrdine());
                                    }
                                    if (azione.getScadenza() != null) {
                                        updateStmt.setString(6, azione.getScadenza());
                                    } else if (pt.getScadenza() != null) {
                                        updateStmt.setString(6, pt.getScadenza());
                                    } else {
                                        updateStmt.setString(6, as.getScadenza());
                                    }
                                    if (azione.getProfiloCollaborazione() != null) {
                                        updateStmt.setString(7, azione.getProfiloCollaborazione());
                                    } else if (pt.getProfiloCollaborazione() != null) {
                                        updateStmt.setString(7, pt.getProfiloCollaborazione());
                                    } else {
                                        updateStmt.setString(7, as.getProfiloCollaborazione());
                                    }
                                }
                                updateStmt.setString(8, azione.getStyle());
                                updateStmt.setString(9, azione.getSoapAction());
                                if (azione.getMessageInput() != null) {
                                    updateStmt.setString(10, azione.getMessageInput().getUse());
                                } else {
                                    updateStmt.setString(10, null);
                                }
                                if (azione.getMessageOutput() != null) {
                                    updateStmt.setString(11, azione.getMessageOutput().getUse());
                                } else {
                                    updateStmt.setString(11, null);
                                }
                                updateStmt.setString(12, azione.getCorrelataServizio());
                                updateStmt.setString(13, azione.getCorrelata());
                                updateStmt.setLong(14, idPortType);
                                updateStmt.setString(15, azione.getNome());
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                                break;
                            }
                            case 3: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("operation_messages");
                                sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione DELETE MESSAGES:\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{azione.getId()})));
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, azione.getId());
                                n = updateStmt.executeUpdate();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverRegistroServiziDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("port_type_azioni");
                                sqlQueryObject.addWhereCondition("id_port_type=?");
                                sqlQueryObject.addWhereCondition("nome=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzione DELETE AZIONI:\n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, new Object[]{idPortType, azione.getNome()})));
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idPortType);
                                updateStmt.setString(2, azione.getNome());
                                n = updateStmt.executeUpdate();
                                DriverRegistroServiziDB_LIB.log.debug((Object)("CRUDAzionePortType type = " + type + " row affected =" + n));
                                break;
                            }
                        }
                        if (1 == type && (selectRS = selectStmt.executeQuery()).next()) {
                            azione.setId(selectRS.getLong("id"));
                            azione.setIdPortType(idPortType);
                            DriverRegistroServiziDB_LIB.CRUDMessageAzionePortType(1, azione, con);
                            sqlQueryObject = azione.getId();
                            var17_19 = null;
                            break block83;
                        }
                        sqlQueryObject = n;
                        break block84;
                    }
                    catch (SQLException se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] SQLException : " + se.getMessage(), se);
                    }
                    catch (Exception se) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAzionePortType] Exception : " + se.getMessage(), se);
                    }
                }
                catch (Throwable var16_25) {
                    var17_21 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var16_25;
                        updateStmt.close();
                        throw var16_25;
                    }
                    catch (Exception e) {
                        throw var16_25;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 2448->2487)] { 
lbl255:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl262:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var17_20 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Loose catch block
     */
    public static void CRUDMessageAzionePortType(int type, Operation azione, Connection con) throws DriverRegistroServiziException {
        block24: {
            Statement updateStmt = null;
            Statement selectStmt = null;
            ResultSet selectRS = null;
            if (azione.getId() <= 0L) {
                new Exception("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] ID Operation Port Type non valida.");
            }
            switch (type) {
                case 1: {
                    MessagePart part;
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("operation_messages");
                    sqlQueryObject.addInsertField("id_port_type_azione", "?");
                    sqlQueryObject.addInsertField("input_message", "?");
                    sqlQueryObject.addInsertField("element_name", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    if (azione.getMessageInput() != null) {
                        for (i = 0; i < azione.getMessageInput().sizePartList(); ++i) {
                            updateStmt = con.prepareStatement(updateQuery);
                            part = azione.getMessageInput().getPart(i);
                            updateStmt.setLong(1, azione.getId());
                            updateStmt.setInt(2, 1);
                            updateStmt.setString(3, part.getElementName());
                            log.debug((Object)("Aggiungo part element input  [" + part.getElementName() + "] per azione [" + azione.getNome() + "]"));
                            log.debug((Object)("CRUDMessageAzionePortType CREATE :\n" + updateQuery));
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    if (azione.getMessageOutput() == null) break;
                    for (i = 0; i < azione.getMessageOutput().sizePartList(); ++i) {
                        updateStmt = con.prepareStatement(updateQuery);
                        part = azione.getMessageOutput().getPart(i);
                        updateStmt.setLong(1, azione.getId());
                        updateStmt.setInt(2, 0);
                        updateStmt.setString(3, part.getElementName());
                        log.debug((Object)("Aggiungo part element output [" + part.getElementName() + "] per azione [" + azione.getNome() + "]"));
                        log.debug((Object)("CRUDMessageAzionePortType CREATE :\n" + updateQuery));
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    break;
                }
                case 2: {
                    throw new Exception("Non implementato");
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, azione.getId());
                    long n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDMessageAzionePortType type = " + type + " row affected =" + n));
                }
            }
            Object var11_15 = null;
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
                break block24;
            }
            catch (Exception e) {}
            break block24;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] SQLException : " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDMessageAzionePortType] Exception : " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                try {
                    if (selectRS != null) {
                        selectRS.close();
                    }
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getIdConnettoreSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, tipoSoggetto);
                stm.setString(2, nomeSoggetto);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                }
                l = idConnettore;
                Object var12_11 = null;
            }
            catch (SQLException e) {
                log.error((Object)"Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception e) {
                log.error((Object)"Errore", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                rs.close();
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        rs.close();
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getIdConnettoreServizio(String nomeServizio, String tipoServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                sqlQueryObject.addWhereCondition("nome_servizio = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, tipoServizio);
                stm.setString(2, nomeServizio);
                stm.setLong(3, idSoggetto);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                }
                l = idConnettore;
                Object var16_15 = null;
            }
            catch (DriverException e) {
                log.error((Object)"Errore Driver.", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (SQLException e) {
                log.error((Object)"Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception e) {
                log.error((Object)"Errore", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            try {
                rs.close();
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        rs.close();
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getIdConnettoreServizioFruitore(long idServizio, String nomeSoggetto, String tipoSoggetto, Connection con) throws DriverRegistroServiziException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                long idSoggetto = DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB);
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio = ?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setLong(1, idServizio);
                stm.setLong(2, idSoggetto);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                }
                l = idConnettore;
                Object var16_14 = null;
            }
            catch (DriverException e) {
                log.error((Object)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (SQLException e) {
                log.error((Object)"Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception e) {
                log.error((Object)"Errore", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            try {
                rs.close();
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        rs.close();
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteAllFruitoriServizio(long idServizio, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                ArrayList<Long> listaConnettori = new ArrayList<Long>();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setLong(1, idServizio);
                rs = stm.executeQuery();
                while (rs.next()) {
                    listaConnettori.add(rs.getLong("id_connettore"));
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addDeleteTable("servizi_fruitori");
                sqlQueryObject.addWhereCondition("id_servizio=?");
                String sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idServizio);
                int n = stm.executeUpdate();
                stm.close();
                log.debug((Object)("Cancellati " + n + " Fruitori del servizio " + idServizio));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addDeleteTable("connettori");
                sqlQueryObject.addWhereCondition("id=?");
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = con.prepareStatement(sqlQuery);
                for (Long idConnettore : listaConnettori) {
                    stm.setLong(1, idConnettore);
                    stm.executeUpdate();
                }
                stm.close();
                log.debug((Object)("Cancellati connettori " + listaConnettori.toString() + " associati ai Fruitori del servizio " + idServizio));
            }
            catch (SQLException e) {
                log.error((Object)"Errore SQL", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            catch (Exception e) {
                log.error((Object)"Errore", (Throwable)e);
                throw new DriverRegistroServiziException(e);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        stm.close();
        return;
    }

    /*
     * Loose catch block
     */
    public static void CRUDDocumento(int type, List<Documento> documenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, Connection connection) throws DriverRegistroServiziException {
        block52: {
            Statement stm = null;
            ResultSet rs = null;
            if (documenti == null && type != 3) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] L'oggetto documenti non puo essere null");
            }
            if (idProprietario <= 0L) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] id proprietario non definito");
            }
            BytesJDBCAdapter jdbcAdapter = null;
            jdbcAdapter = new BytesJDBCAdapter();
            switch (type) {
                case 1: {
                    for (int i = 0; i < documenti.size(); ++i) {
                        String test;
                        Documento doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        byte[] contenuto = doc.getByteContenuto();
                        if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                            contenuto = null;
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        String sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        int index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        log.debug((Object)("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString())));
                        int n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        log.debug((Object)("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString())));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        rs.close();
                        stm.close();
                    }
                    break;
                }
                case 2: {
                    String sqlQuery;
                    List<Documento> oldLista = null;
                    try {
                        oldLista = DriverRegistroServiziDB_LIB.getListaDocumenti(idProprietario, tipologiaProprietarioDocumento, false, connection);
                    }
                    catch (DriverRegistroServiziNotFound dNotFound) {
                        oldLista = new ArrayList<Documento>();
                    }
                    for (int i = 0; i < documenti.size(); ++i) {
                        Documento doc = documenti.get(i);
                        if (doc.getFile() == null || "".equals(doc.getFile())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Nome non definito per documento [" + i + "]");
                        }
                        if (doc.getRuolo() == null || "".equals(doc.getRuolo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Ruolo non definito per documento [" + doc.getFile() + "]");
                        }
                        if (doc.getTipo() == null || "".equals(doc.getTipo())) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Tipo non definito per documento [" + doc.getFile() + "]");
                        }
                        BeanUtilities.validateTipoRuolo(doc.getTipo(), doc.getRuolo());
                        doc.setId(DBUtils.getIdDocumento(doc.getFile(), doc.getTipo(), doc.getRuolo(), idProprietario, connection, tipoDB, tipologiaProprietarioDocumento));
                        if (doc.getOraRegistrazione() == null) {
                            doc.setOraRegistrazione(new Date());
                        }
                        doc.setIdProprietarioDocumento(idProprietario);
                        boolean documentoGiaPresente = false;
                        boolean documentoDaAggiornare = false;
                        if (doc.getId() > 0L) {
                            for (int j = 0; j < oldLista.size(); ++j) {
                                Documento old = oldLista.get(j);
                                if (doc.getId().longValue() != old.getId().longValue()) continue;
                                documentoGiaPresente = true;
                                if (doc.getOraRegistrazione() == null) {
                                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] OraRegistrazione non definita per documento, precedentemente gia inserito, [" + doc.getFile() + "]");
                                }
                                oldLista.remove(j);
                                if (!doc.getOraRegistrazione().after(old.getOraRegistrazione())) continue;
                                documentoDaAggiornare = true;
                            }
                        }
                        byte[] contenuto = null;
                        if (!documentoGiaPresente || documentoDaAggiornare) {
                            String test;
                            if (doc.getByteContenuto() == null || doc.getByteContenuto().length <= 0) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] Contenuto non definito per documento [" + doc.getFile() + "]");
                            }
                            contenuto = doc.getByteContenuto();
                            if (contenuto.length < 3 && "".equals((test = new String(contenuto)).trim().replaceAll("\n", ""))) {
                                contenuto = null;
                            }
                        }
                        if (documentoGiaPresente) {
                            if (!documentoDaAggiornare) continue;
                            long idDocumento = doc.getId();
                            if (idDocumento <= 0L) {
                                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDDocumento] ID non definito per documento da aggiorare [" + doc.getFile() + "]");
                            }
                            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addUpdateTable("documenti");
                            sqlQueryObject.addUpdateField("tipo", "?");
                            sqlQueryObject.addUpdateField("nome", "?");
                            sqlQueryObject.addUpdateField("contenuto", "?");
                            sqlQueryObject.addUpdateField("ora_registrazione", "?");
                            sqlQueryObject.addWhereCondition("id=?");
                            sqlQuery = sqlQueryObject.createSQLUpdate();
                            stm = connection.prepareStatement(sqlQuery);
                            stm.setString(1, doc.getTipo());
                            stm.setString(2, doc.getFile());
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, 3, contenuto);
                            stm.setTimestamp(4, new Timestamp(doc.getOraRegistrazione().getTime()));
                            stm.setLong(5, idDocumento);
                            stm.executeUpdate();
                            stm.close();
                            continue;
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("documenti");
                        sqlQueryObject.addInsertField("ruolo", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        if (contenuto != null) {
                            sqlQueryObject.addInsertField("contenuto", "?");
                        }
                        if (doc.getOraRegistrazione() != null) {
                            sqlQueryObject.addInsertField("ora_registrazione", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        int index = 6;
                        if (contenuto != null) {
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, index, contenuto);
                            ++index;
                        }
                        if (doc.getOraRegistrazione() != null) {
                            stm.setTimestamp(index, new Timestamp(doc.getOraRegistrazione().getTime()));
                            ++index;
                        }
                        log.debug((Object)("CRUDConnettore UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString())));
                        int n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("documenti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("ruolo = ?");
                        sqlQueryObject.addWhereCondition("tipo = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, doc.getRuolo());
                        stm.setString(2, doc.getTipo());
                        stm.setString(3, doc.getFile());
                        stm.setLong(4, idProprietario);
                        stm.setString(5, tipologiaProprietarioDocumento.toString());
                        log.debug((Object)("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, doc.getRuolo(), doc.getTipo(), doc.getFile(), idProprietario, tipologiaProprietarioDocumento.toString())));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        }
                        documenti.get(i).setId(rs.getLong("id"));
                        rs.close();
                        stm.close();
                    }
                    if (oldLista.size() <= 0) break;
                    for (int j = 0; j < oldLista.size(); ++j) {
                        Documento old = oldLista.get(j);
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("documenti");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, old.getId());
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("documenti");
                    sqlQueryObject.addWhereCondition("id_proprietario=?");
                    sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idProprietario);
                    stm.setString(2, tipologiaProprietarioDocumento.toString());
                    stm.executeUpdate();
                    stm.close();
                    log.debug((Object)("CRUDConnettore DELETE : \n" + DBUtils.formatSQLString(sqlQuery, idProprietario)));
                }
            }
            Object var20_35 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                break block52;
            }
            catch (Exception e) {}
            break block52;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var20_36 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static List<Documento> getListaDocumenti(long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return DriverRegistroServiziDB_LIB.getListaDocumenti(null, idProprietario, tipologiaProprietarioDocumento, readBytes, connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Documento> getListaDocumenti(String ruoloDocumenti, long idProprietario, ProprietariDocumento tipologiaProprietarioDocumento, boolean readBytes, Connection connection) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<Documento> arrayList;
        Statement stm = null;
        ResultSet rs = null;
        if (idProprietario <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] id proprietario non definito");
        }
        try {
            try {
                ArrayList<Documento> documenti = new ArrayList<Documento>();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                if (ruoloDocumenti != null) {
                    sqlQueryObject.addWhereCondition("ruolo = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idProprietario);
                stm.setString(2, tipologiaProprietarioDocumento.toString());
                if (ruoloDocumenti != null) {
                    stm.setString(3, ruoloDocumenti);
                }
                rs = stm.executeQuery();
                while (rs.next()) {
                    Documento doc = DriverRegistroServiziDB_LIB.getDocumento(rs.getLong("id"), readBytes, connection);
                    documenti.add(doc);
                }
                if (documenti.size() <= 0) {
                    throw new DriverRegistroServiziNotFound("Documenti con ruolo[" + ruoloDocumenti + "] e idProprietario[" + idProprietario + "] non trovati");
                }
                arrayList = documenti;
                Object var13_14 = null;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] SQLException : " + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound dnf) {
                throw dnf;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getListaDocumenti] Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return arrayList;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return arrayList;
        stm.close();
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Documento getDocumento(long id, boolean readBytes, Connection connection) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Documento documento;
        Statement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] id non definito");
        }
        try {
            try {
                BytesJDBCAdapter jdbcAdapter = null;
                if (readBytes) {
                    jdbcAdapter = new BytesJDBCAdapter();
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectField("ruolo");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_proprietario");
                sqlQueryObject.addSelectField("tipo_proprietario");
                sqlQueryObject.addSelectField("ora_registrazione");
                sqlQueryObject.addSelectField("id");
                if (readBytes) {
                    sqlQueryObject.addSelectField("contenuto");
                }
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, id);
                rs = stm.executeQuery();
                Documento doc = null;
                if (rs.next()) {
                    doc = new Documento();
                    doc.setRuolo(rs.getString("ruolo"));
                    doc.setTipo(rs.getString("tipo"));
                    doc.setFile(rs.getString("nome"));
                    doc.setIdProprietarioDocumento(rs.getLong("id_proprietario"));
                    doc.setTipoProprietarioDocumento(rs.getString("tipo_proprietario"));
                    doc.setOraRegistrazione(rs.getTimestamp("ora_registrazione"));
                    doc.setId(rs.getLong("id"));
                    if (readBytes) {
                        doc.setByteContenuto(jdbcAdapter.getBinaryData(rs, 8));
                    }
                }
                if (doc == null) {
                    throw new DriverRegistroServiziNotFound("Documento con id[" + id + "] non trovato");
                }
                documento = doc;
                Object var12_13 = null;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] SQLException : " + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound dnf) {
                throw dnf;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::getDocumento] Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return documento;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return documento;
        stm.close();
        return documento;
    }

    /*
     * Loose catch block
     */
    public static void CRUDAccordoServizioServizioComposto(int type, AccordoServizioServizioComposto asServComposto, Connection con, long idAccordo) throws DriverRegistroServiziException {
        block43: {
            Statement updateStmt = null;
            Statement selectStmt = null;
            ResultSet selectRS = null;
            if (idAccordo <= 0L) {
                new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID Accordo non valido.");
            }
            if (asServComposto == null && (type == 1 || type == 2)) {
                new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Accordo Cooperazione non valido.");
            }
            if (asServComposto != null && asServComposto.getIdAccordoCooperazione() <= 0L && (type == 1 || type == 2)) {
                new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID Accordo Cooperazione non valido.");
            }
            switch (type) {
                case 1: {
                    long idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    if (asServComposto.getNomeAccordoCooperazione() != null) {
                        idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(IDAccordoCooperazione.getIDAccordoFromUri(asServComposto.getNomeAccordoCooperazione()), con, tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("acc_serv_composti");
                    sqlQueryObject.addInsertField("id_accordo", "?");
                    sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    updateStmt.setLong(2, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)"Aggiungo acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addFromTable("acc_serv_composti");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_accordo=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLQuery();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordo);
                    selectRS = updateStmt.executeQuery();
                    long idAccServComposto = -1L;
                    if (!selectRS.next()) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto inserito non recuperato.");
                    }
                    idAccServComposto = selectRS.getLong("id");
                    asServComposto.setId(idAccServComposto);
                    selectRS.close();
                    updateStmt.close();
                    for (int i = 0; i < asServComposto.sizeServizioComponenteList(); ++i) {
                        AccordoServizioServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            log.debug((Object)("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]"));
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)"Aggiunto acc servizio componente");
                    }
                    break;
                }
                case 2: {
                    long idAccServComposto = asServComposto.getId();
                    if (idAccServComposto <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito.");
                    }
                    long idAccordoCooperazione = asServComposto.getIdAccordoCooperazione();
                    if (asServComposto.getNomeAccordoCooperazione() != null) {
                        idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(IDAccordoCooperazione.getIDAccordoFromUri(asServComposto.getNomeAccordoCooperazione()), con, tipoDB);
                    }
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] idAccordoCooperazione non fornito");
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("acc_serv_composti");
                    sqlQueryObject.addUpdateField("id_accordo_cooperazione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoCooperazione);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)"Aggiornato acc servizio composto");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    for (int i = 0; i < asServComposto.sizeServizioComponenteList(); ++i) {
                        AccordoServizioServizioCompostoServizioComponente tmp = asServComposto.getServizioComponente(i);
                        long idServizioComponente = -1L;
                        if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                            log.debug((Object)("Provo a recuperare l'id del servizio con tipo/nome soggetto erogatore [" + tmp.getTipoSoggetto() + "/" + tmp.getNomeSoggetto() + "] e tipo/nome servizio [" + tmp.getTipo() + "/" + tmp.getNome() + "]"));
                            if (tmp.getTipoSoggetto() != null && tmp.getNomeSoggetto() != null && tmp.getTipo() != null && tmp.getNome() != null) {
                                idServizioComponente = DBUtils.getIdServizio(tmp.getNome(), tmp.getTipo(), tmp.getNomeSoggetto(), tmp.getTipoSoggetto(), con, tipoDB);
                            }
                        }
                        if (idServizioComponente <= 0L) {
                            idServizioComponente = tmp.getIdServizioComponente();
                        }
                        if (idServizioComponente <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID ServizioComponente non definito.");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("acc_serv_componenti");
                        sqlQueryObject.addInsertField("id_servizio_composto", "?");
                        sqlQueryObject.addInsertField("id_servizio_componente", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccServComposto);
                        updateStmt.setLong(2, idServizioComponente);
                        updateStmt.setString(3, tmp.getAzione());
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)"Aggiungo acc servizio componente");
                    }
                    break;
                }
                case 3: {
                    String updateQuery;
                    ISQLQueryObject sqlQueryObject;
                    long idAccServComposto = -1L;
                    if (asServComposto != null) {
                        idAccServComposto = asServComposto.getId();
                        if (idAccServComposto <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] ID AccordoServizioComposto non definito.");
                        }
                    } else {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("acc_serv_composti");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_accordo=?");
                        updateQuery = sqlQueryObject.createSQLQuery();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordo);
                        selectRS = updateStmt.executeQuery();
                        if (selectRS.next()) {
                            idAccServComposto = selectRS.getLong("id");
                        }
                        selectRS.close();
                        updateStmt.close();
                    }
                    if (idAccServComposto <= 0L) break;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_componenti");
                    sqlQueryObject.addWhereCondition("id_servizio_composto=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("acc_serv_composti");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccServComposto);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
            Object var19_26 = null;
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
                break block43;
            }
            catch (Exception e) {}
            break block43;
            {
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] SQLException : " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoServizioServizioComposto] Exception : " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                Object var19_27 = null;
                try {
                    if (selectRS != null) {
                        selectRS.close();
                    }
                    if (selectStmt != null) {
                        selectStmt.close();
                    }
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void CRUDAccordoCooperazione(int type, AccordoCooperazione accordoCooperazione, Connection con) throws DriverRegistroServiziException {
        block62: {
            if (accordoCooperazione == null) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Accordo di Cooperazione non valido.");
            }
            String nome = accordoCooperazione.getNome();
            String descrizione = accordoCooperazione.getDescrizione();
            String firma = accordoCooperazione.getByteFirma() != null ? new String(accordoCooperazione.getByteFirma()) : null;
            firma = firma != null && !"".equals(firma.trim().replaceAll("\n", "")) ? firma : null;
            String stato = accordoCooperazione.getStatoPackage();
            boolean privato = accordoCooperazione.getPrivato();
            String superUser = accordoCooperazione.getSuperUser();
            if (nome == null || nome.equals("")) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Parametro Nome non valido.");
            }
            Statement updateStmt = null;
            ResultSet updateRS = null;
            switch (type) {
                case 1: {
                    int i;
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("accordi_cooperazione");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("versione", "?");
                    sqlQueryObject.addInsertField("firma", "?");
                    sqlQueryObject.addInsertField("privato", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (stato != null) {
                        sqlQueryObject.addInsertField("stato", "?");
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        sqlQueryObject.addInsertField("id_referente", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addInsertField("data_pubblicazione", "?");
                    String updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    if (accordoCooperazione.getVersione() != null && !"".equals(accordoCooperazione.getVersione())) {
                        updateStmt.setString(3, accordoCooperazione.getVersione());
                    } else {
                        updateStmt.setString(3, "");
                    }
                    updateStmt.setString(4, firma);
                    if (privato) {
                        updateStmt.setInt(5, 1);
                    } else {
                        updateStmt.setInt(5, 0);
                    }
                    updateStmt.setString(6, superUser);
                    int index = 7;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idReferente = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, tipoDB);
                        if (idReferente <= 0L) {
                            throw new DriverRegistroServiziException("Soggetto Referente [" + accordoCooperazione.getSoggettoReferente().getTipo() + "/" + accordoCooperazione.getSoggettoReferente().getNome() + "] non trovato");
                        }
                        updateStmt.setLong(index, idReferente);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    if (accordoCooperazione.getDataPubblicazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getDataPubblicazione().getTime()));
                    } else {
                        updateStmt.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
                    }
                    ++index;
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDServizio CREATE : \n" + DriverRegistroServiziDB_LIB.formatSQLString(updateQuery, nome, descrizione)));
                    log.debug((Object)("CRUDServizio type = " + type + " row affected =" + n));
                    IDAccordoCooperazione idAccordoObject = IDAccordoCooperazione.getIDAccordoFromValues(accordoCooperazione.getNome(), accordoCooperazione.getVersione());
                    long idAccordoCooperazione = DBUtils.getIdAccordoCooperazione(idAccordoObject, con, tipoDB);
                    if (idAccordoCooperazione <= 0L) {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] non riesco a trovare l'id del'Accordo inserito");
                    }
                    accordoCooperazione.setId(idAccordoCooperazione);
                    for (int i2 = 0; i2 < accordoCooperazione.sizeElencoPartecipantiList(); ++i2) {
                        AccordoCooperazioneElencoPartecipantiSoggetto soggettoPartecipante = accordoCooperazione.getElencoPartecipanti(i2);
                        long idSoggettoPartecipante = -1L;
                        if (idSoggettoPartecipante <= 0L) {
                            log.debug((Object)("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]"));
                            if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, tipoDB);
                            }
                        }
                        if (idSoggettoPartecipante <= 0L) {
                            idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                        }
                        if (idSoggettoPartecipante <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                        sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordoCooperazione);
                        updateStmt.setLong(2, idSoggettoPartecipante);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n));
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        Documento doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < accordoCooperazione.sizeSpecificaSemiformaleList(); ++i) {
                        Documento doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idAccordoCooperazione, ProprietariDocumento.accordoCooperazione, con);
                    break;
                }
                case 2: {
                    Documento doc;
                    int i;
                    IDAccordoCooperazione idAccordoAttualeInseritoDB = null;
                    idAccordoAttualeInseritoDB = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
                    long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordoAttualeInseritoDB, con, tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("accordi_cooperazione");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("versione", "?");
                    sqlQueryObject.addUpdateField("firma", "?");
                    sqlQueryObject.addUpdateField("privato", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("id_referente", "?");
                    if (stato != null) {
                        sqlQueryObject.addUpdateField("stato", "?");
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addUpdateField("data_pubblicazione", "?");
                    sqlQueryObject.addWhereCondition("id=?");
                    String updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, nome);
                    updateStmt.setString(2, descrizione);
                    if (accordoCooperazione.getVersione() != null && !"".equals(accordoCooperazione.getVersione())) {
                        updateStmt.setString(3, accordoCooperazione.getVersione());
                    } else {
                        updateStmt.setString(3, "");
                    }
                    updateStmt.setString(4, firma);
                    if (privato) {
                        updateStmt.setInt(5, 1);
                    } else {
                        updateStmt.setInt(5, 0);
                    }
                    updateStmt.setString(6, superUser);
                    int index = 7;
                    if (accordoCooperazione.getSoggettoReferente() != null) {
                        long idSRef = DBUtils.getIdSoggetto(accordoCooperazione.getSoggettoReferente().getNome(), accordoCooperazione.getSoggettoReferente().getTipo(), con, tipoDB);
                        updateStmt.setLong(index, idSRef);
                    } else {
                        updateStmt.setLong(index, 0L);
                    }
                    ++index;
                    if (stato != null) {
                        updateStmt.setString(index, stato);
                        ++index;
                    }
                    if (accordoCooperazione.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getOraRegistrazione().getTime()));
                        ++index;
                    }
                    if (accordoCooperazione.getDataPubblicazione() != null) {
                        updateStmt.setTimestamp(index, new Timestamp(accordoCooperazione.getDataPubblicazione().getTime()));
                    } else {
                        updateStmt.setTimestamp(index, new Timestamp(System.currentTimeMillis()));
                    }
                    updateStmt.setLong(++index, idAccordoLong);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("CRUDAccordoCooperazione type = " + type + " row affected =" + n));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    for (i = 0; i < accordoCooperazione.sizeElencoPartecipantiList(); ++i) {
                        AccordoCooperazioneElencoPartecipantiSoggetto soggettoPartecipante = accordoCooperazione.getElencoPartecipanti(i);
                        Long idSoggettoPartecipante = -1L;
                        if (idSoggettoPartecipante == null || idSoggettoPartecipante <= 0L) {
                            log.debug((Object)("Provo a recuperare l'id del soggetto con tipo/nome [" + soggettoPartecipante.getTipo() + "]/[" + soggettoPartecipante.getNome() + "]"));
                            if (soggettoPartecipante.getTipo() != null && soggettoPartecipante.getNome() != null) {
                                idSoggettoPartecipante = DBUtils.getIdSoggetto(soggettoPartecipante.getNome(), soggettoPartecipante.getTipo(), con, tipoDB);
                            }
                        }
                        if (idSoggettoPartecipante <= 0L) {
                            idSoggettoPartecipante = soggettoPartecipante.getIdSoggetto();
                        }
                        if (idSoggettoPartecipante <= 0L) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::CRUDAccordoCooperazione] idSoggettoPartecipante non presente");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("accordi_coop_partecipanti");
                        sqlQueryObject.addInsertField("id_accordo_cooperazione", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idAccordoLong);
                        updateStmt.setLong(2, idSoggettoPartecipante);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDAccordoCooperazione (servizioComposto) type = " + type + " row affected =" + n));
                    }
                    ArrayList<Documento> documenti = new ArrayList<Documento>();
                    for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
                        doc = accordoCooperazione.getAllegato(i);
                        doc.setRuolo(RuoliDocumento.allegato.toString());
                        documenti.add(doc);
                    }
                    for (i = 0; i < accordoCooperazione.sizeSpecificaSemiformaleList(); ++i) {
                        doc = accordoCooperazione.getSpecificaSemiformale(i);
                        doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                        documenti.add(doc);
                    }
                    DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoCooperazione, con);
                    break;
                }
                case 3: {
                    IDAccordoCooperazione idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(nome, accordoCooperazione.getVersione());
                    long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, con, tipoDB);
                    if (idAccordoLong <= 0L) {
                        throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Cooperazione : " + nome);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
                    sqlQueryObject.addWhereCondition("id_accordo_cooperazione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoCooperazione, con);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("accordi_cooperazione");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, idAccordoLong);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                }
            }
            Object var26_44 = null;
            try {
                if (updateRS != null) {
                    updateRS.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
                break block62;
            }
            catch (Exception ex) {}
            break block62;
            {
                catch (DriverException e) {
                    throw new DriverRegistroServiziException(e);
                }
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] SQLException [" + se.getMessage() + "].", se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB_LIB::CRUDAccordoCooperazione] Exception [" + se.getMessage() + "].", se);
                }
            }
            catch (Throwable throwable) {
                Object var26_45 = null;
                try {
                    if (updateRS != null) {
                        updateRS.close();
                    }
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

