/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import it.gov.spcoop.sica.manifest.driver.TipiDocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSicurezza;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.RuoliDocumento;

public abstract class BeanUtilities
implements IDriverRegistroServiziGet {
    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        return this.verificaAccordoCooperazione(idAccordo, accordoCooperazione, true);
    }

    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione, boolean checkID) throws DriverRegistroServiziException {
        AccordoCooperazione beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getAccordoCooperazione(idAccordo, true) : this.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return accordoCooperazione == null;
        }
        if (accordoCooperazione == null) {
            return false;
        }
        return beanRegistro.equals(accordoCooperazione, checkID);
    }

    public boolean verificaAccordo(IDAccordo idAccordo, AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        return this.verificaAccordo(idAccordo, accordoServizio, true);
    }

    public boolean verificaAccordo(IDAccordo idAccordo, AccordoServizio accordoServizio, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizio beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getAccordoServizio(idAccordo, true) : this.getAccordoServizio(idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return accordoServizio == null;
        }
        if (accordoServizio == null) {
            return false;
        }
        return beanRegistro.equals(accordoServizio, checkID);
    }

    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd) throws DriverRegistroServiziException {
        return this.verificaPortaDominio(nomePdd, pdd, true);
    }

    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd, boolean checkID) throws DriverRegistroServiziException {
        PortaDominio beanRegistro = null;
        try {
            beanRegistro = this.getPortaDominio(nomePdd);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return pdd == null;
        }
        if (pdd == null) {
            return false;
        }
        return beanRegistro.equals(pdd, checkID);
    }

    public boolean verificaSoggetto(IDSoggetto idSoggetto, SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        return this.verificaSoggetto(idSoggetto, soggetto, true);
    }

    public boolean verificaSoggetto(IDSoggetto idSoggetto, SoggettoSpcoop soggetto, boolean checkID) throws DriverRegistroServiziException {
        SoggettoSpcoop beanRegistro = null;
        try {
            beanRegistro = this.getSoggettoRegistro(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return soggetto == null;
        }
        if (soggetto == null) {
            return false;
        }
        return beanRegistro.equals(soggetto, checkID);
    }

    public boolean verificaServizio(IDServizio idService, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizio(idService, servizio, true);
    }

    public boolean verificaServizio(IDServizio idService, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizio(idService, true) : this.getServizio(idService);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    public boolean verificaServizioCorrelato(IDServizio idService, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizioCorrelato(idService, servizio, true);
    }

    public boolean verificaServizioCorrelato(IDServizio idService, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizioCorrelato(idService, true) : this.getServizioCorrelato(idService);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    public boolean verificaServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, ServizioSpcoop servizio) throws DriverRegistroServiziException {
        return this.verificaServizioCorrelato(idSoggetto, idAccordo, servizio, true);
    }

    public boolean verificaServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, ServizioSpcoop servizio, boolean checkID) throws DriverRegistroServiziException {
        ServizioSpcoop beanRegistro = null;
        try {
            beanRegistro = this instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)this).getServizioCorrelato(idSoggetto, idAccordo, true) : this.getServizioCorrelato(idSoggetto, idAccordo);
        }
        catch (DriverRegistroServiziNotFound dNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return servizio == null;
        }
        if (servizio == null) {
            return false;
        }
        return beanRegistro.equals(servizio, checkID);
    }

    public static IDSoggetto getSoggettoReferenteID(AccordoServizioSoggettoReferente ass) {
        if (ass != null && ass.getTipo() != null && ass.getNome() != null) {
            return new IDSoggetto(ass.getTipo(), ass.getNome());
        }
        return null;
    }

    public static IDSoggetto getSoggettoReferenteID(AccordoCooperazioneSoggettoReferente acs) {
        if (acs != null && acs.getTipo() != null && acs.getNome() != null) {
            return new IDSoggetto(acs.getTipo(), acs.getNome());
        }
        return null;
    }

    public static void validateTipoRuolo(String tipo, String ruolo) throws DriverRegistroServiziException {
        if (RuoliDocumento.allegato.toString().equals(ruolo)) {
            return;
        }
        if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo)) {
            if (!(TipiDocumentoSemiformale.HTML.toString().equals(tipo) || TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString().equals(tipo) || TipiDocumentoSemiformale.UML.toString().equals(tipo) || TipiDocumentoSemiformale.XML.toString().equals(tipo))) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSemiformale.HTML.toString() + "," + TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSemiformale.UML.toString() + "," + TipiDocumentoSemiformale.XML.toString());
            }
        } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo)) {
            if (!TipiDocumentoLivelloServizio.WSAGREEMENT.toString().equals(tipo) && !TipiDocumentoLivelloServizio.WSLA.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoLivelloServizio.WSAGREEMENT.toString() + "," + TipiDocumentoLivelloServizio.WSLA.toString());
            }
        } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo)) {
            if (!TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString().equals(tipo) && !TipiDocumentoSicurezza.WSPOLICY.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSicurezza.WSPOLICY.toString());
            }
        } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo)) {
            if (!TipiDocumentoCoordinamento.BPEL.toString().equals(tipo) && !TipiDocumentoCoordinamento.WSCDL.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoCoordinamento.BPEL.toString() + "," + TipiDocumentoCoordinamento.WSCDL.toString());
            }
        } else {
            throw new DriverRegistroServiziException("Ruolo non conosciuto");
        }
    }
}

