/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.config.driver;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DBUtils;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.Identificazione;
import org.openspcoop.dao.commons.TipiConnettore;
import org.openspcoop.dao.commons.TipologiaErogazione;
import org.openspcoop.dao.commons.TipologiaFruizione;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.config.AccessoRegistroRegistro;
import org.openspcoop.dao.config.Configurazione;
import org.openspcoop.dao.config.Connettore;
import org.openspcoop.dao.config.ConnettoreProperty;
import org.openspcoop.dao.config.CorrelazioneApplicativa;
import org.openspcoop.dao.config.CorrelazioneApplicativaElemento;
import org.openspcoop.dao.config.Credenziali;
import org.openspcoop.dao.config.GestioneErrore;
import org.openspcoop.dao.config.GestioneErroreCodiceTrasporto;
import org.openspcoop.dao.config.GestioneErroreSoapFault;
import org.openspcoop.dao.config.InvocazionePorta;
import org.openspcoop.dao.config.InvocazionePortaGestioneErrore;
import org.openspcoop.dao.config.InvocazioneServizio;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaApplicativaAzione;
import org.openspcoop.dao.config.PortaApplicativaServizio;
import org.openspcoop.dao.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.PortaDelegataAzione;
import org.openspcoop.dao.config.PortaDelegataServizio;
import org.openspcoop.dao.config.PortaDelegataSoggettoSpcoopErogatore;
import org.openspcoop.dao.config.RispostaAsincrona;
import org.openspcoop.dao.config.Route;
import org.openspcoop.dao.config.RouteGateway;
import org.openspcoop.dao.config.RouteRegistro;
import org.openspcoop.dao.config.RoutingTable;
import org.openspcoop.dao.config.RoutingTableDestinazione;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SetSpcoopProperty;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.WsSecurity;
import org.openspcoop.dao.config.WsSecurityRequestFlowParameter;
import org.openspcoop.dao.config.WsSecurityResponseFlowParameter;
import org.openspcoop.dao.config.driver.DriverConfigurazioneException;
import org.openspcoop.dao.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_LIB {
    public static Logger log = Logger.getLogger((String)"DRIVER_DB_CONFIGURAZIONE");
    private static String tipoDB = null;
    private static String tabellaSoggetti = "soggetti";
    private static boolean initialize = false;

    public static void initStaticLogger(Logger aLog) {
        if (!initialize) {
            if (aLog != null) {
                log = aLog;
            }
            initialize = true;
        }
    }

    public static boolean isStaticLoggerInitialized() {
        return initialize;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    public static void setTabellaSoggetti(String tab) {
        tabellaSoggetti = tab;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDSoggetto(int type, SoggettoSpcoop soggetto, Connection con) throws DriverConfigurazioneException {
        block28: {
            block27: {
                if (soggetto == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro non valido.");
                }
                nome = soggetto.getNome();
                tipo = soggetto.getTipo();
                if (nome == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
                if (nome.equals("")) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
                }
                if (tipo == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
                if (tipo.equals("")) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
                }
                descrizione = soggetto.getDescrizione();
                identificativoPorta = soggetto.getIdentificativoPorta();
                router = soggetto.getRouter();
                updateStmt = null;
                selectStmt = null;
                updateQuery = "";
                selectQuery = "";
                selectRS = null;
                n = 0;
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable(DriverConfigurazioneDB_LIB.tabellaSoggetti);
                                sqlQueryObject.addInsertField("nome_soggetto", "?");
                                sqlQueryObject.addInsertField("descrizione", "?");
                                sqlQueryObject.addInsertField("identificativo_porta", "?");
                                sqlQueryObject.addInsertField("tipo_soggetto", "?");
                                sqlQueryObject.addInsertField("is_router", "?");
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, nome);
                                updateStmt.setString(2, descrizione);
                                updateStmt.setString(3, identificativoPorta);
                                updateStmt.setString(4, tipo);
                                updateStmt.setInt(5, router != false ? 1 : 0);
                                n = updateStmt.executeUpdate();
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto CREATE : \n" + DBUtils.formatSQLString(updateQuery, new Object[]{nome, descrizione, identificativoPorta, tipo, router})));
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable(DriverConfigurazioneDB_LIB.tabellaSoggetti);
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setString(1, nome);
                                break;
                            }
                            case 2: {
                                oldNomeSoggetto = soggetto.getOldNomeForUpdate();
                                oldTipoSoggetto = soggetto.getOldTipoForUpdate();
                                if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                                    oldNomeSoggetto = nome;
                                }
                                if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                                    oldTipoSoggetto = tipo;
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable(DriverConfigurazioneDB_LIB.tabellaSoggetti);
                                sqlQueryObject.addUpdateField("nome_soggetto", "?");
                                sqlQueryObject.addUpdateField("descrizione", "?");
                                sqlQueryObject.addUpdateField("identificativo_porta", "?");
                                sqlQueryObject.addUpdateField("tipo_soggetto", "?");
                                sqlQueryObject.addUpdateField("is_router", "?");
                                sqlQueryObject.addWhereCondition("nome_soggetto=?");
                                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, nome);
                                updateStmt.setString(2, descrizione);
                                updateStmt.setString(3, identificativoPorta);
                                updateStmt.setString(4, tipo);
                                updateStmt.setInt(5, router != false ? 1 : 0);
                                updateStmt.setString(6, oldNomeSoggetto);
                                updateStmt.setString(7, oldTipoSoggetto);
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto UPDATE : \n" + DBUtils.formatSQLString(updateQuery, new Object[]{nome, descrizione, identificativoPorta, tipo, router, soggetto.getId()})));
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                break;
                            }
                            case 3: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable(DriverConfigurazioneDB_LIB.tabellaSoggetti);
                                sqlQueryObject.addWhereCondition("nome_soggetto=?");
                                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, soggetto.getNome());
                                updateStmt.setString(2, soggetto.getTipo());
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto type = " + type + " row affected =" + n));
                                DriverConfigurazioneDB_LIB.log.debug((Object)("CRUDSoggetto DELETE : \n" + DBUtils.formatSQLString(updateQuery, new Object[]{soggetto.getNome(), soggetto.getTipo()})));
                                break;
                            }
                        }
                        if (type == 1 && (selectRS = selectStmt.executeQuery()).next()) {
                            soggetto.setId(selectRS.getLong("id"));
                            sqlQueryObject = soggetto.getId();
                            var18_21 = null;
                            break block27;
                        }
                        sqlQueryObject = n;
                        break block28;
                    }
                    catch (SQLException se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
                    }
                    catch (Exception se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Exception [" + se.getMessage() + "].", se);
                    }
                }
                catch (Throwable var17_27) {
                    var18_23 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var17_27;
                        updateStmt.close();
                        throw var17_27;
                    }
                    catch (Exception e) {
                        throw var17_27;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 1169->1208)] { 
lbl123:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl130:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var18_22 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDConnettore(int type, Connettore connettore, Connection connection) throws DriverConfigurazioneException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'oggetto Connettore non puo essere null");
        }
        if (type != 3) {
            if (connettore.getNome() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore]Il nome Connettore non puo essere null");
            if (connettore.getNome().trim().equals("")) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore]Il nome Connettore non puo essere null");
            }
        }
        String nomeConnettore = connettore.getNome();
        String endpointtype = connettore.getTipo();
        if (endpointtype == null || endpointtype.trim().equals("")) {
            endpointtype = TipiConnettore.DISABILITATO.getNome();
        }
        String url = null;
        boolean debug = false;
        String nome = null;
        String tipo = null;
        String utente = null;
        String password = null;
        String initcont = null;
        String urlpkg = null;
        String provurl = null;
        String connectionfactory = null;
        String sendas = null;
        boolean isAbilitato = false;
        String nomeProperty = null;
        String valoreProperty = null;
        for (int i = 0; i < connettore.sizePropertyList(); ++i) {
            nomeProperty = connettore.getProperty(i).getNome();
            valoreProperty = connettore.getProperty(i).getValore();
            if (valoreProperty != null && valoreProperty.equals("")) {
                valoreProperty = null;
            }
            if (nomeProperty.equals("debug") && "true".equals(valoreProperty)) {
                debug = true;
            }
            if (TipiConnettore.HTTP.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    url = valoreProperty;
                }
            } else if (TipiConnettore.JMS.getNome().equals(endpointtype)) {
                if (nomeProperty.equals("location")) {
                    nome = valoreProperty;
                } else if (nomeProperty.equals("tipo")) {
                    tipo = valoreProperty;
                } else if (nomeProperty.equals("user")) {
                    utente = valoreProperty;
                } else if (nomeProperty.equals("password")) {
                    password = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.initial")) {
                    initcont = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.factory.url.pkgs")) {
                    urlpkg = valoreProperty;
                } else if (nomeProperty.equals("context-java.naming.provider.url")) {
                    provurl = valoreProperty;
                } else if (nomeProperty.equals("connection-factory")) {
                    connectionfactory = valoreProperty;
                } else if (nomeProperty.equals("send-as")) {
                    sendas = valoreProperty;
                }
            }
            if (endpointtype.equalsIgnoreCase(TipiConnettore.DISABILITATO.getNome())) continue;
            isAbilitato = true;
        }
        try {
            try {
                long idConnettore = 0L;
                int n = 0;
                switch (type) {
                    case 1: {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("connettori");
                        sqlQueryObject.addInsertField("endpointtype", "?");
                        sqlQueryObject.addInsertField("url", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("tipo", "?");
                        sqlQueryObject.addInsertField("utente", "?");
                        sqlQueryObject.addInsertField("password", "?");
                        sqlQueryObject.addInsertField("initcont", "?");
                        sqlQueryObject.addInsertField("urlpkg", "?");
                        sqlQueryObject.addInsertField("provurl", "?");
                        sqlQueryObject.addInsertField("connection_factory", "?");
                        sqlQueryObject.addInsertField("send_as", "?");
                        sqlQueryObject.addInsertField("nome_connettore", "?");
                        sqlQueryObject.addInsertField("debug", "?");
                        String sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, endpointtype);
                        stm.setString(2, isAbilitato ? url : null);
                        stm.setString(3, isAbilitato ? nome : null);
                        stm.setString(4, isAbilitato ? tipo : null);
                        stm.setString(5, isAbilitato ? utente : null);
                        stm.setString(6, isAbilitato ? password : null);
                        stm.setString(7, isAbilitato ? initcont : null);
                        stm.setString(8, isAbilitato ? urlpkg : null);
                        stm.setString(9, isAbilitato ? provurl : null);
                        stm.setString(10, isAbilitato ? connectionfactory : null);
                        stm.setString(11, isAbilitato ? sendas : null);
                        stm.setString(12, nomeConnettore);
                        if (debug) {
                            stm.setInt(13, 1);
                        } else {
                            stm.setInt(13, 0);
                        }
                        log.debug((Object)("CRUDConnettore CREATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore)));
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("connettori");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("endpointtype = ?");
                        sqlQueryObject.addWhereCondition("nome_connettore = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, endpointtype);
                        stm.setString(2, nomeConnettore);
                        log.debug((Object)("Recupero idConnettore inserito : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, nomeConnettore)));
                        rs = stm.executeQuery();
                        if (!rs.next()) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Errore tentanto di effettuare la select dopo una create, non riesco a recuperare l'id!");
                        idConnettore = rs.getLong("id");
                        connettore.setId(idConnettore);
                        rs.close();
                        stm.close();
                        break;
                    }
                    case 2: {
                        idConnettore = connettore.getId();
                        if (idConnettore < 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di update.");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("connettori");
                        sqlQueryObject.addUpdateField("endpointtype", "?");
                        sqlQueryObject.addUpdateField("url", "?");
                        sqlQueryObject.addUpdateField("nome", "?");
                        sqlQueryObject.addUpdateField("tipo", "?");
                        sqlQueryObject.addUpdateField("utente", "?");
                        sqlQueryObject.addUpdateField("password", "?");
                        sqlQueryObject.addUpdateField("initcont", "?");
                        sqlQueryObject.addUpdateField("urlpkg", "?");
                        sqlQueryObject.addUpdateField("provurl", "?");
                        sqlQueryObject.addUpdateField("connection_factory", "?");
                        sqlQueryObject.addUpdateField("send_as", "?");
                        sqlQueryObject.addUpdateField("nome_connettore", "?");
                        sqlQueryObject.addUpdateField("debug", "?");
                        sqlQueryObject.addWhereCondition("id=?");
                        String sqlQuery = sqlQueryObject.createSQLUpdate();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setString(1, endpointtype);
                        stm.setString(2, url);
                        stm.setString(3, nome);
                        stm.setString(4, tipo);
                        stm.setString(5, utente);
                        stm.setString(6, password);
                        stm.setString(7, initcont);
                        stm.setString(8, urlpkg);
                        stm.setString(9, provurl);
                        stm.setString(10, connectionfactory);
                        stm.setString(11, sendas);
                        stm.setString(12, nomeConnettore);
                        if (debug) {
                            stm.setInt(13, 1);
                        } else {
                            stm.setInt(13, 0);
                        }
                        stm.setLong(14, idConnettore);
                        stm.executeUpdate();
                        log.debug((Object)("CRUDConnettore UPDATE : \n" + DBUtils.formatSQLString(sqlQuery, endpointtype, url, nome, tipo, utente, password, initcont, urlpkg, provurl, connectionfactory, sendas, nomeConnettore, idConnettore)));
                        break;
                    }
                    case 3: {
                        idConnettore = connettore.getId();
                        if (idConnettore < 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] L'id del connettore non puo essere 0 tentando di fare una operazione di delete.");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("connettori");
                        sqlQueryObject.addWhereCondition("id=?");
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, idConnettore);
                        stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("CRUDConnettore DELETE : \n" + DBUtils.formatSQLString(sqlQuery, idConnettore)));
                        break;
                    }
                }
                l = idConnettore;
                Object var28_31 = null;
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] SQLException : " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConnettore] Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var28_32 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDPortaDelegata(int type, PortaDelegata aPD, Connection con) throws DriverConfigurazioneException {
        long l;
        long idSoggettoProprietario;
        if (aPD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Porta Delegata non valida.");
        }
        String nomePorta = aPD.getNome();
        String nomeProprietario = aPD.getNomeSoggettoProprietario();
        String tipoProprietario = aPD.getTipoSoggettoProprietario();
        if (nomePorta == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome della Porta Delegata non valido.");
        if (nomePorta.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome della Porta Delegata non valido.");
        }
        if (nomeProprietario == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome proprietario Porta Delegata non valido.");
        if (nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Nome proprietario Porta Delegata non valido.");
        }
        if (tipoProprietario == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Tipo proprietario della Porta Delegata non valido.");
        if (tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] Tipo proprietario della Porta Delegata non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        String autenticazione = aPD.getAutenticazione();
        String autorizzazione = aPD.getAutorizzazione();
        String descrizione = aPD.getDescrizione();
        PortaDelegataAzione azione = aPD.getAzione();
        long idAzione = azione != null && azione.getId() != null ? azione.getId() : -1L;
        try {
            idSoggettoProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
        }
        catch (DriverException e1) {
            throw new DriverConfigurazioneException(e1);
        }
        long idPortaDelegata = -1L;
        String location = aPD.getLocation();
        PortaDelegataServizio servizio = aPD.getServizio();
        long idServizioPD = servizio != null && servizio.getId() != null ? servizio.getId() : -1L;
        PortaDelegataSoggettoSpcoopErogatore soggErogatore = aPD.getSoggettoSpcoopErogatore();
        long idSoggettoErogatore = soggErogatore != null && soggErogatore.getId() != null ? soggErogatore.getId() : -1L;
        WsSecurity ws_sec = aPD.getWsSecurity();
        String wsSecStatus = aPD.getStatoWSSecurity();
        CorrelazioneApplicativa corrApp = aPD.getCorrelazioneApplicativa();
        ServizioApplicativo servizioApplicativo = null;
        try {
            try {
                int n = 0;
                int i = 0;
                switch (type) {
                    case 1: {
                        String modeAzione;
                        String modeServizio;
                        String modeSoggettoErogatore;
                        String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                        String nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                        String patternErogatore = soggErogatore != null ? soggErogatore.getPattern() : null;
                        String string = modeSoggettoErogatore = soggErogatore != null ? soggErogatore.getIdentificazione() : null;
                        if (modeSoggettoErogatore == null || modeSoggettoErogatore.equals("")) {
                            modeSoggettoErogatore = Identificazione._static.toString();
                        }
                        switch (Identificazione.valueOf("_" + modeSoggettoErogatore)) {
                            case _contentBased: 
                            case _urlBased: {
                                if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                if (tipoSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                }
                                if (patternErogatore == null) throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                                if (patternErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                                }
                                nomeSoggErogatore = null;
                                break;
                            }
                            case _inputBased: {
                                if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                if (!tipoSoggErogatore.equals("")) break;
                                throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                            }
                            case _static: {
                                if (idSoggettoErogatore <= 0L) {
                                    if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                    if (tipoSoggErogatore.equals("")) {
                                        throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                    }
                                    if (nomeSoggErogatore == null) throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                    if (nomeSoggErogatore.equals("")) {
                                        throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                    }
                                }
                                patternErogatore = null;
                                break;
                            }
                        }
                        String tipoServizio = servizio != null ? servizio.getTipo() : null;
                        String nomeServizio = servizio != null ? servizio.getNome() : null;
                        String patternServizio = servizio != null ? servizio.getPattern() : null;
                        String string2 = modeServizio = servizio != null ? servizio.getIdentificazione() : null;
                        if (modeServizio == null || modeServizio.equals("")) {
                            modeServizio = Identificazione._static.toString();
                        }
                        switch (Identificazione.valueOf("_" + modeServizio)) {
                            case _contentBased: 
                            case _urlBased: {
                                if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                if (tipoServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                }
                                if (patternServizio == null) throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                                if (patternServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                                }
                                nomeServizio = null;
                                break;
                            }
                            case _inputBased: {
                                if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                if (!tipoServizio.equals("")) break;
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            case _static: {
                                if (idServizioPD <= 0L) {
                                    if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                    if (tipoServizio.equals("")) {
                                        throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                    }
                                    if (nomeServizio == null) throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                    if (nomeServizio.equals("")) {
                                        throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                    }
                                }
                                patternServizio = null;
                                break;
                            }
                        }
                        String nomeAzione = azione != null ? azione.getNome() : null;
                        String patternAzione = azione != null ? azione.getPattern() : null;
                        String string3 = modeAzione = azione != null ? azione.getIdentificazione() : null;
                        if (azione != null) {
                            if (modeAzione == null || modeAzione.equals("")) {
                                modeAzione = Identificazione._static.toString();
                            }
                            switch (Identificazione.valueOf("_" + modeAzione)) {
                                case _contentBased: 
                                case _urlBased: {
                                    if (patternAzione == null) throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                    if (patternAzione.equals("")) {
                                        throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                    }
                                    nomeAzione = null;
                                    break;
                                }
                                case _inputBased: {
                                    break;
                                }
                                case _static: {
                                    if (idAzione <= 0L) {
                                        if (nomeAzione == null) throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                        if (nomeAzione.equals("")) {
                                            throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                        }
                                    }
                                    patternAzione = null;
                                    break;
                                }
                            }
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("porte_delegate");
                        sqlQueryObject.addInsertField("nome_porta", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("location", "?");
                        sqlQueryObject.addInsertField("id_soggetto_erogatore", "?");
                        sqlQueryObject.addInsertField("tipo_soggetto_erogatore", "?");
                        sqlQueryObject.addInsertField("nome_soggetto_erogatore", "?");
                        sqlQueryObject.addInsertField("mode_soggetto_erogatore", "?");
                        sqlQueryObject.addInsertField("id_servizio", "?");
                        sqlQueryObject.addInsertField("tipo_servizio", "?");
                        sqlQueryObject.addInsertField("nome_servizio", "?");
                        sqlQueryObject.addInsertField("mode_servizio", "?");
                        sqlQueryObject.addInsertField("id_azione", "?");
                        sqlQueryObject.addInsertField("nome_azione", "?");
                        sqlQueryObject.addInsertField("mode_azione", "?");
                        sqlQueryObject.addInsertField("autenticazione", "?");
                        sqlQueryObject.addInsertField("autorizzazione", "?");
                        sqlQueryObject.addInsertField("ws_security", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                        sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                        sqlQueryObject.addInsertField("integrazione", "?");
                        sqlQueryObject.addInsertField("pattern_soggetto_erogatore", "?");
                        sqlQueryObject.addInsertField("pattern_servizio", "?");
                        sqlQueryObject.addInsertField("pattern_azione", "?");
                        sqlQueryObject.addInsertField("scadenza_correlazione_appl", "?");
                        sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                        sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                        sqlQueryObject.addInsertField("allega_body", "?");
                        sqlQueryObject.addInsertField("scarta_body", "?");
                        sqlQueryObject.addInsertField("gestione_manifest", "?");
                        sqlQueryObject.addInsertField("stateless", "?");
                        sqlQueryObject.addInsertField("id_accordo", "?");
                        sqlQueryObject.addInsertField("id_port_type", "?");
                        String sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setString(1, nomePorta);
                        stm.setString(2, descrizione);
                        stm.setString(3, location);
                        stm.setLong(4, idSoggettoErogatore);
                        stm.setString(5, tipoSoggErogatore);
                        stm.setString(6, nomeSoggErogatore);
                        stm.setString(7, modeSoggettoErogatore);
                        stm.setLong(8, idServizioPD);
                        stm.setString(9, tipoServizio);
                        stm.setString(10, nomeServizio);
                        stm.setString(11, modeServizio);
                        stm.setLong(12, idAzione);
                        stm.setString(13, nomeAzione);
                        stm.setString(14, modeAzione);
                        stm.setString(15, autenticazione);
                        stm.setString(16, autorizzazione);
                        stm.setString(17, wsSecStatus);
                        stm.setLong(18, idSoggettoProprietario);
                        stm.setString(19, aPD.getRicevutaAsincronaSimmetrica());
                        stm.setString(20, aPD.getRicevutaAsincronaAsimmetrica());
                        stm.setString(21, aPD.getIntegrazione());
                        stm.setString(22, patternErogatore);
                        stm.setString(23, patternServizio);
                        stm.setString(24, patternAzione);
                        stm.setString(25, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                        stm.setString(26, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getStato() : null);
                        stm.setString(27, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getTipo() : null);
                        stm.setString(28, aPD != null ? aPD.getAllegaBody() : null);
                        stm.setString(29, aPD != null ? aPD.getScartaBody() : null);
                        stm.setString(30, aPD != null ? aPD.getGestioneManifest() : null);
                        stm.setString(31, aPD != null ? aPD.getStateless() : null);
                        stm.setLong(32, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                        stm.setLong(33, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                        log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nomePorta, descrizione, location, idSoggettoErogatore, tipoSoggErogatore, nomeSoggErogatore, modeSoggettoErogatore, idServizioPD, tipoServizio, nomeServizio, modeServizio, idAzione, nomeAzione, modeAzione, autenticazione, autorizzazione, wsSecStatus, idSoggettoProprietario, aPD.getRicevutaAsincronaSimmetrica(), aPD.getRicevutaAsincronaAsimmetrica(), aPD.getIntegrazione(), patternErogatore, patternServizio, patternAzione, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getStato() : null, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getTipo() : null, aPD.getAllegaBody(), aPD.getScartaBody(), aPD.getGestioneManifest(), aPD.getStateless(), aPD.getIdAccordo(), aPD.getIdPortType())));
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Inserted " + n + " row(s)."));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("porte_delegate");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                        sqlQueryObject.addWhereCondition("nome_porta = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idSoggettoProprietario);
                        stm.setString(2, nomePorta);
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            rs.close();
                            stm.close();
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(CREATE)] Impossibile recuperare l'ID della PortaDelegata appena create.");
                        }
                        idPortaDelegata = rs.getLong("id");
                        aPD.setId(idPortaDelegata);
                        rs.close();
                        stm.close();
                        if (ws_sec != null && "abilitato".equals(wsSecStatus)) {
                            WsSecurityRequestFlowParameter reqParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_ws_request");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeRequestFlowList(); ++i) {
                                reqParam = ws_sec.getRequestFlow(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaDelegata));
                            WsSecurityResponseFlowParameter resParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_ws_response");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeResponseFlowList(); ++i) {
                                resParam = ws_sec.getResponseFlow(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaDelegata));
                        }
                        if (corrApp != null) {
                            CorrelazioneApplicativaElemento cae = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_correlazione");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome_elemento", "?");
                            sqlQueryObject.addInsertField("mode_correlazione", "?");
                            sqlQueryObject.addInsertField("pattern", "?");
                            sqlQueryObject.addInsertField("identificazione_fallita", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                                cae = corrApp.getElemento(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, cae.getNome());
                                stm.setString(3, cae.getIdentificazione());
                                if (cae.getPattern() != null) {
                                    stm.setString(4, cae.getPattern());
                                } else {
                                    stm.setString(4, "");
                                }
                                stm.setString(5, cae.getIdentificazioneFallita());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata));
                        }
                        servizioApplicativo = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("porte_delegate_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPD.sizeServizioApplicativoList(); ++i) {
                            servizioApplicativo = aPD.getServizioApplicativo(i);
                            String nomeSA = servizioApplicativo.getNome();
                            String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                            if (nomeSA == null) throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            if (nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null) throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            if (nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null) throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            if (tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DBUtils.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaDelegata);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Insererted " + i + " associazioni ServizioApplicativo<->PortaDelegata associati alla PortaDelegata[" + idPortaDelegata + "]"));
                        break;
                    }
                    case 2: {
                        String modeAzione;
                        String modeServizio;
                        String modeSoggettoErogatore;
                        String tipoSoggErogatore = soggErogatore != null ? soggErogatore.getTipo() : null;
                        String nomeSoggErogatore = soggErogatore != null ? soggErogatore.getNome() : null;
                        String patternErogatore = soggErogatore != null ? soggErogatore.getPattern() : null;
                        String string = modeSoggettoErogatore = soggErogatore != null ? soggErogatore.getIdentificazione() : null;
                        if (modeSoggettoErogatore == null || modeSoggettoErogatore.equals("")) {
                            modeSoggettoErogatore = Identificazione._static.toString();
                        }
                        switch (Identificazione.valueOf("_" + modeSoggettoErogatore)) {
                            case _contentBased: 
                            case _urlBased: {
                                if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                if (tipoSoggErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                }
                                if (patternErogatore == null) throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                                if (patternErogatore.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Soggetto Erogatore non impostato.");
                                }
                                nomeSoggErogatore = null;
                                break;
                            }
                            case _inputBased: {
                                if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                if (!tipoSoggErogatore.equals("")) break;
                                throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                            }
                            case _static: {
                                if (idSoggettoErogatore <= 0L) {
                                    if (tipoSoggErogatore == null) throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                    if (tipoSoggErogatore.equals("")) {
                                        throw new DriverConfigurazioneException("Tipo Soggetto Erogatore non impostato.");
                                    }
                                    if (nomeSoggErogatore == null) throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                    if (nomeSoggErogatore.equals("")) {
                                        throw new DriverConfigurazioneException("Nome Soggetto Erogatore non impostato.");
                                    }
                                }
                                patternErogatore = null;
                                break;
                            }
                        }
                        String tipoServizio = servizio != null ? servizio.getTipo() : null;
                        String nomeServizio = servizio != null ? servizio.getNome() : null;
                        String patternServizio = servizio != null ? servizio.getPattern() : null;
                        String string4 = modeServizio = servizio != null ? servizio.getIdentificazione() : null;
                        if (modeServizio == null || modeServizio.equals("")) {
                            modeServizio = Identificazione._static.toString();
                        }
                        switch (Identificazione.valueOf("_" + modeServizio)) {
                            case _contentBased: 
                            case _urlBased: {
                                if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                if (tipoServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                }
                                if (patternServizio == null) throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                                if (patternServizio.equals("")) {
                                    throw new DriverConfigurazioneException("Pattern Servizio non impostato.");
                                }
                                nomeServizio = null;
                                break;
                            }
                            case _inputBased: {
                                if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                if (!tipoServizio.equals("")) break;
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            case _static: {
                                if (idServizioPD <= 0L) {
                                    if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                    if (tipoServizio.equals("")) {
                                        throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                                    }
                                    if (nomeServizio == null) throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                    if (nomeServizio.equals("")) {
                                        throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                                    }
                                }
                                patternServizio = null;
                                break;
                            }
                        }
                        String nomeAzione = azione != null ? azione.getNome() : null;
                        String patternAzione = azione != null ? azione.getPattern() : null;
                        String string5 = modeAzione = azione != null ? azione.getIdentificazione() : null;
                        if (azione != null) {
                            if (modeAzione == null || modeAzione.equals("")) {
                                modeAzione = Identificazione._static.toString();
                            }
                            switch (Identificazione.valueOf("_" + modeAzione)) {
                                case _contentBased: 
                                case _urlBased: {
                                    if (patternAzione == null) throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                    if (patternAzione.equals("")) {
                                        throw new DriverConfigurazioneException("Pattern Azione non impostato.");
                                    }
                                    nomeAzione = null;
                                    break;
                                }
                                case _inputBased: {
                                    break;
                                }
                                case _static: {
                                    if (idAzione <= 0L) {
                                        if (nomeAzione == null) throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                        if (nomeAzione.equals("")) {
                                            throw new DriverConfigurazioneException("Nome Azione non impostato.");
                                        }
                                    }
                                    patternAzione = null;
                                    break;
                                }
                            }
                        }
                        String oldNomePD = aPD.getOldNomeForUpdate();
                        String oldNomeProprietario = aPD.getOldNomeSoggettoProprietarioForUpdate();
                        String oldTipoProprietario = aPD.getOldTipoSoggettoProprietarioForUpdate();
                        log.debug((Object)("OLD-PD[" + oldNomePD + "] PD[" + nomePorta + "] OLD-TIPOS[" + oldTipoProprietario + "] TIPOS[" + tipoProprietario + "] OLD-NOMES[" + oldNomeProprietario + "] NOMES[" + nomeProprietario + "]"));
                        if (oldNomePD == null || oldNomePD.equals("")) {
                            log.debug((Object)("old nomePD is null, assegno: " + nomePorta));
                            oldNomePD = nomePorta;
                        }
                        if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                            log.debug((Object)("oldNomeProprietario is null, assegno: " + nomeProprietario));
                            oldNomeProprietario = nomeProprietario;
                        }
                        if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                            log.debug((Object)("oldTipoProprietario is null, assegno: " + tipoProprietario));
                            oldTipoProprietario = tipoProprietario;
                        }
                        if ((idPortaDelegata = DBUtils.getIdPortaDelegata(oldNomePD, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti)) <= 0L) {
                            idPortaDelegata = DBUtils.getIdPortaDelegata(oldNomePD, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (idPortaDelegata <= 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(UPDATE)] id porta delegata non trovato nome[" + oldNomePD + "] tipoProprietario[" + oldTipoProprietario + "] nomeProprietario[" + oldNomeProprietario + "]");
                        }
                        aPD.setId(idPortaDelegata);
                        long oldIdSoggettoProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti);
                        if (oldIdSoggettoProprietario <= 0L) {
                            oldIdSoggettoProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (oldIdSoggettoProprietario <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario della Porta Delegata");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("porte_delegate");
                        sqlQueryObject.addUpdateField("nome_porta", "?");
                        sqlQueryObject.addUpdateField("descrizione", "?");
                        sqlQueryObject.addUpdateField("location", "?");
                        sqlQueryObject.addUpdateField("id_soggetto_erogatore", "?");
                        sqlQueryObject.addUpdateField("tipo_soggetto_erogatore", "?");
                        sqlQueryObject.addUpdateField("nome_soggetto_erogatore", "?");
                        sqlQueryObject.addUpdateField("mode_soggetto_erogatore", "?");
                        sqlQueryObject.addUpdateField("id_servizio", "?");
                        sqlQueryObject.addUpdateField("tipo_servizio", "?");
                        sqlQueryObject.addUpdateField("nome_servizio", "?");
                        sqlQueryObject.addUpdateField("mode_servizio", "?");
                        sqlQueryObject.addUpdateField("id_azione", "?");
                        sqlQueryObject.addUpdateField("nome_azione", "?");
                        sqlQueryObject.addUpdateField("mode_azione", "?");
                        sqlQueryObject.addUpdateField("autenticazione", "?");
                        sqlQueryObject.addUpdateField("autorizzazione", "?");
                        sqlQueryObject.addUpdateField("ws_security", "?");
                        sqlQueryObject.addUpdateField("id_soggetto", "?");
                        sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                        sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                        sqlQueryObject.addUpdateField("integrazione", "?");
                        sqlQueryObject.addUpdateField("pattern_soggetto_erogatore", "?");
                        sqlQueryObject.addUpdateField("pattern_servizio", "?");
                        sqlQueryObject.addUpdateField("pattern_azione", "?");
                        sqlQueryObject.addUpdateField("scadenza_correlazione_appl", "?");
                        sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                        sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                        sqlQueryObject.addUpdateField("allega_body", "?");
                        sqlQueryObject.addUpdateField("scarta_body", "?");
                        sqlQueryObject.addUpdateField("gestione_manifest", "?");
                        sqlQueryObject.addUpdateField("stateless", "?");
                        sqlQueryObject.addUpdateField("id_accordo", "?");
                        sqlQueryObject.addUpdateField("id_port_type", "?");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQueryObject.addWhereCondition("id_soggetto=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        String sqlQuery = sqlQueryObject.createSQLUpdate();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setString(1, nomePorta);
                        stm.setString(2, descrizione);
                        stm.setString(3, location);
                        stm.setLong(4, idSoggettoErogatore);
                        stm.setString(5, tipoSoggErogatore);
                        stm.setString(6, nomeSoggErogatore);
                        stm.setString(7, modeSoggettoErogatore);
                        stm.setLong(8, idServizioPD);
                        stm.setString(9, tipoServizio);
                        stm.setString(10, nomeServizio);
                        stm.setString(11, modeServizio);
                        stm.setLong(12, idAzione);
                        stm.setString(13, nomeAzione);
                        stm.setString(14, modeAzione);
                        stm.setString(15, autenticazione);
                        stm.setString(16, autorizzazione);
                        stm.setString(17, wsSecStatus);
                        stm.setLong(18, idSoggettoProprietario);
                        stm.setString(19, aPD.getRicevutaAsincronaSimmetrica());
                        stm.setString(20, aPD.getRicevutaAsincronaAsimmetrica());
                        stm.setString(21, aPD.getIntegrazione());
                        stm.setString(22, patternErogatore);
                        stm.setString(23, patternServizio);
                        stm.setString(24, patternAzione);
                        stm.setString(25, aPD.getCorrelazioneApplicativa() != null ? aPD.getCorrelazioneApplicativa().getScadenza() : null);
                        stm.setString(26, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getStato() : null);
                        stm.setString(27, aPD.getValidazioneContenutiApplicativi() != null ? aPD.getValidazioneContenutiApplicativi().getTipo() : null);
                        stm.setString(28, aPD != null ? aPD.getAllegaBody() : null);
                        stm.setString(29, aPD != null ? aPD.getScartaBody() : null);
                        stm.setString(30, aPD != null ? aPD.getGestioneManifest() : null);
                        stm.setString(31, aPD != null ? aPD.getStateless() : null);
                        stm.setLong(32, aPD.getIdAccordo() != null ? aPD.getIdAccordo() : -1L);
                        stm.setLong(33, aPD.getIdPortType() != null ? aPD.getIdPortType() : -1L);
                        stm.setLong(34, idPortaDelegata);
                        stm.setLong(35, oldIdSoggettoProprietario);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Updated " + n + " row(s)."));
                        if (ws_sec != null && "abilitato".equals(wsSecStatus)) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_delegate_ws_request");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.executeUpdate();
                            stm.close();
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_delegate_ws_response");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.executeUpdate();
                            stm.close();
                            WsSecurityRequestFlowParameter reqParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_ws_request");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeRequestFlowList(); ++i) {
                                reqParam = ws_sec.getRequestFlow(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaDelegata));
                            WsSecurityResponseFlowParameter resParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_ws_response");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeResponseFlowList(); ++i) {
                                resParam = ws_sec.getResponseFlow(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaDelegata));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_correlazione");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        stm.executeUpdate();
                        stm.close();
                        if (corrApp != null) {
                            CorrelazioneApplicativaElemento cae = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_correlazione");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome_elemento", "?");
                            sqlQueryObject.addInsertField("mode_correlazione", "?");
                            sqlQueryObject.addInsertField("pattern", "?");
                            sqlQueryObject.addInsertField("identificazione_fallita", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < corrApp.sizeElementoList(); ++i) {
                                cae = corrApp.getElemento(i);
                                stm.setLong(1, idPortaDelegata);
                                stm.setString(2, cae.getNome());
                                stm.setString(3, cae.getIdentificazione());
                                if (cae.getPattern() != null) {
                                    stm.setString(4, cae.getPattern());
                                } else {
                                    stm.setString(4, "");
                                }
                                stm.setString(5, cae.getIdentificazioneFallita());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " correlazione applicativa con id=" + idPortaDelegata));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_sa");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Cancellati " + n + " servizi applicativi associati alla Porta Delegata " + idPortaDelegata));
                        n = 0;
                        for (i = 0; i < aPD.sizeServizioApplicativoList(); ++n, ++i) {
                            servizioApplicativo = aPD.getServizioApplicativo(i);
                            String nomeSA = servizioApplicativo.getNome();
                            String nomeProprietarioSA = aPD.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPD.getTipoSoggettoProprietario();
                            if (nomeSA == null) throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            if (nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null) throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            if (nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null) throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            if (tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DBUtils.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_delegate_sa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Aggiunta associazione PortaDelegata<->ServizioApplicativo [" + idPortaDelegata + "]<->[" + idSA + "]"));
                        }
                        log.debug((Object)("Aggiunti " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]"));
                        break;
                    }
                    case 3: {
                        String sqlQuery;
                        ISQLQueryObject sqlQueryObject;
                        idPortaDelegata = DBUtils.getIdPortaDelegata(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        if (idPortaDelegata <= 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata(DELETE)] Non e' stato possibile recuperare l'id della Porta Delegata, necessario per effettuare la DELETE.");
                        }
                        if ("abilitato".equals(wsSecStatus)) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_delegate_ws_request");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            n = stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaDelegata));
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_delegate_ws_response");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaDelegata);
                            n = stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaDelegata));
                        }
                        servizioApplicativo = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_sa");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Deleted " + n + " associazioni PortaDelegata<->ServizioApplicativo associati alla PortaDelegata[" + idPortaDelegata + "]"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_ws_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " ws_request flow associate alla PortaDelegata[" + idPortaDelegata + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_ws_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " ws_response flow associate alla PortaDelegata[" + idPortaDelegata + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_correlazione");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " correlazione associate alla PortaDelegata[" + idPortaDelegata + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaDelegata);
                        log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata)));
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Deleted " + n + " row(s)."));
                        break;
                    }
                }
                l = idPortaDelegata;
                Object var55_70 = null;
            }
            catch (DriverException e) {
                throw new DriverConfigurazioneException(e);
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaDelegata] SQLException : " + se.getMessage(), se);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaDelegata.", e);
            }
        }
        catch (Throwable throwable) {
            Object var55_71 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDServizioApplicativo(int type, ServizioApplicativo aSA, Connection con) throws DriverConfigurazioneException {
        long l;
        if (aSA == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Servizio Applicativo non valido.");
        }
        String nomeSA = aSA.getNome();
        String tipoProprietario = aSA.getTipoSoggettoProprietario();
        String nomeProprietario = aSA.getNomeSoggettoProprietario();
        if (nomeSA == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Servizio Applicativo non valido.");
        if (nomeSA.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Servizio Applicativo non valido.");
        }
        if (tipoProprietario == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Tipo Proprietario Servizio Applicativo non valido.");
        if (tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Tipo Proprietario Servizio Applicativo non valido.");
        }
        if (nomeProprietario == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Proprietario Servizio Applicativo non valido.");
        if (nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo] Nome Proprietario Servizio Applicativo non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        int n = 0;
        try {
            try {
                String descrizione = aSA.getDescrizione();
                log.debug((Object)("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "]"));
                long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                log.debug((Object)("get ID Soggetto con tipo[" + tipoProprietario + "] e nome[" + nomeProprietario + "] : " + idProprietario));
                InvocazionePorta invPorta = aSA.getInvocazionePorta();
                InvocazioneServizio invServizio = aSA.getInvocazioneServizio();
                RispostaAsincrona ricezione = aSA.getRispostaAsincrona();
                Connettore connettoreRisp = null;
                Connettore connettoreInv = null;
                long idConnettoreRisp = 0L;
                long idConnettoreInv = 0L;
                long idServizioApplicativo = 0L;
                Credenziali credenziali = null;
                InvocazionePortaGestioneErrore gestErr = null;
                String fault = null;
                switch (type) {
                    case 1: {
                        Connettore connettore;
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("servizi_applicativi");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("sbustamentorisp", "?");
                        sqlQueryObject.addInsertField("getmsgrisp", "?");
                        sqlQueryObject.addInsertField("tipoauthrisp", "?");
                        sqlQueryObject.addInsertField("utenterisp", "?");
                        sqlQueryObject.addInsertField("passwordrisp", "?");
                        sqlQueryObject.addInsertField("subjectrisp", "?");
                        sqlQueryObject.addInsertField("id_connettore_risp", "?");
                        sqlQueryObject.addInsertField("sbustamentoinv", "?");
                        sqlQueryObject.addInsertField("getmsginv", "?");
                        sqlQueryObject.addInsertField("tipoauthinv", "?");
                        sqlQueryObject.addInsertField("utenteinv", "?");
                        sqlQueryObject.addInsertField("passwordinv", "?");
                        sqlQueryObject.addInsertField("subjectinv", "?");
                        sqlQueryObject.addInsertField("id_connettore_inv", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        sqlQueryObject.addInsertField("fault", "?");
                        sqlQueryObject.addInsertField("tipoauth", "?");
                        sqlQueryObject.addInsertField("utente", "?");
                        sqlQueryObject.addInsertField("password", "?");
                        sqlQueryObject.addInsertField("subject", "?");
                        sqlQueryObject.addInsertField("invio_x_rif_inv", "?");
                        sqlQueryObject.addInsertField("risposta_x_rif_inv", "?");
                        sqlQueryObject.addInsertField("invio_x_rif", "?");
                        sqlQueryObject.addInsertField("invio_x_rif_risp", "?");
                        sqlQueryObject.addInsertField("risposta_x_rif_risp", "?");
                        sqlQueryObject.addInsertField("fault_actor", "?");
                        sqlQueryObject.addInsertField("generic_fault_code", "?");
                        sqlQueryObject.addInsertField("prefix_fault_code", "?");
                        sqlQueryObject.addInsertField("tipologia_fruizione", "?");
                        sqlQueryObject.addInsertField("tipologia_erogazione", "?");
                        String sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        connettoreRisp = new Connettore();
                        connettoreRisp.setNome("ConnettoreRISP_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                        connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                        idConnettoreRisp = DriverConfigurazioneDB_LIB.CRUDConnettore(1, connettoreRisp, con);
                        if (ricezione != null && ricezione.getConnettore() != null) {
                            connettore = ricezione.getConnettore();
                            connettore.setId(idConnettoreRisp);
                            connettore.setNome(connettoreRisp.getNome());
                            DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettore, con);
                        }
                        connettoreInv = new Connettore();
                        connettoreInv.setNome("ConnettoreINV_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario());
                        connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                        idConnettoreInv = DriverConfigurazioneDB_LIB.CRUDConnettore(1, connettoreInv, con);
                        if (invServizio != null && invServizio.getConnettore() != null) {
                            connettore = invServizio.getConnettore();
                            connettore.setId(idConnettoreInv);
                            connettore.setNome(connettoreInv.getNome());
                            DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettore, con);
                        }
                        stm.setString(1, nomeSA);
                        stm.setString(2, descrizione);
                        stm.setInt(3, ricezione != null && ricezione.getSbustamentoSoap() ? 1 : 0);
                        stm.setString(4, ricezione != null ? ricezione.getGetMessage() : null);
                        credenziali = ricezione != null ? ricezione.getCredenziali() : null;
                        stm.setString(5, ricezione != null ? ricezione.getAutenticazione() : null);
                        stm.setString(6, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(7, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(8, credenziali != null ? credenziali.getSubject() : null);
                        stm.setLong(9, idConnettoreRisp);
                        stm.setInt(10, invServizio != null && invServizio.getSbustamentoSoap() ? 1 : 0);
                        stm.setString(11, invServizio != null ? invServizio.getGetMessage() : null);
                        credenziali = invServizio != null ? invServizio.getCredenziali() : null;
                        stm.setString(12, invServizio != null ? invServizio.getAutenticazione() : null);
                        stm.setString(13, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(14, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(15, credenziali != null ? credenziali.getSubject() : null);
                        stm.setLong(16, idConnettoreInv);
                        stm.setLong(17, idProprietario);
                        gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                        fault = gestErr != null ? gestErr.getFault() : null;
                        stm.setString(18, fault);
                        credenziali = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                        stm.setString(19, credenziali != null ? credenziali.getTipo() : null);
                        stm.setString(20, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(21, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(22, credenziali != null ? credenziali.getSubject() : null);
                        stm.setString(23, invServizio != null ? invServizio.getInvioPerRiferimento() : null);
                        stm.setString(24, invServizio != null ? invServizio.getRispostaPerRiferimento() : null);
                        stm.setString(25, invPorta != null ? invPorta.getInvioPerRiferimento() : null);
                        stm.setString(26, ricezione != null ? ricezione.getInvioPerRiferimento() : null);
                        stm.setString(27, ricezione != null ? ricezione.getRispostaPerRiferimento() : null);
                        stm.setString(28, gestErr != null ? gestErr.getFaultActor() : null);
                        stm.setString(29, gestErr != null ? gestErr.getGenericFaultCode() : null);
                        stm.setString(30, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                        stm.setString(31, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                        stm.setString(32, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Inserted " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("servizi_applicativi");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                        sqlQueryObject.addWhereCondition("nome = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idProprietario);
                        stm.setString(2, nomeSA);
                        rs = stm.executeQuery();
                        if (!rs.next()) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(CREATE)] Impossibile trovare il servizio appena creato.");
                        idServizioApplicativo = rs.getLong("id");
                        aSA.setId(idServizioApplicativo);
                        rs.close();
                        stm.close();
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                            DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        }
                        if (aSA.getInvocazioneServizio() == null || aSA.getInvocazioneServizio().getGestioneErrore() == null) break;
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(1, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        break;
                    }
                    case 2: {
                        long oldIdProprietario;
                        String oldNomeSA = aSA.getOldNomeForUpdate();
                        String oldNomeProprietario = aSA.getOldNomeSoggettoProprietarioForUpdate();
                        String oldTipoProprietario = aSA.getOldTipoSoggettoProprietarioForUpdate();
                        if (oldNomeSA == null || oldNomeSA.equals("")) {
                            oldNomeSA = nomeSA;
                        }
                        if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                            oldNomeProprietario = nomeProprietario;
                        }
                        if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                            oldTipoProprietario = tipoProprietario;
                        }
                        if ((oldIdProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti)) <= 0L) {
                            oldIdProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (oldIdProprietario <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario del Servizio Applicativo");
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("servizi_applicativi");
                        sqlQueryObject.addUpdateField("descrizione", "?");
                        sqlQueryObject.addUpdateField("sbustamentorisp", "?");
                        sqlQueryObject.addUpdateField("getmsgrisp", "?");
                        sqlQueryObject.addUpdateField("tipoauthrisp", "?");
                        sqlQueryObject.addUpdateField("utenterisp", "?");
                        sqlQueryObject.addUpdateField("passwordrisp", "?");
                        sqlQueryObject.addUpdateField("subjectrisp", "?");
                        sqlQueryObject.addUpdateField("id_connettore_risp", "?");
                        sqlQueryObject.addUpdateField("sbustamentoinv", "?");
                        sqlQueryObject.addUpdateField("getmsginv", "?");
                        sqlQueryObject.addUpdateField("tipoauthinv", "?");
                        sqlQueryObject.addUpdateField("utenteinv", "?");
                        sqlQueryObject.addUpdateField("passwordinv", "?");
                        sqlQueryObject.addUpdateField("subjectinv", "?");
                        sqlQueryObject.addUpdateField("id_connettore_inv", "?");
                        sqlQueryObject.addUpdateField("fault", "?");
                        sqlQueryObject.addUpdateField("tipoauth", "?");
                        sqlQueryObject.addUpdateField("utente", "?");
                        sqlQueryObject.addUpdateField("password", "?");
                        sqlQueryObject.addUpdateField("subject", "?");
                        sqlQueryObject.addUpdateField("invio_x_rif_inv", "?");
                        sqlQueryObject.addUpdateField("risposta_x_rif_inv", "?");
                        sqlQueryObject.addUpdateField("invio_x_rif", "?");
                        sqlQueryObject.addUpdateField("invio_x_rif_risp", "?");
                        sqlQueryObject.addUpdateField("risposta_x_rif_risp", "?");
                        sqlQueryObject.addUpdateField("fault_actor", "?");
                        sqlQueryObject.addUpdateField("generic_fault_code", "?");
                        sqlQueryObject.addUpdateField("prefix_fault_code", "?");
                        sqlQueryObject.addUpdateField("nome", "?");
                        sqlQueryObject.addUpdateField("id_soggetto", "?");
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                            sqlQueryObject.addUpdateField("id_gestione_errore_risp", "?");
                        }
                        if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                            sqlQueryObject.addUpdateField("id_gestione_errore_inv", "?");
                        }
                        sqlQueryObject.addUpdateField("tipologia_fruizione", "?");
                        sqlQueryObject.addUpdateField("tipologia_erogazione", "?");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQueryObject.addWhereCondition("nome=?");
                        sqlQueryObject.addWhereCondition("id_soggetto=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        String sqlQuery = sqlQueryObject.createSQLUpdate();
                        stm = con.prepareStatement(sqlQuery);
                        idServizioApplicativo = DBUtils.getIdServizioApplicativo(oldNomeSA, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti);
                        if (idServizioApplicativo <= 0L) {
                            idServizioApplicativo = DBUtils.getIdServizioApplicativo(oldNomeSA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (idServizioApplicativo <= 0L) {
                            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDServizioApplicativo(UPDATE)] ID del ServizioApplicativo necessario per l'aggiornamento.");
                        }
                        RispostaAsincrona rispAsin = aSA.getRispostaAsincrona();
                        connettoreRisp = rispAsin != null ? rispAsin.getConnettore() : new Connettore();
                        String newNomeConnettoreRisp = "ConnettoreRISP_" + nomeSA + tipoProprietario + nomeProprietario;
                        idConnettoreRisp = DriverConfigurazioneDB_LIB.getIdConnettore_SA_RISP(idServizioApplicativo, con);
                        InvocazioneServizio invServ = aSA.getInvocazioneServizio();
                        connettoreInv = invServ != null ? invServizio.getConnettore() : new Connettore();
                        String newNomeConnettoreInv = "ConnettoreINV_" + nomeSA + tipoProprietario + nomeProprietario;
                        idConnettoreInv = DriverConfigurazioneDB_LIB.getIdConnettore_SA_INV(idServizioApplicativo, con);
                        if (idConnettoreInv <= 0L) throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                        if (idConnettoreRisp <= 0L) {
                            throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                        }
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                            DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        }
                        if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                            DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(2, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        }
                        String nomeConnettoreRisp = DriverConfigurazioneDB_LIB.getConnettore(idConnettoreRisp, con).getNome();
                        String nomeConnettoreInv = DriverConfigurazioneDB_LIB.getConnettore(idConnettoreInv, con).getNome();
                        String pattern = "Aggiorno Connettore [{0}] : id [{1}] oldNome [{2}] newNome [{2}]";
                        log.debug((Object)MessageFormat.format(pattern, "Risposta Asincrona", idConnettoreRisp, nomeConnettoreRisp, newNomeConnettoreRisp));
                        connettoreRisp.setNome(newNomeConnettoreRisp);
                        connettoreRisp.setId(idConnettoreRisp);
                        DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettoreRisp, con);
                        log.debug((Object)MessageFormat.format(pattern, "Invocazione Servizio", idConnettoreInv, nomeConnettoreInv, newNomeConnettoreInv));
                        connettoreInv.setNome(newNomeConnettoreInv);
                        connettoreInv.setId(idConnettoreInv);
                        DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettoreInv, con);
                        stm.setString(1, descrizione);
                        stm.setInt(2, ricezione != null && ricezione.getSbustamentoSoap() ? 1 : 0);
                        stm.setString(3, ricezione != null ? ricezione.getGetMessage() : null);
                        credenziali = ricezione != null ? ricezione.getCredenziali() : null;
                        stm.setString(4, credenziali != null ? credenziali.getTipo() : null);
                        stm.setString(5, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(6, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(7, credenziali != null ? credenziali.getSubject() : null);
                        stm.setLong(8, idConnettoreRisp);
                        stm.setInt(9, invServizio != null && invServizio.getSbustamentoSoap() ? 1 : 0);
                        stm.setString(10, invServizio != null ? invServizio.getGetMessage() : null);
                        credenziali = invServizio != null ? invServizio.getCredenziali() : null;
                        stm.setString(11, credenziali != null ? credenziali.getTipo() : null);
                        stm.setString(12, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(13, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(14, credenziali != null ? credenziali.getSubject() : null);
                        stm.setLong(15, idConnettoreInv);
                        gestErr = invPorta != null ? invPorta.getGestioneErrore() : null;
                        fault = gestErr != null ? gestErr.getFault() : null;
                        stm.setString(16, fault);
                        credenziali = invPorta != null && invPorta.sizeCredenzialiList() > 0 ? invPorta.getCredenziali(0) : null;
                        stm.setString(17, credenziali != null ? credenziali.getTipo() : null);
                        stm.setString(18, credenziali != null ? credenziali.getUser() : null);
                        stm.setString(19, credenziali != null ? credenziali.getPassword() : null);
                        stm.setString(20, credenziali != null ? credenziali.getSubject() : null);
                        stm.setString(21, invServizio != null ? invServizio.getInvioPerRiferimento() : null);
                        stm.setString(22, invServizio != null ? invServizio.getRispostaPerRiferimento() : null);
                        stm.setString(23, invPorta != null ? invPorta.getInvioPerRiferimento() : null);
                        stm.setString(24, ricezione != null ? ricezione.getInvioPerRiferimento() : null);
                        stm.setString(25, ricezione != null ? ricezione.getRispostaPerRiferimento() : null);
                        stm.setString(26, gestErr != null ? gestErr.getFaultActor() : null);
                        stm.setString(27, gestErr != null ? gestErr.getGenericFaultCode() : null);
                        stm.setString(28, gestErr != null ? gestErr.getPrefixFaultCode() : null);
                        stm.setString(29, nomeSA);
                        stm.setLong(30, idProprietario < 0L ? oldIdProprietario : idProprietario);
                        int indexP = 31;
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                            stm.setLong(indexP, aSA.getRispostaAsincrona().getGestioneErrore().getId());
                            ++indexP;
                        }
                        if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getGestioneErrore() != null) {
                            stm.setLong(indexP, aSA.getInvocazioneServizio().getGestioneErrore().getId());
                        }
                        int n2 = ++indexP;
                        ++indexP;
                        stm.setString(n2, aSA.getTipologiaFruizione() != null ? TipologiaFruizione.valueOf(aSA.getTipologiaFruizione().toUpperCase()).toString() : TipologiaFruizione.DISABILITATO.toString());
                        stm.setString(indexP++, aSA.getTipologiaErogazione() != null ? TipologiaErogazione.valueOf(aSA.getTipologiaErogazione().toUpperCase()).toString() : TipologiaErogazione.DISABILITATO.toString());
                        stm.setLong(indexP, idServizioApplicativo);
                        stm.setString(++indexP, oldNomeSA);
                        stm.setLong(++indexP, oldIdProprietario);
                        ++indexP;
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Updated " + n + " row(s)"));
                        break;
                    }
                    case 3: {
                        log.debug((Object)("get ID Servizio Applicativo con nome[" + nomeSA + "] tipoProprietario[" + tipoProprietario + "] nomeProprietario[" + nomeProprietario + "]"));
                        idServizioApplicativo = DBUtils.getIdServizioApplicativo(nomeSA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        log.debug((Object)("get ID Servizio Applicativo: " + idServizioApplicativo));
                        log.debug((Object)"Deleted PA associazioni...");
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_sa");
                        sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                        String sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idServizioApplicativo);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " associazioni di PortaApplicativa<->ServizioApplicativo associate al ServizioApplicativo[" + idServizioApplicativo + "]"));
                        }
                        log.debug((Object)"Deleted PD associazioni...");
                        log.debug((Object)"Deleted PA associazioni...");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_delegate_sa");
                        sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idServizioApplicativo);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " associazioni di PortaDelegata<->ServizioApplicativo associate al ServizioApplicativo[" + idServizioApplicativo + "]"));
                        }
                        log.debug((Object)"Deleted ...");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("servizi_applicativi");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQueryObject.addWhereCondition("nome=?");
                        sqlQueryObject.addWhereCondition("id_soggetto=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idServizioApplicativo);
                        stm.setString(2, nomeSA);
                        stm.setLong(3, idProprietario);
                        log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo, nomeSA, idProprietario)));
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Deleted " + n + " row(s)"));
                        log.debug((Object)"Recupero connettore asincrono ...");
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getConnettore() != null) {
                            connettoreRisp = aSA.getRispostaAsincrona().getConnettore();
                        } else {
                            connettoreRisp = new Connettore();
                            connettoreRisp.setTipo(TipiConnettore.DISABILITATO.getNome());
                        }
                        String nomeConnettoreRisp = "ConnettoreRISP_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                        connettoreRisp.setNome(nomeConnettoreRisp);
                        idConnettoreRisp = DBUtils.getIdConnettore(nomeConnettoreRisp, con, tipoDB);
                        log.debug((Object)("Recupero connettore asincrono id[" + idConnettoreRisp + "]"));
                        connettoreRisp.setId(idConnettoreRisp);
                        log.debug((Object)"Recupero connettore invocazione servizio ...");
                        if (aSA.getInvocazioneServizio() != null && aSA.getInvocazioneServizio().getConnettore() != null) {
                            connettoreInv = aSA.getInvocazioneServizio().getConnettore();
                        } else {
                            connettoreInv = new Connettore();
                            connettoreInv.setTipo(TipiConnettore.DISABILITATO.getNome());
                        }
                        String nomeConnettoreInv = "ConnettoreINV_" + aSA.getNome() + aSA.getTipoSoggettoProprietario() + aSA.getNomeSoggettoProprietario();
                        connettoreInv.setNome(nomeConnettoreInv);
                        idConnettoreInv = DBUtils.getIdConnettore(nomeConnettoreInv, con, tipoDB);
                        log.debug((Object)("Recupero connettore invocazione servizio id[" + idConnettoreInv + "]"));
                        connettoreInv.setId(idConnettoreInv);
                        if (idConnettoreInv <= 0L) throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                        if (idConnettoreRisp <= 0L) {
                            throw new DriverConfigurazioneException("I connettori del servizio applicativo sono invalidi");
                        }
                        log.debug((Object)"Delete connettore asincrono ...");
                        DriverConfigurazioneDB_LIB.CRUDConnettore(3, connettoreRisp, con);
                        log.debug((Object)"Delete connettore invocazione servizio ...");
                        DriverConfigurazioneDB_LIB.CRUDConnettore(3, connettoreInv, con);
                        if (aSA.getRispostaAsincrona() != null && aSA.getRispostaAsincrona().getGestioneErrore() != null) {
                            DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getRispostaAsincrona().getGestioneErrore(), idProprietario, idServizioApplicativo, false, con);
                        }
                        if (aSA.getInvocazioneServizio() == null || aSA.getInvocazioneServizio().getGestioneErrore() == null) break;
                        DriverConfigurazioneDB_LIB.CRUDGestioneErroreServizioApplicativo(3, aSA.getInvocazioneServizio().getGestioneErrore(), idProprietario, idServizioApplicativo, true, con);
                        break;
                    }
                }
                l = idServizioApplicativo;
                Object var42_45 = null;
            }
            catch (DriverException e) {
                throw new DriverConfigurazioneException(e);
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("SQLException : " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("Exception : " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var42_46 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDPortaApplicativa(int type, PortaApplicativa aPA, Connection con) throws DriverConfigurazioneException {
        long l;
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida.");
        }
        String nomePorta = aPA.getNome();
        String nomeProprietario = aPA.getNomeSoggettoProprietario();
        String tipoProprietario = aPA.getTipoSoggettoProprietario();
        if (nomePorta == null) throw new DriverConfigurazioneException("Nome della Porta Applicativa non valido.");
        if (nomePorta.equals("")) {
            throw new DriverConfigurazioneException("Nome della Porta Applicativa non valido.");
        }
        if (nomeProprietario == null) throw new DriverConfigurazioneException("Nome proprietario Porta Applicativa non valido.");
        if (nomeProprietario.equals("")) {
            throw new DriverConfigurazioneException("Nome proprietario Porta Applicativa non valido.");
        }
        if (tipoProprietario == null) throw new DriverConfigurazioneException("Tipo proprietario della Porta Applicativa non valido.");
        if (tipoProprietario.equals("")) {
            throw new DriverConfigurazioneException("Tipo proprietario della Porta Applicativa non valido.");
        }
        Statement stm = null;
        String sqlQuery = "";
        ResultSet rs = null;
        String descrizione = aPA.getDescrizione();
        PortaApplicativaAzione azione = aPA.getAzione();
        PortaApplicativaServizio servizio = aPA.getServizio();
        long idServizio = servizio != null && servizio.getId() != null ? servizio.getId() : -1L;
        PortaApplicativaSoggettoVirtuale soggVirt = aPA.getSoggettoVirtuale();
        String tipoSoggVirt = soggVirt != null ? soggVirt.getTipo() : null;
        String nomeSoggVirt = soggVirt != null ? soggVirt.getNome() : null;
        long idSoggVirt = -1L;
        try {
            idSoggVirt = DBUtils.getIdSoggetto(nomeSoggVirt, tipoSoggVirt, con, tipoDB, tabellaSoggetti);
        }
        catch (DriverException e1) {
            log.error((Object)e1);
        }
        SetSpcoopProperty proSpcoop = null;
        WsSecurity ws_sec = aPA.getWsSecurity();
        String wsSecStatus = aPA.getStatoWSSecurity();
        try {
            try {
                int n = 0;
                int i = 0;
                long idPortaApplicativa = 0L;
                ServizioApplicativo servizioApplicativo = null;
                long idProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                switch (type) {
                    case 1: {
                        String nomeServizio;
                        String tipoServizio = servizio != null ? servizio.getTipo() : null;
                        String string = nomeServizio = servizio != null ? servizio.getNome() : null;
                        if (idServizio <= 0L) {
                            if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            if (tipoServizio.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            if (nomeServizio == null) throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                            if (nomeServizio.equals("")) {
                                throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                            }
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative");
                        sqlQueryObject.addInsertField("nome_porta", "?");
                        sqlQueryObject.addInsertField("descrizione", "?");
                        sqlQueryObject.addInsertField("id_soggetto_virtuale", "?");
                        sqlQueryObject.addInsertField("tipo_soggetto_virtuale", "?");
                        sqlQueryObject.addInsertField("nome_soggetto_virtuale", "?");
                        sqlQueryObject.addInsertField("id_servizio", "?");
                        sqlQueryObject.addInsertField("tipo_servizio", "?");
                        sqlQueryObject.addInsertField("servizio", "?");
                        sqlQueryObject.addInsertField("azione", "?");
                        sqlQueryObject.addInsertField("ws_security", "?");
                        sqlQueryObject.addInsertField("id_soggetto", "?");
                        sqlQueryObject.addInsertField("ricevuta_asincrona_sim", "?");
                        sqlQueryObject.addInsertField("ricevuta_asincrona_asim", "?");
                        sqlQueryObject.addInsertField("integrazione", "?");
                        sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                        sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                        sqlQueryObject.addInsertField("allega_body", "?");
                        sqlQueryObject.addInsertField("scarta_body", "?");
                        sqlQueryObject.addInsertField("gestione_manifest", "?");
                        sqlQueryObject.addInsertField("stateless", "?");
                        sqlQueryObject.addInsertField("id_accordo", "?");
                        sqlQueryObject.addInsertField("id_port_type", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setString(1, nomePorta);
                        stm.setString(2, descrizione);
                        stm.setLong(3, idSoggVirt);
                        stm.setString(4, tipoSoggVirt);
                        stm.setString(5, nomeSoggVirt);
                        stm.setLong(6, idServizio);
                        stm.setString(7, tipoServizio);
                        stm.setString(8, nomeServizio);
                        stm.setString(9, azione != null ? azione.getNome() : null);
                        stm.setString(10, wsSecStatus);
                        stm.setLong(11, idProprietario);
                        stm.setString(12, aPA.getRicevutaAsincronaSimmetrica() != null ? aPA.getRicevutaAsincronaSimmetrica() : null);
                        stm.setString(13, aPA.getRicevutaAsincronaAsimmetrica() != null ? aPA.getRicevutaAsincronaAsimmetrica() : null);
                        stm.setString(14, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                        stm.setString(15, aPA.getValidazioneContenutiApplicativi() != null ? aPA.getValidazioneContenutiApplicativi().getStato() : null);
                        stm.setString(16, aPA.getValidazioneContenutiApplicativi() != null ? aPA.getValidazioneContenutiApplicativi().getTipo() : null);
                        stm.setString(17, aPA != null ? aPA.getAllegaBody() : null);
                        stm.setString(18, aPA != null ? aPA.getScartaBody() : null);
                        stm.setString(19, aPA != null ? aPA.getGestioneManifest() : null);
                        stm.setString(20, aPA != null ? aPA.getStateless() : null);
                        stm.setLong(21, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                        stm.setLong(22, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Created " + n + " row(s)"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addFromTable("porte_applicative");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                        sqlQueryObject.addWhereCondition("nome_porta = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idProprietario);
                        stm.setString(2, nomePorta);
                        rs = stm.executeQuery();
                        if (!rs.next()) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa(CREATE)] Impossibile recuperare l'ID della PortaApplicativa appena create.");
                        idPortaApplicativa = rs.getLong("id");
                        aPA.setId(idPortaApplicativa);
                        rs.close();
                        stm.close();
                        if (ws_sec != null && "abilitato".equals(wsSecStatus)) {
                            WsSecurityRequestFlowParameter reqParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_ws_request");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeRequestFlowList(); ++i) {
                                reqParam = ws_sec.getRequestFlow(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaApplicativa));
                            WsSecurityResponseFlowParameter resParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_ws_response");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeResponseFlowList(); ++i) {
                                resParam = ws_sec.getResponseFlow(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaApplicativa));
                        }
                        servizioApplicativo = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_sa");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.sizeServizioApplicativoList(); ++i) {
                            servizioApplicativo = aPA.getServizioApplicativo(i);
                            String nomeSA = servizioApplicativo.getNome();
                            String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                            if (nomeSA == null) throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome del ServizioApplicativo associato non valido.");
                            if (nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null) throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome Proprietario del ServizioApplicativo associato non valido.");
                            if (nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null) throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            if (tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)::Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DBUtils.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Insererted " + i + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addInsertTable("porte_applicative_prop");
                        sqlQueryObject.addInsertField("id_porta", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("valore", "?");
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = con.prepareStatement(sqlQuery);
                        for (i = 0; i < aPA.sizeSetSpcoopPropertyList(); ++i) {
                            proSpcoop = aPA.getSetSpcoopProperty(i);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, proSpcoop.getNome());
                            stm.setString(3, proSpcoop.getValore());
                            stm.executeUpdate();
                        }
                        stm.close();
                        log.debug((Object)("Insererted " + i + " SetSpcooProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        break;
                    }
                    case 2: {
                        String nomeServizio;
                        String oldNomePA = aPA.getOldNomeForUpdate();
                        String oldNomeProprietario = aPA.getOldNomeSoggettoProprietarioForUpdate();
                        String oldTipoProprietario = aPA.getOldTipoSoggettoProprietarioForUpdate();
                        if (oldNomePA == null || oldNomePA.equals("")) {
                            oldNomePA = nomePorta;
                        }
                        if (oldNomeProprietario == null || oldNomeProprietario.equals("")) {
                            oldNomeProprietario = nomeProprietario;
                        }
                        if (oldTipoProprietario == null || oldTipoProprietario.equals("")) {
                            oldTipoProprietario = tipoProprietario;
                        }
                        String tipoServizio = servizio != null ? servizio.getTipo() : null;
                        String string = nomeServizio = servizio != null ? servizio.getNome() : null;
                        if (idServizio <= 0L) {
                            if (tipoServizio == null) throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            if (tipoServizio.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Servizio non impostato.");
                            }
                            if (nomeServizio == null) throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                            if (nomeServizio.equals("")) {
                                throw new DriverConfigurazioneException("Nome Servizio non impostato.");
                            }
                        }
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addUpdateTable("porte_applicative");
                        sqlQueryObject.addUpdateField("descrizione", "?");
                        sqlQueryObject.addUpdateField("id_soggetto_virtuale", "?");
                        sqlQueryObject.addUpdateField("tipo_soggetto_virtuale", "?");
                        sqlQueryObject.addUpdateField("nome_soggetto_virtuale", "?");
                        sqlQueryObject.addUpdateField("id_servizio", "?");
                        sqlQueryObject.addUpdateField("tipo_servizio", "?");
                        sqlQueryObject.addUpdateField("servizio", "?");
                        sqlQueryObject.addUpdateField("azione", "?");
                        sqlQueryObject.addUpdateField("ws_security", "?");
                        sqlQueryObject.addUpdateField("nome_porta", "?");
                        sqlQueryObject.addUpdateField("ricevuta_asincrona_sim", "?");
                        sqlQueryObject.addUpdateField("ricevuta_asincrona_asim", "?");
                        sqlQueryObject.addUpdateField("integrazione", "?");
                        sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                        sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                        sqlQueryObject.addUpdateField("id_soggetto", "?");
                        sqlQueryObject.addUpdateField("allega_body", "?");
                        sqlQueryObject.addUpdateField("scarta_body", "?");
                        sqlQueryObject.addUpdateField("gestione_manifest", "?");
                        sqlQueryObject.addUpdateField("stateless", "?");
                        sqlQueryObject.addUpdateField("id_accordo", "?");
                        sqlQueryObject.addUpdateField("id_port_type", "?");
                        sqlQueryObject.addWhereCondition("id_soggetto=?");
                        sqlQueryObject.addWhereCondition("nome_porta=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLUpdate();
                        stm = con.prepareStatement(sqlQuery);
                        idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, oldTipoProprietario, oldNomeProprietario, con, tipoDB, tabellaSoggetti);
                        if (idPortaApplicativa <= 0L) {
                            idPortaApplicativa = DBUtils.getIdPortaApplicativa(oldNomePA, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (idPortaApplicativa <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id della Porta Applicativa nomePA[" + oldNomePA + "] (old[" + aPA.getOldNomeForUpdate() + "]) tipoProprietario[" + oldTipoProprietario + "] (old[" + aPA.getOldTipoSoggettoProprietarioForUpdate() + "]) nomeProprietario[" + oldNomeProprietario + "] (" + aPA.getOldNomeSoggettoProprietarioForUpdate() + ")");
                        }
                        long oldIdProprietario = DBUtils.getIdSoggetto(oldNomeProprietario, oldTipoProprietario, con, tipoDB, tabellaSoggetti);
                        if (oldIdProprietario <= 0L) {
                            oldIdProprietario = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
                        }
                        if (oldIdProprietario <= 0L) {
                            throw new DriverConfigurazioneException("Impossibile recuperare l'id del Soggetto Proprietario della Porta Applicativa");
                        }
                        stm.setString(1, descrizione);
                        stm.setLong(2, idSoggVirt);
                        stm.setString(3, tipoSoggVirt);
                        stm.setString(4, nomeSoggVirt);
                        stm.setLong(5, idServizio);
                        stm.setString(6, tipoServizio);
                        stm.setString(7, nomeServizio);
                        stm.setString(8, azione != null ? azione.getNome() : null);
                        stm.setString(9, wsSecStatus);
                        stm.setString(10, nomePorta);
                        stm.setString(11, aPA.getRicevutaAsincronaSimmetrica() != null ? aPA.getRicevutaAsincronaSimmetrica() : null);
                        stm.setString(12, aPA.getRicevutaAsincronaAsimmetrica() != null ? aPA.getRicevutaAsincronaAsimmetrica() : null);
                        stm.setString(13, aPA.getIntegrazione() != null ? aPA.getIntegrazione() : null);
                        stm.setString(14, aPA.getValidazioneContenutiApplicativi() != null ? aPA.getValidazioneContenutiApplicativi().getStato() : null);
                        stm.setString(15, aPA.getValidazioneContenutiApplicativi() != null ? aPA.getValidazioneContenutiApplicativi().getTipo() : null);
                        stm.setLong(16, idProprietario);
                        stm.setString(17, aPA != null ? aPA.getAllegaBody() : null);
                        stm.setString(18, aPA != null ? aPA.getScartaBody() : null);
                        stm.setString(19, aPA != null ? aPA.getGestioneManifest() : null);
                        stm.setString(20, aPA != null ? aPA.getStateless() : null);
                        stm.setLong(21, aPA.getIdAccordo() != null ? aPA.getIdAccordo() : -1L);
                        stm.setLong(22, aPA.getIdPortType() != null ? aPA.getIdPortType() : -1L);
                        stm.setLong(23, oldIdProprietario);
                        stm.setString(24, oldNomePA);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Updated " + n + " row(s)."));
                        if (ws_sec != null && "abilitato".equals(wsSecStatus)) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_applicative_ws_request");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.executeUpdate();
                            stm.close();
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_applicative_ws_response");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.executeUpdate();
                            stm.close();
                            WsSecurityRequestFlowParameter reqParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_ws_request");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeRequestFlowList(); ++i) {
                                reqParam = ws_sec.getRequestFlow(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, reqParam.getNome());
                                stm.setString(3, reqParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " request flow con id=" + idPortaApplicativa));
                            WsSecurityResponseFlowParameter resParam = null;
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_ws_response");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            for (i = 0; i < ws_sec.sizeResponseFlowList(); ++i) {
                                resParam = ws_sec.getResponseFlow(i);
                                stm.setLong(1, idPortaApplicativa);
                                stm.setString(2, resParam.getNome());
                                stm.setString(3, resParam.getValore());
                                stm.executeUpdate();
                            }
                            stm.close();
                            log.debug((Object)("Inserted " + i + " response flow con id=" + idPortaApplicativa));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_sa");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Cancellati " + n + " servizi applicativi associati alla Porta Applicativa " + idPortaApplicativa));
                        n = 0;
                        for (i = 0; i < aPA.sizeServizioApplicativoList(); ++n, ++i) {
                            servizioApplicativo = aPA.getServizioApplicativo(i);
                            String nomeSA = servizioApplicativo.getNome();
                            String nomeProprietarioSA = aPA.getNomeSoggettoProprietario();
                            String tipoProprietarioSA = aPA.getTipoSoggettoProprietario();
                            if (nomeSA == null) throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            if (nomeSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome del ServizioApplicativo associato non valido.");
                            }
                            if (nomeProprietarioSA == null) throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            if (nomeProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Nome Proprietario del ServizioApplicativo associato non valido.");
                            }
                            if (tipoProprietarioSA == null) throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            if (tipoProprietarioSA.equals("")) {
                                throw new DriverConfigurazioneException("Tipo Proprietario del ServizioApplicativo associato non valido.");
                            }
                            long idSA = DBUtils.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, tipoDB, tabellaSoggetti);
                            if (idSA <= 0L) {
                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_sa");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setLong(2, idSA);
                            stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Aggiunta associazione PortaApplicativa<->ServizioApplicativo [" + idPortaApplicativa + "]<->[" + idSA + "]"));
                        }
                        log.debug((Object)("Aggiunti " + n + " associazioni PortaApplicativa<->ServizioApplicativo associati alla PortaDelegata[" + idPortaApplicativa + "]"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_prop");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Eliminate " + n + " proprieta associate alla Porta Applicativa " + idPortaApplicativa));
                        int newProps = 0;
                        for (i = 0; i < aPA.sizeSetSpcoopPropertyList(); ++newProps, ++i) {
                            proSpcoop = aPA.getSetSpcoopProperty(i);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addInsertTable("porte_applicative_prop");
                            sqlQueryObject.addInsertField("id_porta", "?");
                            sqlQueryObject.addInsertField("nome", "?");
                            sqlQueryObject.addInsertField("valore", "?");
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            stm.setString(2, proSpcoop.getNome());
                            stm.setString(3, proSpcoop.getValore());
                            stm.executeUpdate();
                            stm.close();
                        }
                        log.debug((Object)("Inserted " + newProps + " SetSpcooProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        break;
                    }
                    case 3: {
                        ISQLQueryObject sqlQueryObject;
                        idPortaApplicativa = DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, tabellaSoggetti);
                        if (idPortaApplicativa <= 0L) {
                            throw new DriverConfigurazioneException("Non e' stato possibile recuperare l'id della Porta Applicativa.");
                        }
                        if ("abilitato".equals(wsSecStatus)) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_applicative_ws_request");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            n = stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Deleted " + n + " request flow con id=" + idPortaApplicativa));
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addDeleteTable("porte_applicative_ws_response");
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQuery = sqlQueryObject.createSQLDelete();
                            stm = con.prepareStatement(sqlQuery);
                            stm.setLong(1, idPortaApplicativa);
                            n = stm.executeUpdate();
                            stm.close();
                            log.debug((Object)("Deleted " + n + " response flow con id=" + idPortaApplicativa));
                        }
                        servizioApplicativo = null;
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_sa");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Deleted " + n + " servizi applicativi associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_ws_request");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " ws_request flow associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_ws_response");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " ws_response flow associate alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative_prop");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        n = stm.executeUpdate();
                        stm.close();
                        if (n > 0) {
                            log.debug((Object)("Deleted " + n + " SetSpcooProp associati alla PortaApplicativa[" + idPortaApplicativa + "]"));
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject.addDeleteTable("porte_applicative");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQueryObject.addWhereCondition("id_soggetto=?");
                        sqlQueryObject.addWhereCondition("nome_porta=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setLong(1, idPortaApplicativa);
                        stm.setLong(2, idProprietario);
                        stm.setString(3, nomePorta);
                        n = stm.executeUpdate();
                        stm.close();
                        log.debug((Object)("Deleted " + n + " row(s)."));
                        break;
                    }
                }
                l = idPortaApplicativa;
                Object var43_49 = null;
            }
            catch (DriverException e) {
                throw new DriverConfigurazioneException(e);
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDPortaApplicativa] SQLException [" + se.getMessage() + "].", se);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Errore durante operazione(" + type + ") CRUDPortaApplicativa.", e);
            }
        }
        catch (Throwable throwable) {
            Object var43_50 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Loose catch block
     */
    public static void CRUDRoutingTable(int type, RoutingTable aRT, Connection con) throws DriverConfigurazioneException {
        block52: {
            Statement updateStmt = null;
            Statement insertStmt = null;
            Statement updateStmtSelectRegistri = null;
            ResultSet rsSelectRegistri = null;
            String updateQuery = "";
            int i = 0;
            RoutingTableDestinazione rtd = null;
            Route route = null;
            RouteGateway gw = null;
            RouteRegistro rg = null;
            String tipo = null;
            String nome = null;
            long idRoute = 0L;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, "abilitato");
                    } else {
                        updateStmt.setString(1, "disabilitato");
                    }
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata())));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    for (i = 0; i < aRT.sizeDefaultList(); ++i) {
                        route = aRT.getDefault(i);
                        gw = route.getGateway();
                        rg = route.getRegistro();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, null);
                        updateStmt.setString(2, null);
                        updateStmt.setString(3, gw != null ? "gateway" : "registro");
                        updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                        updateStmt.setString(5, gw != null ? gw.getNome() : null);
                        long registroRotta = 0L;
                        if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addFromTable("registri");
                            sqlQueryObject.addSelectField("id");
                            sqlQueryObject.addWhereCondition("nome = ?");
                            String selectQuery = sqlQueryObject.createSQLQuery();
                            updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                            updateStmtSelectRegistri.setString(1, rg.getNome());
                            rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                            if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                registroRotta = rsSelectRegistri.getLong("id");
                            }
                            rsSelectRegistri.close();
                            updateStmtSelectRegistri.close();
                        }
                        updateStmt.setLong(6, registroRotta);
                        updateStmt.setInt(7, 1);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                    }
                    log.debug((Object)("Inserted " + i + " Default route."));
                    for (i = 0; i < aRT.sizeDestinazioneList(); ++i) {
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setString(1, tipo);
                            updateStmt.setString(2, nome);
                            updateStmt.setString(3, gw != null ? "gateway" : "registro");
                            updateStmt.setString(4, gw != null ? gw.getTipo() : null);
                            updateStmt.setString(5, gw != null ? gw.getNome() : null);
                            long registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                String selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            updateStmt.setLong(6, registroRotta);
                            updateStmt.setInt(7, 0);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                        }
                    }
                    log.debug((Object)("Inserted " + i + " Destination route."));
                    break;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("configurazione");
                    sqlQueryObject.addUpdateField("routing_enabled", "?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    if (aRT.getAbilitata().booleanValue()) {
                        updateStmt.setString(1, "abilitato");
                    } else {
                        updateStmt.setString(1, "disabilitato");
                    }
                    log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, aRT.getAbilitata())));
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addUpdateTable("routing");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    sqlQueryObject.addUpdateField("tiporotta", "?");
                    sqlQueryObject.addUpdateField("tiposoggrotta", "?");
                    sqlQueryObject.addUpdateField("nomesoggrotta", "?");
                    sqlQueryObject.addUpdateField("registrorotta", "?");
                    sqlQueryObject.addUpdateField("is_default", "?");
                    sqlQueryObject.addWhereCondition("id = ?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addInsertTable("routing");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("tiporotta", "?");
                    sqlQueryObject.addInsertField("tiposoggrotta", "?");
                    sqlQueryObject.addInsertField("nomesoggrotta", "?");
                    sqlQueryObject.addInsertField("registrorotta", "?");
                    sqlQueryObject.addInsertField("is_default", "?");
                    String insertQuery = sqlQueryObject.createSQLInsert();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addDeleteTable("routing");
                    String queryDelete = sqlQueryObject.createSQLDelete();
                    log.debug((Object)("DELETING Destination Route : " + queryDelete));
                    updateStmt = con.prepareStatement(queryDelete);
                    int n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("Deleted " + n + " Destination route."));
                    for (i = 0; i < aRT.sizeDefaultList(); ++i) {
                        route = aRT.getDefault(i);
                        idRoute = route.getId();
                        gw = route.getGateway();
                        rg = route.getRegistro();
                        long registroRotta = 0L;
                        if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject.addFromTable("registri");
                            sqlQueryObject.addSelectField("id");
                            sqlQueryObject.addWhereCondition("nome = ?");
                            String selectQuery = sqlQueryObject.createSQLQuery();
                            updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                            updateStmtSelectRegistri.setString(1, rg.getNome());
                            rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                            if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                registroRotta = rsSelectRegistri.getLong("id");
                            }
                            rsSelectRegistri.close();
                            updateStmtSelectRegistri.close();
                        }
                        insertStmt = con.prepareStatement(insertQuery);
                        insertStmt.setString(1, null);
                        insertStmt.setString(2, null);
                        insertStmt.setString(3, gw != null ? "gateway" : "registro");
                        insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                        insertStmt.setString(5, gw != null ? gw.getNome() : null);
                        insertStmt.setLong(6, registroRotta);
                        insertStmt.setInt(7, 1);
                        insertStmt.executeUpdate();
                        insertStmt.close();
                    }
                    log.debug((Object)("Updated " + i + " Default route."));
                    for (i = 0; i < aRT.sizeDestinazioneList(); ++i) {
                        rtd = aRT.getDestinazione(i);
                        nome = rtd.getNome();
                        tipo = rtd.getTipo();
                        for (int j = 0; j < rtd.sizeRouteList(); ++j) {
                            route = rtd.getRoute(j);
                            idRoute = route.getId();
                            gw = route.getGateway();
                            rg = route.getRegistro();
                            long registroRotta = 0L;
                            if (rg != null && rg.getId() <= 0L && rg.getNome() != null && !"".equals(rg.getNome())) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                String selectQuery = sqlQueryObject.createSQLQuery();
                                updateStmtSelectRegistri = con.prepareStatement(selectQuery);
                                updateStmtSelectRegistri.setString(1, rg.getNome());
                                rsSelectRegistri = updateStmtSelectRegistri.executeQuery();
                                if (rsSelectRegistri != null && rsSelectRegistri.next()) {
                                    registroRotta = rsSelectRegistri.getLong("id");
                                }
                                rsSelectRegistri.close();
                                updateStmtSelectRegistri.close();
                            }
                            insertStmt = con.prepareStatement(insertQuery);
                            insertStmt.setString(1, tipo);
                            insertStmt.setString(2, nome);
                            insertStmt.setString(3, gw != null ? "gateway" : "registro");
                            insertStmt.setString(4, gw != null ? gw.getTipo() : null);
                            insertStmt.setString(5, gw != null ? gw.getNome() : null);
                            insertStmt.setLong(6, registroRotta);
                            insertStmt.setInt(7, 0);
                            insertStmt.executeUpdate();
                            insertStmt.close();
                        }
                    }
                    log.debug((Object)("Updated " + i + " Destination route."));
                    break;
                }
                case 3: {
                    i = 0;
                    if (i >= aRT.sizeDefaultList()) break;
                    route = aRT.getDefault(i);
                    if (route.getId() == null || route.getId() <= 0L) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable(DELETE)] id route non valida.");
                    }
                    idRoute = route.getId();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                    sqlQueryObject.addDeleteTable("routing");
                    sqlQueryObject.addWhereCondition("id=?");
                    String sqlQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(sqlQuery);
                    updateStmt.setLong(1, idRoute);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug((Object)("Deleted " + i + " Destination route."));
                    break;
                }
            }
            Object var26_36 = null;
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (insertStmt != null) {
                    insertStmt.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (rsSelectRegistri != null) {
                    rsSelectRegistri.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (updateStmtSelectRegistri != null) {
                    updateStmtSelectRegistri.close();
                }
                break block52;
            }
            catch (Exception e) {}
            break block52;
            {
                catch (SQLException se) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] SQLException [" + se.getMessage() + "].", se);
                }
                catch (Exception se) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRoutingTable] Exception [" + se.getMessage() + "].", se);
                }
            }
            catch (Throwable throwable) {
                Object var26_37 = null;
                try {
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (insertStmt != null) {
                        insertStmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (rsSelectRegistri != null) {
                        rsSelectRegistri.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (updateStmtSelectRegistri != null) {
                        updateStmtSelectRegistri.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDAccessoRegistro(int type, AccessoRegistroRegistro registro, Connection con) throws DriverConfigurazioneException {
        block26: {
            block25: {
                if (registro == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Il servizio non puo essere NULL");
                }
                updateStmt = null;
                updateQuery = "";
                selectStmt = null;
                selectQuery = "";
                selectRS = null;
                idRegistro = 0L;
                n = 0;
                nome = registro.getNome();
                location = registro.getLocation();
                tipo = registro.getTipo();
                user = registro.getUser();
                password = registro.getPassword();
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("registri");
                                sqlQueryObject.addInsertField("nome", "?");
                                sqlQueryObject.addInsertField("location", "?");
                                sqlQueryObject.addInsertField("tipo", "?");
                                sqlQueryObject.addInsertField("utente", "?");
                                sqlQueryObject.addInsertField("password", "?");
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, nome);
                                updateStmt.setString(2, location);
                                updateStmt.setString(3, tipo);
                                updateStmt.setString(4, user);
                                updateStmt.setString(5, password);
                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[]{nome, location, tipo, user, password})));
                                n = updateStmt.executeUpdate();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addFromTable("registri");
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("nome = ?");
                                sqlQueryObject.addWhereCondition("location = ?");
                                sqlQueryObject.setANDLogicOperator(true);
                                selectQuery = sqlQueryObject.createSQLQuery();
                                selectStmt = con.prepareStatement(selectQuery);
                                selectStmt.setString(1, nome);
                                selectStmt.setString(2, location);
                                selectRS = selectStmt.executeQuery();
                                if (!selectRS.next()) break;
                                idRegistro = selectRS.getLong("id");
                                registro.setId(idRegistro);
                                break;
                            }
                            case 2: {
                                if (registro.getId() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(UPDATE)] L'id del Servizio e' necessario.");
                                if (registro.getId() <= 0L) {
                                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(UPDATE)] L'id del Servizio e' necessario.");
                                }
                                idRegistro = registro.getId();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("routing");
                                sqlQueryObject.addUpdateField("nome", "?");
                                sqlQueryObject.addUpdateField("location", "?");
                                sqlQueryObject.addUpdateField("tipo", "?");
                                sqlQueryObject.addUpdateField("utente", "?");
                                sqlQueryObject.addUpdateField("password", "?");
                                sqlQueryObject.addWhereCondition("id=?");
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, registro.getNome());
                                updateStmt.setString(2, registro.getLocation());
                                updateStmt.setString(3, registro.getTipo());
                                updateStmt.setString(4, registro.getUser());
                                updateStmt.setString(5, registro.getPassword());
                                updateStmt.setLong(6, idRegistro);
                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[]{nome, location, tipo, user, password, idRegistro})));
                                n = updateStmt.executeUpdate();
                                break;
                            }
                            case 3: {
                                if (registro.getId() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(DELETE)] L'id del Servizio e' necessario.");
                                if (registro.getId() <= 0L) {
                                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro(DELETE)] L'id del Servizio e' necessario.");
                                }
                                idRegistro = registro.getId();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("registri");
                                sqlQueryObject.addWhereCondition("id=?");
                                sqlQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(sqlQuery);
                                updateStmt.setLong(1, idRegistro);
                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[]{idRegistro})));
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                break;
                            }
                        }
                        if (type == 1) {
                            sqlQueryObject = idRegistro;
                            var19_21 = null;
                            break block25;
                        }
                        sqlQueryObject = n;
                        break block26;
                    }
                    catch (SQLException se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
                    }
                    catch (Exception se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
                    }
                }
                catch (Throwable var18_27) {
                    var19_23 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var18_27;
                        updateStmt.close();
                        throw var18_27;
                    }
                    catch (Exception e) {
                        throw var18_27;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 982->1019)] { 
lbl116:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl123:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var19_22 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDAccessoRegistro(int type, AccessoRegistro registro, Connection con) throws DriverConfigurazioneException {
        block38: {
            block37: {
                block32: {
                    block36: {
                        block35: {
                            block31: {
                                if (registro == null) {
                                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Il registro non pu\u00f2 essere NULL");
                                }
                                updateStmt = null;
                                updateQuery = "";
                                selectStmt = null;
                                selectRS = null;
                                idRegistro = 0L;
                                n = 0;
                                arc = registro.getCache();
                                statoCache = "disabilitato";
                                dimensionecache = null;
                                algoritmocache = null;
                                idlecache = null;
                                lifecache = null;
                                if (arc != null) {
                                    statoCache = "abilitato";
                                    dimensionecache = arc.getDimensione();
                                    algoritmocache = arc.getAlgoritmo();
                                    idlecache = arc.getItemIdleTime();
                                    lifecache = arc.getItemLifeSecond();
                                }
                                try {
                                    try {
                                        switch (type) {
                                            case 1: 
                                            case 2: {
                                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                                sqlQueryObject.addUpdateTable("configurazione");
                                                sqlQueryObject.addUpdateField("statocache", "?");
                                                sqlQueryObject.addUpdateField("dimensionecache", "?");
                                                sqlQueryObject.addUpdateField("algoritmocache", "?");
                                                sqlQueryObject.addUpdateField("idlecache", "?");
                                                sqlQueryObject.addUpdateField("lifecache", "?");
                                                updateQuery = sqlQueryObject.createSQLUpdate();
                                                updateStmt = con.prepareStatement(updateQuery);
                                                updateStmt.setString(1, statoCache);
                                                updateStmt.setString(2, dimensionecache);
                                                updateStmt.setString(3, algoritmocache);
                                                updateStmt.setString(4, idlecache);
                                                updateStmt.setString(5, lifecache);
                                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, new Object[]{statoCache, dimensionecache, algoritmocache, idlecache, lifecache})));
                                                n = updateStmt.executeUpdate();
                                                updateStmt.close();
                                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                                sqlQueryObject.addDeleteTable("registri");
                                                sqlQuery = sqlQueryObject.createSQLDelete();
                                                updateStmt = con.prepareStatement(sqlQuery);
                                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                                                risultato = updateStmt.executeUpdate();
                                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query risultato[" + risultato + "]: " + DBUtils.formatSQLString(updateQuery, new Object[0])));
                                                updateStmt.close();
                                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                                sqlQueryObject.addInsertTable("registri");
                                                sqlQueryObject.addInsertField("nome", "?");
                                                sqlQueryObject.addInsertField("location", "?");
                                                sqlQueryObject.addInsertField("tipo", "?");
                                                sqlQueryObject.addInsertField("utente", "?");
                                                sqlQueryObject.addInsertField("password", "?");
                                                updateQuery = sqlQueryObject.createSQLInsert();
                                                for (i = 0; i < registro.sizeRegistroList(); ++i) {
                                                    updateStmt = con.prepareStatement(updateQuery);
                                                    arr = registro.getRegistro(i);
                                                    nome = arr.getNome();
                                                    location = arr.getLocation();
                                                    tipo = arr.getTipo();
                                                    utente = arr.getUser();
                                                    password = arr.getPassword();
                                                    updateStmt.setString(1, nome);
                                                    updateStmt.setString(2, location);
                                                    updateStmt.setString(3, tipo);
                                                    updateStmt.setString(4, utente);
                                                    updateStmt.setString(5, password);
                                                    DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query INSERT INTO registri(nome, location, tipo, utente, password) VALUES (" + nome + ", " + location + ", " + tipo + ", " + utente + ", " + password + ")"));
                                                    updateStmt.executeUpdate();
                                                    updateStmt.close();
                                                }
                                                break;
                                            }
                                        }
                                        if (type == 1) {
                                            sqlQueryObject = idRegistro;
                                            var27_29 = null;
                                            break block31;
                                        }
                                        sqlQueryObject = n;
                                        break block32;
                                    }
                                    catch (SQLException se) {
                                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] SQLException [" + se.getMessage() + "].", se);
                                    }
                                    catch (Exception se) {
                                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDAccessoRegistro] Exception [" + se.getMessage() + "].", se);
                                    }
                                }
                                catch (Throwable var26_35) {
                                    var27_31 = null;
                                    try {
                                        if (selectRS != null) {
                                            selectRS.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        if (selectStmt != null) {
                                            selectStmt.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        if (updateStmt == null) throw var26_35;
                                        updateStmt.close();
                                        throw var26_35;
                                    }
                                    catch (Exception e) {
                                        throw var26_35;
                                    }
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [7 : 870->885)] { 
lbl114:
                            // 1 sources

                            if (selectRS != null) {
                                selectRS.close();
                            }
                            break block35;
lbl117:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [8 : 887->902)] { 
lbl121:
                        // 1 sources

                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        break block36;
lbl124:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [9 : 904->917)] { 
lbl128:
                    // 1 sources

                    if (updateStmt == null) return sqlQueryObject;
                    updateStmt.close();
                    return sqlQueryObject;
lbl131:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return sqlQueryObject;
                }
                var27_30 = null;
                ** try [egrp 2[TRYBLOCK] [7 : 870->885)] { 
lbl137:
                // 1 sources

                if (selectRS != null) {
                    selectRS.close();
                }
                break block37;
lbl140:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [8 : 887->902)] { 
lbl144:
            // 1 sources

            if (selectStmt != null) {
                selectStmt.close();
            }
            break block38;
lbl147:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDConfigurazioneGenerale(int type, Configurazione config, Connection con) throws DriverConfigurazioneException {
        block45: {
            block44: {
                updateStmt = null;
                updateQuery = "";
                selectStmt = null;
                selectRS = null;
                n = 0;
                idConfigurazione = 0L;
                indirizzoTelematico = config.getIndirizzoTelematico();
                inoltroBusteNonRiscontrate = config.getInoltroBusteNonRiscontrate();
                integrationManager = config.getIntegrationManager();
                messaggiDiagnostici = config.getMessaggiDiagnostici();
                risposteSpcoop = config.getRisposteSpcoop();
                validazioneBusteEgov = config.getValidazioneBusteEgov();
                car = config.getAccessoRegistro();
                att = config.getAttachments();
                utilizzoIndTelematico = null;
                if (indirizzoTelematico != null) {
                    utilizzoIndTelematico = indirizzoTelematico.getUtilizzo();
                }
                cadenza_inoltro = null;
                if (inoltroBusteNonRiscontrate != null) {
                    cadenza_inoltro = inoltroBusteNonRiscontrate.getCadenza();
                }
                autenticazione = null;
                if (integrationManager != null) {
                    autenticazione = integrationManager.getAutenticazione();
                }
                msg_diag_spcoop = null;
                msg_diag_openspcoop = null;
                if (messaggiDiagnostici != null) {
                    msg_diag_spcoop = messaggiDiagnostici.getSpcoop();
                    msg_diag_openspcoop = messaggiDiagnostici.getOpenspcoop();
                }
                val_controllo = null;
                val_stato = null;
                val_manifest = null;
                val_profiloCollaborazione = null;
                if (validazioneBusteEgov != null) {
                    val_controllo = validazioneBusteEgov.getControllo();
                    val_stato = validazioneBusteEgov.getStato();
                    val_manifest = validazioneBusteEgov.getManifestAttachments();
                    val_profiloCollaborazione = validazioneBusteEgov.getProfiloCollaborazione();
                }
                gestioneManifest = null;
                if (att != null) {
                    gestioneManifest = att.getGestioneManifest();
                }
                cache = null;
                dimensioneCache = null;
                algoritmoCache = null;
                idleCache = null;
                lifeCache = null;
                statoCache = null;
                if (car != null) {
                    cache = car.getCache();
                }
                v0 = statoCache = cache != null ? "abilitato" : "disabilitato";
                if (statoCache.equals("abilitato")) {
                    dimensioneCache = cache.getDimensione();
                    algoritmoCache = cache.getAlgoritmo();
                    idleCache = cache.getItemIdleTime();
                    lifeCache = cache.getItemLifeSecond();
                }
                t = config.getTracciamento();
                busteEgov = null;
                dump = null;
                if (t != null) {
                    busteEgov = t.getBusteEgov();
                    dump = t.getDump();
                }
                modRisposta = "reply";
                if (risposteSpcoop != null) {
                    modRisposta = risposteSpcoop.getConnessione().equals("reply") != false ? "reply" : "new";
                }
                routingEnabled = "disabilitato";
                if (config.getRoutingTable() != null && config.getRoutingTable().getAbilitata().booleanValue()) {
                    routingEnabled = "abilitato";
                }
                validazione_contenuti_stato = null;
                validazione_contenuti_tipo = null;
                if (config.getValidazioneContenutiApplicativi() != null) {
                    validazione_contenuti_stato = config.getValidazioneContenutiApplicativi().getStato();
                    validazione_contenuti_tipo = config.getValidazioneContenutiApplicativi().getTipo();
                }
                try {
                    try {
                        switch (type) {
                            case 1: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addInsertTable("configurazione");
                                sqlQueryObject.addInsertField("cadenza_inoltro", "?");
                                sqlQueryObject.addInsertField("validazione_stato", "?");
                                sqlQueryObject.addInsertField("validazione_controllo", "?");
                                sqlQueryObject.addInsertField("msg_diag_spcoop", "?");
                                sqlQueryObject.addInsertField("msg_diag_openspcoop", "?");
                                sqlQueryObject.addInsertField("auth_integration_manager", "?");
                                sqlQueryObject.addInsertField("statocache", "?");
                                sqlQueryObject.addInsertField("dimensionecache", "?");
                                sqlQueryObject.addInsertField("algoritmocache", "?");
                                sqlQueryObject.addInsertField("idlecache", "?");
                                sqlQueryObject.addInsertField("lifecache", "?");
                                sqlQueryObject.addInsertField("validazione_profilo", "?");
                                sqlQueryObject.addInsertField("mod_risposta", "?");
                                sqlQueryObject.addInsertField("indirizzo_telematico", "?");
                                sqlQueryObject.addInsertField("routing_enabled", "?");
                                sqlQueryObject.addInsertField("gestione_manifest", "?");
                                sqlQueryObject.addInsertField("validazione_manifest", "?");
                                sqlQueryObject.addInsertField("tracciamento_buste", "?");
                                sqlQueryObject.addInsertField("tracciamento_dump", "?");
                                sqlQueryObject.addInsertField("validazione_contenuti_stato", "?");
                                sqlQueryObject.addInsertField("validazione_contenuti_tipo", "?");
                                updateQuery = sqlQueryObject.createSQLInsert();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, cadenza_inoltro);
                                updateStmt.setString(2, val_stato);
                                updateStmt.setString(3, val_controllo);
                                updateStmt.setString(4, msg_diag_spcoop);
                                updateStmt.setString(5, msg_diag_openspcoop);
                                updateStmt.setString(6, autenticazione);
                                updateStmt.setString(7, statoCache);
                                updateStmt.setString(8, dimensioneCache);
                                updateStmt.setString(9, algoritmoCache);
                                updateStmt.setString(10, idleCache);
                                updateStmt.setString(11, lifeCache);
                                updateStmt.setString(12, val_profiloCollaborazione);
                                updateStmt.setString(13, modRisposta);
                                updateStmt.setString(14, utilizzoIndTelematico);
                                updateStmt.setString(15, routingEnabled);
                                updateStmt.setString(16, gestioneManifest);
                                updateStmt.setString(17, val_manifest);
                                updateStmt.setString(18, busteEgov);
                                updateStmt.setString(19, dump);
                                updateStmt.setString(20, validazione_contenuti_stato);
                                updateStmt.setString(21, validazione_contenuti_tipo);
                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, new Object[]{cadenza_inoltro, val_stato, val_controllo, msg_diag_spcoop, msg_diag_openspcoop, autenticazione, statoCache, dimensioneCache, algoritmoCache, idleCache, lifeCache, val_profiloCollaborazione, modRisposta, utilizzoIndTelematico, routingEnabled, gestioneManifest, val_manifest, busteEgov, dump})));
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("msg_diag_appender_prop");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("msg_diag_appender");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                id = 1L;
                                if (config.getMessaggiDiagnostici() != null) {
                                    for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++id, ++k) {
                                        appender = config.getMessaggiDiagnostici().getOpenspcoopAppender(k);
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                        sqlQueryObject.addInsertTable("msg_diag_appender");
                                        sqlQueryObject.addInsertField("tipo", "?");
                                        sqlQueryObject.addInsertField("id", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        updateStmt.setString(1, appender.getTipo());
                                        updateStmt.setLong(2, id);
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                        for (l = 0; l < appender.sizePropertyList(); ++l) {
                                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                            sqlQueryObject.addInsertTable("msg_diag_appender_prop");
                                            sqlQueryObject.addInsertField("id_appender", "?");
                                            sqlQueryObject.addInsertField("nome", "?");
                                            sqlQueryObject.addInsertField("valore", "?");
                                            updateQuery = sqlQueryObject.createSQLInsert();
                                            updateStmt = con.prepareStatement(updateQuery);
                                            updateStmt.setLong(1, id);
                                            updateStmt.setString(2, appender.getProperty(l).getNome());
                                            updateStmt.setString(3, appender.getProperty(l).getValore());
                                            updateStmt.executeUpdate();
                                            updateStmt.close();
                                        }
                                    }
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("tracciamento_appender_prop");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("tracciamento_appender");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                id = 1L;
                                if (config.getTracciamento() == null) break;
                                for (k = 0; k < config.getTracciamento().sizeOpenspcoopAppenderList(); ++id, ++k) {
                                    appender = config.getTracciamento().getOpenspcoopAppender(k);
                                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                    sqlQueryObject.addInsertTable("tracciamento_appender");
                                    sqlQueryObject.addInsertField("tipo", "?");
                                    sqlQueryObject.addInsertField("id", "?");
                                    updateQuery = sqlQueryObject.createSQLInsert();
                                    updateStmt = con.prepareStatement(updateQuery);
                                    updateStmt.setString(1, appender.getTipo());
                                    updateStmt.setLong(2, id);
                                    updateStmt.executeUpdate();
                                    updateStmt.close();
                                    for (l = 0; l < appender.sizePropertyList(); ++l) {
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                        sqlQueryObject.addInsertTable("tracciamento_appender_prop");
                                        sqlQueryObject.addInsertField("id_appender", "?");
                                        sqlQueryObject.addInsertField("nome", "?");
                                        sqlQueryObject.addInsertField("valore", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        updateStmt.setLong(1, id);
                                        updateStmt.setString(2, appender.getProperty(l).getNome());
                                        updateStmt.setString(3, appender.getProperty(l).getValore());
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                    }
                                }
                                break;
                            }
                            case 2: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addUpdateTable("configurazione");
                                sqlQueryObject.addUpdateField("cadenza_inoltro", "?");
                                sqlQueryObject.addUpdateField("validazione_stato", "?");
                                sqlQueryObject.addUpdateField("validazione_controllo", "?");
                                sqlQueryObject.addUpdateField("msg_diag_spcoop", "?");
                                sqlQueryObject.addUpdateField("msg_diag_openspcoop", "?");
                                sqlQueryObject.addUpdateField("auth_integration_manager", "?");
                                sqlQueryObject.addUpdateField("statocache", "?");
                                sqlQueryObject.addUpdateField("dimensionecache", "?");
                                sqlQueryObject.addUpdateField("algoritmocache", "?");
                                sqlQueryObject.addUpdateField("idlecache", "?");
                                sqlQueryObject.addUpdateField("lifecache", "?");
                                sqlQueryObject.addUpdateField("validazione_profilo", "?");
                                sqlQueryObject.addUpdateField("mod_risposta", "?");
                                sqlQueryObject.addUpdateField("indirizzo_telematico", "?");
                                sqlQueryObject.addUpdateField("routing_enabled", "?");
                                sqlQueryObject.addUpdateField("gestione_manifest", "?");
                                sqlQueryObject.addUpdateField("validazione_manifest", "?");
                                sqlQueryObject.addUpdateField("tracciamento_buste", "?");
                                sqlQueryObject.addUpdateField("tracciamento_dump", "?");
                                sqlQueryObject.addUpdateField("validazione_contenuti_stato", "?");
                                sqlQueryObject.addUpdateField("validazione_contenuti_tipo", "?");
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setString(1, cadenza_inoltro);
                                updateStmt.setString(2, val_stato);
                                updateStmt.setString(3, val_controllo);
                                updateStmt.setString(4, msg_diag_spcoop);
                                updateStmt.setString(5, msg_diag_openspcoop);
                                updateStmt.setString(6, autenticazione);
                                updateStmt.setString(7, statoCache);
                                updateStmt.setString(8, dimensioneCache);
                                updateStmt.setString(9, algoritmoCache);
                                updateStmt.setString(10, idleCache);
                                updateStmt.setString(11, lifeCache);
                                updateStmt.setString(12, val_profiloCollaborazione);
                                updateStmt.setString(13, modRisposta);
                                updateStmt.setString(14, utilizzoIndTelematico);
                                updateStmt.setString(15, routingEnabled);
                                updateStmt.setString(16, gestioneManifest);
                                updateStmt.setString(17, val_manifest);
                                updateStmt.setString(18, busteEgov);
                                updateStmt.setString(19, dump);
                                updateStmt.setString(20, validazione_contenuti_stato);
                                updateStmt.setString(21, validazione_contenuti_tipo);
                                DriverConfigurazioneDB_LIB.log.debug((Object)("eseguo query :" + DBUtils.formatSQLString(updateQuery, new Object[]{cadenza_inoltro, val_stato, val_controllo, msg_diag_spcoop, msg_diag_openspcoop, autenticazione, statoCache, dimensioneCache, algoritmoCache, idleCache, lifeCache, val_profiloCollaborazione, modRisposta, utilizzoIndTelematico, routingEnabled, gestioneManifest, val_manifest, busteEgov, dump})));
                                n = updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("msg_diag_appender_prop");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("msg_diag_appender");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                id = 1L;
                                if (config.getMessaggiDiagnostici() != null) {
                                    for (k = 0; k < config.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++id, ++k) {
                                        appender = config.getMessaggiDiagnostici().getOpenspcoopAppender(k);
                                        DriverConfigurazioneDB_LIB.log.debug((Object)("INSERT INTO msg_diag_appender (tipo,id) VALUES (" + appender.getTipo() + "," + id + ")"));
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                        sqlQueryObject.addInsertTable("msg_diag_appender");
                                        sqlQueryObject.addInsertField("tipo", "?");
                                        sqlQueryObject.addInsertField("id", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        updateStmt.setString(1, appender.getTipo());
                                        updateStmt.setLong(2, id);
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                        for (l = 0; l < appender.sizePropertyList(); ++l) {
                                            DriverConfigurazioneDB_LIB.log.debug((Object)("INSERT INTO msg_diag_appender_prop (id_appender,nome,valore) VALUES (" + id + "," + appender.getProperty(l).getNome() + "," + appender.getProperty(l).getValore() + ")"));
                                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                            sqlQueryObject.addInsertTable("msg_diag_appender_prop");
                                            sqlQueryObject.addInsertField("id_appender", "?");
                                            sqlQueryObject.addInsertField("nome", "?");
                                            sqlQueryObject.addInsertField("valore", "?");
                                            updateQuery = sqlQueryObject.createSQLInsert();
                                            updateStmt = con.prepareStatement(updateQuery);
                                            updateStmt.setLong(1, id);
                                            updateStmt.setString(2, appender.getProperty(l).getNome());
                                            updateStmt.setString(3, appender.getProperty(l).getValore());
                                            updateStmt.executeUpdate();
                                            updateStmt.close();
                                        }
                                    }
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("tracciamento_appender_prop");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("tracciamento_appender");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                id = 1L;
                                if (config.getTracciamento() == null) break;
                                for (k = 0; k < config.getTracciamento().sizeOpenspcoopAppenderList(); ++id, ++k) {
                                    appender = config.getTracciamento().getOpenspcoopAppender(k);
                                    DriverConfigurazioneDB_LIB.log.debug((Object)("INSERT INTO tracciamento_appender (tipo,id) VALUES (" + appender.getTipo() + "," + id + ")"));
                                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                    sqlQueryObject.addInsertTable("tracciamento_appender");
                                    sqlQueryObject.addInsertField("tipo", "?");
                                    sqlQueryObject.addInsertField("id", "?");
                                    updateQuery = sqlQueryObject.createSQLInsert();
                                    updateStmt = con.prepareStatement(updateQuery);
                                    updateStmt.setString(1, appender.getTipo());
                                    updateStmt.setLong(2, id);
                                    updateStmt.executeUpdate();
                                    updateStmt.close();
                                    for (l = 0; l < appender.sizePropertyList(); ++l) {
                                        DriverConfigurazioneDB_LIB.log.debug((Object)("INSERT INTO tracciamento_appender_prop (id_appender,nome,valore) VALUES (" + id + "," + appender.getProperty(l).getNome() + "," + appender.getProperty(l).getValore() + ")"));
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                        sqlQueryObject.addInsertTable("tracciamento_appender_prop");
                                        sqlQueryObject.addInsertField("id_appender", "?");
                                        sqlQueryObject.addInsertField("nome", "?");
                                        sqlQueryObject.addInsertField("valore", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        updateStmt.setLong(1, id);
                                        updateStmt.setString(2, appender.getProperty(l).getNome());
                                        updateStmt.setString(3, appender.getProperty(l).getValore());
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                    }
                                }
                                break;
                            }
                            case 3: {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(DriverConfigurazioneDB_LIB.tipoDB);
                                sqlQueryObject.addDeleteTable("configurazione");
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                break;
                            }
                        }
                        if (type == 1) {
                            sqlQueryObject = idConfigurazione;
                            var48_53 = null;
                            break block44;
                        }
                        sqlQueryObject = n;
                        break block45;
                    }
                    catch (SQLException se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] SQLException [" + se.getMessage() + "].", se);
                    }
                    catch (Exception se) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] Exception [" + se.getMessage() + "].", se);
                    }
                }
                catch (Throwable var47_59) {
                    var48_55 = null;
                    try {
                        if (selectRS != null) {
                            selectRS.close();
                        }
                        if (selectStmt != null) {
                            selectStmt.close();
                        }
                        if (updateStmt == null) throw var47_59;
                        updateStmt.close();
                        throw var47_59;
                    }
                    catch (Exception e) {
                        throw var47_59;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [7 : 3667->3704)] { 
lbl397:
            // 1 sources

            if (selectRS != null) {
                selectRS.close();
            }
            if (selectStmt != null) {
                selectStmt.close();
            }
            if (updateStmt == null) return sqlQueryObject;
            updateStmt.close();
            return sqlQueryObject;
lbl404:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return sqlQueryObject;
        }
        var48_54 = null;
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject;
        updateStmt.close();
        return sqlQueryObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Connettore getConnettore(long idConnettore, Connection connection) throws DriverConfigurazioneException {
        Connettore connettore;
        Connettore connettore2 = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idConnettore);
                log.debug((Object)("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore)));
                rs = stm.executeQuery();
                if (rs.next()) {
                    String endpoint = rs.getString("endpointtype");
                    if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                        connettore2 = new Connettore();
                        connettore2.setNome(rs.getString("nome_connettore"));
                        connettore2.setTipo(TipiConnettore.DISABILITATO.getNome());
                        connettore2.setId(idConnettore);
                    } else {
                        ConnettoreProperty prop = null;
                        connettore2 = new Connettore();
                        connettore2.setNome(rs.getString("nome_connettore"));
                        connettore2.setTipo(endpoint);
                        connettore2.setId(idConnettore);
                        if (rs.getInt("debug") == 1) {
                            prop = new ConnettoreProperty();
                            prop.setNome("debug");
                            prop.setValore("true");
                            connettore2.addProperty(prop);
                        }
                        if (endpoint.equals("http")) {
                            String value = rs.getString("url");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverConfigurazioneException("Connettore di tipo http possiede una url non definita");
                            if ("".equals(value)) throw new DriverConfigurazioneException("Connettore di tipo http possiede una url non definita");
                            if (" ".equals(value)) {
                                throw new DriverConfigurazioneException("Connettore di tipo http possiede una url non definita");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("location");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                        } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                            String provurl;
                            String urlpkg;
                            String initcont;
                            String pwd;
                            String value = rs.getString("nome");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            if ("".equals(value)) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            if (" ".equals(value)) {
                                throw new DriverConfigurazioneException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("location");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("tipo");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo della coda non definito");
                            if ("".equals(value)) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo della coda non definito");
                            if (" ".equals(value)) {
                                throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo della coda non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("tipo");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("connection_factory");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverConfigurazioneException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            if ("".equals(value)) throw new DriverConfigurazioneException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            if (" ".equals(value)) {
                                throw new DriverConfigurazioneException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("connection-factory");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            value = rs.getString("send_as");
                            if (value != null) {
                                value = value.trim();
                            }
                            if (value == null) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            if ("".equals(value)) throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            if (" ".equals(value)) {
                                throw new DriverConfigurazioneException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                            }
                            prop = new ConnettoreProperty();
                            prop.setNome("send-as");
                            prop.setValore(value);
                            connettore2.addProperty(prop);
                            String usr = rs.getString("utente");
                            if (usr != null && !usr.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("user");
                                prop.setValore(usr);
                                connettore2.addProperty(prop);
                            }
                            if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("password");
                                prop.setValore(pwd);
                                connettore2.addProperty(prop);
                            }
                            if ((initcont = rs.getString("initcont")) != null && !initcont.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.factory.initial");
                                prop.setValore(initcont);
                                connettore2.addProperty(prop);
                            }
                            if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.factory.url.pkgs");
                                prop.setValore(urlpkg);
                                connettore2.addProperty(prop);
                            }
                            if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
                                prop = new ConnettoreProperty();
                                prop.setNome("context-java.naming.provider.url");
                                prop.setValore(provurl);
                                connettore2.addProperty(prop);
                            }
                        } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                            connettore2.setPropertyList(DBUtils.getPropertiesConnettoreConfig(endpoint, connection, tipoDB));
                        }
                    }
                }
                connettore = connettore2;
                Object var17_19 = null;
            }
            catch (SQLException sqle) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
            }
            catch (DriverException e) {
                throw new DriverConfigurazioneException(e);
            }
            catch (Exception sqle) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::getConnettore] Exception : " + sqle.getMessage(), sqle);
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return connettore;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return connettore;
        stm.close();
        return connettore;
    }

    protected static boolean isConnettoreAbilitato(Connettore connettore) {
        if (connettore == null) {
            return false;
        }
        String tipo = connettore.getTipo();
        return !TipiConnettore.DISABILITATO.getNome().equals(tipo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static long getIdConnettore_SA_RISP(long idServizioApplicativo, Connection con) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setLong(1, idServizioApplicativo);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id_connettore_risp");
                }
                l = idConnettore;
                Object var12_10 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static long getIdConnettore_SA_INV(long idServizioApplicativo, Connection con) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setLong(1, idServizioApplicativo);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idConnettore = rs.getLong("id_connettore_inv");
                }
                l = idConnettore;
                Object var12_10 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GestioneErrore getGestioneErrore(long idGestioneErrore, Connection con) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore gestioneErrore;
        GestioneErrore gestioneErrore2 = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("gestione_errore");
                sqlQueryObject.addSelectField("comportamento_default");
                sqlQueryObject.addSelectField("cadenza_rispedizione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id=?");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                log.debug((Object)("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0])));
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idGestioneErrore);
                rs = stm.executeQuery();
                if (!rs.next()) throw new DriverConfigurazioneNotFound("Gestione errore con id[" + idGestioneErrore + "] non presente");
                gestioneErrore2 = new GestioneErrore();
                gestioneErrore2.setId(idGestioneErrore);
                gestioneErrore2.setComportamento(rs.getString("comportamento_default"));
                gestioneErrore2.setCadenzaRispedizione(rs.getString("cadenza_rispedizione"));
                gestioneErrore2.setNome(rs.getString("nome"));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("gestione_errore_trasporto");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, gestioneErrore2.getId());
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    GestioneErroreCodiceTrasporto trasporto = new GestioneErroreCodiceTrasporto();
                    trasporto.setComportamento(rs1.getString("comportamento"));
                    trasporto.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                    if (rs1.getLong("valore_massimo") > 0L) {
                        String maxVal = "" + rs1.getLong("valore_massimo");
                        trasporto.setValoreMassimo(!maxVal.equals("") ? new BigInteger(maxVal) : null);
                    }
                    if (rs1.getLong("valore_minimo") > 0L) {
                        String minVal = "" + rs1.getLong("valore_minimo");
                        trasporto.setValoreMinimo(!minVal.equals("") ? new BigInteger(minVal) : null);
                    }
                    gestioneErrore2.addCodiceTrasporto(trasporto);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("gestione_errore_soap");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_gestione_errore = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, gestioneErrore2.getId());
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    GestioneErroreSoapFault soap = new GestioneErroreSoapFault();
                    soap.setComportamento(rs1.getString("comportamento"));
                    soap.setCadenzaRispedizione(rs1.getString("cadenza_rispedizione"));
                    soap.setFaultActor(rs1.getString("fault_actor"));
                    soap.setFaultCode(rs1.getString("fault_code"));
                    soap.setFaultString(rs1.getString("fault_string"));
                    gestioneErrore2.addSoapFault(soap);
                }
                rs1.close();
                stm1.close();
                rs.close();
                stm.close();
                gestioneErrore = gestioneErrore2;
                Object var13_14 = null;
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException(" SqlException: " + se.getMessage(), se);
            }
            catch (DriverConfigurazioneNotFound e) {
                throw new DriverConfigurazioneNotFound(e);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException(" Exception: " + se.getMessage(), se);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return gestioneErrore;
        }
        if (rs1 != null) {
            rs1.close();
        }
        if (stm1 != null) {
            stm1.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return gestioneErrore;
        stm.close();
        return gestioneErrore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getIdGestioneErrore(String nomeGestioneErrore, Connection con) throws DriverException {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        long idGestioneErrore = -1L;
        try {
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
                sqlQueryObject.addFromTable("gestione_errore");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("nome = ?");
                String query = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(query);
                stm.setString(1, nomeGestioneErrore);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idGestioneErrore = rs.getLong("id");
                }
                l = idGestioneErrore;
                Object var11_10 = null;
            }
            catch (SQLException e) {
                throw new DriverException(e);
            }
            catch (Exception e) {
                throw new DriverException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm == null) throw throwable;
                stm.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return l;
        }
        if (rs != null) {
            rs.close();
        }
        if (stm == null) return l;
        stm.close();
        return l;
    }

    public static long CRUDGestioneErroreServizioApplicativo(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, boolean invocazioneServizio, Connection con) throws DriverConfigurazioneException {
        if (invocazioneServizio) {
            return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 1, con);
        }
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, idSoggettoProprietario, idServizioApplicativo, 2, con);
    }

    public static long CRUDGestioneErroreComponenteCooperazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 3, con);
    }

    public static long CRUDGestioneErroreComponenteIntegrazione(int type, GestioneErrore gestioneErrore, Connection con) throws DriverConfigurazioneException {
        return DriverConfigurazioneDB_LIB.CRUDGestioneErrore(type, gestioneErrore, -1L, -1L, 4, con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long CRUDGestioneErrore(int type, GestioneErrore gestioneErrore, long idSoggettoProprietario, long idServizioApplicativo, int tipoCRUD, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject2;
        if (gestioneErrore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Parametro non valido.");
        }
        String nomeGestioneErrore = null;
        if (tipoCRUD == 1 || tipoCRUD == 2) {
            if (idSoggettoProprietario <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Soggetto proprietario non fornito.");
            }
            if (idServizioApplicativo <= 0L) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Servizio applicativo non fornito.");
            }
            nomeGestioneErrore = "Soggetto(" + idSoggettoProprietario + ")_SA(" + idServizioApplicativo + ")_";
            nomeGestioneErrore = tipoCRUD == 1 ? nomeGestioneErrore + "INV" : nomeGestioneErrore + "RISP";
        } else if (tipoCRUD == 3) {
            nomeGestioneErrore = "componenteCooperazioneGestioneErroreDefaultPdD";
        } else if (tipoCRUD == 4) {
            nomeGestioneErrore = "componenteIntegrazioneGestioneErroreDefaultPdD";
        }
        gestioneErrore.setNome(nomeGestioneErrore);
        int tipoOperazione = type;
        long idGestioneErroreChange = -1L;
        if (type == 2) {
            try {
                idGestioneErroreChange = DriverConfigurazioneDB_LIB.getIdGestioneErrore(nomeGestioneErrore, con);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
            if (idGestioneErroreChange <= 0L) {
                tipoOperazione = 1;
            }
        }
        Statement updateStmt = null;
        Statement selectStmt = null;
        String updateQuery = "";
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            try {
                switch (tipoOperazione) {
                    case 1: {
                        int i;
                        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addInsertTable("gestione_errore");
                        sqlQueryObject2.addInsertField("comportamento_default", "?");
                        sqlQueryObject2.addInsertField("cadenza_rispedizione", "?");
                        sqlQueryObject2.addInsertField("nome", "?");
                        updateQuery = sqlQueryObject2.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, gestioneErrore.getComportamento());
                        updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                        updateStmt.setString(3, gestioneErrore.getNome());
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), gestioneErrore.getNome())));
                        log.debug((Object)("CRUDGestioneErrore type = " + type + " row affected =" + n));
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addFromTable("gestione_errore");
                        sqlQueryObject2.addSelectField("id");
                        sqlQueryObject2.addWhereCondition("nome = ?");
                        selectQuery = sqlQueryObject2.createSQLQuery();
                        selectStmt = con.prepareStatement(selectQuery);
                        selectStmt.setString(1, gestioneErrore.getNome());
                        selectRS = selectStmt.executeQuery();
                        if (!selectRS.next()) throw new Exception("id gestione errore non trovato dopo inserimento con nome [" + gestioneErrore.getNome() + "]");
                        gestioneErrore.setId(selectRS.getLong("id"));
                        selectRS.close();
                        selectStmt.close();
                        if (tipoCRUD == 1 || tipoCRUD == 2) {
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject2.addUpdateTable("servizi_applicativi");
                            if (tipoCRUD == 1) {
                                sqlQueryObject2.addUpdateField("id_gestione_errore_inv", "?");
                            } else {
                                sqlQueryObject2.addUpdateField("id_gestione_errore_risp", "?");
                            }
                            sqlQueryObject2.addWhereCondition("id=?");
                            updateQuery = sqlQueryObject2.createSQLUpdate();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, gestioneErrore.getId());
                            updateStmt.setLong(2, idServizioApplicativo);
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            log.debug((Object)("CRUDGestioneErrore, tipoCRUD: " + tipoCRUD + ", UPDATE TABLE: " + "servizi_applicativi" + ", query:" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), idServizioApplicativo)));
                            log.debug((Object)("CRUDGestioneErrore UPDATE TABLE servizi_applicativi, row affected = " + n));
                        }
                        for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                            GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                            int valoreMassimo = -1;
                            int valoreMinimo = -1;
                            if (tr.getValoreMassimo() != null) {
                                valoreMassimo = tr.getValoreMassimo().intValue();
                            }
                            if (tr.getValoreMinimo() != null) {
                                valoreMinimo = tr.getValoreMinimo().intValue();
                            }
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject2.addInsertTable("gestione_errore_trasporto");
                            sqlQueryObject2.addInsertField("id_gestione_errore", "?");
                            if (valoreMassimo >= 0) {
                                sqlQueryObject2.addInsertField("valore_massimo", "?");
                            }
                            if (valoreMinimo >= 0) {
                                sqlQueryObject2.addInsertField("valore_minimo", "?");
                            }
                            sqlQueryObject2.addInsertField("comportamento", "?");
                            sqlQueryObject2.addInsertField("cadenza_rispedizione", "?");
                            updateQuery = sqlQueryObject2.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            int index = 1;
                            updateStmt.setLong(index, gestioneErrore.getId());
                            ++index;
                            if (valoreMassimo >= 0) {
                                updateStmt.setInt(index, valoreMassimo);
                                ++index;
                            }
                            if (valoreMinimo >= 0) {
                                updateStmt.setInt(index, valoreMinimo);
                                ++index;
                            }
                            updateStmt.setString(index, tr.getComportamento());
                            updateStmt.setString(++index, tr.getCadenzaRispedizione());
                            ++index;
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else if (valoreMassimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else if (valoreMinimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione())));
                            }
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n));
                        }
                        for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                            GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject2.addInsertTable("gestione_errore_soap");
                            sqlQueryObject2.addInsertField("id_gestione_errore", "?");
                            sqlQueryObject2.addInsertField("fault_actor", "?");
                            sqlQueryObject2.addInsertField("fault_code", "?");
                            sqlQueryObject2.addInsertField("fault_string", "?");
                            sqlQueryObject2.addInsertField("comportamento", "?");
                            sqlQueryObject2.addInsertField("cadenza_rispedizione", "?");
                            updateQuery = sqlQueryObject2.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, gestioneErrore.getId());
                            updateStmt.setString(2, sf.getFaultActor());
                            updateStmt.setString(3, sf.getFaultCode());
                            updateStmt.setString(4, sf.getFaultString());
                            updateStmt.setString(5, sf.getComportamento());
                            updateStmt.setString(6, sf.getCadenzaRispedizione());
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione())));
                            log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n));
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        gestioneErrore.setId(idGestioneErroreChange);
                        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addUpdateTable("gestione_errore");
                        sqlQueryObject2.addUpdateField("comportamento_default", "?");
                        sqlQueryObject2.addUpdateField("cadenza_rispedizione", "?");
                        sqlQueryObject2.addWhereCondition("id=?");
                        sqlQueryObject2.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject2.createSQLUpdate();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setString(1, gestioneErrore.getComportamento());
                        updateStmt.setString(2, gestioneErrore.getCadenzaRispedizione());
                        updateStmt.setLong(3, idGestioneErroreChange);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore UPDATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getComportamento(), gestioneErrore.getCadenzaRispedizione(), idGestioneErroreChange)));
                        log.debug((Object)("CRUGestioneErrore type = " + type + " row affected =" + n));
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addDeleteTable("gestione_errore_trasporto");
                        sqlQueryObject2.addWhereCondition("id_gestione_errore=?");
                        updateQuery = sqlQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idGestioneErroreChange);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore (Delete old trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange)));
                        log.debug((Object)("CRUGestioneErrore (Delete old trasporto) type = " + type + " row affected =" + n));
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addDeleteTable("gestione_errore_soap");
                        sqlQueryObject2.addWhereCondition("id_gestione_errore=?");
                        updateQuery = sqlQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idGestioneErroreChange);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore (Delete old soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErroreChange)));
                        log.debug((Object)("CRUGestioneErrore (Delete old soap fault) type = " + type + " row affected =" + n));
                        for (i = 0; i < gestioneErrore.sizeCodiceTrasportoList(); ++i) {
                            GestioneErroreCodiceTrasporto tr = gestioneErrore.getCodiceTrasporto(i);
                            int valoreMassimo = -1;
                            int valoreMinimo = -1;
                            if (tr.getValoreMassimo() != null) {
                                valoreMassimo = tr.getValoreMassimo().intValue();
                            }
                            if (tr.getValoreMinimo() != null) {
                                valoreMinimo = tr.getValoreMinimo().intValue();
                            }
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject2.addInsertTable("gestione_errore_trasporto");
                            sqlQueryObject2.addInsertField("id_gestione_errore", "?");
                            if (valoreMassimo >= 0) {
                                sqlQueryObject2.addInsertField("valore_massimo", "?");
                            }
                            if (valoreMinimo >= 0) {
                                sqlQueryObject2.addInsertField("valore_minimo", "?");
                            }
                            sqlQueryObject2.addInsertField("comportamento", "?");
                            sqlQueryObject2.addInsertField("cadenza_rispedizione", "?");
                            updateQuery = sqlQueryObject2.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            int index = 1;
                            updateStmt.setLong(index, gestioneErrore.getId());
                            ++index;
                            if (valoreMassimo >= 0) {
                                updateStmt.setInt(index, valoreMassimo);
                                ++index;
                            }
                            if (valoreMinimo >= 0) {
                                updateStmt.setInt(index, valoreMinimo);
                                ++index;
                            }
                            updateStmt.setString(index, tr.getComportamento());
                            updateStmt.setString(++index, tr.getCadenzaRispedizione());
                            ++index;
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            if (valoreMassimo >= 0 && valoreMinimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else if (valoreMassimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMassimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else if (valoreMinimo >= 0) {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), valoreMinimo, tr.getComportamento(), tr.getCadenzaRispedizione())));
                            } else {
                                log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), tr.getComportamento(), tr.getCadenzaRispedizione())));
                            }
                            log.debug((Object)("CRUDGestioneErrore_Trasporto(" + i + ") type = " + type + " row affected =" + n));
                        }
                        for (i = 0; i < gestioneErrore.sizeSoapFaultList(); ++i) {
                            GestioneErroreSoapFault sf = gestioneErrore.getSoapFault(i);
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                            sqlQueryObject2.addInsertTable("gestione_errore_soap");
                            sqlQueryObject2.addInsertField("id_gestione_errore", "?");
                            sqlQueryObject2.addInsertField("fault_actor", "?");
                            sqlQueryObject2.addInsertField("fault_code", "?");
                            sqlQueryObject2.addInsertField("fault_string", "?");
                            sqlQueryObject2.addInsertField("comportamento", "?");
                            sqlQueryObject2.addInsertField("cadenza_rispedizione", "?");
                            updateQuery = sqlQueryObject2.createSQLInsert();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, gestioneErrore.getId());
                            updateStmt.setString(2, sf.getFaultActor());
                            updateStmt.setString(3, sf.getFaultCode());
                            updateStmt.setString(4, sf.getFaultString());
                            updateStmt.setString(5, sf.getComportamento());
                            updateStmt.setString(6, sf.getCadenzaRispedizione());
                            n = updateStmt.executeUpdate();
                            updateStmt.close();
                            log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") CREATE : \n" + DBUtils.formatSQLString(updateQuery, gestioneErrore.getId(), sf.getFaultActor(), sf.getFaultCode(), sf.getFaultString(), sf.getComportamento(), sf.getCadenzaRispedizione())));
                            log.debug((Object)("CRUDGestioneErrore_SoapFault(" + i + ") type = " + type + " row affected =" + n));
                        }
                        break;
                    }
                    case 3: {
                        long idGestioneErrore = DriverConfigurazioneDB_LIB.getIdGestioneErrore(nomeGestioneErrore, con);
                        gestioneErrore.setId(idGestioneErrore);
                        if (idGestioneErrore <= 0L) break;
                        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addDeleteTable("gestione_errore_trasporto");
                        sqlQueryObject2.addWhereCondition("id_gestione_errore=?");
                        updateQuery = sqlQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idGestioneErrore);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore (Delete trasporto) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                        log.debug((Object)("CRUGestioneErrore (Delete trasporto) type = " + type + " row affected =" + n));
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addDeleteTable("gestione_errore_soap");
                        sqlQueryObject2.addWhereCondition("id_gestione_errore=?");
                        updateQuery = sqlQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idGestioneErrore);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore (Delete soap fault) UPDATE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                        log.debug((Object)("CRUGestioneErrore (Delete soap fault) type = " + type + " row affected =" + n));
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipoDB);
                        sqlQueryObject2.addDeleteTable("gestione_errore");
                        sqlQueryObject2.addWhereCondition("id=?");
                        updateQuery = sqlQueryObject2.createSQLDelete();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idGestioneErrore);
                        n = updateStmt.executeUpdate();
                        updateStmt.close();
                        log.debug((Object)("CRUDGestioneErrore type = " + type + " row affected =" + n));
                        log.debug((Object)("CRUDGestioneErrore DELETE : \n" + DBUtils.formatSQLString(updateQuery, idGestioneErrore)));
                        break;
                    }
                }
                sqlQueryObject2 = n;
                Object var25_31 = null;
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] SQLException [" + se.getMessage() + "].", se);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDGestioneErrore] Exception [" + se.getMessage() + "].", se);
            }
        }
        catch (Throwable throwable) {
            Object var25_32 = null;
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
                if (updateStmt == null) throw throwable;
                updateStmt.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return sqlQueryObject2;
        }
        if (selectRS != null) {
            selectRS.close();
        }
        if (selectStmt != null) {
            selectStmt.close();
        }
        if (updateStmt == null) return sqlQueryObject2;
        updateStmt.close();
        return sqlQueryObject2;
    }
}

