/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.dao.driver;

import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.firma.Firma;
import it.gov.spcoop.sica.manifest.AccordoServizio;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.driver.XMLUtilsException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.activation.FileDataSource;

public class XMLUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteComune getAccordoServizioParteComune(byte[] zip) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "apc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioParteComune = XMLUtils.getAccordoServizioParteComune(tmp);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioParteComune;
        tmp.delete();
        return accordoServizioParteComune;
    }

    public static AccordoServizioParteComune getAccordoServizioParteComune(String fileName) throws XMLUtilsException {
        return XMLUtils.getAccordoServizioParteComune(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteComune getAccordoServizioParteComune(File zip) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioParteComune = XMLUtils.getAccordoServizioParteComune(zipFile);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (zipFile == null) return accordoServizioParteComune;
        zipFile.close();
        return accordoServizioParteComune;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteComune getAccordoServizioParteComune(InputStream m) throws XMLUtilsException {
        AccordoServizioParteComune accordoServizioParteComune;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioParteComune = XMLUtils.getAccordoServizioParteComune(bout.toByteArray());
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteComune;
        }
        if (bout == null) return accordoServizioParteComune;
        bout.close();
        return accordoServizioParteComune;
    }

    public static AccordoServizioParteComune getAccordoServizioParteComune(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoServizioParteComune archivio = new AccordoServizioParteComune();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ("firma.xml".equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ("manifesto.xml".equals(entry.getName())) {
                    inputStream = zip.getInputStream(entry);
                    AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(inputStream);
                    if (manifesto.getParteComune() == null) {
                        throw new Exception("Manifest Parte Comune non presente");
                    }
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entry.getName().startsWith("specificaConversazione")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = "specificaConversazione" + File.separatorChar;
                    if ((dir + "ConversazioneConcettuale.wsbl").equals(entry.getName())) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + "ConversazioneLogicaLatoErogatore.wsbl").equals(entry.getName())) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + "ConversazioneLogicaLatoFruitore.wsbl").equals(entry.getName())) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith("specificaInterfaccia")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = "specificaInterfaccia" + File.separatorChar;
                    if ((dir + "InterfacciaConcettuale.wsdl").equals(entry.getName())) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + "InterfacciaLogicaErogatore.wsdl").equals(entry.getName())) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + "InterfacciaLogicaFruitore.wsdl").equals(entry.getName())) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith("allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (!entry.getName().startsWith("specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
                if (!"ProfiloDiCollaborazione.xml".equals(nome)) continue;
                it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(d.getContenuto());
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            for (int i = 0; i < archivio.getManifesto().sizeSpecificaSemiformaleList(); ++i) {
                String fileName = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getBase();
                String tipo = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getTipo();
                for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                    archivio.getSpecificaSemiformale(j).setTipo(tipo);
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                XMLUtils.generateAccordoServizioParteComune(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                XMLUtils.generateAccordoServizioParteComune(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public static byte[] generateAccordoServizioParteComune(AccordoServizioParteComune manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.generateAccordoServizioParteComune(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteComune(AccordoServizioParteComune manifesto, OutputStream out) throws XMLUtilsException {
        ZipOutputStream zipOut = null;
        try {
            try {
                int i;
                zipOut = new ZipOutputStream(out);
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry("firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto());
                zipOut.putNextEntry(new ZipEntry("manifesto.xml"));
                zipOut.write(manifestoBytes);
                if (manifesto.getInterfacciaConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                    zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                }
                if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                }
                if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                }
                if (manifesto.getConversazioneConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                    zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                }
                if (manifesto.getConversazioneLogicaErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                }
                if (manifesto.getConversazioneLogicaFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                }
                for (i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry("allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry("specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(byte[] zip) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "aps");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioParteSpecifica = XMLUtils.getAccordoServizioParteSpecifica(tmp);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioParteSpecifica;
        tmp.delete();
        return accordoServizioParteSpecifica;
    }

    public static AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(String fileName) throws XMLUtilsException {
        return XMLUtils.getAccordoServizioParteSpecifica(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(File zip) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioParteSpecifica = XMLUtils.getAccordoServizioParteSpecifica(zipFile);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (zipFile == null) return accordoServizioParteSpecifica;
        zipFile.close();
        return accordoServizioParteSpecifica;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(InputStream m) throws XMLUtilsException {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioParteSpecifica = XMLUtils.getAccordoServizioParteSpecifica(bout.toByteArray());
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioParteSpecifica;
        }
        if (bout == null) return accordoServizioParteSpecifica;
        bout.close();
        return accordoServizioParteSpecifica;
    }

    public static AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(ZipFile zip) throws XMLUtilsException {
        try {
            String fileName;
            int i;
            AccordoServizioParteSpecifica archivio = new AccordoServizioParteSpecifica();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i2 = 0; i2 < fixed.length(); ++i2) {
                    if (fixed.charAt(i2) != '/') continue;
                    fixed.setCharAt(i2, File.separatorChar);
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ("firma.xml".equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ("manifesto.xml".equals(entry.getName())) {
                    inputStream = zip.getInputStream(entry);
                    AccordoServizio manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAS(inputStream);
                    if (manifesto.getParteSpecifica() == null) {
                        throw new Exception("Manifest Parte Specifica non presente");
                    }
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entry.getName().startsWith("specificaPortiAccesso")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    String dir = "specificaPortiAccesso" + File.separatorChar;
                    if ((dir + "PortiAccessoErogatore.wsdl").equals(entry.getName())) {
                        archivio.setPortiAccessoErogatore(d);
                        continue;
                    }
                    if (!(dir + "PortiAccessoFruitore.wsdl").equals(entry.getName())) continue;
                    archivio.setPortiAccessoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith("allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (entry.getName().startsWith("specificaLivelliServizio")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaLivelloServizio(d);
                    continue;
                }
                if (entry.getName().startsWith("specificaSemiformale")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaSemiformale(d);
                    continue;
                }
                if (!entry.getName().startsWith("specificaSicurezza")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSicurezza(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            for (i = 0; i < archivio.getManifesto().sizeSpecificaSemiformaleList(); ++i) {
                fileName = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getBase();
                String tipo = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getTipo();
                for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                    archivio.getSpecificaSemiformale(j).setTipo(tipo);
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio() != null) {
                for (i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().sizeDocumentoLivelloServizioList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getBase();
                    String tipo = archivio.getManifesto().getParteSpecifica().getSpecificaLivelliServizio().getDocumentoLivelloServizio(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheLivelliServizio(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaLivelloServizio(j).getNome())) continue;
                        archivio.getSpecificaLivelloServizio(j).setTipo(tipo);
                    }
                }
            }
            if (archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza() != null) {
                for (i = 0; i < archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().sizeDocumentoSicurezzaList(); ++i) {
                    fileName = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getBase();
                    String tipo = archivio.getManifesto().getParteSpecifica().getSpecificaSicurezza().getDocumentoSicurezza(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheSicurezza(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaSicurezza(j).getNome())) continue;
                        archivio.getSpecificaSicurezza(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                XMLUtils.generateAccordoServizioParteSpecifica(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                XMLUtils.generateAccordoServizioParteSpecifica(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public static byte[] generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.generateAccordoServizioParteSpecifica(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica manifesto, OutputStream out) throws XMLUtilsException {
        ZipOutputStream zipOut = null;
        try {
            try {
                Documento doc;
                int i;
                zipOut = new ZipOutputStream(out);
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry("firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAS(manifesto.getManifesto());
                zipOut.putNextEntry(new ZipEntry("manifesto.xml"));
                zipOut.write(manifestoBytes);
                if (manifesto.getPortiAccessoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaPortiAccesso" + File.separatorChar + "PortiAccessoErogatore.wsdl"));
                    zipOut.write(manifesto.getPortiAccessoErogatore().getContenuto());
                }
                if (manifesto.getPortiAccessoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaPortiAccesso" + File.separatorChar + "PortiAccessoFruitore.wsdl"));
                    zipOut.write(manifesto.getPortiAccessoFruitore().getContenuto());
                }
                for (i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry("allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheLivelliServizio(); ++i) {
                    doc = manifesto.getSpecificaLivelloServizio(i);
                    zipOut.putNextEntry(new ZipEntry("specificaLivelliServizio" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry("specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheSicurezza(); ++i) {
                    doc = manifesto.getSpecificaSicurezza(i);
                    zipOut.putNextEntry(new ZipEntry("specificaSicurezza" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoCooperazione getAccordoCooperazione(byte[] zip) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "adc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoCooperazione = XMLUtils.getAccordoCooperazione(tmp);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoCooperazione;
        tmp.delete();
        return accordoCooperazione;
    }

    public static AccordoCooperazione getAccordoCooperazione(String fileName) throws XMLUtilsException {
        return XMLUtils.getAccordoCooperazione(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoCooperazione getAccordoCooperazione(File zip) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoCooperazione = XMLUtils.getAccordoCooperazione(zipFile);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (zipFile == null) return accordoCooperazione;
        zipFile.close();
        return accordoCooperazione;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoCooperazione getAccordoCooperazione(InputStream m) throws XMLUtilsException {
        AccordoCooperazione accordoCooperazione;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoCooperazione = XMLUtils.getAccordoCooperazione(bout.toByteArray());
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoCooperazione;
        }
        if (bout == null) return accordoCooperazione;
        bout.close();
        return accordoCooperazione;
    }

    public static AccordoCooperazione getAccordoCooperazione(ZipFile zip) throws XMLUtilsException {
        try {
            AccordoCooperazione archivio = new AccordoCooperazione();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i = 0; i < fixed.length(); ++i) {
                    if (fixed.charAt(i) != '/') continue;
                    fixed.setCharAt(i, File.separatorChar);
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ("firma.xml".equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ("manifesto.xml".equals(entry.getName())) {
                    inputStream = zip.getInputStream(entry);
                    it.gov.spcoop.sica.manifest.AccordoCooperazione manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoAC(inputStream);
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entry.getName().startsWith("allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (!entry.getName().startsWith("specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            for (int i = 0; i < archivio.getManifesto().sizeSpecificaSemiformaleList(); ++i) {
                String fileName = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getBase();
                String tipo = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getTipo();
                for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                    archivio.getSpecificaSemiformale(j).setTipo(tipo);
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoCooperazione(AccordoCooperazione manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                XMLUtils.generateAccordoCooperazione(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoCooperazione(AccordoCooperazione manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                XMLUtils.generateAccordoCooperazione(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public static byte[] generateAccordoCooperazione(AccordoCooperazione manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.generateAccordoCooperazione(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoCooperazione(AccordoCooperazione manifesto, OutputStream out) throws XMLUtilsException {
        ZipOutputStream zipOut = null;
        try {
            try {
                int i;
                zipOut = new ZipOutputStream(out);
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry("firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoAC(manifesto.getManifesto());
                zipOut.putNextEntry(new ZipEntry("manifesto.xml"));
                zipOut.write(manifestoBytes);
                for (i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry("allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    Documento doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry("specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioComposto getAccordoServizioComposto(byte[] zip) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        File tmp = null;
        FileOutputStream fout = null;
        try {
            try {
                tmp = File.createTempFile("sica", "asc");
                fout = new FileOutputStream(tmp);
                fout.write(zip);
                fout.flush();
                fout.close();
                accordoServizioComposto = XMLUtils.getAccordoServizioComposto(tmp);
                Object var5_5 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp == null) throw throwable;
                tmp.delete();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (fout != null) {
            fout.close();
        }
        if (tmp == null) return accordoServizioComposto;
        tmp.delete();
        return accordoServizioComposto;
    }

    public static AccordoServizioComposto getAccordoServizioComposto(String fileName) throws XMLUtilsException {
        return XMLUtils.getAccordoServizioComposto(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioComposto getAccordoServizioComposto(File zip) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(zip);
                accordoServizioComposto = XMLUtils.getAccordoServizioComposto(zipFile);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (zipFile == null) throw throwable;
                zipFile.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (zipFile == null) return accordoServizioComposto;
        zipFile.close();
        return accordoServizioComposto;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AccordoServizioComposto getAccordoServizioComposto(InputStream m) throws XMLUtilsException {
        AccordoServizioComposto accordoServizioComposto;
        ByteArrayOutputStream bout = null;
        try {
            try {
                bout = new ByteArrayOutputStream();
                byte[] read = new byte[1024];
                int letti = 0;
                while ((letti = m.read(read)) >= 0) {
                    bout.write(read, 0, letti);
                }
                bout.flush();
                bout.close();
                m.close();
                accordoServizioComposto = XMLUtils.getAccordoServizioComposto(bout.toByteArray());
                Object var6_6 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bout == null) throw throwable;
                bout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return accordoServizioComposto;
        }
        if (bout == null) return accordoServizioComposto;
        bout.close();
        return accordoServizioComposto;
    }

    public static AccordoServizioComposto getAccordoServizioComposto(ZipFile zip) throws XMLUtilsException {
        try {
            String fileName;
            int i;
            AccordoServizioComposto archivio = new AccordoServizioComposto();
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                String dir;
                Documento d;
                InputStream inputStream;
                ZipEntry entry = e.nextElement();
                StringBuffer fixed = new StringBuffer(entry.getName());
                for (int i2 = 0; i2 < fixed.length(); ++i2) {
                    if (fixed.charAt(i2) != '/') continue;
                    fixed.setCharAt(i2, File.separatorChar);
                }
                if (entry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entry.getName());
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                if ("firma.xml".equals(entry.getName())) {
                    Firma firma = new Firma();
                    archivio.setFirma(firma);
                    continue;
                }
                if ("manifesto.xml".equals(entry.getName())) {
                    inputStream = zip.getInputStream(entry);
                    ServizioComposto manifesto = it.gov.spcoop.sica.manifest.driver.XMLUtils.getManifestoSC(inputStream);
                    inputStream.close();
                    archivio.setManifesto(manifesto);
                    continue;
                }
                if (entry.getName().startsWith("specificaConversazione")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = "specificaConversazione" + File.separatorChar;
                    if ((dir + "ConversazioneConcettuale.wsbl").equals(entry.getName())) {
                        archivio.setConversazioneConcettuale(d);
                        continue;
                    }
                    if ((dir + "ConversazioneLogicaLatoErogatore.wsbl").equals(entry.getName())) {
                        archivio.setConversazioneLogicaErogatore(d);
                        continue;
                    }
                    if (!(dir + "ConversazioneLogicaLatoFruitore.wsbl").equals(entry.getName())) continue;
                    archivio.setConversazioneLogicaFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith("specificaInterfaccia")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    dir = "specificaInterfaccia" + File.separatorChar;
                    if ((dir + "InterfacciaConcettuale.wsdl").equals(entry.getName())) {
                        archivio.setInterfacciaConcettuale(d);
                        continue;
                    }
                    if ((dir + "InterfacciaLogicaErogatore.wsdl").equals(entry.getName())) {
                        archivio.setInterfacciaLogicaLatoErogatore(d);
                        continue;
                    }
                    if (!(dir + "InterfacciaLogicaFruitore.wsdl").equals(entry.getName())) continue;
                    archivio.setInterfacciaLogicaLatoFruitore(d);
                    continue;
                }
                if (entry.getName().startsWith("specificaCoordinamento")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addSpecificaCoordinamento(d);
                    continue;
                }
                if (entry.getName().startsWith("allegati")) {
                    inputStream = zip.getInputStream(entry);
                    d = new Documento(nome, tipo, inputStream);
                    inputStream.close();
                    archivio.addAllegato(d);
                    continue;
                }
                if (!entry.getName().startsWith("specificaSemiformale")) continue;
                inputStream = zip.getInputStream(entry);
                d = new Documento(nome, tipo, inputStream);
                inputStream.close();
                archivio.addSpecificaSemiformale(d);
            }
            if (archivio.getManifesto() == null) {
                throw new Exception("Manifesto non presente");
            }
            for (i = 0; i < archivio.getManifesto().sizeSpecificaSemiformaleList(); ++i) {
                fileName = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getBase();
                String tipo = archivio.getManifesto().getSpecificaSemiformale(i).getDocumentoSemiformale().getTipo();
                for (int j = 0; j < archivio.sizeSpecificheSemiformali(); ++j) {
                    if (!fileName.equals(archivio.getSpecificaSemiformale(j).getNome())) continue;
                    archivio.getSpecificaSemiformale(j).setTipo(tipo);
                }
            }
            if (archivio.getManifesto().getSpecificaCoordinamento() != null) {
                for (i = 0; i < archivio.getManifesto().getSpecificaCoordinamento().sizeDocumentoCoordinamentoList(); ++i) {
                    fileName = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getBase();
                    String tipo = archivio.getManifesto().getSpecificaCoordinamento().getDocumentoCoordinamento(i).getTipo();
                    for (int j = 0; j < archivio.sizeSpecificheCoordinamento(); ++j) {
                        if (!fileName.equals(archivio.getSpecificaCoordinamento(j).getNome())) continue;
                        archivio.getSpecificaCoordinamento(j).setTipo(tipo);
                    }
                }
            }
            return archivio;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioComposto(AccordoServizioComposto manifesto, File file) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(file);
                XMLUtils.generateAccordoServizioComposto(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioComposto(AccordoServizioComposto manifesto, String fileName) throws XMLUtilsException {
        FileOutputStream fout = null;
        try {
            try {
                fout = new FileOutputStream(fileName);
                XMLUtils.generateAccordoServizioComposto(manifesto, fout);
                fout.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (fout == null) throw throwable;
                fout.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (fout == null) return;
        fout.close();
        return;
    }

    public static byte[] generateAccordoServizioComposto(AccordoServizioComposto manifesto) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.generateAccordoServizioComposto(manifesto, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void generateAccordoServizioComposto(AccordoServizioComposto manifesto, OutputStream out) throws XMLUtilsException {
        ZipOutputStream zipOut = null;
        try {
            try {
                Documento doc;
                int i;
                zipOut = new ZipOutputStream(out);
                if (manifesto.getFirma() != null) {
                    byte[] firma = manifesto.getFirma().getBytes();
                    zipOut.putNextEntry(new ZipEntry("firma.xml"));
                    zipOut.write(firma);
                }
                byte[] manifestoBytes = it.gov.spcoop.sica.manifest.driver.XMLUtils.generateManifestoSC(manifesto.getManifesto());
                zipOut.putNextEntry(new ZipEntry("manifesto.xml"));
                zipOut.write(manifestoBytes);
                if (manifesto.getInterfacciaConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaConcettuale.wsdl"));
                    zipOut.write(manifesto.getInterfacciaConcettuale().getContenuto());
                }
                if (manifesto.getInterfacciaLogicaLatoErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoErogatore().getContenuto());
                }
                if (manifesto.getInterfacciaLogicaLatoFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaInterfaccia" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl"));
                    zipOut.write(manifesto.getInterfacciaLogicaLatoFruitore().getContenuto());
                }
                if (manifesto.getConversazioneConcettuale() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneConcettuale.wsbl"));
                    zipOut.write(manifesto.getConversazioneConcettuale().getContenuto());
                }
                if (manifesto.getConversazioneLogicaErogatore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoErogatore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaErogatore().getContenuto());
                }
                if (manifesto.getConversazioneLogicaFruitore() != null) {
                    zipOut.putNextEntry(new ZipEntry("specificaConversazione" + File.separatorChar + "ConversazioneLogicaLatoFruitore.wsbl"));
                    zipOut.write(manifesto.getConversazioneLogicaFruitore().getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheCoordinamento(); ++i) {
                    doc = manifesto.getSpecificaCoordinamento(i);
                    zipOut.putNextEntry(new ZipEntry("specificaCoordinamento" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                for (i = 0; i < manifesto.sizeAllegati(); ++i) {
                    Documento allegato = manifesto.getAllegato(i);
                    zipOut.putNextEntry(new ZipEntry("allegati" + File.separatorChar + allegato.getNome()));
                    zipOut.write(allegato.getContenuto());
                }
                for (i = 0; i < manifesto.sizeSpecificheSemiformali(); ++i) {
                    doc = manifesto.getSpecificaSemiformale(i);
                    zipOut.putNextEntry(new ZipEntry("specificaSemiformale" + File.separatorChar + doc.getNome()));
                    zipOut.write(doc.getContenuto());
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (zipOut == null) throw throwable;
                zipOut.close();
                throw throwable;
            }
            catch (Exception eClose) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception eClose) {}
        if (zipOut == null) return;
        zipOut.close();
        return;
    }
}

