/*
 * Decompiled with CFR 0.152.
 */
package it.gov.spcoop.sica.dao.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.driver.TipiProfiliCollaborazione;
import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.dao.driver.XMLUtils;
import it.gov.spcoop.sica.manifest.AccordoServizio;
import it.gov.spcoop.sica.manifest.DocumentoConversazione;
import it.gov.spcoop.sica.manifest.DocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.DocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.DocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.DocumentoSicurezza;
import it.gov.spcoop.sica.manifest.ElencoAllegati;
import it.gov.spcoop.sica.manifest.ElencoPartecipanti;
import it.gov.spcoop.sica.manifest.ElencoServiziComponenti;
import it.gov.spcoop.sica.manifest.ElencoServiziComposti;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaCoordinamento;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaLivelliServizio;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.SpecificaSemiformale;
import it.gov.spcoop.sica.manifest.SpecificaSicurezza;
import it.gov.spcoop.sica.manifest.driver.TipiAdesione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoConversazione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSicurezza;
import java.util.Date;
import org.openspcoop.dao.registry.driver.SICAtoOpenSPCoopUtilities;

public class ClientTest {
    public static final String wsdlImplementativo = "<wsdl:definitions targetNamespace=\"http://openspcoop.org/Example/service\" \nxmlns:apachesoap=\"http://xml.apache.org/xml-soap\" xmlns:service=\"http://openspcoop.org/Example/service\"\n xmlns:types=\"http://openspcoop.org/Example/types\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"\n xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" >\n   \n\t<!-- Example KEYWORD -->  \n\t\n\t\t<wsdl:import namespace=\"http://openspcoop.org/Example/service\" location=\"logicoKEYWORD.wsdl\" />\n  \t\t <wsdl:binding name=\"ExampleSoapBinding\" type=\"service:Example\">\n\t\t\t<wsdlsoap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>\n\t\t\t<wsdl:operation name=\"movOneWayRequest\">\n\t\t\t\t<wsdlsoap:operation soapAction=\"Example\"/>\n\t\t\t\t<wsdl:input name=\"movOneWayRequest\">\n\t\t\t\t\t\t<wsdlsoap:body use=\"literal\"/>\n\t\t\t\t</wsdl:input>\n\t\t\t</wsdl:operation>\n\t\t</wsdl:binding>\n\n\t\t<wsdl:service name=\"ExampleService\">\n\t\t\t<wsdl:port binding=\"service:ExampleSoapBinding\" name=\"Example\">\n\t\t\t\t<wsdlsoap:address location=\"http://localhost:8080/exampleKEYWORD/service\"/>\n\t\t\t</wsdl:port>\n\t\t</wsdl:service>\n</wsdl:definitions>";

    public static void main(String[] args) {
        try {
            AccordoServizioParteComune asPC = new AccordoServizioParteComune();
            AccordoServizio manAsPC = ClientTest.getManifestoAS_ParteComune();
            asPC.setManifesto(manAsPC);
            Documento dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            Documento dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            asPC.addAllegato(dAllegato1);
            asPC.addAllegato(dAllegato2);
            Documento dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            Documento dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            asPC.addSpecificaSemiformale(dSS1);
            asPC.addSpecificaSemiformale(dSS2);
            Documento conversazioneConcettuale = new Documento("ConversazioneConcettuale.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>concettuale</wsbl>".getBytes());
            asPC.setConversazioneConcettuale(conversazioneConcettuale);
            Documento conversazioneLogicaErogatore = new Documento("ConversazioneLogicaLatoErogatore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>erogatore</wsbl>".getBytes());
            asPC.setConversazioneLogicaErogatore(conversazioneLogicaErogatore);
            Documento conversazioneLogicaFruitore = new Documento("ConversazioneLogicaLatoFruitore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>fruitore</wsbl>".getBytes());
            asPC.setConversazioneLogicaFruitore(conversazioneLogicaFruitore);
            Documento interfacciaConcettuale = new Documento("InterfacciaConcettuale.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>concettuale</wsdl>".getBytes());
            asPC.setInterfacciaConcettuale(interfacciaConcettuale);
            Documento interfacciaLogicaErogatore = new Documento("InterfacciaLogicaErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>erogatore</wsdl>".getBytes());
            asPC.setInterfacciaLogicaLatoErogatore(interfacciaLogicaErogatore);
            Documento interfacciaLogicaFruitore = new Documento("InterfacciaLogicaFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>fruitore</wsdl>".getBytes());
            asPC.setInterfacciaLogicaLatoFruitore(interfacciaLogicaFruitore);
            EgovDecllElement dichiarazioneEGov = ClientTest.getDichiarazioneEGov(manAsPC.getNome());
            byte[] egovBytes = it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov(dichiarazioneEGov);
            Documento docModalitaEsplicitaCNIPA = new Documento("ProfiloDiCollaborazione.xml", TipiDocumentoSemiformale.XML.toString(), egovBytes);
            asPC.addSpecificaSemiformale(docModalitaEsplicitaCNIPA);
            Documento dAllegatoDEFINITORIO = new Documento("InterfacciaDefinitoria.xsd", "XSD", "<xsd>DEFINITORIO</xsd>".getBytes());
            asPC.addAllegato(dAllegatoDEFINITORIO);
            String fileName = "package.apc";
            XMLUtils.generateAccordoServizioParteComune(asPC, fileName);
            XMLUtils.getAccordoServizioParteComune(fileName);
            AccordoServizioParteSpecifica asPS = new AccordoServizioParteSpecifica();
            AccordoServizio manAsPS = ClientTest.getManifestoAS_ParteSpecifica();
            asPS.setManifesto(manAsPS);
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            asPS.addAllegato(dAllegato1);
            asPS.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            asPS.addSpecificaSemiformale(dSS1);
            asPS.addSpecificaSemiformale(dSS2);
            Documento portiAccessoErogatore = new Documento("PortiAccessoErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), wsdlImplementativo.replaceAll("KEYWORD", "EROGATORE").getBytes());
            asPS.setPortiAccessoErogatore(portiAccessoErogatore);
            Documento portiAccessoFruitore = new Documento("PortiAccessoFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), wsdlImplementativo.replaceAll("KEYWORD", "FRUITORE").getBytes());
            asPS.setPortiAccessoFruitore(portiAccessoFruitore);
            Documento servizioMinimo = new Documento("LivelloServizioMinimo.wsla", TipiDocumentoLivelloServizio.WSLA.toString(), "<sla>minimo</sla>".getBytes());
            asPS.addSpecificaLivelloServizio(servizioMinimo);
            Documento servizioMax = new Documento("LivelloServizioOttimale.wsla", TipiDocumentoLivelloServizio.WSLA.toString(), "<sla>max</sla>".getBytes());
            asPS.addSpecificaLivelloServizio(servizioMax);
            Documento sicurezza1 = new Documento("SicurezzaDelCanale.wspolicy", TipiDocumentoSicurezza.WSPOLICY.toString(), "<sec>wss</sec>".getBytes());
            asPS.addSpecificaSicurezza(sicurezza1);
            Documento sicurezza2 = new Documento("LineeGuida.doc", TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString(), "LINEE GUIDA".getBytes());
            asPS.addSpecificaSicurezza(sicurezza2);
            fileName = "package.aps";
            XMLUtils.generateAccordoServizioParteSpecifica(asPS, fileName);
            XMLUtils.getAccordoServizioParteSpecifica(fileName);
            fileName = "package2.aps";
            asPS.getManifesto().setNome(asPS.getManifesto().getNome() + "2");
            XMLUtils.generateAccordoServizioParteSpecifica(asPS, fileName);
            AccordoCooperazione ac = new AccordoCooperazione();
            ac.setManifesto(ClientTest.getManifestoAC());
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            ac.addAllegato(dAllegato1);
            ac.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            ac.addSpecificaSemiformale(dSS1);
            ac.addSpecificaSemiformale(dSS2);
            fileName = "package.adc";
            XMLUtils.generateAccordoCooperazione(ac, fileName);
            XMLUtils.getAccordoCooperazione(fileName);
            AccordoServizioComposto aSC = new AccordoServizioComposto();
            ServizioComposto manASC = ClientTest.getManifestoASComposto();
            aSC.setManifesto(manASC);
            dAllegato1 = new Documento("Allegato1.doc", "DOC", "PROVA".getBytes());
            dAllegato2 = new Documento("Allegato2.doc", "DOC", "PROVA2".getBytes());
            aSC.addAllegato(dAllegato1);
            aSC.addAllegato(dAllegato2);
            dSS1 = new Documento("Collaborazione.doc", TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString(), "SS".getBytes());
            dSS2 = new Documento("Schemi.xml", TipiDocumentoSemiformale.XML.toString(), "<test/>".getBytes());
            aSC.addSpecificaSemiformale(dSS1);
            aSC.addSpecificaSemiformale(dSS2);
            conversazioneConcettuale = new Documento("ConversazioneConcettuale.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>concettuale</wsbl>".getBytes());
            aSC.setConversazioneConcettuale(conversazioneConcettuale);
            conversazioneLogicaErogatore = new Documento("ConversazioneLogicaLatoErogatore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>erogatore</wsbl>".getBytes());
            aSC.setConversazioneLogicaErogatore(conversazioneLogicaErogatore);
            conversazioneLogicaFruitore = new Documento("ConversazioneLogicaLatoFruitore.wsbl", TipiDocumentoConversazione.WSBL.toString(), "<wsbl>fruitore</wsbl>".getBytes());
            aSC.setConversazioneLogicaFruitore(conversazioneLogicaFruitore);
            interfacciaConcettuale = new Documento("InterfacciaConcettuale.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>concettuale</wsdl>".getBytes());
            aSC.setInterfacciaConcettuale(interfacciaConcettuale);
            interfacciaLogicaErogatore = new Documento("InterfacciaLogicaErogatore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>erogatore</wsdl>".getBytes());
            aSC.setInterfacciaLogicaLatoErogatore(interfacciaLogicaErogatore);
            interfacciaLogicaFruitore = new Documento("InterfacciaLogicaFruitore.wsdl", TipiDocumentoInterfaccia.WSDL.toString(), "<wsdl>fruitore</wsdl>".getBytes());
            aSC.setInterfacciaLogicaLatoFruitore(interfacciaLogicaFruitore);
            Documento specificaCoordinamento = new Documento("Generica Orchestrazione.bpel", TipiDocumentoCoordinamento.BPEL.toString(), "<bpel>coordinamento</bpel>".getBytes());
            aSC.addSpecificaCoordinamento(specificaCoordinamento);
            Documento specificaCoordinamento2 = new Documento("Generica Orchestrazione.wscdl", TipiDocumentoCoordinamento.WSCDL.toString(), "<wscdl>coordinamento</wscdl>".getBytes());
            aSC.addSpecificaCoordinamento(specificaCoordinamento2);
            dichiarazioneEGov = ClientTest.getDichiarazioneEGov(manASC.getNome());
            egovBytes = it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov(dichiarazioneEGov);
            docModalitaEsplicitaCNIPA = new Documento("ProfiloDiCollaborazione.xml", TipiDocumentoSemiformale.XML.toString(), egovBytes);
            aSC.addSpecificaSemiformale(docModalitaEsplicitaCNIPA);
            dAllegatoDEFINITORIO = new Documento("InterfacciaDefinitoria.xsd", "XSD", "<xsd>DEFINITORIO</xsd>".getBytes());
            aSC.addAllegato(dAllegatoDEFINITORIO);
            fileName = "package.asc";
            XMLUtils.generateAccordoServizioComposto(aSC, fileName);
            XMLUtils.getAccordoServizioComposto(fileName);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public static AccordoServizio getManifestoAS_ParteComune() throws Exception {
        AccordoServizio manifest = new AccordoServizio();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASParteComune");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        it.gov.spcoop.sica.manifest.AccordoServizioParteComune parteComune = new it.gov.spcoop.sica.manifest.AccordoServizioParteComune();
        parteComune.setPubblicatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        SpecificaConversazione conversazione = new SpecificaConversazione();
        DocumentoConversazione doc = new DocumentoConversazione();
        doc.setTipo("WSBL");
        doc.setBase("ConversazioneConcettuale.wsbl");
        conversazione.setConversazioneConcettuale(doc);
        DocumentoConversazione docErogatore = new DocumentoConversazione();
        docErogatore.setTipo("WSBL");
        docErogatore.setBase("ConversazioneLogicaLatoErogatore.wsbl");
        conversazione.setConversazioneLogicaLatoErogatore(docErogatore);
        DocumentoConversazione docFruitore = new DocumentoConversazione();
        docFruitore.setTipo("WSBL");
        docFruitore.setBase("ConversazioneLogicaLatoFruitore.wsbl");
        conversazione.setConversazioneLogicaLatoFruitore(docFruitore);
        parteComune.setSpecificaConversazione(conversazione);
        SpecificaInterfaccia interfaccia = new SpecificaInterfaccia();
        DocumentoInterfaccia docI = new DocumentoInterfaccia();
        docI.setTipo("WSDL");
        docI.setBase("InterfacciaConcettuale.wsdl");
        interfaccia.setInterfacciaConcettuale(docI);
        DocumentoInterfaccia docIErogatore = new DocumentoInterfaccia();
        docIErogatore.setTipo("WSDL");
        docIErogatore.setBase("InterfacciaLogicaErogatore.wsdl");
        interfaccia.setInterfacciaLogicaLatoErogatore(docIErogatore);
        DocumentoInterfaccia docIFruitore = new DocumentoInterfaccia();
        docIFruitore.setTipo("WSDL");
        docIFruitore.setBase("InterfacciaLogicaFruitore.wsdl");
        interfaccia.setInterfacciaLogicaLatoFruitore(docIFruitore);
        parteComune.setSpecificaInterfaccia(interfaccia);
        manifest.setParteComune(parteComune);
        ElencoAllegati elenco1 = new ElencoAllegati();
        elenco1.setGenericoDocumento("Allegato1.doc");
        ElencoAllegati elenco2 = new ElencoAllegati();
        elenco2.setGenericoDocumento("Allegato2.doc");
        manifest.addAllegati(elenco1);
        manifest.addAllegati(elenco2);
        SpecificaSemiformale specifica1 = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifica1.setDocumentoSemiformale(docS1);
        manifest.addSpecificaSemiformale(specifica1);
        SpecificaSemiformale specifica2 = new SpecificaSemiformale();
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifica2.setDocumentoSemiformale(docS2);
        manifest.addSpecificaSemiformale(specifica2);
        SpecificaSemiformale specificaEGOV = new SpecificaSemiformale();
        DocumentoSemiformale docSpecificaEGOV = new DocumentoSemiformale();
        docSpecificaEGOV.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSpecificaEGOV.setBase("ProfiloDiCollaborazione.xml");
        specificaEGOV.setDocumentoSemiformale(docSpecificaEGOV);
        manifest.addSpecificaSemiformale(specificaEGOV);
        ElencoAllegati elencoDefinitorioXSD = new ElencoAllegati();
        elencoDefinitorioXSD.setGenericoDocumento("InterfacciaDefinitoria.xsd");
        manifest.addAllegati(elencoDefinitorioXSD);
        return manifest;
    }

    public static AccordoServizio getManifestoAS_ParteSpecifica() throws Exception {
        AccordoServizio manifest = new AccordoServizio();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASParteSpecifica");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = new it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica();
        parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("adsc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteComune", "2"));
        parteSpecifica.setAdesione(TipiAdesione.AUTOMATICA.toString());
        parteSpecifica.setErogatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        SpecificaPortiAccesso portiAccesso = new SpecificaPortiAccesso();
        DocumentoInterfaccia docErogatore = new DocumentoInterfaccia();
        docErogatore.setTipo("WSDL");
        docErogatore.setBase("PortiAccessoErogatore.wsdl");
        portiAccesso.setPortiAccessoErogatore(docErogatore);
        DocumentoInterfaccia docFruitore = new DocumentoInterfaccia();
        docFruitore.setTipo("WSDL");
        docFruitore.setBase("PortiAccessoFruitore.wsdl");
        portiAccesso.setPortiAccessoFruitore(docFruitore);
        parteSpecifica.setSpecificaPortiAccesso(portiAccesso);
        SpecificaLivelliServizio sLivServizio = new SpecificaLivelliServizio();
        DocumentoLivelloServizio dsLivServ1 = new DocumentoLivelloServizio();
        dsLivServ1.setTipo(TipiDocumentoLivelloServizio.WSLA.toString());
        dsLivServ1.setBase("LivelloServizioMinimo.wsla");
        sLivServizio.addDocumentoLivelloServizio(dsLivServ1);
        DocumentoLivelloServizio dsLivServ2 = new DocumentoLivelloServizio();
        dsLivServ2.setTipo(TipiDocumentoLivelloServizio.WSLA.toString());
        dsLivServ2.setBase("LivelloServizioOttimale.wsla");
        sLivServizio.addDocumentoLivelloServizio(dsLivServ2);
        parteSpecifica.setSpecificaLivelliServizio(sLivServizio);
        SpecificaSicurezza sSicurezza = new SpecificaSicurezza();
        DocumentoSicurezza dsSicurezza1 = new DocumentoSicurezza();
        dsSicurezza1.setTipo(TipiDocumentoSicurezza.WSPOLICY.toString());
        dsSicurezza1.setBase("SicurezzaDelCanale.wspolicy");
        sSicurezza.addDocumentoSicurezza(dsSicurezza1);
        DocumentoSicurezza dsSicurezza2 = new DocumentoSicurezza();
        dsSicurezza2.setTipo(TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString());
        dsSicurezza2.setBase("LineeGuida.doc");
        sSicurezza.addDocumentoSicurezza(dsSicurezza2);
        parteSpecifica.setSpecificaSicurezza(sSicurezza);
        manifest.setParteSpecifica(parteSpecifica);
        ElencoAllegati elenco1 = new ElencoAllegati();
        elenco1.setGenericoDocumento("Allegato1.doc");
        ElencoAllegati elenco2 = new ElencoAllegati();
        elenco2.setGenericoDocumento("Allegato2.doc");
        manifest.addAllegati(elenco1);
        manifest.addAllegati(elenco2);
        SpecificaSemiformale specifica1 = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifica1.setDocumentoSemiformale(docS1);
        manifest.addSpecificaSemiformale(specifica1);
        SpecificaSemiformale specifica2 = new SpecificaSemiformale();
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifica2.setDocumentoSemiformale(docS2);
        manifest.addSpecificaSemiformale(specifica2);
        return manifest;
    }

    public static it.gov.spcoop.sica.manifest.AccordoCooperazione getManifestoAC() throws Exception {
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = new it.gov.spcoop.sica.manifest.AccordoCooperazione();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("AC");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        manifest.setCoordinatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempioCoordinatore", true));
        ElencoAllegati elenco1 = new ElencoAllegati();
        elenco1.setGenericoDocumento("Allegato1.doc");
        ElencoAllegati elenco2 = new ElencoAllegati();
        elenco2.setGenericoDocumento("Allegato2.doc");
        manifest.addAllegati(elenco1);
        manifest.addAllegati(elenco2);
        SpecificaSemiformale specifica1 = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifica1.setDocumentoSemiformale(docS1);
        manifest.addSpecificaSemiformale(specifica1);
        SpecificaSemiformale specifica2 = new SpecificaSemiformale();
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifica2.setDocumentoSemiformale(docS2);
        manifest.addSpecificaSemiformale(specifica2);
        ElencoPartecipanti ePartecipanti = new ElencoPartecipanti();
        ePartecipanti.addPartecipante(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoPartecipante1", true));
        ePartecipanti.addPartecipante(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoPartecipante2", true));
        manifest.setElencoPartecipanti(ePartecipanti);
        ElencoServiziComposti eSC = new ElencoServiziComposti();
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto1", false), "ASServizioComposto1", "2"));
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto2", false), "ASServizioComposto2", "2"));
        eSC.addServizioComposto(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("sc", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoErogatoreServizioComposto3", false), "ASServizioComposto3", "2"));
        manifest.setServiziComposti(eSC);
        return manifest;
    }

    public static ServizioComposto getManifestoASComposto() throws Exception {
        ServizioComposto manifest = new ServizioComposto();
        manifest.setDataCreazione(new Date());
        manifest.setDataPubblicazione(new Date());
        manifest.setDescrizione("Descrizione di esempio");
        manifest.setFirmato(false);
        manifest.setNome("ASServizioComposto");
        manifest.setRiservato(true);
        manifest.setVersione("2");
        manifest.setPubblicatore(SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", true));
        manifest.setRiferimentoAccordoCooperazione(SICAtoOpenSPCoopUtilities.buildIDAccordoCooperazioneSica("AC", "2"));
        SpecificaConversazione conversazione = new SpecificaConversazione();
        DocumentoConversazione doc = new DocumentoConversazione();
        doc.setTipo("WSBL");
        doc.setBase("ConversazioneConcettuale.wsbl");
        conversazione.setConversazioneConcettuale(doc);
        DocumentoConversazione docErogatore = new DocumentoConversazione();
        docErogatore.setTipo("WSBL");
        docErogatore.setBase("ConversazioneLogicaLatoErogatore.wsbl");
        conversazione.setConversazioneLogicaLatoErogatore(docErogatore);
        DocumentoConversazione docFruitore = new DocumentoConversazione();
        docFruitore.setTipo("WSBL");
        docFruitore.setBase("ConversazioneLogicaLatoFruitore.wsbl");
        conversazione.setConversazioneLogicaLatoFruitore(docFruitore);
        manifest.setSpecificaConversazione(conversazione);
        SpecificaInterfaccia interfaccia = new SpecificaInterfaccia();
        DocumentoInterfaccia docI = new DocumentoInterfaccia();
        docI.setTipo("WSDL");
        docI.setBase("InterfacciaConcettuale.wsdl");
        interfaccia.setInterfacciaConcettuale(docI);
        DocumentoInterfaccia docIErogatore = new DocumentoInterfaccia();
        docIErogatore.setTipo("WSDL");
        docIErogatore.setBase("InterfacciaLogicaErogatore.wsdl");
        interfaccia.setInterfacciaLogicaLatoErogatore(docIErogatore);
        DocumentoInterfaccia docIFruitore = new DocumentoInterfaccia();
        docIFruitore.setTipo("WSDL");
        docIFruitore.setBase("InterfacciaLogicaFruitore.wsdl");
        interfaccia.setInterfacciaLogicaLatoFruitore(docIFruitore);
        manifest.setSpecificaInterfaccia(interfaccia);
        SpecificaCoordinamento speCorr = new SpecificaCoordinamento();
        DocumentoCoordinamento docCoor = new DocumentoCoordinamento();
        docCoor.setTipo(TipiDocumentoCoordinamento.BPEL.toString());
        docCoor.setBase("Generica Orchestrazione.bpel");
        speCorr.addDocumentoCoordinamento(docCoor);
        DocumentoCoordinamento docCoor2 = new DocumentoCoordinamento();
        docCoor2.setTipo(TipiDocumentoCoordinamento.WSCDL.toString());
        docCoor2.setBase("Generica Orchestrazione.wscdl");
        speCorr.addDocumentoCoordinamento(docCoor2);
        manifest.setSpecificaCoordinamento(speCorr);
        ElencoServiziComponenti componenti = new ElencoServiziComponenti();
        componenti.addServizioComponente(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("ads", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteSpecifica", "2"));
        componenti.addServizioComponente(SICAtoOpenSPCoopUtilities.buildIDAccordoSica("ads", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica("SoggettoEsempio", false), "ASParteSpecifica2", "2"));
        manifest.setServiziComponenti(componenti);
        ElencoAllegati elenco1 = new ElencoAllegati();
        elenco1.setGenericoDocumento("Allegato1.doc");
        ElencoAllegati elenco2 = new ElencoAllegati();
        elenco2.setGenericoDocumento("Allegato2.doc");
        manifest.addAllegati(elenco1);
        manifest.addAllegati(elenco2);
        SpecificaSemiformale specifica1 = new SpecificaSemiformale();
        DocumentoSemiformale docS1 = new DocumentoSemiformale();
        docS1.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
        docS1.setBase("Collaborazione.doc");
        specifica1.setDocumentoSemiformale(docS1);
        manifest.addSpecificaSemiformale(specifica1);
        SpecificaSemiformale specifica2 = new SpecificaSemiformale();
        DocumentoSemiformale docS2 = new DocumentoSemiformale();
        docS2.setTipo(TipiDocumentoSemiformale.XML.toString());
        docS2.setBase("Schemi.xml");
        specifica2.setDocumentoSemiformale(docS2);
        manifest.addSpecificaSemiformale(specifica2);
        SpecificaSemiformale specificaEGOV = new SpecificaSemiformale();
        DocumentoSemiformale docSpecificaEGOV = new DocumentoSemiformale();
        docSpecificaEGOV.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSpecificaEGOV.setBase("ProfiloDiCollaborazione.xml");
        specificaEGOV.setDocumentoSemiformale(docSpecificaEGOV);
        manifest.addSpecificaSemiformale(specificaEGOV);
        ElencoAllegati elencoDefinitorioXSD = new ElencoAllegati();
        elencoDefinitorioXSD.setGenericoDocumento("InterfacciaDefinitoria.xsd");
        manifest.addAllegati(elencoDefinitorioXSD);
        return manifest;
    }

    public static EgovDecllElement getDichiarazioneEGov(String nomeAccordo) {
        EgovDecllElement egov = new EgovDecllElement();
        egov.setEGovVersion("e-govV1.1");
        egov.setRifDefinizioneInterfaccia(nomeAccordo);
        OperationListType operations = new OperationListType();
        OperationType tipoOneWay = new OperationType();
        tipoOneWay.setOperazione("nomeOperationOneWay");
        tipoOneWay.setProfiloDiCollaborazione(TipiProfiliCollaborazione.OneWay.name());
        tipoOneWay.setServizio("nomeServizioOneWay");
        operations.addOperation(tipoOneWay);
        OperationType tipoSincrono = new OperationType();
        tipoSincrono.setOperazione("nomeOperationSincrono");
        tipoSincrono.setProfiloDiCollaborazione(TipiProfiliCollaborazione.Sincrono.name());
        tipoSincrono.setServizio("nomeServizioSincrono");
        operations.addOperation(tipoSincrono);
        OperationType tipoAsincronoSimmetrico = new OperationType();
        tipoAsincronoSimmetrico.setOperazione("nomeOperationAsincronoSimmetricoRichiesta");
        tipoAsincronoSimmetrico.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
        tipoAsincronoSimmetrico.setServizio("nomeServizioAsincronoSimmetrico");
        tipoAsincronoSimmetrico.setOperazioneCorrelata("nomeOperationAsincronoSimmetricoRisposta");
        tipoAsincronoSimmetrico.setServizioCorrelato("nomeServizioCorrelatoAsincronoSimmetrico");
        operations.addOperation(tipoAsincronoSimmetrico);
        OperationType tipoAsincronoAsimmetrico = new OperationType();
        tipoAsincronoAsimmetrico.setOperazione("nomeOperationAsincronoAsimmetricoRichiesta");
        tipoAsincronoAsimmetrico.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
        tipoAsincronoAsimmetrico.setServizio("nomeServizioAsincronoAsimmetrico");
        tipoAsincronoAsimmetrico.setOperazioneCorrelata("nomeOperationAsincronoAsimmetricoRichiestaStato");
        tipoAsincronoAsimmetrico.setServizioCorrelato("nomeServizioAsincronoAsimmetrico");
        operations.addOperation(tipoAsincronoAsimmetrico);
        egov.setOperationList(operations);
        return egov;
    }
}

