/*
 * Decompiled with CFR 0.152.
 */
package it.cnipa.collprofiles.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.driver.TipiProfiliCollaborazione;
import it.cnipa.collprofiles.driver.XMLUtilsException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop.utils.ValidatoreXSD;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD() throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(XMLUtils.class.getResourceAsStream("/SpecificaSemiformaleEGov.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(EgovDecllElement egov, StringBuffer motivoErroreValidazione) {
        OperationListType operations;
        int size = motivoErroreValidazione.length();
        if (egov.getEGovVersion() == null) {
            motivoErroreValidazione.append("VersioneEGov non definita\n");
        }
        if (egov.getRifDefinizioneInterfaccia() == null) {
            motivoErroreValidazione.append("RifInterfaccia non definita\n");
        }
        if ((operations = egov.getOperationList()) == null) {
            motivoErroreValidazione.append("OperationListType non presente\n");
        } else {
            if (operations.sizeOperationList() <= 0) {
                motivoErroreValidazione.append("OperationListType vuota\n");
            }
            for (int i = 0; i < operations.sizeOperationList(); ++i) {
                OperationType op = operations.getOperation(i);
                if (op.getServizio() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza il servizio\n");
                }
                if (op.getOperazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza l'operation\n");
                }
                if (op.getProfiloDiCollaborazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza un profilo di collaborazione\n");
                }
                if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione()) || TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) continue;
                motivoErroreValidazione.append("OperationList[" + i + "] con un profilo di collaborazione non conosciuto (" + op.getProfiloDiCollaborazione() + ")\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EgovDecllElement getDichiarazioneEGov(byte[] m) throws XMLUtilsException {
        EgovDecllElement egovDecllElement;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(m);
                egovDecllElement = XMLUtils.getDichiarazioneEGov(bin);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (bin == null) throw throwable;
                bin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return egovDecllElement;
        }
        if (bin == null) return egovDecllElement;
        bin.close();
        return egovDecllElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EgovDecllElement getDichiarazioneEGov(File m) throws XMLUtilsException {
        EgovDecllElement egovDecllElement;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(m);
                egovDecllElement = XMLUtils.getDichiarazioneEGov(fin);
                Object var4_4 = null;
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fin == null) throw throwable;
                fin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return egovDecllElement;
        }
        if (fin == null) return egovDecllElement;
        fin.close();
        return egovDecllElement;
    }

    public static EgovDecllElement getDichiarazioneEGov(String m) throws XMLUtilsException {
        return XMLUtils.getDichiarazioneEGov(m.getBytes());
    }

    public static EgovDecllElement getDichiarazioneEGov(InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD();
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (EgovDecllElement)org.openspcoop.dao.commons.XMLUtils.xmlToObj(binTrasformazione, EgovDecllElement.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(out.getName(), EgovDecllElement.class, (Object)manifest);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(fileName, EgovDecllElement.class, (Object)manifest);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDichiarazioneEGov(EgovDecllElement manifest) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.generateDichiarazioneEGov(manifest, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            org.openspcoop.dao.commons.XMLUtils.objToXml(out, EgovDecllElement.class, (Object)manifest);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }
}

