/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;

public class XSDUtils {
    private AbstractXMLUtils xmlUtils;
    private static long counter = 0L;

    public XSDUtils(AbstractXMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public boolean isXSDSchema(byte[] xsd) throws XMLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return false;
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.isXSDSchema(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public boolean isXSDSchema(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return this.isXSDSchema(elemXML);
    }

    public boolean isXSDSchema(Element xsd) throws XMLException {
        return this.isXSDSchema((Node)xsd);
    }

    public boolean isXSDSchema(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Schema xsd da verificare non definito");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                return false;
            }
            return "http://www.w3.org/2001/XMLSchema".equals(xsd.getNamespaceURI());
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(byte[] xsd) throws XMLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                throw new Exception("Schema xsd non e' un documento valido");
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return this.getTargetNamespace(elemXML);
    }

    public String getTargetNamespace(Element xsd) throws XMLException {
        return this.getTargetNamespace((Node)xsd);
    }

    public String getTargetNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Schema xsd non e' un documento valido");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getImportNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "namespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getImportSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getIncludeSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new Exception("Non e' un import valido");
            }
            if (!"include".equals(xsd.getLocalName())) {
                throw new Exception("Root element non e' un include di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public List<Node> readImportsAndIncludes(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, true, true);
    }

    public List<Node> readImports(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, true, false);
    }

    public List<Node> readIncludes(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, false, true);
    }

    public List<Node> readImportsAndIncludes(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, true);
    }

    public List<Node> readImports(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, false);
    }

    public List<Node> readIncludes(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public List<Node> readImports(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public List<Node> readIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, true);
    }

    public List<Node> readImports(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, false);
    }

    public List<Node> readIncludes(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public List<Node> readImports(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public List<Node> readIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    private List<Node> readImportsIncludes(String targetNamespaceSchema, Document xsdD, Node xsdE, boolean imports, boolean includes) throws XMLException {
        try {
            Vector<Node> nodes = new Vector<Node>();
            NodeList list = null;
            list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if ("schema".equals(child.getLocalName())) {
                        NodeList listDefinition;
                        if (targetNamespaceSchema == null) {
                            try {
                                targetNamespaceSchema = this.getTargetNamespace(child);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if ((listDefinition = child.getChildNodes()) == null) continue;
                        for (int j = 0; j < listDefinition.getLength(); ++j) {
                            Node childDefinition = listDefinition.item(j);
                            if (imports && "import".equals(childDefinition.getLocalName())) {
                                if (targetNamespaceSchema == null) {
                                    try {
                                        targetNamespaceSchema = this.getImportNamespace(childDefinition);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                                nodes.add(childDefinition);
                            }
                            if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                            childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                            nodes.add(childDefinition);
                        }
                        continue;
                    }
                    if ("import".equals(child.getLocalName())) {
                        if (!imports) continue;
                        if (targetNamespaceSchema == null) {
                            try {
                                targetNamespaceSchema = this.getImportNamespace(child);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                        nodes.add(child);
                        continue;
                    }
                    if (!"include".equals(child.getLocalName()) || !includes) continue;
                    if (targetNamespaceSchema == null) {
                        throw new XMLException("Lo schema esegue un include senza definire un targetNamespace.");
                    }
                    child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                    nodes.add(child);
                }
            }
            return nodes;
        }
        catch (Exception e) {
            throw new XMLException("Riscontrato errore durante la lettura dello schema: " + e.getMessage(), e);
        }
    }

    public void removeImport(Document xsd, Node importNode) {
        this.removeImports_engine(xsd, null, true, false, importNode);
    }

    public void removeInclude(Document xsd, Node includeNode) {
        this.removeImports_engine(xsd, null, false, true, includeNode);
    }

    public void removeImport(Element xsd, Node importNode) {
        this.removeImports_engine(null, xsd, true, false, importNode);
    }

    public void removeInclude(Element xsd, Node includeNode) {
        this.removeImports_engine(null, xsd, false, true, includeNode);
    }

    public void removeImport(Node xsd, Node importNode) {
        this.removeImports_engine(null, xsd, true, false, importNode);
    }

    public void removeInclude(Node xsd, Node includeNode) {
        this.removeImports_engine(null, xsd, false, true, includeNode);
    }

    public void removeImports(Document xsd) {
        this.removeImports_engine(xsd, null, true, false, null);
    }

    public void removeIncludes(Document xsd) {
        this.removeImports_engine(xsd, null, false, true, null);
    }

    public void removeImportsAndIncludes(Document xsd) {
        this.removeImports_engine(xsd, null, true, true, null);
    }

    public void removeImports(Element xsd) {
        this.removeImports_engine(null, xsd, true, false, null);
    }

    public void removeIncludes(Element xsd) {
        this.removeImports_engine(null, xsd, false, true, null);
    }

    public void removeImportsAndIncludes(Element xsd) {
        this.removeImports_engine(null, xsd, true, true, null);
    }

    public void removeImports(Node xsd) {
        this.removeImports_engine(null, xsd, true, false, null);
    }

    public void removeIncludes(Node xsd) {
        this.removeImports_engine(null, xsd, false, true, null);
    }

    public void removeImportsAndIncludes(Node xsd) {
        this.removeImports_engine(null, xsd, true, true, null);
    }

    private void removeImports_engine(Document xsdD, Node xsdE, boolean imports, boolean includes, Node importIncludeNode) {
        NodeList list = null;
        list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if ("schema".equals(child.getLocalName())) {
                    NodeList listDefinition = child.getChildNodes();
                    if (listDefinition == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (imports && "import".equals(childDefinition.getLocalName())) {
                            if (importIncludeNode == null) {
                                child.removeChild(childDefinition);
                            } else if (importIncludeNode.equals(childDefinition)) {
                                child.removeChild(childDefinition);
                            }
                        }
                        if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                        if (importIncludeNode == null) {
                            child.removeChild(childDefinition);
                            continue;
                        }
                        if (!importIncludeNode.equals(childDefinition)) continue;
                        child.removeChild(childDefinition);
                    }
                    continue;
                }
                if ("import".equals(child.getLocalName())) {
                    if (!imports) continue;
                    if (importIncludeNode == null) {
                        if (xsdD != null) {
                            xsdD.removeChild(child);
                            continue;
                        }
                        xsdE.removeChild(child);
                        continue;
                    }
                    if (!importIncludeNode.equals(child)) continue;
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!"include".equals(child.getLocalName()) || !includes) continue;
                if (importIncludeNode == null) {
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!importIncludeNode.equals(child)) continue;
                if (xsdD != null) {
                    xsdD.removeChild(child);
                    continue;
                }
                xsdE.removeChild(child);
            }
        }
    }

    public Schema buildSchema(Hashtable<String, byte[]> resources, Hashtable<String, String> mappingNamespaceLocations, Logger logger) throws XMLException {
        if (resources.size() == 0) {
            throw new XMLException("Schemi non presenti");
        }
        byte[] schemaPerValidazione = null;
        try {
            StringBuffer bf = new StringBuffer();
            bf.append("<xsd:schema targetNamespace=\"http://openspcoop2.org/validazione_engine\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
            StringBuffer bfContenitori = new StringBuffer();
            StringBuffer bfImportNormali = new StringBuffer();
            Enumeration<String> targetNamespaces = mappingNamespaceLocations.keys();
            int indexSystemId = 0;
            while (targetNamespaces.hasMoreElements()) {
                String targetNamespace = targetNamespaces.nextElement();
                String locations = mappingNamespaceLocations.get(targetNamespace);
                String[] splitLocations = locations.split(" ");
                if (splitLocations.length == 1) {
                    bfImportNormali.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + splitLocations[0] + "\" />\n");
                    continue;
                }
                String systemIdNewSchema = "System_OpenSPCoop_Id_" + indexSystemId;
                ++indexSystemId;
                bfContenitori.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + systemIdNewSchema + "\" />\n");
                StringBuffer bfStessoNamespace = new StringBuffer();
                bfStessoNamespace.append("<xsd:schema targetNamespace=\"" + targetNamespace + "\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
                for (int i = 0; i < splitLocations.length; ++i) {
                    boolean findImportInclude = false;
                    for (int j = 0; j < splitLocations.length; ++j) {
                        if (j == i) continue;
                        byte[] xsd = resources.get(splitLocations[j]);
                        Document d = this.xmlUtils.newDocument(xsd);
                        List<Node> imports = this.readImports(d);
                        if (imports != null) {
                            for (Node node : imports) {
                                String baseLocation;
                                String schemaLocation;
                                if (node == null || (schemaLocation = this.getImportSchemaLocation(node)) == null || !splitLocations[i].equals(baseLocation = this.getBaseNameXSDLocation(schemaLocation))) continue;
                                findImportInclude = true;
                                break;
                            }
                        }
                        if (findImportInclude) break;
                        List<Node> includes = this.readIncludes(d);
                        if (includes != null) {
                            for (Node node : includes) {
                                String baseLocation;
                                String schemaLocation;
                                if (node == null || (schemaLocation = this.getIncludeSchemaLocation(node)) == null || !splitLocations[i].equals(baseLocation = this.getBaseNameXSDLocation(schemaLocation))) continue;
                                findImportInclude = true;
                                break;
                            }
                        }
                        if (findImportInclude) break;
                    }
                    if (findImportInclude) continue;
                    bfStessoNamespace.append("\t<xsd:include schemaLocation=\"" + splitLocations[i] + "\" />\n");
                }
                bfStessoNamespace.append("</xsd:schema>");
                resources.put(systemIdNewSchema, bfStessoNamespace.toString().getBytes());
            }
            bf.append(bfContenitori.toString());
            bf.append(bfImportNormali.toString());
            bf.append("</xsd:schema>");
            schemaPerValidazione = bf.toString().getBytes();
        }
        catch (Exception e) {
            throw new XMLException("Creazione dello schema fallita: " + e.getMessage(), e);
        }
        XSDResourceResolver resourceResolver = new XSDResourceResolver(resources);
        try {
            ValidatoreXSD validatoreXSD = new ValidatoreXSD(logger, "org.apache.xerces.jaxp.validation.XMLSchemaFactory", (LSResourceResolver)resourceResolver, (InputStream)new ByteArrayInputStream(schemaPerValidazione));
            return validatoreXSD.getSchema();
        }
        catch (Exception e) {
            this.debugPrintXSDSchemi(schemaPerValidazione, resourceResolver, logger);
            throw new XMLException("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    public void registraMappingNamespaceLocations(byte[] resource, String location, Hashtable<String, String> mappingNamespaceLocations) throws XMLException {
        String targetNamespaceXSD = this.getTargetNamespace(resource);
        if (targetNamespaceXSD != null) {
            if (mappingNamespaceLocations.containsKey(targetNamespaceXSD)) {
                String locationGiaAssociataTargetNamespace = mappingNamespaceLocations.remove(targetNamespaceXSD);
                String newValue = locationGiaAssociataTargetNamespace + " " + location;
                mappingNamespaceLocations.put(targetNamespaceXSD, newValue);
            } else {
                mappingNamespaceLocations.put(targetNamespaceXSD, location);
            }
        }
    }

    public String getBaseNameXSDLocation(String location) throws MalformedURLException {
        if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("file://")) {
            URL url = new URL(location);
            File fileUrl = new File(url.getFile());
            return fileUrl.getName();
        }
        File f = new File(location);
        return f.getName();
    }

    public void debugPrintXSDSchemi(byte[] schemaPerValidazione, XSDResourceResolver resourceResolver, Logger logger) {
        try {
            File dir = File.createTempFile("xsd_dir_", "");
            dir.delete();
            boolean dirCreate = dir.mkdir();
            String uniqueID = XSDUtils.getIdForDebug();
            File f = null;
            f = (dirCreate &= dir.isDirectory()) ? File.createTempFile("root_" + uniqueID + "_", ".xsd", dir) : File.createTempFile("root_" + uniqueID + "_", ".xsd");
            FileSystemUtilities.writeFile(f, schemaPerValidazione);
            if (resourceResolver != null && resourceResolver instanceof XSDResourceResolver) {
                XSDResourceResolver xsdResolver = resourceResolver;
                Enumeration<String> keys = xsdResolver.getResources().keys();
                while (keys.hasMoreElements()) {
                    String systemId = keys.nextElement();
                    byte[] contenuto = xsdResolver.getResources().get(systemId);
                    File schemaTmpLog = null;
                    schemaTmpLog = dirCreate ? File.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd", dir) : File.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd");
                    FileSystemUtilities.writeFile(schemaTmpLog, contenuto);
                }
            }
            if (dirCreate) {
                logger.error((Object)("Inizializzazione dello schema fallita, gli schemi sono stati registrati nella directory " + dir.getAbsolutePath()));
            } else {
                logger.error((Object)("Inizializzazione dello schema fallita, gli schemi sono stati registrati nella area temporanea (root schema: " + f.getAbsolutePath() + ")"));
            }
        }
        catch (Exception eDebug) {
            logger.error((Object)("Registrazione xsd per debug non riuscita: " + eDebug.getMessage()), (Throwable)eDebug);
        }
    }

    private static synchronized String getIdForDebug() {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        return "ID_" + ++counter + "_" + dateformat.format(DateManager.getDate());
    }
}

