/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractXPathExpressionEngine {
    private static XPathFactory xPathFactory = null;
    private static Logger logger = Logger.getLogger(XPathExpressionEngine.class);
    private static Integer synchronizedObjectForBugFWK005ParseXerces = new Integer(1);
    private int _prefixIndex = 0;
    private static final String AUTO_PREFIX = "_op2PrefixAutoGeneratedIndex";

    public static XPathFactory getXPathFactory() throws XPathException {
        if (xPathFactory == null) {
            AbstractXPathExpressionEngine.initXPathFactory();
        }
        return xPathFactory;
    }

    public static synchronized void initXPathFactory() throws XPathException {
        try {
            if (xPathFactory == null) {
                xPathFactory = XPathFactory.newInstance();
            }
        }
        catch (Exception e) {
            throw new XPathException("Inizializzazione XPathFactory non riuscita", e);
        }
    }

    public static void setLogger(Logger logger) {
        AbstractXPathExpressionEngine.logger = logger;
    }

    public String getStringMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(document.getDocumentElement(), dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(element, dnc, pattern, XPathReturnType.STRING);
    }

    public String getStringMatchPattern(String contenuto, DynamicNamespaceContext dnc, String pattern) throws XPathException, XPathNotFoundException, XPathNotValidException {
        return (String)this.getMatchPattern(contenuto, dnc, pattern, XPathReturnType.STRING);
    }

    public abstract String getAsString(SOAPElement var1);

    public abstract AbstractXMLUtils getXMLUtils();

    public Object getMatchPattern(SOAPElement element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (element == null) {
            throw new XPathException("element xml undefined");
        }
        return this._engine_getMatchPattern((Element)element, null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(Document document, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (document == null) {
            throw new XPathException("document xml undefined");
        }
        if (document.getDocumentElement() == null) {
            throw new XPathException("document.element xml undefined");
        }
        return this._engine_getMatchPattern(document.getDocumentElement(), null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(Element element, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (element == null) {
            throw new XPathException("element xml undefined");
        }
        return this._engine_getMatchPattern(element, null, dnc, pattern, returnType);
    }

    public Object getMatchPattern(String content, DynamicNamespaceContext dnc, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (content == null) {
            throw new XPathException("content undefined");
        }
        return this._engine_getMatchPattern(null, content, dnc, pattern, returnType);
    }

    public abstract Element readXPathElement(Element var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _engine_getMatchPattern(Element contenutoAsElement, String contenutoAsString, DynamicNamespaceContext dncPrivate, String pattern, XPathReturnType returnType) throws XPathException, XPathNotFoundException, XPathNotValidException {
        if (pattern == null || pattern.length() == 0) {
            throw new XPathNotFoundException("Pattern di ricerca non fornito");
        }
        if (contenutoAsElement == null && contenutoAsString == null) {
            throw new XPathNotFoundException("Contenuto su cui effettuare la ricerca non fornito");
        }
        if (contenutoAsElement != null && contenutoAsString != null) {
            throw new XPathNotFoundException("Contenuto su cui effettuare la ricerca ambiguo");
        }
        pattern = pattern.trim();
        this.validate(pattern);
        try {
            XPathFactory factory = AbstractXPathExpressionEngine.getXPathFactory();
            XPath xpath = factory.newXPath();
            if (xpath == null) {
                throw new Exception("Costruzione xpath non riuscita");
            }
            DynamicNamespaceContext dnc = null;
            if (dncPrivate != null) {
                dnc = (DynamicNamespaceContext)dncPrivate.clone();
            }
            if (dnc != null) {
                pattern = pattern.replaceAll("}:", "}");
                pattern = this.convertNamespaces(pattern, dnc);
            }
            if (dnc != null) {
                xpath.setNamespaceContext(dnc);
            }
            if (pattern.startsWith("concat_openspcoop") && pattern.endsWith(")")) {
                if (!returnType.equals(XPathReturnType.STRING)) {
                    throw new XPathException("Funzione concat_openspcoop non compatibile con un tipo di ritorno: " + returnType.toString());
                }
                String param = pattern.substring("concat_openspcoop(".length(), pattern.length() - 1);
                String[] params = param.split(",");
                StringBuffer bfResult = new StringBuffer();
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].startsWith("\"") && params[i].endsWith("\"")) {
                        bfResult.append(params[i].substring(1, params[i].length() - 1));
                        continue;
                    }
                    StringReader reader = null;
                    if (contenutoAsString != null) {
                        try {
                            reader = new StringReader(contenutoAsString);
                        }
                        catch (Exception e) {
                            try {
                                if (reader != null) {
                                    ((Reader)reader).close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            throw e;
                        }
                    }
                    XPathExpression expression = null;
                    try {
                        expression = xpath.compile(params[i]);
                    }
                    catch (Exception e) {
                        if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                            throw new XPathNotFoundException("Espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") non applicabile al messaggio: " + Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true));
                        }
                        if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                        }
                        if (e.getCause() != null) {
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                        }
                        throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                    }
                    if (expression == null) {
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    String result = null;
                    try {
                        Integer n = synchronizedObjectForBugFWK005ParseXerces;
                        synchronized (n) {
                            result = reader != null ? expression.evaluate(new InputSource(reader)) : expression.evaluate(this.readXPathElement(contenutoAsElement));
                        }
                    }
                    catch (Exception e) {
                        if (Utilities.existsInnerException((Throwable)e, com.sun.org.apache.xpath.internal.XPathException.class)) {
                            throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, com.sun.org.apache.xpath.internal.XPathException.class).getMessage() + ")", e);
                        }
                        if (e.getCause() != null) {
                            throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                        }
                        throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                    }
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                    if (result == null || "".equals(result)) {
                        logger.debug((Object)("nessun match trovato per l'espressione xpath contenuta in concat_openspcoop (" + params[i] + ")"));
                        throw new XPathNotFoundException("nessun match trovato per l'espressione xpath contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    bfResult.append(result);
                }
                if (bfResult.length() <= 0) {
                    StringBuffer bfDNC = new StringBuffer();
                    Enumeration<?> en = dnc.getPrefixes();
                    while (en.hasMoreElements()) {
                        String prefix = (String)en.nextElement();
                        bfDNC.append("\n\t- ");
                        bfDNC.append("[").append(prefix).append("]=[").append(dnc.getNamespaceURI(prefix)).append("]");
                    }
                    throw new XPathNotFoundException("nessun match trovato per l'espressione xpath (concat_openspcoop) [" + pattern + "] DynamicNamespaceContext:" + bfDNC.toString());
                }
                return bfResult.toString();
            }
            StringReader reader = null;
            if (contenutoAsString != null) {
                try {
                    reader = new StringReader(contenutoAsString);
                }
                catch (Exception e) {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            XPathExpression expression = null;
            try {
                expression = xpath.compile(pattern);
            }
            catch (Exception e) {
                if (Utilities.existsInnerMessageException(e, "Prefix must resolve to a namespace", true)) {
                    throw new XPathNotFoundException("Espressione XPATH non applicabile al messaggio: " + Utilities.getInnerMessageException(e, "Prefix must resolve to a namespace", true));
                }
                if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                }
                if (e.getCause() != null) {
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                }
                throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
            }
            if (expression == null) {
                throw new Exception("Costruzione XPathExpression non riuscita");
            }
            Object result = null;
            try {
                Integer bfDNC = synchronizedObjectForBugFWK005ParseXerces;
                synchronized (bfDNC) {
                    result = reader != null ? expression.evaluate(new InputSource(reader), returnType.getValore()) : expression.evaluate(this.readXPathElement(contenutoAsElement), returnType.getValore());
                }
            }
            catch (Exception e) {
                if (Utilities.existsInnerException((Throwable)e, com.sun.org.apache.xpath.internal.XPathException.class)) {
                    throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, com.sun.org.apache.xpath.internal.XPathException.class).getMessage() + ")", e);
                }
                if (e.getCause() != null) {
                    throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                }
                throw new Exception("Valutazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
            }
            if (reader != null) {
                ((Reader)reader).close();
            }
            boolean notFound = false;
            if (result == null) {
                notFound = true;
            } else if (result instanceof String) {
                if ("".equals(result)) {
                    notFound = true;
                }
            } else if (XPathReturnType.NODESET.equals(returnType) && result instanceof NodeList && ((NodeList)result).getLength() <= 0) {
                notFound = true;
            }
            if (notFound) {
                StringBuffer bfDNC = new StringBuffer();
                Enumeration<?> en = dnc.getPrefixes();
                while (en.hasMoreElements()) {
                    String prefix = (String)en.nextElement();
                    bfDNC.append("\n\t- ");
                    bfDNC.append("[").append(prefix).append("]=[").append(dnc.getNamespaceURI(prefix)).append("]");
                }
                throw new XPathNotFoundException("nessun match trovato per l'espressione xpath [" + pattern + "] DynamicNamespaceContext:" + bfDNC.toString());
            }
            return result;
        }
        catch (XPathNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new XPathException("getMatchPattern pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public void validate(String path) throws XPathNotValidException {
        block18: {
            try {
                path = path.trim();
                XPathFactory factory = AbstractXPathExpressionEngine.getXPathFactory();
                XPath xpath = factory.newXPath();
                if (xpath == null) {
                    throw new Exception("Costruzione xpath non riuscita");
                }
                path = path.replaceAll("}:", "}");
                int index = 0;
                if (path.indexOf("{") != -1) {
                    while (path.indexOf("{") != -1) {
                        int indexStart = path.indexOf("{");
                        int indexEnd = path.indexOf("}");
                        if (indexEnd == -1) {
                            throw new Exception("{ utilizzato senza la rispettiva chiusura }");
                        }
                        String namespace = path.substring(indexStart + "{".length(), indexEnd);
                        if (namespace == null || namespace.equals("")) {
                            throw new Exception("Namespace non indicato tra {}");
                        }
                        String prefix = "a" + index + ":";
                        ++index;
                        path = path.replace("{" + namespace + "}", prefix);
                    }
                }
                if (path.startsWith("concat_openspcoop")) {
                    String param = path.substring("concat_openspcoop(".length(), path.length() - 1);
                    String[] params = param.split(",");
                    for (int i = 0; i < params.length; ++i) {
                        if (params[i].startsWith("\"") && params[i].endsWith("\"")) continue;
                        XPathExpression expression = null;
                        try {
                            expression = xpath.compile(params[i]);
                        }
                        catch (Exception e) {
                            if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                            }
                            if (e.getCause() != null) {
                                throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                            }
                            throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore (" + e.getMessage() + ")", e);
                        }
                        if (expression != null) continue;
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    break block18;
                }
                XPathExpression expression = null;
                try {
                    expression = xpath.compile(path);
                }
                catch (Exception e) {
                    if (Utilities.existsInnerException((Throwable)e, TransformerException.class)) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getInnerException((Throwable)e, TransformerException.class).getMessage() + ")", e);
                    }
                    if (e.getCause() != null) {
                        throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + Utilities.getLastInnerException(e.getCause()).getMessage() + ")", e);
                    }
                    throw new Exception("Compilazione dell'espressione XPATH ha causato un errore (" + e.getMessage() + ")", e);
                }
                if (expression == null) {
                    throw new Exception("Costruzione XPathExpression non riuscita");
                }
            }
            catch (Exception e) {
                throw new XPathNotValidException("Validazione dell'xpath indicato [" + path + "] fallita: " + e.getMessage(), e);
            }
        }
    }

    public String toString(NodeList rootNode) {
        StringBuffer resultBuffer = new StringBuffer();
        this.toString(rootNode, resultBuffer, 1);
        return resultBuffer.toString();
    }

    private synchronized int _getNextPrefixIndex() {
        ++this._prefixIndex;
        return this._prefixIndex;
    }

    private String convertNamespaces(String path, DynamicNamespaceContext dnc) throws UtilsException {
        if (path.indexOf("{") != -1) {
            while (path.indexOf("{") != -1) {
                int indexStart = path.indexOf("{");
                int indexEnd = path.indexOf("}");
                if (indexEnd == -1) {
                    throw new UtilsException("Errore durante l'interpretazione del valore [" + path + "]: { utilizzato senza la rispettiva chiusura }");
                }
                String namespace = path.substring(indexStart + "{".length(), indexEnd);
                String prefix = dnc.getPrefix(namespace);
                if (prefix != null && !"".equals(prefix)) {
                    prefix = prefix + ":";
                } else {
                    prefix = AUTO_PREFIX + this._getNextPrefixIndex();
                    dnc.addNamespace(prefix, namespace);
                    prefix = prefix + ":";
                }
                path = path.replace("{" + namespace + "}", prefix);
            }
        }
        return path;
    }

    private void toString(NodeList rootNode, StringBuffer resultBuffer, int livello) {
        if (rootNode.getLength() == 1 && rootNode.item(0).getNodeType() == 3 && resultBuffer.length() == 0) {
            resultBuffer.append(rootNode.item(0).getTextContent());
            return;
        }
        boolean findElementoRisultatoMultiplo = false;
        for (int index = 0; index < rootNode.getLength(); ++index) {
            Node aNode = rootNode.item(index);
            if (aNode.getNodeType() == 1) {
                NodeList childNodes = aNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                boolean hasChildNodes = false;
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node n = childNodes.item(i);
                    if (!n.hasChildNodes()) continue;
                    hasChildNodes = true;
                    break;
                }
                if (hasChildNodes) {
                    resultBuffer.append("<" + aNode.getNodeName());
                    this.printAttributes(aNode, resultBuffer);
                    resultBuffer.append(">");
                    this.toString(aNode.getChildNodes(), resultBuffer, livello + 1);
                    resultBuffer.append("</" + aNode.getNodeName() + ">");
                    continue;
                }
                resultBuffer.append("<" + aNode.getNodeName());
                this.printAttributes(aNode, resultBuffer);
                resultBuffer.append(">" + aNode.getTextContent() + "</" + aNode.getNodeName() + ">");
                continue;
            }
            if (livello != 1 || aNode.getNodeType() != 3) continue;
            if (findElementoRisultatoMultiplo) {
                resultBuffer.append(", ");
            } else {
                findElementoRisultatoMultiplo = true;
            }
            resultBuffer.append("[" + index + "]=" + aNode.getTextContent());
        }
    }

    private void printAttributes(Node aNode, StringBuffer resultBuffer) {
        NamedNodeMap attr = aNode.getAttributes();
        for (int i = 0; i < attr.getLength(); ++i) {
            Node item = attr.item(i);
            if (item instanceof Attr) {
                Attr attribute = (Attr)item;
                String prefix = attribute.getPrefix();
                prefix = prefix != null && !"".equals(prefix) ? prefix + ":" : "";
                String value = attribute.getNodeValue();
                resultBuffer.append(" " + prefix + attribute.getLocalName() + "=\"" + value + "\"");
                continue;
            }
            resultBuffer.append(" " + item.toString());
        }
    }
}

