/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.XMLErrorHandler;
import org.openspcoop2.utils.xml.XMLErrorListener;
import org.openspcoop2.utils.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXMLUtils {
    private DocumentBuilderFactory documentFactory = null;
    private TransformerFactory transformerFactory = null;
    private DatatypeFactory datatypeFactory = null;
    private GregorianCalendar gregorianCalendar = null;

    protected abstract DocumentBuilderFactory newDocumentBuilderFactory() throws XMLException;

    protected abstract TransformerFactory newTransformerFactory() throws XMLException;

    protected abstract DatatypeFactory newDatatypeFactory() throws XMLException;

    public synchronized void initBuilder() throws XMLException {
        if (this.documentFactory == null) {
            try {
                this.documentFactory = this.newDocumentBuilderFactory();
            }
            catch (Exception e) {
                throw new XMLException(e.getMessage(), e);
            }
            this.documentFactory.setNamespaceAware(true);
        }
        DocumentBuilderFactory.newInstance().getClass().getName();
    }

    public synchronized void initTransformer() throws XMLException {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.newTransformerFactory();
        }
    }

    public synchronized void initCalendarConverter() throws XMLException {
        try {
            this.datatypeFactory = this.newDatatypeFactory();
            this.gregorianCalendar = (GregorianCalendar)Calendar.getInstance();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public DocumentBuilderFactory getDocumentFactory() throws XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        return this.documentFactory;
    }

    public TransformerFactory getTransformerFactory() throws XMLException {
        if (this.transformerFactory == null) {
            this.initTransformer();
        }
        return this.transformerFactory;
    }

    public DatatypeFactory getDatatypeFactory() {
        return this.datatypeFactory;
    }

    public XMLGregorianCalendar toGregorianCalendar(Date d) throws XMLException {
        if (this.datatypeFactory == null || this.gregorianCalendar == null) {
            this.initCalendarConverter();
        }
        this.gregorianCalendar.setTime(d);
        return this.datatypeFactory.newXMLGregorianCalendar(this.gregorianCalendar);
    }

    public Document getAsDocument(Element element) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element));
    }

    public Document getAsDocument(Element element, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), errorHandler);
    }

    public Document getAsDocument(Element element, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), entityResolver);
    }

    public Document getAsDocument(Element element, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(element), errorHandler, entityResolver);
    }

    public Document getAsDocument(Node Node2) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2));
    }

    public Document getAsDocument(Node Node2, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), errorHandler);
    }

    public Document getAsDocument(Node Node2, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), entityResolver);
    }

    public Document getAsDocument(Node Node2, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLException {
        return this.newDocument(this.toByteArray(Node2), errorHandler, entityResolver);
    }

    public Document newDocument() throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(new XMLErrorHandler(), null);
    }

    public Document newDocument(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(errorHandler, null);
    }

    public Document newDocument(EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument_engine(errorHandler, entityResolver);
    }

    private Document newDocument_engine(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.newDocument();
    }

    public Document newDocument(byte[] xml) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler, null);
    }

    public Document newDocument(byte[] xml, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document newDocument(byte[] xml, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(xml);
            Document document = this.newDocument(bin, errorHandler, entityResolver);
            return document;
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception eClose) {}
            }
        }
    }

    public Document newDocument(InputStream is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, null);
    }

    public Document newDocument(InputStream is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(InputStream is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(is);
    }

    public Document newDocument(File f) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler, null);
    }

    public Document newDocument(File f, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(File f, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(f);
    }

    public Document newDocument(InputSource is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), null);
    }

    public Document newDocument(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, null);
    }

    public Document newDocument(InputSource is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, (ErrorHandler)new XMLErrorHandler(), entityResolver);
    }

    public Document newDocument(InputSource is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.parse(is);
    }

    public Element newElement() throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(new XMLErrorHandler(), null);
    }

    public Element newElement(ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(errorHandler, null);
    }

    public Element newElement(EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(new XMLErrorHandler(), entityResolver);
    }

    public Element newElement(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newElement_engine(errorHandler, entityResolver);
    }

    private Element newElement_engine(ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        if (this.documentFactory == null) {
            this.initBuilder();
        }
        DocumentBuilder documentBuilder = this.documentFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(errorHandler);
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        return documentBuilder.newDocument().getDocumentElement();
    }

    public Element newElement(byte[] xml) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml).getDocumentElement();
    }

    public Element newElement(byte[] xml, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler).getDocumentElement();
    }

    public Element newElement(byte[] xml, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, entityResolver).getDocumentElement();
    }

    public Element newElement(byte[] xml, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(xml, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(InputStream is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is).getDocumentElement();
    }

    public Element newElement(InputStream is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler).getDocumentElement();
    }

    public Element newElement(InputStream is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, entityResolver).getDocumentElement();
    }

    public Element newElement(InputStream is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(File f) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f).getDocumentElement();
    }

    public Element newElement(File f, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler).getDocumentElement();
    }

    public Element newElement(File f, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, entityResolver).getDocumentElement();
    }

    public Element newElement(File f, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(f, errorHandler, entityResolver).getDocumentElement();
    }

    public Element newElement(InputSource is) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is).getDocumentElement();
    }

    public Element newElement(InputSource is, ErrorHandler errorHandler) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler).getDocumentElement();
    }

    public Element newElement(InputSource is, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, entityResolver).getDocumentElement();
    }

    public Element newElement(InputSource is, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException, ParserConfigurationException, XMLException {
        return this.newDocument(is, errorHandler, entityResolver).getDocumentElement();
    }

    public byte[] toByteArray(Document doc) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Element element) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Node node) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toByteArray();
    }

    public byte[] toByteArray(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toByteArray();
    }

    public String toString(Document doc) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Document doc, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(doc, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public String toString(Element element) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Element element, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(element, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public String toString(Node node) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout);
        bout.close();
        return bout.toString();
    }

    public String toString(Node node, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeTo(node, (OutputStream)bout, omitXMLDeclaration);
        bout.close();
        return bout.toString();
    }

    public void writeTo(Document doc, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, errorListener, false);
    }

    public void writeTo(Document doc, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Document doc, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, errorListener, false);
    }

    public void writeTo(Document doc, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Document doc, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Document doc, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, errorListener, false);
    }

    public void writeTo(Document doc, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Document doc, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)doc, file, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, errorListener, false);
    }

    public void writeTo(Element element, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, errorListener, false);
    }

    public void writeTo(Element element, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Element element, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Element element, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, errorListener, false);
    }

    public void writeTo(Element element, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Element element, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo((Node)element, file, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, OutputStream os) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, OutputStream os, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, errorListener, false);
    }

    public void writeTo(Node node, OutputStream os, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, os, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, Writer writer) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, Writer writer, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, errorListener, false);
    }

    public void writeTo(Node node, Writer writer, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, writer, errorListener, omitXMLDeclaration);
    }

    public void writeTo(Node node, File file) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), false);
    }

    public void writeTo(Node node, File file, ErrorListener errorListener) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, errorListener, false);
    }

    public void writeTo(Node node, File file, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, (ErrorListener)new XMLErrorListener(), omitXMLDeclaration);
    }

    public void writeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        this.writeNodeTo(node, file, errorListener, omitXMLDeclaration);
    }

    private void writeNodeTo(Node node, OutputStream os, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException, XMLException {
        if (this.transformerFactory == null) {
            this.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(os);
        Transformer transformer = this.transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        os.flush();
    }

    private void writeNodeTo(Node node, Writer writer, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        if (this.transformerFactory == null) {
            this.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        Transformer transformer = this.transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
        writer.flush();
    }

    private void writeNodeTo(Node node, File file, ErrorListener errorListener, boolean omitXMLDeclaration) throws TransformerException, IOException, XMLException {
        if (this.transformerFactory == null) {
            this.initTransformer();
        }
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(file);
        Transformer transformer = this.transformerFactory.newTransformer();
        if (omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setErrorListener(errorListener);
        transformer.transform(source, result);
    }

    @Deprecated
    public byte[] eraserXML(byte[] xml) {
        return this.eraserXML(new String(xml)).getBytes();
    }

    @Deprecated
    public String eraserXML(String xml) {
        String tmp = xml.trim();
        if (tmp.startsWith("<?xml")) {
            int indexOf = tmp.indexOf(">");
            return tmp.substring(indexOf + 1);
        }
        return xml;
    }

    @Deprecated
    public byte[] eraserXsiType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        try {
            String eraserString = " xsi:type=\"xsd:string\"";
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    if (i + eraserString.length() < xml.length) {
                        StringBuffer test = new StringBuffer();
                        for (int k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            throw new UtilsException("Utilities.eraserType error " + e.getMessage(), e);
        }
    }

    public boolean isDocument(byte[] xml) {
        try {
            return this.newDocument(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isElement(byte[] xml) {
        try {
            return this.newElement(xml) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getAttributeValue(Node n, String attrName) {
        Node nA;
        NamedNodeMap att = n.getAttributes();
        if (att != null && (nA = att.getNamedItem(attrName)) != null) {
            return nA.getNodeValue();
        }
        return null;
    }
}

