/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl.validator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ParamStyle;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.openspcoop2.utils.wadl.ApplicationWrapper;
import org.openspcoop2.utils.wadl.WADLException;
import org.openspcoop2.utils.wadl.WADLUtilities;
import org.openspcoop2.utils.wadl.entity.HttpBaseEntity;
import org.openspcoop2.utils.wadl.entity.HttpBaseRequestEntity;
import org.openspcoop2.utils.wadl.entity.HttpBaseResponseEntity;
import org.openspcoop2.utils.wadl.validator.WADLValidatorException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Validator {
    private ApplicationWrapper application;
    private Logger log;
    private AbstractXMLUtils xmlUtils;
    private XSDUtils xsdUtils;
    private Schema schema;

    public Validator(Logger log, ApplicationWrapper application) throws WADLException {
        this(log, application, XMLUtils.getInstance());
    }

    public Validator(Logger log, ApplicationWrapper application, AbstractXMLUtils xmlUtils) throws WADLException {
        try {
            this.log = log;
            this.application = application;
            this.xmlUtils = xmlUtils;
            this.xsdUtils = new XSDUtils(this.xmlUtils);
            if (this.application.getResources().size() > 0) {
                this.schema = this.xsdUtils.buildSchema(this.application.getResources(), this.application.getMappingNamespaceLocations(), this.log);
            }
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    public void validate(HttpBaseEntity<?> httpEntity) throws WADLException, WADLValidatorException {
        ResourceNode resourceNode = WADLUtilities.findResourceNode(this.application.getApplicationNode(), httpEntity.getUrl());
        MethodNode methodNode = WADLUtilities.findMethodNode(resourceNode, httpEntity.getMethod());
        this.validateAgainstXSDSchema(httpEntity, resourceNode, methodNode);
        this.wadlConformanceCheck(httpEntity, resourceNode, methodNode);
    }

    private void validateAgainstXSDSchema(HttpBaseEntity<?> httpEntity, ResourceNode resourceNode, MethodNode methodNode) throws WADLException, WADLValidatorException {
        block15: {
            if (this.schema != null) {
                try {
                    ValidatoreXSD validatore = null;
                    try {
                        validatore = new ValidatoreXSD(this.schema);
                    }
                    catch (Exception e) {
                        throw new WADLException("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e.getMessage(), e);
                    }
                    QName elementAtteso = null;
                    AbstractNode nodeXML = this.getNode(httpEntity, methodNode);
                    if (nodeXML != null) {
                        if (nodeXML instanceof RepresentationNode) {
                            elementAtteso = ((RepresentationNode)nodeXML).getElement();
                        } else if (nodeXML instanceof FaultNode) {
                            elementAtteso = ((FaultNode)nodeXML).getElement();
                        }
                    }
                    if (elementAtteso == null) break block15;
                    Node node = this.readNode(elementAtteso, httpEntity);
                    String nomeElemento = null;
                    try {
                        nomeElemento = node.getLocalName();
                        validatore.valida(node, true);
                    }
                    catch (Exception e) {
                        StringBuffer errorMsgValidazioneXSD = new StringBuffer();
                        errorMsgValidazioneXSD.append("validazione fallita");
                        errorMsgValidazioneXSD.append(" (elemento " + nomeElemento + "): " + e.getMessage());
                        String elementNonValidato = null;
                        try {
                            elementNonValidato = this.xmlUtils.toString(node);
                        }
                        catch (Exception eString) {
                            this.log.error((Object)("Errore durante la conversione del Node in String: " + eString.getMessage()), (Throwable)eString);
                        }
                        this.log.error((Object)("Validazione fallita (elemento " + nomeElemento + ") [" + elementNonValidato + "]: " + e.getMessage()), (Throwable)e);
                        throw new WADLValidatorException(errorMsgValidazioneXSD.toString(), e);
                    }
                }
                catch (WADLException e) {
                    throw e;
                }
                catch (WADLValidatorException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WADLException(e.getMessage(), e);
                }
            }
        }
    }

    private AbstractNode getNode(HttpBaseEntity<?> httpEntity, MethodNode methodNode) throws WADLException, WADLValidatorException {
        block9: {
            block8: {
                if (!(httpEntity instanceof HttpBaseRequestEntity)) break block8;
                if (methodNode.getSupportedInputs() == null) break block9;
                for (RepresentationNode input : methodNode.getSupportedInputs()) {
                    if (!input.getMediaType().equals("application/xml") && !input.getMediaType().equals("text/xml")) continue;
                    return input;
                }
                break block9;
            }
            if (httpEntity instanceof HttpBaseResponseEntity) {
                List<FaultNode> lstFaults;
                int status = ((HttpBaseResponseEntity)httpEntity).getStatus();
                List lstOutputs = this.getSupportedOutputs((MultivaluedMap<List<Long>, RepresentationNode>)methodNode.getSupportedOutputs(), status);
                if (lstOutputs != null) {
                    for (RepresentationNode output : lstOutputs) {
                        if (!output.getMediaType().equals("application/xml") && !output.getMediaType().equals("text/xml")) continue;
                        return output;
                    }
                }
                if ((lstFaults = this.getSupportedFaults((MultivaluedMap<List<Long>, FaultNode>)methodNode.getFaults(), status)) != null) {
                    for (FaultNode fault : lstFaults) {
                        if (!fault.getMediaType().equals("application/xml") && !fault.getMediaType().equals("text/xml")) continue;
                        return fault;
                    }
                }
                if ((lstOutputs = (List)methodNode.getSupportedOutputs().get(new ArrayList())) != null) {
                    for (RepresentationNode output : lstOutputs) {
                        if (!output.getMediaType().equals("application/xml") && !output.getMediaType().equals("text/xml")) continue;
                        return output;
                    }
                }
            }
        }
        return null;
    }

    private List<RepresentationNode> getSupportedOutputs(MultivaluedMap<List<Long>, RepresentationNode> outputs, int status) {
        for (List lst : outputs.keySet()) {
            for (Long longValue : lst) {
                if (longValue.intValue() != status) continue;
                return (List)outputs.get((Object)lst);
            }
        }
        return null;
    }

    private List<FaultNode> getSupportedFaults(MultivaluedMap<List<Long>, FaultNode> faults, int status) {
        for (List lst : faults.keySet()) {
            for (Long longValue : lst) {
                if (longValue.intValue() != status) continue;
                return (List)faults.get((Object)lst);
            }
        }
        return null;
    }

    private void wadlConformanceCheck(HttpBaseEntity<?> httpEntity, ResourceNode resourceNode, MethodNode methodNode) throws WADLException, WADLValidatorException {
        try {
            QName elementAtteso = null;
            List paramsAttesi = methodNode.getRequiredParameters();
            AbstractNode nodeXML = this.getNode(httpEntity, methodNode);
            if (nodeXML != null) {
                if (nodeXML instanceof RepresentationNode) {
                    RepresentationNode representationNode = (RepresentationNode)nodeXML;
                    elementAtteso = representationNode.getElement();
                } else if (nodeXML instanceof FaultNode) {
                    FaultNode faultNode = (FaultNode)nodeXML;
                    elementAtteso = faultNode.getElement();
                }
            }
            if (httpEntity.getContentType() != null) {
                boolean contentTypeSupported = false;
                if (httpEntity instanceof HttpBaseRequestEntity) {
                    if (methodNode.getSupportedInputs() != null) {
                        for (RepresentationNode input : methodNode.getSupportedInputs()) {
                            if (!input.getMediaType().equals(httpEntity.getContentType())) continue;
                            contentTypeSupported = true;
                        }
                    }
                } else if (httpEntity instanceof HttpBaseResponseEntity) {
                    List<FaultNode> lstFaults;
                    int status = ((HttpBaseResponseEntity)httpEntity).getStatus();
                    List lstOutputs = this.getSupportedOutputs((MultivaluedMap<List<Long>, RepresentationNode>)methodNode.getSupportedOutputs(), status);
                    if (lstOutputs != null) {
                        for (RepresentationNode output : lstOutputs) {
                            if (!output.getMediaType().equals(httpEntity.getContentType())) continue;
                            contentTypeSupported = true;
                        }
                    }
                    if ((lstFaults = this.getSupportedFaults((MultivaluedMap<List<Long>, FaultNode>)methodNode.getFaults(), status)) != null) {
                        for (FaultNode fault : lstFaults) {
                            if (!fault.getMediaType().equals(httpEntity.getContentType())) continue;
                            contentTypeSupported = true;
                        }
                    }
                    if ((lstOutputs = (List)methodNode.getSupportedOutputs().get(new ArrayList())) != null) {
                        for (RepresentationNode output : lstOutputs) {
                            if (!output.getMediaType().equals(httpEntity.getContentType())) continue;
                            contentTypeSupported = true;
                        }
                    }
                }
                if (!contentTypeSupported) {
                    throw new WADLValidatorException("Verifica content type [" + httpEntity.getContentType() + "] supportato fallita.");
                }
            }
            if (elementAtteso != null) {
                Node node = this.readNode(elementAtteso, httpEntity);
                if (node.getLocalName() == null) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http non contiene un local-name?");
                }
                if (node.getNamespaceURI() == null) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http non contiene un namespace?");
                }
                if (!node.getLocalName().equals(elementAtteso.getLocalPart())) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http contiene un local-name [" + node.getLocalName() + "] differente da quello atteso [" + elementAtteso.getLocalPart() + "]");
                }
                if (!node.getNamespaceURI().equals(elementAtteso.getNamespaceURI())) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http contiene un namespace [" + node.getNamespaceURI() + "] differente da quello atteso [" + elementAtteso.getNamespaceURI() + "]");
                }
            }
            if (httpEntity instanceof HttpBaseRequestEntity) {
                HttpBaseRequestEntity request = (HttpBaseRequestEntity)httpEntity;
                if (paramsAttesi != null && !paramsAttesi.isEmpty()) {
                    for (Param param : paramsAttesi) {
                        if (param.getStyle().equals((Object)ParamStyle.QUERY)) {
                            if (request.getParametersFormBased() != null && request.getParametersFormBased().containsKey(param.getName())) continue;
                            throw new WADLValidatorException("Verifica presenza header formBased [" + param.getName() + "] fallita.");
                        }
                        if (!param.getStyle().equals((Object)ParamStyle.HEADER) || request.getParametersTrasporto() != null && request.getParametersTrasporto().containsKey(param.getName())) continue;
                        throw new WADLValidatorException("Verifica presenza header trasporto [" + param.getName() + "] fallita.");
                    }
                }
            }
        }
        catch (WADLException e) {
            throw e;
        }
        catch (WADLValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    private Node readNode(QName elementAtteso, HttpBaseEntity<?> httpEntity) throws WADLValidatorException, WADLException {
        Node node = null;
        try {
            if (httpEntity.getContent() == null) {
                throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Non \u00e8 stato riscontrato alcun dato nel payload http");
            }
            Object content = httpEntity.getContent();
            if (content instanceof Document) {
                node = ((Document)content).getDocumentElement();
            } else if (content instanceof byte[]) {
                byte[] bytes = (byte[])content;
                node = this.xmlUtils.newDocument(bytes);
            } else if (content instanceof String) {
                byte[] bytes = ((String)content).getBytes();
                node = this.xmlUtils.newDocument(bytes);
            } else if (content instanceof InputStream) {
                InputStream is = (InputStream)content;
                node = this.xmlUtils.newDocument(is);
            } else {
                throw new WADLException("HttpBaseEntity [" + httpEntity.getClass().getName() + "] non gestita");
            }
            return node;
        }
        catch (WADLException e) {
            throw e;
        }
        catch (WADLValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Non \u00e8 stato riscontrato nel payload http dei dati che contengano una struttura xml valida, " + e.getMessage(), e);
        }
    }
}

