/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl;

import java.util.Hashtable;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDUtils;

public class ApplicationWrapper {
    private ApplicationNode applicationNode;
    private Hashtable<String, byte[]> resources = new Hashtable();
    private Hashtable<String, String> mappingNamespaceLocations = new Hashtable();
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;

    public ApplicationWrapper(ApplicationNode applicationNode, Hashtable<String, byte[]> resources, Hashtable<String, String> mappingNamespaceLocations, AbstractXMLUtils xmlUtils) {
        this.applicationNode = applicationNode;
        this.resources = resources;
        this.mappingNamespaceLocations = mappingNamespaceLocations;
        this.xmlUtils = xmlUtils;
        this.xsdUtils = new XSDUtils(this.xmlUtils);
    }

    public ApplicationNode getApplicationNode() {
        return this.applicationNode;
    }

    public Hashtable<String, byte[]> getResources() {
        return this.resources;
    }

    public Hashtable<String, String> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void addResource(String systemId, byte[] resource) throws XMLException {
        if (!this.resources.containsKey(systemId)) {
            this.resources.put(systemId, resource);
            this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, this.mappingNamespaceLocations);
        }
    }
}

