/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.EscapeSQLPattern;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public abstract class SQLQueryObjectCore
implements ISQLQueryObject {
    Vector<String> fields = new Vector();
    Vector<String> fieldNames = new Vector();
    Hashtable<String, Boolean> fieldNameIsFunction = new Hashtable();
    Hashtable<String, String> alias = new Hashtable();
    Vector<String> tables = new Vector();
    Vector<String> tableNames = new Vector();
    Vector<String> tableAlias = new Vector();
    Vector<String> conditions = new Vector();
    Vector<String> forceIndexTableNames = new Vector();
    boolean andLogicOperator = false;
    boolean notBeforeConditions = false;
    private Vector<String> groupBy = new Vector();
    Vector<String> orderBy = new Vector();
    boolean sortTypeAsc = true;
    private boolean distinct = false;
    int limit = -1;
    int offset = -1;
    Vector<String> updateFieldsName = new Vector();
    Vector<String> updateFieldsValue = new Vector();
    String updateTable = null;
    Vector<String> insertFieldsName = new Vector();
    Vector<String> insertFieldsValue = new Vector();
    String insertTable = null;
    private TipiDatabase tipoDatabase;
    private boolean precheckQuery = true;
    private int serial = 0;

    public int sizeConditions() {
        return this.conditions.size();
    }

    public SQLQueryObjectCore(TipiDatabase tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    public void setPrecheckQuery(boolean precheckQuery) {
        this.precheckQuery = precheckQuery;
    }

    protected synchronized int getSerial() {
        ++this.serial;
        return this.serial;
    }

    protected void precheckBuildQuery() throws SQLQueryObjectException {
        if (!this.precheckQuery) {
            return;
        }
        if (this.offset >= 0 && this.orderBy.size() == 0) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (this.groupBy.size() > 0) {
            boolean exists;
            if (this.orderBy.size() > 0) {
                for (String order : this.orderBy) {
                    String orderField;
                    exists = false;
                    for (String groupBy : this.groupBy) {
                        if (!this.normalizeField(groupBy).equals(this.normalizeField(order))) continue;
                        exists = true;
                        break;
                    }
                    if (exists || this.isFieldNameForFunction(orderField = this.normalizeField(order)).booleanValue()) continue;
                    throw new SQLQueryObjectException("La colonna " + order + " utilizzata nella condizione di ORDER BY deve apparire anche in una condizione di GROUP BY");
                }
            }
            for (String groupBy : this.groupBy) {
                exists = false;
                for (String field : this.fields) {
                    if (!this.normalizeField(groupBy).equals(this.normalizeField(field))) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                throw new SQLQueryObjectException("La colonna " + groupBy + " utilizzata nella condizione di GROUP BY deve essere anche selezionato come select field");
            }
        }
    }

    protected String normalizeField(String field) {
        return this.normalizeField(field, true);
    }

    protected String normalizeField(String field, boolean firstSearchFromAliasesField) {
        int indexOf;
        if (firstSearchFromAliasesField) {
            for (String fieldRicercaAliasa : this.fields) {
                List<String> aliases;
                String[] split = null;
                if (fieldRicercaAliasa.contains(" as ")) {
                    split = fieldRicercaAliasa.split(" as ");
                } else if (fieldRicercaAliasa.contains(" As ")) {
                    split = fieldRicercaAliasa.split(" As ");
                } else if (fieldRicercaAliasa.contains(" aS ")) {
                    split = fieldRicercaAliasa.split(" aS ");
                } else if (fieldRicercaAliasa.contains(" AS ")) {
                    split = fieldRicercaAliasa.split(" AS ");
                } else if (fieldRicercaAliasa.contains(" ")) {
                    split = fieldRicercaAliasa.split(" ");
                } else if (fieldRicercaAliasa.contains(this.getDefaultAliasFieldKeyword())) {
                    split = fieldRicercaAliasa.split(this.getDefaultAliasFieldKeyword());
                }
                if (split == null && (aliases = this.getSupportedAliasesField()) != null && aliases.size() > 0) {
                    for (String alias : aliases) {
                        if (!fieldRicercaAliasa.contains(alias)) continue;
                        split = fieldRicercaAliasa.split(alias);
                        break;
                    }
                }
                if (split == null || split.length != 2) continue;
                split[0] = split[0].trim();
                split[1] = split[1].trim();
                if (!field.equals(split[0])) continue;
                return split[1];
            }
        }
        if ((indexOf = field.indexOf(".")) != -1 && indexOf + 1 < field.length()) {
            field = field.substring(indexOf + 1);
        }
        ArrayList<String> aliasModeSupportati = new ArrayList<String>();
        Iterator<String> iterator = this.getSupportedAliasesField().iterator();
        while (iterator.hasNext()) {
            aliasModeSupportati.add(iterator.next());
        }
        if (!aliasModeSupportati.contains(" ")) {
            aliasModeSupportati.add(" ");
        }
        if (!aliasModeSupportati.contains(" as ")) {
            aliasModeSupportati.add(" as ");
        }
        for (String alias : aliasModeSupportati) {
            int aliasLength = alias.length();
            String fLowerCase = field.toLowerCase();
            indexOf = fLowerCase.lastIndexOf(alias);
            if (indexOf == -1 || indexOf + aliasLength >= field.length()) continue;
            field = field.substring(indexOf + aliasLength);
            field = field.trim();
            break;
        }
        return field;
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeField) throws SQLQueryObjectException {
        return this.addSelectField(null, nomeField);
    }

    @Override
    public ISQLQueryObject addSelectField(String nomeTabella, String nomeField) throws SQLQueryObjectException {
        return this._engine_addSelectField(nomeTabella, nomeField, null, true, false);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeField, String alias) throws SQLQueryObjectException {
        return this._engine_addSelectField(null, nomeField, alias, true, false);
    }

    @Override
    public ISQLQueryObject addSelectAliasField(String nomeTabella, String nomeField, String alias) throws SQLQueryObjectException {
        return this._engine_addSelectField(nomeTabella, nomeField, alias, true, false);
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String nomeField, String alias, String valore) throws SQLQueryObjectException {
        return this._engine_addSelectField(null, nomeField, alias, true, "coalesce(", ",'" + this.escapeStringValue(valore) + "')", true);
    }

    @Override
    public ISQLQueryObject addSelectCoalesceField(String aliasTabella, String nomeField, String alias, String valore) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        return this._engine_addSelectField(aliasTabella, nomeField, alias, true, "coalesce(", ",'" + this.escapeStringValue(valore) + "')", true);
    }

    @Override
    public ISQLQueryObject addSelectCountField(String alias) throws SQLQueryObjectException {
        String fieldSQL = "count(*)";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        this.fieldNameIsFunction.put(alias, true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias) throws SQLQueryObjectException {
        if (fieldCount == null) {
            fieldCount = "*";
        }
        String fieldSQL = "count(" + fieldCount + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        this.fieldNameIsFunction.put(alias, true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (fieldCount == null && distinct) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare DISTINCT senza specificare un fieldCount");
        }
        if (distinct) {
            this.addSelectCountField("DISTINCT " + fieldCount, alias);
        } else {
            this.addSelectCountField(fieldCount, alias);
        }
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectCountField(String aliasTabella, String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectCountField(aliasTabella + "." + fieldCount, alias, distinct);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        this._engine_addSelectField(null, field, alias, true, "avg(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectAvgField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this._engine_addSelectField(aliasTabella, field, alias, true, "avg(", ")", true);
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectAvgTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectAvgTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this._engine_addSelectField(null, field, alias, true, "max(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this._engine_addSelectField(aliasTabella, field, alias, true, "max(", ")", true);
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectMaxTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectMaxTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this._engine_addSelectField(null, field, alias, true, "min(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this._engine_addSelectField(aliasTabella, field, alias, true, "min(", ")", true);
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectMinTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectMinTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        this._engine_addSelectField(null, field, alias, true, "sum(", ")", true);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        if (aliasTabella == null) {
            throw new SQLQueryObjectException("nomeTabella non puo' essere null");
        }
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this._engine_addSelectField(aliasTabella, field, alias, true, "sum(", ")", true);
        return this;
    }

    @Override
    public abstract ISQLQueryObject addSelectSumTimestampField(String var1, String var2) throws SQLQueryObjectException;

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String aliasTabella, String field, String alias) throws SQLQueryObjectException {
        if (!this.tableAlias.contains(aliasTabella)) {
            throw new SQLQueryObjectException("L'alias indicato non corrisponde ad un alias effettivo associato ad una tabella");
        }
        this.addSelectSumTimestampField(aliasTabella + "." + field, alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectForceIndex(String nomeTabella, String indexName) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabela is null or empty string");
        }
        if (indexName == null || "".equals(indexName)) {
            throw new SQLQueryObjectException("Nome indice is null or empty string");
        }
        String forceIndex = "/*+ index(" + nomeTabella + " " + indexName + ") */";
        if (this.forceIndexTableNames.contains(forceIndex)) {
            throw new SQLQueryObjectException("Forzatura all'utilizzo dell'indice (" + forceIndex + ") gia inserito tra le forzature");
        }
        this.forceIndexTableNames.add(forceIndex);
        return this;
    }

    @Override
    public void setSelectDistinct(boolean value) throws SQLQueryObjectException {
        this.distinct = value;
    }

    protected boolean isSelectDistinct() throws SQLQueryObjectException {
        if (this.distinct && this.fields.size() <= 0) {
            throw new SQLQueryObjectException("Per usare la select distinct devono essere indicati dei select field");
        }
        return this.distinct;
    }

    @Override
    public Vector<String> getFieldsName() throws SQLQueryObjectException {
        if (this.fieldNames == null || this.fieldNames.size() == 0) {
            throw new SQLQueryObjectException("Nessun field impostato");
        }
        return this.fieldNames;
    }

    @Override
    public Boolean isFieldNameForFunction(String fieldName) throws SQLQueryObjectException {
        if (this.fieldNames == null || this.fieldNames.size() == 0) {
            throw new SQLQueryObjectException("Nessun field impostato");
        }
        if (!this.fieldNameIsFunction.containsKey(fieldName)) {
            throw new SQLQueryObjectException("Field non presente (se durante la definizione del field e' stato usato un 'alias' utilizzarlo come parametro di questo metodo)");
        }
        return this.fieldNameIsFunction.get(fieldName);
    }

    public Vector<String> getFields() throws SQLQueryObjectException {
        if (this.fields == null || this.fields.size() == 0) {
            throw new SQLQueryObjectException("Nessun field impostato");
        }
        return this.fields;
    }

    @Override
    public Vector<String> getTablesName() throws SQLQueryObjectException {
        if (this.tableNames == null || this.tableNames.size() == 0) {
            throw new SQLQueryObjectException("Nessuna tabella impostata");
        }
        return this.tableNames;
    }

    public Vector<String> getTables() throws SQLQueryObjectException {
        if (this.tables == null || this.tables.size() == 0) {
            throw new SQLQueryObjectException("Nessuna tabella impostata");
        }
        return this.tables;
    }

    @Override
    public abstract String getUnixTimestampConversion(String var1);

    @Override
    public abstract String getDiffUnixTimestamp(String var1, String var2);

    @Override
    public String getDefaultAliasFieldKeyword() {
        return this.getSupportedAliasesField().get(0);
    }

    @Override
    public String getDefaultAliasTableKeyword() {
        return this.getSupportedAliasesTable().get(0);
    }

    @Override
    public List<String> getSupportedAliasesField() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" as ");
        lista.add(" ");
        return lista;
    }

    @Override
    public List<String> getSupportedAliasesTable() {
        ArrayList<String> lista = new ArrayList<String>();
        lista.add(" as ");
        lista.add(" ");
        return lista;
    }

    protected ISQLQueryObject _engine_addSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName, boolean isFunction) throws SQLQueryObjectException {
        return this._engine_addSelectField(nomeTabella, nomeField, alias, addFieldName, null, null, isFunction);
    }

    protected ISQLQueryObject _engine_addSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName, String functionPrefix, String functionSuffix, boolean isFunction) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field is null or empty string");
        }
        if (alias != null) {
            if (this.fields.contains("*")) {
                throw new SQLQueryObjectException("Alias " + alias + " del field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fieldNames.contains(alias)) {
                throw new SQLQueryObjectException("Alias " + alias + " gia inserito tra i select fields");
            }
        } else {
            if (!"*".equals(nomeField) && this.fields.contains("*")) {
                throw new SQLQueryObjectException("Field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fields.contains(nomeField)) {
                throw new SQLQueryObjectException("Field " + nomeField + " gia inserito tra i select fields");
            }
        }
        if (nomeTabella != null && !"".equals(nomeTabella)) {
            if (!this.tableNames.contains(nomeTabella)) {
                throw new SQLQueryObjectException("Tabella " + nomeTabella + " non esiste tra le tabelle su cui effettuare la ricerca (se nella addFromTable e' stato utilizzato l'alias per la tabella, utilizzarlo anche come parametro in questo metodo)");
            }
            String nomeTabellaConField = nomeTabella + "." + nomeField;
            if (functionPrefix != null) {
                nomeTabellaConField = functionPrefix + nomeTabellaConField;
            }
            if (functionSuffix != null) {
                nomeTabellaConField = nomeTabellaConField + functionSuffix;
            }
            if (alias != null) {
                this.fields.add(nomeTabellaConField + this.getDefaultAliasFieldKeyword() + alias);
                this.alias.put(alias, nomeTabellaConField);
            } else {
                this.fields.add(nomeTabellaConField);
            }
        } else {
            String tmp = new String(nomeField);
            if (functionPrefix != null) {
                tmp = functionPrefix + tmp;
            }
            if (functionSuffix != null) {
                tmp = tmp + functionSuffix;
            }
            if (alias != null) {
                this.fields.add(tmp + this.getDefaultAliasFieldKeyword() + alias);
                this.alias.put(alias, tmp);
            } else {
                this.fields.add(tmp);
            }
        }
        if (addFieldName) {
            if (alias != null) {
                this.fieldNames.add(alias);
                this.fieldNameIsFunction.put(alias, isFunction);
            } else {
                this.fieldNames.add(nomeField);
                this.fieldNameIsFunction.put(nomeField, isFunction);
            }
        }
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (this.tableNames.contains(tabella)) {
            throw new SQLQueryObjectException("Tabella " + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(tabella);
        this.tables.add(tabella);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(String tabella, String alias) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (alias == null || "".equals(alias)) {
            throw new SQLQueryObjectException("Alias tabella is null or empty string");
        }
        if (this.tableNames.contains(alias)) {
            throw new SQLQueryObjectException("Tabella " + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tableNames.add(alias);
        this.tables.add(tabella + this.getDefaultAliasTableKeyword() + alias);
        this.tableAlias.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(String condition) throws SQLQueryObjectException {
        if (condition == null || "".equals(condition)) {
            throw new SQLQueryObjectException("Where Condition is null or empty string");
        }
        String buildCondition = "( " + condition + " )";
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException("Where Condition " + condition + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, String ... conditions) throws SQLQueryObjectException {
        this.addWhereCondition(andLogicOperator, false, conditions);
        return this;
    }

    @Override
    public ISQLQueryObject addWhereCondition(boolean andLogicOperator, boolean not, String ... conditions) throws SQLQueryObjectException {
        if (conditions == null || conditions.length <= 0) {
            throw new SQLQueryObjectException("Where Conditions non esistenti");
        }
        StringBuffer buildCondition = new StringBuffer();
        if (not) {
            buildCondition.append("( NOT ");
        }
        buildCondition.append("( ");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                if (andLogicOperator) {
                    buildCondition.append(" AND ");
                } else {
                    buildCondition.append(" OR ");
                }
            }
            if (conditions[i] == null || "".equals(conditions[i])) {
                throw new SQLQueryObjectException("Where Condition[" + i + "] is null or empty string");
            }
            buildCondition.append("(");
            buildCondition.append(conditions[i]);
            buildCondition.append(")");
        }
        buildCondition.append(" )");
        if (not) {
            buildCondition.append(")");
        }
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition.toString());
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException("IsNullCondition field non puo' essere null");
        }
        this.addWhereCondition(field + " is null");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereIsNotNullCondition(String field) throws SQLQueryObjectException {
        if (field == null || "".equals(field)) {
            throw new SQLQueryObjectException("IsNullCondition field non puo' essere null");
        }
        this.addWhereCondition(field + " is not null");
        return this;
    }

    @Override
    public ISQLQueryObject addWhereINCondition(String field, boolean stringValueType, String ... valore) throws SQLQueryObjectException {
        if (valore == null || valore.length < 1) {
            throw new SQLQueryObjectException("Deve essere fornito almeno un valore");
        }
        StringBuffer bf = new StringBuffer(field);
        bf.append(" IN ( ");
        for (int i = 0; i < valore.length; ++i) {
            if (i > 0) {
                bf.append(",");
            }
            if (stringValueType) {
                bf.append("'");
                bf.append(this.escapeStringValue(valore[i]));
                bf.append("'");
                continue;
            }
            bf.append(valore[i]);
        }
        bf.append(")");
        this.addWhereCondition(bf.toString());
        return this;
    }

    @Override
    public ISQLQueryObject addWhereBetweenCondition(String field, boolean stringValueType, String leftValue, String rightValue) throws SQLQueryObjectException {
        if (leftValue == null) {
            throw new SQLQueryObjectException("Deve essere fornito un valore per l'intervallo sinistro");
        }
        if (rightValue == null) {
            throw new SQLQueryObjectException("Deve essere fornito un valore per l'intervallo destro");
        }
        StringBuffer bf = new StringBuffer(field);
        bf.append(" BETWEEN ");
        if (stringValueType) {
            bf.append("'");
            bf.append(this.escapeStringValue(leftValue));
            bf.append("'");
        } else {
            bf.append(leftValue);
        }
        bf.append(" AND ");
        if (stringValueType) {
            bf.append("'");
            bf.append(this.escapeStringValue(rightValue));
            bf.append("'");
        } else {
            bf.append(rightValue);
        }
        this.addWhereCondition(bf.toString());
        return this;
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        if (escape) {
            EscapeSQLPattern escapePattern = this.escapePatternValue(searchPattern);
            String escapeClausole = "";
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            buildCondition = "( " + columnName + " LIKE '" + escapePattern.getEscapeValue() + "'" + escapeClausole + " )";
        } else {
            buildCondition = "( " + columnName + " LIKE '" + searchPattern + "' )";
        }
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.addWhereLikeCondition(columnName, searchPattern, true);
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, escape);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, true);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean escape) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, escape);
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        if (escape) {
            EscapeSQLPattern escapePattern = this.escapePatternValue(searchPattern);
            String escapeClausole = "";
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            buildCondition = contains && caseInsensitive ? "( lower(" + columnName + ") LIKE '%" + escapePattern.getEscapeValue().toLowerCase() + "%'" + escapeClausole + " )" : (contains ? "( " + columnName + " LIKE '%" + escapePattern.getEscapeValue() + "%'" + escapeClausole + " )" : (caseInsensitive ? "( lower(" + columnName + ") LIKE '" + escapePattern.getEscapeValue().toLowerCase() + "'" + escapeClausole + " )" : "( " + columnName + " LIKE '" + escapePattern.getEscapeValue() + "'" + escapeClausole + " )"));
        } else {
            buildCondition = contains && caseInsensitive ? "( lower(" + columnName + ") LIKE '%" + searchPattern.toLowerCase() + "%' )" : (contains ? "( " + columnName + " LIKE '%" + searchPattern + "%' )" : (caseInsensitive ? "( lower(" + columnName + ") LIKE '" + searchPattern.toLowerCase() + "' )" : "( " + columnName + " LIKE '" + searchPattern + "' )"));
        }
        return buildCondition;
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.addWhereLikeCondition(columnName, searchPattern, true, contains, caseInsensitive);
    }

    @Override
    public ISQLQueryObject addWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, escape, contains, caseInsensitive);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
        return this;
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, true, contains, caseInsensitive);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean escape, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, escape, contains, caseInsensitive);
    }

    private String createWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non fornito");
        }
        if (sqlQueryObject instanceof SQLQueryObjectCore) {
            SQLQueryObjectCore core = (SQLQueryObjectCore)sqlQueryObject;
            if (core.orderBy != null && core.orderBy.size() > 0) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere condizioni di order by");
            }
            if (core.offset >= 0) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di OFFSET");
            }
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append("EXISTS (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereExistsCondition(notExists, sqlQueryObject));
        return this;
    }

    @Override
    public String getWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        return this.createWhereExistsCondition(notExists, sqlQueryObject);
    }

    @Override
    public ISQLQueryObject addWhereSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, false, field, sqlQueryObject));
        return this;
    }

    @Override
    public ISQLQueryObject addWhereINSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, true, field, sqlQueryObject));
        return this;
    }

    private String createWhereSQLConditionCondition(boolean notExists, boolean in, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene costruita la ricerca, non fornito");
        }
        if (field == null) {
            throw new SQLQueryObjectException("Field non fornito");
        }
        if (sqlQueryObject instanceof SQLQueryObjectCore) {
            SQLQueryObjectCore core = (SQLQueryObjectCore)sqlQueryObject;
            if (core.orderBy != null && core.orderBy.size() > 0) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere condizioni di order by");
            }
            if (core.offset >= 0) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di OFFSET");
            }
            if (!in && core.limit > 1) {
                throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non deve possedere la condizione di LIMIT o al massimo puo' essere definita con valore '1')");
            }
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append(field);
        if (in) {
            bf.append(" IN ");
        } else {
            bf.append(" = ");
        }
        bf.append(" (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public void setANDLogicOperator(boolean andLogicOperator) throws SQLQueryObjectException {
        this.andLogicOperator = andLogicOperator;
    }

    @Override
    public void setNOTBeforeConditions(boolean not) throws SQLQueryObjectException {
        this.notBeforeConditions = not;
    }

    @Override
    public String escapeStringValue(String value) throws SQLQueryObjectException {
        return SQLQueryObjectCore.getEscapeStringValue(value);
    }

    public static String getEscapeStringValue(String value) throws SQLQueryObjectException {
        if (value == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        int index = value.indexOf(39);
        if (index >= 0) {
            StringBuffer str = new StringBuffer();
            char[] v = value.toCharArray();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == '\'') {
                    str.append('\'');
                }
                str.append(v[i]);
            }
            return str.toString();
        }
        return value;
    }

    @Override
    public EscapeSQLPattern escapePatternValue(String pattern) throws SQLQueryObjectException {
        EscapeSQLPattern escapeSqlPattern = new EscapeSQLPattern();
        if (pattern == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        EscapeSQLConfiguration escapeConfig = this.getEscapeSQLConfiguration();
        char[] special_char = escapeConfig.getSpecial_char();
        StringBuffer str = new StringBuffer();
        char[] v = pattern.toCharArray();
        boolean escape = false;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == '\'') {
                str.append('\'');
            } else {
                for (int j = 0; j < special_char.length && !escape; ++j) {
                    if (v[i] != special_char[j]) continue;
                    str.append(escapeConfig.getEscapeClausole());
                    escape = true;
                    if (!escapeConfig.isUseEscapeClausole()) continue;
                    escapeSqlPattern.setUseEscapeClausole(true);
                    escapeSqlPattern.setEscapeClausole(escapeConfig.getEscapeClausole());
                }
            }
            str.append(v[i]);
            if (!escape) continue;
            escape = false;
        }
        String returnStr = str.toString();
        escapeSqlPattern.setEscapeValue(returnStr);
        return escapeSqlPattern;
    }

    protected abstract EscapeSQLConfiguration getEscapeSQLConfiguration();

    @Override
    public ISQLQueryObject addGroupBy(String groupByNomeField) throws SQLQueryObjectException {
        if (groupByNomeField == null || "".equals(groupByNomeField)) {
            throw new SQLQueryObjectException("GroupBy Condition is null or empty string");
        }
        if (this.alias.containsKey(groupByNomeField)) {
            this.groupBy.add(this.alias.get(groupByNomeField));
        } else {
            this.groupBy.add(groupByNomeField);
        }
        return this;
    }

    protected Vector<String> getGroupByConditions() throws SQLQueryObjectException {
        if (this.groupBy != null && this.groupBy.size() > 0 && this.fields.size() <= 0) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field");
        }
        return this.groupBy;
    }

    @Override
    public ISQLQueryObject addOrderBy(String orderByNomeField) throws SQLQueryObjectException {
        if (orderByNomeField == null || "".equals(orderByNomeField)) {
            throw new SQLQueryObjectException("OrderBy Condition is null or empty string");
        }
        this.orderBy.add(orderByNomeField);
        return this;
    }

    @Override
    public void setSortType(boolean sort) throws SQLQueryObjectException {
        if (this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("OrderBy Conditions non definite");
        }
        this.sortTypeAsc = sort;
    }

    @Override
    public void setLimit(int limit) throws SQLQueryObjectException {
        this.limit = limit;
    }

    @Override
    public void setOffset(int offset) throws SQLQueryObjectException {
        this.offset = offset;
    }

    @Override
    public abstract String createSQLQuery() throws SQLQueryObjectException;

    public String toString() {
        try {
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    @Override
    public String toString(boolean delete) {
        try {
            if (delete) {
                return this.createSQLDelete();
            }
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    protected void checkUnionField(boolean count, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObjectDaVerificare;
        int i;
        if (count) {
            if (this.orderBy != null && this.orderBy.size() > 0) {
                throw new SQLQueryObjectException("Non e' possibile usare order by in una count");
            }
            if (this.limit > 0) {
                throw new SQLQueryObjectException("Non e' possibile usare limit in una count");
            }
            if (this.offset >= 0) {
                throw new SQLQueryObjectException("Non e' possibile usare offset in una count");
            }
        }
        if (this.offset >= 0 && this.fields.size() <= 0) {
            throw new SQLQueryObjectException("Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
        }
        if (this.limit > 0 && this.fields.size() <= 0) {
            throw new SQLQueryObjectException("Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
        }
        if (this.distinct) {
            throw new SQLQueryObjectException("Non e' possibile usare distinct nella select piu' esterna della union (utilizza il parametro boolean unionAll)");
        }
        if (sqlQueryObject == null || sqlQueryObject.length <= 0) {
            throw new SQLQueryObjectException("Parametro is null");
        }
        if (sqlQueryObject.length == 1) {
            throw new SQLQueryObjectException("Parametro contiene un solo sqlQueryObject (minimo 2)");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            sqlQueryObjectDaVerificare = sqlQueryObject[i];
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObjectDaVerificare.getFieldsName();
            if (nomiFieldSqlQueryObjectDaVerificare != null && nomiFieldSqlQueryObjectDaVerificare.size() != 0) continue;
            throw new SQLQueryObjectException("La select numero " + (i + 1) + " non possiede fields?");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObject[i].getFieldsName();
            String[] nomi = nomiFieldSqlQueryObjectDaVerificare.toArray(new String[1]);
            for (int indiceField = 0; indiceField < nomi.length; ++indiceField) {
                String fieldDaVerificare = nomi[indiceField];
                for (int altriSqlObject = 0; altriSqlObject < sqlQueryObject.length; ++altriSqlObject) {
                    if (altriSqlObject == i || sqlQueryObject[altriSqlObject].getFieldsName().contains(fieldDaVerificare) || sqlQueryObject[altriSqlObject].getFieldsName().contains("*")) continue;
                    throw new SQLQueryObjectException("Field [" + fieldDaVerificare + "] trovato nella select numero " + (i + 1) + " non presente nella select numero " + (altriSqlObject + 1) + " (Se sono campi diversi usare lo stesso alias)");
                }
            }
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            sqlQueryObjectDaVerificare = (SQLQueryObjectCore)sqlQueryObject[i];
            if (((SQLQueryObjectCore)sqlQueryObjectDaVerificare).orderBy == null || ((SQLQueryObjectCore)sqlQueryObjectDaVerificare).orderBy.size() <= 0 || ((SQLQueryObjectCore)sqlQueryObjectDaVerificare).offset >= 0) continue;
            ((SQLQueryObjectCore)sqlQueryObjectDaVerificare).setOffset(0);
        }
    }

    @Override
    public ISQLQueryObject addUpdateTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.updateTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addUpdateField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.updateFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli update fields");
        }
        this.updateFieldsName.add(nomeField);
        this.updateFieldsValue.add(valueField);
        return this;
    }

    @Override
    public ISQLQueryObject addInsertTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.insertTable = nomeTabella;
        return this;
    }

    @Override
    public ISQLQueryObject addInsertField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.insertFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli insert fields");
        }
        this.insertFieldsName.add(nomeField);
        this.insertFieldsValue.add(valueField);
        return this;
    }

    @Override
    public String createSQLInsert() throws SQLQueryObjectException {
        int i;
        if (this.insertTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'inserimento non definito");
        }
        if (this.insertFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da inserire presente");
        }
        if (this.insertFieldsName.size() != this.insertFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(this.insertTable);
        bf.append(" (");
        for (i = 0; i < this.insertFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsName.get(i));
        }
        bf.append(") VALUES (");
        for (i = 0; i < this.insertFieldsValue.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsValue.get(i));
        }
        bf.append(")");
        return bf.toString();
    }

    @Override
    public ISQLQueryObject addDeleteTable(String tabella) throws SQLQueryObjectException {
        this.checkDeleteTable(tabella);
        this.addFromTable(tabella);
        return this;
    }

    protected void checkDeleteTable(String tabella) throws SQLQueryObjectException {
        if (tabella.contains(" as ") || tabella.contains(" ")) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
        List<String> asModeSupportati = this.getSupportedAliasesTable();
        for (String aliasMode : asModeSupportati) {
            if (!tabella.contains(aliasMode)) continue;
            throw new SQLQueryObjectException("Non e' possibile utilizzare tabelle definite tramite alias in caso di delete");
        }
    }

    @Override
    public ISQLQueryObject newSQLQueryObject() throws SQLQueryObjectException {
        return SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
    }

    @Override
    public String getTipoDatabase() throws SQLQueryObjectException {
        return this.tipoDatabase.toString();
    }

    @Override
    public TipiDatabase getTipoDatabaseOpenSPCoop2() throws SQLQueryObjectException {
        return this.tipoDatabase;
    }
}

