/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.DB2QueryObject;
import org.openspcoop2.utils.sql.HyperSQLQueryObject;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.MySQLQueryObject;
import org.openspcoop2.utils.sql.OracleQueryObject;
import org.openspcoop2.utils.sql.PostgreSQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.openspcoop2.utils.sql.SQLServerQueryObject;

public class SQLObjectFactory {
    public static ISQLQueryObject createSQLQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        return SQLObjectFactory.toQueryObject(tipoDatabase);
    }

    public static ISQLQueryObject createSQLQueryObject(TipiDatabase tipoDatabase) throws SQLQueryObjectException {
        return SQLObjectFactory.createSQLQueryObject(tipoDatabase.toString());
    }

    public static ISQLQueryObject toQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        if (TipiDatabase.POSTGRESQL.equals(tipoDatabase)) {
            return new PostgreSQLQueryObject(TipiDatabase.POSTGRESQL);
        }
        if (TipiDatabase.MYSQL.equals(tipoDatabase)) {
            return new MySQLQueryObject(TipiDatabase.MYSQL);
        }
        if (TipiDatabase.ORACLE.equals(tipoDatabase)) {
            return new OracleQueryObject(TipiDatabase.ORACLE);
        }
        if (TipiDatabase.HSQL.toString().equals(tipoDatabase)) {
            return new HyperSQLQueryObject(TipiDatabase.HSQL);
        }
        if (TipiDatabase.SQLSERVER.toString().equals(tipoDatabase)) {
            return new SQLServerQueryObject(TipiDatabase.SQLSERVER);
        }
        if (TipiDatabase.DB2.toString().equals(tipoDatabase)) {
            return new DB2QueryObject(TipiDatabase.DB2);
        }
        throw new SQLQueryObjectException("Tipo database non gestito [" + tipoDatabase + "]");
    }
}

