/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.util.Iterator;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.EscapeSQLConfiguration;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class PostgreSQLQueryObject
extends SQLQueryObjectCore {
    public PostgreSQLQueryObject(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public String getUnixTimestampConversion(String column) {
        return "(date_part('epoch'," + column + ")*1000)";
    }

    @Override
    public String getDiffUnixTimestamp(String columnMax, String columnMin) {
        return this.getUnixTimestampConversion("( " + columnMax + " - " + columnMin + " )");
    }

    @Override
    public ISQLQueryObject addSelectAvgTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "avg(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addSelectSumTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "sum(" + this.getUnixTimestampConversion(field) + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + this.getDefaultAliasFieldKeyword() + alias;
        }
        this._engine_addSelectField(null, fieldSQL, null, false, true);
        this.fieldNames.add(alias);
        return this;
    }

    @Override
    public ISQLQueryObject addFromTable(ISQLQueryObject subSelect) throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append(" ( ");
        bf.append(subSelect.createSQLQuery());
        bf.append(" ) as subquery" + this.getSerial() + " ");
        this.addFromTable(bf.toString());
        return this;
    }

    @Override
    protected EscapeSQLConfiguration getEscapeSQLConfiguration() {
        EscapeSQLConfiguration config = new EscapeSQLConfiguration();
        config.setSpecial_char(new char[]{'_', '%'});
        config.setUseEscapeClausole(false);
        config.setEscapeClausole('\\');
        return config;
    }

    @Override
    public String createSQLQuery() throws SQLQueryObjectException {
        return this.createSQLQuery(false);
    }

    private String createSQLQuery(boolean union) throws SQLQueryObjectException {
        this.precheckBuildQuery();
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        Iterator itForceIndex = this.forceIndexTableNames.iterator();
        while (itForceIndex.hasNext()) {
            bf.append(" " + (String)itForceIndex.next() + " ");
        }
        if (this.isSelectDistinct()) {
            bf.append(" DISTINCT ");
        }
        if (this.fields.size() == 0) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        bf.append(this.getSQL(false, false, false, union));
        return bf.toString();
    }

    @Override
    public String createSQLDelete() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        if (this.tables.size() == 0) {
            throw new SQLQueryObjectException("Non e' possibile creare un comando di delete senza aver definito le tabelle su cui apportare l'eliminazione dei dati");
        }
        for (String table : this.tables) {
            this.checkDeleteTable(table);
        }
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false, false, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update, boolean conditions, boolean union) throws SQLQueryObjectException {
        boolean first;
        Iterator<Object> it;
        StringBuffer bf = new StringBuffer();
        if (!update && !conditions) {
            bf.append(" FROM ");
            if (this.tables.size() == 0) {
                throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
            }
            if (delete && this.tables.size() > 2) {
                throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
            }
            it = this.tables.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (this.conditions.size() > 0) {
            if (!conditions) {
                bf.append(" WHERE ");
            }
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        if (!(this.getGroupByConditions().size() <= 0 || delete || update || conditions)) {
            bf.append(" GROUP BY ");
            it = this.getGroupByConditions().iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        if (!(this.orderBy.size() <= 0 || delete || update || conditions)) {
            bf.append(" ORDER BY ");
            it = this.orderBy.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
            if (this.sortTypeAsc) {
                bf.append(" ASC ");
            } else {
                bf.append(" DESC ");
            }
        }
        if (this.offset >= 0 && this.orderBy.size() == 0) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (!(this.limit <= 0 || delete || update || conditions)) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (!(this.offset < 0 || delete || update || conditions)) {
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        boolean first;
        this.checkUnionField(false, sqlQueryObject);
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        Iterator itForceIndex = this.forceIndexTableNames.iterator();
        while (itForceIndex.hasNext()) {
            bf.append(" " + (String)itForceIndex.next() + " ");
        }
        if (this.fields.size() == 0) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
        }
        bf.append(" FROM ( ");
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            if (i > 0) {
                bf.append(" UNION ");
                if (unionAll) {
                    bf.append(" ALL ");
                }
            }
            bf.append("( ");
            bf.append(((PostgreSQLQueryObject)sqlQueryObject[i]).createSQLQuery(true));
            bf.append(") ");
        }
        bf.append(" ) as subquery" + this.getSerial() + " ");
        if (this.getGroupByConditions().size() > 0) {
            bf.append(" GROUP BY ");
            Iterator<String> it = this.getGroupByConditions().iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append(it.next());
            }
        }
        if (this.orderBy.size() > 0) {
            bf.append(" ORDER BY ");
            Iterator it = this.orderBy.iterator();
            first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                bf.append((String)it.next());
            }
            if (this.sortTypeAsc) {
                bf.append(" ASC ");
            } else {
                bf.append(" DESC ");
            }
        }
        if (this.offset >= 0 && this.orderBy.size() == 0) {
            throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
        }
        if (this.limit > 0) {
            bf.append(" LIMIT ");
            bf.append(this.limit);
        }
        if (this.offset >= 0) {
            bf.append(" OFFSET ");
            bf.append(this.offset);
        }
        return bf.toString();
    }

    @Override
    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(true, sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT count(*) " + this.getDefaultAliasFieldKeyword() + " ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        bf.append(this.createSQLUnion(unionAll, sqlQueryObject));
        bf.append(" ) as subquery" + this.getSerial() + " ");
        return bf.toString();
    }

    @Override
    public String createSQLUpdate() throws SQLQueryObjectException {
        if (this.updateTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'aggiornamento non definito");
        }
        if (this.updateFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da aggiornare presente");
        }
        if (this.updateFieldsName.size() != this.updateFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true, false, false));
        return bf.toString();
    }

    @Override
    public String createSQLConditions() throws SQLQueryObjectException {
        if (this.conditions == null) {
            throw new SQLQueryObjectException("Condizioni non definite");
        }
        if (this.conditions.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna condizione presente");
        }
        StringBuffer bf = new StringBuffer();
        bf.append(this.getSQL(false, false, true, false));
        return bf.toString();
    }
}

