/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class ClientTest {
    private static int ROW = 21;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        Enum tipoDatabase = null;
        if (args.length > 0 && !"${tipoDatabase}".equals(args[0].trim())) {
            tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        }
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        switch (1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[tipoDatabase.ordinal()]) {
            case 1: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 2: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 3: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                break;
            }
            case 4: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                break;
            }
            case 5: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
            case 6: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        Class.forName(driver).newInstance();
        Connection con = null;
        Statement stmtDelete = null;
        Statement stmtInsert = null;
        try {
            long increment;
            int index;
            String descrizione;
            int i;
            con = DriverManager.getConnection(url, userName, password);
            String delete = "delete from msgdiagnostici";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            delete = "delete from tracce";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            stmtDelete.close();
            for (i = 0; i < ROW; ++i) {
                String insertMsgDiagnosticoWithGdo = "INSERT INTO msgdiagnostici (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario) VALUES (?,?,?,?,?,?,?)";
                String insertMsgDiagnosticoWithoutGdo = "INSERT INTO msgdiagnostici (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario) VALUES (?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    descrizione = "descrizione con caratteri particolari finisce con ---- [ _ % ^ ] -----";
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertMsgDiagnosticoWithGdo) : con.prepareStatement(insertMsgDiagnosticoWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.execute();
                stmtInsert.close();
            }
            for (i = 0; i < ROW; ++i) {
                String insertTracciaWithGdo = "INSERT INTO tracce (descrizione,gdo,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario) VALUES (?,?,?,?,?,?,?)";
                String insertTracciaWithoutGdo = "INSERT INTO tracce (descrizione,gdo2,tipo_mittente,mittente,tipo_destinatario,destinatario) VALUES (?,?,?,?,?,?)";
                descrizione = "descrizione esempio " + i;
                if (i > 9) {
                    descrizione = "descrizione esempio uguale";
                }
                if (i == 20) {
                    descrizione = "descrizione con caratteri particolari finisce con ---- [ _ % ^ ] -----";
                }
                stmtInsert = i % 2 == 0 ? con.prepareStatement(insertTracciaWithGdo) : con.prepareStatement(insertTracciaWithoutGdo);
                index = 1;
                stmtInsert.setString(index++, descrizione);
                if (i % 2 == 0) {
                    stmtInsert.setTimestamp(index++, DateManager.getTimestamp());
                    increment = 10368000000L * (long)(i + 1);
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + increment + (long)(200101 * (i + 1))));
                } else {
                    stmtInsert.setTimestamp(index++, new Timestamp(DateManager.getTimeMillis() + (long)(23 * (i + 1))));
                }
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoMittente" + i / 2);
                stmtInsert.setString(index++, "SPC");
                stmtInsert.setString(index++, "SoggettoDestinatario" + i / 2);
                stmtInsert.execute();
                stmtInsert.close();
            }
            ClientTest.testUnixTime_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con);
            ClientTest.testUnixTime_engine((TipiDatabase)tipoDatabase, "tracce", con);
            ClientTest.testFromTable_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con);
            ClientTest.testLikeEscapeChar_engine((TipiDatabase)tipoDatabase, "msgdiagnostici", con);
            ClientTest.test0_engine((TipiDatabase)tipoDatabase, con);
            ClientTest.test1_engine((TipiDatabase)tipoDatabase, false, con);
            ClientTest.test1_engine((TipiDatabase)tipoDatabase, true, con);
            ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, false, true, con);
            ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, true, true, con);
            ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, false, false, con);
            ClientTest.testUnion_engine((TipiDatabase)tipoDatabase, true, false, con);
            ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, false, true, con);
            ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, true, true, con);
            ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, false, false, con);
            ClientTest.testUnionWithGroupBy_engine((TipiDatabase)tipoDatabase, true, false, con);
        }
        finally {
            try {
                stmtDelete.close();
            }
            catch (Exception eClose) {}
            try {
                stmtInsert.close();
            }
            catch (Exception eClose) {}
            try {
                con.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void testUnixTime_engine(TipiDatabase tipo, String table, Connection con) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getUnixTimestampConversion("gdo"), "unixtime");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            String testUnixTime = sqlQueryObject.createSQLQuery();
            System.out.println("\ntest1-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(testUnixTime);
            int index = 0;
            if (!rs.next()) throw new Exception("UnixTime test1 failed");
            long timeStampValue = rs.getTimestamp("gdo").getTime();
            long convertValue = rs.getLong("unixtime");
            System.out.println("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + " timeValue:" + timeStampValue + ") (" + convertValue + ")");
            if (timeStampValue != convertValue) {
                if (!TipiDatabase.ORACLE.equals(tipo)) throw new Exception("UnixTime test failed diff(" + (convertValue - timeStampValue) + ")");
                if (timeStampValue != convertValue - 1000L) {
                    throw new Exception("UnixTime test failed diff(" + (convertValue - timeStampValue) + ")");
                }
            }
            rs.close();
            stmtQuery.close();
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectAvgTimestampField("gdo", "unixtimeavg");
            sqlQueryObject.addSelectMinTimestampField("gdo", "unixtimemin");
            sqlQueryObject.addSelectMaxTimestampField("gdo", "unixtimemax");
            sqlQueryObject.addSelectSumTimestampField("gdo", "unixtimesum");
            sqlQueryObject.addGroupBy("descrizione");
            testUnixTime = sqlQueryObject.createSQLQuery();
            System.out.println("\ntest2-" + table + " unixtime:\n\t" + testUnixTime);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(testUnixTime);
            index = 0;
            while (rs.next()) {
                System.out.println("riga[" + index++ + "]=" + rs.getString("descrizione") + " [min:" + rs.getLong("unixtimemin") + " max:" + rs.getLong("unixtimemax") + " avg:" + rs.getLong("unixtimeavg") + " sum:" + rs.getLong("unixtimesum") + "]");
            }
            rs.close();
            stmtQuery.close();
            sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            String format = "yyyy-MM-dd_HH:mm:ss.SSS";
            SimpleDateFormat dateformat = new SimpleDateFormat(format);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.addSelectField("gdo2");
            sqlQueryObject.addSelectAliasField(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"), "latenza");
            sqlQueryObject.addOrderBy(sqlQueryObject.getDiffUnixTimestamp("gdo2", "gdo"));
            sqlQueryObject.setSortType(true);
            testUnixTime = sqlQueryObject.createSQLQuery();
            System.out.println("\ntest3-" + table + " unixtime:\n\t" + testUnixTime);
            long oldLatenza = 0L;
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(testUnixTime);
            int index2 = 0;
            while (rs.next()) {
                long latenza = rs.getLong("latenza");
                System.out.println("riga[" + index2++ + "]=" + rs.getString("descrizione") + " gdo[" + dateformat.format(rs.getTimestamp("gdo")) + "] gdo2[" + dateformat.format(rs.getTimestamp("gdo2")) + "] [msLatenza:" + latenza + " humanReadable:" + Utilities.convertSystemTimeIntoString_millisecondi(latenza, true) + "]");
                if (latenza <= oldLatenza) {
                    throw new Exception("Attesa latenza con ordinamento crescente. Latenza della entry precedente aveva [" + oldLatenza + "]");
                }
                if (index2 > 10 && latenza < 10000000000L) {
                    throw new Exception("Attesa latenza enorme, riscontro non avvenuto");
                }
                oldLatenza = latenza;
            }
            rs.close();
            stmtQuery.close();
            return;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFromTable_engine(TipiDatabase tipo, String table, Connection con) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            SQLQueryObjectCore sqlQueryObjectExternal = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObjectExternal.addFromTable(sqlQueryObject);
            String test = sqlQueryObjectExternal.createSQLQuery();
            System.out.println("\ntest-" + table + " fromTable:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            System.out.println("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            rs.close();
            stmtQuery.close();
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testLikeEscapeChar_engine(TipiDatabase tipo, String table, Connection con) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            SQLQueryObjectCore sqlQueryObject = (SQLQueryObjectCore)SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable(table);
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("gdo");
            sqlQueryObject.setLimit(1);
            sqlQueryObject.addOrderBy("gdo");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.addWhereLikeCondition("descrizione", "[ _ % ^ ]", true, true);
            String test = sqlQueryObject.createSQLQuery();
            System.out.println("\ntest-" + table + " escapeLike:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (!rs.next()) {
                throw new Exception("Test failed");
            }
            System.out.println("riga[" + index++ + "]=" + rs.getString("descrizione") + " (time:" + rs.getTimestamp("gdo") + ")");
            rs.close();
            stmtQuery.close();
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test0_engine(TipiDatabase tipo, Connection con) throws Exception {
        Statement stmtQuery = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addFromTable("msgdiagnostici", "aliasMSG");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectCountField("aliasMSG", "id", "cont", true);
            sqlQueryObject.addSelectAvgField("aliasMSG", "id", "avgMedio");
            sqlQueryObject.addSelectField("aliasMSG", "mittente");
            sqlQueryObject.addSelectAliasField("aliasMSG", "destinatario", "ALIASDEST");
            sqlQueryObject.addWhereIsNotNullCondition("tracce.tipo_mittente");
            sqlQueryObject.addGroupBy("aliasMSG.mittente");
            sqlQueryObject.addGroupBy("ALIASDEST");
            sqlQueryObject.addOrderBy("cont");
            sqlQueryObject.addOrderBy("avgMedio");
            sqlQueryObject.addOrderBy("mittente");
            sqlQueryObject.setSortType(true);
            Vector<String> trovato = sqlQueryObject.getFieldsName();
            System.out.println("(test0_engine) [" + tipo.toString() + "] getFieldsName: \t" + trovato);
            String atteso = "cont, mittente, ALIASDEST";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getFieldsName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            trovato = sqlQueryObject.getTablesName();
            System.out.println("(test0_engine) [" + tipo.toString() + "] getTablesName: \t" + trovato);
            atteso = "tracce, aliasMSG";
            if (atteso.equals(trovato.toString())) {
                throw new Exception("Test failed (getTablesName) trovato[" + trovato.toString() + "] atteso[" + atteso + "]");
            }
            System.out.println("");
            String test = sqlQueryObject.createSQLQuery();
            System.out.println("\ntest0_engine:\n\t" + test);
            stmtQuery = con.createStatement();
            rs = stmtQuery.executeQuery(test);
            int index = 0;
            if (rs.next()) {
                System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                while (rs.next()) {
                    System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + "->" + rs.getString("ALIASDEST") + ") (count:" + rs.getLong("cont") + ")");
                }
            } else {
                throw new Exception("Test failed");
            }
            rs.close();
            stmtQuery.close();
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception eClose) {}
            try {
                stmtQuery.close();
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test1_engine(TipiDatabase tipo, boolean distinct, Connection con) throws Exception {
        block195: {
            String test;
            int limit;
            String mittente;
            ISQLQueryObject sqlQueryObject;
            ResultSet rs;
            Statement stmtQuery;
            block194: {
                block193: {
                    int index;
                    String test2;
                    int index2;
                    String test3;
                    int limit2;
                    stmtQuery = null;
                    rs = null;
                    try {
                        System.out.println("\n\na. ** Query normale");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectField("tracce", "tipo_destinatario");
                        sqlQueryObject.addSelectField("tracce.destinatario");
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        String test4 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryNormale]:\n\t" + test4);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test4);
                        int index3 = 0;
                        if (rs.next()) {
                            System.out.println("riga[" + index3++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                System.out.println("riga[" + index3++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index3 != ROW / 2 + 1) {
                                throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index3 + ")");
                            }
                        } else if (index3 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index3 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\nb. ** Query con limit/offset");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectField("tracce", "tipo_destinatario");
                        sqlQueryObject.addSelectField("tracce.destinatario");
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject.setLimit(limit2);
                        sqlQueryObject.setOffset(0);
                        test3 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimitOffset]:\n\t" + test3);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            System.out.println("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                System.out.println("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\nc. ** Query con limit");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectField("tracce", "tipo_destinatario");
                        sqlQueryObject.addSelectField("tracce.destinatario");
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        limit2 = 10;
                        sqlQueryObject.setLimit(limit2);
                        test3 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryLimit]:\n\t" + test3);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test3);
                        index2 = 0;
                        if (rs.next()) {
                            if (!(index2 != 0 && index2 != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                            }
                            System.out.println("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                System.out.println("riga[" + index2++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index2 != limit2) {
                            throw new Exception("Test failed (expected " + limit2 + " rows, found:" + index2 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\nd. ** Query con offset");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectField("tracce", "tipo_destinatario");
                        sqlQueryObject.addSelectField("tracce.destinatario");
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.setOffset(2);
                        test2 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QueryOffset]:\n\t" + test2);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            String mittente2;
                            if (distinct) {
                                String mittente3;
                                if (index == 0 && !(mittente3 = rs.getString("mittente")).endsWith("10")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 10)");
                                }
                                if (index == 1 && !(mittente = rs.getString("mittente")).endsWith("2")) {
                                    throw new Exception("Test failed (atteso un nome di mittente che termina con 2)");
                                }
                            } else if (!(index != 0 && index != 1 || (mittente2 = rs.getString("mittente")).endsWith("1"))) {
                                throw new Exception("Test failed (atteso un nome di mittente che termina con 1)");
                            }
                            System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (distinct) {
                            if (index != (ROW - 2) / 2) {
                                throw new Exception("Test failed (expected " + (ROW - 2) / 2 + " rows, found:" + index + ")");
                            }
                        } else if (index != ROW - 2) {
                            throw new Exception("Test failed (expected " + (ROW - 2) + " rows, found:" + index + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\ne. ** Query groupBy");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectCountField("id", "cont", true);
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addSelectField("tracce.tipo_destinatario");
                        sqlQueryObject.addSelectField("destinatario");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tracce.tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("tipo_destinatario");
                        sqlQueryObject.addGroupBy("tracce.destinatario");
                        test2 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupBy]:\n\t" + test2);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test2);
                        index = 0;
                        if (rs.next()) {
                            System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont") + "");
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + index + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont") + "");
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    throw new Exception("Test failed row[" + index + "] found:" + rs.getLong("cont") + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                throw new Exception("Test failed row[" + index + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != ROW / 2 + 1) {
                            throw new Exception("Test failed (expected " + (ROW / 2 + 1) + " rows, found:" + index + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\nf. ** Query groupBy con limit/offset");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addSelectCountField("id", "cont", true);
                        sqlQueryObject.addSelectField("mittente");
                        sqlQueryObject.addSelectField("tracce.tipo_destinatario");
                        sqlQueryObject.addSelectField("destinatario");
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tracce.tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.addGroupBy("mittente");
                        sqlQueryObject.addGroupBy("tipo_destinatario");
                        sqlQueryObject.addGroupBy("tracce.destinatario");
                        int limit3 = 5;
                        sqlQueryObject.setLimit(limit3);
                        sqlQueryObject.setOffset(1);
                        String test5 = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [GroupByLimitOffset]:\n\t" + test5);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test5);
                        int index4 = 0;
                        if (rs.next()) {
                            System.out.println("riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont") + "");
                            if (2L != rs.getLong("cont")) {
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                            while (rs.next()) {
                                System.out.println("riga[" + index4++ + "]= (" + rs.getString("mittente") + ") = " + rs.getLong("cont") + "");
                                if (rs.getString("mittente").endsWith("10")) {
                                    if (1L == rs.getLong("cont")) continue;
                                    throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + rs.getLong("cont") + " expected:1");
                                }
                                if (2L == rs.getLong("cont")) continue;
                                throw new Exception("Test failed row[" + (index4 - 1) + "] found:" + rs.getLong("cont") + " expected:2");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index4 != limit3) {
                            throw new Exception("Test failed (expected " + limit3 + " rows, found:" + index4 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        System.out.println("\n\ng. ** Query con select*");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addFromTable("tracce");
                        sqlQueryObject.setSelectDistinct(distinct);
                        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.addOrderBy("tipo_destinatario");
                        sqlQueryObject.addOrderBy("tracce.destinatario");
                        sqlQueryObject.setSortType(true);
                        String test6 = null;
                        try {
                            test6 = sqlQueryObject.createSQLQuery();
                            System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*]:\n\t" + test6);
                            if (distinct) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                            }
                        }
                        catch (SQLQueryObjectException s) {
                            if (distinct) {
                                if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                    throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                                }
                            }
                            throw s;
                        }
                        if (distinct) break block193;
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test6);
                        int index5 = 0;
                        if (rs.next()) {
                            System.out.println("riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            while (rs.next()) {
                                System.out.println("riga[" + index5++ + "]= (" + rs.getString("mittente") + ")");
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index5 != ROW) {
                            throw new Exception("Test failed (expected " + ROW + " rows, found:" + index5 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                }
                try {
                    System.out.println("\n\nh. ** Query con select* e offset/limit");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                    sqlQueryObject.addFromTable("tracce");
                    sqlQueryObject.setSelectDistinct(distinct);
                    sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.addOrderBy("tipo_destinatario");
                    sqlQueryObject.addOrderBy("tracce.destinatario");
                    sqlQueryObject.setSortType(true);
                    limit = 10;
                    sqlQueryObject.setLimit(limit);
                    sqlQueryObject.setOffset(0);
                    test = null;
                    try {
                        test = sqlQueryObject.createSQLQuery();
                        System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffset*]:\n\t" + test);
                        if (distinct) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                        }
                    }
                    catch (SQLQueryObjectException s) {
                        if (distinct) {
                            if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                                throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                            }
                        }
                        throw s;
                    }
                    if (distinct) break block194;
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                            throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                        }
                        System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        while (rs.next()) {
                            System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != limit) {
                        throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                    }
                    rs.close();
                    stmtQuery.close();
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception eClose) {}
                    try {
                        stmtQuery.close();
                    }
                    catch (Exception eClose) {}
                }
            }
            try {
                System.out.println("\n\ni. ** Query con select* e offset/limit e alias");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                sqlQueryObject.addFromTable("tracce", "tr");
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.addOrderBy("tipo_destinatario");
                sqlQueryObject.addOrderBy("tr.destinatario");
                sqlQueryObject.setSortType(true);
                limit = 10;
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(0);
                test = null;
                try {
                    test = sqlQueryObject.createSQLQuery();
                    System.out.println("\nTest1(" + distinct + ") [" + tipo.toString() + "] [QuerySelect*LimitOffsetAlias*]:\n\t" + test);
                    if (distinct) {
                        throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field");
                    }
                }
                catch (SQLQueryObjectException s) {
                    if (distinct) {
                        if (!s.getMessage().equals("Per usare la select distinct devono essere indicati dei select field")) {
                            throw new Exception("Attesa eccezione: Per usare la select distinct devono essere indicati dei select field. Trovata: " + s.getMessage());
                        }
                    }
                    throw s;
                }
                if (distinct) break block195;
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                if (rs.next()) {
                    if (!(index != 0 && index != 1 || (mittente = rs.getString("mittente")).endsWith("0"))) {
                        throw new Exception("Test failed (atteso un nome di mittente che termina con 0)");
                    }
                    System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    while (rs.next()) {
                        System.out.println("riga[" + index++ + "]= (" + rs.getString("mittente") + ")");
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                rs.close();
                stmtQuery.close();
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception eClose) {}
                try {
                    stmtQuery.close();
                }
                catch (Exception eClose) {}
            }
        }
    }

    private static ISQLQueryObject prepareForUnion(ISQLQueryObject sqlQueryObject, int limit) throws SQLQueryObjectException {
        sqlQueryObject.addFromTable("tracce");
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.addSelectCountField("id", "cont", true);
        sqlQueryObject.addSelectField("mittente");
        sqlQueryObject.addWhereIsNotNullCondition("tipo_mittente");
        sqlQueryObject.addOrderBy("mittente");
        sqlQueryObject.setSortType(true);
        sqlQueryObject.addGroupBy("mittente");
        sqlQueryObject.setLimit(limit);
        sqlQueryObject.setOffset(0);
        return sqlQueryObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnion_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con) throws Exception {
        block161: {
            int index;
            ISQLQueryObject sqlQueryObject;
            ISQLQueryObject prepare2;
            ISQLQueryObject prepare1;
            ResultSet rs;
            Statement stmtQuery;
            block159: {
                long cont;
                String mit;
                block158: {
                    block157: {
                        stmtQuery = null;
                        rs = null;
                        try {
                            System.out.println("\n\na. ** Query Union (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                            prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            if (!count) {
                                sqlQueryObject.addOrderBy("mittente");
                                sqlQueryObject.setSortType(true);
                            }
                            String test = null;
                            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            index = 0;
                            if (rs.next()) {
                                if (count) {
                                    long cont2 = rs.getLong("aliasUnion");
                                    System.out.println("riga[" + index++ + "]= [" + cont2 + "]");
                                    if (unionAll) {
                                        if (cont2 != (long)(limit * 2)) {
                                            throw new Exception("Expected " + limit * 2 + ", found " + cont2);
                                        }
                                    } else if (cont2 != (long)limit) {
                                        throw new Exception("Expected " + limit + ", found " + cont2);
                                    }
                                } else {
                                    String mit2 = rs.getString("mit");
                                    long cont3 = rs.getLong("cont");
                                    System.out.println("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (cont3 != 1L) {
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                    } else if (cont3 != 2L) {
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                    while (rs.next()) {
                                        mit2 = rs.getString("mit");
                                        cont3 = rs.getLong("cont");
                                        System.out.println("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                        if (mit2.endsWith("10")) {
                                            if (cont3 == 1L) continue;
                                            throw new Exception("Expected 1, found " + cont3);
                                        }
                                        if (cont3 == 2L) continue;
                                        throw new Exception("Expected 2, found " + cont3);
                                    }
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (count) {
                                if (index != 1) {
                                    throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                                }
                            } else if (unionAll) {
                                if (index != limit * 2) {
                                    throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                                }
                            } else if (index != limit) {
                                throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                            }
                            rs.close();
                            stmtQuery.close();
                        }
                        finally {
                            try {
                                rs.close();
                            }
                            catch (Exception eClose) {}
                            try {
                                stmtQuery.close();
                            }
                            catch (Exception eClose) {}
                        }
                        try {
                            if (count) break block157;
                            System.out.println("\n\nb. ** Query Union OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            int limit = 5;
                            prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                            prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                            sqlQueryObject.addSelectAliasField("mittente", "mit");
                            sqlQueryObject.addSelectField("cont");
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.setSortType(true);
                            int limitEsterno = 6;
                            int offset = 2;
                            if (!unionAll) {
                                limitEsterno /= 2;
                                offset /= 2;
                            }
                            sqlQueryObject.setLimit(limitEsterno);
                            sqlQueryObject.setOffset(offset);
                            String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                            System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                            stmtQuery = con.createStatement();
                            rs = stmtQuery.executeQuery(test);
                            int index2 = 0;
                            if (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                System.out.println("riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont != 1L) {
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                } else if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                while (rs.next()) {
                                    mit = rs.getString("mit");
                                    cont = rs.getLong("cont");
                                    System.out.println("riga[" + index2++ + "]= (" + mit + "):[" + cont + "]");
                                    if (mit.endsWith("10")) {
                                        if (cont == 1L) continue;
                                        throw new Exception("Expected 1, found " + cont);
                                    }
                                    if (cont == 2L) continue;
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else {
                                throw new Exception("Test failed");
                            }
                            if (index2 != limitEsterno) {
                                throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index2 + ")");
                            }
                            rs.close();
                            stmtQuery.close();
                        }
                        finally {
                            try {
                                rs.close();
                            }
                            catch (Exception eClose) {}
                            try {
                                stmtQuery.close();
                            }
                            catch (Exception eClose) {}
                        }
                    }
                    try {
                        if (count) break block158;
                        System.out.println("\n\nc. ** Query Union OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectField("cont");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.setSortType(true);
                        int offset = 2;
                        if (!unionAll) {
                            offset /= 2;
                        }
                        int numeroEntriesRisultato = limit * 2 - offset;
                        if (!unionAll) {
                            numeroEntriesRisultato = limit - offset;
                        }
                        sqlQueryObject.setOffset(offset);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index3 = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            System.out.println("riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("cont");
                                System.out.println("riga[" + index3++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (cont == 1L) continue;
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (cont == 2L) continue;
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index3 != numeroEntriesRisultato) {
                            throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index3 + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                }
                try {
                    if (count) break block159;
                    System.out.println("\n\nd. ** Query Union Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectField("cont");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.setSortType(true);
                    int limitEsterno = 4;
                    if (!unionAll) {
                        limitEsterno /= 2;
                    }
                    sqlQueryObject.setLimit(limitEsterno);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index4 = 0;
                    boolean foundEndsWith10 = false;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("cont");
                        System.out.println("riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            foundEndsWith10 = true;
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("cont");
                            System.out.println("riga[" + index4++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index4 != limitEsterno) {
                        throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index4 + ")");
                    }
                    if (foundEndsWith10) {
                        throw new Exception("Test failed, unexpected element ends with 10");
                    }
                    rs.close();
                    stmtQuery.close();
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception eClose) {}
                    try {
                        stmtQuery.close();
                    }
                    catch (Exception eClose) {}
                }
            }
            try {
                System.out.println("\n\ne. ** Query Union con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                if (!count) {
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.setSortType(true);
                }
                String test = null;
                test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                index = 0;
                if (rs.next()) {
                    if (count) {
                        long cont = rs.getLong("aliasUnion");
                        System.out.println("riga[" + index++ + "]= [" + cont + "]");
                        if (unionAll) {
                            if (cont != (long)(limit * 2)) {
                                throw new Exception("Expected " + limit * 2 + ", found " + cont);
                            }
                        } else if (cont != (long)limit) {
                            throw new Exception("Expected " + limit + ", found " + cont);
                        }
                    } else {
                        String mit = rs.getString("mittente");
                        long cont = rs.getLong("cont");
                        System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mittente");
                            cont = rs.getLong("cont");
                            System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (cont == 1L) continue;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (cont == 2L) continue;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (count) {
                    if (index != 1) {
                        throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                    }
                } else if (unionAll) {
                    if (index != limit * 2) {
                        throw new Exception("Test failed (expected " + limit * 2 + " rows, found:" + index + ")");
                    }
                } else if (index != limit) {
                    throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                }
                rs.close();
                stmtQuery.close();
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception eClose) {}
                try {
                    stmtQuery.close();
                }
                catch (Exception eClose) {}
            }
            if (!count) {
                String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                System.out.println("\n\nf. ** Query Union con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                ISQLQueryObject prepare12 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                ISQLQueryObject prepare22 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                sqlQueryObject2.addOrderBy("mittente");
                sqlQueryObject2.setSortType(true);
                sqlQueryObject2.setLimit(10);
                sqlQueryObject2.setOffset(2);
                try {
                    if (count) {
                        System.out.println("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                    } else {
                        System.out.println("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                    }
                    throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                }
                catch (SQLQueryObjectException s) {
                    if (!s.getMessage().equals(msgOffset)) {
                        throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s.getMessage() + "]");
                    }
                    System.out.println("\n\ng. ** Query Union con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setOffset(2);
                    try {
                        if (count) {
                            System.out.println("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                        } else {
                            System.out.println("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        }
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        System.out.println("\n\nh. ** Query Union con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setLimit(10);
                        try {
                            if (count) {
                                System.out.println("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                            } else {
                                System.out.println("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            }
                            throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (s3.getMessage().equals(msgLimit) || s3.getMessage().equals(msgOffset)) break block161;
                            throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testUnionWithGroupBy_engine(TipiDatabase tipo, boolean count, boolean unionAll, Connection con) throws Exception {
        ISQLQueryObject sqlQueryObject;
        ISQLQueryObject prepare2;
        ISQLQueryObject prepare1;
        block150: {
            long cont;
            String mit;
            ResultSet rs;
            Statement stmtQuery;
            block149: {
                block148: {
                    stmtQuery = null;
                    rs = null;
                    try {
                        System.out.println("\n\na. ** Query UnionGroupBy (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        if (!count) {
                            sqlQueryObject.addOrderBy("mittente");
                            sqlQueryObject.setSortType(true);
                        }
                        sqlQueryObject.addGroupBy("mittente");
                        String test = null;
                        test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            if (count) {
                                long cont2 = rs.getLong("aliasUnion");
                                System.out.println("riga[" + index++ + "]= [" + cont2 + "]");
                                if (cont2 != (long)limit) {
                                    throw new Exception("Expected " + limit + ", found " + cont2);
                                }
                            } else {
                                String mit2 = rs.getString("mit");
                                long cont3 = rs.getLong("contRisultatoGroupBy");
                                System.out.println("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                if (mit2.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont3 != 2L) {
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                    } else if (cont3 != 1L) {
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                } else if (unionAll) {
                                    if (cont3 != 4L) {
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                } else if (cont3 != 2L) {
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                                while (rs.next()) {
                                    mit2 = rs.getString("mit");
                                    cont3 = rs.getLong("contRisultatoGroupBy");
                                    System.out.println("riga[" + index++ + "]= (" + mit2 + "):[" + cont3 + "]");
                                    if (mit2.endsWith("10")) {
                                        if (unionAll) {
                                            if (cont3 == 2L) continue;
                                            throw new Exception("Expected 2, found " + cont3);
                                        }
                                        if (cont3 == 1L) continue;
                                        throw new Exception("Expected 1, found " + cont3);
                                    }
                                    if (unionAll) {
                                        if (cont3 == 4L) continue;
                                        throw new Exception("Expected 4, found " + cont3);
                                    }
                                    if (cont3 == 2L) continue;
                                    throw new Exception("Expected 2, found " + cont3);
                                }
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (count) {
                            if (index != 1) {
                                throw new Exception("Test failed (expected 1 rows, found:" + index + ")");
                            }
                        } else if (index != limit) {
                            throw new Exception("Test failed (expected " + limit + " rows, found:" + index + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                    try {
                        if (count) break block148;
                        System.out.println("\n\nb. ** Query UnionGroupBy OffSetLimit (unionCount:" + count + " unionAll:" + unionAll + ")");
                        int limit = 5;
                        prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject.addSelectAliasField("mittente", "mit");
                        sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                        sqlQueryObject.addOrderBy("mittente");
                        sqlQueryObject.setSortType(true);
                        sqlQueryObject.addGroupBy("mittente");
                        int limitEsterno = 6;
                        int offset = 2;
                        sqlQueryObject.setLimit(limitEsterno /= 2);
                        sqlQueryObject.setOffset(offset /= 2);
                        String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                        System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSetLimit UnionAll]:\n\t" + test);
                        stmtQuery = con.createStatement();
                        rs = stmtQuery.executeQuery(test);
                        int index = 0;
                        if (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont != 2L) {
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                } else if (cont != 1L) {
                                    throw new Exception("Expected 1, found " + cont);
                                }
                            } else if (unionAll) {
                                if (cont != 4L) {
                                    throw new Exception("Expected 4, found " + cont);
                                }
                            } else if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                            while (rs.next()) {
                                mit = rs.getString("mit");
                                cont = rs.getLong("contRisultatoGroupBy");
                                System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                                if (mit.endsWith("10")) {
                                    if (unionAll) {
                                        if (cont == 2L) continue;
                                        throw new Exception("Expected 2, found " + cont);
                                    }
                                    if (cont == 1L) continue;
                                    throw new Exception("Expected 1, found " + cont);
                                }
                                if (unionAll) {
                                    if (cont == 4L) continue;
                                    throw new Exception("Expected 4, found " + cont);
                                }
                                if (cont == 2L) continue;
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else {
                            throw new Exception("Test failed");
                        }
                        if (index != limitEsterno) {
                            throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                        }
                        rs.close();
                        stmtQuery.close();
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (Exception eClose) {}
                        try {
                            stmtQuery.close();
                        }
                        catch (Exception eClose) {}
                    }
                }
                try {
                    if (count) break block149;
                    System.out.println("\n\nc. ** Query UnionGroupBy  OffSet (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                    sqlQueryObject.addSelectAliasField("mittente", "mit");
                    sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                    sqlQueryObject.addOrderBy("mittente");
                    sqlQueryObject.setSortType(true);
                    sqlQueryObject.addGroupBy("mittente");
                    int offset = 2;
                    int numeroEntriesRisultato = limit * 2 - (offset /= 2);
                    numeroEntriesRisultato = limit - offset;
                    sqlQueryObject.setOffset(offset);
                    String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                    System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                    stmtQuery = con.createStatement();
                    rs = stmtQuery.executeQuery(test);
                    int index = 0;
                    if (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont != 2L) {
                                    throw new Exception("Expected 2, found " + cont);
                                }
                            } else if (cont != 1L) {
                                throw new Exception("Expected 1, found " + cont);
                            }
                        } else if (unionAll) {
                            if (cont != 4L) {
                                throw new Exception("Expected 4, found " + cont);
                            }
                        } else if (cont != 2L) {
                            throw new Exception("Expected 2, found " + cont);
                        }
                        while (rs.next()) {
                            mit = rs.getString("mit");
                            cont = rs.getLong("contRisultatoGroupBy");
                            System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                            if (mit.endsWith("10")) {
                                if (unionAll) {
                                    if (cont == 2L) continue;
                                    throw new Exception("Expected 2, found " + cont);
                                }
                                if (cont == 1L) continue;
                                throw new Exception("Expected 1, found " + cont);
                            }
                            if (unionAll) {
                                if (cont == 4L) continue;
                                throw new Exception("Expected 4, found " + cont);
                            }
                            if (cont == 2L) continue;
                            throw new Exception("Expected 2, found " + cont);
                        }
                    } else {
                        throw new Exception("Test failed");
                    }
                    if (index != numeroEntriesRisultato) {
                        throw new Exception("Test failed (expected " + numeroEntriesRisultato + " rows, found:" + index + ")");
                    }
                    rs.close();
                    stmtQuery.close();
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception eClose) {}
                    try {
                        stmtQuery.close();
                    }
                    catch (Exception eClose) {}
                }
            }
            try {
                if (count) break block150;
                System.out.println("\n\nd. ** Query UnionGroupBy Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                int limit = 5;
                prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
                sqlQueryObject.addSelectAliasField("mittente", "mit");
                sqlQueryObject.addSelectSumField("cont", "contRisultatoGroupBy");
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.addGroupBy("mittente");
                int limitEsterno = 4;
                sqlQueryObject.setLimit(limitEsterno /= 2);
                String test = sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
                System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [OffSet UnionAll]:\n\t" + test);
                stmtQuery = con.createStatement();
                rs = stmtQuery.executeQuery(test);
                int index = 0;
                boolean foundEndsWith10 = false;
                if (rs.next()) {
                    mit = rs.getString("mit");
                    cont = rs.getLong("contRisultatoGroupBy");
                    System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                    if (mit.endsWith("10")) {
                        if (unionAll) {
                            if (cont != 2L) {
                                throw new Exception("Expected 2, found " + cont);
                            }
                        } else if (cont != 1L) {
                            throw new Exception("Expected 1, found " + cont);
                        }
                    } else if (unionAll) {
                        if (cont != 4L) {
                            throw new Exception("Expected 4, found " + cont);
                        }
                    } else if (cont != 2L) {
                        throw new Exception("Expected 2, found " + cont);
                    }
                    while (rs.next()) {
                        mit = rs.getString("mit");
                        cont = rs.getLong("contRisultatoGroupBy");
                        System.out.println("riga[" + index++ + "]= (" + mit + "):[" + cont + "]");
                        if (mit.endsWith("10")) {
                            if (unionAll) {
                                if (cont == 2L) continue;
                                throw new Exception("Expected 2, found " + cont);
                            }
                            if (cont == 1L) continue;
                            throw new Exception("Expected 1, found " + cont);
                        }
                        if (unionAll) {
                            if (cont == 4L) continue;
                            throw new Exception("Expected 4, found " + cont);
                        }
                        if (cont == 2L) continue;
                        throw new Exception("Expected 2, found " + cont);
                    }
                } else {
                    throw new Exception("Test failed");
                }
                if (index != limitEsterno) {
                    throw new Exception("Test failed (expected " + limitEsterno + " rows, found:" + index + ")");
                }
                if (foundEndsWith10) {
                    throw new Exception("Test failed, unexpected element ends with 10");
                }
                rs.close();
                stmtQuery.close();
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception eClose) {}
                try {
                    stmtQuery.close();
                }
                catch (Exception eClose) {}
            }
        }
        try {
            System.out.println("\n\ne. ** Query UnionGroupBy con select* (unionCount:" + count + " unionAll:" + unionAll + ")");
            int limit = 5;
            prepare1 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
            prepare2 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipo);
            if (!count) {
                sqlQueryObject.addOrderBy("mittente");
                sqlQueryObject.setSortType(true);
            }
            sqlQueryObject.addGroupBy("mittente");
            String test = null;
            test = count ? sqlQueryObject.createSQLUnionCount(unionAll, "aliasUnion", prepare1, prepare2) : sqlQueryObject.createSQLUnion(unionAll, prepare1, prepare2);
            System.out.println("\nTest(count:" + count + " unionAll:" + unionAll + ") [" + tipo.toString() + "] [Normale UnionAll]:\n\t" + test);
            throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field");
        }
        catch (SQLQueryObjectException s) {
            block151: {
                if (!s.getMessage().equals("Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field")) {
                    throw new Exception("Attesa eccezione: Non e' possibile utilizzare condizioni di group by se non sono stati indicati select field. Trovata: " + s.getMessage());
                }
                if (!count) {
                    String msgOffset = "Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union";
                    String msgLimit = "Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union";
                    System.out.println("\n\nf. ** Query UnionGroupBy con select* e LimitOffset (unionCount:" + count + " unionAll:" + unionAll + ")");
                    int limit = 5;
                    ISQLQueryObject prepare12 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    ISQLQueryObject prepare22 = ClientTest.prepareForUnion(SQLObjectFactory.createSQLQueryObject(tipo), limit);
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                    sqlQueryObject2.addOrderBy("mittente");
                    sqlQueryObject2.setSortType(true);
                    sqlQueryObject2.setLimit(10);
                    sqlQueryObject2.setOffset(2);
                    sqlQueryObject2.addGroupBy("mittente");
                    try {
                        if (count) {
                            System.out.println("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                        } else {
                            System.out.println("[" + tipo.toString() + "] f. OffSetLimit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                        }
                        throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                    }
                    catch (SQLQueryObjectException s2) {
                        if (!s2.getMessage().equals(msgOffset)) {
                            throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s2.getMessage() + "]");
                        }
                        System.out.println("\n\ng. ** Query UnionGroupBy con select* e Offset (unionCount:" + count + " unionAll:" + unionAll + ")");
                        sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                        sqlQueryObject2.addOrderBy("mittente");
                        sqlQueryObject2.setSortType(true);
                        sqlQueryObject2.setOffset(2);
                        sqlQueryObject2.addGroupBy("mittente");
                        try {
                            if (count) {
                                System.out.println("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                            } else {
                                System.out.println("[" + tipo.toString() + "] g. OffSet *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                            }
                            throw new Exception("Attesa eccezione: Non e' possibile usare offset se non e' stato indicato alcun field nella select piu' esterna della union");
                        }
                        catch (SQLQueryObjectException s3) {
                            if (!s3.getMessage().equals(msgOffset)) {
                                throw new Exception("Attesa eccezione: [" + msgOffset + "]. Trovata: [" + s3.getMessage() + "]");
                            }
                            System.out.println("\n\nh. ** Query UnionGroupBy con select* e Limit (unionCount:" + count + " unionAll:" + unionAll + ")");
                            sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(tipo);
                            sqlQueryObject2.addOrderBy("mittente");
                            sqlQueryObject2.setSortType(true);
                            sqlQueryObject2.setLimit(10);
                            sqlQueryObject2.addGroupBy("mittente");
                            try {
                                if (count) {
                                    System.out.println("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnionCount(unionAll, "aliasUnion", prepare12, prepare22));
                                } else {
                                    System.out.println("[" + tipo.toString() + "] h Limit *: \n\t" + sqlQueryObject2.createSQLUnion(unionAll, prepare12, prepare22));
                                }
                                throw new Exception("Attesa eccezione: Non e' possibile usare limit se non e' stato indicato alcun field nella select piu' esterna della union");
                            }
                            catch (SQLQueryObjectException s4) {
                                if (s4.getMessage().equals(msgLimit) || s4.getMessage().equals(msgOffset)) break block151;
                                throw new Exception("Attesa eccezione: [" + msgLimit + "] oppure [" + msgOffset + "]. Trovata: [" + s4.getMessage() + "]");
                            }
                        }
                    }
                }
            }
            return;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$openspcoop2$utils$TipiDatabase;

        static {
            $SwitchMap$org$openspcoop2$utils$TipiDatabase = new int[TipiDatabase.values().length];
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.POSTGRESQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.ORACLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.HSQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.SQLSERVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openspcoop2$utils$TipiDatabase[TipiDatabase.DB2.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

