/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import org.openspcoop2.utils.checksum.ChecksumAdler;
import org.openspcoop2.utils.checksum.ChecksumCRC;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.FilterChecksumTypes;
import org.openspcoop2.utils.serialization.FilteredObject;
import org.openspcoop2.utils.serialization.IDBuilder;
import org.openspcoop2.utils.serialization.ISerializer;

public class PropertyFilter
implements net.sf.json.util.PropertyFilter {
    private IDBuilder idBuilder = null;
    private Filter filter = null;
    private ISerializer serializer = null;

    public PropertyFilter(Filter filter, IDBuilder idBuilder, ISerializer serializer) {
        this.idBuilder = idBuilder;
        this.filter = filter;
        this.serializer = serializer;
    }

    public PropertyFilter(Filter filter, ISerializer serializer) {
        this.filter = filter;
        this.serializer = serializer;
    }

    public boolean apply(Object source, String name, Object value) {
        if (value != null) {
            for (int i = 0; i < this.filter.sizeFiltersByValue(); ++i) {
                Class<?> classFilter = this.filter.getFilterByValue(i);
                if (!value.getClass().getName().equals(classFilter.getName())) continue;
                this.applicaFiltro(source, name, value, classFilter);
                return true;
            }
        }
        String nomeField = source.getClass().getName() + "." + name;
        for (int i = 0; i < this.filter.sizeFiltersByName(); ++i) {
            String filterName = this.filter.getFilterByName(i);
            if (!nomeField.equals(filterName) || value == null) continue;
            this.applicaFiltro(source, name, value, value.getClass());
            return true;
        }
        return value == null;
    }

    private void applicaFiltro(Object source, String name, Object value, Class<?> classFilter) {
        try {
            FilteredObject oggettoFiltrato = new FilteredObject();
            String id = this.idBuilder.toID(source, name);
            if (this.filter.existsFilteredObject(id)) {
                return;
            }
            if (this.idBuilder != null) {
                oggettoFiltrato.setId(id);
            }
            long checksum = -1L;
            byte[] byteOggetto = null;
            byteOggetto = value instanceof byte[] ? (byte[])value : this.serializer.getObject(value).getBytes();
            checksum = FilterChecksumTypes.ADLER.toString().equals(this.filter.getFilterChecksumType().toString()) ? ChecksumAdler.checksumAdler32(byteOggetto) : ChecksumCRC.checksumCRC32(byteOggetto);
            oggettoFiltrato.setChecksum(checksum);
            oggettoFiltrato.setClassType(classFilter);
            this.filter.addFilteredObject(oggettoFiltrato);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

