/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.resources.RisorseJMXException;

public class GestoreRisorseJMX {
    private MBeanServer mbeanServer;
    private Object mbeanServerConnection;
    protected Logger log;
    private Vector<ObjectName> jmxNames;

    public GestoreRisorseJMX() throws RisorseJMXException {
        this(null, null, null);
    }

    public GestoreRisorseJMX(Logger logger) throws RisorseJMXException {
        this(null, null, logger);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, null, null);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext, Logger logger) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, logger, null);
    }

    public GestoreRisorseJMX(String jndiNameMBeanServer, Properties jndiContext, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        this(jndiNameMBeanServer, jndiContext, null, null, null, null, null, logger, loggerConsole);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, null, null);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password, Logger logger) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, logger, null);
    }

    public GestoreRisorseJMX(String tipoApplicationServer, String factory, String serverUrl, String username, String password, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        this(null, null, tipoApplicationServer, factory, serverUrl, username, password, logger, loggerConsole);
    }

    private GestoreRisorseJMX(String modalita1_jndiNameMBeanServer, Properties modalita1_jndiContext, String modalita2_tipoApplicationServer, String modalita2_factory, String modalita2_serverUrl, String modalita2_username, String modalita2_password, Logger logger, Logger loggerConsole) throws RisorseJMXException {
        block17: {
            this.mbeanServer = null;
            this.mbeanServerConnection = null;
            this.log = null;
            this.jmxNames = new Vector();
            this.log = logger == null ? Logger.getLogger(GestoreRisorseJMX.class) : logger;
            if (loggerConsole == null) {
                loggerConsole = Logger.getLogger((String)"openspcoop2.startup");
            }
            try {
                if (modalita1_jndiNameMBeanServer != null) {
                    GestoreJNDI jndi = new GestoreJNDI(modalita1_jndiContext);
                    this.mbeanServer = (MBeanServer)jndi.lookup(modalita1_jndiNameMBeanServer);
                    if (this.mbeanServer == null) {
                        throw new Exception("MBeanServer [" + modalita1_jndiNameMBeanServer + "] non trovato");
                    }
                    if (logger == null) {
                        loggerConsole.info((Object)("Attivata gestione jmx attraverso MBeanServer [" + modalita1_jndiNameMBeanServer + "]: " + this.mbeanServer.toString()));
                    }
                    this.log.info((Object)("Attivata gestione jmx attraverso MBeanServer [" + modalita1_jndiNameMBeanServer + "]: " + this.mbeanServer.toString()));
                    break block17;
                }
                if (modalita2_tipoApplicationServer != null && !"".equals(modalita2_tipoApplicationServer)) {
                    if (modalita2_factory == null || "".equals(modalita2_factory)) {
                        throw new Exception("Parametro 'factory' non fornito");
                    }
                    if (modalita2_serverUrl == null || "".equals(modalita2_serverUrl)) {
                        throw new Exception("Parametro 'serverUrl' non fornito");
                    }
                    if (modalita2_tipoApplicationServer.equals("jboss7") || modalita2_tipoApplicationServer.equals("jboss8") || modalita2_tipoApplicationServer.equals("wildfly8") || modalita2_tipoApplicationServer.startsWith("tomcat")) {
                        Class<?> jmxServiceURLClass = Class.forName("javax.management.remote.JMXServiceURL");
                        Constructor<?> constructorJmxServiceURLClass = jmxServiceURLClass.getConstructor(String.class);
                        Object serviceURL = constructorJmxServiceURLClass.newInstance(modalita2_serverUrl);
                        Class<?> jmxConnectorFactoryClass = Class.forName("javax.management.remote.JMXConnectorFactory");
                        Method connect = jmxConnectorFactoryClass.getMethod("connect", jmxServiceURLClass, Map.class);
                        Object jmxConnector = connect.invoke(null, serviceURL, null);
                        Class<?> jmxConnectorClass = Class.forName("javax.management.remote.JMXConnector");
                        Method getMBeanServerConnection = jmxConnectorClass.getMethod("getMBeanServerConnection", new Class[0]);
                        this.mbeanServerConnection = getMBeanServerConnection.invoke(jmxConnector, new Object[0]);
                    } else {
                        Properties properties = new Properties();
                        properties.put("java.naming.factory.initial", modalita2_factory);
                        properties.put("java.naming.provider.url", modalita2_serverUrl);
                        GestoreJNDI jndi = new GestoreJNDI(properties);
                        this.mbeanServerConnection = jndi.lookup("jmx/invoker/RMIAdaptor");
                        if (modalita2_username != null && modalita2_password != null) {
                            Class<?> simplePrincipalClass = Class.forName("org.jboss.security.SimplePrincipal");
                            Constructor<?> constructorPrincipalClass = simplePrincipalClass.getConstructor(String.class);
                            Object simplePrincipal = constructorPrincipalClass.newInstance(modalita2_username);
                            Class<?> securityAssociationClass = Class.forName("org.jboss.security.SecurityAssociation");
                            Method setPrincipal = securityAssociationClass.getMethod("setPrincipal", simplePrincipalClass);
                            setPrincipal.invoke(null, simplePrincipal);
                            Method setCredential = securityAssociationClass.getMethod("setCredential", String.class);
                            setCredential.invoke(null, modalita2_password);
                        }
                    }
                    break block17;
                }
                ArrayList<MBeanServer> lServer = MBeanServerFactory.findMBeanServer(null);
                if (lServer == null) {
                    throw new RisorseJMXException("Lista di MBean Server di default non trovata (MBeanServerFactory.findMBeanServer)");
                }
                if (lServer.isEmpty()) {
                    throw new RisorseJMXException("Lista di MBean Server di default vuota");
                }
                Iterator<MBeanServer> it = lServer.iterator();
                if (it.hasNext()) {
                    this.mbeanServer = it.next();
                    if (this.mbeanServer == null) {
                        throw new Exception("MBeanServer di default non trovato");
                    }
                    if (logger == null) {
                        loggerConsole.info((Object)("Attivata gestione jmx attraverso MBeanServer: " + this.mbeanServer.toString()));
                    }
                    this.log.info((Object)("Attivata gestione jmx attraverso MBeanServer: " + this.mbeanServer.toString()));
                    break block17;
                }
                throw new RisorseJMXException("Lista di MBean Server di default vuota ?");
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage()), (Throwable)e);
                throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione del gestore delle RisorseJMX: " + e.getMessage(), e);
            }
        }
    }

    public void registerMBean(Class<?> c, String nome) throws RisorseJMXException {
        this.registerMBean(c, "org.openspcoop2.pdd", "type", nome);
    }

    public void registerMBean(Class<?> c, String dominio, String type, String nome) throws RisorseJMXException {
        try {
            ObjectName jmxName = new ObjectName(dominio, type, nome);
            if (this.mbeanServer == null) {
                throw new Exception("Operazione di registrazione permessa solo se il gestore viene inizializzato con il costruttore di default o indicando l'MBeanServer");
            }
            this.mbeanServer.registerMBean(c.newInstance(), jmxName);
            this.jmxNames.add(jmxName);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione della risorsa JMX [" + nome + "]: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'inizializzazione della risorsa JMX [" + nome + "]: " + e.getMessage(), e);
        }
    }

    public void unregisterMBeans() {
        for (int i = 0; i < this.jmxNames.size(); ++i) {
            ObjectName jmxName = this.jmxNames.get(i);
            try {
                if (this.mbeanServer == null) {
                    throw new Exception("Operazione di cancellazione permessa solo se il gestore viene inizializzato con il costruttore di default o indicando l'MBeanServer");
                }
                this.mbeanServer.unregisterMBean(jmxName);
                this.log.info((Object)("Unbound della risorsa JMX [" + jmxName.toString() + "]"));
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante l'unbound della risorsa JMX [" + jmxName.toString() + "]: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Object getAttribute(String nomeRisorsa, String nomeAttributo) throws RisorseJMXException {
        return this.getAttribute("org.openspcoop2.pdd", "type", nomeRisorsa, nomeAttributo);
    }

    public Object getAttribute(String dominio, String tipo, String nomeRisorsa, String nomeAttributo) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName(dominio, tipo, nomeRisorsa);
            if (this.mbeanServerConnection != null) {
                Class<?> c = Class.forName("javax.management.MBeanServerConnection");
                Method m = c.getMethod("getAttribute", ObjectName.class, String.class);
                return m.invoke(this.mbeanServerConnection, name, nomeAttributo);
            }
            return this.mbeanServer.getAttribute(name, nomeAttributo);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dell'attributo [" + nomeAttributo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante la lettura dell'attributo [" + nomeAttributo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage(), e);
        }
    }

    public Object invoke(String nomeRisorsa, String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        return this.invoke("org.openspcoop2.pdd", "type", nomeRisorsa, nomeMetodo, params, signature);
    }

    public Object invoke(String dominio, String tipo, String nomeRisorsa, String nomeMetodo, Object[] params, String[] signature) throws RisorseJMXException {
        try {
            ObjectName name = new ObjectName(dominio, tipo, nomeRisorsa);
            if (this.mbeanServerConnection != null) {
                Class<?> c = Class.forName("javax.management.MBeanServerConnection");
                Method m = c.getMethod("invoke", ObjectName.class, String.class, Object[].class, String[].class);
                return m.invoke(this.mbeanServerConnection, name, nomeMetodo, params, signature);
            }
            return this.mbeanServer.invoke(name, nomeMetodo, params, signature);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'invocazione del metodo [" + nomeMetodo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage()), (Throwable)e);
            throw new RisorseJMXException("Riscontrato errore durante l'invocazione del metodo [" + nomeMetodo + "] della risorsa [" + nomeRisorsa + "]: " + e.getMessage(), e);
        }
    }
}

