/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.log4j.Logger;

public class GestoreJNDI {
    private Properties contextProperties;

    public GestoreJNDI(Properties contextP) {
        this.contextProperties = contextP;
    }

    public GestoreJNDI() {
        this.contextProperties = new Properties();
    }

    public Object lookup(String fullPath) throws Exception {
        InitialContext ctx = null;
        try {
            Object obj;
            ctx = this.contextProperties != null && this.contextProperties.size() > 0 ? new InitialContext(this.contextProperties) : new InitialContext();
            Object object = obj = ctx.lookup(fullPath);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public boolean unbind(String fullPath) {
        return this.unbind(fullPath, null, null);
    }

    public boolean unbind(String fullPath, Logger log) {
        return this.unbind(fullPath, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(String fullPath, Logger log, Logger logConsole) {
        InitialContext currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            if (log != null) {
                log.debug((Object)("Unbind  fullname " + name));
            }
            try {
                currentContext.unbind(name);
            }
            catch (NameNotFoundException ignored) {
                if (log != null) {
                    log.error((Object)("Errore durante l'unbind (Ignored) [" + ignored + "]"), (Throwable)ignored);
                }
                if (logConsole != null) {
                    logConsole.error((Object)("Errore durante l'unbind (Ignored) [" + ignored + "]"), (Throwable)ignored);
                }
                boolean bl = false;
                try {
                    if (currentContext != null) {
                        currentContext.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error((Object)("Errore durante l'unbind [" + e + "]"), (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error((Object)("Errore durante l'unbind [" + e + "]"), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public boolean bind(String fullPath, Object toBind) {
        return this.bind(fullPath, toBind, null, null);
    }

    public boolean bind(String fullPath, Object toBind, Logger log) {
        return this.bind(fullPath, toBind, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(String fullPath, Object toBind, Logger log, Logger logConsole) {
        Context currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            String[] components = name.split("/");
            int stop = components.length - 1;
            for (int ix = 0; ix < stop; ++ix) {
                String nextPath = components[ix];
                try {
                    currentContext = (Context)currentContext.lookup(nextPath);
                    continue;
                }
                catch (NameNotFoundException ignored) {
                    currentContext = currentContext.createSubcontext(nextPath);
                }
            }
            currentContext.bind(components[stop], toBind);
            if (log != null) {
                log.info((Object)("binding [" + fullPath + "] to " + currentContext));
            }
            if (logConsole != null) {
                logConsole.info((Object)("binding [" + fullPath + "] to " + currentContext));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (log != null) {
                log.error((Object)("Errore durante il bind [" + e + "]"), (Throwable)e);
            }
            if (logConsole != null) {
                logConsole.error((Object)("Errore durante il bind [" + e + "]"), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception eClose) {}
        }
    }
}

