/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;

public class DataContentHandlerManager {
    private Logger log;

    public DataContentHandlerManager(Logger log) {
        this.log = log;
    }

    public void initMailcap() {
        byte[] tmp;
        URL url;
        Enumeration<URL> en;
        try {
            this.log.info((Object)"Search mailcap.default ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap.default");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.log.info((Object)("Find mailcap.default [" + url.toString() + "]"));
                    this.log.info((Object)("Read mailcap.default [" + url.toString() + "] ..."));
                    tmp = Utilities.getAsByteArray(url);
                    this.log.info((Object)("Read mailcap.default [" + url.toString() + "]: " + new String(tmp)));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Mailcap.default search error: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.log.info((Object)"Search mailcap ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.log.info((Object)("Find mailcap [" + url.toString() + "]"));
                    this.log.info((Object)("Read mailcap [" + url.toString() + "] ..."));
                    tmp = Utilities.getAsByteArray(url);
                    this.log.info((Object)("Read mailcap [" + url.toString() + "]: " + new String(tmp)));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Mailcap search error: " + e.getMessage()), (Throwable)e);
        }
    }

    public List<String> readMimeTypesRegistrati() {
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        String[] gestiti = mcap.getMimeTypes();
        ArrayList<String> gestitiAsList = new ArrayList<String>();
        if (gestiti != null) {
            this.log.info((Object)("MimeTypes registrati: [" + gestiti.length + "]"));
            for (int i = 0; i < gestiti.length; ++i) {
                this.log.info((Object)("MimeType registrato: [" + gestiti[i] + "]"));
                gestitiAsList.add(gestiti[i]);
                CommandInfo[] cis = mcap.getAllCommands(gestiti[i]);
                for (int j = 0; j < cis.length; ++j) {
                    this.log.info((Object)("\t[" + j + "] " + cis[j].getCommandName() + " = " + cis[j].getCommandClass()));
                }
            }
        } else {
            this.log.info((Object)"Non risultano registrati MimeTypes");
        }
        return gestitiAsList;
    }

    public void addMimeTypeIntoMailcap(String commandInfo) throws UtilsException {
        if (!commandInfo.contains(";;")) {
            throw new UtilsException("Formato non corretto, non \u00e8 stato riscontrato il carattere ';;'");
        }
        String[] split = commandInfo.split(";;");
        if (split == null || split.length != 2) {
            throw new UtilsException("Formato non corretto");
        }
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mcap.addMailcap(commandInfo);
        CommandMap.setDefaultCommandMap((CommandMap)mcap);
        this.log.info((Object)("Registrato in Mailcap il mimetype [" + split[0] + "]: " + commandInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMimeTypesIntoMailcap(byte[] mailcap) throws IOException, UtilsException {
        List<String> gestitiAsList = this.readMimeTypesRegistrati();
        BufferedReader br = null;
        InputStreamReader isr = null;
        ByteArrayInputStream bin = null;
        try {
            String strLine;
            bin = new ByteArrayInputStream(mailcap);
            isr = new InputStreamReader(bin);
            br = new BufferedReader(isr);
            while ((strLine = br.readLine()) != null) {
                String[] split;
                if (strLine == null || strLine.startsWith("#") || !strLine.contains(";;") || gestitiAsList.contains((split = strLine.split(";;"))[0])) continue;
                gestitiAsList.add(split[0]);
                this.addMimeTypeIntoMailcap(strLine);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception eClose) {}
            try {
                isr.close();
            }
            catch (Exception eClose) {}
            try {
                bin.close();
            }
            catch (Exception eClose) {}
        }
    }
}

