/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.AbstractNoReturnGeneratedKeyGenerator;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.DefaultKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;

public class PostgreSQLKeyGenerator
extends AbstractNoReturnGeneratedKeyGenerator {
    public PostgreSQLKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        super(connection, type);
    }

    @Override
    public String getSequenceQuery() throws KeyGeneratorException {
        String sequence = null;
        switch (this.type.getType()) {
            case DEFAULT: {
                sequence = ((DefaultKeyGeneratorObject)this.type).getPrefix() + "_id_seq";
                break;
            }
            case CUSTOM: {
                CustomKeyGeneratorObject c = (CustomKeyGeneratorObject)this.type;
                if (c.existsCustomTableObjectsForDatabaseType(TipiDatabase.POSTGRESQL)) {
                    sequence = c.getCustomTableObjectsForDatabaseType(TipiDatabase.POSTGRESQL).getSequenceName();
                    break;
                }
                sequence = c.getDefaultTableObjects().getSequenceName();
                break;
            }
            default: {
                throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + this.type);
            }
        }
        return "select nextval('" + sequence + "'::text) as nextval";
    }
}

