/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IKeyGenerator;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;
import org.openspcoop2.utils.jdbc.KeyGeneratorFactory;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class InsertAndGeneratedKey {
    public static long insertAndReturnGeneratedKey(Connection con, TipiDatabase tipoDatabase, IKeyGeneratorObject object, InsertAndGeneratedKeyObject ... objects) throws KeyGeneratorException {
        Statement stmt = null;
        try {
            IKeyGenerator keyGenerator = KeyGeneratorFactory.createKeyGeneratorFactory(tipoDatabase.getNome(), con, object);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase.getNome());
            sqlQueryObject.addInsertTable(object.getTable());
            if (objects == null) {
                throw new Exception("Objects for insert is null");
            }
            if (objects.length <= 0) {
                throw new Exception("Objects for insert is empty");
            }
            for (int i = 0; i < objects.length; ++i) {
                sqlQueryObject.addInsertField(objects[i].getName(), "?");
            }
            if (!keyGenerator.isReturnGeneratedKeySupported()) {
                sqlQueryObject.addInsertField(keyGenerator.getColunmKeyName(), "?");
            }
            String insertString = sqlQueryObject.createSQLInsert();
            stmt = keyGenerator.isReturnGeneratedKeySupported() ? con.prepareStatement(insertString, 1) : con.prepareStatement(insertString);
            int i = 0;
            int indexJDBC = 1;
            while (i < objects.length) {
                switch (objects[i].getJdbcType()) {
                    case TIMESTAMP: {
                        Timestamp t = null;
                        if (objects[i].getValue() != null) {
                            if (objects[i].getValue() instanceof Timestamp) {
                                t = (Timestamp)objects[i].getValue();
                            } else if (objects[i].getValue() instanceof Date) {
                                t = new Timestamp(((Date)objects[i].getValue()).getTime());
                            } else if (objects[i].getValue() instanceof java.sql.Date) {
                                t = new Timestamp(((Date)objects[i].getValue()).getTime());
                            } else if (objects[i].getValue() instanceof Calendar) {
                                t = new Timestamp(((Calendar)objects[i].getValue()).getTime().getTime());
                            }
                        }
                        stmt.setTimestamp(indexJDBC, t);
                        break;
                    }
                    case INT: {
                        Integer num = null;
                        if (objects[i].getValue() != null) {
                            if (objects[i].getValue() instanceof Integer) {
                                num = (Integer)objects[i].getValue();
                            } else if (objects[i].getValue() instanceof Long) {
                                num = ((Long)objects[i].getValue()).intValue();
                            } else if (objects[i].getValue() instanceof Float) {
                                num = ((Float)objects[i].getValue()).intValue();
                            } else if (objects[i].getValue() instanceof Double) {
                                num = ((Double)objects[i].getValue()).intValue();
                            }
                        }
                        stmt.setInt(indexJDBC, num);
                        break;
                    }
                    case LONG: {
                        Long numLong = null;
                        if (objects[i].getValue() != null) {
                            if (objects[i].getValue() instanceof Long) {
                                numLong = (Long)objects[i].getValue();
                            } else if (objects[i].getValue() instanceof Integer) {
                                numLong = ((Integer)objects[i].getValue()).longValue();
                            } else if (objects[i].getValue() instanceof Float) {
                                numLong = ((Float)objects[i].getValue()).longValue();
                            } else if (objects[i].getValue() instanceof Double) {
                                numLong = ((Double)objects[i].getValue()).longValue();
                            }
                        }
                        stmt.setLong(indexJDBC, numLong);
                        break;
                    }
                    case STRING: {
                        String s = null;
                        if (objects[i].getValue() != null) {
                            s = (String)objects[i].getValue();
                        }
                        JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, indexJDBC, s);
                        break;
                    }
                    default: {
                        throw new Exception("JDBC Type non supportato: " + (Object)((Object)objects[i].getJdbcType()));
                    }
                }
                ++i;
                ++indexJDBC;
            }
            if (!keyGenerator.isReturnGeneratedKeySupported()) {
                stmt.setLong(indexJDBC, keyGenerator.generateKey());
            }
            stmt.executeUpdate();
            long l = keyGenerator.getReturnGeneratedKey((PreparedStatement)stmt);
            return l;
        }
        catch (Exception e) {
            throw new KeyGeneratorException("insertAndReturnGeneratedKey failed: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception eClose) {}
        }
    }
}

