/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class ZipUtilities {
    public static String getRootDir(String entry) throws UtilsException {
        try {
            String rootDir = null;
            String dir = entry;
            int indexOf = dir.indexOf(File.separatorChar);
            if (indexOf <= 0) {
                throw new UtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip (" + indexOf + ")");
            }
            if ((dir = dir.substring(0, indexOf)) == null || "".equals(dir)) {
                throw new UtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip (" + dir + ")");
            }
            rootDir = dir + File.separatorChar;
            return rootDir;
        }
        catch (UtilsException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la comprensione della directory radice presente all'interno dello zip: " + e.getMessage(), e);
        }
    }

    public static String getBaseName(String file) throws UtilsException {
        try {
            return new File(file).getName();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la comprensione del base name per il file [" + file + "]: " + e.getMessage(), e);
        }
    }

    public static String operativeSystemConversion(String entryName) {
        char separatorCharWindows = '\\';
        char separatorCharLinux = '/';
        boolean isWindows = File.separatorChar == separatorCharWindows;
        StringBuffer fixed = new StringBuffer(entryName);
        for (int i = 0; i < fixed.length(); ++i) {
            if (isWindows) {
                if (fixed.charAt(i) != separatorCharLinux) continue;
                fixed.setCharAt(i, File.separatorChar);
                continue;
            }
            if (fixed.charAt(i) != separatorCharWindows) continue;
            fixed.setCharAt(i, File.separatorChar);
        }
        return fixed.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(String zipFile, String dest) throws UtilsException {
        try {
            File destFile = new File(dest);
            if (!destFile.exists()) {
                if (!destFile.mkdir()) {
                    throw new Exception("Destinazione [" + dest + "] non esistente e creazione non riuscita");
                }
            } else {
                if (!destFile.isDirectory()) {
                    throw new Exception("Destinazione [" + dest + "] non e' una directory");
                }
                if (!destFile.canWrite()) {
                    throw new Exception("Destinazione [" + dest + "] non accessibile in scrittura ");
                }
            }
            OutputStream out = null;
            InputStream iZip = null;
            ZipFile zf = new ZipFile(zipFile);
            try {
                Enumeration<? extends ZipEntry> em = zf.entries();
                while (em.hasMoreElements()) {
                    int len;
                    ZipEntry ze = em.nextElement();
                    String targetfile = destFile.getAbsolutePath() + File.separatorChar + ze.getName();
                    FileSystemUtilities.mkdirParentDirectory(targetfile);
                    if (ze.getName() != null && (ze.getName().endsWith("/") || ze.getName().endsWith("\\"))) {
                        File fDir = new File(targetfile);
                        if (fDir.mkdir()) continue;
                        throw new Exception("Creazione directory [" + fDir.getAbsolutePath() + "] per entry [" + ze.getName() + "] non riuscita");
                    }
                    iZip = zf.getInputStream(ze);
                    out = new FileOutputStream(targetfile);
                    byte[] buf = new byte[1024];
                    while ((len = iZip.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    iZip.close();
                    iZip = null;
                    out.flush();
                    out.close();
                    out = null;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (iZip != null) {
                    iZip.close();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Unzip non riuscito: " + e.getMessage(), e);
        }
    }
}

