/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.IDate;
import org.openspcoop2.utils.resources.Loader;

public class DateManager {
    private static IDate dataManager;
    private static Logger log;

    public static synchronized void initializeDataManager(String className, Properties properties, Logger log) throws UtilsException {
        if (dataManager == null) {
            try {
                DateManager.log = log != null ? log : Logger.getLogger(DateManager.class);
                dataManager = (IDate)Loader.getInstance().newInstance(className);
                dataManager.init(properties);
            }
            catch (Exception e) {
                throw new UtilsException("Riscontrato errore durante il caricamento del data manager specificato [class:" + className + "]: " + e.getMessage(), e);
            }
        }
    }

    public static void close() {
        if (dataManager != null) {
            try {
                dataManager.close();
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante la chiusura del data manager: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static Date getDate() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger(DateManager.class);
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop2.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getDate();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getDate() non riuscita", (Throwable)e);
            return new Date();
        }
    }

    public static long getTimeMillis() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger(DateManager.class);
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop2.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getTimeMillis();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getTimeMillis() non riuscita", (Throwable)e);
            return new Date().getTime();
        }
    }

    public static Timestamp getTimestamp() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger(DateManager.class);
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop2.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getTimestamp();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getTimestamp() non riuscita", (Throwable)e);
            return new Timestamp(new Date().getTime());
        }
    }

    public static Calendar getCalendar() throws UtilsException {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger(DateManager.class);
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop2.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getCalendar();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getCalendar() non riuscita", (Throwable)e);
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(new Date());
            return c;
        }
    }
}

