/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.checksum;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.openspcoop2.utils.checksum.ChecksumException;

public class ChecksumCRC {
    public static long checksumCRC32(String fileName) throws ChecksumException {
        try {
            File file = new File(fileName);
            return ChecksumCRC.checksumCRC32(file);
        }
        catch (Exception e) {
            throw new ChecksumException("Calcolo checksum non riuscito: " + e.getMessage(), e);
        }
    }

    public static long checksumCRC32(File file) throws ChecksumException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            long l = ChecksumCRC.checksumCRC32(fin);
            return l;
        }
        catch (Exception e) {
            throw new ChecksumException("Calcolo checksum non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static long checksumCRC32(byte[] bytes) throws ChecksumException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(bytes);
            long l = ChecksumCRC.checksumCRC32(bin);
            return l;
        }
        catch (Exception e) {
            throw new ChecksumException("Calcolo checksum non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static long checksumCRC32(InputStream i) throws ChecksumException {
        try {
            CheckedInputStream cis = new CheckedInputStream(i, new CRC32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            long checksum = cis.getChecksum().getValue();
            return checksum;
        }
        catch (Exception e) {
            throw new ChecksumException("Calcolo checksum non riuscito: " + e.getMessage(), e);
        }
    }
}

