/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.RFC2253Parser;
import org.openspcoop2.utils.UtilsException;

public class Utilities {
    public static final int DIMENSIONE_BUFFER = 65536;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    public static boolean freeMemoryLog = false;
    public static Logger log;
    public static final Runtime s_runtime;
    public static final long INITIAL_SIZE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAsByteArray(URL url) throws UtilsException {
        try {
            InputStream openStream = null;
            byte[] content = null;
            try {
                openStream = url.openStream();
                content = Utilities.getAsByteArray(openStream);
            }
            finally {
                try {
                    openStream.close();
                }
                catch (Exception exception) {}
            }
            return content;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static byte[] getAsByteArray(InputStream is) throws UtilsException {
        try {
            return Utilities.getAsByteArrayOuputStream(is).toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static ByteArrayOutputStream getAsByteArrayOuputStream(InputStream is) throws UtilsException {
        try {
            byte[] buffer = new byte[65536];
            int letti = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((letti = is.read(buffer)) != -1) {
                bout.write(buffer, 0, letti);
            }
            bout.flush();
            bout.close();
            return bout;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, Properties sorgente) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = sorgente.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = sorgente.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, String[] key, String[] name) throws UtilsException {
        Properties sorgente = new Properties();
        if (key != null && name != null && key.length == name.length) {
            for (int i = 0; i < key.length; ++i) {
                sorgente.put(key[i], name[i]);
            }
        }
        return Utilities.readProperties(prefix, sorgente);
    }

    public static String convertSystemTimeIntoString_millisecondi(long time, boolean millisecondiCheck) {
        long millisecondi = time % 1000L;
        long diff = time / 1000L;
        long ore = diff / 3600L;
        long minuti = diff % 3600L / 60L;
        long secondi = diff % 3600L % 60L;
        StringBuffer bf = new StringBuffer();
        long giorni = ore / 24L;
        long oreInUnGiorno = giorni % 24L;
        if (giorni > 0L) {
            bf.append(giorni + "d");
        }
        if (giorni > 0L) {
            if (oreInUnGiorno > 0L) {
                if (bf.length() > 0) {
                    bf.append(":");
                }
                bf.append(oreInUnGiorno + "h");
            } else if (bf.length() > 0) {
                bf.append(":0h");
            }
        } else if (ore > 0L) {
            if (bf.length() > 0) {
                bf.append(":");
            }
            bf.append(ore + "h");
        } else if (bf.length() > 0) {
            bf.append(":0h");
        }
        if (minuti > 0L) {
            if (bf.length() > 0) {
                bf.append(":");
            }
            bf.append(minuti + "m");
        } else if (bf.length() > 0) {
            bf.append(":0m");
        }
        if (secondi > 0L) {
            if (bf.length() > 0) {
                bf.append(":");
            }
            bf.append(secondi + "s");
        } else if (bf.length() > 0) {
            bf.append(":0s");
        }
        if (millisecondiCheck) {
            if (millisecondi >= 0L) {
                if (bf.length() > 0) {
                    bf.append(".");
                }
                bf.append(millisecondi + "ms");
            } else if (bf.length() > 0) {
                bf.append(".0ms");
            }
        }
        if (bf.length() == 0) {
            bf.append("conversione non riuscita");
        }
        return bf.toString();
    }

    public static String convertBytesToFormatString(long value) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Double len = null;
        String res = "";
        len = new Long(value).doubleValue();
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = res + "b";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = res + "kb";
        } else {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = res + "mb";
        }
        return res;
    }

    public static String[] split(String value, char separator) throws UtilsException {
        StringBuffer bf = new StringBuffer();
        ArrayList<String> splitResults = new ArrayList<String>();
        if (value == null || value.length() <= 0) {
            throw new UtilsException("Valore non fornito");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == separator) {
                if (i > 0 && value.charAt(i - 1) != '\\') {
                    splitResults.add(bf.toString());
                    bf.delete(0, bf.length());
                    continue;
                }
                if (i == 0) {
                    splitResults.add(bf.toString());
                    bf.delete(0, bf.length());
                    continue;
                }
                bf.append(value.charAt(i));
                continue;
            }
            bf.append(value.charAt(i));
        }
        splitResults.add(bf.toString());
        return splitResults.toArray(new String[1]);
    }

    private static boolean contains(String value, String separator) {
        int indexOf = value.indexOf(separator);
        boolean found = false;
        if (indexOf == 0) {
            found = true;
        } else {
            while (indexOf > 0) {
                char precedente = value.charAt(indexOf - 1);
                if (precedente == '\\') {
                    if (indexOf + 1 > value.length()) break;
                    indexOf = value.indexOf(separator, indexOf + 1);
                    continue;
                }
                found = true;
                break;
            }
        }
        return found;
    }

    public static boolean sslVerify(String subjectPresenteNellaConfigurazione, String subjectArrivatoConnessioneSSL) throws UtilsException {
        Hashtable<String, String> hashSubjectArrivatoConnessioneSSL = Utilities.getSubjectIntoHashtable(subjectArrivatoConnessioneSSL);
        Hashtable<String, String> hashSubjectPresenteNellaConfigurazione = Utilities.getSubjectIntoHashtable(subjectPresenteNellaConfigurazione);
        if (hashSubjectArrivatoConnessioneSSL.size() != hashSubjectPresenteNellaConfigurazione.size()) {
            return false;
        }
        Enumeration<String> keys = hashSubjectArrivatoConnessioneSSL.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!hashSubjectPresenteNellaConfigurazione.containsKey(key)) {
                return false;
            }
            String connessioneSSLValue = hashSubjectArrivatoConnessioneSSL.get(key);
            String configurazioneInternaValue = hashSubjectPresenteNellaConfigurazione.get(key);
            while (connessioneSSLValue.contains("\\/")) {
                connessioneSSLValue = connessioneSSLValue.replace("\\/", "/");
            }
            while (connessioneSSLValue.contains("\\,")) {
                connessioneSSLValue = connessioneSSLValue.replace("\\,", ",");
            }
            while (configurazioneInternaValue.contains("\\/")) {
                configurazioneInternaValue = configurazioneInternaValue.replace("\\/", "/");
            }
            while (configurazioneInternaValue.contains("\\,")) {
                configurazioneInternaValue = configurazioneInternaValue.replace("\\,", ",");
            }
            if (connessioneSSLValue.equals(configurazioneInternaValue)) continue;
            return false;
        }
        return true;
    }

    public static String formatSubject(String subject) throws UtilsException {
        Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
        StringBuffer bf = new StringBuffer();
        bf.append("/");
        Enumeration<String> keys = hashSubject.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = hashSubject.get(key);
            bf.append(Utilities.formatKeySubject(key));
            bf.append("=");
            bf.append(Utilities.formatValueSubject(value));
            bf.append("/");
        }
        return bf.toString();
    }

    public static void validaSubject(String subjectParam) throws UtilsException {
        String subject = subjectParam;
        UtilsException normalizedException = null;
        try {
            String tmp;
            subject = tmp = Utilities.normalizeSubject(subjectParam);
        }
        catch (UtilsException e) {
            normalizedException = e;
        }
        boolean commaFound = Utilities.contains(subject, ",");
        boolean slashFound = Utilities.contains(subject, "/");
        if (commaFound && slashFound) {
            throw new UtilsException("(" + subject + ") Non possono coesistere i separatore \",\" e \"/\", solo uno dei due tipi deve essere utilizzato come delimitatore (usare eventualmente come carattere di escape '\\')");
        }
        if (!(commaFound || slashFound || subject.contains("="))) {
            throw new UtilsException("(" + subject + ") Subject non valido, nemmeno una coppia nome=valore trovata");
        }
        String[] valoriSubject = Utilities.getValoriSubject(subject);
        boolean campoObbligatorioCN = false;
        boolean campoObbligatorioOU = false;
        boolean campoObbligatorioO = false;
        boolean campoObbligatorioL = false;
        boolean campoObbligatorioST = false;
        boolean campoObbligatorioC = false;
        boolean campoObbligatorioE = false;
        for (int i = 0; i < valoriSubject.length; ++i) {
            if (!valoriSubject[i].contains("=")) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valoriSubject[i] + "] non separata dal carattere \"=\". Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
            }
            String[] keyValue = valoriSubject[i].trim().split("=");
            if (keyValue.length < 2) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valoriSubject[i] + "] non contiene un valore? Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
            }
            if (keyValue[0].trim().contains(" ")) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: il campo [" + valoriSubject[i] + "] contiene spazi nella chiave identificativa [" + keyValue[0].trim() + "]");
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("CN")) {
                campoObbligatorioCN = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("OU")) {
                campoObbligatorioOU = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("O")) {
                campoObbligatorioO = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("L")) {
                campoObbligatorioL = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("ST")) {
                campoObbligatorioST = true;
                continue;
            }
            if (Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("C")) {
                campoObbligatorioC = true;
                continue;
            }
            if (!Utilities.formatKeySubject(keyValue[0]).equalsIgnoreCase("E")) continue;
            campoObbligatorioE = true;
        }
        if (!(campoObbligatorioCN || campoObbligatorioOU || campoObbligatorioO || campoObbligatorioL || campoObbligatorioST || campoObbligatorioC || campoObbligatorioE)) {
            throw new UtilsException("(" + subject + ") Almeno un attributo di certificato tra 'CN', 'OU', 'O', 'L', 'ST', 'C' e 'E' deve essere valorizzato.");
        }
        if (normalizedException != null) {
            throw normalizedException;
        }
    }

    public static String normalizeSubject(String subjectParam) throws UtilsException {
        try {
            String subject = RFC2253Parser.normalize((String)subjectParam);
            return subject;
        }
        catch (Exception e) {
            throw new UtilsException("(" + subjectParam + ") Normalizzazione RFC2253 non riuscita: " + e.getMessage(), e);
        }
    }

    public static String[] getValoriSubject(String subjectParam) throws UtilsException {
        try {
            String subject = Utilities.normalizeSubject(subjectParam);
            return Utilities._getValoriSubject(subject);
        }
        catch (Exception e) {
            try {
                LdapName prova = new LdapName(subjectParam);
                Enumeration<String> ens = prova.getAll();
                ArrayList<String> values = new ArrayList<String>();
                while (ens.hasMoreElements()) {
                    String name = ens.nextElement();
                    values.add(name);
                }
                if (values.size() > 0) {
                    return values.toArray(new String[1]);
                }
                throw new Exception("Coppie nome/valore non trovate");
            }
            catch (Exception e2Level) {
                e2Level.printStackTrace(System.out);
                throw new UtilsException("(" + subjectParam + ") javax.naming.ldap.LdapName reader failed: " + e2Level.getMessage() + ". \nFirst method error: " + e.getMessage(), e);
            }
        }
    }

    private static String[] _getValoriSubject(String subject) throws UtilsException {
        String[] valori;
        boolean commaFound = Utilities.contains(subject, ",");
        boolean slashFound = Utilities.contains(subject, "/");
        if (commaFound) {
            if (subject.startsWith(",")) {
                subject = subject.substring(1);
            }
            if (subject.endsWith(",")) {
                subject = subject.substring(0, subject.length() - 1);
            }
            valori = Utilities.split(subject, ',');
        } else if (!slashFound) {
            int indexOf = subject.indexOf("=");
            if (indexOf <= 0) {
                throw new UtilsException("(" + subject + ") Separatore validi per il subject interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\" e carattere \"=\" non presente");
            }
            if (subject.indexOf("=", indexOf + 1) >= 0) {
                throw new UtilsException("(" + subject + ") Separatore validi per il subject interno alla configurazione di OpenSPCoop non trovati:  \",\" o \"/\"");
            }
            valori = new String[]{subject};
        } else {
            if (subject.startsWith("/")) {
                subject = subject.substring(1);
            }
            if (subject.endsWith("/")) {
                subject = subject.substring(0, subject.length() - 1);
            }
            valori = Utilities.split(subject, '/');
        }
        if (valori == null || valori.length < 1) {
            throw new UtilsException("(" + subject + ") Comprensione subject interno alla configurazione di OpenSPCoop non riuscita: null??");
        }
        for (int i = 0; i < valori.length; ++i) {
            if (!valori[i].contains("=")) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valori[i] + "] non separata dal carattere \"=\". Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
            }
            String[] keyValue = valori[i].trim().split("=");
            if (keyValue.length >= 2) continue;
            throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valori[i] + "] non contiene un valore? Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
        }
        return valori;
    }

    public static Hashtable<String, String> getSubjectIntoHashtable(String subject) throws UtilsException {
        Hashtable<String, String> hashSubject = new Hashtable<String, String>();
        String[] valoriSubject = Utilities.getValoriSubject(subject);
        for (int i = 0; i < valoriSubject.length; ++i) {
            if (!valoriSubject[i].contains("=")) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valoriSubject[i] + "] non separata dal carattere \"=\"");
            }
            String[] keyValue = valoriSubject[i].trim().split("=");
            if (keyValue.length < 2) {
                throw new UtilsException("(" + subject + ") Comprensione subject non riuscita: [" + valoriSubject[i] + "] non contiene un valore? Verificare che non esistano coppie che possiedono valori che contengono il carattere separatore (usare eventualmente come carattere di escape '\\')");
            }
            String valore = Utilities.formatValueSubject(valoriSubject[i].trim().substring(keyValue[0].length() + "=".length()));
            hashSubject.put(Utilities.formatKeySubject(keyValue[0]), valore);
        }
        return hashSubject;
    }

    public static String formatKeySubject(String keySubject) {
        return keySubject.trim().toLowerCase();
    }

    public static String formatValueSubject(String valueSubject) {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < valueSubject.length(); ++i) {
            if (valueSubject.charAt(i) == '/') {
                if (i == 0) {
                    bf.append('\\');
                } else if (valueSubject.charAt(i - 1) != '\\') {
                    bf.append('\\');
                }
            }
            bf.append(valueSubject.charAt(i));
        }
        return bf.toString().trim();
    }

    public static void printFreeMemory(String descr) {
        if (freeMemoryLog) {
            long currentSize = s_runtime.freeMemory();
            log.debug((Object)("[Free Memory Space][CURRENT: " + Utilities.convertBytesToFormatString(currentSize) + "] [DIFF: " + Utilities.convertBytesToFormatString(INITIAL_SIZE - s_runtime.freeMemory()) + "] " + descr));
        }
    }

    public static boolean existsInnerException(Throwable e, Class<?> found) {
        return Utilities.existsInnerException(e, found.getName());
    }

    public static boolean existsInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerException(e.getCause(), found);
        }
        return false;
    }

    public static Throwable getInnerException(Throwable e, Class<?> found) {
        return Utilities.getInnerException(e, found.getName());
    }

    public static Throwable getInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerException(e.getCause(), found);
        }
        return null;
    }

    public static Throwable getLastInnerException(Throwable e) {
        if (e.getCause() == null) {
            return e;
        }
        return Utilities.getLastInnerException(e.getCause());
    }

    public static boolean existsInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerMessageException(e.getCause(), msg, contains);
        }
        return false;
    }

    public static Throwable getInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerMessageException(e.getCause(), msg, contains);
        }
        return null;
    }

    public static Throwable getInnerNotEmptyMessageException(Throwable e) {
        if (e.getMessage() != null && !"".equals(e.getMessage()) && !"null".equalsIgnoreCase(e.getMessage())) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerNotEmptyMessageException(e.getCause());
        }
        return e;
    }

    public static String eraserXmlAttribute(String tmp, String keyword) {
        int indexOfValueWrong = tmp.indexOf(keyword);
        while (indexOfValueWrong > 0) {
            StringBuffer bf = new StringBuffer();
            int index = indexOfValueWrong - 1;
            while (tmp.charAt(index) != ' ') {
                bf.append(tmp.charAt(index));
                --index;
            }
            StringBuffer replaceString = new StringBuffer();
            for (int i = bf.toString().length() - 1; i >= 0; --i) {
                replaceString.append(bf.toString().charAt(i));
            }
            replaceString.append(keyword);
            index = indexOfValueWrong + keyword.length();
            while (tmp.charAt(index) != ' ' && tmp.charAt(index) != '>') {
                replaceString.append(tmp.charAt(index));
                ++index;
            }
            tmp = StringUtils.replace((String)tmp, (String)replaceString.toString(), (String)"");
            indexOfValueWrong = tmp.indexOf(keyword);
        }
        return tmp;
    }

    public static String convertToPrintableText(byte[] b, int maxBytes) throws UtilsException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            if (b.length > maxBytes) {
                throw new UtilsException("Visualizzazione non riuscita: la dimensione del pacchetto fornito (" + Utilities.convertBytesToFormatString(b.length) + ") supera il limite consentito (" + Utilities.convertBytesToFormatString(maxBytes) + ")");
            }
            for (int i = 0; i < b.length; ++i) {
                if (Utilities.isPrintableChar((char)b[i])) continue;
                throw new UtilsException("Visualizzazione non riuscita: il documento contiene caratteri non visualizzabili");
            }
            bout.write(b);
            bout.flush();
            bout.close();
            String tmp = bout.toString();
            bout = null;
            String string = tmp;
            return string;
        }
        catch (Exception e) {
            throw new UtilsException("Visualizzazione non riuscita: Documento binario?");
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    public static boolean isPrintableChar(char c) {
        return Character.isDefined(c);
    }

    static {
        s_runtime = Runtime.getRuntime();
        INITIAL_SIZE = s_runtime.freeMemory();
    }
}

