/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.apache.soap.encoding.soapenc.Base64;

public class Identity {
    private String principalName;
    private Principal principal;
    private String subject;
    private X509Certificate[] certs;
    private String username;
    private String password;
    protected HttpServletRequest httpServletRequest;

    public Identity() {
    }

    public Identity(HttpServletRequest req) {
        this(req, null);
    }

    public Identity(HttpServletRequest req, Logger log) {
        X509Certificate[] certs;
        String decodeAuth;
        String[] decodeAuthSplit;
        this.httpServletRequest = req;
        String auth = req.getHeader("Authorization");
        if (auth != null && (decodeAuthSplit = (decodeAuth = new String(Base64.decode((String)auth.substring(6)))).split(":")).length > 1) {
            this.username = decodeAuthSplit[0];
            this.password = decodeAuthSplit[1];
        }
        if ((certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate")) != null) {
            if (log != null) {
                try {
                    log.info((Object)("Certificati presenti nella richiesta: " + certs.length));
                    for (int i = 0; i < certs.length; ++i) {
                        X509Certificate cert = certs[i];
                        log.info((Object)"===================================================");
                        log.info((Object)("\tCert[" + i + "].toString()=" + cert.toString()));
                        log.info((Object)("\tCert[" + i + "].getType()=" + cert.getType()));
                        log.info((Object)("\tCert[" + i + "].getVersion()=" + cert.getVersion()));
                        if (cert.getIssuerDN() != null) {
                            log.info((Object)("\tCert[" + i + "].cert.getIssuerDN().toString()=" + ((Object)cert.getIssuerDN()).toString()));
                            log.info((Object)("\tCert[" + i + "].cert.getIssuerDN().getName()=" + cert.getIssuerDN().getName()));
                        } else {
                            log.info((Object)("\tCert[" + i + "].cert.getIssuerDN() is null"));
                        }
                        if (cert.getIssuerX500Principal() != null) {
                            log.info((Object)("\tCert[" + i + "].getIssuerX500Principal().toString()=" + cert.getIssuerX500Principal().toString()));
                            log.info((Object)("\tCert[" + i + "].getIssuerX500Principal().getName()=" + cert.getIssuerX500Principal().getName()));
                            log.info((Object)("\tCert[" + i + "].getIssuerX500Principal().getName(X500Principal.CANONICAL)=" + cert.getIssuerX500Principal().getName("CANONICAL")));
                            log.info((Object)("\tCert[" + i + "].getIssuerX500Principal().getName(X500Principal.RFC1779)=" + cert.getIssuerX500Principal().getName("RFC1779")));
                            log.info((Object)("\tCert[" + i + "].getIssuerX500Principal().getName(X500Principal.RFC2253)=" + cert.getIssuerX500Principal().getName("RFC2253")));
                        } else {
                            log.info((Object)("\tCert[" + i + "].cert.getIssuerX500Principal() is null"));
                        }
                        if (cert.getSubjectDN() != null) {
                            log.info((Object)("\tCert[" + i + "].getSubjectDN().toString()=" + ((Object)cert.getSubjectDN()).toString()));
                            log.info((Object)("\tCert[" + i + "].getSubjectDN().getName()=" + cert.getSubjectDN().getName()));
                        } else {
                            log.info((Object)("\tCert[" + i + "].cert.getSubjectDN() is null"));
                        }
                        log.info((Object)("\tCert[" + i + "].getSerialNumber()=" + cert.getSerialNumber()));
                        log.info((Object)("\tCert[" + i + "].getNotAfter()=" + cert.getNotAfter()));
                        log.info((Object)("\tCert[" + i + "].getNotBefore()=" + cert.getNotBefore()));
                        if (cert.getSubjectX500Principal() != null) {
                            log.info((Object)("\tCert[" + i + "].getSubjectX500Principal().toString()=" + cert.getSubjectX500Principal().toString()));
                            log.info((Object)("\tCert[" + i + "].getSubjectX500Principal().getName()=" + cert.getSubjectX500Principal().getName()));
                            log.info((Object)("\tCert[" + i + "].getSubjectX500Principal().getName(X500Principal.CANONICAL)=" + cert.getSubjectX500Principal().getName("CANONICAL")));
                            log.info((Object)("\tCert[" + i + "].getSubjectX500Principal().getName(X500Principal.RFC1779)=" + cert.getSubjectX500Principal().getName("RFC1779")));
                            log.info((Object)("\tCert[" + i + "].getSubjectX500Principal().getName(X500Principal.RFC2253)=" + cert.getSubjectX500Principal().getName("RFC2253")));
                            continue;
                        }
                        log.info((Object)("\tCert[" + i + "].cert.getSubjectX500Principal() is null"));
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Print info certs error: " + e.getMessage()), e);
                }
            }
            if (certs.length > 0) {
                this.subject = certs[0].getSubjectX500Principal().toString();
                this.certs = certs;
            }
        } else if (log != null) {
            log.info((Object)"Certificati non presenti nella richiesta");
        }
        if (req.getUserPrincipal() != null) {
            this.principal = req.getUserPrincipal();
            this.principalName = this.principal.getName();
        }
    }

    public Principal getPrincipalObject() {
        return this.principal;
    }

    public void setPrincipalObject(Principal principalObject) {
        this.principal = principalObject;
    }

    public String getPrincipal() {
        return this.principalName;
    }

    public void setPrincipal(String principal) {
        this.principalName = principal;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public X509Certificate[] getCerts() {
        return this.certs;
    }

    public void setCerts(X509Certificate[] certs) {
        this.certs = certs;
    }

    public boolean isUserInRole(String role) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.isUserInRole(role);
        }
        throw new NotImplementedException("HttpServletRequest undefined");
    }

    public Object getAttribute(String attributeName) {
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.getAttribute(attributeName);
        }
        throw new NotImplementedException("HttpServletRequest undefined");
    }

    public Object getAttribute(String role, String attributeName) {
        throw new NotImplementedException("HttpServletRequest unsupported");
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.principal != null) {
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("principal(");
            bf.append(this.principal);
            bf.append(")");
        }
        if (this.subject != null) {
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("subject(");
            bf.append(this.subject);
            bf.append(")");
        }
        if (this.username != null) {
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("username(");
            bf.append(this.username);
            bf.append(")");
        }
        if (this.password != null) {
            if (bf.length() > 0) {
                bf.append(" ");
            }
            bf.append("password(");
            bf.append(this.password);
            bf.append(")");
        }
        return bf.toString();
    }
}

