/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Riscontro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidazioneSintattica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazioneErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.StrutturaBustaException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ValidazioneSintatticaResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.constants.SPCoopCostantiPosizioneEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.utils.SPCoopUtils;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class SPCoopValidazioneSintattica
implements IValidazioneSintattica {
    private SOAPMessage msg;
    private SOAPHeader headerSOAP = null;
    private SOAPHeaderElement headerEGov;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private Vector<Eccezione> errorsTrovatiSullaListaEccezioni;
    private Busta busta;
    private String msgErrore;
    private CodiceErroreCooperazione codiceErrore;
    private boolean readQualifiedAttribute;
    private IProtocolFactory protocolFactory;
    private Logger log = null;
    private boolean segnalazioneElementoPresentePiuVolte = false;
    private boolean messaggioScaduto = false;
    private Busta bustaErroreHeaderIntestazione = null;
    private List<String> tipiSoggetti = null;
    private List<String> tipiServizi = null;
    private ITraduttore traduttore = null;
    private SPCoopProperties spcoopProperties = null;

    public void setMsg(SOAPMessage msg) {
        this.msg = msg;
    }

    public void setHeaderSOAP(SOAPHeader headerSOAP) {
        this.headerSOAP = headerSOAP;
    }

    public void setReadQualifiedAttribute(boolean readQualifiedAttribute) {
        this.readQualifiedAttribute = readQualifiedAttribute;
    }

    public SPCoopValidazioneSintattica(IProtocolFactory protocolFactory) throws ProtocolException {
        this.log = protocolFactory.getLogger();
        this.protocolFactory = protocolFactory;
        if (this.errorsTrovatiSullaListaEccezioni == null) {
            this.errorsTrovatiSullaListaEccezioni = new Vector();
        }
        if (this.erroriProcessamento == null) {
            this.erroriProcessamento = new Vector();
        }
        if (this.erroriValidazione == null) {
            this.erroriValidazione = new Vector();
        }
        this.tipiSoggetti = this.protocolFactory.createProtocolConfiguration().getTipiSoggetti();
        this.tipiServizi = this.protocolFactory.createProtocolConfiguration().getTipiServizi();
        this.traduttore = this.protocolFactory.createTraduttore();
        this.spcoopProperties = SPCoopProperties.getInstance(this.log);
    }

    public SOAPHeaderElement getHeaderEGov(SOAPMessage aMsg, boolean readQualifiedAttribute) throws ProtocolException {
        this.msg = aMsg;
        this.readQualifiedAttribute = readQualifiedAttribute;
        return this.getHeaderEGov();
    }

    public SOAPHeaderElement getHeaderEGov() throws ProtocolException {
        try {
            if (this.headerEGov != null) {
                return this.headerEGov;
            }
            if (this.headerSOAP == null) {
                this.headerSOAP = this.msg.getSOAPHeader();
            }
            this.headerEGov = this.getHeaderEGov(this.headerSOAP);
            return this.headerEGov;
        }
        catch (Exception e) {
            this.log.error("ValidazioneSintattica.headerEGovAsBytes error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ValidazioneSintattica.headerEGovAsBytes error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Busta getBusta() {
        return this.busta;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public Vector<Eccezione> getErroriTrovatiSullaListaEccezioni() {
        return this.errorsTrovatiSullaListaEccezioni;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public CodiceErroreCooperazione getCodiceErrore() {
        return this.codiceErrore;
    }

    public SOAPHeaderElement getHeaderSPCoop() {
        return this.headerEGov;
    }

    public boolean valida() {
        try {
            if (this.headerSOAP == null) {
                this.headerSOAP = this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                this.msgErrore = "Analizzato un messaggio senza header";
                this.codiceErrore = CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
                return false;
            }
            if (this.headerEGov == null) {
                this.headerEGov = this.getHeaderEGov(this.headerSOAP);
            }
            if (this.headerEGov == null) {
                this.msgErrore = "Analizzato un messaggio senza busta SPCoop";
                this.codiceErrore = CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
                return false;
            }
        }
        catch (StrutturaBustaException e) {
            this.log.error("Struttura della busta non corretta: " + e.getMessage(), (Throwable)e);
            this.msgErrore = e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
            return false;
        }
        catch (Exception e) {
            this.msgErrore = "(Validazione sintattica) " + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
            this.busta = null;
            return false;
        }
        try {
            Eccezione ecc;
            Busta aBusta;
            this.busta = aBusta = new Busta(this.protocolFactory.getProtocol());
            this.erroriValidazione = new Vector();
            this.erroriProcessamento = new Vector();
            this.errorsTrovatiSullaListaEccezioni = new Vector();
            String xmlns = this.getPrefix();
            if (!"http://www.cnipa.it/eGov_it/portadominio".equals(this.headerEGov.getActor())) {
                if (!this.spcoopProperties.isGenerazioneBustaErrore_actorScorretto()) {
                    throw new StrutturaBustaException("Header egov con actor scorretto", "Actor");
                }
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_ACTOR.toString());
                this.erroriValidazione.add(ecc);
            }
            if (!this.headerEGov.getMustUnderstand()) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_MUST_UNDERSTAND.toString());
                this.erroriValidazione.add(ecc);
            }
            Vector list = SoapUtils.getNotEmptyChildNodes((Node)this.headerEGov);
            if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(this.headerEGov.getNamespaceURI())) {
                Eccezione ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_NAMESPACE.toString());
                this.erroriValidazione.add(ecc2);
            }
            Node intestazioneMsg = (Node)list.get(0);
            Vector headerMsg = SoapUtils.getNotEmptyChildNodes((Node)intestazioneMsg);
            boolean mittenteGiaTrovato = false;
            boolean destinatarioGiaTrovato = false;
            boolean profiloCollaborazioneGiaTrovato = false;
            boolean collaborazioneGiaTrovato = false;
            boolean servizioGiaTrovato = false;
            boolean azioneGiaTrovato = false;
            boolean messaggioGiaTrovato = false;
            boolean profiloTrasmissioneGiaTrovato = false;
            boolean sequenzaGiaTrovato = false;
            for (int i = 0; i < headerMsg.size(); ++i) {
                Eccezione ecc3;
                Node child = (Node)headerMsg.get(i);
                if (SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!mittenteGiaTrovato) {
                        this.validazioneMittente(child, xmlns);
                        mittenteGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Mittente", "Mittente");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.MITTENTE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!destinatarioGiaTrovato) {
                        this.validazioneDestinatario(child, xmlns);
                        destinatarioGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Destinatario", "Destinatario");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.DESTINATARIO_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"ProfiloCollaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!profiloCollaborazioneGiaTrovato) {
                        this.validazioneProfiloCollaborazione(child, xmlns);
                        profiloCollaborazioneGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento ProfiloCollaborazione", "ProfiloCollaborazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Collaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!collaborazioneGiaTrovato) {
                        this.validazioneCollaborazione(child);
                        collaborazioneGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Collaborazione", "Collaborazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Servizio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!servizioGiaTrovato) {
                        this.validazioneServizio(child, xmlns);
                        servizioGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Servizio", "Servizio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Azione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!azioneGiaTrovato) {
                        this.validazioneAzione(child);
                        azioneGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Azione", "Azione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.AZIONE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Messaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!messaggioGiaTrovato) {
                        this.validazioneMessaggio(child, xmlns);
                        messaggioGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Messaggio", "Messaggio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_MESSAGGIO + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_MESSAGGIO.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"ProfiloTrasmissione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!profiloTrasmissioneGiaTrovato) {
                        this.validazioneProfiloTrasmissione(child, xmlns);
                        profiloTrasmissioneGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento ProfiloTrasmissione", "ProfiloTrasmissione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)child, (String)"Sequenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (!sequenzaGiaTrovato) {
                        this.validazioneSequenza(child, xmlns);
                        sequenzaGiaTrovato = true;
                        continue;
                    }
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Sequenza", "Sequenza");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                ecc3.setRilevanza(LivelloRilevanza.ERROR);
                ecc3.setDescrizione("Messaggio/child[" + child.getNodeName() + "]");
                this.erroriValidazione.add(ecc3);
            }
            if (this.spcoopProperties.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione() && !this.messaggioScaduto) {
                String[] split;
                Date oraRegistrazioneMinimaAccettata = new Date(DateManager.getTimeMillis() - this.spcoopProperties.getIntervalloScadenzaBuste() * 60L * 1000L);
                if (this.busta.getOraRegistrazione() != null && this.busta.getOraRegistrazione().before(oraRegistrazioneMinimaAccettata)) {
                    this.log.error("OraRegistrazione portata nella busta (" + SPCoopUtils.getDate_eGovFormat(this.busta.getOraRegistrazione()) + ") pi\u00f9 vecchia della data minima attesa (" + SPCoopUtils.getDate_eGovFormat(oraRegistrazioneMinimaAccettata) + ") e scadenza non presente");
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc4.setCodiceEccezione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO);
                    ecc4.setRilevanza(LivelloRilevanza.ERROR);
                    ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc4);
                }
                if (this.busta.getID() != null && (split = this.busta.getID().split("_")) != null && split.length == 5) {
                    Date dataIntoIDEgov = null;
                    try {
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
                        dataIntoIDEgov = dateformat.parse(split[3] + "_" + split[4]);
                    }
                    catch (Exception dateformat) {
                        // empty catch block
                    }
                    if (dataIntoIDEgov != null && dataIntoIDEgov.before(oraRegistrazioneMinimaAccettata)) {
                        this.log.error("Data presente nell'idEgov della busta (" + SPCoopUtils.getDate_eGovFormat(dataIntoIDEgov) + ") pi\u00f9 vecchia della data minima attesa (" + SPCoopUtils.getDate_eGovFormat(oraRegistrazioneMinimaAccettata) + ") e scadenza non presente");
                        Eccezione ecc5 = new Eccezione();
                        ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc5.setCodiceEccezione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO);
                        ecc5.setRilevanza(LivelloRilevanza.ERROR);
                        ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                        this.erroriValidazione.add(ecc5);
                    }
                }
            }
            if (list.size() > 1) {
                boolean listaRiscontriGiaPresente = false;
                boolean listaTrasmissioniGiaPresente = false;
                boolean listaEccezioniGiaPresente = false;
                for (int i = 1; i < list.size(); ++i) {
                    Eccezione ecc6;
                    Node child = (Node)list.get(i);
                    if (SoapUtils.matchLocalName((Node)child, (String)"IntestazioneMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento IntestazioneMessaggio", "IntestazioneMessaggio");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc6.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                        ecc6.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_INTESTAZIONE_MESSAGGIO + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_INTESTAZIONE_MESSAGGIO.toString());
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaRiscontri", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaRiscontriGiaPresente) {
                            this.validazioneListaRiscontri(child, xmlns);
                            listaRiscontriGiaPresente = true;
                            continue;
                        }
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento ListaRiscontri", "ListaRiscontri");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc6.setCodiceEccezione(CodiceErroreCooperazione.LISTA_RISCONTRI_PRESENTE_PIU_VOLTE);
                        ecc6.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE.toString());
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaTrasmissioni", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaTrasmissioniGiaPresente) {
                            this.validazioneListaTrasmissioni(child, xmlns);
                            listaTrasmissioniGiaPresente = true;
                            continue;
                        }
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento ListaTrasmissioni", "ListaTrasmissioni");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc6.setCodiceEccezione(CodiceErroreCooperazione.LISTA_TRASMISSIONI_PRESENTE_PIU_VOLTE);
                        ecc6.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE.toString());
                        }
                        this.erroriValidazione.add(ecc6);
                        continue;
                    }
                    if (SoapUtils.matchLocalName((Node)child, (String)"ListaEccezioni", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        if (!listaEccezioniGiaPresente) {
                            this.validazioneListaEccezioni(child, xmlns);
                            listaEccezioniGiaPresente = true;
                            continue;
                        }
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento ListaEccezioni", "ListaEccezioni");
                        }
                        ecc6 = new Eccezione();
                        ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc6.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                        ecc6.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE.toString());
                        }
                        this.errorsTrovatiSullaListaEccezioni.add(ecc6);
                        continue;
                    }
                    ecc6 = new Eccezione();
                    ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc6.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
                    ecc6.setRilevanza(LivelloRilevanza.ERROR);
                    ecc6.setDescrizione("Intestazione/child[" + child.getNodeName() + "]");
                    this.erroriValidazione.add(ecc6);
                }
            }
            if (this.spcoopProperties.isCheckTolleranzaDateFutureAttivo() && this.erroriValidazione.size() == 0) {
                this.validazioneDatePresentiRispettoDateFuture();
            }
        }
        catch (StrutturaBustaException e) {
            this.log.error("Struttura della busta non corretta: " + e.getMessage(), (Throwable)e);
            this.msgErrore = e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
            return false;
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Errore di processamento durante la validazione sintattica");
            this.erroriProcessamento.add(ecc);
            this.log.error("Errore di processamento durante la validazione sintattica", (Throwable)e);
        }
        return true;
    }

    public SOAPHeaderElement getHeaderEGov_senzaControlli() throws ProtocolException {
        try {
            SOAPHeaderElement headerElement;
            if (this.headerSOAP == null) {
                this.headerSOAP = this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                throw new Exception("Analizzato un messaggio senza header");
            }
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    headerElementEGov = headerElement;
                }
            }
            if (headerElementEGov == null) {
                throw new Exception("Header eGov non presente");
            }
            return headerElementEGov;
        }
        catch (Exception e) {
            throw new ProtocolException("Lettura non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPHeaderElement getHeaderEGov(SOAPHeader header) throws ProtocolException, StrutturaBustaException {
        try {
            int i;
            SOAPHeaderElement headerElement;
            if (header == null) {
                return null;
            }
            Iterator it = header.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            StringBuffer bf = new StringBuffer();
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                try {
                    bf.append("Check ACTOR Atteso[http://www.cnipa.it/eGov_it/portadominio]==[" + headerElement.getActor() + "]=[" + "http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor()) + "]\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                bf.append("FIND!\n");
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                bf.append("NOT FOUND TRAMITE ACTOR!\n");
                it = header.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    try {
                        bf.append("Check NAMESPACE Atteso[http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/]==[" + headerElement.getNamespaceURI() + "]=[" + "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI()) + "]\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    bf.append("FIND!\n");
                    headerElementEGov = headerElement;
                }
            }
            if (headerElementEGov == null) {
                Object msgHeader = "";
                try {
                    msgHeader = " header-soap: " + OpenSPCoop2MessageFactory.getMessageFactory().createEmptySOAPMessage(SOAPVersion.SOAP11).getAsString((Node)header, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new Exception("Header eGov non presente (" + bf.toString() + ")" + (String)msgHeader);
            }
            Busta errore = new Busta(this.protocolFactory.getProtocol());
            errore.setTipoMittente(this.spcoopProperties.getKeywordTipoMittenteSconosciuto());
            errore.setMittente(this.spcoopProperties.getKeywordMittenteSconosciuto());
            errore.setIdentificativoPortaMittente(this.traduttore.getIdentificativoPortaDefault(new IDSoggetto(errore.getTipoMittente(), errore.getMittente())));
            errore.setTipoDestinatario(this.spcoopProperties.getKeywordTipoMittenteSconosciuto());
            errore.setDestinatario(this.spcoopProperties.getKeywordMittenteSconosciuto());
            errore.setIdentificativoPortaDestinatario(this.traduttore.getIdentificativoPortaDefault(new IDSoggetto(errore.getTipoDestinatario(), errore.getDestinatario())));
            if (this.existsMoreHeaderEGov()) {
                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.FORMATO_NON_CORRETTO, (String)"Pi\u00f9 di un header e-Gov presente", (IProtocolFactory)this.protocolFactory));
                this.bustaErroreHeaderIntestazione = errore;
                throw new Exception("Pi\u00f9 di un header e-Gov presente");
            }
            Object xmlns = headerElementEGov.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!((String)xmlns).equals("")) {
                xmlns = (String)xmlns + ":";
            }
            if (!SoapUtils.matchLocalName((Node)headerElementEGov, (String)"Intestazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.FORMATO_NON_CORRETTO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_NON_CORRETTO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                throw new Exception("Header eGov senza header intestazione");
            }
            Vector list = SoapUtils.getNotEmptyChildNodes((Node)headerElementEGov);
            if (list == null || list.size() == 0) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_INTESTAZIONE_MESSAGGIO.toString(), (IProtocolFactory)this.protocolFactory));
                throw new Exception("Header eGov con header intestazione senza elementi interni tra cui IntestazioneMessaggio");
            }
            Node intestazioneMsg = (Node)list.get(0);
            if (intestazioneMsg == null || !SoapUtils.matchLocalName((Node)intestazioneMsg, (String)"IntestazioneMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                this.bustaErroreHeaderIntestazione = errore;
                this.bustaErroreHeaderIntestazione.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_INTESTAZIONE_MESSAGGIO.toString(), (IProtocolFactory)this.protocolFactory));
                throw new Exception("Header eGov con header intestazione che possiede first child [" + intestazioneMsg.getNodeName() + "] diverso da IntestazioneMessaggio");
            }
            Vector intestMsgChild = SoapUtils.getNotEmptyChildNodes((Node)intestazioneMsg);
            Node mittente = null;
            Node destinatario = null;
            Node messaggio = null;
            for (int i2 = 0; i2 < intestMsgChild.size(); ++i2) {
                Node child = (Node)intestMsgChild.get(i2);
                if (child == null) {
                    this.log.info("Elemento null");
                } else if (child.getNodeName() == null) {
                    this.log.info("Elemento child null");
                }
                if (child == null || child.getNodeName() == null) continue;
                if (mittente == null && SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    mittente = child;
                    continue;
                }
                if (destinatario == null && SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    destinatario = child;
                    continue;
                }
                if (messaggio != null || !SoapUtils.matchLocalName((Node)child, (String)"Messaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                messaggio = child;
            }
            boolean eccezioneStrutturaMittente = false;
            boolean eccezioneStrutturaDestinatario = false;
            boolean eccezioneStrutturaMessaggio = false;
            if (mittente == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                eccezioneStrutturaMittente = true;
            } else {
                Vector headerMittente = SoapUtils.getNotEmptyChildNodes(mittente);
                if (headerMittente == null || headerMittente.size() == 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                    eccezioneStrutturaMittente = true;
                } else {
                    for (i = 0; i < headerMittente.size(); ++i) {
                        String tipoMittente;
                        String mittenteValue;
                        block135: {
                            Node idParteMittente = (Node)headerMittente.get(i);
                            if (!SoapUtils.matchLocalName((Node)idParteMittente, (String)"IdentificativoParte", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaMittente = true;
                                break;
                            }
                            Vector valueIDParteMitt = SoapUtils.getNotEmptyChildNodes((Node)idParteMittente);
                            if (valueIDParteMitt == null || valueIDParteMitt.size() == 0 || valueIDParteMitt.size() > 1) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_NON_VALORIZZATO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaMittente = false;
                                break;
                            }
                            mittenteValue = null;
                            try {
                                mittenteValue = ((Node)valueIDParteMitt.get(0)).getNodeValue();
                                if (mittenteValue == null) {
                                    throw new Exception("mittente is null");
                                }
                            }
                            catch (Exception e) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_NON_VALORIZZATO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaMittente = false;
                                break;
                            }
                            tipoMittente = null;
                            Node hrefFindMitt = null;
                            hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"tipo");
                            if (hrefFindMitt != null) {
                                try {
                                    tipoMittente = hrefFindMitt.getNodeValue();
                                    if (tipoMittente == null) {
                                        throw new Exception("tipo non definito");
                                    }
                                    break block135;
                                }
                                catch (Exception e) {
                                    errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALIDO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString(), (IProtocolFactory)this.protocolFactory));
                                    eccezioneStrutturaMittente = true;
                                    break;
                                }
                            }
                            errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.TIPO_MITTENTE_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString(), (IProtocolFactory)this.protocolFactory));
                            eccezioneStrutturaMittente = true;
                            break;
                        }
                        if (i == 0) {
                            errore.setTipoMittente(tipoMittente);
                            errore.setMittente(mittenteValue);
                            continue;
                        }
                        errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.MITTENTE_PRESENTE_PIU_VOLTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                        eccezioneStrutturaMittente = false;
                    }
                }
            }
            if (destinatario == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                eccezioneStrutturaDestinatario = true;
            } else {
                Vector headerDestinatario = SoapUtils.getNotEmptyChildNodes(destinatario);
                if (headerDestinatario == null || headerDestinatario.size() == 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                    eccezioneStrutturaDestinatario = true;
                } else {
                    for (i = 0; i < headerDestinatario.size(); ++i) {
                        String tipoDestinatario;
                        String destinatarioValue;
                        block136: {
                            Node idParteDestinatario = (Node)headerDestinatario.get(i);
                            if (!SoapUtils.matchLocalName((Node)idParteDestinatario, (String)"IdentificativoParte", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_NON_VALIDO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaDestinatario = true;
                                break;
                            }
                            Vector valueIDParteDest = SoapUtils.getNotEmptyChildNodes((Node)idParteDestinatario);
                            if (valueIDParteDest == null || valueIDParteDest.size() == 0 || valueIDParteDest.size() > 1) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_NON_VALIDO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaDestinatario = false;
                                break;
                            }
                            destinatarioValue = null;
                            try {
                                destinatarioValue = ((Node)valueIDParteDest.get(0)).getNodeValue();
                                if (destinatarioValue == null) {
                                    throw new Exception("destinatario is null");
                                }
                            }
                            catch (Exception e) {
                                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_NON_VALORIZZATO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                                eccezioneStrutturaDestinatario = false;
                                break;
                            }
                            tipoDestinatario = null;
                            Node hrefFindDest = null;
                            hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDestinatario, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDestinatario, (String)"tipo");
                            if (hrefFindDest != null) {
                                try {
                                    tipoDestinatario = hrefFindDest.getNodeValue();
                                    if (tipoDestinatario == null) {
                                        throw new Exception("tipo non definito");
                                    }
                                    break block136;
                                }
                                catch (Exception e) {
                                    errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_VALIDO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString(), (IProtocolFactory)this.protocolFactory));
                                    eccezioneStrutturaDestinatario = true;
                                    break;
                                }
                            }
                            errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString(), (IProtocolFactory)this.protocolFactory));
                            eccezioneStrutturaDestinatario = true;
                            break;
                        }
                        if (i == 0) {
                            errore.setTipoDestinatario(tipoDestinatario);
                            errore.setDestinatario(destinatarioValue);
                            continue;
                        }
                        errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.DESTINATARIO_PRESENTE_PIU_VOLTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString(), (IProtocolFactory)this.protocolFactory));
                        eccezioneStrutturaDestinatario = false;
                    }
                }
            }
            if (messaggio == null) {
                errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_FORMATO_INTESTAZIONE_NON_CORRETTO_POSIZIONE_MESSAGGIO.toString(), (IProtocolFactory)this.protocolFactory));
                eccezioneStrutturaMessaggio = true;
            } else {
                Vector contenutoMsg = SoapUtils.getNotEmptyChildNodes((Node)messaggio);
                if (contenutoMsg.size() <= 0) {
                    errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                    eccezioneStrutturaMessaggio = true;
                } else {
                    String identificatore = null;
                    boolean identificatoreTrovato = false;
                    for (int j = 0; j < contenutoMsg.size(); ++j) {
                        Node childMsg = (Node)contenutoMsg.get(j);
                        if (!SoapUtils.matchLocalName((Node)childMsg, (String)"Identificatore", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                        identificatoreTrovato = true;
                        if (SoapUtils.getNotEmptyChildNodes((Node)childMsg).size() != 1) {
                            errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                            break;
                        }
                        try {
                            identificatore = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                        }
                        catch (Exception tipoDestinatario) {}
                        break;
                    }
                    if (!identificatoreTrovato) {
                        errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                        eccezioneStrutturaMessaggio = true;
                    } else if (identificatore == null) {
                        errore.addEccezione(Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE, (String)SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString(), (IProtocolFactory)this.protocolFactory));
                        eccezioneStrutturaMessaggio = false;
                    } else {
                        errore.setID(identificatore);
                    }
                }
            }
            if (errore.sizeListaEccezioni() > 0) {
                String itValue;
                if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo() && (eccezioneStrutturaMittente || eccezioneStrutturaDestinatario || eccezioneStrutturaMessaggio)) {
                    Eccezione ec = errore.getEccezione(0);
                    throw new StrutturaBustaException("Header egov con struttura errata, " + ec.getDescrizione(this.protocolFactory), ec.getDescrizione(this.protocolFactory).replaceAll("/", ""));
                }
                Node servizio = null;
                Node azione = null;
                Node profiloCollaborazione = null;
                Node collaborazione = null;
                Node profiloTrasmissione = null;
                Node sequenza = null;
                for (int i3 = 0; i3 < intestMsgChild.size(); ++i3) {
                    Node child = (Node)intestMsgChild.get(i3);
                    if (mittente == null && SoapUtils.matchLocalName((Node)child, (String)"Mittente", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        mittente = child;
                        continue;
                    }
                    if (destinatario == null && SoapUtils.matchLocalName((Node)child, (String)"Destinatario", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        destinatario = child;
                        continue;
                    }
                    if (servizio == null && SoapUtils.matchLocalName((Node)child, (String)"Servizio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        servizio = child;
                        continue;
                    }
                    if (azione == null && SoapUtils.matchLocalName((Node)child, (String)"Azione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        azione = child;
                        continue;
                    }
                    if (profiloCollaborazione == null && SoapUtils.matchLocalName((Node)child, (String)"ProfiloCollaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        profiloCollaborazione = child;
                        continue;
                    }
                    if (collaborazione == null && SoapUtils.matchLocalName((Node)child, (String)"Collaborazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        collaborazione = child;
                        continue;
                    }
                    if (profiloTrasmissione == null && SoapUtils.matchLocalName((Node)child, (String)"ProfiloTrasmissione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                        profiloTrasmissione = child;
                        continue;
                    }
                    if (sequenza != null || !SoapUtils.matchLocalName((Node)child, (String)"Sequenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                    sequenza = child;
                }
                if (mittente != null) {
                    Node hrefFindMitt;
                    Node idParteMittente;
                    Vector headerMittente2;
                    try {
                        headerMittente2 = SoapUtils.getNotEmptyChildNodes((Node)mittente);
                        idParteMittente = (Node)headerMittente2.get(0);
                        errore.setMittente(((Node)SoapUtils.getNotEmptyChildNodes((Node)idParteMittente).get(0)).getNodeValue());
                    }
                    catch (Exception headerMittente2) {
                        // empty catch block
                    }
                    try {
                        headerMittente2 = SoapUtils.getNotEmptyChildNodes((Node)mittente);
                        idParteMittente = (Node)headerMittente2.get(0);
                        hrefFindMitt = null;
                        hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"tipo");
                        itValue = hrefFindMitt.getNodeValue();
                        errore.setTipoMittente(itValue);
                    }
                    catch (Exception headerMittente3) {
                        // empty catch block
                    }
                    try {
                        headerMittente2 = SoapUtils.getNotEmptyChildNodes((Node)mittente);
                        idParteMittente = (Node)headerMittente2.get(0);
                        hrefFindMitt = null;
                        hrefFindMitt = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteMittente, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteMittente, (String)"indirizzoTelematico");
                        itValue = hrefFindMitt.getNodeValue();
                        errore.setIndirizzoMittente(itValue);
                    }
                    catch (Exception headerMittente4) {
                        // empty catch block
                    }
                }
                if (destinatario != null) {
                    Node hrefFindDest;
                    Node idParteDest;
                    Vector headerDest2;
                    try {
                        headerDest2 = SoapUtils.getNotEmptyChildNodes((Node)destinatario);
                        idParteDest = (Node)headerDest2.get(0);
                        errore.setDestinatario(((Node)SoapUtils.getNotEmptyChildNodes((Node)idParteDest).get(0)).getNodeValue());
                    }
                    catch (Exception headerDest2) {
                        // empty catch block
                    }
                    try {
                        headerDest2 = SoapUtils.getNotEmptyChildNodes((Node)destinatario);
                        idParteDest = (Node)headerDest2.get(0);
                        hrefFindDest = null;
                        hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDest, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDest, (String)"tipo");
                        itValue = hrefFindDest.getNodeValue();
                        errore.setTipoDestinatario(itValue);
                    }
                    catch (Exception headerDest3) {
                        // empty catch block
                    }
                    try {
                        headerDest2 = SoapUtils.getNotEmptyChildNodes((Node)destinatario);
                        idParteDest = (Node)headerDest2.get(0);
                        hrefFindDest = null;
                        hrefFindDest = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParteDest, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParteDest, (String)"indirizzoTelematico");
                        itValue = hrefFindDest.getNodeValue();
                        errore.setIndirizzoDestinatario(itValue);
                    }
                    catch (Exception headerDest4) {
                        // empty catch block
                    }
                }
                if (servizio != null) {
                    try {
                        errore.setServizio(((Node)SoapUtils.getNotEmptyChildNodes(servizio).get(0)).getNodeValue());
                    }
                    catch (Exception headerDest4) {
                        // empty catch block
                    }
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)servizio, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(servizio, (String)"tipo");
                        errore.setTipoServizio(hrefFind.getNodeValue());
                    }
                    catch (Exception hrefFind) {
                        // empty catch block
                    }
                }
                if (azione != null) {
                    try {
                        errore.setAzione(((Node)SoapUtils.getNotEmptyChildNodes(azione).get(0)).getNodeValue());
                    }
                    catch (Exception hrefFind) {
                        // empty catch block
                    }
                }
                if (profiloCollaborazione != null) {
                    Node hrefFind2;
                    try {
                        String profilovalue = ((Node)SoapUtils.getNotEmptyChildNodes(profiloCollaborazione).get(0)).getNodeValue();
                        errore.setProfiloDiCollaborazione(this.toProfilo(profilovalue), profilovalue);
                    }
                    catch (Exception profilovalue) {
                        // empty catch block
                    }
                    try {
                        hrefFind2 = null;
                        hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloCollaborazione, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(profiloCollaborazione, (String)"tipo");
                        errore.setTipoServizioCorrelato(hrefFind2.getNodeValue());
                    }
                    catch (Exception hrefFind2) {
                        // empty catch block
                    }
                    try {
                        hrefFind2 = null;
                        hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloCollaborazione, (String)"servizioCorrelato", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)profiloCollaborazione, (String)"servizioCorrelato");
                        errore.setServizioCorrelato(hrefFind2.getNodeValue());
                    }
                    catch (Exception hrefFind3) {
                        // empty catch block
                    }
                }
                if (collaborazione != null) {
                    try {
                        errore.setCollaborazione(((Node)SoapUtils.getNotEmptyChildNodes(collaborazione).get(0)).getNodeValue());
                    }
                    catch (Exception hrefFind3) {
                        // empty catch block
                    }
                }
                if (messaggio != null) {
                    try {
                        Vector contenutoMsg = SoapUtils.getNotEmptyChildNodes((Node)messaggio);
                        for (int j = 0; j < contenutoMsg.size(); ++j) {
                            Node childMsg = (Node)contenutoMsg.get(j);
                            if (SoapUtils.matchLocalName((Node)childMsg, (String)"RiferimentoMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                try {
                                    errore.setRiferimentoMessaggio(((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue());
                                }
                                catch (Exception itValue2) {}
                                continue;
                            }
                            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Scadenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                                try {
                                    String scadenza = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                                    Date scadenzaDate = this.validazioneData(scadenza);
                                    errore.setScadenza(scadenzaDate);
                                }
                                catch (Exception scadenza) {}
                                continue;
                            }
                            if (!SoapUtils.matchLocalName((Node)childMsg, (String)"OraRegistrazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) continue;
                            try {
                                String oraRegistrazione = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                                Date oraDate = this.validazioneData(oraRegistrazione);
                                errore.setOraRegistrazione(oraDate);
                            }
                            catch (Exception oraRegistrazione) {
                                // empty catch block
                            }
                            try {
                                Node hrefFind = null;
                                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)childMsg, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)childMsg, (String)"tempo");
                                String tipoOraRegistrazioneValue = hrefFind.getNodeValue();
                                errore.setTipoOraRegistrazione(this.toTipoOra(tipoOraRegistrazioneValue), tipoOraRegistrazioneValue);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception contenutoMsg) {
                        // empty catch block
                    }
                }
                if (profiloTrasmissione != null) {
                    Node hrefFind4;
                    try {
                        hrefFind4 = null;
                        hrefFind4 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode(profiloTrasmissione, (String)"confermaRicezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(profiloTrasmissione, (String)"confermaRicezione");
                        if (hrefFind4.getNodeValue().equals("true")) {
                            errore.setConfermaRicezione(true);
                        } else {
                            errore.setConfermaRicezione(false);
                        }
                    }
                    catch (Exception hrefFind4) {
                        // empty catch block
                    }
                    try {
                        hrefFind4 = null;
                        hrefFind4 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)profiloTrasmissione, (String)"inoltro", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)profiloTrasmissione, (String)"inoltro");
                        String inoltro = hrefFind4.getNodeValue();
                        errore.setInoltro(this.toInoltro(inoltro), inoltro);
                    }
                    catch (Exception hrefFind5) {
                        // empty catch block
                    }
                }
                if (sequenza != null) {
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode(sequenza, (String)"numeroProgressivo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode(sequenza, (String)"numeroProgressivo");
                        Long test = Long.valueOf(hrefFind.getNodeValue());
                        errore.setSequenza(test.longValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.bustaErroreHeaderIntestazione = errore;
                throw new Exception("Header eGov senza alcuni elementi principali: presenza mittente[" + (mittente != null) + "] destinatario[" + (destinatario != null) + "] messaggio[" + (messaggio != null) + "] eccezioni-riscontrate: [" + errore.toStringListaEccezioni(this.getProtocolFactory()) + "]");
            }
            return headerElementEGov;
        }
        catch (StrutturaBustaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProtocolException("Lettura non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean existsHeaderEGov(OpenSPCoop2Message msg) {
        this.msg = (SOAPMessage)msg;
        try {
            SOAPHeaderElement headerElement;
            if (this.headerEGov != null) {
                return true;
            }
            if (msg == null) {
                return false;
            }
            if (this.headerSOAP == null) {
                this.headerSOAP = this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                return false;
            }
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            SOAPHeaderElement headerElementEGov = null;
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                headerElementEGov = headerElement;
            }
            if (headerElementEGov == null) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    headerElementEGov = headerElement;
                }
            }
            return headerElementEGov != null;
        }
        catch (Exception e) {
            this.log.error("existsHeaderEGov error: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean existsMoreHeaderEGov() {
        try {
            SOAPHeaderElement headerElement;
            if (this.headerSOAP == null) {
                this.headerSOAP = this.msg.getSOAPHeader();
            }
            if (this.headerSOAP == null) {
                return false;
            }
            boolean headerGiaTrovato = false;
            Iterator it = this.headerSOAP.examineAllHeaderElements();
            while (it.hasNext()) {
                headerElement = (SOAPHeaderElement)it.next();
                if (!"http://www.cnipa.it/eGov_it/portadominio".equals(headerElement.getActor())) continue;
                if (headerGiaTrovato) {
                    return true;
                }
                headerGiaTrovato = true;
            }
            if (!headerGiaTrovato) {
                it = this.headerSOAP.examineAllHeaderElements();
                while (it.hasNext()) {
                    headerElement = (SOAPHeaderElement)it.next();
                    if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(headerElement.getNamespaceURI())) continue;
                    if (headerGiaTrovato) {
                        return true;
                    }
                    headerGiaTrovato = true;
                }
            }
            return false;
        }
        catch (Exception e) {
            this.log.error("existsMoreHeaderEGov error: " + e.getMessage());
            return false;
        }
    }

    public String getPrefix() {
        Object xmlns = this.headerEGov.getPrefix();
        if (xmlns == null) {
            xmlns = "";
        }
        if (!((String)xmlns).equals("")) {
            xmlns = (String)xmlns + ":";
        }
        return xmlns;
    }

    private void validazioneMittente(Node child, String prefix) throws ProtocolException {
        Vector headerMittente = SoapUtils.getNotEmptyChildNodes((Node)child);
        Node idParte = (Node)headerMittente.get(0);
        Vector valueIDParte = SoapUtils.getNotEmptyChildNodes((Node)idParte);
        String value = ((Node)valueIDParte.get(0)).getNodeValue();
        Node hrefFind = null;
        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
        String tipo = hrefFind.getNodeValue();
        if (!this.tipiSoggetti.contains(tipo)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoMittente(tipo);
        this.busta.setMittente(value);
        String indTelematico = null;
        try {
            Node hrefFindT = null;
            hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
            if (hrefFindT != null) {
                indTelematico = hrefFindT.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_MITTENTE_NON_PRESENTE);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (indTelematico != null && !indTelematico.equals("")) {
            URL urlCheck = null;
            try {
                urlCheck = new URL(indTelematico);
                this.busta.setIndirizzoMittente(urlCheck.toString());
            }
            catch (Exception e) {
                this.busta.setIndirizzoMittente(indTelematico);
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_MITTENTE_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                this.erroriValidazione.add(ecc);
            }
        }
    }

    private void validazioneDestinatario(Node child, String prefix) throws ProtocolException {
        Vector headerDestinatario = SoapUtils.getNotEmptyChildNodes((Node)child);
        Node idParte = (Node)headerDestinatario.get(0);
        Vector valueIDParte = SoapUtils.getNotEmptyChildNodes((Node)idParte);
        String value = ((Node)valueIDParte.get(0)).getNodeValue();
        Node hrefFind = null;
        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
        String tipo = hrefFind.getNodeValue();
        if (!this.tipiSoggetti.contains(tipo)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_DESTINATARIO_SCONOSCIUTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoDestinatario(tipo);
        this.busta.setDestinatario(value);
        String indTelematico = null;
        try {
            Node hrefFindT = null;
            hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
            if (hrefFindT != null) {
                indTelematico = hrefFindT.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_DESTINATARIO_NON_PRESENTE);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (indTelematico != null && !indTelematico.equals("")) {
            URL urlcheck = null;
            try {
                urlcheck = new URL(indTelematico);
                this.busta.setIndirizzoDestinatario(urlcheck.toString());
            }
            catch (Exception e) {
                this.busta.setIndirizzoDestinatario(indTelematico);
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.INDIRIZZO_DESTINATARIO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                this.erroriValidazione.add(ecc);
            }
        }
    }

    private void validazioneProfiloCollaborazione(Node child, String prefix) throws ProtocolException {
        Eccezione ecc;
        Eccezione ecc2;
        Eccezione ecc3;
        String profilo = null;
        Vector valueProfiloDiCollaborazione = SoapUtils.getNotEmptyChildNodes((Node)child);
        if (valueProfiloDiCollaborazione.size() == 0 || valueProfiloDiCollaborazione.size() > 1) {
            ecc3 = new Eccezione();
            ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc3.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO);
            ecc3.setRilevanza(LivelloRilevanza.ERROR);
            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc3);
        } else {
            try {
                profilo = ((Node)valueProfiloDiCollaborazione.get(0)).getNodeValue();
                if (!(profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono") || profilo.equals("EGOV_IT_ServizioAsincronoSimmetrico") || profilo.equals("EGOV_IT_ServizioAsincronoAsimmetrico"))) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_SCONOSCIUTO);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc3);
                }
                this.busta.setProfiloDiCollaborazione(this.toProfilo(profilo), profilo);
            }
            catch (Exception e) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString());
                this.erroriValidazione.add(ecc2);
            }
        }
        String tipo = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"tipo");
            if (hrefFind != null) {
                tipo = hrefFind.getNodeValue();
            }
        }
        catch (Exception e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (tipo != null && !this.tipiServizi.contains(tipo)) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_SCONOSCIUTO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO.toString());
            this.erroriValidazione.add(ecc2);
        }
        String servizioCorrelato = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"servizioCorrelato", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"servizioCorrelato");
            if (hrefFind != null) {
                servizioCorrelato = hrefFind.getNodeValue();
            }
        }
        catch (Exception e) {
            Eccezione ecc4 = new Eccezione();
            ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc4.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_VALIDO);
            ecc4.setRilevanza(LivelloRilevanza.ERROR);
            ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_SERVIZIO_CORRELATO.toString());
            this.erroriValidazione.add(ecc4);
        }
        this.busta.setTipoServizioCorrelato(tipo);
        this.busta.setServizioCorrelato(servizioCorrelato);
        if (servizioCorrelato != null && (profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono"))) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_CORRELATO_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_SERVIZIO_CORRELATO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (tipo != null && this.tipiServizi.contains(tipo) && (profilo.equals("EGOV_IT_MessaggioSingoloOneWay") || profilo.equals("EGOV_IT_ServizioSincrono"))) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_CORRELATO_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE_TIPO_SERVIZIO_CORRELATO.toString());
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneCollaborazione(Node child) throws ProtocolException {
        if (SoapUtils.getNotEmptyChildNodes((Node)child).size() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        String coll = null;
        try {
            coll = ((Node)SoapUtils.getNotEmptyChildNodes((Node)child).get(0)).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.COLLABORAZIONE_NON_VALORIZZATA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setCollaborazione(coll);
    }

    private void validazioneServizio(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        if (SoapUtils.getNotEmptyChildNodes((Node)child).size() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        String serv = null;
        try {
            serv = ((Node)SoapUtils.getNotEmptyChildNodes((Node)child).get(0)).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.SERVIZIO_NON_VALORIZZATO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setServizio(serv);
        String tipo = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"tipo");
            if (hrefFind != null) {
                tipo = hrefFind.getNodeValue();
            }
            if (tipo == null) {
                if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                    throw new StrutturaBustaException("Header egov con elemento Servizio senza tipo", "Servizio");
                }
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_NON_PRESENTE);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString());
                this.erroriValidazione.add(ecc);
            } else if (!this.tipiServizi.contains(tipo)) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_SCONOSCIUTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString());
                this.erroriValidazione.add(ecc);
            }
        }
        catch (StrutturaBustaException e) {
            throw e;
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TIPO_SERVIZIO_NON_VALIDO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setTipoServizio(tipo);
    }

    private void validazioneAzione(Node child) throws ProtocolException {
        if (SoapUtils.getNotEmptyChildNodes((Node)child).size() != 1) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.AZIONE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        String azione = null;
        try {
            azione = ((Node)SoapUtils.getNotEmptyChildNodes((Node)child).get(0)).getNodeValue();
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.AZIONE_NON_VALORIZZATA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setAzione(azione);
    }

    private void validazioneMessaggio(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        String xmlns = this.getPrefix();
        Vector contenutoMsg = SoapUtils.getNotEmptyChildNodes((Node)child);
        if (contenutoMsg.size() == 0 || contenutoMsg.size() > 4) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("IntestazioneMessaggio/Messaggio childsize:" + contenutoMsg.size());
            this.erroriValidazione.add(ecc);
        }
        boolean presenzaID = false;
        boolean presenzaOra = false;
        boolean presenzaScadenza = false;
        boolean presenzaRifMessaggio = false;
        for (int j = 0; j < contenutoMsg.size(); ++j) {
            Eccezione ecc;
            Eccezione ecc2;
            Eccezione ecc3;
            Node childMsg = (Node)contenutoMsg.get(j);
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Identificatore", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaID) {
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Identificatore", "MessaggioIdentificatore");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaID = true;
                if (SoapUtils.getNotEmptyChildNodes((Node)childMsg).size() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String id = null;
                try {
                    id = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                }
                if (id == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc);
                }
                this.busta.setID(id);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"OraRegistrazione", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaOra) {
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento OraRegistrazione", "MessaggioOraRegistrazione");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaOra = true;
                if (SoapUtils.getNotEmptyChildNodes((Node)childMsg).size() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String ora = null;
                try {
                    ora = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALORIZZATA);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                Date oraDate = null;
                if (ora != null) {
                    oraDate = this.validazioneData(ora);
                }
                if (ora == null || oraDate == null) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALORIZZATA);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                }
                this.busta.setOraRegistrazione(oraDate);
                String tipoOra = null;
                try {
                    Node hrefFind = null;
                    hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)childMsg, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)childMsg, (String)"tempo");
                    tipoOra = hrefFind.getNodeValue();
                }
                catch (Exception e) {
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov senza elemento OraRegistrazione tempo", "OraRegistrazioneTempo");
                    }
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc4.setCodiceEccezione(CodiceErroreCooperazione.TIPO_ORA_REGISTRAZIONE_NON_VALIDA);
                    ecc4.setRilevanza(LivelloRilevanza.ERROR);
                    ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc4);
                }
                if (tipoOra != null && !tipoOra.equals("EGOV_IT_Locale") && !tipoOra.equals("EGOV_IT_SPC")) {
                    Eccezione ecc5 = new Eccezione();
                    ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc5.setCodiceEccezione(CodiceErroreCooperazione.TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA);
                    ecc5.setRilevanza(LivelloRilevanza.ERROR);
                    ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc5);
                }
                this.busta.setTipoOraRegistrazione(this.toTipoOra(tipoOra), tipoOra);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"RiferimentoMessaggio", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaRifMessaggio) {
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento RiferimentoMessaggio", "MessaggioRiferimentoMessaggio");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaRifMessaggio = true;
                if (SoapUtils.getNotEmptyChildNodes((Node)childMsg).size() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String rifID = null;
                try {
                    rifID = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                }
                if (rifID == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc);
                }
                this.busta.setRiferimentoMessaggio(rifID);
                continue;
            }
            if (SoapUtils.matchLocalName((Node)childMsg, (String)"Scadenza", (String)xmlns, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                if (presenzaScadenza) {
                    if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                        throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento Scadenza", "MessaggioScadenza");
                    }
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.SCADENZA_PRESENTE_PIU_VOLTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    if (this.segnalazioneElementoPresentePiuVolte) {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE + " elemento presente pi\u00f9 volte nell'header");
                    } else {
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    }
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                presenzaScadenza = true;
                if (SoapUtils.getNotEmptyChildNodes((Node)childMsg).size() != 1) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.SCADENZA_NON_PRESENTE);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                String scadenza = null;
                try {
                    scadenza = ((Node)SoapUtils.getNotEmptyChildNodes((Node)childMsg).get(0)).getNodeValue();
                }
                catch (Exception e) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.SCADENZA_NON_VALIDA);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                Date scadenzaDate = null;
                if (scadenza != null) {
                    scadenzaDate = this.validazioneData(scadenza);
                }
                if (scadenza == null || scadenzaDate == null) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.SCADENZA_NON_VALORIZZATA);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                if (this.dataScaduta(scadenza)) {
                    this.messaggioScaduto = true;
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.MESSAGGIO_SCADUTO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SCADENZA_NON_VALIDA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc2);
                }
                this.busta.setScadenza(scadenzaDate);
                continue;
            }
            ecc3 = new Eccezione();
            ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
            ecc3.setRilevanza(LivelloRilevanza.ERROR);
            ecc3.setDescrizione("IntestazioneMessaggio/Messaggio/child[" + childMsg.getNodeName() + "]");
            this.erroriValidazione.add(ecc3);
        }
        if (!presenzaID) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        if (!presenzaOra) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_PRESENTE);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneProfiloTrasmissione(Node child, String prefix) throws ProtocolException {
        Eccezione ecc;
        Node hrefFind2;
        if (SoapUtils.getNotEmptyChildNodes((Node)child).size() != 0) {
            Eccezione ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_NON_VALIDO);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE + " child size:" + SoapUtils.getNotEmptyChildNodes((Node)child).size());
            this.erroriValidazione.add(ecc2);
        }
        String inoltro = null;
        String confermaRicezione = null;
        try {
            hrefFind2 = null;
            hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"inoltro", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"inoltro");
            inoltro = hrefFind2.getNodeValue();
        }
        catch (Exception hrefFind2) {
            // empty catch block
        }
        try {
            hrefFind2 = null;
            hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"confermaRicezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"confermaRicezione");
            confermaRicezione = hrefFind2.getNodeValue();
        }
        catch (Exception hrefFind3) {
            // empty catch block
        }
        if (inoltro == null) {
            inoltro = "EGOV_IT_PIUDIUNAVOLTA";
        } else if (!inoltro.equals("EGOV_IT_ALPIUUNAVOLTA") && !inoltro.equals("EGOV_IT_PIUDIUNAVOLTA")) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE_INOLTRO.toString());
            this.erroriValidazione.add(ecc);
        }
        if (confermaRicezione == null) {
            confermaRicezione = "false";
        } else if (!confermaRicezione.equals("true") && !confermaRicezione.equals("false")) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE_CONFERMA_RICEZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        this.busta.setInoltro(this.toInoltro(inoltro), inoltro);
        if (confermaRicezione.equals("true")) {
            this.busta.setConfermaRicezione(true);
        } else {
            this.busta.setConfermaRicezione(false);
        }
    }

    private void validazioneSequenza(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        if (SoapUtils.getNotEmptyChildNodes((Node)child).size() != 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        String seq = null;
        try {
            Node hrefFind = null;
            hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)child, (String)"numeroProgressivo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)child, (String)"numeroProgressivo");
            seq = hrefFind.getNodeValue();
        }
        catch (Exception hrefFind) {
            // empty catch block
        }
        if (seq == null) {
            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                throw new StrutturaBustaException("Header egov senza elemento Sequenza numeroProgressivo", "SequenzaNumeroProgressivo");
            }
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_VALORIZZATA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_NUMERO_PROGRESSIVO.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        try {
            Long test = Long.valueOf(seq);
            this.busta.setSequenza(test.longValue());
        }
        catch (Exception e) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_NUMERO_PROGRESSIVO.toString());
            this.erroriValidazione.add(ecc);
        }
    }

    private void validazioneListaRiscontri(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        Vector riscontri = SoapUtils.getNotEmptyChildNodes((Node)child);
        if (riscontri.size() <= 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.LISTA_RISCONTRI_NON_VALORIZZATA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        for (int i = 0; i < riscontri.size(); ++i) {
            boolean errorFind = false;
            Node riscontro = (Node)riscontri.get(i);
            if (!SoapUtils.matchLocalName((Node)riscontro, (String)"Riscontro", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE + "/childNode[" + riscontro.getNodeName() + "]");
                this.erroriValidazione.add(ecc);
                continue;
            }
            Vector childsRiscontro = SoapUtils.getNotEmptyChildNodes((Node)riscontro);
            boolean presenzaIdentificatore = false;
            boolean presenzaOraRegistrazione = false;
            String id = null;
            boolean findID = false;
            String ora = null;
            Date oraDate = null;
            boolean findOra = false;
            String tipoOra = null;
            boolean findTipoOra = false;
            for (int j = 0; j < childsRiscontro.size(); ++j) {
                Eccezione ecc;
                Eccezione ecc2;
                Node elem = (Node)childsRiscontro.get(j);
                if (SoapUtils.matchLocalName((Node)elem, (String)"Identificatore", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaIdentificatore) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento RiscontroIdentificatore", "RiscontroIdentificatore");
                        }
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_IDENTIFICATORE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_IDENTIFICATORE.toString());
                        }
                        this.erroriValidazione.add(ecc2);
                        continue;
                    }
                    presenzaIdentificatore = true;
                    try {
                        id = ((Node)SoapUtils.getNotEmptyChildNodes((Node)elem).get(0)).getNodeValue();
                        findID = true;
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_IDENTIFICATORE.toString());
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"OraRegistrazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaOraRegistrazione) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento RiscontroOraRegistrazione", "RiscontroOraRegistrazione");
                        }
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE.toString());
                        }
                        this.erroriValidazione.add(ecc2);
                        continue;
                    }
                    presenzaOraRegistrazione = true;
                    try {
                        ora = ((Node)SoapUtils.getNotEmptyChildNodes((Node)elem).get(0)).getNodeValue();
                        findOra = true;
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE.toString());
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    oraDate = null;
                    if (ora != null) {
                        oraDate = this.validazioneData(ora);
                    }
                    if (ora == null || oraDate == null) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        Node hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)elem, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)elem, (String)"tempo");
                        tipoOra = hrefFind.getNodeValue();
                        findTipoOra = true;
                    }
                    catch (Exception e) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov senza RiscontroOraRegistrazioneTempo", "RiscontroOraRegistrazioneTempo");
                        }
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE_TEMPO.toString());
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    if (tipoOra == null || tipoOra.equals("EGOV_IT_Locale") || tipoOra.equals("EGOV_IT_SPC")) continue;
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc2);
                    errorFind = true;
                    continue;
                }
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.LISTA_RISCONTRI_NON_VALIDA);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO + "/child[" + elem.getNodeName() + "]");
                this.erroriValidazione.add(ecc2);
                errorFind = true;
            }
            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                if (!presenzaIdentificatore) {
                    throw new StrutturaBustaException("Header egov senza RiscontroIdentificatore", "RiscontroIdentificatore");
                }
                if (!presenzaOraRegistrazione) {
                    throw new StrutturaBustaException("Header egov senza RiscontroOraRegistrazione", "RiscontroOraRegistrazione");
                }
            }
            if (!errorFind) {
                if (!findID) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_IDENTIFICATORE.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (!findOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE.toString());
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc);
                }
            }
            if (id == null && ora == null && tipoOra == null) continue;
            Riscontro r = new Riscontro();
            r.setID(id);
            r.setOraRegistrazione(oraDate);
            r.setTipoOraRegistrazioneValue(tipoOra);
            r.setTipoOraRegistrazione(this.traduttore.toTipoOraRegistrazione(tipoOra));
            this.busta.addRiscontro(r);
        }
    }

    private void validazioneListaTrasmissioni(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        Vector trasmissioni = SoapUtils.getNotEmptyChildNodes((Node)child);
        if (trasmissioni.size() <= 0) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.LISTA_TRASMISSIONI_NON_VALORIZZATA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE.toString());
            this.erroriValidazione.add(ecc);
            return;
        }
        for (int i = 0; i < trasmissioni.size(); ++i) {
            boolean errorFind = false;
            Node trasmissione = (Node)trasmissioni.get(i);
            if (!SoapUtils.matchLocalName((Node)trasmissione, (String)"Trasmissione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_NON_PRESENTE);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE + "/child[" + trasmissione.getNodeName() + "]");
                this.erroriValidazione.add(ecc);
                continue;
            }
            Vector childsTrasmissione = SoapUtils.getNotEmptyChildNodes((Node)trasmissione);
            boolean presenzaOrigine = false;
            boolean presenzaDestinazione = false;
            boolean presenzaOraRegistrazione = false;
            String origine = null;
            String tipoOrigine = null;
            String indTelematicoOrigine = null;
            boolean findOrigine = false;
            boolean findTipoOrigine = false;
            String destinazione = null;
            String tipoDestinazione = null;
            String indTelematicoDestinazione = null;
            boolean findDestinazione = false;
            boolean findTipoDestinazione = false;
            String ora = null;
            Date oraDate = null;
            boolean findOra = false;
            String tipoOra = null;
            boolean findTipoOra = false;
            for (int j = 0; j < childsTrasmissione.size(); ++j) {
                Eccezione ecc;
                URL urlcheck;
                Node hrefFindT;
                Node hrefFind;
                Eccezione ecc2;
                Vector valueIDParte;
                Node idParte;
                Eccezione ecc3;
                Node elem = (Node)childsTrasmissione.get(j);
                if (SoapUtils.matchLocalName((Node)elem, (String)"Origine", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaOrigine) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento TrasmissioneOrigine", "TrasmissioneOrigine");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_PRESENTE_PIU_VOLTE);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE.toString());
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaOrigine = true;
                    if (SoapUtils.getNotEmptyChildNodes((Node)elem).size() != 1) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_NON_PRESENTE);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        if (SoapUtils.getNotEmptyChildNodes((Node)elem).size() < 1) {
                            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                                throw new StrutturaBustaException("Header egov senza TrasmissioneOrigine IdentificativoParte", "TrasmissioneOrigineIdentificativoParte");
                            }
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE.toString());
                        } else if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE.toString());
                        }
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                        continue;
                    }
                    idParte = (Node)SoapUtils.getNotEmptyChildNodes((Node)elem).get(0);
                    try {
                        valueIDParte = SoapUtils.getNotEmptyChildNodes((Node)idParte);
                        origine = ((Node)valueIDParte.get(0)).getNodeValue();
                        findOrigine = true;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
                        tipoOrigine = hrefFind.getNodeValue();
                        if (tipoOrigine == null) {
                            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                                if (!findTipoOrigine) {
                                    throw new StrutturaBustaException("Header egov senza TrasmissioneOrigine IdentificativoParteTipo", "TrasmissioneOrigineIdentificativoParteTipo");
                                }
                            } else {
                                throw new Exception("Tipo non definito");
                            }
                        }
                        if (!this.tipiSoggetti.contains(tipoOrigine)) {
                            throw new Exception("Tipo non valido");
                        }
                        findTipoOrigine = true;
                    }
                    catch (StrutturaBustaException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_TIPO.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFindT = null;
                        hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
                        if (hrefFindT != null) {
                            indTelematicoOrigine = hrefFindT.getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    if (errorFind || indTelematicoOrigine == null || indTelematicoOrigine.equals("")) continue;
                    urlcheck = null;
                    try {
                        urlcheck = new URL(indTelematicoOrigine);
                        indTelematicoOrigine = urlcheck.toString();
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"Destinazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    if (presenzaDestinazione) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento TrasmissioneDestinazione", "TrasmissioneDestinazione");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_PRESENTE_PIU_VOLTE);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE.toString());
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaDestinazione = true;
                    if (SoapUtils.getNotEmptyChildNodes((Node)elem).size() != 1) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_NON_VALIDA);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        if (SoapUtils.getNotEmptyChildNodes((Node)elem).size() < 1) {
                            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                                throw new StrutturaBustaException("Header egov senza TrasmissioneDestinazione IdentificativoParte", "TrasmissioneDestinazioneIdentificativoParte");
                            }
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE.toString());
                        } else if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE.toString());
                        }
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                        continue;
                    }
                    idParte = (Node)SoapUtils.getNotEmptyChildNodes((Node)elem).get(0);
                    try {
                        valueIDParte = SoapUtils.getNotEmptyChildNodes((Node)idParte);
                        destinazione = ((Node)valueIDParte.get(0)).getNodeValue();
                        findDestinazione = true;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFind = null;
                        hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"tipo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"tipo");
                        tipoDestinazione = hrefFind.getNodeValue();
                        if (tipoDestinazione == null) {
                            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                                if (!findTipoOrigine) {
                                    throw new StrutturaBustaException("Header egov senza TrasmissioneDestinazione IdentificativoParteTipo", "TrasmissioneDestinazioneIdentificativoParteTipo");
                                }
                            } else {
                                throw new Exception("Tipo non definito");
                            }
                        }
                        if (!this.tipiSoggetti.contains(tipoDestinazione)) {
                            throw new Exception("Tipo non valido");
                        }
                        findTipoDestinazione = true;
                    }
                    catch (StrutturaBustaException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    try {
                        hrefFindT = null;
                        hrefFindT = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)idParte, (String)"indirizzoTelematico", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)idParte, (String)"indirizzoTelematico");
                        if (hrefFindT != null) {
                            indTelematicoDestinazione = hrefFindT.getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        ecc2 = new Eccezione();
                        ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc2.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA);
                        ecc2.setRilevanza(LivelloRilevanza.ERROR);
                        ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                        this.erroriValidazione.add(ecc2);
                        errorFind = true;
                    }
                    if (errorFind || indTelematicoDestinazione == null || indTelematicoDestinazione.equals("")) continue;
                    urlcheck = null;
                    try {
                        urlcheck = new URL(indTelematicoDestinazione);
                        indTelematicoDestinazione = urlcheck.toString();
                    }
                    catch (Exception e) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_IND_TELEMATICO.toString());
                        this.erroriValidazione.add(ecc);
                        errorFind = true;
                    }
                    continue;
                }
                if (SoapUtils.matchLocalName((Node)elem, (String)"OraRegistrazione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc4;
                    if (presenzaOraRegistrazione) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            throw new StrutturaBustaException("Header egov con pi\u00f9 di un elemento TrasmissioneOraRegistrazione", "TrasmissioneOraRegistrazione");
                        }
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        if (this.segnalazioneElementoPresentePiuVolte) {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE + " elemento presente pi\u00f9 volte nell'header");
                        } else {
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
                        }
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    presenzaOraRegistrazione = true;
                    try {
                        ora = ((Node)SoapUtils.getNotEmptyChildNodes((Node)elem).get(0)).getNodeValue();
                        findOra = true;
                    }
                    catch (Exception e) {
                        ecc4 = new Eccezione();
                        ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc4.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA);
                        ecc4.setRilevanza(LivelloRilevanza.ERROR);
                        ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
                        this.erroriValidazione.add(ecc4);
                        errorFind = true;
                    }
                    oraDate = null;
                    if (ora != null) {
                        oraDate = this.validazioneData(ora);
                    }
                    if (ora == null || oraDate == null) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
                        this.erroriValidazione.add(ecc3);
                        errorFind = true;
                    }
                    try {
                        Node hrefFind2 = null;
                        hrefFind2 = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)elem, (String)"tempo", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)elem, (String)"tempo");
                        tipoOra = hrefFind2.getNodeValue();
                        findTipoOra = true;
                    }
                    catch (Exception e) {
                        if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                            if (!findTipoOrigine) {
                                throw new StrutturaBustaException("Header egov senza Trasmissione OraRegistrazioneTempo", "TrasmissioneOraRegistrazioneTempo");
                            }
                        }
                        ecc4 = new Eccezione();
                        ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc4.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA);
                        ecc4.setRilevanza(LivelloRilevanza.ERROR);
                        ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE_TEMPO.toString());
                        this.erroriValidazione.add(ecc4);
                        errorFind = true;
                    }
                    if (tipoOra == null || tipoOra.equals("EGOV_IT_Locale") || tipoOra.equals("EGOV_IT_SPC")) continue;
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc3);
                    errorFind = true;
                    continue;
                }
                ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.LISTA_TRASMISSIONI_NON_VALIDA);
                ecc3.setRilevanza(LivelloRilevanza.ERROR);
                ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE + "/child[" + elem.getNodeName() + "]");
                this.erroriValidazione.add(ecc3);
                errorFind = true;
            }
            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                if (!presenzaOrigine) {
                    throw new StrutturaBustaException("Header egov senza TrasmissioneOrigine", "TrasmissioneOrigine");
                }
                if (!presenzaDestinazione) {
                    throw new StrutturaBustaException("Header egov senza TrasmissioneDestinazione", "TrasmissioneDestinazione");
                }
                if (!presenzaOraRegistrazione) {
                    throw new StrutturaBustaException("Header egov senza TrasmissioneOraRegistrazione", "TrasmissioneOraRegistrazione");
                }
            }
            if (!errorFind) {
                if (!presenzaOrigine) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (!presenzaDestinazione) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (!presenzaOraRegistrazione) {
                    errorFind = true;
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
                    this.erroriValidazione.add(ecc);
                }
            }
            if (!errorFind) {
                if (!findOrigine) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORIGINE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE.toString());
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOrigine) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORIGINE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORIGINE_IDENTIFICATIVO_PARTE_TIPO.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (!findDestinazione) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_DESTINAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE.toString());
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoDestinazione) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_DESTINAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_DESTINAZIONE_IDENTIFICATIVO_PARTE_TIPO.toString());
                    this.erroriValidazione.add(ecc);
                }
                if (!findOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
                    this.erroriValidazione.add(ecc);
                } else if (!findTipoOra) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE_TEMPO.toString());
                    this.erroriValidazione.add(ecc);
                }
            }
            if (origine == null && tipoOrigine == null && tipoDestinazione == null && destinazione == null && ora == null && tipoOra == null) continue;
            Trasmissione tr = new Trasmissione();
            tr.setOrigine(origine);
            tr.setTipoOrigine(tipoOrigine);
            tr.setIndirizzoOrigine(indTelematicoOrigine);
            tr.setDestinazione(destinazione);
            tr.setTipoDestinazione(tipoDestinazione);
            tr.setIndirizzoDestinazione(indTelematicoDestinazione);
            tr.setOraRegistrazione(oraDate);
            tr.setTempoValue(tipoOra);
            tr.setTempo(this.traduttore.toTipoOraRegistrazione(tipoOra));
            this.busta.addTrasmissione(tr);
        }
    }

    private void validazioneListaEccezioni(Node child, String prefix) throws StrutturaBustaException, ProtocolException {
        Vector eccezioni = SoapUtils.getNotEmptyChildNodes((Node)child);
        for (int i = 0; i < eccezioni.size(); ++i) {
            Eccezione ecc;
            boolean errorFind = false;
            Node eccezione = (Node)eccezioni.get(i);
            if (!SoapUtils.matchLocalName((Node)eccezione, (String)"Eccezione", (String)prefix, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc2 = new Eccezione();
                ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc2.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                ecc2.setRilevanza(LivelloRilevanza.ERROR);
                ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE + "/child[" + eccezione.getNodeName() + "]");
                this.errorsTrovatiSullaListaEccezioni.add(ecc2);
                errorFind = true;
            }
            String contestoCodifica = null;
            String codiceEccezione = null;
            String rilevanza = null;
            String posizione = null;
            boolean contestoCodificaError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"contestoCodifica", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"contestoCodifica");
                contestoCodifica = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                contestoCodificaError = true;
            }
            if (contestoCodifica == null) {
                contestoCodificaError = true;
            }
            if (contestoCodificaError) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc3.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                ecc3.setRilevanza(LivelloRilevanza.ERROR);
                ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_CONTESTO_CODIFICA.toString());
                this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                errorFind = true;
            }
            boolean codiceEccezioneError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"codiceEccezione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"codiceEccezione");
                codiceEccezione = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                codiceEccezioneError = true;
            }
            if (!this.validazioneCodiceEccezione(codiceEccezione)) {
                codiceEccezioneError = true;
            }
            if (codiceEccezioneError) {
                Eccezione ecc4 = new Eccezione();
                ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc4.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                ecc4.setRilevanza(LivelloRilevanza.ERROR);
                ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_CODICE_ECCEZIONE.toString());
                this.errorsTrovatiSullaListaEccezioni.add(ecc4);
                errorFind = true;
            }
            boolean rilevanzaError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"rilevanza", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"rilevanza");
                rilevanza = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                rilevanzaError = true;
            }
            LivelloRilevanza livRilevanza = this.validazioneRilevanza(rilevanza);
            if (livRilevanza.equals(LivelloRilevanza.UNKNOWN)) {
                rilevanzaError = true;
            }
            if (rilevanzaError) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc5.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                ecc5.setRilevanza(LivelloRilevanza.ERROR);
                ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_RILEVANZA.toString());
                this.errorsTrovatiSullaListaEccezioni.add(ecc5);
                errorFind = true;
            }
            boolean posizioneError = false;
            try {
                Node hrefFind = null;
                hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)eccezione, (String)"posizione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)eccezione, (String)"posizione");
                posizione = hrefFind.getNodeValue();
            }
            catch (Exception e) {
                posizioneError = true;
            }
            if (posizione == null) {
                posizioneError = true;
            }
            if (posizioneError) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_POSIZIONE.toString());
                this.errorsTrovatiSullaListaEccezioni.add(ecc);
                errorFind = true;
            }
            if (!this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo()) {
                if (contestoCodifica == null) {
                    throw new StrutturaBustaException("Header egov senza Eccezione contestoCodifica", "EccezioneContestoCodifica");
                }
                if (codiceEccezione == null) {
                    throw new StrutturaBustaException("Header egov senza Eccezione codiceEccezione", "EccezioneCodiceEccezione");
                }
                if (rilevanza == null) {
                    throw new StrutturaBustaException("Header egov senza Eccezione rilevanza", "EccezioneRilevanza");
                }
                if (posizione == null) {
                    throw new StrutturaBustaException("Header egov senza Eccezione posizione", "EccezionePosizione");
                }
            }
            if (!errorFind) {
                if (contestoCodifica == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_CONTESTO_CODIFICA.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (codiceEccezione == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_CODICE_ECCEZIONE.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (rilevanza == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_RILEVANZA.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
                if (posizione == null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_POSIZIONE.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                }
            }
            if (contestoCodifica == null || codiceEccezione == null || rilevanza == null || posizione == null) continue;
            Eccezione eccLetta = new Eccezione();
            eccLetta.setContestoCodificaValue(contestoCodifica);
            eccLetta.setContestoCodifica(this.traduttore.toContestoCodificaEccezione(contestoCodifica));
            eccLetta.setCodiceEccezioneValue(codiceEccezione);
            eccLetta.setCodiceEccezione(this.traduttore.toCodiceErroreCooperazione(codiceEccezione));
            eccLetta.setRilevanza(livRilevanza);
            eccLetta.setRilevanzaValue(rilevanza);
            eccLetta.setDescrizione(posizione);
            this.busta.addEccezione(eccLetta);
        }
    }

    private LivelloRilevanza validazioneRilevanza(String codice) throws ProtocolException {
        return this.traduttore.toLivelloRilevanza(codice);
    }

    public boolean validazioneCodiceEccezione(CodiceErroreCooperazione codice) {
        String v = this.traduttore.toString(codice);
        return v != null;
    }

    public boolean validazioneCodiceEccezione(String codicetxt) throws ProtocolException {
        CodiceErroreCooperazione codice = CodiceErroreCooperazione.toCodiceErroreCooperazione((IProtocolFactory)this.protocolFactory, (String)codicetxt);
        return this.validazioneCodiceEccezione(codice);
    }

    public void validazioneFaultEGov(SOAPBody body) {
        try {
            if (!body.hasFault()) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT.toString());
                this.errorsTrovatiSullaListaEccezioni.add(ecc);
            } else {
                Eccezione ecc;
                Name codeS;
                SOAPFault fault = body.getFault();
                boolean valoriOK = true;
                String faultS = fault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (!"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS) && !"EGOV_IT_001 - Formato Busta non corretto".equals(faultS)) {
                    Eccezione ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT_STRING.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc2);
                    valoriOK = false;
                }
                if ((codeS = fault.getFaultCodeAsName()) == null || !"Client".equals(codeS.getLocalName()) && !"Server".equals(codeS.getLocalName()) || !"http://schemas.xmlsoap.org/soap/envelope/".equalsIgnoreCase(codeS.getURI())) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT_CODE.toString());
                    this.errorsTrovatiSullaListaEccezioni.add(ecc);
                    valoriOK = false;
                }
                if (valoriOK) {
                    if ("Client".equals(codeS.getLocalName())) {
                        Eccezione ecc3;
                        boolean detailPresente = false;
                        Detail d = fault.getDetail();
                        if (d != null && d.getDetailEntries().hasNext()) {
                            detailPresente = true;
                        }
                        if (!"EGOV_IT_001 - Formato Busta non corretto".equals(faultS)) {
                            ecc3 = new Eccezione();
                            ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                            ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                            ecc3.setRilevanza(LivelloRilevanza.ERROR);
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT_STRING.toString());
                            this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                        }
                        if (detailPresente) {
                            ecc3 = new Eccezione();
                            ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                            ecc3.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                            ecc3.setRilevanza(LivelloRilevanza.ERROR);
                            ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT_DETAILS_PRESENTI.toString());
                            this.errorsTrovatiSullaListaEccezioni.add(ecc3);
                        }
                    }
                    if ("Server".equals(codeS.getLocalName()) && !"EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        ecc = new Eccezione();
                        ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                        ecc.setRilevanza(LivelloRilevanza.ERROR);
                        ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_ECCEZIONI_NON_VALIDA_POSIZIONE_SOAP_FAULT_STRING.toString());
                        this.errorsTrovatiSullaListaEccezioni.add(ecc);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante la validazione del SoapFault", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Validazione SoapFault: errore di processamento");
            this.erroriProcessamento.add(ecc);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validazioneManifestAttachmentsEGov(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) {
        SOAPBody soapBody = null;
        try {
            Vector<String> contentID = new Vector<String>();
            Vector<String> contentLocation = new Vector<String>();
            Iterator it = msg.getAttachments();
            while (it.hasNext()) {
                AttachmentPart ap = (AttachmentPart)it.next();
                contentID.add(ap.getContentId());
                contentLocation.add(ap.getContentLocation());
            }
            boolean isRichiesta = false;
            boolean isRisposta = false;
            soapBody = msg.getSOAPBody();
            Vector soapBodyList = SoapUtils.getNotEmptyChildNodes((Node)soapBody);
            if (soapBodyList.size() != 1) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE + " child size:" + soapBodyList.size());
                this.erroriValidazione.add(ecc);
                return;
            }
            Node descrizione = (Node)soapBodyList.get(0);
            Object prefixManifest = descrizione.getPrefix();
            if (prefixManifest == null) {
                prefixManifest = "";
            }
            if (!"".equals(prefixManifest)) {
                prefixManifest = (String)prefixManifest + ":";
            }
            if (!SoapUtils.matchLocalName((Node)descrizione, (String)"Descrizione", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE.toString());
                this.erroriValidazione.add(ecc);
                return;
            }
            if (!"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/".equals(descrizione.getNamespaceURI())) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_NAMESPACE.toString());
                this.erroriValidazione.add(ecc);
                return;
            }
            Vector descrizioneMessaggi = SoapUtils.getNotEmptyChildNodes((Node)descrizione);
            if (descrizioneMessaggi.size() <= 0) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE + " child size:" + descrizioneMessaggi.size());
                this.erroriValidazione.add(ecc);
                return;
            }
            for (int i = 0; i < descrizioneMessaggi.size(); ++i) {
                Eccezione ecc;
                Eccezione ecc2;
                Eccezione ecc3;
                Node descrizioneMessaggio = (Node)descrizioneMessaggi.get(i);
                if (!SoapUtils.matchLocalName((Node)descrizioneMessaggio, (String)"DescrizioneMessaggio", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc4 = new Eccezione();
                    ecc4.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc4.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc4.setRilevanza(LivelloRilevanza.ERROR);
                    ecc4.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE + "/child[" + descrizioneMessaggio.getNodeName() + "]");
                    this.erroriValidazione.add(ecc4);
                    continue;
                }
                Vector riferimentoList = SoapUtils.getNotEmptyChildNodes((Node)descrizioneMessaggio);
                if (riferimentoList.size() != 1) {
                    Eccezione ecc5 = new Eccezione();
                    ecc5.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc5.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc5.setRilevanza(LivelloRilevanza.ERROR);
                    ecc5.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO + " child size:" + riferimentoList.size());
                    this.erroriValidazione.add(ecc5);
                    continue;
                }
                Node riferimento = (Node)riferimentoList.get(0);
                if (!SoapUtils.matchLocalName((Node)riferimento, (String)"Riferimento", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    Eccezione ecc6 = new Eccezione();
                    ecc6.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc6.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_PRESENTE);
                    ecc6.setRilevanza(LivelloRilevanza.ERROR);
                    ecc6.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO + "/child[" + riferimento.getNodeName() + "]");
                    this.erroriValidazione.add(ecc6);
                    continue;
                }
                String href = null;
                boolean hrefError = false;
                try {
                    Node hrefFind = null;
                    hrefFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"href", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)riferimento, (String)"href");
                    href = hrefFind.getNodeValue();
                }
                catch (Exception e) {
                    hrefError = true;
                }
                if (href == null) {
                    hrefError = true;
                }
                if (hrefError) {
                    Eccezione ecc7 = new Eccezione();
                    ecc7.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc7.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_VALIDO);
                    ecc7.setRilevanza(LivelloRilevanza.ERROR);
                    ecc7.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_HREF.toString());
                    this.erroriValidazione.add(ecc7);
                    continue;
                }
                boolean findHRef = false;
                for (int k = 0; k < contentID.size(); ++k) {
                    if (href.equals(contentID.get(k)) || href.equals("cid:" + (String)contentID.get(k)) || href.equals(contentLocation.get(k))) {
                        contentID.remove(k);
                        contentLocation.remove(k);
                        findHRef = true;
                        break;
                    }
                    Object hrefNew = new String(href);
                    String cidPref = "";
                    if (((String)hrefNew).startsWith("cid:")) {
                        hrefNew = ((String)hrefNew).substring("cid:".length());
                        cidPref = "cid:";
                    }
                    if (!((String)hrefNew).startsWith("<")) {
                        hrefNew = "<" + (String)hrefNew;
                    }
                    if (!((String)hrefNew).endsWith(">")) {
                        hrefNew = (String)hrefNew + ">";
                    }
                    if (((String)(hrefNew = cidPref + (String)hrefNew)).equals(href) || !((String)hrefNew).equals(contentID.get(k)) && !((String)hrefNew).equals("cid:" + (String)contentID.get(k))) continue;
                    contentID.remove(k);
                    contentLocation.remove(k);
                    findHRef = true;
                    break;
                }
                if (!findHRef) {
                    Eccezione ecc8 = new Eccezione();
                    ecc8.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc8.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATO_NON_PRESENTE);
                    ecc8.setRilevanza(LivelloRilevanza.ERROR);
                    ecc8.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_HREF + "[" + href + "]");
                    this.erroriValidazione.add(ecc8);
                }
                String role = null;
                boolean roleError = false;
                try {
                    Node roleFind = null;
                    roleFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"role", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)riferimento, (String)"role");
                    role = roleFind.getNodeValue();
                }
                catch (Exception e) {
                    roleError = true;
                }
                if (role == null) {
                    roleError = true;
                }
                if (roleError) {
                    ecc3 = new Eccezione();
                    ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc3.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc3.setRilevanza(LivelloRilevanza.ERROR);
                    ecc3.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_ROLE.toString());
                    this.erroriValidazione.add(ecc3);
                    continue;
                }
                if (this.spcoopProperties.getRoleRichiestaManifest().equalsIgnoreCase(role) || this.spcoopProperties.getRoleRispostaManifest().equalsIgnoreCase(role)) {
                    if (isRichiesta || isRisposta) {
                        ecc3 = new Eccezione();
                        ecc3.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                        ecc3.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_VALIDO);
                        ecc3.setRilevanza(LivelloRilevanza.ERROR);
                        String posizioneErrore = SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_ROLE_PRINCIPALE_DUPLICATO.toString();
                        posizioneErrore = posizioneErrore.replace("@RICHIESTA@", this.spcoopProperties.getRoleRichiestaManifest());
                        posizioneErrore = posizioneErrore.replace("@RISPOSTA@", this.spcoopProperties.getRoleRispostaManifest());
                        ecc3.setDescrizione(posizioneErrore);
                        this.erroriValidazione.add(ecc3);
                        continue;
                    }
                    if (this.spcoopProperties.getRoleRichiestaManifest().equalsIgnoreCase(role)) {
                        isRichiesta = true;
                    } else {
                        isRisposta = true;
                    }
                }
                String id = null;
                boolean idError = false;
                try {
                    Node idFind = SoapUtils.getQualifiedAttributeNode((Node)riferimento, (String)"id", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    id = idFind.getNodeValue();
                }
                catch (Exception e) {
                    idError = true;
                }
                if (id == null) {
                    idError = true;
                }
                if (idError) {
                    Eccezione ecc9 = new Eccezione();
                    ecc9.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc9.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc9.setRilevanza(LivelloRilevanza.ERROR);
                    ecc9.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_ID.toString());
                    this.erroriValidazione.add(ecc9);
                    continue;
                }
                Vector elementiRiferimento = SoapUtils.getNotEmptyChildNodes((Node)riferimento);
                if (elementiRiferimento.size() != 2) {
                    Eccezione ecc10 = new Eccezione();
                    ecc10.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc10.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc10.setRilevanza(LivelloRilevanza.ERROR);
                    ecc10.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO + " child size:" + elementiRiferimento.size());
                    this.erroriValidazione.add(ecc10);
                    continue;
                }
                Node child = (Node)elementiRiferimento.get(0);
                Node schema = null;
                Node titolo = null;
                if (SoapUtils.matchLocalName((Node)child, (String)"Schema", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    schema = child;
                    titolo = (Node)elementiRiferimento.get(1);
                } else if (SoapUtils.matchLocalName((Node)child, (String)"Titolo", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    titolo = child;
                    schema = (Node)elementiRiferimento.get(1);
                } else {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO + "/child[" + child.getNodeName() + "]");
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                if (!SoapUtils.matchLocalName((Node)schema, (String)"Schema", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc2.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc2.setRilevanza(LivelloRilevanza.ERROR);
                    ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_SCHEMA.toString());
                    this.erroriValidazione.add(ecc2);
                    continue;
                }
                String posizione = null;
                boolean posizioneError = false;
                try {
                    Node posizioneFind = null;
                    posizioneFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)schema, (String)"posizione", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)schema, (String)"posizione");
                    posizione = posizioneFind.getNodeValue();
                }
                catch (Exception e) {
                    posizioneError = true;
                }
                if (posizione == null) {
                    posizioneError = true;
                }
                if (posizioneError) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_SCHEMA_POSIZIONE.toString());
                    this.erroriValidazione.add(ecc);
                    continue;
                }
                if (!SoapUtils.matchLocalName((Node)titolo, (String)"Titolo", (String)prefixManifest, (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/")) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc.setRilevanza(LivelloRilevanza.ERROR);
                    ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_TITOLO.toString());
                    this.erroriValidazione.add(ecc);
                    continue;
                }
                String Lingua = null;
                try {
                    Node LinguaFind = null;
                    LinguaFind = this.readQualifiedAttribute ? SoapUtils.getQualifiedAttributeNode((Node)titolo, (String)"Lingua", (String)"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/") : SoapUtils.getAttributeNode((Node)titolo, (String)"Lingua");
                    Lingua = LinguaFind.getNodeValue();
                }
                catch (Exception LinguaFind) {
                    // empty catch block
                }
                if (Lingua == null) {
                    Lingua = "it";
                }
                String valoreTitolo = null;
                try {
                    valoreTitolo = ((Node)SoapUtils.getNotEmptyChildNodes((Node)titolo).get(0)).getNodeValue();
                    if (valoreTitolo != null) continue;
                    throw new Exception("valore non presente");
                }
                catch (Exception e) {
                    Eccezione ecc11 = new Eccezione();
                    ecc11.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                    ecc11.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI);
                    ecc11.setRilevanza(LivelloRilevanza.ERROR);
                    ecc11.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_TITOLO.toString());
                    this.erroriValidazione.add(ecc11);
                }
            }
            if (!isRichiesta && !isRisposta) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                String posizioneErrore = SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_ROLE_PRINCIPALE_ASSENTE.toString();
                posizioneErrore = posizioneErrore.replace("@RICHIESTA@", this.spcoopProperties.getRoleRichiestaManifest());
                posizioneErrore = posizioneErrore.replace("@RISPOSTA@", this.spcoopProperties.getRoleRispostaManifest());
                ecc.setDescrizione(posizioneErrore);
                this.erroriValidazione.add(ecc);
                return;
            }
            while (contentID.size() > 0) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ALLEGATO_NON_DEFINITO_MANIFEST);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                String href = (String)contentID.remove(0);
                if (href == null) {
                    href = (String)contentLocation.remove(0);
                } else {
                    contentLocation.remove(0);
                }
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_MANIFEST_POSIZIONE_DESCRIZIONE_DESCRIZIONE_MESSAGGIO_RIFERIMENTO_HREF + "[" + href + "] non presente");
                this.erroriValidazione.add(ecc);
            }
            return;
        }
        catch (Exception e) {
            this.log.error("Errore durante la validazione del Manifest degli attachments", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Manifest degli attachments: errore di processamento");
            this.erroriProcessamento.add(ecc);
            return;
        }
        finally {
            soapBody = null;
        }
    }

    private Date validazioneData(String aDate) {
        try {
            Integer test;
            String[] split = aDate.split("T");
            if (split == null) {
                return null;
            }
            if (split.length != 2) {
                return null;
            }
            String[] date = split[0].split("-");
            if (date == null) {
                return null;
            }
            if (date.length != 3) {
                return null;
            }
            if (date[0].length() != 4) {
                return null;
            }
            try {
                Integer test2 = Integer.valueOf(date[0]);
                if (test2 > 2100) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            if (date[1].length() != 2) {
                return null;
            }
            if (date[2].length() != 2) {
                return null;
            }
            try {
                Integer mese = Integer.valueOf(date[1]);
                if (mese > 12 || mese < 0) {
                    return null;
                }
                Integer giorno = Integer.valueOf(date[2]);
                if (giorno < 0) {
                    return null;
                }
                if (giorno > 29 && mese == 2) {
                    return null;
                }
                if (giorno > 30 && (mese == 4 || mese == 6 || mese == 9 || mese == 11)) {
                    return null;
                }
                if (giorno > 31) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            String[] ora = split[1].split(":");
            if (ora == null) {
                return null;
            }
            if (ora.length < 3) {
                return null;
            }
            if (ora[0].length() != 2) {
                return null;
            }
            try {
                test = Integer.valueOf(ora[0]);
                if (test > 23 || test < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            if (ora[1].length() != 2) {
                return null;
            }
            try {
                test = Integer.valueOf(ora[1]);
                if (test > 59 || test < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            String secondi = null;
            if (ora[2].length() < 2) {
                return null;
            }
            try {
                secondi = "" + ora[2].charAt(0) + ora[2].charAt(1);
                Integer test3 = Integer.valueOf(secondi);
                if (test3 > 59 || test3 < 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            GregorianCalendar calendar = null;
            try {
                calendar = new GregorianCalendar(Integer.valueOf(date[0]), Integer.valueOf(date[1]) - 1, Integer.valueOf(date[2]), Integer.valueOf(ora[0]), Integer.valueOf(ora[1]), Integer.valueOf(secondi));
            }
            catch (Exception e) {
                return null;
            }
            long value = calendar.getTime().getTime();
            return new Date(value);
        }
        catch (Exception error) {
            return null;
        }
    }

    private boolean dataScaduta(String scadenza) {
        Date now = DateManager.getDate();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy MM dd HH mm ss");
        String nowFormat = dateformat.format(now);
        String scadenzaFormat = scadenza.replace('-', ' ').replace(':', ' ').replace('T', ' ');
        String[] splitNow = nowFormat.split(" ");
        String[] splitScadenza = scadenzaFormat.split(" ");
        if (this.validazioneData(scadenza) == null) {
            return false;
        }
        try {
            Integer testNowAnno = Integer.valueOf(splitNow[0]);
            Integer testScadenzaAnno = Integer.valueOf(splitScadenza[0]);
            Integer testNowMese = Integer.valueOf(splitNow[1]);
            Integer testScadenzaMese = Integer.valueOf(splitScadenza[1]);
            Integer testNowGiorno = Integer.valueOf(splitNow[2]);
            Integer testScadenzaGiorno = Integer.valueOf(splitScadenza[2]);
            Integer testNowOra = Integer.valueOf(splitNow[3]);
            Integer testScadenzaOra = Integer.valueOf(splitScadenza[3]);
            Integer testNowMinuti = Integer.valueOf(splitNow[4]);
            Integer testScadenzaMinuti = Integer.valueOf(splitScadenza[4]);
            Integer testNowSecondi = Integer.valueOf(splitNow[5]);
            Integer testScadenzaSecondi = splitScadenza[5].charAt(0) + splitScadenza[5].charAt(1);
            if (testNowAnno > testScadenzaAnno) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese > testScadenzaMese) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno > testScadenzaGiorno) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra > testScadenzaOra) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra.intValue() == testScadenzaOra.intValue() && testNowMinuti > testScadenzaMinuti) {
                return true;
            }
            if (testNowAnno.intValue() == testScadenzaAnno.intValue() && testNowMese.intValue() == testScadenzaMese.intValue() && testNowGiorno.intValue() == testScadenzaGiorno.intValue() && testNowOra.intValue() == testScadenzaOra.intValue() && testNowMinuti.intValue() == testScadenzaMinuti.intValue() && testNowSecondi > testScadenzaSecondi) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private void validazioneDatePresentiRispettoDateFuture() throws ProtocolException {
        int i;
        Eccezione ecc;
        String[] split;
        int intervalloTolleranza = this.spcoopProperties.getIntervalloMinutiTolleranzaDateFuture();
        Date sistema = DateManager.getDate();
        Date dataFuturaMassimaAccettata = new Date(sistema.getTime() + (long)(intervalloTolleranza * 60 * 1000));
        if (this.busta.getOraRegistrazione() != null && this.busta.getOraRegistrazione().after(dataFuturaMassimaAccettata)) {
            this.log.error("Data portata nell'ora di registrazione [" + SPCoopUtils.getDate_eGovFormat(this.busta.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + SPCoopUtils.getDate_eGovFormat(sistema) + ") e l'intervallo di tolleranza impostato a " + intervalloTolleranza + " minuti");
            Eccezione ecc2 = new Eccezione();
            ecc2.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc2.setCodiceEccezione(CodiceErroreCooperazione.ORA_REGISTRAZIONE_NON_VALIDA);
            ecc2.setRilevanza(LivelloRilevanza.ERROR);
            ecc2.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ORA_REGISTRAZIONE_NON_VALIDA_POSIZIONE.toString());
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getID() != null && (split = this.busta.getID().split("_")) != null && split.length == 5) {
            Date dataIntoIDEgov = null;
            try {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
                dataIntoIDEgov = dateformat.parse(split[3] + "_" + split[4]);
            }
            catch (Exception dateformat) {
                // empty catch block
            }
            if (dataIntoIDEgov != null && dataIntoIDEgov.after(dataFuturaMassimaAccettata)) {
                this.log.error("Data portata nell'identificativo egov [" + this.busta.getID() + "][" + SPCoopUtils.getDate_eGovFormat(dataIntoIDEgov) + "] futura rispetto all'ora attuale di sistema (" + SPCoopUtils.getDate_eGovFormat(sistema) + ") e l'intervallo di tolleranza impostato a " + intervalloTolleranza + " minuti");
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_VALIDO_POSIZIONE.toString());
                this.erroriValidazione.add(ecc);
            }
        }
        for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
            Riscontro riscontro = this.busta.getRiscontro(i);
            if (riscontro.getOraRegistrazione() == null || !riscontro.getOraRegistrazione().after(dataFuturaMassimaAccettata)) continue;
            this.log.error("Data portata nell'ora di registrazione del riscontro con id [" + riscontro.getID() + "] [" + SPCoopUtils.getDate_eGovFormat(riscontro.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + SPCoopUtils.getDate_eGovFormat(sistema) + ") e l'intervallo di tolleranza impostato a " + intervalloTolleranza + " minuti");
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_RISCONTRI_NON_VALIDA_POSIZIONE_RISCONTRO_ORA_REGISTRAZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
        for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
            Trasmissione trasmissione = this.busta.getTrasmissione(i);
            if (trasmissione.getOraRegistrazione() == null || !trasmissione.getOraRegistrazione().after(dataFuturaMassimaAccettata)) continue;
            this.log.error("Data portata nell'ora di registrazione di una trasmissione [" + SPCoopUtils.getDate_eGovFormat(trasmissione.getOraRegistrazione()) + "] futura rispetto all'ora attuale di sistema (" + SPCoopUtils.getDate_eGovFormat(sistema) + ") e l'intervallo di tolleranza impostato a " + intervalloTolleranza + " minuti");
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(SPCoopCostantiPosizioneEccezione.ECCEZIONE_LISTA_TRASMISSIONI_NON_VALIDA_POSIZIONE_TRASMISSIONE_ORA_REGISTRAZIONE.toString());
            this.erroriValidazione.add(ecc);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public ValidazioneSintatticaResult validaRichiesta(IState state, OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        this.msg = (SOAPMessage)msg;
        boolean isValido = this.valida();
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(this.erroriValidazione, this.erroriProcessamento, this.errorsTrovatiSullaListaEccezioni, this.busta, errore, this.bustaErroreHeaderIntestazione, (SOAPElement)this.headerEGov, isValido);
        return result;
    }

    public ValidazioneSintatticaResult validaRisposta(IState state, OpenSPCoop2Message msg, Busta bustaRichiesta, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        this.msg = (SOAPMessage)msg;
        boolean isValido = this.valida();
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(this.erroriValidazione, this.erroriProcessamento, this.errorsTrovatiSullaListaEccezioni, this.busta, errore, this.bustaErroreHeaderIntestazione, (SOAPElement)this.headerEGov, isValido);
        return result;
    }

    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, boolean isRichiesta, OpenSPCoop2Message msg) throws ProtocolException {
        return this.existsHeaderEGov(msg);
    }

    public ValidazioneSintatticaResult validazioneManifestAttachments(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) {
        this.validazioneManifestAttachmentsEGov(msg, proprietaManifestAttachments);
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(this.erroriValidazione, this.erroriProcessamento, this.errorsTrovatiSullaListaEccezioni, this.busta, errore, this.bustaErroreHeaderIntestazione, (SOAPElement)this.headerEGov, true);
        return result;
    }

    public SOAPHeaderElement getHeaderProtocollo_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        this.msg = (SOAPMessage)msg;
        return this.getHeaderEGov_senzaControlli();
    }

    public ValidazioneSintatticaResult validazioneFault(SOAPBody body) {
        this.validazioneFaultEGov(body);
        ErroreCooperazione errore = null;
        if (this.msgErrore != null && this.codiceErrore != null) {
            errore = new ErroreCooperazione(this.msgErrore, this.codiceErrore);
        }
        ValidazioneSintatticaResult result = new ValidazioneSintatticaResult(this.erroriValidazione, this.erroriProcessamento, this.errorsTrovatiSullaListaEccezioni, this.busta, errore, this.bustaErroreHeaderIntestazione, (SOAPElement)this.headerEGov, true);
        return result;
    }

    public SOAPHeaderElement getHeaderProtocollo(Busta busta) {
        return null;
    }

    public ProfiloDiCollaborazione toProfilo(String profilo) {
        if ("EGOV_IT_MessaggioSingoloOneWay".equals(profilo)) {
            return ProfiloDiCollaborazione.ONEWAY;
        }
        if ("EGOV_IT_ServizioSincrono".equals(profilo)) {
            return ProfiloDiCollaborazione.SINCRONO;
        }
        if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(profilo)) {
            return ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO;
        }
        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(profilo)) {
            return ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO;
        }
        return ProfiloDiCollaborazione.UNKNOWN;
    }

    public TipoOraRegistrazione toTipoOra(String tipoora) {
        if ("EGOV_IT_Locale".equals(tipoora)) {
            return TipoOraRegistrazione.LOCALE;
        }
        if ("EGOV_IT_SPC".equals(tipoora)) {
            return TipoOraRegistrazione.SINCRONIZZATO;
        }
        return TipoOraRegistrazione.UNKNOWN;
    }

    public Inoltro toInoltro(String inoltro) {
        if ("EGOV_IT_PIUDIUNAVOLTA".equals(inoltro)) {
            return Inoltro.CON_DUPLICATI;
        }
        if ("EGOV_IT_ALPIUUNAVOLTA".equals(inoltro)) {
            return Inoltro.SENZA_DUPLICATI;
        }
        return Inoltro.UNKNOWN;
    }
}

