/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator;

import it.gov.spcoop.sica.wsbl.driver.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.validator.ValidazioneDocumenti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ValidazioneResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;

public class SPCoopValidazioneDocumenti
extends ValidazioneDocumenti {
    public SPCoopValidazioneDocumenti(IProtocolFactory factory) {
        super(factory);
    }

    public ValidazioneResult validaSpecificaConversazione(AccordoServizioParteComune accordoServizioParteComune) {
        String objectInEsame = null;
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        try {
            objectInEsame = "[InterfacciaWSBL Concettuale] ";
            byte[] wsblConcettuale = null;
            if (accordoServizioParteComune.getByteSpecificaConversazioneConcettuale() != null) {
                wsblConcettuale = accordoServizioParteComune.getByteSpecificaConversazioneConcettuale();
            } else if (accordoServizioParteComune.getSpecificaConversazioneConcettuale() != null) {
                wsblConcettuale = this.readDocumento(accordoServizioParteComune.getSpecificaConversazioneConcettuale());
            }
            if (wsblConcettuale != null) {
                this.xmlUtils.newDocument(wsblConcettuale);
                if (XMLUtils.isMessageBehavior(wsblConcettuale)) {
                    throw new Exception("La specifica di conversazione concettuale non e' un documento WSBL ConceptualBehavior, ma erroneamente un documento WSBL MessageBehavior");
                }
                XMLUtils.getConceptualBehavior(this.log, wsblConcettuale);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            objectInEsame = "[InterfacciaWSBL Erogatore] ";
            byte[] wsblErogatore = null;
            if (accordoServizioParteComune.getByteSpecificaConversazioneErogatore() != null) {
                wsblErogatore = accordoServizioParteComune.getByteSpecificaConversazioneErogatore();
            } else if (accordoServizioParteComune.getSpecificaConversazioneErogatore() != null) {
                wsblErogatore = this.readDocumento(accordoServizioParteComune.getSpecificaConversazioneErogatore());
            }
            if (wsblErogatore != null) {
                this.xmlUtils.newDocument(wsblErogatore);
                if (XMLUtils.isConceptualBehavior(wsblErogatore)) {
                    throw new Exception("La specifica di conversazione logica erogatore non e' un documento WSBL MessageBehavior, ma erroneamente un documento WSBL ConceptualBehavior");
                }
                XMLUtils.getMessageBehavior(this.log, wsblErogatore);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            objectInEsame = "[InterfacciaWSBL Fruitore] ";
            byte[] wsblFruitore = null;
            if (accordoServizioParteComune.getByteSpecificaConversazioneFruitore() != null) {
                wsblFruitore = accordoServizioParteComune.getByteSpecificaConversazioneFruitore();
            } else if (accordoServizioParteComune.getSpecificaConversazioneFruitore() != null) {
                wsblFruitore = this.readDocumento(accordoServizioParteComune.getSpecificaConversazioneFruitore());
            }
            if (wsblFruitore != null) {
                this.xmlUtils.newDocument(wsblFruitore);
                if (XMLUtils.isConceptualBehavior(wsblFruitore)) {
                    throw new Exception("La specifica di conversazione logica fruitore non e' un documento WSBL MessageBehavior, ma erroneamente un documento WSBL ConceptualBehavior");
                }
                XMLUtils.getMessageBehavior(this.log, wsblFruitore);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }
}

