/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidazioneConSchema;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SPCoopValidazioneConSchema
implements IValidazioneConSchema {
    private Logger log = null;
    private static ValidatoreXSD validatoreBustaSPCoop = null;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private IProtocolFactory protocolFactory;
    private AbstractXMLUtils xmlUtils;

    public SPCoopValidazioneConSchema(IProtocolFactory protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = protocolFactory.getLogger() != null ? protocolFactory.getLogger() : LoggerWrapperFactory.getLogger((String)"ValidazioneConSchemaSPCoop");
        this.xmlUtils = XMLUtils.getInstance();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public static synchronized boolean initializeSchema(Logger log) {
        if (validatoreBustaSPCoop != null) {
            return true;
        }
        if (log == null) {
            log = LoggerWrapperFactory.getLogger((String)"ValidazioneConSchemaSPCoop");
        }
        try {
            SPCoopProperties spcoopProperties = SPCoopProperties.getInstance(log);
            log.info("Inizializzazione dello schema per il protocollo spcoop (possono essere necessari alcuni minuti...)");
            String[] schemiXSDDaImportare = spcoopProperties.getSchemiXSDImportatiValidazioneXSDBusta();
            String schemaXSD = spcoopProperties.getSchemaXSDValidazioneXSDBusta();
            validatoreBustaSPCoop = SPCoopValidazioneConSchema.createSchemaValidator(log, schemiXSDDaImportare, schemaXSD);
            log.info("Inizializzazione dello schema per il protocollo spcoop terminata.");
            return true;
        }
        catch (Exception e) {
            log.error("Riscontrato errore durante l'inizializzazione dello schema per il protocollo spcoop: " + e.getMessage(), (Throwable)e);
            validatoreBustaSPCoop = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValidatoreXSD createSchemaValidator(Logger log, String[] schemiXSDDaImportare, String schemaXSD) throws Exception {
        XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
        if (schemiXSDDaImportare != null) {
            for (int i = 0; i < schemiXSDDaImportare.length; ++i) {
                File fXsd = new File(schemiXSDDaImportare[i]);
                InputStream is = null;
                try {
                    is = fXsd.exists() ? new FileInputStream(fXsd) : SPCoopValidazioneConSchema.class.getResourceAsStream("/" + schemiXSDDaImportare[i]);
                    xsdResourceResolver.addResource(fXsd.getName(), is);
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        File fXsd = new File(schemaXSD);
        InputStream is = null;
        try {
            is = fXsd.exists() ? new FileInputStream(fXsd) : SPCoopValidazioneConSchema.class.getResourceAsStream("/" + schemaXSD);
            ValidatoreXSD validatoreXSD = new ValidatoreXSD(log, (LSResourceResolver)xsdResourceResolver, is);
            return validatoreXSD;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void valida(OpenSPCoop2Message message, SOAPElement header, SOAPBody soapBody, boolean isSPCoopErroreProcessamento, boolean isSPCoopErroreIntestazione, boolean isMessaggioConAttachments, boolean validazioneManifestAttachments) throws ProtocolException {
        Eccezione ecc;
        this.erroriValidazione = new Vector();
        this.erroriProcessamento = new Vector();
        if (validatoreBustaSPCoop == null) {
            throw new ProtocolException("Validatore con schema XSD non inizializzato");
        }
        try {
            if (!isSPCoopErroreProcessamento && !isSPCoopErroreIntestazione) {
                validatoreBustaSPCoop.valida((Node)this.xmlUtils.newDocument(OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getAsByte((Node)header, false)));
            } else {
                Iterator itChilds = header.getChildElements();
                SOAPElement listaEccezioni = null;
                while (itChilds.hasNext()) {
                    SOAPElement elemInterno;
                    Object element = itChilds.next();
                    if (!(element instanceof SOAPElement) || !"ListaEccezioni".equals((elemInterno = (SOAPElement)element).getLocalName())) continue;
                    listaEccezioni = elemInterno;
                    break;
                }
                if (listaEccezioni == null && isSPCoopErroreIntestazione) {
                    throw new SAXException("ListaEccezioni non presente in un messaggio SPCoopErrore");
                }
                if (listaEccezioni != null) {
                    validatoreBustaSPCoop.valida((Node)this.xmlUtils.newDocument(OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getAsByte(listaEccezioni, false)));
                }
            }
        }
        catch (SAXException e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione(e.getMessage());
            this.erroriValidazione.add(ecc);
        }
        catch (Exception e) {
            ecc = new Eccezione();
            ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
            ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
            ecc.setRilevanza(LivelloRilevanza.ERROR);
            ecc.setDescrizione("Validazione con schema xsd dell'header egov non riuscita: errore di processamento");
            this.log.error("Validazione con schema xsd dell'header egov non riuscita non riuscita", (Throwable)e);
            this.erroriProcessamento.add(ecc);
        }
        if (soapBody != null && isMessaggioConAttachments && validazioneManifestAttachments) {
            try {
                OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11);
                validatoreBustaSPCoop.valida((Node)this.xmlUtils.newDocument(msg.getAsByte((Node)msg.getFirstChildElement((SOAPElement)soapBody), false)));
            }
            catch (SAXException e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.INTESTAZIONE);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione("ManifestAttachments: " + e.getMessage());
                this.erroriValidazione.add(ecc);
            }
            catch (Exception e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica(ContestoCodificaEccezione.PROCESSAMENTO);
                ecc.setCodiceEccezione(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO);
                ecc.setRilevanza(LivelloRilevanza.ERROR);
                ecc.setDescrizione("Validazione con schema xsd del manifest degli attachments non riuscita: errore di processamento");
                this.log.error("Validazione con schema xsd del manifest degli attachments non riuscita", (Throwable)e);
                this.erroriProcessamento.add(ecc);
            }
        }
    }

    public boolean initialize() {
        return SPCoopValidazioneConSchema.initializeSchema(this.log);
    }
}

