/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolVersionManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidatoreErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazioneErrori;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;

public class SPCoopValidatoreErrori
implements IValidatoreErrori {
    private IProtocolFactory protocolFactory;
    private Logger log;

    public SPCoopValidatoreErrori(IProtocolFactory protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = this.protocolFactory.getLogger();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean isBustaErrore(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        IProtocolVersionManager protocolManager;
        boolean eccezioneProcessamento;
        block10: {
            block9: {
                eccezioneProcessamento = false;
                protocolManager = null;
                try {
                    if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                        SOAPFault soapFault = msg.getSOAPBody().getFault();
                        String faultS = soapFault.getFaultString();
                        if (faultS != null) {
                            faultS = faultS.trim();
                        }
                        if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                            eccezioneProcessamento = true;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.log == null) break block9;
                    this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                protocolManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
            }
            catch (Exception e) {
                if (this.log == null) break block10;
                this.log.error("Errore durante la createProtocolVersionManager: " + e.getMessage(), (Throwable)e);
            }
        }
        if (eccezioneProcessamento) {
            return true;
        }
        if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }

    public boolean isBustaErroreProcessamento(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento;
        block5: {
            eccezioneProcessamento = false;
            try {
                if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                    SOAPFault soapFault = msg.getSOAPBody().getFault();
                    String faultS = soapFault.getFaultString();
                    if (faultS != null) {
                        faultS = faultS.trim();
                    }
                    if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                        eccezioneProcessamento = true;
                    }
                }
            }
            catch (Exception e) {
                if (this.log == null) break block5;
                this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage(), (Throwable)e);
            }
        }
        return eccezioneProcessamento;
    }

    public boolean isBustaErroreIntestazione(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        IProtocolVersionManager protocolManager;
        boolean eccezioneProcessamento;
        block10: {
            block9: {
                eccezioneProcessamento = false;
                protocolManager = null;
                try {
                    if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                        SOAPFault soapFault = msg.getSOAPBody().getFault();
                        String faultS = soapFault.getFaultString();
                        if (faultS != null) {
                            faultS = faultS.trim();
                        }
                        if ("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop".equals(faultS)) {
                            eccezioneProcessamento = true;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.log == null) break block9;
                    this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta SPCoop Errore: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                protocolManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
            }
            catch (Exception e) {
                if (this.log == null) break block10;
                this.log.error("Errore durante la createProtocolVersionManager: " + e.getMessage(), (Throwable)e);
            }
        }
        if (eccezioneProcessamento) {
            return false;
        }
        if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }
}

