/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento.XMLTracciaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.IXMLTracciaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder.SPCoopImbustamento;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;

public class SPCoopXMLTracciaBuilder
extends XMLTracciaBuilder
implements IXMLTracciaBuilder {
    private SPCoopImbustamento imbustamento = null;

    public SPCoopXMLTracciaBuilder(IProtocolFactory factory) throws ProtocolException {
        super(factory);
        this.imbustamento = new SPCoopImbustamento(factory);
    }

    public SOAPElement toElement(Traccia tracciaObject) throws ProtocolException {
        try {
            OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();
            SOAPFactory sf = SoapUtils.getSoapFactory((SOAPVersion)SOAPVersion.SOAP11);
            SOAPElement traccia = sf.createElement("traccia", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            SOAPElement GDO = traccia.addChildElement("GDO", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            if (tracciaObject.getGdo() == null) {
                GDO.setValue(this.factory.createTraduttore().getDate_protocolFormat());
            } else {
                GDO.setValue(this.factory.createTraduttore().getDate_protocolFormat(tracciaObject.getGdo()));
            }
            SOAPElement IdentificativoPorta = traccia.addChildElement("IdentificativoPorta", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            IdentificativoPorta.setValue(tracciaObject.getIdSoggetto().getCodicePorta());
            SOAPElement TipoMessaggio = traccia.addChildElement("TipoMessaggio", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            TipoMessaggio.setValue(tracciaObject.getTipoMessaggio().toString());
            SOAPElement hdrEGov = null;
            Busta busta = tracciaObject.getBusta();
            SOAPElement bustaInDom = tracciaObject.getBustaAsElement();
            String bustaAsString = tracciaObject.getBustaAsString();
            byte[] bustaInByte = tracciaObject.getBustaAsByteArray();
            if (bustaInDom != null) {
                hdrEGov = fac.createEmptySOAPMessage(SOAPVersion.SOAP11).cleanXSITypes(bustaInDom);
            } else if (bustaAsString != null) {
                hdrEGov = fac.createMessage(SOAPVersion.SOAP11).createSOAPElement(bustaAsString.getBytes());
            } else if (bustaInByte != null) {
                hdrEGov = fac.createMessage(SOAPVersion.SOAP11).createSOAPElement(bustaInByte);
            } else if (busta != null) {
                hdrEGov = this.imbustamento.build_eGovHeader(null, busta, false, true);
            } else {
                throw new NullPointerException("Busta non fornita in alcun modo");
            }
            if (hdrEGov == null) {
                throw new ProtocolException("XMLBuilder.buildElement_Tracciamento fallito");
            }
            traccia.addChildElement(hdrEGov);
            return traccia;
        }
        catch (Exception e) {
            this.log.error("XMLTracciaBuilder error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("XMLTracciaBuilder error: " + e.getMessage(), (Throwable)e);
        }
    }
}

