/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAToOpenSPCoopUtilitiesException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAtoOpenSPCoopUtilities;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class SICAtoOpenSPCoopContext {
    private static SICAtoOpenSPCoopContext staticContext = null;
    private static String DEFAULT_SICA_PROPERTIES_NAME = "sica";
    private String configurationFile;
    private ResourceBundle bundle = null;
    private boolean SICAClient_generaProject = true;
    private boolean SICAClient_includiInfoRegistroGenerale = true;
    private boolean SICAClient_nomeAccordo_32CaratteriMax = true;
    private boolean InformazioniEGov_specificaSemiformale = true;
    private boolean InformazioniEGov_wscp = false;
    private boolean InformazioniEGov_wscpDisabled_namespaceCnipa = false;
    private boolean InformazioniEGov_wscpDisabled_childUnqualified = true;
    private boolean InformazioniEGov_wscpEnabled_childUnqualified = true;
    private boolean InformazioniEGov_nomiSPCoop_qualified = true;
    private boolean WSDL_XSD_prettyDocuments = false;
    private boolean WSDL_XSD_allineaImportInclude = true;
    private boolean WSDL_XSD_accordiParteSpecifica_gestioneParteComune = true;
    private boolean WSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune = false;
    private boolean WSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune = false;
    private boolean WSDL_XSD_accordiParteSpecifica_wsdlEmpty = true;
    private boolean SICAClientCompatibility = false;
    private Hashtable<String, Boolean> SICAClientEnabledOptions = new Hashtable();
    private Hashtable<String, Boolean> SICAClientDisabledOptions = new Hashtable();
    private Hashtable<String, String> mappingSoggettoSPCoopToCodiceIPA = new Hashtable();
    private Hashtable<String, String> mappingServizioSPCoopToUriAPS = new Hashtable();

    public static void initSICAtoOpenSPCoopContext() throws SICAToOpenSPCoopUtilitiesException {
        SICAtoOpenSPCoopContext.initSICAtoOpenSPCoopContext(null);
    }

    public static synchronized void initSICAtoOpenSPCoopContext(String configurationFile) throws SICAToOpenSPCoopUtilitiesException {
        if (staticContext == null) {
            staticContext = new SICAtoOpenSPCoopContext(configurationFile);
        }
    }

    public static SICAtoOpenSPCoopContext getInstance() throws SICAToOpenSPCoopUtilitiesException {
        if (staticContext == null) {
            SICAtoOpenSPCoopContext.initSICAtoOpenSPCoopContext(DEFAULT_SICA_PROPERTIES_NAME);
        }
        return staticContext;
    }

    public SICAtoOpenSPCoopContext() throws SICAToOpenSPCoopUtilitiesException {
        this(DEFAULT_SICA_PROPERTIES_NAME);
    }

    public SICAtoOpenSPCoopContext(String configurationFile) throws SICAToOpenSPCoopUtilitiesException {
        try {
            this.configurationFile = configurationFile;
            this.SICAClient_generaProject = Boolean.parseBoolean(this.readProperty("SICAClient.project"));
            this.SICAClient_includiInfoRegistroGenerale = Boolean.parseBoolean(this.readProperty("SICAClient.includiInfoRegistroGenerale"));
            this.SICAClient_nomeAccordo_32CaratteriMax = Boolean.parseBoolean(this.readProperty("SICAClient.nomeAccordo.32CaratteriMax"));
            this.InformazioniEGov_specificaSemiformale = Boolean.parseBoolean(this.readProperty("InformazioniEGov.specificaSemiformale"));
            this.InformazioniEGov_wscp = Boolean.parseBoolean(this.readProperty("InformazioniEGov.wscp"));
            this.InformazioniEGov_wscpDisabled_namespaceCnipa = Boolean.parseBoolean(this.readProperty("InformazioniEGov.wscpDisabled.namespace.cnipa"));
            this.InformazioniEGov_wscpDisabled_childUnqualified = Boolean.parseBoolean(this.readProperty("InformazioniEGov.wscpDisabled.childUnqualified"));
            this.InformazioniEGov_wscpEnabled_childUnqualified = Boolean.parseBoolean(this.readProperty("InformazioniEGov.wscpEnabled.childUnqualified"));
            this.InformazioniEGov_nomiSPCoop_qualified = Boolean.parseBoolean(this.readProperty("InformazioniEGov.nomiSPCoop.qualified"));
            this.WSDL_XSD_prettyDocuments = Boolean.parseBoolean(this.readProperty("WSDL_XSD.prettyDocuments"));
            this.WSDL_XSD_allineaImportInclude = Boolean.parseBoolean(this.readProperty("WSDL_XSD.allineaImportInclude"));
            this.WSDL_XSD_accordiParteSpecifica_gestioneParteComune = Boolean.parseBoolean(this.readProperty("WSDL_XSD.accordiParteSpecifica.gestioneParteComune"));
            this.WSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune = Boolean.parseBoolean(this.readProperty("WSDL_XSD.accordiParteSpecifica.openspcoopToSica.eliminazioneImportParteComune"));
            this.WSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune = Boolean.parseBoolean(this.readProperty("WSDL_XSD.accordiParteSpecifica.sicaToOpenspcoop.aggiuntaImportParteComune"));
            this.WSDL_XSD_accordiParteSpecifica_wsdlEmpty = Boolean.parseBoolean(this.readProperty("WSDL_XSD.accordiParteSpecifica.wsdlEmpty"));
            this.setSICAClientEnabledOptions(this.readProperty("SICAClient.opzioniAbilitate"));
            this.setSICAClientDisabledOptions(this.readProperty("SICAClient.opzioniDisabilitate"));
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException(e);
        }
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    private synchronized void initResourceBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(this.configurationFile);
        }
    }

    private String readProperty(String key) throws Exception {
        String properties;
        if (this.bundle == null) {
            this.initResourceBundle();
        }
        if ((properties = this.bundle.getString(key)) == null) {
            throw new Exception("Proprieta [" + key + "] non trovata");
        }
        return properties.trim();
    }

    public void addMappingSoggettoSPCoopToCodiceIPA(IDSoggetto idSoggettoSPCoop, String codiceIPA) {
        if (codiceIPA == null || idSoggettoSPCoop == null || idSoggettoSPCoop.toString() == null) {
            return;
        }
        if (!this.mappingSoggettoSPCoopToCodiceIPA.containsKey(idSoggettoSPCoop.toString())) {
            this.mappingSoggettoSPCoopToCodiceIPA.put(idSoggettoSPCoop.toString(), codiceIPA);
        }
    }

    public String getCodiceIPA(IDSoggetto idSoggettoSPCoop) {
        return this.mappingSoggettoSPCoopToCodiceIPA.get(idSoggettoSPCoop.toString());
    }

    public String getCodiceIPA(String nomeSoggetto) {
        return this.getCodiceIPA(new IDSoggetto("SPC", nomeSoggetto));
    }

    public IDSoggetto getIDSoggetto(String codiceIPA) {
        if (this.mappingSoggettoSPCoopToCodiceIPA.contains(codiceIPA)) {
            Enumeration<String> keys = this.mappingSoggettoSPCoopToCodiceIPA.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = this.mappingSoggettoSPCoopToCodiceIPA.get(key);
                if (!value.equals(codiceIPA)) continue;
                String[] split = key.split("/");
                return new IDSoggetto(split[0], split[1]);
            }
        }
        return null;
    }

    public void addMappingServizioToUriAPS(IDServizio idServizioSPCoop, IDAccordo idAccordoServizioParteSpecifica) throws SICAToOpenSPCoopUtilitiesException {
        if (idServizioSPCoop == null || idServizioSPCoop.getTipoServizio() == null || idServizioSPCoop.getServizio() == null || idServizioSPCoop.getSoggettoErogatore() == null || idServizioSPCoop.getSoggettoErogatore().getTipo() == null || idServizioSPCoop.getSoggettoErogatore().getNome() == null) {
            return;
        }
        if (idAccordoServizioParteSpecifica == null || idAccordoServizioParteSpecifica.getNome() == null || idAccordoServizioParteSpecifica.getVersione() == null || idAccordoServizioParteSpecifica.getSoggettoReferente() == null || idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo() == null || idAccordoServizioParteSpecifica.getSoggettoReferente().getNome() == null) {
            return;
        }
        idServizioSPCoop.setAzione(null);
        String keyServizioSPCoop = idServizioSPCoop.toString();
        if (!this.mappingServizioSPCoopToUriAPS.containsKey(keyServizioSPCoop)) {
            this.mappingServizioSPCoopToUriAPS.put(keyServizioSPCoop, SICAtoOpenSPCoopUtilities.idAccordoServizioParteSpecifica_openspcoopToSica(idAccordoServizioParteSpecifica, this));
        }
    }

    public String getUriAPS(IDServizio idServizioSPCoop) {
        return this.mappingServizioSPCoopToUriAPS.get(idServizioSPCoop.toString());
    }

    public IDServizio getIDServizio(IDAccordo idAccordoServizioParteSpecifica) throws SICAToOpenSPCoopUtilitiesException {
        return this.getIDServizio(SICAtoOpenSPCoopUtilities.idAccordoServizioParteSpecifica_openspcoopToSica(idAccordoServizioParteSpecifica, this));
    }

    public IDServizio getIDServizio(String uriAPS) {
        if (this.mappingServizioSPCoopToUriAPS.contains(uriAPS)) {
            Enumeration<String> keys = this.mappingServizioSPCoopToUriAPS.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = this.mappingServizioSPCoopToUriAPS.get(key);
                if (!value.equals(uriAPS)) continue;
                try {
                    String[] split = key.split("--");
                    String soggetto = split[0];
                    String tipoSoggetto = soggetto.split("/")[0];
                    String nomeSoggetto = soggetto.split("/")[1];
                    String servizio = split[1];
                    String tipoServizio = servizio.split("/")[0];
                    String nomeServizio = servizio.split("/")[1];
                    int indexOf = nomeServizio.lastIndexOf(":");
                    if (indexOf > 0) {
                        nomeServizio = nomeServizio.substring(0, indexOf);
                    }
                    IDServizio idS = new IDServizio(tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio);
                    return idS;
                }
                catch (Exception e) {
                    throw new RuntimeException("(key[" + key + "] value[" + value + "]) " + e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public boolean isSICAClient_generaProject() {
        return this.checkOption("SICAClient.project", this.SICAClient_generaProject);
    }

    public void setSICAClient_generaProject(boolean client_generaProject) {
        this.SICAClient_generaProject = client_generaProject;
    }

    public boolean isSICAClient_includiInfoRegistroGenerale() {
        return this.checkOption("SICAClient.includiInfoRegistroGenerale", this.SICAClient_includiInfoRegistroGenerale);
    }

    public void setSICAClient_includiInfoRegistroGenerale(boolean client_includiInfoRegistroGenerale) {
        this.SICAClient_includiInfoRegistroGenerale = client_includiInfoRegistroGenerale;
    }

    public boolean isSICAClient_nomeAccordo_32CaratteriMax() {
        return this.checkOption("SICAClient.nomeAccordo.32CaratteriMax", this.SICAClient_nomeAccordo_32CaratteriMax);
    }

    public void setSICAClient_nomeAccordo_32CaratteriMax(boolean client_nomeAccordo_32CaratteriMax) {
        this.SICAClient_nomeAccordo_32CaratteriMax = client_nomeAccordo_32CaratteriMax;
    }

    public boolean isWSDL_XSD_accordiParteSpecifica_wsdlEmpty() {
        return this.checkOption("WSDL_XSD.accordiParteSpecifica.wsdlEmpty", this.WSDL_XSD_accordiParteSpecifica_wsdlEmpty);
    }

    public void setWSDL_XSD_accordiParteSpecifica_wsdlEmpty(boolean client_accordiParteSpecifica_wsdlEmpty) {
        this.WSDL_XSD_accordiParteSpecifica_wsdlEmpty = client_accordiParteSpecifica_wsdlEmpty;
    }

    public boolean isInformazioniEGov_specificaSemiformale() {
        return this.checkOption("InformazioniEGov.specificaSemiformale", this.InformazioniEGov_specificaSemiformale);
    }

    public void setInformazioniEGov_specificaSemiformale(boolean informazioniEGov_specificaSemiformale) {
        this.InformazioniEGov_specificaSemiformale = informazioniEGov_specificaSemiformale;
    }

    public boolean isInformazioniEGov_wscp() {
        return this.checkOption("InformazioniEGov.wscp", this.InformazioniEGov_wscp);
    }

    public void setInformazioniEGov_wscp(boolean informazioniEGov_wscp) {
        this.InformazioniEGov_wscp = informazioniEGov_wscp;
    }

    public boolean isInformazioniEGov_wscpDisabled_namespaceCnipa() {
        return this.InformazioniEGov_wscpDisabled_namespaceCnipa;
    }

    public void setInformazioniEGov_wscpDisabled_namespaceCnipa(boolean informazioniEGovWscpDisabledNamespaceCnipa) {
        this.InformazioniEGov_wscpDisabled_namespaceCnipa = informazioniEGovWscpDisabledNamespaceCnipa;
    }

    public boolean isInformazioniEGov_wscpDisabled_childUnqualified() {
        return this.InformazioniEGov_wscpDisabled_childUnqualified;
    }

    public void setInformazioniEGov_wscpDisabled_childUnqualified(boolean informazioniEGovWscpDisabledChildUnqualified) {
        this.InformazioniEGov_wscpDisabled_childUnqualified = informazioniEGovWscpDisabledChildUnqualified;
    }

    public boolean isInformazioniEGov_wscpEnabled_childUnqualified() {
        return this.InformazioniEGov_wscpEnabled_childUnqualified;
    }

    public void setInformazioniEGov_wscpEnabled_childUnqualified(boolean informazioniEGovWscpEnabledChildUnqualified) {
        this.InformazioniEGov_wscpEnabled_childUnqualified = informazioniEGovWscpEnabledChildUnqualified;
    }

    public boolean isInformazioniEGov_nomiSPCoop_qualified() {
        return this.InformazioniEGov_nomiSPCoop_qualified;
    }

    public void setInformazioniEGov_nomiSPCoop_qualified(boolean informazioniEGovNomiSPCoopQualified) {
        this.InformazioniEGov_nomiSPCoop_qualified = informazioniEGovNomiSPCoopQualified;
    }

    public boolean isWSDL_XSD_prettyDocuments() {
        return this.checkOption("WSDL_XSD.prettyDocuments", this.WSDL_XSD_prettyDocuments);
    }

    public void setWSDL_XSD_prettyDocuments(boolean documents) {
        this.WSDL_XSD_prettyDocuments = documents;
    }

    public boolean isWSDL_XSD_allineaImportInclude() {
        return this.checkOption("WSDL_XSD.allineaImportInclude", this.WSDL_XSD_allineaImportInclude);
    }

    public void setWSDL_XSD_allineaImportInclude(boolean importInclude) {
        this.WSDL_XSD_allineaImportInclude = importInclude;
    }

    public boolean isWSDL_XSD_accordiParteSpecifica_gestioneParteComune() {
        return this.checkOption("WSDL_XSD.accordiParteSpecifica.gestioneParteComune", this.WSDL_XSD_accordiParteSpecifica_gestioneParteComune);
    }

    public void setWSDL_XSD_accordiParteSpecifica_gestioneParteComune(boolean parteSpecifica_gestioneParteComune) {
        this.WSDL_XSD_accordiParteSpecifica_gestioneParteComune = parteSpecifica_gestioneParteComune;
    }

    public boolean isWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune() {
        return this.checkOption("WSDL_XSD.accordiParteSpecifica.openspcoopToSica.eliminazioneImportParteComune", this.WSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune);
    }

    public void setWSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune(boolean parteSpecifica_openspcoopToSica_eliminazioneImportParteComune) {
        this.WSDL_XSD_accordiParteSpecifica_openspcoopToSica_eliminazioneImportParteComune = parteSpecifica_openspcoopToSica_eliminazioneImportParteComune;
    }

    public boolean isWSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune() {
        return this.checkOption("WSDL_XSD.accordiParteSpecifica.sicaToOpenspcoop.aggiuntaImportParteComune", this.WSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune);
    }

    public void setWSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune(boolean parteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune) {
        this.WSDL_XSD_accordiParteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune = parteSpecifica_sicaToOpenspcoop_aggiuntaImportParteComune;
    }

    public boolean isSICAClientCompatibility() {
        return this.SICAClientCompatibility;
    }

    public void setSICAClientCompatibility(boolean clientCompatibility) {
        this.SICAClientCompatibility = clientCompatibility;
    }

    public void setSICAClientEnabledOptions(String enabledOptions) {
        if (enabledOptions == null) {
            return;
        }
        String[] options = enabledOptions.trim().split(",");
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                this.SICAClientEnabledOptions.put(options[i].trim(), true);
            }
        }
    }

    public void setSICAClientDisabledOptions(String disabledOptions) {
        if (disabledOptions == null) {
            return;
        }
        String[] options = disabledOptions.trim().split(",");
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                this.SICAClientDisabledOptions.put(options[i].trim(), true);
            }
        }
    }

    private boolean checkOption(String name, boolean defaultValue) {
        if (this.SICAClientCompatibility) {
            if (this.SICAClientEnabledOptions.containsKey(name)) {
                return true;
            }
            if (this.SICAClientDisabledOptions.containsKey(name)) {
                return false;
            }
        }
        return defaultValue;
    }
}

