/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.XMLDiagnosticoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.IXMLDiagnosticoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.utils.SPCoopUtils;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPCoopXMLDiagnosticoBuilder
extends XMLDiagnosticoBuilder
implements IXMLDiagnosticoBuilder {
    public SPCoopXMLDiagnosticoBuilder(IProtocolFactory protocolFactory) {
        super(protocolFactory);
    }

    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        try {
            Document doc = this.xmlUtils.newDocument();
            Element diagnostico = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:MessaggioDiagnostico");
            Element gdoMsgDiag = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:OraRegistrazione");
            Date gdoD = null;
            gdoD = msgDiag.getGdo() == null ? new Date(DateManager.getTimeMillis()) : new Date(msgDiag.getGdo().getTime());
            gdoMsgDiag.setTextContent(SPCoopUtils.getDate_eGovFormat(gdoD));
            diagnostico.appendChild(gdoMsgDiag);
            Element identificativoPorta = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoPorta");
            identificativoPorta.setTextContent(msgDiag.getIdSoggetto().getCodicePorta());
            diagnostico.appendChild(identificativoPorta);
            Element identificativoFunzione = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoFunzione");
            identificativoFunzione.setTextContent(msgDiag.getIdFunzione());
            diagnostico.appendChild(identificativoFunzione);
            Element livelloSev = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:LivelloDiSeverita");
            String liv = "" + msgDiag.getSeverita();
            livelloSev.setTextContent(liv);
            diagnostico.appendChild(livelloSev);
            Element testo = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:TestoDiagnostico");
            testo.setTextContent(msgDiag.getMessaggio());
            diagnostico.appendChild(testo);
            return diagnostico;
        }
        catch (Exception e) {
            this.log.error("XMLDiagnosticoBuilder error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("XMLDiagnosticoBuilder error: " + e.getMessage(), (Throwable)e);
        }
    }
}

