/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.config.BasicTraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SubCodiceErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.constants.SPCoopCostantiPosizioneEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.utils.SPCoopUtils;
import java.util.Date;

public class SPCoopTraduttore
extends BasicTraduttore {
    public SPCoopTraduttore(IProtocolFactory protocolFactory) {
        super(protocolFactory);
    }

    public String toString(CodiceErroreCooperazione cod) {
        return this.toString(cod, null);
    }

    public String toString(CodiceErroreCooperazione cod, SubCodiceErrore subCode) {
        String prefix = "EGOV_IT_";
        switch (cod) {
            case FORMATO_NON_CORRETTO: {
                return prefix + "001";
            }
            case FORMATO_INTESTAZIONE_NON_CORRETTO: {
                return prefix + "002";
            }
            case FORMATO_CORPO_NON_CORRETTO: 
            case ALLEGATI: {
                return prefix + "003";
            }
            case INTESTAZIONE_NON_CORRETTA: {
                return prefix + "100";
            }
            case MITTENTE: 
            case MITTENTE_NON_PRESENTE: 
            case TIPO_MITTENTE_NON_PRESENTE: 
            case IDPORTA_MITTENTE_NON_PRESENTE: 
            case INDIRIZZO_MITTENTE_NON_PRESENTE: 
            case MITTENTE_PRESENTE_PIU_VOLTE: 
            case TIPO_MITTENTE_PRESENTE_PIU_VOLTE: 
            case IDPORTA_MITTENTE_PRESENTE_PIU_VOLTE: 
            case INDIRIZZO_MITTENTE_PRESENTE_PIU_VOLTE: 
            case MITTENTE_NON_VALORIZZATO: 
            case TIPO_MITTENTE_NON_VALORIZZATO: 
            case IDPORTA_MITTENTE_NON_VALORIZZATO: 
            case INDIRIZZO_MITTENTE_NON_VALORIZZATO: 
            case MITTENTE_NON_VALIDO: 
            case TIPO_MITTENTE_NON_VALIDO: 
            case IDPORTA_MITTENTE_NON_VALIDO: 
            case INDIRIZZO_MITTENTE_NON_VALIDO: 
            case MITTENTE_SCONOSCIUTO: 
            case TIPO_MITTENTE_SCONOSCIUTO: 
            case IDPORTA_MITTENTE_SCONOSCIUTO: 
            case INDIRIZZO_MITTENTE_SCONOSCIUTO: {
                return prefix + "101";
            }
            case DESTINATARIO: 
            case DESTINATARIO_NON_PRESENTE: 
            case TIPO_DESTINATARIO_NON_PRESENTE: 
            case IDPORTA_DESTINATARIO_NON_PRESENTE: 
            case INDIRIZZO_DESTINATARIO_NON_PRESENTE: 
            case DESTINATARIO_PRESENTE_PIU_VOLTE: 
            case TIPO_DESTINATARIO_PRESENTE_PIU_VOLTE: 
            case IDPORTA_DESTINATARIO_PRESENTE_PIU_VOLTE: 
            case INDIRIZZO_DESTINATARIO_PRESENTE_PIU_VOLTE: 
            case DESTINATARIO_NON_VALORIZZATO: 
            case TIPO_DESTINATARIO_NON_VALORIZZATO: 
            case IDPORTA_DESTINATARIO_NON_VALORIZZATO: 
            case INDIRIZZO_DESTINATARIO_NON_VALORIZZATO: 
            case DESTINATARIO_NON_VALIDO: 
            case TIPO_DESTINATARIO_NON_VALIDO: 
            case IDPORTA_DESTINATARIO_NON_VALIDO: 
            case INDIRIZZO_DESTINATARIO_NON_VALIDO: 
            case DESTINATARIO_SCONOSCIUTO: 
            case TIPO_DESTINATARIO_SCONOSCIUTO: 
            case IDPORTA_DESTINATARIO_SCONOSCIUTO: 
            case INDIRIZZO_DESTINATARIO_SCONOSCIUTO: {
                return prefix + "102";
            }
            case PROFILO_COLLABORAZIONE: 
            case PROFILO_COLLABORAZIONE_NON_PRESENTE: 
            case PROFILO_COLLABORAZIONE_PRESENTE_PIU_VOLTE: 
            case PROFILO_COLLABORAZIONE_NON_VALORIZZATO: 
            case PROFILO_COLLABORAZIONE_NON_VALIDO: 
            case PROFILO_COLLABORAZIONE_SCONOSCIUTO: 
            case SERVIZIO_CORRELATO_NON_PRESENTE: 
            case TIPO_SERVIZIO_CORRELATO_NON_PRESENTE: 
            case VERSIONE_SERVIZIO_CORRELATO_NON_PRESENTE: 
            case SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE: 
            case TIPO_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE: 
            case VERSIONE_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE: 
            case SERVIZIO_CORRELATO_NON_VALORIZZATO: 
            case TIPO_SERVIZIO_CORRELATO_NON_VALORIZZATO: 
            case VERSIONE_SERVIZIO_CORRELATO_NON_VALORIZZATO: 
            case SERVIZIO_CORRELATO_NON_VALIDO: 
            case TIPO_SERVIZIO_CORRELATO_NON_VALIDO: 
            case VERSIONE_SERVIZIO_CORRELATO_NON_VALIDO: 
            case SERVIZIO_CORRELATO_SCONOSCIUTO: 
            case TIPO_SERVIZIO_CORRELATO_SCONOSCIUTO: 
            case VERSIONE_SERVIZIO_CORRELATO_SCONOSCIUTO: {
                return prefix + "103";
            }
            case COLLABORAZIONE: 
            case COLLABORAZIONE_NON_PRESENTE: 
            case COLLABORAZIONE_PRESENTE_PIU_VOLTE: 
            case COLLABORAZIONE_NON_VALORIZZATA: 
            case COLLABORAZIONE_NON_VALIDA: 
            case COLLABORAZIONE_SCONOSCIUTA: {
                return prefix + "104";
            }
            case SERVIZIO: 
            case SERVIZIO_NON_PRESENTE: 
            case TIPO_SERVIZIO_NON_PRESENTE: 
            case VERSIONE_SERVIZIO_NON_PRESENTE: 
            case SERVIZIO_PRESENTE_PIU_VOLTE: 
            case TIPO_SERVIZIO_PRESENTE_PIU_VOLTE: 
            case VERSIONE_SERVIZIO_PRESENTE_PIU_VOLTE: 
            case SERVIZIO_NON_VALORIZZATO: 
            case TIPO_SERVIZIO_NON_VALORIZZATO: 
            case VERSIONE_SERVIZIO_NON_VALORIZZATO: 
            case SERVIZIO_NON_VALIDO: 
            case TIPO_SERVIZIO_NON_VALIDO: 
            case VERSIONE_SERVIZIO_NON_VALIDO: 
            case SERVIZIO_SCONOSCIUTO: 
            case TIPO_SERVIZIO_SCONOSCIUTO: 
            case VERSIONE_SERVIZIO_SCONOSCIUTO: {
                return prefix + "105";
            }
            case AZIONE: 
            case AZIONE_NON_PRESENTE: 
            case AZIONE_PRESENTE_PIU_VOLTE: 
            case AZIONE_NON_VALORIZZATA: 
            case AZIONE_NON_VALIDA: 
            case AZIONE_SCONOSCIUTA: 
            case INVOCAZIONE_SENZA_AZIONE_NON_PERMESSA: {
                return prefix + "106";
            }
            case IDENTIFICATIVO_MESSAGGIO: 
            case IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE: 
            case IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE: 
            case IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO: {
                return prefix + "107";
            }
            case ORA_REGISTRAZIONE: 
            case ORA_REGISTRAZIONE_NON_PRESENTE: 
            case TIPO_ORA_REGISTRAZIONE_NON_PRESENTE: 
            case ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case ORA_REGISTRAZIONE_NON_VALORIZZATA: 
            case TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA: 
            case ORA_REGISTRAZIONE_NON_VALIDA: 
            case TIPO_ORA_REGISTRAZIONE_NON_VALIDA: 
            case ORA_REGISTRAZIONE_SCONOSCIUTA: 
            case TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA: {
                return prefix + "108";
            }
            case RIFERIMENTO_MESSAGGIO: 
            case RIFERIMENTO_MESSAGGIO_NON_PRESENTE: 
            case RIFERIMENTO_MESSAGGIO_PRESENTE_PIU_VOLTE: 
            case RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO: {
                return prefix + "109";
            }
            case IDENTIFICATIVO_MESSAGGIO_NON_VALIDO: 
            case IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO: 
            case IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO: {
                return prefix + "110";
            }
            case RIFERIMENTO_MESSAGGIO_NON_VALIDO: 
            case RIFERIMENTO_MESSAGGIO_SCONOSCIUTO: 
            case RIFERIMENTO_MESSAGGIO_GIA_PROCESSATO: {
                return prefix + "111";
            }
            case SCADENZA: 
            case SCADENZA_NON_PRESENTE: 
            case TIPO_SCADENZA_NON_PRESENTE: 
            case SCADENZA_PRESENTE_PIU_VOLTE: 
            case TIPO_SCADENZA_PRESENTE_PIU_VOLTE: 
            case SCADENZA_NON_VALORIZZATA: 
            case TIPO_SCADENZA_NON_VALORIZZATA: 
            case SCADENZA_NON_VALIDA: 
            case TIPO_SCADENZA_NON_VALIDA: 
            case SCADENZA_SCONOSCIUTA: 
            case TIPO_SCADENZA_SCONOSCIUTA: {
                return prefix + "112";
            }
            case PROFILO_TRASMISSIONE: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE: 
            case PROFILO_TRASMISSIONE_NON_PRESENTE: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_PRESENTE: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE: 
            case PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_PRESENTE_PIU_VOLTE: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_PRESENTE_PIU_VOLTE: 
            case PROFILO_TRASMISSIONE_NON_VALORIZZATO: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALORIZZATO: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALORIZZATO: 
            case PROFILO_TRASMISSIONE_NON_VALIDO: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO: 
            case PROFILO_TRASMISSIONE_SCONOSCIUTO: 
            case PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO: 
            case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO: {
                return prefix + "113";
            }
            case CONSEGNA_IN_ORDINE_NON_PRESENTE: 
            case CONSEGNA_IN_ORDINE_PRESENTE_PIU_VOLTE: 
            case CONSEGNA_IN_ORDINE_NON_VALORIZZATA: 
            case CONSEGNA_IN_ORDINE_NON_VALIDA: 
            case CONSEGNA_IN_ORDINE_SCONOSCIUTA: 
            case CONSEGNA_IN_ORDINE_FUORI_SEQUENZA: 
            case CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO: 
            case CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA: 
            case CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA: {
                return prefix + "114";
            }
            case LISTA_RISCONTRI: 
            case LISTA_RISCONTRI_NON_PRESENTE: 
            case LISTA_RISCONTRI_PRESENTE_PIU_VOLTE: 
            case LISTA_RISCONTRI_NON_VALORIZZATA: 
            case LISTA_RISCONTRI_NON_VALIDA: 
            case LISTA_RISCONTRI_SCONOSCIUTA: 
            case RISCONTRO: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO: 
            case RISCONTRO_ORA_REGISTRAZIONE: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE: 
            case RISCONTRO_NON_PRESENTE: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE: 
            case RISCONTRO_ORA_REGISTRAZIONE_NON_PRESENTE: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE: 
            case RISCONTRO_PRESENTE_PIU_VOLTE: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE: 
            case RISCONTRO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case RISCONTRO_NON_VALORIZZATO: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO: 
            case RISCONTRO_ORA_REGISTRAZIONE_NON_VALORIZZATA: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATO: 
            case RISCONTRO_NON_VALIDO: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO: 
            case RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO: 
            case RISCONTRO_SCONOSCIUTO: 
            case RISCONTRO_IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO: 
            case RISCONTRO_ORA_REGISTRAZIONE_SCONOSCIUTA: 
            case RISCONTRO_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTO: {
                return prefix + "115";
            }
            case LISTA_TRASMISSIONI: 
            case LISTA_TRASMISSIONI_NON_PRESENTE: 
            case LISTA_TRASMISSIONI_PRESENTE_PIU_VOLTE: 
            case LISTA_TRASMISSIONI_NON_VALORIZZATA: 
            case LISTA_TRASMISSIONI_NON_VALIDA: 
            case LISTA_TRASMISSIONI_SCONOSCIUTA: 
            case TRASMISSIONE: 
            case TRASMISSIONE_TIPO_ORIGINE: 
            case TRASMISSIONE_ORIGINE: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE: 
            case TRASMISSIONE_IDPORTA_ORIGINE: 
            case TRASMISSIONE_TIPO_DESTINAZIONE: 
            case TRASMISSIONE_DESTINAZIONE: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE: 
            case TRASMISSIONE_ORA_REGISTRAZIONE: 
            case TRASMISSIONE_NON_PRESENTE: 
            case TRASMISSIONE_TIPO_ORIGINE_NON_PRESENTE: 
            case TRASMISSIONE_ORIGINE_NON_PRESENTE: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE_NON_PRESENTE: 
            case TRASMISSIONE_IDPORTA_ORIGINE_NON_PRESENTE: 
            case TRASMISSIONE_TIPO_DESTINAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_DESTINAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE: 
            case TRASMISSIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_TIPO_ORIGINE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_ORIGINE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_IDPORTA_ORIGINE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_TIPO_DESTINAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_DESTINAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE: 
            case TRASMISSIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_TIPO_ORIGINE_NON_VALORIZZATA: 
            case TRASMISSIONE_ORIGINE_NON_VALORIZZATA: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALORIZZATA: 
            case TRASMISSIONE_IDPORTA_ORIGINE_NON_VALORIZZATA: 
            case TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_DESTINAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALORIZZATA: 
            case TRASMISSIONE_NON_VALIDA: 
            case TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA: 
            case TRASMISSIONE_ORIGINE_NON_VALIDA: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA: 
            case TRASMISSIONE_IDPORTA_ORIGINE_NON_VALIDA: 
            case TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA: 
            case TRASMISSIONE_DESTINAZIONE_NON_VALIDA: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALIDA: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA: 
            case TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA: 
            case TRASMISSIONE_SCONOSCIUTA: 
            case TRASMISSIONE_TIPO_ORIGINE_SCONOSCIUTA: 
            case TRASMISSIONE_ORIGINE_SCONOSCIUTA: 
            case TRASMISSIONE_INDIRIZZO_ORIGINE_SCONOSCIUTA: 
            case TRASMISSIONE_IDPORTA_ORIGINE_SCONOSCIUTA: 
            case TRASMISSIONE_TIPO_DESTINAZIONE_SCONOSCIUTA: 
            case TRASMISSIONE_DESTINAZIONE_SCONOSCIUTA: 
            case TRASMISSIONE_INDIRIZZO_DESTINAZIONE_SCONOSCIUTA: 
            case TRASMISSIONE_IDPORTA_DESTINAZIONE_SCONOSCIUTA: 
            case TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA: 
            case TRASMISSIONE_ORA_REGISTRAZIONE_SCONOSCIUTA: {
                return prefix + "116";
            }
            case SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA: 
            case SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE: {
                return prefix + "117";
            }
            case ALLEGATI_RIFERIMENTO_NON_PRESENTE: 
            case ALLEGATI_RIFERIMENTO_NON_VALIDO: {
                return prefix + "118";
            }
            case ALLEGATO_NON_PRESENTE: {
                return prefix + "119";
            }
            case ALLEGATO_NON_DEFINITO_MANIFEST: {
                return prefix + "120";
            }
            case SICUREZZA: 
            case SICUREZZA_CIFRATURA_NON_PRESENTE: 
            case SICUREZZA_CIFRATURA_NON_VALIDA: 
            case SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE: 
            case SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA: 
            case SICUREZZA_NON_PRESENTE: {
                return prefix + "200";
            }
            case SICUREZZA_AUTORIZZAZIONE_FALLITA: 
            case SICUREZZA_FALSIFICAZIONE_MITTENTE: {
                return prefix + "201";
            }
            case SICUREZZA_FIRMA_NON_VALIDA: 
            case SICUREZZA_FIRMA_NON_PRESENTE: 
            case SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA: 
            case SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE: {
                return prefix + "202";
            }
            case SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA: 
            case SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE: {
                return prefix + "203";
            }
            case ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO: {
                return prefix + "300";
            }
            case MESSAGGIO_SCADUTO: {
                return prefix + "301";
            }
            case CONSEGNA_IN_ORDINE: {
                return prefix + "400";
            }
            case CONSEGNA_IN_ORDINE_NON_SUPPORTATA: {
                return prefix + "401";
            }
            case CONSEGNA_IN_ORDINE_NON_GESTIBILE: {
                return prefix + "402";
            }
        }
        return null;
    }

    public CodiceErroreCooperazione toCodiceErroreCooperazione(String codiceCooperazione) {
        String prefix = "EGOV_IT_";
        if ((prefix + "001").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.FORMATO_NON_CORRETTO;
        }
        if ((prefix + "002").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.FORMATO_INTESTAZIONE_NON_CORRETTO;
        }
        if ((prefix + "003").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.FORMATO_CORPO_NON_CORRETTO;
        }
        if ((prefix + "100").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.INTESTAZIONE_NON_CORRETTA;
        }
        if ((prefix + "101").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.MITTENTE;
        }
        if ((prefix + "102").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.DESTINATARIO;
        }
        if ((prefix + "103").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.PROFILO_COLLABORAZIONE;
        }
        if ((prefix + "104").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.COLLABORAZIONE;
        }
        if ((prefix + "105").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SERVIZIO;
        }
        if ((prefix + "106").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.AZIONE;
        }
        if ((prefix + "107").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO;
        }
        if ((prefix + "108").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.ORA_REGISTRAZIONE;
        }
        if ((prefix + "109").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO;
        }
        if ((prefix + "110").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_NON_VALIDO;
        }
        if ((prefix + "111").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO;
        }
        if ((prefix + "112").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SCADENZA;
        }
        if ((prefix + "113").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.PROFILO_TRASMISSIONE;
        }
        if ((prefix + "114").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_VALIDA;
        }
        if ((prefix + "115").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.LISTA_RISCONTRI;
        }
        if ((prefix + "116").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.LISTA_TRASMISSIONI;
        }
        if ((prefix + "117").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA;
        }
        if ((prefix + "118").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.ALLEGATI_RIFERIMENTO_NON_VALIDO;
        }
        if ((prefix + "119").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.ALLEGATO_NON_PRESENTE;
        }
        if ((prefix + "120").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.ALLEGATO_NON_DEFINITO_MANIFEST;
        }
        if ((prefix + "200").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SICUREZZA;
        }
        if ((prefix + "201").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA;
        }
        if ((prefix + "202").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA;
        }
        if ((prefix + "203").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA;
        }
        if ((prefix + "300").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO;
        }
        if ((prefix + "301").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.MESSAGGIO_SCADUTO;
        }
        if ((prefix + "400").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.CONSEGNA_IN_ORDINE;
        }
        if ((prefix + "401").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_SUPPORTATA;
        }
        if ((prefix + "402").equals(codiceCooperazione)) {
            return CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_GESTIBILE;
        }
        return CodiceErroreCooperazione.UNKNOWN;
    }

    public String toString(MessaggiFaultErroreCooperazione msg) {
        switch (msg) {
            case FAULT_STRING_PROCESSAMENTO: {
                return "EGOV_IT_300 - Errore nel processamento del messaggio SPCoop";
            }
            case FAULT_STRING_PROCESSAMENTO_SENZA_CODICE: {
                return "Errore nel processamento del messaggio SPCoop";
            }
            case FAULT_STRING_VALIDAZIONE: {
                return "EGOV_IT_001 - Formato Busta non corretto";
            }
        }
        return msg.toString();
    }

    public String toString(ErroreCooperazione msg) {
        try {
            if (msg.getCodiceErrore() != null) {
                switch (msg.getCodiceErrore()) {
                    case MITTENTE_NON_VALIDO: 
                    case MITTENTE_SCONOSCIUTO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString();
                    }
                    case TIPO_MITTENTE_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_MITTENTE_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString();
                    }
                    case DESTINATARIO_NON_VALIDO: 
                    case DESTINATARIO_SCONOSCIUTO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE.toString();
                    }
                    case TIPO_DESTINATARIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_DESTINATARIO_SCONOSCIUTO_POSIZIONE_IDENTIFICATIVO_PARTE_TIPO.toString();
                    }
                    case SERVIZIO_NON_VALIDO: 
                    case SERVIZIO_SCONOSCIUTO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE.toString();
                    }
                    case TIPO_SERVIZIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SERVIZIO_SCONOSCIUTO_POSIZIONE_TIPO.toString();
                    }
                    case AZIONE_NON_VALIDA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_AZIONE_SCONOSCIUTA_POSIZIONE.toString();
                    }
                    case IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_ID_MESSAGGIO_NON_VALIDO_POSIZIONE.toString();
                    }
                    case RIFERIMENTO_MESSAGGIO_NON_PRESENTE: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_DEFINITO_POSIZIONE.toString();
                    }
                    case RIFERIMENTO_MESSAGGIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_RIFERIMENTO_MESSAGGIO_NON_VALIDO_POSIZIONE.toString();
                    }
                    case MESSAGGIO_SCADUTO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_MESSAGGIO_SCADUTO_POSIZIONE.toString();
                    }
                    case PROFILO_COLLABORAZIONE_SCONOSCIUTO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString();
                    }
                    case PROFILO_COLLABORAZIONE_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_COLLABORAZIONE_SCONOSCIUTO_POSIZIONE.toString();
                    }
                    case COLLABORAZIONE_NON_VALIDA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString();
                    }
                    case COLLABORAZIONE_SCONOSCIUTA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_COLLABORAZIONE_SCONOSCIUTA_POSIZIONE.toString();
                    }
                    case PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_PROFILO_TRASMISSIONE_NON_VALIDO_POSIZIONE_CONFERMA_RICEZIONE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_NON_GESTIBILE: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_FUORI_SEQUENZA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_NUMERO_PROGRESSIVO_BUSTA_CAPOSTIPITE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_TIPO_MITTENTE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_MITTENTE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_TIPO_DESTINATARIO.toString();
                    }
                    case CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_DESTINATARIO.toString();
                    }
                    case CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_TIPO_SERVIZIO.toString();
                    }
                    case CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_SERVIZIO.toString();
                    }
                    case CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_AZIONE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_SEQUENZA_NON_VALIDA_POSIZIONE_COLLABORAZIONE.toString();
                    }
                    case CONSEGNA_IN_ORDINE_NON_SUPPORTATA: {
                        return SPCoopCostantiPosizioneEccezione.ECCEZIONE_TRASPARENZA_TEMPORALE_NON_SUPPORTATA_POSIZIONE.toString();
                    }
                    case SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA: 
                    case SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE: 
                    case SICUREZZA: 
                    case SICUREZZA_CIFRATURA_NON_PRESENTE: 
                    case SICUREZZA_CIFRATURA_NON_VALIDA: 
                    case SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE: 
                    case SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA: 
                    case SICUREZZA_NON_PRESENTE: 
                    case SICUREZZA_AUTORIZZAZIONE_FALLITA: 
                    case SICUREZZA_FALSIFICAZIONE_MITTENTE: 
                    case SICUREZZA_FIRMA_NON_VALIDA: 
                    case SICUREZZA_FIRMA_NON_PRESENTE: 
                    case SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA: 
                    case SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE: 
                    case SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA: 
                    case SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE: {
                        return msg.getDescrizioneRawValue();
                    }
                    case ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO: {
                        return msg.getDescrizioneRawValue();
                    }
                    case FORMATO_NON_CORRETTO: {
                        return msg.getDescrizioneRawValue();
                    }
                }
                return msg.getDescrizioneRawValue();
            }
            return msg.getDescrizioneRawValue();
        }
        catch (Exception e) {
            this.log.error("Errore durante la trasformazione del messaggio di cooperazione: " + e.getMessage(), (Throwable)e);
            return msg.getDescrizioneRawValue();
        }
    }

    public String getDate_protocolFormat() {
        return this.getDate_protocolFormat(null);
    }

    public String getDate_protocolFormat(Date date) {
        return SPCoopUtils.getDate_eGovFormat(date);
    }

    public String getIdentificativoPortaDefault(IDSoggetto soggetto) {
        if ("SPC".equalsIgnoreCase(soggetto.getTipo())) {
            return soggetto.getNome() + "SPCoopIT";
        }
        if ("AOO".equalsIgnoreCase(soggetto.getTipo())) {
            return "PDD" + soggetto.getNome();
        }
        return soggetto.getNome() + "PdD" + soggetto.getTipo();
    }

    public String toString(Inoltro inoltro) {
        switch (inoltro) {
            case CON_DUPLICATI: {
                return "EGOV_IT_PIUDIUNAVOLTA";
            }
            case SENZA_DUPLICATI: {
                return "EGOV_IT_ALPIUUNAVOLTA";
            }
        }
        return "SCONOSCIUTO";
    }

    public String toString(ProfiloDiCollaborazione profilo) {
        switch (profilo) {
            case ONEWAY: {
                return "EGOV_IT_MessaggioSingoloOneWay";
            }
            case SINCRONO: {
                return "EGOV_IT_ServizioSincrono";
            }
            case ASINCRONO_SIMMETRICO: {
                return "EGOV_IT_ServizioAsincronoSimmetrico";
            }
            case ASINCRONO_ASIMMETRICO: {
                return "EGOV_IT_ServizioAsincronoAsimmetrico";
            }
        }
        return "SCONOSCIUTO";
    }

    public String toString(TipoOraRegistrazione tipo) {
        switch (tipo) {
            case LOCALE: {
                return "EGOV_IT_Locale";
            }
            case SINCRONIZZATO: {
                return "EGOV_IT_SPC";
            }
        }
        return "SCONOSCIUTO";
    }

    public String toString(LivelloRilevanza rilevanza) {
        switch (rilevanza) {
            case DEBUG: {
                return "LIEVE";
            }
            case INFO: {
                return "INFO";
            }
            case WARN: {
                return "LIEVE";
            }
            case ERROR: {
                return "GRAVE";
            }
            case FATAL: {
                return "GRAVE";
            }
        }
        return "SCONOSCIUTO";
    }

    public LivelloRilevanza toLivelloRilevanza(String livelloRilevanza) {
        if (livelloRilevanza == null) {
            return LivelloRilevanza.UNKNOWN;
        }
        if (livelloRilevanza.equals("LIEVE")) {
            return LivelloRilevanza.DEBUG;
        }
        if (livelloRilevanza.equals("INFO")) {
            return LivelloRilevanza.INFO;
        }
        if (livelloRilevanza.equals("GRAVE")) {
            return LivelloRilevanza.ERROR;
        }
        return LivelloRilevanza.UNKNOWN;
    }

    public Inoltro toInoltro(String inoltro) {
        if (inoltro == null) {
            return Inoltro.UNKNOWN;
        }
        if (inoltro.equals("EGOV_IT_ALPIUUNAVOLTA")) {
            return Inoltro.SENZA_DUPLICATI;
        }
        if (inoltro.equals("EGOV_IT_PIUDIUNAVOLTA")) {
            return Inoltro.CON_DUPLICATI;
        }
        return Inoltro.UNKNOWN;
    }

    public TipoOraRegistrazione toTipoOraRegistrazione(String tipoOraRegistrazione) {
        if (tipoOraRegistrazione == null) {
            return TipoOraRegistrazione.UNKNOWN;
        }
        if (tipoOraRegistrazione.equals("EGOV_IT_Locale")) {
            return TipoOraRegistrazione.LOCALE;
        }
        if (tipoOraRegistrazione.equals("EGOV_IT_SPC")) {
            return TipoOraRegistrazione.SINCRONIZZATO;
        }
        return TipoOraRegistrazione.UNKNOWN;
    }

    public ProfiloDiCollaborazione toProfiloDiCollaborazione(String profiloDiCollaborazione) {
        if (profiloDiCollaborazione == null) {
            return ProfiloDiCollaborazione.UNKNOWN;
        }
        if (profiloDiCollaborazione.equals("EGOV_IT_MessaggioSingoloOneWay")) {
            return ProfiloDiCollaborazione.ONEWAY;
        }
        if (profiloDiCollaborazione.equals("EGOV_IT_ServizioSincrono")) {
            return ProfiloDiCollaborazione.SINCRONO;
        }
        if (profiloDiCollaborazione.equals("EGOV_IT_ServizioAsincronoSimmetrico")) {
            return ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO;
        }
        if (profiloDiCollaborazione.equals("EGOV_IT_ServizioAsincronoAsimmetrico")) {
            return ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO;
        }
        return ProfiloDiCollaborazione.UNKNOWN;
    }

    public String toString(ContestoCodificaEccezione contesto) {
        switch (contesto) {
            case INTESTAZIONE: {
                return "ErroreIntestazioneMessaggioSPCoop";
            }
            case PROCESSAMENTO: {
                return "ErroreProcessamentoMessaggioSPCoop";
            }
        }
        return "ErroreIntestazioneMessaggioSPCoop";
    }

    public ContestoCodificaEccezione toContestoCodificaEccezione(String contestoCodificaEccezione) {
        if ("ErroreIntestazioneMessaggioSPCoop".equals(contestoCodificaEccezione)) {
            return ContestoCodificaEccezione.INTESTAZIONE;
        }
        return ContestoCodificaEccezione.PROCESSAMENTO;
    }

    protected String getIdentificativoCodiceIPA_Nome(IDSoggetto idSoggetto) {
        String soggetto = null;
        soggetto = "SPC".equals(idSoggetto.getTipo()) ? idSoggetto.getNome() : idSoggetto.toString();
        return soggetto;
    }
}

