/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolVersionManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProtocolManager;

public class SPCoopProtocolVersionManager
extends SPCoopProtocolManager
implements IProtocolVersionManager {
    protected String versione;

    public SPCoopProtocolVersionManager(IProtocolFactory protocolFactory, String versione) throws ProtocolException {
        super(protocolFactory);
        this.versione = versione;
    }

    public StatoFunzionalitaProtocollo getFiltroDuplicati(ProfiloDiCollaborazione profiloCollaborazione) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.ABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getConsegnaAffidabile(ProfiloDiCollaborazione profiloCollaborazione) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.DISABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getConsegnaInOrdine(ProfiloDiCollaborazione profiloCollaborazione) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.DISABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getCollaborazione(ProfiloDiCollaborazione profiloCollaborazione) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            if (profiloCollaborazione == null || ProfiloDiCollaborazione.UNKNOWN.equals(profiloCollaborazione)) {
                return StatoFunzionalitaProtocollo.REGISTRO;
            }
            if (profiloCollaborazione.equals(ProfiloDiCollaborazione.ONEWAY) || profiloCollaborazione.equals(ProfiloDiCollaborazione.SINCRONO)) {
                return StatoFunzionalitaProtocollo.DISABILITATA;
            }
            return StatoFunzionalitaProtocollo.ABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public boolean isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public String getIdCorrelazioneAsincrona(Busta richiesta) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return richiesta.getCollaborazione();
        }
        return richiesta.getRiferimentoMessaggio();
    }

    public String getIdCorrelazioneAsincrona(String rifMsg, String collaborazione) {
        if ("eGov1.1-lineeGuida1.1".equalsIgnoreCase(this.versione)) {
            if (rifMsg != null) {
                return rifMsg;
            }
            if (collaborazione != null) {
                return collaborazione;
            }
        } else {
            return rifMsg;
        }
        return null;
    }

    public boolean isEccezioniLivelloInfoAbilitato() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isIgnoraEccezioniLivelloNonGrave() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneBusteErrore_strutturaMalformataHeaderProtocollo() {
        return this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo();
    }

    public boolean isGenerazioneErroreMessaggioOnewayDuplicato() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isUtilizzoIndirizzoSoggettoPresenteBusta() {
        return !"eGov1.1-lineeGuida1.1".equalsIgnoreCase(this.versione);
    }
}

