/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SOAPFaultIntegrationGenericInfoMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProperties;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStreamParams;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportRequestContext;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportResponseContext;
import java.util.Map;
import org.slf4j.Logger;

public class SPCoopProtocolManager
implements IProtocolManager {
    protected SPCoopProperties spcoopProperties = null;
    protected IProtocolFactory protocolFactory = null;
    protected Logger logger = null;

    public SPCoopProtocolManager(IProtocolFactory protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.logger = this.protocolFactory.getLogger();
        this.spcoopProperties = SPCoopProperties.getInstance(this.logger);
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public boolean isBustaServizio(Busta busta) {
        return busta.getServizio() == null && busta.getRiferimentoMessaggio() == null;
    }

    public String getKeywordTipoMittenteSconosciuto() {
        return this.spcoopProperties.getKeywordTipoMittenteSconosciuto();
    }

    public String getKeywordMittenteSconosciuto() {
        return this.spcoopProperties.getKeywordMittenteSconosciuto();
    }

    public long getIntervalloScadenzaBuste() {
        try {
            return this.spcoopProperties.getIntervalloScadenzaBuste();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        return this.spcoopProperties.isGenerazioneElementiNonValidabiliRispettoXSD();
    }

    public boolean isIgnoraEccezioniNonGravi() {
        return this.spcoopProperties.isIgnoraEccezioniNonGravi();
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return this.spcoopProperties.isGenerazioneListaEccezioniErroreProcessamento();
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocollo_EccezioneValidazione() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolValidazione();
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolloConStackTrace() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegratione_erroreServer() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationServerError();
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegratione_erroreClient() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationClientError();
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationeConStackTrace() {
        return this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
    }

    public SOAPFaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsSOAPFaultIntegrazione() {
        Boolean value = this.spcoopProperties.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
        if (value == null) {
            return SOAPFaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
        }
        if (value.booleanValue()) {
            return SOAPFaultIntegrationGenericInfoMode.ABILITATO;
        }
        return SOAPFaultIntegrationGenericInfoMode.DISABILITATO;
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        return this.spcoopProperties.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        return this.spcoopProperties.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
    }

    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        return null;
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageRequest(SOAPVersion soapVersion, OpenSPCoop2Message msg, Busta busta) throws ProtocolException {
        return msg;
    }

    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(SOAPVersion soapVersion, OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext) throws ProtocolException {
        return msg;
    }

    public boolean isHttpEmptyResponseOneWay() {
        return this.spcoopProperties.isHttpEmptyResponseOneWay();
    }

    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        return this.spcoopProperties.getHttpReturnCodeEmptyResponseOneWay();
    }

    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        return this.spcoopProperties.isHttpOneWay_PD_HTTPEmptyResponse();
    }

    public boolean isBlockedTransaction_responseMessageWithTransportCodeError() {
        return this.spcoopProperties.isResponseMessageWithTransportCodeError_blockedTransaction();
    }
}

