/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CostantiProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopInstanceProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;

public class SPCoopProperties {
    private Logger log = null;
    private static SPCoopProperties spcoopProperties = null;
    private SPCoopInstanceProperties reader;
    private static String tipoSeriale_IdentificativoBusta = null;
    private static Integer prefissoSeriale_IdentificativoBusta = null;
    private static Boolean isHttpEmptyResponseOneWay = null;
    private static Integer getHttpReturnCodeEmptyResponseOneWay = null;
    private static Boolean isHttpOneWay_PD_HTTPEmptyResponse = null;
    private static Boolean isResponseMessageWithTransportCodeError_blockedTransaction = null;
    private static Boolean isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = null;
    private static Boolean isGenerazioneBustaErrore_actorScorretto = null;
    private static Long intervalloScadenzaBuste = null;
    private static Integer dateFutureIntervalloTolleranza = null;
    private static Boolean repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = null;
    private static String getKeywordTipoMittenteSconosciuto = null;
    private static String getKeywordMittenteSconosciuto = null;
    private static String getSchemaXSDValidazioneXSDBusta = null;
    private static String[] schemiImportatiValidazioneXSDBusta = null;
    private static Boolean isGenerazioneElementiNonValidabiliRispettoXSD = null;
    private static Boolean isBustaErrore_EccezioniNonGravi = null;
    private static Boolean isGenerazioneListaEccezioniErroreProcessamento = null;
    private static String roleRichiestaManifest = null;
    private static String roleRispostaManifest = null;
    private static String roleAllegatoManifest = null;
    private static Boolean generateManifestAttachmentsIdWithBrackets = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolValidazione = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = null;
    private static Boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationServerError = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationClientError = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
    private static Boolean isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
    private static Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = null;

    public SPCoopProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger((String)"SPCoopProperties");
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = SPCoopProperties.class.getResourceAsStream("/spcoopMigrazione.properties");
            if (properties == null) {
                throw new Exception("File '/spcoopMigrazione.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'spcoop.properties': " + e.getMessage());
            throw new ProtocolException("SPCoopProperties initialize error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.reader = new SPCoopInstanceProperties(confDir, propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log) throws ProtocolException {
        if (spcoopProperties == null) {
            spcoopProperties = new SPCoopProperties(confDir, log);
        }
    }

    public static SPCoopProperties getInstance(Logger log) throws ProtocolException {
        if (spcoopProperties == null) {
            throw new ProtocolException("SPCoopProperties not initialized (use init method in factory)");
        }
        return spcoopProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            int prefix;
            String tipo = this.getTipoSeriale_IdentificativoBusta();
            if (!("db".equals(tipo) || CostantiProtocollo.IDENTIFICATIVO_SERIALE_MYSQL.equals(tipo) || "static".equals(tipo))) {
                String msg = "Riscontrato errore durante la lettura della proprieta': 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.tipo': tipo non gestito";
                this.log.error(msg);
                throw new ProtocolException(msg);
            }
            if ("static".equals(tipo) && (prefix = this.getPrefissoSeriale_IdentificativoBusta()) > 99) {
                String msg = "Riscontrato errore durante la lettura della proprieta': 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.prefix': massima lunghezza del prefisso e' di due cifre";
                this.log.error(msg);
                throw new ProtocolException(msg);
            }
            this.isHttpEmptyResponseOneWay();
            this.getHttpReturnCodeEmptyResponseOneWay();
            this.isHttpOneWay_PD_HTTPEmptyResponse();
            this.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo();
            this.isGenerazioneBustaErrore_actorScorretto();
            this.getIntervalloScadenzaBuste();
            this.isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione();
            this.getIntervalloMinutiTolleranzaDateFuture();
            this.getKeywordTipoMittenteSconosciuto();
            this.getKeywordMittenteSconosciuto();
            this.getSchemaXSDValidazioneXSDBusta();
            this.getSchemiXSDImportatiValidazioneXSDBusta();
            this.isGenerazioneElementiNonValidabiliRispettoXSD();
            this.isIgnoraEccezioniNonGravi();
            this.isGenerazioneListaEccezioniErroreProcessamento();
            this.getRoleRichiestaManifest();
            this.getRoleRispostaManifest();
            this.getRoleAllegatoManifest();
            this.isGenerazioneDetailsSOAPFaultProtocolValidazione();
            this.isGenerazioneDetailsSOAPFaultProtocolProcessamento();
            this.isGenerazioneDetailsSOAPFaultProtocolWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche();
            this.isGenerazioneDetailsSOAPFaultIntegrationServerError();
            this.isGenerazioneDetailsSOAPFaultIntegrationClientError();
            this.isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace();
            this.isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche();
            this.isAggiungiDetailErroreApplicativo_SoapFaultApplicativo();
            this.isAggiungiDetailErroreApplicativo_SoapFaultPdD();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' del protocollo SPCoop, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, (Throwable)e);
        }
    }

    public String getTipoSeriale_IdentificativoBusta() throws ProtocolException {
        if (tipoSeriale_IdentificativoBusta == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.tipo");
                if (name == null) {
                    throw new Exception("proprieta non definita");
                }
                tipoSeriale_IdentificativoBusta = name != null ? name.trim() : null;
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.tipo': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return tipoSeriale_IdentificativoBusta;
    }

    public int getPrefissoSeriale_IdentificativoBusta() throws ProtocolException {
        if (prefissoSeriale_IdentificativoBusta == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.prefix");
                prefissoSeriale_IdentificativoBusta = name != null ? Integer.valueOf(Integer.parseInt(name.trim())) : Integer.valueOf(-1);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.id.prefix': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return prefissoSeriale_IdentificativoBusta;
    }

    public boolean isHttpEmptyResponseOneWay() {
        if (isHttpEmptyResponseOneWay == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse");
                if (value != null) {
                    value = value.trim();
                    isHttpEmptyResponseOneWay = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse' non impostata, viene utilizzato il default=true");
                    isHttpEmptyResponseOneWay = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isHttpEmptyResponseOneWay = true;
            }
        }
        return isHttpEmptyResponseOneWay;
    }

    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        if (getHttpReturnCodeEmptyResponseOneWay == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.returnCode");
                if (value != null) {
                    getHttpReturnCodeEmptyResponseOneWay = Integer.parseInt(value = value.trim());
                    if (getHttpReturnCodeEmptyResponseOneWay != 200 && getHttpReturnCodeEmptyResponseOneWay != 202) {
                        throw new Exception("Unici valori ammessi sono 200 o 202, trovato [" + getHttpReturnCodeEmptyResponseOneWay + "]");
                    }
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.returnCode' non impostata, viene utilizzato il default=200");
                    getHttpReturnCodeEmptyResponseOneWay = 200;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.returnCode' non impostata, viene utilizzato il default=200, errore: " + e.getMessage());
                getHttpReturnCodeEmptyResponseOneWay = 200;
            }
        }
        return getHttpReturnCodeEmptyResponseOneWay;
    }

    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        if (isHttpOneWay_PD_HTTPEmptyResponse == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable");
                if (value != null) {
                    value = value.trim();
                    isHttpOneWay_PD_HTTPEmptyResponse = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true");
                    isHttpOneWay_PD_HTTPEmptyResponse = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.oneway.httpEmptyResponse.bodyEmptyWithHeader.enable' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isHttpOneWay_PD_HTTPEmptyResponse = true;
            }
        }
        return isHttpOneWay_PD_HTTPEmptyResponse;
    }

    public boolean isResponseMessageWithTransportCodeError_blockedTransaction() {
        if (isResponseMessageWithTransportCodeError_blockedTransaction == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction");
                if (value != null) {
                    value = value.trim();
                    isResponseMessageWithTransportCodeError_blockedTransaction = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction' non impostata, viene utilizzato il default=true");
                    isResponseMessageWithTransportCodeError_blockedTransaction = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.responseMessageWithTransportCodeError.blockedTransaction' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isResponseMessageWithTransportCodeError_blockedTransaction = true;
            }
        }
        return isResponseMessageWithTransportCodeError_blockedTransaction;
    }

    public boolean isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo() {
        if (isGenerazioneBustaErrore_strutturaMalformataHeaderBusta == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta' non impostata, viene utilizzato il default=false");
                    isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.generazioneBustaRisposta' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneBustaErrore_strutturaMalformataHeaderBusta = false;
            }
        }
        return isGenerazioneBustaErrore_strutturaMalformataHeaderBusta;
    }

    public boolean isGenerazioneBustaErrore_actorScorretto() {
        if (isGenerazioneBustaErrore_actorScorretto == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneBustaErrore_actorScorretto = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta' non impostata, viene utilizzato il default=true");
                    isGenerazioneBustaErrore_actorScorretto = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.strutturaHeaderNonCorretta.actorNonCorretto.generazioneBustaRisposta' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneBustaErrore_actorScorretto = true;
            }
        }
        return isGenerazioneBustaErrore_actorScorretto;
    }

    public long getIntervalloScadenzaBuste() throws ProtocolException {
        if (intervalloScadenzaBuste == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.scadenzaMessaggio");
                if (name == null) {
                    throw new Exception("non definita");
                }
                intervalloScadenzaBuste = Long.parseLong(name = name.trim());
                if (intervalloScadenzaBuste <= 0L && intervalloScadenzaBuste != -1L) {
                    throw new Exception("Valore non valido [" + intervalloScadenzaBuste + "].");
                }
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.scadenzaMessaggio': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, (Throwable)e);
            }
        }
        return intervalloScadenzaBuste;
    }

    public int getIntervalloMinutiTolleranzaDateFuture() {
        if (dateFutureIntervalloTolleranza == null) {
            try {
                String name = null;
                name = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.date.intervalloTolleranza");
                if (name != null) {
                    name = name.trim();
                    dateFutureIntervalloTolleranza = Integer.parseInt(name);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.date.intervalloTolleranza' non impostata, viene utilizzato il default=-1 (accettate qualsiasi date future)");
                    dateFutureIntervalloTolleranza = -1;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.date.intervalloTolleranza' non impostata, viene utilizzato il default=-1 (accettate qualsiasi date future): " + e.getMessage());
                dateFutureIntervalloTolleranza = -1;
            }
        }
        return dateFutureIntervalloTolleranza;
    }

    public boolean isCheckTolleranzaDateFutureAttivo() {
        return this.getIntervalloMinutiTolleranzaDateFuture() > 0;
    }

    public boolean isRepositoryBusteFiltraBusteScaduteRispettoOraRegistrazione() {
        if (repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione");
                if (value == null) {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione' non definita (Viene utilizzato il default:true)");
                    repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = true;
                } else {
                    repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = Boolean.parseBoolean(value);
                }
            }
            catch (Exception e) {
                this.log.warn("Riscontrato errore durante la lettura della proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.scadenzaMessaggio.filtraBusteScaduteRispettoOraRegistrazione' (Viene utilizzato il default:true): " + e.getMessage());
                repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione = true;
            }
        }
        return repositoryBusteFiltraBusteScaduteRispettoOraRegistrazione;
    }

    public String getKeywordTipoMittenteSconosciuto() {
        if (getKeywordTipoMittenteSconosciuto == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.tipo");
                if (value != null) {
                    getKeywordTipoMittenteSconosciuto = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.tipo' non impostata, viene utilizzato il default=Sconosciuto");
                    getKeywordTipoMittenteSconosciuto = "Sconosciuto";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.tipo' non impostata, viene utilizzato il default=Sconosciuto, errore:" + e.getMessage());
                getKeywordTipoMittenteSconosciuto = "Sconosciuto";
            }
        }
        return getKeywordTipoMittenteSconosciuto;
    }

    public String getKeywordMittenteSconosciuto() {
        if (getKeywordMittenteSconosciuto == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.nome");
                if (value != null) {
                    getKeywordMittenteSconosciuto = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.nome' non impostata, viene utilizzato il default=Sconosciuto");
                    getKeywordMittenteSconosciuto = "Sconosciuto";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.mittenteSconosciuto.nome' non impostata, viene utilizzato il default=Sconosciuto, errore:" + e.getMessage());
                getKeywordMittenteSconosciuto = "Sconosciuto";
            }
        }
        return getKeywordMittenteSconosciuto;
    }

    public String getSchemaXSDValidazioneXSDBusta() {
        if (getSchemaXSDValidazioneXSDBusta == null) {
            String defaultSchema = "Busta.xsd";
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schema");
                if (value != null) {
                    getSchemaXSDValidazioneXSDBusta = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schema' non impostata, viene utilizzato il default=[" + defaultSchema + "]");
                    getSchemaXSDValidazioneXSDBusta = defaultSchema;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schema' non impostata, viene utilizzato il default=[" + defaultSchema + "], errore:" + e.getMessage());
                getSchemaXSDValidazioneXSDBusta = defaultSchema;
            }
        }
        return getSchemaXSDValidazioneXSDBusta;
    }

    public String[] getSchemiXSDImportatiValidazioneXSDBusta() {
        String defaults = "soapEnvelope.xsd,wssecurityUtility.xsd";
        String[] arrayDefault = new String[]{"soapEnvelope.xsd", "wssecurityUtility.xsd"};
        if (schemiImportatiValidazioneXSDBusta == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schemiImportati");
                if (value != null) {
                    schemiImportatiValidazioneXSDBusta = (value = value.trim()).split(",");
                    if (schemiImportatiValidazioneXSDBusta == null || schemiImportatiValidazioneXSDBusta.length <= 0) {
                        throw new Exception("schemi non definiti");
                    }
                    for (int i = 0; i < schemiImportatiValidazioneXSDBusta.length; ++i) {
                        SPCoopProperties.schemiImportatiValidazioneXSDBusta[i] = schemiImportatiValidazioneXSDBusta[i].trim();
                    }
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schemiImportati' non impostata, viene utilizzato il default=" + defaults);
                    schemiImportatiValidazioneXSDBusta = arrayDefault;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validazione_xsd.schemiImportati' non impostata, viene utilizzato il default=" + defaults + ", errore:" + e.getMessage());
                schemiImportatiValidazioneXSDBusta = arrayDefault;
            }
        }
        return schemiImportatiValidazioneXSDBusta;
    }

    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        if (isGenerazioneElementiNonValidabiliRispettoXSD == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneElementiNonValidabiliRispettoXSD = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD' non impostata, viene utilizzato il default=false");
                    isGenerazioneElementiNonValidabiliRispettoXSD = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneElementiNonValidabiliRispettoXSD' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneElementiNonValidabiliRispettoXSD = false;
            }
        }
        return isGenerazioneElementiNonValidabiliRispettoXSD;
    }

    public boolean isIgnoraEccezioniNonGravi() {
        if (isBustaErrore_EccezioniNonGravi == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable");
                if (value != null) {
                    value = value.trim();
                    isBustaErrore_EccezioniNonGravi = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable' non impostata, viene utilizzato il default=false");
                    isBustaErrore_EccezioniNonGravi = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.bustaErrore.ignoraEccezioniNonGravi.enable' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isBustaErrore_EccezioniNonGravi = false;
            }
        }
        return isBustaErrore_EccezioniNonGravi;
    }

    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        if (isGenerazioneListaEccezioniErroreProcessamento == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneListaEccezioniErroreProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni' non impostata, viene utilizzato il default=false");
                    isGenerazioneListaEccezioniErroreProcessamento = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.eccezioneProcessamento.generazioneListaEccezioni' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneListaEccezioniErroreProcessamento = false;
            }
        }
        return isGenerazioneListaEccezioniErroreProcessamento;
    }

    public String getRoleRichiestaManifest() {
        if (roleRichiestaManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.richiesta");
                if (value != null) {
                    roleRichiestaManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta");
                    roleRichiestaManifest = "Richiesta";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Richiesta, errore:" + e.getMessage());
                roleRichiestaManifest = "Richiesta";
            }
        }
        return roleRichiestaManifest;
    }

    public String getRoleRispostaManifest() {
        if (roleRispostaManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.risposta");
                if (value != null) {
                    roleRispostaManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta");
                    roleRispostaManifest = "Risposta";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.risposta' non impostata, viene utilizzato il default=Risposta, errore:" + e.getMessage());
                roleRispostaManifest = "Risposta";
            }
        }
        return roleRispostaManifest;
    }

    public String getRoleAllegatoManifest() {
        if (roleAllegatoManifest == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.allegato");
                if (value != null) {
                    roleAllegatoManifest = value = value.trim();
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato");
                    roleAllegatoManifest = "Allegato";
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.role.richiesta' non impostata, viene utilizzato il default=Allegato, errore:" + e.getMessage());
                roleAllegatoManifest = "Allegato";
            }
        }
        return roleAllegatoManifest;
    }

    public boolean isGenerateManifestAttachmentsIdWithBrackets() {
        if (generateManifestAttachmentsIdWithBrackets == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.id.brackets");
                if (value != null) {
                    value = value.trim();
                    generateManifestAttachmentsIdWithBrackets = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.id.brackets' non impostata, viene utilizzato il default=false");
                    generateManifestAttachmentsIdWithBrackets = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.manifestAttachments.id.brackets' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                generateManifestAttachmentsIdWithBrackets = false;
            }
        }
        return generateManifestAttachmentsIdWithBrackets;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolValidazione() {
        if (isGenerazioneDetailsSOAPFaultProtocolValidazione == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolValidazione = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneIntestazione' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolValidazione = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolValidazione;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolProcessamento() {
        if (isGenerazioneDetailsSOAPFaultProtocolProcessamento == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolProcessamento = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.eccezioneProcessamento' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolProcessamento = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolProcessamento;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolWithStackTrace() {
        if (isGenerazioneDetailsSOAPFaultProtocolWithStackTrace == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolWithStackTrace = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolWithStackTrace;
    }

    public boolean isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche() {
        if (isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.protocol.informazioniGeneriche' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultProtocolConInformazioniGeneriche;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationServerError() {
        if (isGenerazioneDetailsSOAPFaultIntegrationServerError == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationServerError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true");
                    isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.serverError' non impostata, viene utilizzato il default=true, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationServerError = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationServerError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationClientError() {
        if (isGenerazioneDetailsSOAPFaultIntegrationClientError == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationClientError = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.clientError' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationClientError = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationClientError;
    }

    public boolean isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace() {
        if (isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = Boolean.parseBoolean(value);
                } else {
                    this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false");
                    isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
                }
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.stackTrace' non impostata, viene utilizzato il default=false, errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace = false;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationWithStackTrace;
    }

    public Boolean isGenerazioneDetailsSOAPFaultIntegrazionConInformazioniGeneriche() {
        if (isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche");
                if (value != null) {
                    value = value.trim();
                    isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode)");
                    isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                }
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.generazioneDetailsSoapFault.integration.informazioniGeneriche' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultAsGenericCode), errore:" + e.getMessage());
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche = null;
                isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGenericheRead = true;
            }
        }
        return isGenerazioneDetailsSOAPFaultIntegrationConInformazioniGeneriche;
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        if (isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails");
                if (value != null) {
                    value = value.trim();
                    isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails)");
                    isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
                }
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultApplicativo.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultApplicativo.enrichDetails), errore:" + e.getMessage());
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativo = null;
                isAggiungiDetailErroreApplicativo_SoapFaultApplicativoRead = true;
            }
        }
        return isAggiungiDetailErroreApplicativo_SoapFaultApplicativo;
    }

    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        if (isAggiungiDetailErroreApplicativo_SoapFaultPdDRead == null) {
            try {
                String value = this.reader.getValue_convertEnvProperties("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails");
                if (value != null) {
                    value = value.trim();
                    isAggiungiDetailErroreApplicativo_SoapFaultPdD = Boolean.parseBoolean(value);
                } else {
                    this.log.debug("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails)");
                    isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
                }
                isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
            catch (Exception e) {
                this.log.warn("Proprieta' di openspcoop 'it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.erroreApplicativo.faultPdD.enrichDetails' non impostata, viene utilizzato il default associato al Servizio Applicativo (faultPdD.enrichDetails), errore:" + e.getMessage());
                isAggiungiDetailErroreApplicativo_SoapFaultPdD = null;
                isAggiungiDetailErroreApplicativo_SoapFaultPdDRead = true;
            }
        }
        return isAggiungiDetailErroreApplicativo_SoapFaultPdD;
    }
}

