/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator.SPCoopValidazioneSintattica;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SPCoopSbustamento {
    private Logger log;
    private IProtocolFactory protocolFactory;
    private SPCoopValidazioneSintattica validazioneSintattica = null;
    private AbstractXMLUtils xmlUtils = null;
    private SPCoopProperties spcoopProperties = null;

    public SPCoopSbustamento(IProtocolFactory protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = protocolFactory.getLogger();
        this.spcoopProperties = SPCoopProperties.getInstance(this.log);
        this.validazioneSintattica = (SPCoopValidazioneSintattica)this.protocolFactory.createValidazioneSintattica();
        this.xmlUtils = XMLUtils.getInstance();
    }

    public SOAPHeaderElement sbustamentoEGov(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        SOAPHeader headerSOAP = null;
        SOAPHeaderElement header = null;
        try {
            this.validazioneSintattica.setMsg((SOAPMessage)msg);
            this.validazioneSintattica.setReadQualifiedAttribute(proprietaManifestAttachments.isReadQualifiedAttribute());
            headerSOAP = msg.getSOAPHeader();
            header = this.validazioneSintattica.getHeaderEGov(headerSOAP);
            if (header == null) {
                throw new Exception("Header eGov non presente");
            }
            msg.removeHeaderElement(headerSOAP, header);
            if (proprietaManifestAttachments.isGestioneManifest() && msg.countAttachments() > 0) {
                this.remove_eGovManifest(msg, proprietaManifestAttachments);
            }
            SOAPHeaderElement sOAPHeaderElement = header;
            return sOAPHeaderElement;
        }
        catch (Exception e) {
            this.log.error("SbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("SbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.validazioneSintattica != null) {
                this.validazioneSintattica.setHeaderSOAP(null);
            }
            headerSOAP = null;
            header = null;
        }
    }

    public OpenSPCoop2Message remove_eGovManifest(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            SOAPBody body = msg.getSOAPBody();
            SOAPElement descrizione = (SOAPElement)msg.getFirstChildElement((SOAPElement)body);
            Iterator it = descrizione.getChildElements();
            String idMsg = null;
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof SOAPElement)) continue;
                SOAPElement descrizioneMessaggio = (SOAPElement)element;
                SOAPElement riferimento = (SOAPElement)msg.getFirstChildElement(descrizioneMessaggio);
                if (riferimento.getAttribute("role").equalsIgnoreCase(this.spcoopProperties.getRoleRichiestaManifest())) {
                    idMsg = riferimento.getAttribute("href");
                    break;
                }
                if (!riferimento.getAttribute("role").equalsIgnoreCase(this.spcoopProperties.getRoleRispostaManifest())) continue;
                idMsg = riferimento.getAttribute("href");
                break;
            }
            if (idMsg == null) {
                throw new Exception("DescrizioneMessaggio con ruolo " + this.spcoopProperties.getRoleRichiestaManifest() + " o " + this.spcoopProperties.getRoleRispostaManifest() + " non trovato.");
            }
            if (idMsg.startsWith("cid:")) {
                idMsg = idMsg.substring("cid:".length());
            }
            MimeHeaders mhs = new MimeHeaders();
            mhs.addHeader("Content-ID", idMsg);
            AttachmentPart ap = (AttachmentPart)msg.getAttachments(mhs).next();
            msg.removeAttachments(mhs);
            DataHandler dh = ap.getDataHandler();
            msg.getSOAPBody().removeContents();
            InputStream inputDH = dh.getInputStream();
            byte[] bytePotenzialiXML = new byte[5];
            int readByte = inputDH.read(bytePotenzialiXML);
            boolean xmlContentPresente = false;
            if (readByte == 5 && (char)bytePotenzialiXML[0] == '<' && (char)bytePotenzialiXML[1] == '?' && (char)bytePotenzialiXML[2] == 'x' && (char)bytePotenzialiXML[3] == 'm' && (char)bytePotenzialiXML[4] == 'l') {
                readByte = inputDH.read();
                while ((char)readByte != '>' && readByte != -1) {
                    readByte = inputDH.read();
                }
                if ((char)readByte == '>') {
                    xmlContentPresente = true;
                }
            }
            if (readByte == -1) {
                return msg;
            }
            InputStream isBody = null;
            isBody = !xmlContentPresente ? dh.getInputStream() : inputDH;
            Vector<InputStream> iss = new Vector<InputStream>();
            iss.add(new ByteArrayInputStream("<OpenSPCoopWrapper>".getBytes()));
            iss.add(isBody);
            iss.add(new ByteArrayInputStream("</OpenSPCoopWrapper>".getBytes()));
            SequenceInputStream is = new SequenceInputStream(iss.elements());
            Document doc = this.xmlUtils.newDocument((InputStream)is);
            NodeList nl = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    Element element = (Element)n;
                    if ("SoapBodyEmpty".equals(element.getLocalName()) && "http://www.openspcoop2.org/spcoop/manifest/body".equals(element.getNamespaceURI())) continue;
                    msg.getSOAPBody().addChildElement(SoapUtils.getSoapFactory((SOAPVersion)SOAPVersion.SOAP11).createElement(element));
                }
                if (!(n instanceof Text)) continue;
                msg.getSOAPBody().addTextNode(n.getTextContent());
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public byte[] removeSPCoop(byte[] header) throws ProtocolException {
        ByteArrayOutputStream reqByteSbustata = null;
        try {
            int indexOfEGov;
            String headerSTR = new String(header);
            int endIntestazione = 0;
            int start = 0;
            while ((indexOfEGov = headerSTR.indexOf("http://www.cnipa.it/eGov_it/portadominio", start)) != -1) {
                StringBuffer rovesciata = new StringBuffer();
                for (int i = indexOfEGov - 1; i > 0; --i) {
                    rovesciata.append((char)header[i]);
                    if ((char)header[i] != '<') continue;
                    start = i;
                    break;
                }
                StringBuffer rigaCompleta = new StringBuffer();
                rovesciata.reverse();
                rigaCompleta.append(rovesciata.toString());
                rigaCompleta.append("http://www.cnipa.it/eGov_it/portadominio");
                for (int i = indexOfEGov + "http://www.cnipa.it/eGov_it/portadominio".length(); i < header.length; ++i) {
                    rigaCompleta.append((char)header[i]);
                    if ((char)header[i] == '>') break;
                }
                if (rigaCompleta.toString().indexOf("Intestazione") != -1) {
                    endIntestazione = start - 1 + rigaCompleta.length();
                    break;
                }
                start = start - 1 + rigaCompleta.length();
            }
            if (start == 0) {
                return null;
            }
            int end = headerSTR.indexOf("Intestazione>", endIntestazione) + "Intestazione>".length();
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            reqByteSbustata = new ByteArrayOutputStream();
            for (int i = 0; i < start; ++i) {
                reqByteSbustata.write(header[i]);
            }
            boolean eraserSpaziDopoEGov = false;
            for (int i = end; i < header.length; ++i) {
                if (!eraserSpaziDopoEGov && (char)header[i] == '<') {
                    eraserSpaziDopoEGov = true;
                    reqByteSbustata.write(header[i]);
                    continue;
                }
                if (!eraserSpaziDopoEGov) continue;
                reqByteSbustata.write(header[i]);
            }
            byte[] bustaSenzaEGov = reqByteSbustata.toByteArray();
            reqByteSbustata.close();
            return bustaSenzaEGov;
        }
        catch (Exception e) {
            try {
                reqByteSbustata.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error("RimozioneHeaderSPCoop non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("RimozioneHeaderSPCoop non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public SOAPHeaderElement sbustamento(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        return this.sbustamentoEGov(msg, proprietaManifestAttachments);
    }
}

