/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ConfigurazionePdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Riscontro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.config.SPCoopProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.utils.SPCoopUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator.SPCoopValidazioneSemantica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.validator.SPCoopValidazioneSintattica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.IDSerialGenerator;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorParameter;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorType;
import it.link.pdd.tools.migrazione_govway.utils.resources.DataContentHandlerManager;
import it.link.pdd.tools.migrazione_govway.utils.resources.InputStreamDataSource;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class SPCoopImbustamento {
    private IProtocolFactory factory;
    private Logger log;
    private SPCoopProperties spcoopProperties = null;
    private List<String> tipiSoggetti = null;
    private List<String> tipiServizi = null;
    private SPCoopValidazioneSemantica validazioneSemantica = null;
    private SPCoopValidazioneSintattica validazioneSintattica = null;
    private AbstractXMLUtils xmlUtils = null;
    private ITraduttore traduttore = null;
    private IProtocolManager protocolManager = null;
    private static int maxSeriale = 0;
    private static int prefixLenght = 0;
    private static int serialCounter = 0;

    public SPCoopImbustamento(IProtocolFactory factory) throws ProtocolException {
        this.factory = factory;
        this.log = factory.getLogger();
        this.spcoopProperties = SPCoopProperties.getInstance(this.log);
        this.tipiSoggetti = this.factory.createProtocolConfiguration().getTipiSoggetti();
        this.tipiServizi = this.factory.createProtocolConfiguration().getTipiServizi();
        this.validazioneSemantica = (SPCoopValidazioneSemantica)this.factory.createValidazioneSemantica();
        this.validazioneSintattica = (SPCoopValidazioneSintattica)this.factory.createValidazioneSintattica();
        this.xmlUtils = XMLUtils.getInstance();
        this.traduttore = this.factory.createTraduttore();
        this.protocolManager = this.factory.createProtocolManager();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.factory;
    }

    private static synchronized void initSerialCounter(int prefixSeriale) {
        if (maxSeriale == 0) {
            if (prefixSeriale == -1) {
                maxSeriale = 9999999;
                prefixLenght = 0;
            } else if (prefixSeriale < 10) {
                maxSeriale = 999999;
                prefixLenght = 1;
            } else {
                maxSeriale = 99999;
                prefixLenght = 2;
            }
        }
    }

    public static synchronized int getNextSerialCounter() {
        if (serialCounter + 1 > maxSeriale) {
            serialCounter = 0;
        }
        return ++serialCounter;
    }

    public String buildID(IState state, IDSoggetto idSoggetto, String idTransazione, Boolean isRichiesta) throws ProtocolException {
        String idPD = idSoggetto.getCodicePorta();
        String codAmm = idSoggetto.getNome();
        if (idPD == null || codAmm == null) {
            this.log.error("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
            throw new ProtocolException("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
        }
        SPCoopImbustamento.initSerialCounter(this.spcoopProperties.getPrefissoSeriale_IdentificativoBusta());
        IDSerialGenerator serialGenerator = null;
        IDSerialGeneratorParameter serialGeneratorParameter = null;
        if (!"static".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta())) {
            ConfigurazionePdD config = this.factory.getConfigurazionePdD();
            serialGenerator = new IDSerialGenerator(config.getLog(), state, config.getTipoDatabase());
            serialGeneratorParameter = new IDSerialGeneratorParameter(this.factory.getProtocol());
            serialGeneratorParameter.setSerializableTimeWaitMs(config.getAttesaAttivaJDBC());
            serialGeneratorParameter.setSerializableNextIntervalTimeMs(config.getCheckIntervalJDBC());
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGeneratorParameter.setMaxValue(Long.valueOf(maxSeriale));
            serialGeneratorParameter.setWrap(true);
        }
        try {
            long counter = -1L;
            StringBuffer bf = new StringBuffer();
            bf.append(codAmm);
            bf.append('_');
            bf.append(idPD);
            bf.append('_');
            if ("mysql".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta())) {
                serialGeneratorParameter.setTipo(IDSerialGeneratorType.MYSQL);
                counter = serialGenerator.buildIDAsNumber(serialGeneratorParameter);
            } else {
                counter = "static".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta()) ? (long)SPCoopImbustamento.getNextSerialCounter() : serialGenerator.buildIDAsNumber(serialGeneratorParameter);
            }
            if (this.spcoopProperties.getPrefissoSeriale_IdentificativoBusta() != -1) {
                bf.append(this.spcoopProperties.getPrefissoSeriale_IdentificativoBusta());
            }
            String c = Long.toString(counter);
            int padding = 7 - prefixLenght - c.length();
            for (int i = 0; i < padding; ++i) {
                bf.append('0');
            }
            bf.append(c);
            bf.append('_');
            Date now = DateManager.getDate();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            bf.append(dateformat.format(now));
            return bf.toString();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov) throws ProtocolException {
        return this.build_eGovHeader(msg, eGov, true, false);
    }

    public SOAPElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov, boolean verificaPresenzaElementiObbligatori) throws ProtocolException {
        return this.build_eGovHeader(msg, eGov, verificaPresenzaElementiObbligatori, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov, boolean verificaPresenzaElementiObbligatori, boolean forzaValidazioneXSDElementiDisabilitata) throws ProtocolException {
        try {
            boolean generazioneElemento;
            SOAPHeader hdr;
            OpenSPCoop2Message messaggio = msg;
            if (messaggio == null) {
                OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
                messaggio = mf.createMessage(SOAPVersion.SOAP11);
            }
            if ((hdr = messaggio.getSOAPHeader()) == null) {
                hdr = messaggio.getSOAPPart().getEnvelope().addHeader();
            }
            QName name = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Intestazione", "eGov_IT");
            SOAPHeaderElement eGovHeader = messaggio.newSOAPHeaderElement(hdr, name);
            eGovHeader.setActor("http://www.cnipa.it/eGov_it/portadominio");
            eGovHeader.setMustUnderstand(true);
            eGovHeader.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            SOAPElement eGovIntestazioneMsg = eGovHeader.addChildElement("IntestazioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getMittente() == null) {
                    throw new ProtocolException("Mittente e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoMittente() == null) {
                    throw new ProtocolException("TipoMittente e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            SOAPElement eGovMitt = eGovIntestazioneMsg.addChildElement("Mittente", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement eGovIDParteMitt = eGovMitt.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getMittente() != null) {
                eGovIDParteMitt.setValue(eGov.getMittente());
            }
            if (eGov.getTipoMittente() != null) {
                eGovIDParteMitt.setAttribute("tipo", eGov.getTipoMittente());
            }
            if (eGov.getIndirizzoMittente() != null) {
                eGovIDParteMitt.setAttribute("indirizzoTelematico", eGov.getIndirizzoMittente());
            }
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getDestinatario() == null) {
                    throw new ProtocolException("Destinatario e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoDestinatario() == null) {
                    throw new ProtocolException("TipoDestinatario e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            SOAPElement eGovDest = eGovIntestazioneMsg.addChildElement("Destinatario", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement eGovIDParteDest = eGovDest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getDestinatario() != null) {
                eGovIDParteDest.setValue(eGov.getDestinatario());
            }
            if (eGov.getTipoDestinatario() != null) {
                eGovIDParteDest.setAttribute("tipo", eGov.getTipoDestinatario());
            }
            if (eGov.getIndirizzoDestinatario() != null) {
                eGovIDParteDest.setAttribute("indirizzoTelematico", eGov.getIndirizzoDestinatario());
            }
            if (eGov.getProfiloDiCollaborazione() != null) {
                generazioneElemento = true;
                if (!(forzaValidazioneXSDElementiDisabilitata || this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD() || ProfiloDiCollaborazione.ONEWAY.equals(eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(eGov.getProfiloDiCollaborazione()))) {
                    generazioneElemento = false;
                }
                if (generazioneElemento) {
                    SOAPElement eGovProfCollaborazione = eGovIntestazioneMsg.addChildElement("ProfiloCollaborazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    switch (eGov.getProfiloDiCollaborazione()) {
                        case ONEWAY: {
                            eGovProfCollaborazione.setValue("EGOV_IT_MessaggioSingoloOneWay");
                            break;
                        }
                        case SINCRONO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioSincrono");
                            break;
                        }
                        case ASINCRONO_SIMMETRICO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioAsincronoSimmetrico");
                            break;
                        }
                        case ASINCRONO_ASIMMETRICO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioAsincronoAsimmetrico");
                            break;
                        }
                        default: {
                            eGovProfCollaborazione.setValue(eGov.getProfiloDiCollaborazioneValue());
                        }
                    }
                    if (eGov.getServizioCorrelato() != null) {
                        eGovProfCollaborazione.setAttribute("servizioCorrelato", eGov.getServizioCorrelato());
                    }
                    if (eGov.getTipoServizioCorrelato() != null) {
                        boolean generazioneAttributo = true;
                        if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            generazioneAttributo = this.tipiServizi.contains(eGov.getTipoServizioCorrelato());
                        }
                        if (generazioneAttributo) {
                            eGovProfCollaborazione.setAttribute("tipo", eGov.getTipoServizioCorrelato());
                        }
                    }
                }
            }
            if (eGov.getCollaborazione() != null) {
                generazioneElemento = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
                    proprietaValidazione.setValidazioneIDCompleta(false);
                    generazioneElemento = this.validazioneSemantica.validazioneID(eGov.getCollaborazione(), null, proprietaValidazione);
                }
                if (generazioneElemento) {
                    SOAPElement eGovCollaborazione = eGovIntestazioneMsg.addChildElement("Collaborazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    eGovCollaborazione.setValue(eGov.getCollaborazione());
                }
            }
            if (eGov.getServizio() != null) {
                SOAPElement eGovServizio = eGovIntestazioneMsg.addChildElement("Servizio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovServizio.setValue(eGov.getServizio());
                if (eGov.getTipoServizio() != null) {
                    eGovServizio.setAttribute("tipo", eGov.getTipoServizio());
                }
            }
            if (eGov.getAzione() != null) {
                SOAPElement eGovAzione = eGovIntestazioneMsg.addChildElement("Azione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovAzione.setValue(eGov.getAzione());
            }
            SOAPElement eGovMessaggio = eGovIntestazioneMsg.addChildElement("Messaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getID() != null) {
                boolean generazioneElemento2 = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento2 = this.validazioneSemantica.validazioneID_engine(eGov.getID());
                }
                if (!generazioneElemento2) throw new ProtocolException("Identificatore e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getID() + ")");
                SOAPElement eGovIDMsg = eGovMessaggio.addChildElement("Identificatore", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (eGov.getID() != null) {
                    eGovIDMsg.setValue(eGov.getID());
                }
            } else if (verificaPresenzaElementiObbligatori) {
                throw new ProtocolException("Identificatore e' un elemento obbligatorio, e non e' stato definito");
            }
            SOAPElement eGovOraRegistrazione = eGovMessaggio.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getOraRegistrazione() == null && verificaPresenzaElementiObbligatori) {
                throw new ProtocolException("OraRegistrazione e' un elemento obbligatorio, e non e' stato definito");
            }
            if (eGov.getOraRegistrazione() != null) {
                eGovOraRegistrazione.setValue(SPCoopUtils.getDate_eGovFormat(eGov.getOraRegistrazione()));
            }
            if (eGov.getTipoOraRegistrazione() != null) {
                boolean generazioneAttributo = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals(eGov.getTipoOraRegistrazione()) || TipoOraRegistrazione.SINCRONIZZATO.equals(eGov.getTipoOraRegistrazione());
                }
                if (!generazioneAttributo) throw new ProtocolException("TipoOraRegistrazione e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getTipoOraRegistrazioneValue() + ")");
                if (TipoOraRegistrazione.LOCALE.equals(eGov.getTipoOraRegistrazione())) {
                    eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_Locale");
                } else if (TipoOraRegistrazione.SINCRONIZZATO.equals(eGov.getTipoOraRegistrazione())) {
                    eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
                } else {
                    eGovOraRegistrazione.setAttribute("tempo", eGov.getTipoOraRegistrazioneValue());
                }
            } else {
                eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
            }
            if (eGov.getRiferimentoMessaggio() != null) {
                boolean generazioneElemento3 = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento3 = this.validazioneSemantica.validazioneID_engine(eGov.getRiferimentoMessaggio());
                }
                if (generazioneElemento3) {
                    SOAPElement eGovRifMsg = eGovMessaggio.addChildElement("RiferimentoMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    eGovRifMsg.setValue(eGov.getRiferimentoMessaggio());
                }
            }
            if (eGov.getScadenza() != null) {
                SOAPElement eGovScadenza = eGovMessaggio.addChildElement("Scadenza", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovScadenza.setValue(SPCoopUtils.getDate_eGovFormat(eGov.getScadenza()));
            }
            SOAPElement eGovProfTrasmissione = eGovIntestazioneMsg.addChildElement("ProfiloTrasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getInoltro() != null) {
                boolean generazioneElemento4 = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneElemento4 = Inoltro.CON_DUPLICATI.equals(eGov.getInoltro()) || Inoltro.SENZA_DUPLICATI.equals(eGov.getInoltro());
                }
                if (generazioneElemento4) {
                    if (Inoltro.CON_DUPLICATI.equals(eGov.getInoltro())) {
                        eGovProfTrasmissione.setAttribute("inoltro", "EGOV_IT_PIUDIUNAVOLTA");
                    } else if (Inoltro.SENZA_DUPLICATI.equals(eGov.getInoltro())) {
                        eGovProfTrasmissione.setAttribute("inoltro", "EGOV_IT_ALPIUUNAVOLTA");
                    } else {
                        eGovProfTrasmissione.setAttribute("inoltro", eGov.getInoltroValue());
                    }
                }
            }
            String crValue = "false";
            if (eGov.isConfermaRicezione()) {
                crValue = "true";
            }
            eGovProfTrasmissione.setAttribute("confermaRicezione", crValue);
            if (eGov.getSequenza() != -1L) {
                SOAPElement eGovSequenza = eGovIntestazioneMsg.addChildElement("Sequenza", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                StringBuffer bf = new StringBuffer();
                String sequenza = Long.toString(eGov.getSequenza());
                int padding = 7 - sequenza.length();
                for (int i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(sequenza);
                eGovSequenza.setAttribute("numeroProgressivo", bf.toString());
            }
            if (eGov.sizeListaRiscontri() > 0) {
                SOAPElement eGovListaRiscontri = eGovHeader.addChildElement("ListaRiscontri", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                for (int i = 0; i < eGov.sizeListaRiscontri(); ++i) {
                    Riscontro ris = eGov.getRiscontro(i);
                    SOAPElement Riscontro2 = eGovListaRiscontri.addChildElement("Riscontro", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    if (ris.getID() != null) {
                        boolean generazioneElemento5 = true;
                        if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            generazioneElemento5 = this.validazioneSemantica.validazioneID_engine(ris.getID());
                        }
                        if (!generazioneElemento5) throw new ProtocolException("Identificatore e' un elemento obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getID() + ")");
                        SOAPElement id = Riscontro2.addChildElement("Identificatore", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        id.setValue(ris.getID());
                    } else if (verificaPresenzaElementiObbligatori) {
                        throw new ProtocolException("Identificatore e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                    }
                    if (ris.getOraRegistrazione() != null) {
                        SOAPElement ora = Riscontro2.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        ora.setValue(SPCoopUtils.getDate_eGovFormat(ris.getOraRegistrazione()));
                        if (ris.getTipoOraRegistrazione() != null) {
                            boolean generazioneAttributo = true;
                            if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                                boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals(ris.getTipoOraRegistrazione()) || TipoOraRegistrazione.SINCRONIZZATO.equals(ris.getTipoOraRegistrazione());
                            }
                            if (!generazioneAttributo) throw new ProtocolException("TipoOraRegistrazione e' un attributo obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getTipoOraRegistrazioneValue(this.factory) + ")");
                            if (TipoOraRegistrazione.LOCALE.equals(ris.getTipoOraRegistrazione())) {
                                ora.setAttribute("tempo", "EGOV_IT_Locale");
                                continue;
                            }
                            ora.setAttribute("tempo", "EGOV_IT_SPC");
                            continue;
                        }
                        ora.setAttribute("tempo", "EGOV_IT_SPC");
                        continue;
                    }
                    if (!verificaPresenzaElementiObbligatori) continue;
                    throw new ProtocolException("OraRegistrazione e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                }
            }
            if (eGov.sizeListaTrasmissioni() > 0) {
                boolean addFirstElement = false;
                SOAPElement eGovListaTrasmissioni = null;
                for (int i = 0; i < eGov.sizeListaTrasmissioni(); ++i) {
                    Trasmissione tr = eGov.getTrasmissione(i);
                    if (tr.getOrigine() == null || tr.getTipoOrigine() == null || tr.getDestinazione() == null || tr.getTipoDestinazione() == null || tr.getOraRegistrazione() == null || tr.getTempo() == null) continue;
                    if (!addFirstElement) {
                        eGovListaTrasmissioni = eGovHeader.addChildElement("ListaTrasmissioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        addFirstElement = true;
                    }
                    SOAPElement Trasmissione2 = eGovListaTrasmissioni.addChildElement("Trasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement orig = Trasmissione2.addChildElement("Origine", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement IDParteOrigine = orig.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    IDParteOrigine.setValue(tr.getOrigine());
                    IDParteOrigine.setAttribute("tipo", tr.getTipoOrigine());
                    if (tr.getIndirizzoOrigine() != null) {
                        IDParteOrigine.setAttribute("indirizzoTelematico", tr.getIndirizzoOrigine());
                    }
                    SOAPElement dest = Trasmissione2.addChildElement("Destinazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement IDParteDest = dest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    IDParteDest.setValue(tr.getDestinazione());
                    IDParteDest.setAttribute("tipo", tr.getTipoDestinazione());
                    if (tr.getIndirizzoDestinazione() != null) {
                        IDParteDest.setAttribute("indirizzoTelematico", tr.getIndirizzoDestinazione());
                    }
                    SOAPElement ora = Trasmissione2.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    ora.setValue(SPCoopUtils.getDate_eGovFormat(tr.getOraRegistrazione()));
                    boolean generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals(tr.getTempo()) || TipoOraRegistrazione.SINCRONIZZATO.equals(tr.getTempo());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("Tempo e' un attributo obbligatorio in una trasmissione, e il valore non e' utilizzabile rispetto all'xsd (" + tr.getTempoValue(this.factory) + ")");
                    if (TipoOraRegistrazione.LOCALE.equals(tr.getTempo())) {
                        ora.setAttribute("tempo", "EGOV_IT_Locale");
                        continue;
                    }
                    ora.setAttribute("tempo", "EGOV_IT_SPC");
                }
            }
            if (eGov.sizeListaEccezioni() <= 0) return eGovHeader;
            SOAPElement eGovListaEccezioni = eGovHeader.addChildElement("ListaEccezioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            for (int i = 0; i < eGov.sizeListaEccezioni(); ++i) {
                boolean generazioneAttributo;
                Eccezione ecc = eGov.getEccezione(i);
                SOAPElement eccezione = eGovListaEccezioni.addChildElement("Eccezione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (ecc.getContestoCodifica() != null) {
                    eccezione.setAttribute("contestoCodifica", ecc.getContestoCodificaValue(this.factory));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("ContestoCodifica e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getCodiceEccezione() != null) {
                    generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        generazioneAttributo = this.validazioneSintattica.validazioneCodiceEccezione(ecc.getCodiceEccezione());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + ecc.getCodiceEccezione() + ")");
                    eccezione.setAttribute("codiceEccezione", ecc.getCodiceEccezioneValue(this.factory));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getRilevanza() != null) {
                    generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = LivelloRilevanza.DEBUG.equals(ecc.getRilevanza()) || LivelloRilevanza.ERROR.equals(ecc.getRilevanza()) || LivelloRilevanza.FATAL.equals(ecc.getRilevanza()) || LivelloRilevanza.INFO.equals(ecc.getRilevanza()) || LivelloRilevanza.WARN.equals(ecc.getRilevanza());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("Rilevanza e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + ecc.getRilevanza() + ")");
                    eccezione.setAttribute("rilevanza", this.traduttore.toString(ecc.getRilevanza()));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("Rilevanza e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getDescrizione(this.factory) != null) {
                    eccezione.setAttribute("posizione", ecc.getDescrizione(this.factory));
                    continue;
                }
                if (!verificaPresenzaElementiObbligatori) continue;
                throw new ProtocolException("Posizione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
            }
            return eGovHeader;
        }
        catch (Exception e) {
            this.log.error("Creazione busta eGov non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione busta eGov non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    private String normalizeIdRefManifest(String contentId) {
        StringBuffer bf = new StringBuffer();
        if (this.spcoopProperties.isGenerateManifestAttachmentsIdWithBrackets()) {
            if (!contentId.startsWith("<")) {
                bf.append("<");
            }
            bf.append(contentId);
            if (!contentId.endsWith(">")) {
                bf.append(">");
            }
        } else {
            int start = 0;
            int end = contentId.length();
            if (contentId.startsWith("<")) {
                start = 1;
            }
            if (contentId.endsWith(">")) {
                end = contentId.length() - 1;
            }
            bf.append(contentId.substring(start, end));
        }
        return bf.toString();
    }

    public OpenSPCoop2Message build_eGovManifest(OpenSPCoop2Message msg, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            SOAPElement descrizione = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getSOAPBody().addChildElement(new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Descrizione", "eGov_IT"));
            Iterator iter = msg.getAttachments();
            int attach = 1;
            while (iter.hasNext()) {
                Utilities.printFreeMemory((String)("Imbustamento - Costruzione manifest att " + attach));
                AttachmentPart p = (AttachmentPart)iter.next();
                String contentID = p.getContentId();
                String contentLocation = p.getContentLocation();
                String contentType = p.getContentType();
                SOAPElement descrizioneMessaggio = descrizione.addChildElement("DescrizioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                SOAPElement riferimento = descrizioneMessaggio.addChildElement("Riferimento", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (contentID != null) {
                    riferimento.setAttribute("href", "cid:" + this.normalizeIdRefManifest(contentID));
                } else {
                    riferimento.setAttribute("href", contentLocation);
                }
                if (attach == 1 && proprietaManifestAttachments.isScartaBody()) {
                    if (isRichiesta) {
                        riferimento.setAttribute("role", this.spcoopProperties.getRoleRichiestaManifest());
                    } else {
                        riferimento.setAttribute("role", this.spcoopProperties.getRoleRispostaManifest());
                    }
                } else {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleAllegatoManifest());
                }
                QName id = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "eGov_IT");
                riferimento.addAttribute(id, "attachment" + attach);
                SOAPElement schema = riferimento.addChildElement("Schema", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                schema.setAttribute("posizione", contentType);
                SOAPElement titolo = riferimento.addChildElement("Titolo", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                titolo.setAttribute("Lingua", "it");
                if (attach == 1 && proprietaManifestAttachments.isScartaBody()) {
                    if (isRichiesta) {
                        titolo.setValue(this.spcoopProperties.getRoleRichiestaManifest());
                    } else {
                        titolo.setValue(this.spcoopProperties.getRoleRispostaManifest());
                    }
                } else {
                    titolo.setValue("attachment" + attach);
                }
                ++attach;
            }
            if (!proprietaManifestAttachments.isScartaBody()) {
                Utilities.printFreeMemory((String)"Imbustamento - Scarta Body");
                byte[] body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)msg.getSOAPPart().getEnvelope());
                AttachmentPart ap = null;
                boolean bodyWithMultiRootElement = false;
                if (body == null || body.length == 0) {
                    body = "<eGov_IT:SoapBodyEmpty xmlns:eGov_IT=\"http://www.openspcoop2.org/spcoop/manifest/body\" />".getBytes();
                } else {
                    Vector listNode = SoapUtils.getNotEmptyChildNodes((Node)msg.getSOAPPart().getEnvelope().getBody(), (boolean)false);
                    if (listNode != null && listNode.size() > 1) {
                        bodyWithMultiRootElement = true;
                    }
                }
                if (bodyWithMultiRootElement) {
                    InputStreamDataSource isSource = new InputStreamDataSource("ManifestEGov", "application/octet-stream", body);
                    ap = msg.createAttachmentPart(new DataHandler((DataSource)isSource));
                } else {
                    Source streamSource = null;
                    DataContentHandlerManager dchManager = new DataContentHandlerManager(this.log);
                    streamSource = dchManager.readMimeTypesContentHandler().containsKey("text/xml") ? new DOMSource(this.xmlUtils.newElement(body)) : new StreamSource(new ByteArrayInputStream(body));
                    ap = msg.createAttachmentPart();
                    ap.setContent((Object)streamSource, "text/xml");
                }
                ap.setContentId(msg.createContentID("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/"));
                msg.addAttachmentPart(ap);
                SOAPElement descrizioneMessaggio = descrizione.addChildElement("DescrizioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                SOAPElement riferimento = descrizioneMessaggio.addChildElement("Riferimento", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                riferimento.setAttribute("href", "cid:" + this.normalizeIdRefManifest(ap.getContentId()));
                if (isRichiesta) {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleRichiestaManifest());
                } else {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleRispostaManifest());
                }
                QName id = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "eGov_IT");
                riferimento.addAttribute(id, "attachment" + attach);
                SOAPElement schema = riferimento.addChildElement("Schema", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                schema.setAttribute("posizione", ap.getContentType());
                SOAPElement titolo = riferimento.addChildElement("Titolo", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                titolo.setAttribute("Lingua", "it");
                if (isRichiesta) {
                    titolo.setValue(this.spcoopProperties.getRoleRichiestaManifest());
                } else {
                    titolo.setValue(this.spcoopProperties.getRoleRispostaManifest());
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Add Manifest in Body");
            msg.getSOAPBody().removeContents();
            msg.getSOAPBody().addChildElement(descrizione);
            return msg;
        }
        catch (Exception e) {
            this.log.error("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public void imbustamentoEGov(OpenSPCoop2Message msg, Busta busta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        this.imbustamentoEGov(msg, busta, false, proprietaManifestAttachments);
    }

    public SOAPElement imbustamentoEGov(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            Utilities.printFreeMemory((String)"Imbustamento - Creazione header eGov");
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(msg, busta);
            Utilities.printFreeMemory((String)"Imbustamento - imbustamento");
            this.imbustamentoEGov(msg, headerEGovElement, isRichiesta, proprietaManifestAttachments);
            return headerEGovElement;
        }
        catch (Exception e) {
            this.log.error("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement imbustamentoEGov(OpenSPCoop2Message msg, SOAPHeaderElement headerEGovElement, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            headerEGovElement = msg.cleanXSITypes(headerEGovElement);
            SOAPHeader hdr = msg.getSOAPHeader();
            if (hdr == null) {
                hdr = msg.getSOAPPart().getEnvelope().addHeader();
            }
            msg.addHeaderElement(hdr, headerEGovElement);
            Utilities.printFreeMemory((String)"Imbustamento -Header Aggiunto");
            if (proprietaManifestAttachments != null && proprietaManifestAttachments.isGestioneManifest() && msg.countAttachments() > 0) {
                Utilities.printFreeMemory((String)"Imbustamento - Gestione Manifest");
                this.build_eGovManifest(msg, isRichiesta, proprietaManifestAttachments);
            }
            return headerEGovElement;
        }
        catch (Exception e) {
            this.log.error("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void build_trasmissione(Trasmissione trasmissione, SOAPElement listaTrasmissioni) throws ProtocolException {
        try {
            SOAPElement trasmissioneNode = listaTrasmissioni.addChildElement("Trasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement orig = trasmissioneNode.addChildElement("Origine", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement IDParteOrigine = orig.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            IDParteOrigine.setValue(trasmissione.getOrigine());
            IDParteOrigine.setAttribute("tipo", trasmissione.getTipoOrigine());
            if (trasmissione.getIndirizzoOrigine() != null) {
                IDParteOrigine.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoOrigine());
            }
            SOAPElement dest = trasmissioneNode.addChildElement("Destinazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement IDParteDest = dest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            IDParteDest.setValue(trasmissione.getDestinazione());
            IDParteDest.setAttribute("tipo", trasmissione.getTipoDestinazione());
            if (trasmissione.getIndirizzoDestinazione() != null) {
                IDParteDest.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoDestinazione());
            }
            SOAPElement ora = trasmissioneNode.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            ora.setValue(SPCoopUtils.getDate_eGovFormat(trasmissione.getOraRegistrazione()));
            if (TipoOraRegistrazione.LOCALE.equals(trasmissione.getTempo())) {
                ora.setAttribute("tempo", "EGOV_IT_Locale");
            } else if (TipoOraRegistrazione.SINCRONIZZATO.equals(trasmissione.getTempo())) {
                ora.setAttribute("tempo", "EGOV_IT_SPC");
            } else {
                ora.setAttribute("tempo", trasmissione.getTempoValue(this.factory));
            }
        }
        catch (Exception e) {
            this.log.error("Creazione trasmissione non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione trasmissione non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, boolean readQualifiedAttribute) throws ProtocolException {
        SOAPHeaderElement eGovHeaderOLD = null;
        SOAPHeaderElement eGovHeaderNEW = null;
        try {
            SOAPElement mChild;
            eGovHeaderOLD = this.validazioneSintattica.getHeaderEGov((SOAPMessage)message, readQualifiedAttribute);
            if (eGovHeaderOLD == null) {
                throw new ProtocolException("Header eGov non esistente");
            }
            eGovHeaderNEW = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getSOAPHeader().addHeaderElement(new QName(eGovHeaderOLD.getNamespaceURI(), eGovHeaderOLD.getLocalName(), eGovHeaderOLD.getPrefix()));
            eGovHeaderNEW.setActor(eGovHeaderOLD.getActor());
            eGovHeaderNEW.setMustUnderstand(eGovHeaderOLD.getMustUnderstand());
            Iterator namespaces = eGovHeaderOLD.getNamespacePrefixes();
            while (namespaces.hasNext()) {
                String mNamespace = (String)namespaces.next();
                eGovHeaderNEW.addNamespaceDeclaration(mNamespace, eGovHeaderOLD.getNamespaceURI(mNamespace));
            }
            Iterator attributes = eGovHeaderOLD.getAllAttributes();
            while (attributes.hasNext()) {
                Name mAttribute = (Name)attributes.next();
                eGovHeaderNEW.addAttribute(mAttribute, eGovHeaderOLD.getAttributeValue(mAttribute));
            }
            Iterator child = eGovHeaderOLD.getChildElements();
            while (child.hasNext()) {
                Object oChild = child.next();
                if (!(oChild instanceof SOAPElement)) continue;
                mChild = (SOAPElement)oChild;
                eGovHeaderNEW.addChildElement(mChild);
            }
            child = eGovHeaderNEW.getChildElements();
            SOAPElement listaTrasmissioni = null;
            while (child.hasNext()) {
                mChild = (SOAPElement)child.next();
                if (!"ListaTrasmissioni".equals(mChild.getLocalName())) continue;
                listaTrasmissioni = mChild;
                break;
            }
            if (listaTrasmissioni == null) {
                listaTrasmissioni = eGovHeaderNEW.addChildElement("ListaTrasmissioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            }
            this.build_trasmissione(trasmissione, listaTrasmissioni);
            message.getSOAPHeader().removeChild((Node)eGovHeaderOLD);
            SOAPElement sOAPElement = this.imbustamentoEGov(message, eGovHeaderNEW, false, null);
            return sOAPElement;
        }
        catch (Exception e) {
            this.log.error("addTrasmissione non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("addTrasmissione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.validazioneSintattica != null) {
                this.validazioneSintattica.setHeaderSOAP(null);
            }
            eGovHeaderOLD = null;
            eGovHeaderNEW = null;
        }
    }

    @Deprecated
    public String eraserType(String patch) throws ProtocolException {
        try {
            StringBuffer soapEnvelopePatch = new StringBuffer();
            int start = patch.indexOf("<eGov_IT:Intestazione");
            int end = patch.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            soapEnvelopePatch.append(patch.substring(0, start));
            String header = patch.substring(start, end);
            header = header.replaceAll("xsi:type", "");
            header = header.replaceAll("=\"xsd", "");
            header = header.replaceAll(":string\"", "");
            header = header.replaceAll(":dateTime\"", "");
            soapEnvelopePatch.append(header);
            soapEnvelopePatch.append(patch.substring(end));
            return soapEnvelopePatch.toString();
        }
        catch (Exception e) {
            this.log.error("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    public byte[] eraserType(byte[] xml) throws ProtocolException {
        ByteArrayOutputStream cleanEGov = null;
        try {
            int i;
            String header = new String(xml);
            int start = header.indexOf("<eGov_IT:Intestazione");
            int end = header.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            if (start == -1) {
                return null;
            }
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            String eraserString = " xsi:type=\"xsd:string\"";
            String eraserDate = " xsi:type=\"xsd:dateTime\"";
            cleanEGov = new ByteArrayOutputStream();
            for (i = 0; i < start; ++i) {
                cleanEGov.write(xml[i]);
            }
            i = start;
            while (i < end) {
                if (xml[i] == 32) {
                    int k;
                    StringBuffer test;
                    if (i + eraserDate.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserDate.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserDate)) {
                            i += eraserDate.length();
                            continue;
                        }
                    }
                    if (i + eraserString.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanEGov.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanEGov.write(xml[i]);
                ++i;
            }
            for (i = end; i < xml.length; ++i) {
                cleanEGov.write(xml[i]);
            }
            byte[] cleanBytes = cleanEGov.toByteArray();
            cleanEGov.close();
            return cleanBytes;
        }
        catch (Exception e) {
            try {
                if (cleanEGov != null) {
                    cleanEGov.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement imbustamento(OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        if (busta.getProfiloDiCollaborazione() != null) {
            switch (busta.getProfiloDiCollaborazione()) {
                case ONEWAY: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY, "EGOV_IT_MessaggioSingoloOneWay");
                    break;
                }
                case SINCRONO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO, "EGOV_IT_ServizioSincrono");
                    break;
                }
                case ASINCRONO_ASIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO, "EGOV_IT_ServizioAsincronoAsimmetrico");
                    break;
                }
                case ASINCRONO_SIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO, "EGOV_IT_ServizioAsincronoSimmetrico");
                    break;
                }
            }
        }
        if (busta.getTipoOraRegistrazione() != null) {
            switch (busta.getTipoOraRegistrazione()) {
                case LOCALE: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, "EGOV_IT_Locale");
                    break;
                }
                case SINCRONIZZATO: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO, "EGOV_IT_SPC");
                    break;
                }
            }
        }
        if (busta.getInoltro() != null) {
            switch (busta.getInoltro()) {
                case CON_DUPLICATI: {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, "EGOV_IT_PIUDIUNAVOLTA");
                    break;
                }
                case SENZA_DUPLICATI: {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, "EGOV_IT_ALPIUUNAVOLTA");
                    break;
                }
            }
        }
        for (Riscontro riscontro : busta.getListaRiscontri()) {
            if (riscontro.getTipoOraRegistrazione() == null) continue;
            if (riscontro.getTipoOraRegistrazione().equals(TipoOraRegistrazione.LOCALE)) {
                riscontro.setTipoOraRegistrazioneValue("EGOV_IT_Locale");
            }
            if (!riscontro.getTipoOraRegistrazione().equals(TipoOraRegistrazione.SINCRONIZZATO)) continue;
            riscontro.setTipoOraRegistrazioneValue("EGOV_IT_SPC");
        }
        for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
            if (trasmissione.getTempo() == null) continue;
            if (trasmissione.getTempo().equals(TipoOraRegistrazione.LOCALE)) {
                trasmissione.setTempoValue("EGOV_IT_Locale");
                continue;
            }
            trasmissione.setTempoValue("EGOV_IT_SPC");
        }
        return this.imbustamentoEGov(msg, busta, isRichiesta, proprietaManifestAttachments);
    }

    public SOAPElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione) throws ProtocolException {
        return this.addTrasmissione(message, trasmissione, false);
    }
}

