/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.builder.ErroreApplicativoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.AbstractEccezioneBuilderParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneProtocolloBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IErroreApplicativoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.KeyValueObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.utils.SPCoopUtils;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SPCoopErroreApplicativoBuilder
extends ErroreApplicativoBuilder
implements IErroreApplicativoBuilder {
    public SPCoopErroreApplicativoBuilder(IProtocolFactory factory) throws ProtocolException {
        super(factory);
    }

    public boolean isErroreApplicativo(String namespace, String localName) {
        return "MessaggioDiErroreApplicativo".equals(localName) && "http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/".equals(namespace);
    }

    public String getNamespaceEccezioneProtocollo() {
        return "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/";
    }

    protected SOAPElement buildErroreApplicativoElement_engine(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            String idPorta = null;
            String idFunzione = null;
            String tipo = null;
            String codiceEccezione = null;
            String descrizioneEccezione = null;
            if (eccezioneProtocollo != null) {
                idPorta = eccezioneProtocollo.getDominioPorta().getCodicePorta();
                idFunzione = eccezioneProtocollo.getIdFunzione();
                tipo = "EccezioneBusta";
                codiceEccezione = this.traduttore.toString(eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione(), eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione());
                descrizioneEccezione = eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.factory);
            } else {
                idPorta = eccezioneIntegrazione.getDominioPorta().getCodicePorta();
                idFunzione = eccezioneIntegrazione.getIdFunzione();
                tipo = "EccezioneProcessamento";
                codiceEccezione = this.traduttore.toCodiceErroreIntegrazioneAsString(eccezioneIntegrazione.getErroreIntegrazione(), eccezioneIntegrazione.getProprieta().getFaultPrefixCode(), eccezioneIntegrazione.getProprieta().isFaultAsGenericCode());
                descrizioneEccezione = eccezioneIntegrazione.getProprieta().transformFaultMsg(eccezioneIntegrazione.getErroreIntegrazione(), this.factory);
            }
            Document doc = this.xmlUtils.newDocument();
            Element eccezione = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:MessaggioDiErroreApplicativo");
            Element oraRec = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:OraRegistrazione");
            oraRec.setTextContent(SPCoopUtils.getDate_eGovFormat());
            eccezione.appendChild(oraRec);
            Element identificativoPorta = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:IdentificativoPorta");
            identificativoPorta.setTextContent(idPorta);
            eccezione.appendChild(identificativoPorta);
            Element identificativoFunzione = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:IdentificativoFunzione");
            identificativoFunzione.setTextContent(idFunzione);
            eccezione.appendChild(identificativoFunzione);
            Element EccNode = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:Eccezione");
            eccezione.appendChild(EccNode);
            Element EccNodeInterno = doc.createElementNS("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "eGov_IT_Ecc:" + tipo);
            EccNodeInterno.setAttribute("codiceEccezione", codiceEccezione);
            EccNodeInterno.setAttribute("descrizioneEccezione", descrizioneEccezione);
            EccNode.appendChild(EccNodeInterno);
            OpenSPCoop2Message responseSOAPMessageError = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11);
            SOAPBody soapBody = responseSOAPMessageError.getSOAPBody();
            soapBody.appendChild(soapBody.getOwnerDocument().importNode(eccezione, true));
            return (SOAPElement)soapBody.getFirstChild();
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("toElement failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public AbstractEccezioneBuilderParameter readErroreApplicativo(byte[] xml, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            Document nXml = this.xmlUtils.newDocument(xml);
            return this.readErroreApplicativo(nXml, prefixCodiceErroreApplicativoIntegrazione);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public AbstractEccezioneBuilderParameter readErroreApplicativo(Node xml, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            CodiceErroreCooperazione codice;
            NodeList ndList = xml.getChildNodes();
            String oraRegistrazione = null;
            String identificativoPorta = null;
            String identificativoFunzione = null;
            boolean eccezioneBusta = false;
            String codiceEccezione = null;
            String descrizioneEccezione = null;
            for (int i = 0; i < ndList.getLength(); ++i) {
                if (ndList.item(i).getNodeName().endsWith("OraRegistrazione")) {
                    oraRegistrazione = ((Element)ndList.item(i)).getFirstChild().getTextContent();
                    continue;
                }
                if (ndList.item(i).getNodeName().endsWith("IdentificativoPorta")) {
                    identificativoPorta = ((Element)ndList.item(i)).getFirstChild().getTextContent();
                    continue;
                }
                if (ndList.item(i).getNodeName().endsWith("IdentificativoFunzione")) {
                    identificativoFunzione = ((Element)ndList.item(i)).getFirstChild().getTextContent();
                    continue;
                }
                if (!ndList.item(i).getNodeName().endsWith("Eccezione")) continue;
                NodeList ndEcc = ndList.item(i).getChildNodes();
                if (ndEcc.item(0).getNodeName().endsWith("EccezioneBusta")) {
                    eccezioneBusta = true;
                } else if (ndEcc.item(0).getNodeName().endsWith("EccezioneProcessamento")) {
                    eccezioneBusta = false;
                }
                NamedNodeMap mapAtt = ndEcc.item(0).getAttributes();
                codiceEccezione = mapAtt.getNamedItem("codiceEccezione").getNodeValue();
                descrizioneEccezione = mapAtt.getNamedItem("descrizioneEccezione").getNodeValue();
            }
            if (oraRegistrazione == null) {
                throw new ProtocolException("OraRegistrazione non definita?");
            }
            if (identificativoFunzione == null) {
                throw new ProtocolException("IdentificativoFunzione non definito?");
            }
            if (identificativoPorta == null) {
                throw new ProtocolException("IdentificativoPorta non definito?");
            }
            if (codiceEccezione == null) {
                throw new ProtocolException("CodiceEccezione non definita?");
            }
            if (descrizioneEccezione == null) {
                throw new ProtocolException("DescrizioneEccezione non definita?");
            }
            EccezioneProtocolloBuilderParameters eccezione = null;
            if (eccezioneBusta) {
                eccezione = new EccezioneProtocolloBuilderParameters();
                codice = this.factory.createTraduttore().toCodiceErroreCooperazione(codiceEccezione);
                ErroreCooperazione erroreCooperazione = new ErroreCooperazione(descrizioneEccezione, codice);
                Eccezione eccezioneProtocollo = new Eccezione(erroreCooperazione, true, identificativoFunzione, this.factory);
                eccezione.setEccezioneProtocollo(eccezioneProtocollo);
            } else {
                eccezione = new EccezioneIntegrazioneBuilderParameters();
                codice = this.factory.createTraduttore().toCodiceErroreIntegrazione(codiceEccezione, prefixCodiceErroreApplicativoIntegrazione);
                ErroreIntegrazione erroreIntegrazione = new ErroreIntegrazione(descrizioneEccezione, (CodiceErroreIntegrazione)codice, new KeyValueObject[0]);
                ((EccezioneIntegrazioneBuilderParameters)eccezione).setErroreIntegrazione(erroreIntegrazione);
            }
            IDSoggetto dominio = new IDSoggetto();
            dominio.setCodicePorta(identificativoPorta);
            eccezione.setDominioPorta(dominio);
            eccezione.setOraRegistrazione(SPCoopUtils.getDate_eGovFormat(oraRegistrazione));
            eccezione.setIdFunzione(identificativoFunzione);
            return eccezione;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

