/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IBustaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder.SPCoopImbustamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.builder.SPCoopSbustamento;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;

public class SPCoopBustaBuilder
implements IBustaBuilder {
    private SPCoopImbustamento spcoopImbustamento = null;
    private SPCoopSbustamento spcoopSbustamento = null;
    private Logger log = null;

    public SPCoopBustaBuilder(IProtocolFactory factory) throws ProtocolException {
        this.spcoopImbustamento = new SPCoopImbustamento(factory);
        this.spcoopSbustamento = new SPCoopSbustamento(factory);
        this.log = factory.getLogger();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.spcoopImbustamento.getProtocolFactory();
    }

    public String newID(IState state, IDSoggetto idSoggetto, String idTransazione, Boolean isRichiesta) throws ProtocolException {
        return this.spcoopImbustamento.buildID(state, idSoggetto, idTransazione, isRichiesta);
    }

    public Date extractDateFromID(String id) throws ProtocolException {
        try {
            if (id == null) {
                return null;
            }
            String[] split = id.split("_");
            if (split.length != 5) {
                return null;
            }
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            String tmp = split[3] + "_" + split[4];
            Date d = dateformat.parse(tmp);
            return d;
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante l'estrazione della data dall'identificativo [" + id + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPElement toElement(Busta busta, boolean isRichiesta) throws ProtocolException {
        try {
            OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createEmptySOAPMessage(SOAPVersion.SOAP11);
            return this.spcoopImbustamento.build_eGovHeader(msg, busta, false);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString(Busta busta, boolean isRichiesta) throws ProtocolException {
        return Utilities.toString((Logger)this.log, (SOAPElement)this.toElement(busta, isRichiesta));
    }

    public byte[] toByteArray(Busta busta, boolean isRichiesta) throws ProtocolException {
        return Utilities.toByteArray((Logger)this.log, (SOAPElement)this.toElement(busta, isRichiesta));
    }

    public SOAPElement imbustamento(IState state, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        return this.spcoopImbustamento.imbustamento(msg, busta, isRichiesta, proprietaManifestAttachments);
    }

    public SOAPElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione) throws ProtocolException {
        return this.spcoopImbustamento.addTrasmissione(message, trasmissione);
    }

    public SOAPElement sbustamento(IState state, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        return this.spcoopSbustamento.sbustamento(msg, proprietaManifestAttachments);
    }
}

