/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.archive;

import it.cnipa.collprofiles.driver.XMLUtils;
import it.gov.spcoop.sica.dao.AccordoCooperazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.manifest.ElencoPartecipanti;
import it.gov.spcoop.sica.manifest.ElencoServiziComponenti;
import it.gov.spcoop.sica.manifest.ElencoServiziComposti;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoConversazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.RegistryNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAtoOpenSPCoopContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAtoOpenSPCoopUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;

public class SPCoopArchiveImportUtils {
    public static void setIDSoggettoFromCodiceIPA(AccordoServizioParteComune aspc, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (aspc.getManifesto() != null && aspc.getManifesto().getParteComune() != null && aspc.getManifesto().getParteComune().getPubblicatore() != null) {
            String codiceIPAReferente = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(aspc.getManifesto().getParteComune().getPubblicatore());
            IDSoggetto soggettoReferente = null;
            try {
                soggettoReferente = registryReader.getIdSoggettoByCodiceIPA(codiceIPAReferente);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoReferente, codiceIPAReferente);
            }
            catch (RegistryNotFound dNotF) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPAReferente + "] non esiste");
            }
        }
    }

    public static void setIDSoggettoFromCodiceIPA(AccordoServizioComposto asc, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (asc.getManifesto() != null && asc.getManifesto().getPubblicatore() != null) {
            String codiceIPAReferente = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(asc.getManifesto().getPubblicatore());
            IDSoggetto soggettoReferente = null;
            try {
                soggettoReferente = registryReader.getIdSoggettoByCodiceIPA(codiceIPAReferente);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoReferente, codiceIPAReferente);
            }
            catch (RegistryNotFound dNotF) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPAReferente + "] non esiste");
            }
        }
        if (asc.getManifesto() != null && asc.getManifesto().getServiziComponenti() != null) {
            ElencoServiziComponenti sComponenti = asc.getManifesto().getServiziComponenti();
            for (int i = 0; i < sComponenti.sizeServizioComponenteList(); ++i) {
                String servComponente = sComponenti.getServizioComponente(i);
                String codiceIPASoggettoErogatoreServizioComponente = SICAtoOpenSPCoopUtilities.readDNSoggettoFromUriAccordo(servComponente);
                IDSoggetto soggettoErogatoreServizioComponente = null;
                try {
                    soggettoErogatoreServizioComponente = registryReader.getIdSoggettoByCodiceIPA(codiceIPASoggettoErogatoreServizioComponente);
                    contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoErogatoreServizioComponente, codiceIPASoggettoErogatoreServizioComponente);
                    continue;
                }
                catch (RegistryNotFound dNotF) {
                    throw new ProtocolException("Il soggetto erogatore con Codice IPA [" + codiceIPASoggettoErogatoreServizioComponente + "] non esiste (servizio componente: " + servComponente + ")");
                }
            }
        }
    }

    public static void setIDServizioFromURI_APS(AccordoServizioComposto asc, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (asc.getManifesto() != null && asc.getManifesto().getServiziComponenti() != null) {
            ElencoServiziComponenti sComponenti = asc.getManifesto().getServiziComponenti();
            for (int i = 0; i < sComponenti.sizeServizioComponenteList(); ++i) {
                String servComponente = sComponenti.getServizioComponente(i);
                IDAccordo idAccordoServizioParteSpecifica = null;
                try {
                    idAccordoServizioParteSpecifica = SICAtoOpenSPCoopUtilities.idAccordoServizioParteSpecifica_sicaToOpenspcoop(servComponente, contextSICA);
                    IDServizio idServizio = registryReader.convertToIDServizio(idAccordoServizioParteSpecifica);
                    contextSICA.addMappingServizioToUriAPS(idServizio, idAccordoServizioParteSpecifica);
                    continue;
                }
                catch (RegistryNotFound dNotF) {
                    if (idAccordoServizioParteSpecifica != null) {
                        throw new ProtocolException("L'accordo di servizio parte specifica [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteSpecifica) + "] non esiste (servizio componente: " + servComponente + ").");
                    }
                    throw new ProtocolException("L'accordo di servizio parte specifica relativo al servizio componente (" + servComponente + ") non esiste");
                }
            }
        }
    }

    public static void setIDSoggettoFromCodiceIPA(AccordoCooperazione ac, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (ac.getManifesto() != null && ac.getManifesto().getCoordinatore() != null) {
            String codiceIPACoordinatore = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(ac.getManifesto().getCoordinatore());
            IDSoggetto soggettoCoordinatore = null;
            try {
                soggettoCoordinatore = registryReader.getIdSoggettoByCodiceIPA(codiceIPACoordinatore);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoCoordinatore, codiceIPACoordinatore);
            }
            catch (RegistryNotFound dNotF) {
                throw new ProtocolException("Il soggetto coordinatore con Codice IPA [" + codiceIPACoordinatore + "] non esiste");
            }
        }
        if (ac.getManifesto() != null && ac.getManifesto().getElencoPartecipanti() != null) {
            ElencoPartecipanti elencoPartecipanti = ac.getManifesto().getElencoPartecipanti();
            for (int i = 0; i < elencoPartecipanti.sizePartecipanteList(); ++i) {
                String codiceIPASoggettoPartecipante = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(elencoPartecipanti.getPartecipante(i));
                IDSoggetto soggettoPartecipante = null;
                try {
                    soggettoPartecipante = registryReader.getIdSoggettoByCodiceIPA(codiceIPASoggettoPartecipante);
                    contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoPartecipante, codiceIPASoggettoPartecipante);
                    continue;
                }
                catch (RegistryNotFound dNotF) {
                    throw new ProtocolException("Il soggetto partecipante con Codice IPA [" + codiceIPASoggettoPartecipante + "] non esiste");
                }
            }
        }
        if (ac.getManifesto() != null && ac.getManifesto().getServiziComposti() != null) {
            ElencoServiziComposti sComposti = ac.getManifesto().getServiziComposti();
            for (int i = 0; i < sComposti.sizeServizioCompostoList(); ++i) {
                String uriServizioComposto = sComposti.getServizioComposto(i);
                String codiceIPASoggettoErogatoreServizioComposto = SICAtoOpenSPCoopUtilities.readDNSoggettoFromUriAccordo(uriServizioComposto);
                IDSoggetto soggettoErogatoreServizioComposto = null;
                try {
                    soggettoErogatoreServizioComposto = registryReader.getIdSoggettoByCodiceIPA(codiceIPASoggettoErogatoreServizioComposto);
                    contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoErogatoreServizioComposto, codiceIPASoggettoErogatoreServizioComposto);
                    continue;
                }
                catch (RegistryNotFound dNotF) {
                    throw new ProtocolException("Il soggetto erogatore con Codice IPA [" + codiceIPASoggettoErogatoreServizioComposto + "] non esiste (servizio composto: " + uriServizioComposto + ")");
                }
            }
        }
    }

    public static void setIDSoggettoFromCodiceIPA(AccordoServizioParteSpecifica asps, SICAtoOpenSPCoopContext contextSICA, IRegistryReader registryReader) throws Exception {
        if (asps.getManifesto() != null && asps.getManifesto().getParteSpecifica() != null && asps.getManifesto().getParteSpecifica().getErogatore() != null) {
            String codiceIPAErogatore = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(asps.getManifesto().getParteSpecifica().getErogatore());
            IDSoggetto soggettoErogatore = null;
            try {
                soggettoErogatore = registryReader.getIdSoggettoByCodiceIPA(codiceIPAErogatore);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoErogatore, codiceIPAErogatore);
            }
            catch (RegistryNotFound dNotF) {
                throw new ProtocolException("Il soggetto erogatore con Codice IPA [" + codiceIPAErogatore + "] non esiste");
            }
        }
        if (asps.getManifesto() != null && asps.getManifesto().getParteSpecifica() != null && asps.getManifesto().getParteSpecifica().getRiferimentoParteComune() != null) {
            String uriRiferimentoParteComune = asps.getManifesto().getParteSpecifica().getRiferimentoParteComune();
            String codiceIPASoggettoReferenteParteComune = SICAtoOpenSPCoopUtilities.readDNSoggettoFromUriAccordo(uriRiferimentoParteComune);
            IDSoggetto soggettoReferenteParteComune = null;
            try {
                soggettoReferenteParteComune = registryReader.getIdSoggettoByCodiceIPA(codiceIPASoggettoReferenteParteComune);
                contextSICA.addMappingSoggettoSPCoopToCodiceIPA(soggettoReferenteParteComune, codiceIPASoggettoReferenteParteComune);
            }
            catch (RegistryNotFound dNotF) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPASoggettoReferenteParteComune + "] non esiste (parte comune: " + uriRiferimentoParteComune + ")");
            }
        }
    }

    public static void validazioneContenuti(AccordoServizioParteComune aspc) throws Exception {
        if (aspc.getInterfacciaConcettuale() == null) {
            throw new Exception("WSDL Concettuale non presente");
        }
        if (aspc.getInterfacciaLogicaLatoErogatore() == null) {
            throw new Exception("WSDL Logico Erogatore non presente");
        }
        byte[] wsdlConcettuale = aspc.getInterfacciaConcettuale().getContenuto();
        if (wsdlConcettuale == null) {
            throw new Exception("WSDL Concettuale non presente nell'archivio");
        }
        if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlConcettuale)) {
            wsdlConcettuale = null;
        }
        aspc.getInterfacciaConcettuale().setContenuto(wsdlConcettuale);
        byte[] wsdlLogicoErogatore = aspc.getInterfacciaLogicaLatoErogatore().getContenuto();
        if (wsdlLogicoErogatore == null) {
            throw new Exception("WSDL Logico Erogatore non presente nell'archivio");
        }
        if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlLogicoErogatore)) {
            wsdlLogicoErogatore = null;
        }
        aspc.getInterfacciaLogicaLatoErogatore().setContenuto(wsdlLogicoErogatore);
        byte[] wsdlLogicoFruitore = null;
        if (aspc.getInterfacciaLogicaLatoFruitore() != null) {
            wsdlLogicoFruitore = aspc.getInterfacciaLogicaLatoFruitore().getContenuto();
            if (wsdlLogicoFruitore == null) {
                throw new Exception("WSDL Logico Fruitore non presente nell'archivio");
            }
            if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlLogicoFruitore)) {
                wsdlLogicoFruitore = null;
            }
        }
        if (aspc.getInterfacciaLogicaLatoFruitore() != null) {
            aspc.getInterfacciaLogicaLatoFruitore().setContenuto(wsdlLogicoFruitore);
        }
        byte[] wsblConcettuale = null;
        if (aspc.getConversazioneConcettuale() != null && TipiDocumentoConversazione.WSBL.toString().equals(aspc.getConversazioneConcettuale().getTipo()) && (wsblConcettuale = aspc.getConversazioneConcettuale().getContenuto()) == null) {
            throw new Exception("WSBL Concettuale non presente nell'archivio");
        }
        if (aspc.getConversazioneConcettuale() != null) {
            aspc.getConversazioneConcettuale().setContenuto(wsblConcettuale);
        }
        byte[] wsblLogicoErogatore = null;
        if (aspc.getConversazioneLogicaErogatore() != null && TipiDocumentoConversazione.WSBL.toString().equals(aspc.getConversazioneLogicaErogatore().getTipo()) && (wsblLogicoErogatore = aspc.getConversazioneLogicaErogatore().getContenuto()) == null) {
            throw new Exception("WSBL Logico Erogatore non presente nell'archivio");
        }
        if (aspc.getConversazioneLogicaErogatore() != null) {
            aspc.getConversazioneLogicaErogatore().setContenuto(wsblLogicoErogatore);
        }
        byte[] wsblLogicoFruitore = null;
        if (aspc.getConversazioneLogicaFruitore() != null && TipiDocumentoConversazione.WSBL.toString().equals(aspc.getConversazioneLogicaFruitore().getTipo()) && (wsblLogicoFruitore = aspc.getConversazioneLogicaFruitore().getContenuto()) == null) {
            throw new Exception("WSBL Logico Fruitore non presente nell'archivio");
        }
        if (aspc.getConversazioneLogicaFruitore() != null) {
            aspc.getConversazioneLogicaFruitore().setContenuto(wsblLogicoFruitore);
        }
    }

    public static void validazioneContenuti(AccordoServizioComposto asc) throws Exception {
        if (asc.getInterfacciaConcettuale() == null) {
            throw new Exception("WSDL Concettuale non presente");
        }
        if (asc.getInterfacciaLogicaLatoErogatore() == null) {
            throw new Exception("WSDL Logico Erogatore non presente");
        }
        byte[] wsdlConcettuale = asc.getInterfacciaConcettuale().getContenuto();
        if (wsdlConcettuale == null) {
            throw new Exception("WSDL Concettuale non presente nell'archivio");
        }
        if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlConcettuale)) {
            wsdlConcettuale = null;
        }
        asc.getInterfacciaConcettuale().setContenuto(wsdlConcettuale);
        byte[] wsdlLogicoErogatore = asc.getInterfacciaLogicaLatoErogatore().getContenuto();
        if (wsdlLogicoErogatore == null) {
            throw new Exception("WSDL Logico Erogatore non presente nell'archivio");
        }
        if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlLogicoErogatore)) {
            wsdlLogicoErogatore = null;
        }
        asc.getInterfacciaLogicaLatoErogatore().setContenuto(wsdlLogicoErogatore);
        byte[] wsdlLogicoFruitore = null;
        if (asc.getInterfacciaLogicaLatoFruitore() != null) {
            wsdlLogicoFruitore = asc.getInterfacciaLogicaLatoFruitore().getContenuto();
            if (wsdlLogicoFruitore == null) {
                throw new Exception("WSDL Logico Fruitore non presente nell'archivio");
            }
            if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlLogicoFruitore)) {
                wsdlLogicoFruitore = null;
            }
        }
        if (asc.getInterfacciaLogicaLatoFruitore() != null) {
            asc.getInterfacciaLogicaLatoFruitore().setContenuto(wsdlLogicoFruitore);
        }
        byte[] wsblConcettuale = null;
        if (asc.getConversazioneConcettuale() != null && TipiDocumentoConversazione.WSBL.toString().equals(asc.getConversazioneConcettuale().getTipo()) && (wsblConcettuale = asc.getConversazioneConcettuale().getContenuto()) == null) {
            throw new Exception("WSBL Concettuale non presente nell'archivio");
        }
        if (asc.getConversazioneConcettuale() != null) {
            asc.getConversazioneConcettuale().setContenuto(wsblConcettuale);
        }
        byte[] wsblLogicoErogatore = null;
        if (asc.getConversazioneLogicaErogatore() != null && TipiDocumentoConversazione.WSBL.toString().equals(asc.getConversazioneLogicaErogatore().getTipo()) && (wsblLogicoErogatore = asc.getConversazioneLogicaErogatore().getContenuto()) == null) {
            throw new Exception("WSBL Logico Erogatore non presente nell'archivio");
        }
        if (asc.getConversazioneLogicaErogatore() != null) {
            asc.getConversazioneLogicaErogatore().setContenuto(wsblLogicoErogatore);
        }
        byte[] wsblLogicoFruitore = null;
        if (asc.getConversazioneLogicaFruitore() != null && TipiDocumentoConversazione.WSBL.toString().equals(asc.getConversazioneLogicaFruitore().getTipo()) && (wsblLogicoFruitore = asc.getConversazioneLogicaFruitore().getContenuto()) == null) {
            throw new Exception("WSBL Logico Fruitore non presente nell'archivio");
        }
        if (asc.getConversazioneLogicaFruitore() != null) {
            asc.getConversazioneLogicaFruitore().setContenuto(wsblLogicoFruitore);
        }
    }

    public static void validazioneContenuti(AccordoServizioParteSpecifica aps) throws Exception {
        byte[] wsdlImplementativo;
        if (aps.getPortiAccessoErogatore() == null && aps.getPortiAccessoFruitore() == null) {
            throw new Exception("Nessun WSDL Implementativo presente");
        }
        if (aps.getPortiAccessoErogatore() != null) {
            wsdlImplementativo = aps.getPortiAccessoErogatore().getContenuto();
            if (wsdlImplementativo == null) {
                throw new Exception("WSDL Implementativo Erogatore non presente nell'archivio");
            }
            if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlImplementativo)) {
                wsdlImplementativo = null;
            }
            aps.getPortiAccessoErogatore().setContenuto(wsdlImplementativo);
        }
        if (aps.getPortiAccessoFruitore() != null) {
            wsdlImplementativo = aps.getPortiAccessoFruitore().getContenuto();
            if (wsdlImplementativo == null) {
                throw new Exception("WSDL Implementativo Fruitore non presente nell'archivio");
            }
            if (SICAtoOpenSPCoopUtilities.isWsdlEmpty(wsdlImplementativo)) {
                wsdlImplementativo = null;
            }
            aps.getPortiAccessoFruitore().setContenuto(wsdlImplementativo);
        }
    }

    @Deprecated
    public static boolean isInfoEGovPresenti(AccordoServizioParteComune aspc) {
        boolean infoEgovPresenti = false;
        if (aspc != null) {
            int j;
            Documento docSICA = null;
            for (j = 0; j < aspc.sizeAllegati(); ++j) {
                docSICA = aspc.getAllegato(j);
                if (it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) {
                    infoEgovPresenti = true;
                    break;
                }
                if (!XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) continue;
                infoEgovPresenti = true;
                break;
            }
            if (!infoEgovPresenti) {
                for (j = 0; j < aspc.sizeSpecificheSemiformali(); ++j) {
                    docSICA = aspc.getSpecificaSemiformale(j);
                    if (it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) {
                        infoEgovPresenti = true;
                        break;
                    }
                    if (!XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) continue;
                    infoEgovPresenti = true;
                    break;
                }
            }
        }
        return infoEgovPresenti;
    }

    @Deprecated
    public static boolean isInfoEGovPresenti(AccordoServizioComposto asc) {
        boolean infoEgovPresenti = false;
        if (asc != null) {
            int j;
            Documento docSICA = null;
            for (j = 0; j < asc.sizeAllegati(); ++j) {
                docSICA = asc.getAllegato(j);
                if (it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) {
                    infoEgovPresenti = true;
                    break;
                }
                if (!XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) continue;
                infoEgovPresenti = true;
                break;
            }
            if (!infoEgovPresenti) {
                for (j = 0; j < asc.sizeSpecificheSemiformali(); ++j) {
                    docSICA = asc.getSpecificaSemiformale(j);
                    if (it.gov.spcoop.sica.wscp.driver.XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) {
                        infoEgovPresenti = true;
                        break;
                    }
                    if (!XMLUtils.isProfiloCollaborazioneEGOV(docSICA.getContenuto())) continue;
                    infoEgovPresenti = true;
                    break;
                }
            }
        }
        return infoEgovPresenti;
    }
}

