/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.archive;

import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.dao.driver.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.archive.SPCoopArchiveImportUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.archive.SPCoopConvertToPackageCNIPAException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAtoOpenSPCoopContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.spcoop.sica.SICAtoOpenSPCoopUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import org.slf4j.Logger;

public class SPCoopArchiveImport {
    private IProtocolFactory protocolFactory = null;
    private Logger logger = null;

    public SPCoopArchiveImport(IProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.logger = this.protocolFactory.getLogger();
    }

    public Archive buildAccordoServizioParteComune(byte[] archive, IRegistryReader registryReader, boolean validationDocuments) throws ProtocolException, SPCoopConvertToPackageCNIPAException {
        try {
            String codiceIPA;
            SICAtoOpenSPCoopContext sicaContext = new SICAtoOpenSPCoopContext();
            XMLUtils daoUtilities = new XMLUtils(sicaContext, this.logger);
            it.gov.spcoop.sica.dao.AccordoServizioParteComune aspcSICA = null;
            try {
                aspcSICA = daoUtilities.getAccordoServizioParteComune(archive);
            }
            catch (Exception e) {
                throw new SPCoopConvertToPackageCNIPAException("Conversione dell'archivio in package CNIPA non riuscita: " + e.getMessage(), e);
            }
            if (aspcSICA.getManifesto().getNome() == null) {
                throw new ProtocolException("Riscontrato un archivio che possiede un manifesto senza nome");
            }
            String soggettoReferente = aspcSICA.getManifesto().getParteComune().getPubblicatore();
            if (soggettoReferente != null && !registryReader.existsSoggettoByCodiceIPA(codiceIPA = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(soggettoReferente))) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPA + "] non esiste.");
            }
            if (validationDocuments) {
                SPCoopArchiveImportUtils.validazioneContenuti(aspcSICA);
            }
            SPCoopArchiveImportUtils.setIDSoggettoFromCodiceIPA(aspcSICA, sicaContext, registryReader);
            AccordoServizioParteComune aspcOpenSPCoop2 = null;
            try {
                aspcOpenSPCoop2 = SICAtoOpenSPCoopUtilities.accordoServizioParteComune_sicaToOpenspcoop(aspcSICA, sicaContext, this.logger);
                Archive archiveObject = new Archive();
                ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione("CnipaPackageASPC");
                ArchiveAccordoServizioParteComune archiveASPC = new ArchiveAccordoServizioParteComune(aspcOpenSPCoop2, idCorrelazione, true);
                archiveObject.getAccordiServizioParteComune().add((Object)archiveASPC);
                return archiveObject;
            }
            catch (Exception e) {
                throw new ProtocolException("Conversione dell'archivio, da formato CNIPA a formato OpenSPCoop2, non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (SPCoopConvertToPackageCNIPAException convert) {
            throw convert;
        }
        catch (Exception e) {
            throw new ProtocolException("Conversione archivio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public Archive buildAccordoServizioComposto(byte[] archive, IRegistryReader registryReader, boolean validationDocuments) throws ProtocolException, SPCoopConvertToPackageCNIPAException {
        try {
            String codiceIPA;
            SICAtoOpenSPCoopContext sicaContext = new SICAtoOpenSPCoopContext();
            XMLUtils daoUtilities = new XMLUtils(sicaContext, this.logger);
            AccordoServizioComposto asCompostoSICA = null;
            try {
                asCompostoSICA = daoUtilities.getAccordoServizioComposto(archive);
            }
            catch (Exception e) {
                throw new SPCoopConvertToPackageCNIPAException("Conversione dell'archivio in package CNIPA non riuscita: " + e.getMessage(), e);
            }
            if (asCompostoSICA.getManifesto().getNome() == null) {
                throw new ProtocolException("Riscontrato un archivio che possiede un manifesto senza nome");
            }
            String soggettoReferente = asCompostoSICA.getManifesto().getPubblicatore();
            if (soggettoReferente != null && !registryReader.existsSoggettoByCodiceIPA(codiceIPA = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(soggettoReferente))) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPA + "] non esiste.");
            }
            if (validationDocuments) {
                SPCoopArchiveImportUtils.validazioneContenuti(asCompostoSICA);
            }
            SPCoopArchiveImportUtils.setIDSoggettoFromCodiceIPA(asCompostoSICA, sicaContext, registryReader);
            SPCoopArchiveImportUtils.setIDServizioFromURI_APS(asCompostoSICA, sicaContext, registryReader);
            AccordoServizioParteComune asCompostoOpenSPCoop2 = null;
            try {
                asCompostoOpenSPCoop2 = SICAtoOpenSPCoopUtilities.accordoServizioComposto_sicaToOpenspcoop(asCompostoSICA, sicaContext, this.logger);
                Archive archiveObject = new Archive();
                ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione("CnipaPackageASC");
                ArchiveAccordoServizioComposto archiveASC = new ArchiveAccordoServizioComposto(asCompostoOpenSPCoop2, idCorrelazione, true);
                archiveObject.getAccordiServizioComposto().add((Object)archiveASC);
                return archiveObject;
            }
            catch (Exception e) {
                throw new ProtocolException("Conversione dell'archivio, da formato CNIPA a formato OpenSPCoop2, non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (SPCoopConvertToPackageCNIPAException convert) {
            throw convert;
        }
        catch (Exception e) {
            throw new ProtocolException("Conversione archivio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public Archive buildAccordoServizioParteSpecifica(byte[] archive, IRegistryReader registryReader, boolean validationDocuments) throws ProtocolException, SPCoopConvertToPackageCNIPAException {
        try {
            String codiceIPA;
            SICAtoOpenSPCoopContext sicaContext = new SICAtoOpenSPCoopContext();
            XMLUtils daoUtilities = new XMLUtils(sicaContext, this.logger);
            AccordoServizioParteSpecifica aspsSICA = null;
            try {
                aspsSICA = daoUtilities.getAccordoServizioParteSpecifica(archive);
            }
            catch (Exception e) {
                throw new SPCoopConvertToPackageCNIPAException("Conversione dell'archivio in package CNIPA non riuscita: " + e.getMessage(), e);
            }
            if (aspsSICA.getManifesto().getNome() == null) {
                throw new ProtocolException("Riscontrato un archivio che possiede un manifesto senza nome");
            }
            String soggettoErogatore = aspsSICA.getManifesto().getParteSpecifica().getErogatore();
            if (soggettoErogatore != null && !registryReader.existsSoggettoByCodiceIPA(codiceIPA = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(soggettoErogatore))) {
                throw new ProtocolException("Il soggetto referente con Codice IPA [" + codiceIPA + "] non esiste.");
            }
            if (validationDocuments) {
                SPCoopArchiveImportUtils.validazioneContenuti(aspsSICA);
            }
            SPCoopArchiveImportUtils.setIDSoggettoFromCodiceIPA(aspsSICA, sicaContext, registryReader);
            try {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica aspsOpenSPCoop2 = SICAtoOpenSPCoopUtilities.accordoServizioParteSpecifica_sicaToOpenspcoop(aspsSICA, sicaContext, this.logger);
                Archive archiveObject = new Archive();
                ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione("CnipaPackageASPS");
                ArchiveAccordoServizioParteSpecifica archiveASPS = new ArchiveAccordoServizioParteSpecifica(aspsOpenSPCoop2, idCorrelazione, true);
                archiveObject.getAccordiServizioParteSpecifica().add((Object)archiveASPS);
                return archiveObject;
            }
            catch (Exception e) {
                throw new ProtocolException("Conversione dell'archivio, da formato CNIPA a formato OpenSPCoop2, non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (SPCoopConvertToPackageCNIPAException convert) {
            throw convert;
        }
        catch (Exception e) {
            throw new ProtocolException("Conversione archivio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public Archive buildAccordoCooperazione(byte[] archive, IRegistryReader registryReader) throws ProtocolException, SPCoopConvertToPackageCNIPAException {
        try {
            String codiceIPA;
            SICAtoOpenSPCoopContext sicaContext = new SICAtoOpenSPCoopContext();
            XMLUtils daoUtilities = new XMLUtils(sicaContext, this.logger);
            it.gov.spcoop.sica.dao.AccordoCooperazione acSICA = null;
            try {
                acSICA = daoUtilities.getAccordoCooperazione(archive);
            }
            catch (Exception e) {
                throw new SPCoopConvertToPackageCNIPAException("Conversione dell'archivio in package CNIPA non riuscita: " + e.getMessage(), e);
            }
            if (acSICA.getManifesto().getNome() == null) {
                throw new ProtocolException("Riscontrato un archivio che possiede un manifesto senza nome");
            }
            String soggettoCoordinatore = acSICA.getManifesto().getCoordinatore();
            if (soggettoCoordinatore != null && !registryReader.existsSoggettoByCodiceIPA(codiceIPA = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(soggettoCoordinatore))) {
                throw new ProtocolException("Il soggetto coordinatore con Codice IPA [" + codiceIPA + "] non esiste.");
            }
            if (acSICA.getManifesto() != null && acSICA.getManifesto().getElencoPartecipanti() != null) {
                for (int i = 0; i < acSICA.getManifesto().getElencoPartecipanti().sizePartecipanteList(); ++i) {
                    String partecipante = acSICA.getManifesto().getElencoPartecipanti().getPartecipante(i);
                    String codiceIPA2 = SICAtoOpenSPCoopUtilities.removeURI_IDSoggettoSica(partecipante);
                    if (registryReader.existsSoggettoByCodiceIPA(codiceIPA2)) continue;
                    throw new ProtocolException("Il soggetto partecipante con Codice IPA [" + codiceIPA2 + "] non esiste.");
                }
            }
            SPCoopArchiveImportUtils.setIDSoggettoFromCodiceIPA(acSICA, sicaContext, registryReader);
            AccordoCooperazione acOpenSPCoop2 = null;
            try {
                acOpenSPCoop2 = SICAtoOpenSPCoopUtilities.accordoCooperazione_sicaToOpenspcoop(acSICA, sicaContext, this.logger);
                Archive archiveObject = new Archive();
                ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione("CnipaPackageAC");
                ArchiveAccordoCooperazione archiveAC = new ArchiveAccordoCooperazione(acOpenSPCoop2, idCorrelazione, true);
                archiveObject.getAccordiCooperazione().add((Object)archiveAC);
                return archiveObject;
            }
            catch (Exception e) {
                throw new ProtocolException("Conversione dell'archivio, da formato CNIPA a formato OpenSPCoop2, non riuscita: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (SPCoopConvertToPackageCNIPAException convert) {
            throw convert;
        }
        catch (Exception e) {
            throw new ProtocolException("Conversione archivio non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }
}

