/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.web.lib.audit.dao.Filtro;
import org.openspcoop2.web.lib.audit.log.Binary;
import org.openspcoop2.web.lib.audit.log.Operation;
import org.openspcoop2.web.lib.audit.log.constants.Stato;
import org.openspcoop2.web.lib.audit.log.constants.Tipologia;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class AuditHelper {
    HttpServletRequest request;
    PageData pd;
    HttpSession session;
    private static boolean useXml = false;

    public AuditHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        this.request = request;
        this.pd = pd;
        this.session = session;
    }

    public static boolean isUseXml() {
        return useXml;
    }

    public static void setUseXml(boolean useXml) {
        AuditHelper.useXml = useXml;
    }

    public List<DataElement> addAuditingToDati(String statoaudit, String stato, String dump, String formatodump, String log4j, int numFiltri) throws Exception {
        try {
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            String[] tipi = new String[]{"abilitato", "disabilitato"};
            String[] tipiLabels = new String[]{"abilitato", "disabilitato"};
            DataElement de = new DataElement();
            de.setLabel("Auditing");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato audit");
            de.setType(DataElementType.SELECT);
            de.setName("statoaudit");
            de.setValues(tipi);
            de.setLabels(tipiLabels);
            if (statoaudit != null) {
                de.setSelected(statoaudit);
            }
            de.setPostBack(true);
            dati.add(de);
            if (statoaudit != null && statoaudit.equals("abilitato")) {
                de = new DataElement();
                de.setLabel("Comportamento di Default");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Audit");
            if (statoaudit != null && statoaudit.equals("abilitato")) {
                de.setType(DataElementType.SELECT);
                de.setValues(tipi);
                de.setLabels(tipiLabels);
                if (stato != null) {
                    de.setSelected(stato);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(stato);
            }
            de.setName("stato");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dump");
            if (statoaudit != null && statoaudit.equals("abilitato")) {
                de.setType(DataElementType.SELECT);
                de.setValues(tipi);
                de.setLabels(tipiLabels);
                if (dump != null) {
                    de.setSelected(dump);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(dump);
            }
            de.setName("dump");
            dati.add(de);
            String[] tipiFormato = new String[]{"JSON", "XML"};
            de = new DataElement();
            de.setLabel("Formato dump");
            if (!useXml) {
                formatodump = "JSON";
            }
            if (useXml && statoaudit != null && statoaudit.equals("abilitato")) {
                de.setType(DataElementType.SELECT);
                de.setValues(tipiFormato);
                if (formatodump != null) {
                    de.setSelected(formatodump);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(formatodump);
            }
            de.setName("formatodump");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Log4j Auditing");
            if (statoaudit != null && statoaudit.equals("abilitato")) {
                de.setType(DataElementType.SELECT);
                de.setValues(tipi);
                de.setLabels(tipiLabels);
                if (log4j != null) {
                    de.setSelected(log4j);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(log4j);
            }
            de.setName("log4j");
            dati.add(de);
            if (statoaudit != null && statoaudit.equals("abilitato")) {
                de = new DataElement();
                de.setLabel("Filtri");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Visualizza");
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneAuditingFiltriList.do");
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numFiltri));
                dati.add(de);
            }
            return dati;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String auditCheckData(String statoaudit, String stato, String dump, String formatodump, String log4j) throws Exception {
        try {
            if (!statoaudit.equals("abilitato") && !statoaudit.equals("disabilitato")) {
                String msg = "Stato dev'essere abilitato o disabilitato";
                return msg;
            }
            if (!stato.equals("abilitato") && !stato.equals("disabilitato")) {
                String msg = "Audit dev'essere abilitato o disabilitato";
                return msg;
            }
            if (!dump.equals("abilitato") && !dump.equals("disabilitato")) {
                String msg = "Dump dev'essere abilitato o disabilitato";
                return msg;
            }
            if (!formatodump.equals("JSON") && !formatodump.equals("XML")) {
                String msg = "Formato dump dev'essere JSON o XML";
                return msg;
            }
            if (!log4j.equals("abilitato") && !log4j.equals("disabilitato")) {
                String msg = "Log4j Auditing dev'essere abilitato o disabilitato";
                return msg;
            }
            return "";
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void prepareFiltriList(ISearch ricerca, List<Filtro> lista, int idLista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneAuditingFiltri", (Parameter[])new Parameter[0]);
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Auditing", "configurazioneAuditing.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Filtri", null));
            } else {
                lstParam.add(new Parameter("Filtri", "configurazioneAuditingFiltriList.do"));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Filtri", (String)search);
            }
            String[] labels = new String[]{"Descrizione", "Stato", "Dump"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Filtro f : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneAuditingFiltriChange.do", new Parameter[]{new Parameter("id", "" + f.getId())});
                    de.setValue(f.toString());
                    de.setIdToRemove("" + f.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(f.isAuditEnabled() ? "abilitato" : "disabilitato");
                    e.add(de);
                    de = new DataElement();
                    de.setValue(f.isDumpEnabled() ? "abilitato" : "disabilitato");
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<DataElement> addFiltroToDati(Tipologia tipoOp, String utente, String tipooperazione, String[] tipiOgg, String tipooggetto, String statooperazione, String stato, String tipofiltro, String dump, String statoazione, String dumpazione, String id) throws Exception {
        try {
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            String[] tipi = new String[]{"abilitato", "disabilitato"};
            String[] tipiLabels = new String[]{"abilitato", "disabilitato"};
            DataElement de = null;
            if (tipoOp.equals(Tipologia.CHANGE)) {
                de = new DataElement();
                de.setValue(id);
                de.setType(DataElementType.HIDDEN);
                de.setName("id");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Filtro Generico");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Utente");
            de.setName("utente");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(utente);
            dati.add(de);
            String[] tipiOp = new String[]{"-", Tipologia.ADD.toString(), Tipologia.CHANGE.toString(), Tipologia.DEL.toString()};
            de = new DataElement();
            de.setLabel("Tipo operazione");
            de.setName("tipooperazione");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiOp);
            if (tipooperazione != null) {
                de.setSelected(tipooperazione);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo oggetto");
            de.setName("tipooggetto");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiOgg);
            if (tipooggetto != null) {
                de.setSelected(tipooggetto);
            }
            dati.add(de);
            String[] tipiStatoOp = new String[]{"-", Stato.REQUESTING.toString(), Stato.ERROR.toString(), Stato.COMPLETED.toString()};
            de = new DataElement();
            de.setLabel("Stato operazione");
            de.setName("statooperazione");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiStatoOp);
            if (statooperazione != null) {
                de.setSelected(statooperazione);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Filtro per Contenuto");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setName("stato");
            de.setValues(tipi);
            de.setLabels(tipiLabels);
            if (stato != null) {
                de.setSelected(stato);
            }
            de.setPostBack(true);
            dati.add(de);
            String[] tipiFiltro = new String[]{"normale", "espressioneRegolare"};
            de = new DataElement();
            de.setLabel("Tipo");
            de.setName("tipofiltro");
            if (stato != null && stato.equals("abilitato")) {
                de.setType(DataElementType.SELECT);
                de.setValues(tipiFiltro);
                if (tipofiltro != null) {
                    de.setSelected(tipofiltro);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipofiltro);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dump");
            de.setName("dump");
            if (stato != null && stato.equals("abilitato")) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(dump);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(dump);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Azione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setName("statoazione");
            de.setValues(tipi);
            de.setLabels(tipiLabels);
            if (statoazione != null) {
                de.setSelected(statoazione);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dump");
            de.setType(DataElementType.SELECT);
            de.setName("dumpazione");
            de.setValues(tipi);
            de.setLabels(tipiLabels);
            if (dumpazione != null) {
                de.setSelected(dumpazione);
            }
            dati.add(de);
            return dati;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String filtriCheckData(String utente, String tipooperazione, String tipooggetto, String statooperazione, String stato, String tipofiltro, String dump, String statoazione, String dumpazione, String[] tipiOgg) throws Exception {
        try {
            if (!(tipooperazione.equals("-") || tipooperazione.equals(Tipologia.ADD.toString()) || tipooperazione.equals(Tipologia.CHANGE.toString()) || tipooperazione.equals(Tipologia.DEL.toString()))) {
                String msg = "Tipo operazione dev'essere - o " + Tipologia.ADD.toString() + " o " + Tipologia.CHANGE.toString() + " o " + Tipologia.DEL.toString();
                return msg;
            }
            if (!(statooperazione.equals("-") || statooperazione.equals(Stato.REQUESTING.toString()) || statooperazione.equals(Stato.ERROR.toString()) || statooperazione.equals(Stato.COMPLETED.toString()))) {
                String msg = "Stato operazione dev'essere - o " + Stato.REQUESTING.toString() + " o " + Stato.ERROR.toString() + " o " + Stato.COMPLETED.toString();
                return msg;
            }
            if (!stato.equals("abilitato") && !stato.equals("disabilitato")) {
                String msg = "Stato dev'essere abilitato o disabilitato";
                return msg;
            }
            if (stato.equals("abilitato") && !tipofiltro.equals("normale") && !tipofiltro.equals("espressioneRegolare")) {
                String msg = "Tipo dev'essere normale o espressioneRegolare";
                return msg;
            }
            if (!statoazione.equals("abilitato") && !statoazione.equals("disabilitato")) {
                String msg = "Stato dev'essere abilitato o disabilitato";
                return msg;
            }
            if (!dumpazione.equals("abilitato") && !dumpazione.equals("disabilitato")) {
                String msg = "Dump dev'essere abilitato o disabilitato";
                return msg;
            }
            Object allOgg = "";
            boolean trovatoOgg = false;
            for (int i = 0; i < tipiOgg.length; ++i) {
                String tmpOgg = tipiOgg[i];
                if (tmpOgg.equals(tipooggetto)) {
                    trovatoOgg = true;
                }
                allOgg = ((String)allOgg).equals("") ? tmpOgg : (String)allOgg + ", " + tmpOgg;
            }
            if (!trovatoOgg) {
                String msg = "Il tipo oggetto dev'essere scelto tra: " + (String)allOgg;
                return msg;
            }
            if (stato.equals("abilitato") && dump.equals("")) {
                String msg = "Se Stato \u00e8 abilitato, Dump dev'essere valorizzato";
                return msg;
            }
            if (utente.equals("") && tipooperazione.equals("-") && tipooggetto.equals("-") && statooperazione.equals("-") && !"abilitato".equals(stato)) {
                String msg = "Specificare almeno un criterio di filtro generico o un filtro per contenuto";
                return msg;
            }
            return "";
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<DataElement> addAuditReportToDati(String datainizio, String datafine, String tipooperazione, String[] tipiOgg, String tipooggetto, String id, String oldid, String utente, String statooperazione, String contoggetto) throws Exception {
        try {
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            DataElement de = new DataElement();
            de.setLabel("Criteri di Ricerca");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            int valueSize = 40;
            de = new DataElement();
            de.setLabel("Inizio intervallo");
            de.setNote("Indicare una data nel formato 'yyyy-MM-dd'");
            de.setValue(datainizio != null ? datainizio : "");
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("datainizio");
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Fine intervallo");
            de.setNote("Indicare una data nel formato 'yyyy-MM-dd'");
            de.setValue(datafine != null ? datafine : "");
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("datafine");
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Utente");
            de.setName("utente");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(utente);
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Operazione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipiOp = new String[]{"-", Tipologia.ADD.toString(), Tipologia.CHANGE.toString(), Tipologia.DEL.toString(), Tipologia.LOGIN.toString(), Tipologia.LOGOUT.toString()};
            de = new DataElement();
            de.setLabel("Tipo");
            de.setName("tipooperazione");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiOp);
            if (tipooperazione != null) {
                de.setSelected(tipooperazione);
            }
            de.setSize(valueSize);
            dati.add(de);
            String[] tipiStatoOp = new String[]{"-", Stato.REQUESTING.toString(), Stato.ERROR.toString(), Stato.COMPLETED.toString()};
            de = new DataElement();
            de.setLabel("Stato");
            de.setName("statooperazione");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiStatoOp);
            if (statooperazione != null) {
                de.setSelected(statooperazione);
            }
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Oggetto");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo");
            de.setName("tipooggetto");
            de.setType(DataElementType.SELECT);
            de.setValues(tipiOgg);
            if (tipooggetto != null) {
                de.setSelected(tipooggetto);
            }
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Identificativo");
            de.setName("id");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(id);
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Id precedente alla modifica");
            de.setName("oldid");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(oldid);
            de.setSize(valueSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Contenuto");
            de.setName("contoggetto");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(contoggetto);
            de.setSize(valueSize);
            dati.add(de);
            return dati;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String auditReportCheckData(String datainizio, String datafine, String tipooperazione, String tipooggetto, String id, String oldid, String statooperazione, String[] tipiOgg) throws Exception {
        try {
            String msg;
            int bisestile;
            int giornoI;
            int meseI;
            int annoI;
            String giorno;
            String mese;
            String anno;
            if (!(tipooperazione.equals("-") || tipooperazione.equals(Tipologia.ADD.toString()) || tipooperazione.equals(Tipologia.CHANGE.toString()) || tipooperazione.equals(Tipologia.DEL.toString()) || tipooperazione.equals(Tipologia.LOGIN.toString()) || tipooperazione.equals(Tipologia.LOGOUT.toString()))) {
                String msg2 = "Tipo operazione dev'essere - o " + Tipologia.ADD.toString() + " o " + Tipologia.CHANGE.toString() + " o " + Tipologia.DEL.toString() + " o " + Tipologia.LOGIN.toString() + " o " + Tipologia.LOGOUT.toString();
                return msg2;
            }
            if (!(statooperazione.equals("-") || statooperazione.equals(Stato.REQUESTING.toString()) || statooperazione.equals(Stato.ERROR.toString()) || statooperazione.equals(Stato.COMPLETED.toString()))) {
                String msg3 = "Stato operazione dev'essere - o " + Stato.REQUESTING.toString() + " o " + Stato.ERROR.toString() + " o " + Stato.COMPLETED.toString();
                return msg3;
            }
            Object allOgg = "";
            boolean trovatoOgg = false;
            for (int i = 0; i < tipiOgg.length; ++i) {
                String tmpOgg = tipiOgg[i];
                if (tmpOgg.equals(tipooggetto)) {
                    trovatoOgg = true;
                }
                allOgg = ((String)allOgg).equals("") ? tmpOgg : (String)allOgg + ", " + tmpOgg;
            }
            if (!trovatoOgg) {
                String msg4 = "Il tipo oggetto dev'essere scelto tra: " + (String)allOgg;
                return msg4;
            }
            if (!(datainizio != null && !"".equals(datainizio) || id != null && !"".equals(id) || oldid != null && !"".equals(oldid))) {
                String msg5 = "Deve essere indicato almeno uno dei seguenti criteri di ricerca: Intervallo Iniziale, Identificativo, Id precedente alla modifica";
                return msg5;
            }
            if (datainizio != null && !"".equals(datainizio)) {
                boolean dataInOk = true;
                if (datainizio.length() != 10) {
                    dataInOk = false;
                } else {
                    anno = datainizio.substring(0, 4);
                    mese = datainizio.substring(5, 7);
                    giorno = datainizio.substring(8, 10);
                    if (!RegularExpressionEngine.isMatch((String)anno, (String)"^[0-9]+$")) {
                        dataInOk = false;
                    } else if (!datainizio.substring(4, 5).equals("-")) {
                        dataInOk = false;
                    } else if (!RegularExpressionEngine.isMatch((String)mese, (String)"^[0-9]+$")) {
                        dataInOk = false;
                    } else if (!datainizio.substring(7, 8).equals("-")) {
                        dataInOk = false;
                    } else if (!RegularExpressionEngine.isMatch((String)giorno, (String)"^[0-9]+$")) {
                        dataInOk = false;
                    } else {
                        annoI = Integer.parseInt(anno);
                        meseI = Integer.parseInt(mese);
                        giornoI = Integer.parseInt(giorno);
                        if (meseI == 1 || meseI == 3 || meseI == 5 || meseI == 7 || meseI == 8 || meseI == 10 || meseI == 12) {
                            if (giornoI == 0 || giornoI > 31) {
                                dataInOk = false;
                            }
                        } else if (meseI == 4 || meseI == 6 || meseI == 9 || meseI == 11) {
                            if (giornoI == 0 || giornoI > 30) {
                                dataInOk = false;
                            }
                        } else if (meseI == 2) {
                            bisestile = annoI / 4;
                            if (annoI != bisestile * 4) {
                                if (giornoI == 0 || giornoI > 28) {
                                    dataInOk = false;
                                }
                            } else if (giornoI == 0 || giornoI > 29) {
                                dataInOk = false;
                            }
                        } else {
                            dataInOk = false;
                        }
                    }
                }
                if (!dataInOk) {
                    msg = "Inizio intervallo espresso in una forma sbagliata. Esprimerlo come yyyy-MM-dd";
                    return msg;
                }
            }
            if (datafine != null && !"".equals(datafine)) {
                boolean dataFineOk = true;
                if (datafine.length() != 10) {
                    dataFineOk = false;
                } else {
                    anno = datafine.substring(0, 4);
                    mese = datafine.substring(5, 7);
                    giorno = datafine.substring(8, 10);
                    if (!RegularExpressionEngine.isMatch((String)anno, (String)"^[0-9]+$")) {
                        dataFineOk = false;
                    } else if (!datafine.substring(4, 5).equals("-")) {
                        dataFineOk = false;
                    } else if (!RegularExpressionEngine.isMatch((String)mese, (String)"^[0-9]+$")) {
                        dataFineOk = false;
                    } else if (!datafine.substring(7, 8).equals("-")) {
                        dataFineOk = false;
                    } else if (!RegularExpressionEngine.isMatch((String)giorno, (String)"^[0-9]+$")) {
                        dataFineOk = false;
                    } else {
                        annoI = Integer.parseInt(anno);
                        meseI = Integer.parseInt(mese);
                        giornoI = Integer.parseInt(giorno);
                        if (meseI == 1 || meseI == 3 || meseI == 5 || meseI == 7 || meseI == 8 || meseI == 10 || meseI == 12) {
                            if (giornoI == 0 || giornoI > 31) {
                                dataFineOk = false;
                            }
                        } else if (meseI == 4 || meseI == 6 || meseI == 9 || meseI == 11) {
                            if (giornoI == 0 || giornoI > 30) {
                                dataFineOk = false;
                            }
                        } else if (meseI == 2) {
                            bisestile = annoI / 4;
                            if (annoI != bisestile * 4) {
                                if (giornoI == 0 || giornoI > 28) {
                                    dataFineOk = false;
                                }
                            } else if (giornoI == 0 || giornoI > 29) {
                                dataFineOk = false;
                            }
                        } else {
                            dataFineOk = false;
                        }
                    }
                }
                if (!dataFineOk) {
                    msg = "Fine intervallo espresso in una forma sbagliata. Esprimerlo come yyyy-MM-dd";
                    return msg;
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void prepareAuditReportList(ISearch ricerca, List<Operation> lista, int idLista, String datainizio, String datafine, String tipooperazione, String tipooggetto, String id, String oldid, String utente, String statooperazione, String contoggetto) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"auditing", (Parameter[])new Parameter[0]);
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Parameter pDataInizio = new Parameter("datainizio", datainizio);
            Parameter pDataFine = new Parameter("datafine", datafine);
            Parameter pTipoOperazione = new Parameter("tipooperazione", tipooperazione);
            Parameter pTipoOggetto = new Parameter("tipooggetto", tipooggetto);
            Parameter pId = new Parameter("id", id);
            Parameter pOldId = new Parameter("oldid", oldid);
            Parameter pUtente = new Parameter("utente", utente);
            Parameter pStatoOperazione = new Parameter("statooperazione", statooperazione);
            Parameter pContoggetto = new Parameter("contoggetto", contoggetto);
            Parameter pEditModeFin = ServletUtils.getParameterForEditModeFinished();
            String params = ServletUtils.getParametersAsString((boolean)false, (Parameter[])new Parameter[]{pDataInizio, pDataFine, pTipoOperazione, pTipoOggetto, pId, pOldId, pUtente, pStatoOperazione, pContoggetto, pEditModeFin});
            ArrayList<GeneralLink> titlelist = new ArrayList<GeneralLink>();
            GeneralLink tl1 = new GeneralLink();
            tl1.setLabel("Auditing");
            tl1.setUrl("auditing.do");
            titlelist.add(tl1);
            GeneralLink tl2 = new GeneralLink();
            tl2.setLabel("Operazioni");
            titlelist.add(tl2);
            this.pd.setTitleList(titlelist);
            this.pd.setSearch("off");
            String[] labels = new String[]{"Data", "Operazione", "Stato", "Oggetto", "ID", "Utente"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Operation op : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("auditingDettaglio.do", new Parameter[]{new Parameter("idop", "" + op.getId()), pDataInizio, pDataFine, pTipoOperazione, pTipoOggetto, pId, pOldId, pUtente, pStatoOperazione, pContoggetto});
                    de.setValue(DateUtils.getSimpleDateFormatMs().format(op.getTimeExecute()));
                    de.setIdToRemove("" + op.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getTipologia().getValue());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getStato().getValue());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getTipoOggetto());
                    e.add(de);
                    de = new DataElement();
                    if (op.getObjectId() != null && op.getObjectId().length() > 60) {
                        de.setValue(op.getObjectId().substring(0, 60) + " ...");
                        de.setToolTip(op.getObjectId());
                    } else {
                        de.setValue(op.getObjectId());
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setValue(op.getUtente());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            this.request.setAttribute("params", (Object)params);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<DataElement> addAuditReportDettaglioToDati(Operation op, boolean showLinkDocumentiBinari, Parameter ... params) throws Exception {
        try {
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            Parameter pIdOp = new Parameter("idop", "" + op.getId());
            Parameter pTypeOggetto = new Parameter("type", "oggetto");
            Parameter pTypeErrore = new Parameter("type", "error");
            DataElement de = new DataElement();
            de.setLabel("Dettaglio Operazione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Time request");
            de.setValue("" + op.getTimeRequest());
            de.setType(DataElementType.TEXT);
            de.setName("timereq");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Time execute");
            de.setValue("" + op.getTimeExecute());
            de.setType(DataElementType.TEXT);
            de.setName("timeex");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Id operazione");
            de.setValue("" + op.getId());
            de.setType(DataElementType.TEXT);
            de.setName("iddbop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo operazione");
            de.setValue(op.getTipologia().getValue());
            de.setType(DataElementType.TEXT);
            de.setName("tipoop");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo oggetto");
            de.setValue(op.getTipoOggetto());
            de.setType(DataElementType.TEXT);
            de.setName("tipoogg");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Identificativo");
            de.setValue(op.getObjectId());
            de.setType(DataElementType.TEXT);
            de.setName("objid");
            dati.add(de);
            if (op.getObjectOldId() != null) {
                de = new DataElement();
                de.setLabel("Id precedente alla modifica");
                de.setValue(op.getObjectOldId());
                de.setType(DataElementType.TEXT);
                de.setName("objoldid");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Utente");
            de.setValue(op.getUtente());
            de.setType(DataElementType.TEXT);
            de.setName("utente");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setValue(op.getStato().getValue());
            de.setType(DataElementType.TEXT);
            de.setName("stato");
            dati.add(de);
            int size2 = params != null ? params.length + 2 : 2;
            Parameter[] paramsErr = new Parameter[size2];
            Parameter[] paramsOgg = new Parameter[size2];
            paramsErr[0] = pIdOp;
            paramsErr[1] = pTypeErrore;
            paramsOgg[0] = pIdOp;
            paramsOgg[1] = pTypeOggetto;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    paramsErr[i + 2] = params[i];
                    paramsOgg[i + 2] = params[i];
                }
            }
            if (Stato.ERROR.equals(op.getStato())) {
                de = new DataElement();
                de.setLabel("Motivo errore");
                de.setUrl("auditingDettaglioInfo.do", paramsErr);
                de.setValue("Motivo errore");
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Dettaglio Oggetto");
            if (op.getObjectDetails() != null && !"".equals(op.getObjectDetails())) {
                de.setUrl("auditingDettaglioInfo.do", paramsOgg);
                de.setType(DataElementType.LINK);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue("Dettaglio Oggetto");
            dati.add(de);
            int size = params != null ? params.length + 1 : 1;
            Parameter[] params2 = new Parameter[size];
            params2[0] = pIdOp;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    params2[i + 1] = params[i];
                }
            }
            if (showLinkDocumentiBinari) {
                de = new DataElement();
                de.setLabel("Documenti Binari");
                de.setUrl("auditingDettaglioDocumentiBinari.do", params2);
                de.setValue("Documenti Binari (" + op.sizeBinaryList() + ")");
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            return dati;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<DataElement> addAuditReportInfoToDati(String type, String info) throws Exception {
        try {
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            DataElement de = new DataElement();
            de.setLabel("Dettaglio Oggetto");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            if (type.equals("error")) {
                de.setLabel("Motivo errore");
            }
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setValue(info);
            de.setRows(30);
            de.setCols(80);
            dati.add(de);
            return dati;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void prepareDocBinList(Operation singleOp, Parameter ... params) throws Exception {
        try {
            this.pd.setNumEntries(singleOp.sizeBinaryList());
            Parameter pIdOp = new Parameter("idop", "" + singleOp.getId());
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            int size = params != null ? params.length + 1 : 1;
            Parameter[] params2 = new Parameter[size];
            params2[0] = pIdOp;
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    params2[i + 1] = params[i];
                }
            }
            lstParam.add(new Parameter("Auditing", "auditing.do"));
            lstParam.add(new Parameter("Operazioni", "auditing.do", params));
            lstParam.add(new Parameter("Dettaglio di " + singleOp.getId(), "auditingDettaglio.do", params2));
            lstParam.add(new Parameter("Documenti Binari", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            this.pd.setSearch("off");
            String[] labels = new String[]{"ID", "Checksum"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            for (int i = 0; i < singleOp.sizeBinaryList(); ++i) {
                Binary bin = singleOp.getBinary(i);
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue(bin.getBinaryId());
                e.add(de);
                de = new DataElement();
                de.setValue("" + bin.getChecksum());
                e.add(de);
                dati.add(e);
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            this.pd.setSelect(false);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

