/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v1_2.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.v1_2.drivers.DriverConfigurazioneServiziOpenSPCoopV1;
import it.link.pdd.tools.migrazione_govway.wrapper.IdSoggettoWrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.slf4j.Logger;

public class IdConverter {
    private org.openspcoop.dao.registry.driver.DriverRegistroServiziDB driverRegistroOp1;
    private DriverConfigurazioneServiziOpenSPCoopV1 driverConfigurazioneServiziOp1;
    private DriverRegistroServiziDB driverRegistro;
    private boolean dsModeIn;
    private boolean dsModeOut;
    private Connection connection;
    private Connection connectionOut;
    private org.openspcoop.dao.commons.IDSoggetto[] idSoggetti;
    private org.openspcoop.dao.commons.IDSoggetto[] idSoggettiDefault;
    private Logger log = LoggerWrapperFactory.getLogger((String)"migrazione");

    public void closeConnection() throws SQLException {
        if (!this.dsModeIn) {
            this.connection.close();
        }
        if (!this.dsModeOut) {
            this.connectionOut.close();
        }
    }

    public IdConverter(DatabaseProperties initIn, DatabaseProperties initOut) throws Exception {
        try {
            this.dsModeIn = initIn.isDataSourceMode();
            this.dsModeOut = initOut.isDataSourceMode();
            if (this.dsModeIn) {
                this.driverRegistroOp1 = new org.openspcoop.dao.registry.driver.DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverConfigurazioneServiziOp1 = new DriverConfigurazioneServiziOpenSPCoopV1(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                this.driverRegistroOp1 = new org.openspcoop.dao.registry.driver.DriverRegistroServiziDB(this.connection, null, initIn.getTipoDatabase());
                this.driverConfigurazioneServiziOp1 = new DriverConfigurazioneServiziOpenSPCoopV1(this.connection, this.log, initIn.getTipoDatabase());
            }
            if (this.dsModeOut) {
                this.driverRegistro = new DriverRegistroServiziDB(initOut.getJndiName(), initOut.getJndiProp(), initOut.getTipoDatabase());
            } else {
                Class.forName(initOut.getDriverJDBC());
                this.connectionOut = DriverManager.getConnection(initOut.getConnectionURL(), initOut.getUsername(), initOut.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connectionOut, this.log, initOut.getTipoDatabase());
            }
            this.idSoggetti = this.driverConfigurazioneServiziOp1.getAllIdSoggettiConfig();
            if (this.idSoggetti == null) {
                throw new Exception("Non esistono soggetti");
            }
            IdSoggettoWrapper[] idSoggettiDefault2 = MigrazioneProperties.getInstance().getIdSoggettiDefault();
            this.idSoggettiDefault = new org.openspcoop.dao.commons.IDSoggetto[idSoggettiDefault2.length];
            int i = 0;
            for (IdSoggettoWrapper idSoggetto : idSoggettiDefault2) {
                this.idSoggettiDefault[i] = new org.openspcoop.dao.commons.IDSoggetto();
                this.idSoggettiDefault[i].setCodicePorta(idSoggetto.getCodicePorta());
                this.idSoggettiDefault[i].setNome(idSoggetto.getNome());
                this.idSoggettiDefault[i].setTipo(idSoggetto.getTipo());
                ++i;
            }
        }
        catch (Exception e) {
            this.log.error("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), e);
        }
    }

    public Long getIdSoggetto(Long idSoggetto) throws Exception {
        SoggettoSpcoop soggetto = this.driverRegistroOp1.getSoggettoRegistro(idSoggetto.longValue());
        IDSoggetto id = new IDSoggetto();
        id.setNome(soggetto.getNome());
        id.setTipo(soggetto.getTipo());
        Soggetto soggettoOp2 = this.driverRegistro.getSoggetto(id);
        return soggettoOp2.getId();
    }

    public org.openspcoop.dao.commons.IDSoggetto getIdSoggetto(String idPorta, boolean mustExist) throws Exception {
        int i;
        for (i = 0; i < this.idSoggetti.length; ++i) {
            if (!this.idSoggetti[i].getCodicePorta().equals(idPorta)) continue;
            return this.idSoggetti[i];
        }
        for (i = 0; i < this.idSoggettiDefault.length; ++i) {
            if (!this.idSoggettiDefault[i].getCodicePorta().equals(idPorta)) continue;
            return this.idSoggettiDefault[i];
        }
        if (!mustExist) {
            return null;
        }
        throw new Exception("Nessun soggetto con codice porta [" + idPorta + "]");
    }

    public org.openspcoop.dao.commons.IDSoggetto getIdSoggetto(String nomeSoggetto, String tipoSoggetto, boolean mustExists) throws Exception {
        return this.getIdSoggetto(nomeSoggetto, tipoSoggetto, mustExists, false);
    }

    public org.openspcoop.dao.commons.IDSoggetto getIdSoggetto(String nomeSoggetto, String tipoSoggetto, boolean mustExists, boolean searchInDefault) throws Exception {
        int i;
        for (i = 0; i < this.idSoggetti.length; ++i) {
            if (!this.idSoggetti[i].getNome().equals(nomeSoggetto) || !this.idSoggetti[i].getTipo().equals(tipoSoggetto)) continue;
            return this.idSoggetti[i];
        }
        if (searchInDefault) {
            for (i = 0; i < this.idSoggettiDefault.length; ++i) {
                if (!this.idSoggettiDefault[i].getNome().equals(nomeSoggetto) || !this.idSoggettiDefault[i].getTipo().equals(tipoSoggetto)) continue;
                return this.idSoggettiDefault[i];
            }
        }
        if (!mustExists) {
            return null;
        }
        throw new Exception("Nessun soggetto con nome [" + nomeSoggetto + "] e tipo [" + tipoSoggetto + "]");
    }

    public AccordoServizioParteComune getAccordoPC(Long idAccordo) throws Exception {
        return this.getAccordoPC(this.driverRegistroOp1.getAccordoServizio(idAccordo.longValue()));
    }

    public AccordoServizioParteComune getAccordoPC(AccordoServizio accordo) throws Exception {
        IDAccordo id;
        IDSoggetto soggettoReferente = new IDSoggetto();
        if (accordo.getSoggettoReferente() != null) {
            soggettoReferente.setNome(accordo.getSoggettoReferente().getNome());
            soggettoReferente.setTipo(accordo.getSoggettoReferente().getTipo());
        } else {
            MigrazioneProperties p = null;
            try {
                p = MigrazioneProperties.getInstance();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            soggettoReferente.setTipo(p.getTipoSoggettoReferenteDefault());
            soggettoReferente.setNome(p.getNomeSoggettoReferenteDefault());
        }
        if (accordo.getVersione() == null || accordo.getVersione().isEmpty()) {
            accordo.setVersione("1");
        }
        String soggetto = (id = IDAccordoFactory.getInstance().getIDAccordoFromValues(accordo.getNome(), soggettoReferente, accordo.getVersione())).getSoggettoReferente() != null ? id.getSoggettoReferente().getTipo() + "/" + id.getSoggettoReferente().getNome() : "";
        this.log.debug("Cerco accordo con id nome[" + id.getNome() + "] soggetto[" + soggetto + "] versione[" + id.getVersione() + "]");
        return this.driverRegistro.getAccordoServizioParteComune(id);
    }

    public Long getIdAccordo(Long idAccordo) throws Exception {
        return this.getAccordoPC(idAccordo).getId();
    }
}

