/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v1_2.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.reader.IConfigurazioneServiziReader;
import it.link.pdd.tools.migrazione_govway.v1_2.drivers.DriverConfigurazioneServiziOpenSPCoopV1;
import it.link.pdd.tools.migrazione_govway.v1_2.reader.ConfigurazioneServiziConverter;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaApplicativaV1Wrapper;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaDelegataV1Wrapper;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaDominioV1Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.ConnettoriProperty;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaDelegata;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.driver.DriverConfigurazioneDB;
import org.openspcoop.dao.config.driver.IDPortaDelegata;
import org.openspcoop.dao.config.driver.IDServizioApplicativo;
import org.openspcoop.dao.config.driver.IDriverConfigurazioneGet;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziDB;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.slf4j.Logger;

public class ConfigurazioneServiziReader
implements IConfigurazioneServiziReader {
    private IDriverRegistroServiziGet driverRegistro;
    private IDriverConfigurazioneGet driverConfigurazione;
    private DriverConfigurazioneServiziOpenSPCoopV1 driverAvanzato;
    private boolean dsMode;
    private Connection connection;
    private ConfigurazioneServiziConverter converter;

    public void closeConnection() throws SQLException {
        if (!this.dsMode) {
            this.connection.close();
        }
    }

    public ConfigurazioneServiziReader(DatabaseProperties initIn, DatabaseProperties initOut, Logger log) throws Exception {
        try {
            this.dsMode = initIn.isDataSourceMode();
            this.converter = new ConfigurazioneServiziConverter(initIn, initOut);
            if (this.dsMode) {
                this.driverRegistro = new DriverRegistroServiziDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(initIn.getJndiName(), initIn.getJndiProp(), initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV1(initIn.getJndiName(), initIn.getJndiProp(), log, initIn.getTipoDatabase());
            } else {
                Class.forName(initIn.getDriverJDBC());
                this.connection = DriverManager.getConnection(initIn.getConnectionURL(), initIn.getUsername(), initIn.getPassword());
                this.driverRegistro = new DriverRegistroServiziDB(this.connection, null, initIn.getTipoDatabase());
                this.driverConfigurazione = new DriverConfigurazioneDB(this.connection, null, initIn.getTipoDatabase());
                this.driverAvanzato = new DriverConfigurazioneServiziOpenSPCoopV1(this.connection, log, initIn.getTipoDatabase());
            }
        }
        catch (Exception e) {
            log.error("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), (Throwable)e);
            throw new Exception("Impossibile inizializzare il driver del database OpenSPCoop1 di partenza: " + e.getMessage(), e);
        }
    }

    public List<PortaDominioV2Wrapper> findAllPdD() throws Exception {
        ArrayList<PortaDominioV1Wrapper> lst = new ArrayList<PortaDominioV1Wrapper>();
        String[] allId = null;
        try {
            allId = this.driverRegistro.getAllIdPorteDominio(new FiltroSPCoop());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (String id : allId) {
                PortaDominioV1Wrapper wrapper = new PortaDominioV1Wrapper();
                wrapper.setPorta(this.driverRegistro.getPortaDominio(id));
                wrapper.setTipo(this.driverAvanzato.getTipoPortaDominio(id));
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPdD(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> findAllSoggettiRegistro() throws Exception {
        ArrayList<org.openspcoop.dao.registry.SoggettoSpcoop> lst = new ArrayList<org.openspcoop.dao.registry.SoggettoSpcoop>();
        IDSoggetto[] allId = null;
        try {
            allId = this.driverRegistro.getAllIdSoggettiRegistro(new FiltroSPCoop());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (IDSoggetto id : allId) {
                lst.add(this.driverRegistro.getSoggettoRegistro(id));
            }
        }
        return this.converter.convertListSoggettiRegistro(lst);
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneNonComposti() throws Exception {
        ArrayList<AccordoServizio> lst = new ArrayList<AccordoServizio>();
        org.openspcoop.dao.registry.driver.IDAccordo[] allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizio(new FiltroAccordiSPCoop());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (org.openspcoop.dao.registry.driver.IDAccordo id : allId) {
                AccordoServizio accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizio(id, true);
                if (accordo.getServizioComposto() != null) continue;
                lst.add(accordo);
            }
        }
        return this.converter.convertListAccordiParteComune(lst);
    }

    public List<AccordoServizioParteSpecifica> findAllServizi(List<IDAccordo> lstIds) throws Exception {
        ArrayList<ServizioSpcoop> lst = new ArrayList<ServizioSpcoop>();
        for (IDAccordo idAccordo : lstIds) {
            FiltroServiziSPCoop filtro = new FiltroServiziSPCoop();
            filtro.setIdAccordo(this.converter.toIdAccordoV1(idAccordo));
            try {
                IDServizio[] allId = this.driverRegistro.getAllIdServizi(filtro);
                if (allId == null) continue;
                for (IDServizio id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getServizio(id, true));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
        }
        return this.converter.convertListServizi(lst, false);
    }

    public List<AccordoServizioParteSpecifica> findAllServiziCorrelati(List<IDAccordo> lstIds) throws Exception {
        ArrayList<ServizioSpcoop> lst = new ArrayList<ServizioSpcoop>();
        for (IDAccordo idAccordo : lstIds) {
            FiltroServiziSPCoop filtro = new FiltroServiziSPCoop();
            filtro.setIdAccordo(this.converter.toIdAccordoV1(idAccordo));
            try {
                IDServizio[] allId = this.driverRegistro.getAllIdServiziCorrelati(filtro);
                if (allId == null) continue;
                for (IDServizio id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getServizioCorrelato(id, true));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
        }
        return this.converter.convertListServizi(lst, true);
    }

    public List<AccordoServizioParteComune> findAllAccordiParteComuneComposti() throws Exception {
        ArrayList<AccordoServizio> lst = new ArrayList<AccordoServizio>();
        org.openspcoop.dao.registry.driver.IDAccordo[] allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizio(new FiltroAccordiSPCoop());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (org.openspcoop.dao.registry.driver.IDAccordo id : allId) {
                AccordoServizio accordo = ((DriverRegistroServiziDB)this.driverRegistro).getAccordoServizio(id, true);
                if (accordo.getServizioComposto() == null) continue;
                lst.add(accordo);
            }
        }
        return this.converter.convertListAccordiParteComune(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione> findAllAccordiCooperazione() throws Exception {
        ArrayList<AccordoCooperazione> lst = new ArrayList<AccordoCooperazione>();
        try {
            IDAccordoCooperazione[] allId = this.driverRegistro.getAllIdAccordiCooperazione(new FiltroAccordiSPCoop());
            if (allId != null) {
                for (IDAccordoCooperazione id : allId) {
                    lst.add(((DriverRegistroServiziDB)this.driverRegistro).getAccordoCooperazione(id, true));
                }
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        return this.converter.convertListAccordiCooperazione(lst);
    }

    public List<Soggetto> findAllSoggettiConfig() throws Exception {
        ArrayList<SoggettoSpcoop> lst = new ArrayList<SoggettoSpcoop>();
        IDSoggetto[] allId = this.driverAvanzato.getAllIdSoggettiConfig();
        if (allId != null) {
            for (IDSoggetto id : allId) {
                lst.add(this.driverConfigurazione.getSoggetto(id));
            }
        }
        return this.converter.convertListSoggettiConfig(lst);
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo> findAllServiziApplicativi() throws Exception {
        ArrayList<ServizioApplicativo> lst = new ArrayList<ServizioApplicativo>();
        IDServizioApplicativo[] allId = this.driverAvanzato.getAllIdServiziApplicativi();
        if (allId != null) {
            for (IDServizioApplicativo id : allId) {
                lst.add(this.driverConfigurazione.getServizioApplicativo(id));
            }
        }
        return this.converter.convertListServiziApplicativi(lst);
    }

    public List<PortaApplicativaV2Wrapper> findAllPorteApplicative() throws Exception {
        ArrayList<PortaApplicativaV1Wrapper> lst = new ArrayList<PortaApplicativaV1Wrapper>();
        Long[] allId = this.driverAvanzato.getAllIdPorteApplicative();
        if (allId != null) {
            for (Long id : allId) {
                PortaApplicativaV1Wrapper wrapper = new PortaApplicativaV1Wrapper();
                PortaApplicativa pa = ((DriverConfigurazioneDB)this.driverConfigurazione).getPortaApplicativa(id.longValue());
                wrapper.setPortaApplicativa(pa);
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPorteApplicative(lst);
    }

    public List<PortaDelegataV2Wrapper> findAllPorteDelegate() throws Exception {
        ArrayList<PortaDelegataV1Wrapper> lst = new ArrayList<PortaDelegataV1Wrapper>();
        IDPortaDelegata[] allId = this.driverAvanzato.getAllIdPorteDelegata();
        if (allId != null) {
            for (IDPortaDelegata id : allId) {
                PortaDelegataV1Wrapper wrapper = new PortaDelegataV1Wrapper();
                PortaDelegata pd = this.driverConfigurazione.getPortaDelegata(id);
                if (pd.getAutorizzazione() != null && "openspcoop".equals(pd.getAutorizzazione())) {
                    pd.setAutorizzazione("authenticated");
                }
                if (pd.getAutorizzazione() == null || "".equals(pd.getAutorizzazione())) {
                    pd.setAutorizzazione("none");
                }
                wrapper.setPortaDelegata(pd);
                lst.add(wrapper);
            }
        }
        return this.converter.convertListPorteDelegate(lst);
    }

    public List<IDAccordo> findIdAccordiNonComposti() throws Exception {
        ArrayList<IDAccordo> lst = new ArrayList<IDAccordo>();
        org.openspcoop.dao.registry.driver.IDAccordo[] allId = this.driverRegistro.getAllIdAccordiServizio(new FiltroAccordiSPCoop());
        if (allId != null) {
            for (org.openspcoop.dao.registry.driver.IDAccordo id : allId) {
                AccordoServizio accordo = this.driverRegistro.getAccordoServizio(id);
                if (accordo.getServizioComposto() != null) continue;
                lst.add(this.converter.toIdAccordoV2(id, false));
            }
        }
        return lst;
    }

    public List<IDAccordo> findIdAccordiComposti() throws Exception {
        ArrayList<IDAccordo> lst = new ArrayList<IDAccordo>();
        org.openspcoop.dao.registry.driver.IDAccordo[] allId = null;
        try {
            allId = this.driverRegistro.getAllIdAccordiServizio(new FiltroAccordiSPCoop());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (allId != null) {
            for (org.openspcoop.dao.registry.driver.IDAccordo id : allId) {
                AccordoServizio accordo = this.driverRegistro.getAccordoServizio(id);
                if (accordo.getServizioComposto() == null) continue;
                lst.add(this.converter.toIdAccordoV2(id, false));
            }
        }
        return lst;
    }

    public List<ConnettoriProperty> findAllConnettoriProperties() throws Exception {
        ArrayList<ConnettoriProperty> lst = new ArrayList<ConnettoriProperty>();
        List<String> ids = this.driverAvanzato.findAllIdConnettoreProperties();
        for (String id : ids) {
            lst.add(this.driverAvanzato.getConnettoreProperties(id));
        }
        return lst;
    }

    public List<Ruolo> findAllRuoli() throws Exception {
        return new ArrayList<Ruolo>();
    }
}

