/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.v1_2.reader;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreCodiceTrasporto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneCredenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataSoggettoErogatore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ProprietaProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RispostaAsincrona;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaRichiestaIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.FaultIntegrazioneTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.GestioneErroreComportamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.InvocazioneServizioTipoAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataAzioneIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataServizioIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalitaConWarning;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.ValidazioneContenutiApplicativiTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazionePartecipanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Azione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingStyle;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingUse;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.properties.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.properties.MigrazioneProperties;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.v1_2.reader.IdConverter;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaApplicativaV1Wrapper;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaDelegataV1Wrapper;
import it.link.pdd.tools.migrazione_govway.v1_2.wrapper.PortaDominioV1Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaApplicativaV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDelegataV2Wrapper;
import it.link.pdd.tools.migrazione_govway.wrapper.PortaDominioV2Wrapper;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.config.CorrelazioneApplicativa;
import org.openspcoop.dao.config.GestioneErroreSoapFault;
import org.openspcoop.dao.config.InvocazionePorta;
import org.openspcoop.dao.config.InvocazionePortaGestioneErrore;
import org.openspcoop.dao.config.InvocazioneServizio;
import org.openspcoop.dao.config.PortaApplicativa;
import org.openspcoop.dao.config.PortaApplicativaAzione;
import org.openspcoop.dao.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop.dao.config.PortaDelegataAzione;
import org.openspcoop.dao.config.PortaDelegataSoggettoSpcoopErogatore;
import org.openspcoop.dao.config.ServizioApplicativo;
import org.openspcoop.dao.config.SetSpcoopProperty;
import org.openspcoop.dao.config.SoggettoSpcoop;
import org.openspcoop.dao.config.ValidazioneContenutiApplicativi;
import org.openspcoop.dao.config.WsSecurity;
import org.openspcoop.dao.config.WsSecurityRequestFlowParameter;
import org.openspcoop.dao.config.WsSecurityResponseFlowParameter;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;

public class ConfigurazioneServiziConverter {
    private IdConverter idConverter;

    public ConfigurazioneServiziConverter(DatabaseProperties initIn, DatabaseProperties initOut) throws Exception {
        this.idConverter = new IdConverter(initIn, initOut);
    }

    public org.openspcoop.dao.registry.driver.IDAccordo toIdAccordoV1(IDAccordo idAccordo) throws org.openspcoop.dao.registry.driver.DriverRegistroServiziException {
        IDSoggetto soggettoReferente = null;
        if (idAccordo.getSoggettoReferente() != null) {
            soggettoReferente = new IDSoggetto();
            soggettoReferente.setNome(idAccordo.getSoggettoReferente().getNome());
            soggettoReferente.setTipo(idAccordo.getSoggettoReferente().getTipo());
            soggettoReferente.setCodicePorta(idAccordo.getSoggettoReferente().getCodicePorta());
        }
        return org.openspcoop.dao.registry.driver.IDAccordo.getIDAccordoFromValues((String)idAccordo.getNome(), (IDSoggetto)soggettoReferente, (String)idAccordo.getVersione());
    }

    public IDAccordo toIdAccordoV2(org.openspcoop.dao.registry.driver.IDAccordo idAccordo, boolean setSoggettoReferenteDefault) throws DriverRegistroServiziException {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto soggettoReferente = null;
        if (idAccordo.getSoggettoReferente() != null) {
            soggettoReferente = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto();
            soggettoReferente.setNome(idAccordo.getSoggettoReferente().getNome());
            soggettoReferente.setTipo(idAccordo.getSoggettoReferente().getTipo());
            soggettoReferente.setCodicePorta(idAccordo.getSoggettoReferente().getCodicePorta());
        } else if (setSoggettoReferenteDefault) {
            soggettoReferente = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto();
            MigrazioneProperties p = null;
            try {
                p = MigrazioneProperties.getInstance();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            soggettoReferente.setTipo(p.getTipoSoggettoReferenteDefault());
            soggettoReferente.setNome(p.getNomeSoggettoReferenteDefault());
            try {
                soggettoReferente.setCodicePorta(ProtocolFactoryManager.getInstance().getProtocolFactoryBySubjectType(p.getTipoSoggettoReferenteDefault()).createTraduttore().getIdentificativoPortaDefault(soggettoReferente));
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
        return IDAccordoFactory.getInstance().getIDAccordoFromValues(idAccordo.getNome(), soggettoReferente, idAccordo.getVersione());
    }

    public List<PortaDominioV2Wrapper> convertListPdD(List<PortaDominioV1Wrapper> findAll) {
        ArrayList<PortaDominioV2Wrapper> lst = new ArrayList<PortaDominioV2Wrapper>();
        for (PortaDominioV1Wrapper obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> convertListSoggettiRegistro(List<org.openspcoop.dao.registry.SoggettoSpcoop> findAll) throws Exception {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto>();
        for (org.openspcoop.dao.registry.SoggettoSpcoop obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<AccordoServizioParteComune> convertListAccordiParteComune(List<AccordoServizio> findAll) {
        ArrayList<AccordoServizioParteComune> lst = new ArrayList<AccordoServizioParteComune>();
        for (AccordoServizio obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<AccordoServizioParteSpecifica> convertListServizi(List<ServizioSpcoop> findAll, boolean servizioCorrelato) throws Exception {
        ArrayList<AccordoServizioParteSpecifica> lst = new ArrayList<AccordoServizioParteSpecifica>();
        for (ServizioSpcoop obj : findAll) {
            lst.add(this.convert(obj, servizioCorrelato));
        }
        return lst;
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione> convertListAccordiCooperazione(List<AccordoCooperazione> findAll) {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione>();
        for (AccordoCooperazione obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<Soggetto> convertListSoggettiConfig(List<SoggettoSpcoop> findAll) {
        ArrayList<Soggetto> lst = new ArrayList<Soggetto>();
        for (SoggettoSpcoop obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo> convertListServiziApplicativi(List<ServizioApplicativo> findAll) {
        ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo> lst = new ArrayList<it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo>();
        for (ServizioApplicativo obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<PortaApplicativaV2Wrapper> convertListPorteApplicative(List<PortaApplicativaV1Wrapper> findAll) {
        ArrayList<PortaApplicativaV2Wrapper> lst = new ArrayList<PortaApplicativaV2Wrapper>();
        for (PortaApplicativaV1Wrapper obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public List<PortaDelegataV2Wrapper> convertListPorteDelegate(List<PortaDelegataV1Wrapper> findAll) {
        ArrayList<PortaDelegataV2Wrapper> lst = new ArrayList<PortaDelegataV2Wrapper>();
        for (PortaDelegataV1Wrapper obj : findAll) {
            lst.add(this.convert(obj));
        }
        return lst;
    }

    public PortaDominioV2Wrapper convert(PortaDominioV1Wrapper obj) {
        PortaDominioV2Wrapper objV2 = new PortaDominioV2Wrapper();
        objV2.setPorta(this.convert(obj.getPorta()));
        PortaDominioV2Wrapper.TIPO tipo = null;
        if ("operativo".equals(obj.getTipo())) {
            tipo = PortaDominioV2Wrapper.TIPO.OPERATIVO;
        } else if ("non-operativo".equals(obj.getTipo())) {
            tipo = PortaDominioV2Wrapper.TIPO.NON_OPERATIVO;
        } else if ("esterno".equals(obj.getTipo())) {
            tipo = PortaDominioV2Wrapper.TIPO.ESTERNO;
        }
        objV2.setTipo(tipo);
        return objV2;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio convert(PortaDominio obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio porta = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio();
        porta.setNome(obj.getNome());
        porta.setDescrizione(obj.getDescrizione());
        try {
            if (obj.getSubject() != null) {
                Utilities.formatSubject((String)obj.getSubject());
                porta.setSubject(obj.getSubject());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (obj.getClientAuth() != null) {
            porta.setClientAuth((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getClientAuth()));
        } else {
            porta.setClientAuth(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.DISABILITATO);
        }
        porta.setImplementazione(obj.getImplementazione());
        return porta;
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto convert(org.openspcoop.dao.registry.SoggettoSpcoop obj) throws Exception {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto();
        soggetto.setSuperUser(obj.getSuperUser());
        soggetto.setPrivato(obj.getPrivato());
        soggetto.setTipo(obj.getTipo());
        soggetto.setNome(obj.getNome());
        soggetto.setIdentificativoPorta(obj.getIdentificativoPorta());
        soggetto.setDescrizione(obj.getDescrizione());
        soggetto.setPortaDominio(obj.getPortaDominio());
        soggetto.setOraRegistrazione(obj.getOraRegistrazione());
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto idSoggetto = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto(obj.getTipo(), obj.getNome(), obj.getIdentificativoPorta());
        ProtocolFactoryManager pfm = ProtocolFactoryManager.getInstance();
        String protocol = pfm.getProtocolBySubjectType(soggetto.getTipo());
        soggetto.setCodiceIpa(pfm.getProtocolFactoryByName(protocol).createTraduttore().getIdentificativoCodiceIPADefault(idSoggetto, false));
        soggetto.setConnettore(this.convert(obj.getConnettore()));
        soggetto.setVersioneProtocollo(obj.getProfilo());
        return soggetto;
    }

    public AccordoServizioParteComune convert(AccordoServizio obj) {
        AccordoServizioParteComune accordo = new AccordoServizioParteComune();
        if (obj.getSoggettoReferente() != null) {
            accordo.setSoggettoReferente(this.convert(obj.getSoggettoReferente()));
        } else {
            IdSoggetto referente = new IdSoggetto();
            MigrazioneProperties p = null;
            try {
                p = MigrazioneProperties.getInstance();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            referente.setTipo(p.getTipoSoggettoReferenteDefault());
            referente.setNome(p.getNomeSoggettoReferenteDefault());
            accordo.setSoggettoReferente(referente);
        }
        if (obj.getVersione() != null && !obj.getVersione().isEmpty()) {
            accordo.setVersione(obj.getVersione());
        } else {
            accordo.setVersione("1");
        }
        accordo.setSuperUser(obj.getSuperUser());
        accordo.setStatoPackage(obj.getStatoPackage());
        accordo.setPrivato(obj.getPrivato());
        accordo.setByteWsdlDefinitorio(obj.getByteWsdlDefinitorio());
        accordo.setByteWsdlConcettuale(obj.getByteWsdlConcettuale());
        accordo.setByteWsdlLogicoErogatore(obj.getByteWsdlLogicoErogatore());
        accordo.setByteWsdlLogicoFruitore(obj.getByteWsdlLogicoFruitore());
        accordo.setWsdlDefinitorio(obj.getWsdlDefinitorio());
        accordo.setWsdlConcettuale(obj.getWsdlConcettuale());
        accordo.setWsdlLogicoErogatore(obj.getWsdlLogicoErogatore());
        accordo.setWsdlLogicoFruitore(obj.getWsdlLogicoFruitore());
        accordo.setByteSpecificaConversazioneConcettuale(obj.getByteWsblConcettuale());
        accordo.setByteSpecificaConversazioneErogatore(obj.getByteWsblLogicoErogatore());
        accordo.setByteSpecificaConversazioneFruitore(obj.getByteWsblLogicoFruitore());
        accordo.setSpecificaConversazioneConcettuale(obj.getWsblConcettuale());
        accordo.setSpecificaConversazioneErogatore(obj.getWsblLogicoErogatore());
        accordo.setSpecificaConversazioneFruitore(obj.getWsblLogicoFruitore());
        accordo.setNome(obj.getNome());
        accordo.setDescrizione(obj.getDescrizione());
        accordo.setProfiloCollaborazione((ProfiloCollaborazione)ProfiloCollaborazione.toEnumConstantFromString((String)obj.getProfiloCollaborazione()));
        accordo.setUtilizzoSenzaAzione(obj.getUtilizzoSenzaAzione());
        if (obj.getAzioneList() != null && obj.getAzioneList().length > 0) {
            for (org.openspcoop.dao.registry.Azione azione : obj.getAzioneList()) {
                Azione azione2 = new Azione();
                azione2.setProfAzione(azione.getProfAzione());
                azione2.setIdAccordo(azione.getIdAccordo());
                azione2.setNome(azione.getNome());
                azione2.setProfiloCollaborazione((ProfiloCollaborazione)ProfiloCollaborazione.toEnumConstantFromString((String)azione.getProfiloCollaborazione()));
                azione2.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getFiltroDuplicati()));
                azione2.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getConfermaRicezione()));
                azione2.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getIdCollaborazione()));
                azione2.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getConsegnaInOrdine()));
                azione2.setScadenza(azione.getScadenza());
                azione2.setCorrelata(azione.getCorrelata());
                accordo.addAzione(azione2);
            }
        }
        if (obj.getAllegatoList() != null && obj.getAllegatoList().length > 0) {
            for (org.openspcoop.dao.registry.Azione azione : obj.getAllegatoList()) {
                Documento allegato = this.convert((org.openspcoop.dao.registry.Documento)azione);
                accordo.addAllegato(allegato);
            }
        }
        if (obj.getPortTypeList() != null && obj.getPortTypeList().length > 0) {
            for (org.openspcoop.dao.registry.Azione azione : obj.getPortTypeList()) {
                PortType portType = new PortType();
                portType.setProfiloPT(azione.getProfiloPT());
                portType.setIdAccordo(azione.getIdAccordo());
                portType.setNome(azione.getNome());
                portType.setDescrizione(azione.getDescrizione());
                portType.setStyle((BindingStyle)BindingStyle.toEnumConstantFromString((String)azione.getStyle()));
                portType.setProfiloCollaborazione((ProfiloCollaborazione)ProfiloCollaborazione.toEnumConstantFromString((String)azione.getProfiloCollaborazione()));
                portType.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getFiltroDuplicati()));
                portType.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getConfermaRicezione()));
                portType.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getIdCollaborazione()));
                portType.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azione.getConsegnaInOrdine()));
                if (azione.getAzioneList() != null && azione.getAzioneList().length > 0) {
                    for (int i = 0; i < azione.getAzioneList().length; ++i) {
                        Operation azioneObj = azione.getAzioneList()[i];
                        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation azione3 = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation();
                        if (azioneObj.getMessageInput() != null) {
                            azione3.setMessageInput(this.convert(azioneObj.getMessageInput()));
                        }
                        if (azioneObj.getMessageOutput() != null) {
                            azione3.setMessageOutput(this.convert(azioneObj.getMessageOutput()));
                        }
                        azione3.setProfAzione(azioneObj.getProfAzione());
                        azione3.setIdPortType(azioneObj.getIdPortType());
                        azione3.setNome(azioneObj.getNome());
                        azione3.setStyle((BindingStyle)BindingStyle.toEnumConstantFromString((String)azioneObj.getStyle()));
                        azione3.setSoapAction(azioneObj.getSoapAction());
                        azione3.setProfiloCollaborazione((ProfiloCollaborazione)ProfiloCollaborazione.toEnumConstantFromString((String)azioneObj.getProfiloCollaborazione()));
                        azione3.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azioneObj.getFiltroDuplicati()));
                        azione3.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azioneObj.getConfermaRicezione()));
                        azione3.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azioneObj.getIdCollaborazione()));
                        azione3.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)azioneObj.getConsegnaInOrdine()));
                        azione3.setScadenza(azioneObj.getScadenza());
                        azione3.setCorrelataServizio(azioneObj.getCorrelataServizio());
                        azione3.setCorrelata(azioneObj.getCorrelata());
                        portType.addAzione(azione3);
                    }
                }
                portType.setScadenza(azione.getScadenza());
                accordo.addPortType(portType);
            }
        }
        if (obj.getSpecificaSemiformaleList() != null && obj.getSpecificaSemiformaleList().length > 0) {
            for (org.openspcoop.dao.registry.Azione azione : obj.getSpecificaSemiformaleList()) {
                accordo.addSpecificaSemiformale(this.convert((org.openspcoop.dao.registry.Documento)azione));
            }
        }
        if (obj.getServizioComposto() != null) {
            accordo.setServizioComposto(this.convert(obj.getServizioComposto()));
        }
        accordo.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getFiltroDuplicati()));
        accordo.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConfermaRicezione()));
        accordo.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getIdCollaborazione()));
        accordo.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConsegnaInOrdine()));
        accordo.setScadenza(obj.getScadenza());
        accordo.setOraRegistrazione(obj.getOraRegistrazione());
        return accordo;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message convert(Message obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message msg = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message();
        msg.setUse((BindingUse)BindingUse.toEnumConstantFromString((String)obj.getUse()));
        if (obj.getPartList() != null && obj.getPartList().length > 0) {
            for (int i = 0; i < obj.getPartList().length; ++i) {
                msg.addPart(this.convert(obj.getPartList()[i]));
            }
        }
        return msg;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart convert(MessagePart obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart msgPart = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart();
        msgPart.setElementName(obj.getElementName());
        msgPart.setName(obj.getElementName());
        return msgPart;
    }

    private AccordoServizioParteComuneServizioComposto convert(AccordoServizioServizioComposto obj) {
        AccordoServizioParteComuneServizioComposto servizioComposto = new AccordoServizioParteComuneServizioComposto();
        servizioComposto.setAccordoCooperazione(obj.getNomeAccordoCooperazione());
        servizioComposto.setIdAccordoCooperazione(obj.getIdAccordoCooperazione());
        if (obj.getServizioComponenteList() != null && obj.getServizioComponenteList().length > 0) {
            for (AccordoServizioServizioCompostoServizioComponente accordoServizioServizioCompostoServizioComponente : obj.getServizioComponenteList()) {
                servizioComposto.addServizioComponente(this.convert(accordoServizioServizioCompostoServizioComponente));
            }
        }
        if (obj.getSpecificaCoordinamentoList() != null && obj.getSpecificaCoordinamentoList().length > 0) {
            for (AccordoServizioServizioCompostoServizioComponente accordoServizioServizioCompostoServizioComponente : obj.getSpecificaCoordinamentoList()) {
                servizioComposto.addSpecificaCoordinamento(this.convert((org.openspcoop.dao.registry.Documento)accordoServizioServizioCompostoServizioComponente));
            }
        }
        return servizioComposto;
    }

    private AccordoServizioParteComuneServizioCompostoServizioComponente convert(AccordoServizioServizioCompostoServizioComponente obj) {
        AccordoServizioParteComuneServizioCompostoServizioComponente servizioComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
        servizioComponente.setAzione(obj.getAzione());
        servizioComponente.setIdServizioComponente(obj.getIdServizioComponente());
        servizioComponente.setNome(obj.getNome());
        servizioComponente.setNomeSoggetto(obj.getNomeSoggetto());
        servizioComponente.setTipo(obj.getTipo());
        servizioComponente.setTipoSoggetto(obj.getTipoSoggetto());
        return servizioComponente;
    }

    private IdSoggetto convert(AccordoServizioSoggettoReferente soggettoReferente) {
        IdSoggetto id = new IdSoggetto();
        id.setNome(soggettoReferente.getNome());
        id.setTipo(soggettoReferente.getTipo());
        return id;
    }

    public Documento convert(org.openspcoop.dao.registry.Documento allegatoObj) {
        Documento allegato = new Documento();
        allegato.setByteContenuto(allegatoObj.getByteContenuto());
        allegato.setRuolo(allegatoObj.getRuolo());
        allegato.setTipoProprietarioDocumento(allegatoObj.getTipoProprietarioDocumento());
        allegato.setIdProprietarioDocumento(allegatoObj.getIdProprietarioDocumento());
        allegato.setTipo(allegatoObj.getTipo());
        allegato.setFile(allegatoObj.getFile());
        allegato.setOraRegistrazione(allegatoObj.getOraRegistrazione());
        return allegato;
    }

    public AccordoServizioParteSpecifica convert(ServizioSpcoop obj, boolean servizioCorrelato) throws Exception {
        AccordoServizioParteSpecifica accordo = new AccordoServizioParteSpecifica();
        accordo.setSuperUser(obj.getSuperUser());
        accordo.setStatoPackage(obj.getStatoPackage());
        accordo.setPrivato(obj.getPrivato());
        if (obj.getIdAccordo() != null) {
            org.openspcoop.dao.registry.Documento[] accordospc = this.idConverter.getAccordoPC(obj.getIdAccordo());
            accordo.setAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromAccordo((AccordoServizioParteComune)accordospc));
            accordo.setIdAccordo(accordospc.getId());
        }
        if (obj.getIdSoggetto() != null) {
            accordo.setIdSoggetto(this.idConverter.getIdSoggetto(obj.getIdSoggetto()));
        }
        accordo.setByteWsdlImplementativoErogatore(obj.getByteWsdlImplementativoErogatore());
        accordo.setByteWsdlImplementativoFruitore(obj.getByteWsdlImplementativoFruitore());
        accordo.setNome(obj.getNome());
        accordo.setVersione("1");
        accordo.setPortType(obj.getPortType());
        accordo.setWsdlImplementativoErogatore(obj.getWsdlImplementativoErogatore());
        accordo.setWsdlImplementativoFruitore(obj.getWsdlImplementativoFruitore());
        accordo.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getFiltroDuplicati()));
        accordo.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConfermaRicezione()));
        accordo.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getIdCollaborazione()));
        accordo.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConsegnaInOrdine()));
        accordo.setScadenza(obj.getScadenza());
        accordo.setOraRegistrazione(obj.getOraRegistrazione());
        accordo.setVersioneProtocollo(obj.getProfilo());
        accordo.setDescrizione(obj.getDescrizione());
        accordo.setServizio(this.convertServizioSpcoop(obj, servizioCorrelato));
        if (obj.getSpecificaSemiformaleList() != null && obj.getSpecificaSemiformaleList().length > 0) {
            for (org.openspcoop.dao.registry.Documento specificaSemiformaleObj : obj.getSpecificaSemiformaleList()) {
                accordo.addSpecificaSemiformale(this.convert(specificaSemiformaleObj));
            }
        }
        if (obj.getSpecificaSicurezzaList() != null && obj.getSpecificaSicurezzaList().length > 0) {
            for (org.openspcoop.dao.registry.Documento specificaSicurezzaObj : obj.getSpecificaSicurezzaList()) {
                accordo.addSpecificaSicurezza(this.convert(specificaSicurezzaObj));
            }
        }
        if (obj.getSpecificaLivelloServizioList() != null && obj.getSpecificaLivelloServizioList().length > 0) {
            for (org.openspcoop.dao.registry.Documento specificaLivelloServizioObj : obj.getSpecificaLivelloServizioList()) {
                accordo.addSpecificaLivelloServizio(this.convert(specificaLivelloServizioObj));
            }
        }
        if (obj.getAllegatoList() != null && obj.getAllegatoList().length > 0) {
            for (org.openspcoop.dao.registry.Documento allegatoObj : obj.getAllegatoList()) {
                accordo.addAllegato(this.convert(allegatoObj));
            }
        }
        if (obj.getFruitoreList() != null && obj.getFruitoreList().length > 0) {
            for (int i = 0; i < obj.getFruitoreList().length; ++i) {
                accordo.addFruitore(this.convert(obj.getFruitore(i)));
            }
        }
        return accordo;
    }

    private Fruitore convert(org.openspcoop.dao.registry.Fruitore obj) throws Exception {
        Fruitore fruitore = new Fruitore();
        fruitore.setStatoPackage(obj.getStatoPackage());
        if (obj.getIdSoggetto() != null && obj.getIdSoggetto() > 0L) {
            fruitore.setIdSoggetto(this.idConverter.getIdSoggetto(obj.getIdSoggetto()));
        }
        fruitore.setByteWsdlImplementativoErogatore(obj.getByteWsdlImplementativoErogatore());
        fruitore.setByteWsdlImplementativoFruitore(obj.getByteWsdlImplementativoFruitore());
        fruitore.setClientAuth((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getClientAuth()));
        if (obj.getConnettore() != null) {
            fruitore.setConnettore(this.convert(obj.getConnettore()));
        }
        fruitore.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConsegnaInOrdine()));
        if (obj.getIdServizio() != null) {
            fruitore.setIdServizio(obj.getIdServizio());
        }
        fruitore.setTipo(obj.getTipo());
        fruitore.setNome(obj.getNome());
        fruitore.setWsdlImplementativoErogatore(obj.getWsdlImplementativoErogatore());
        fruitore.setWsdlImplementativoFruitore(obj.getWsdlImplementativoFruitore());
        fruitore.setFiltroDuplicati((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getFiltroDuplicati()));
        fruitore.setConfermaRicezione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConfermaRicezione()));
        fruitore.setIdCollaborazione((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getIdCollaborazione()));
        fruitore.setConsegnaInOrdine((it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita)it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita.toEnumConstantFromString((String)obj.getConsegnaInOrdine()));
        fruitore.setScadenza(obj.getScadenza());
        fruitore.setOraRegistrazione(obj.getOraRegistrazione());
        fruitore.setVersioneProtocollo(obj.getProfilo());
        if (obj.getServizioApplicativoList() != null && obj.getServizioApplicativoList().length > 0) {
            for (int i = 0; i < obj.getServizioApplicativoList().length; ++i) {
                fruitore.addServizioApplicativo(obj.getServizioApplicativo(i));
            }
        }
        return fruitore;
    }

    private Servizio convertServizioSpcoop(ServizioSpcoop asps, boolean servizioCorrelato) {
        Servizio servizio = new Servizio();
        servizio.setNome(asps.getNome());
        servizio.setTipologiaServizio(servizioCorrelato ? TipologiaServizio.CORRELATO : TipologiaServizio.NORMALE);
        String nomeConnettore = asps.getConnettore().getNome() + (servizioCorrelato ? "Correlato" : "");
        servizio.setConnettore(this.convert(asps.getConnettore(), nomeConnettore));
        servizio.setTipoSoggettoErogatore(asps.getTipoSoggettoErogatore());
        servizio.setNomeSoggettoErogatore(asps.getNomeSoggettoErogatore());
        servizio.setTipo(asps.getTipo());
        return servizio;
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione convert(AccordoCooperazione obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione accordo = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione();
        accordo.setSoggettoReferente(this.convert(obj.getSoggettoReferente()));
        if (obj.getElencoPartecipantiList() != null && obj.getElencoPartecipantiList().length > 0) {
            for (AccordoCooperazioneElencoPartecipantiSoggetto accordoCooperazioneElencoPartecipantiSoggetto : obj.getElencoPartecipantiList()) {
                AccordoCooperazionePartecipanti partecipanti = new AccordoCooperazionePartecipanti();
                partecipanti.addSoggettoPartecipante(this.convert(accordoCooperazioneElencoPartecipantiSoggetto));
                accordo.setElencoPartecipanti(partecipanti);
            }
        }
        if (obj.getAllegatoList() != null && obj.getAllegatoList().length > 0) {
            for (org.openspcoop.dao.registry.Documento documento : obj.getAllegatoList()) {
                accordo.addAllegato(this.convert(documento));
            }
        }
        if (obj.getSpecificaSemiformaleList() != null && obj.getSpecificaSemiformaleList().length > 0) {
            for (org.openspcoop.dao.registry.Documento documento : obj.getSpecificaSemiformaleList()) {
                accordo.addSpecificaSemiformale(this.convert(documento));
            }
        }
        if (obj.getUriServiziCompostiList() != null && obj.getUriServiziCompostiList().length > 0) {
            for (String string : obj.getUriServiziCompostiList()) {
                accordo.addUriServiziComposti(string);
            }
        }
        accordo.setSuperUser(obj.getSuperUser());
        accordo.setStatoPackage(obj.getStatoPackage());
        accordo.setPrivato(obj.getPrivato());
        accordo.setNome(obj.getNome());
        accordo.setDescrizione(obj.getDescrizione());
        accordo.setVersione(obj.getVersione());
        accordo.setOraRegistrazione(obj.getOraRegistrazione());
        return accordo;
    }

    private IdSoggetto convert(AccordoCooperazioneElencoPartecipantiSoggetto soggettoReferente) {
        IdSoggetto id = new IdSoggetto();
        id.setNome(soggettoReferente.getNome());
        id.setTipo(soggettoReferente.getTipo());
        id.setIdSoggetto(soggettoReferente.getIdSoggetto());
        return id;
    }

    private IdSoggetto convert(AccordoCooperazioneSoggettoReferente soggettoReferente) {
        IdSoggetto id = new IdSoggetto();
        id.setNome(soggettoReferente.getNome());
        id.setTipo(soggettoReferente.getTipo());
        id.setIdSoggetto(soggettoReferente.getIdSoggetto());
        return id;
    }

    public Soggetto convert(SoggettoSpcoop obj) {
        Soggetto soggetto = new Soggetto();
        if (obj.getConnettoreList() != null && obj.getConnettoreList().length > 0) {
            for (org.openspcoop.dao.config.Connettore connettore : obj.getConnettoreList()) {
                soggetto.addConnettore(this.convert(connettore));
            }
        }
        if (obj.getPortaDelegataList() != null && obj.getPortaDelegataList().length > 0) {
            for (org.openspcoop.dao.config.Connettore connettore : obj.getPortaDelegataList()) {
                soggetto.addPortaDelegata(this.convert((org.openspcoop.dao.config.PortaDelegata)connettore));
            }
        }
        if (obj.getPortaApplicativaList() != null && obj.getPortaApplicativaList().length > 0) {
            for (org.openspcoop.dao.config.Connettore connettore : obj.getPortaApplicativaList()) {
                soggetto.addPortaApplicativa(this.convert((PortaApplicativa)connettore));
            }
        }
        if (obj.getServizioApplicativoList() != null && obj.getServizioApplicativoList().length > 0) {
            for (org.openspcoop.dao.config.Connettore connettore : obj.getServizioApplicativoList()) {
                soggetto.addServizioApplicativo(this.convert((ServizioApplicativo)connettore));
            }
        }
        soggetto.setSuperUser(obj.getSuperUser());
        soggetto.setTipo(obj.getTipo());
        soggetto.setNome(obj.getNome());
        soggetto.setIdentificativoPorta(obj.getIdentificativoPorta());
        soggetto.setDescrizione(obj.getDescrizione());
        soggetto.setRouter(obj.getRouter());
        return soggetto;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore convert(org.openspcoop.dao.config.Connettore obj) {
        return this.convert(obj, obj.getNome());
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore convert(org.openspcoop.dao.config.Connettore obj, String nome) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore connettore = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore();
        if (obj.getPropertyList() != null && obj.getPropertyList().length > 0) {
            for (org.openspcoop.dao.config.ConnettoreProperty prop : obj.getPropertyList()) {
                Property property = new Property();
                property.setNome(prop.getNome());
                property.setValore(prop.getValore());
                connettore.addProperty(property);
            }
        }
        connettore.setNomeRegistro(obj.getNomeRegistro());
        connettore.setTipoDestinatarioTrasmissioneBusta(obj.getTipoDestinatarioTrasmissioneBusta());
        connettore.setNomeDestinatarioTrasmissioneBusta(obj.getNomeDestinatarioTrasmissioneBusta());
        connettore.setTipo(obj.getTipo());
        connettore.setNome(nome);
        return connettore;
    }

    private Connettore convert(org.openspcoop.dao.registry.Connettore obj) {
        return this.convert(obj, obj.getNome());
    }

    private Connettore convert(org.openspcoop.dao.registry.Connettore obj, String nome) {
        Connettore connettore = new Connettore();
        if (obj.getPropertyList() != null && obj.getPropertyList().length > 0) {
            for (int i = 0; i < obj.getPropertyList().length; ++i) {
                ConnettoreProperty prop = obj.getPropertyList()[i];
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property property = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property();
                property.setNome(prop.getNome());
                property.setValore(prop.getValore());
                connettore.addProperty(property);
            }
        }
        connettore.setTipo(obj.getTipo());
        connettore.setNome(nome);
        return connettore;
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo convert(ServizioApplicativo obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo servizio = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo();
        if (obj.getInvocazionePorta() != null) {
            servizio.setInvocazionePorta(this.convert(obj.getInvocazionePorta()));
        }
        if (obj.getInvocazioneServizio() != null) {
            servizio.setInvocazioneServizio(this.convert(obj.getInvocazioneServizio()));
        }
        if (obj.getRispostaAsincrona() != null) {
            servizio.setRispostaAsincrona(this.convert(obj.getRispostaAsincrona()));
        }
        servizio.setIdSoggetto(obj.getIdSoggetto());
        servizio.setTipoSoggettoProprietario(obj.getTipoSoggettoProprietario());
        servizio.setNomeSoggettoProprietario(obj.getNomeSoggettoProprietario());
        servizio.setTipologiaFruizione(obj.getTipologiaFruizione());
        servizio.setTipologiaErogazione(obj.getTipologiaErogazione());
        servizio.setNome(obj.getNome());
        servizio.setDescrizione(obj.getDescrizione());
        return servizio;
    }

    private RispostaAsincrona convert(org.openspcoop.dao.config.RispostaAsincrona obj) {
        RispostaAsincrona rispostaAsincrona = new RispostaAsincrona();
        if (obj.getCredenziali() != null) {
            rispostaAsincrona.setCredenziali(this.convertToInvocazioneCredenziali(obj.getCredenziali()));
        }
        rispostaAsincrona.setConnettore(this.convert(obj.getConnettore()));
        if (obj.getGestioneErrore() != null) {
            rispostaAsincrona.setGestioneErrore(this.convert(obj.getGestioneErrore()));
        }
        rispostaAsincrona.setSbustamentoSoap(obj.getSbustamentoSoap() ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        rispostaAsincrona.setGetMessage((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getGetMessage()));
        rispostaAsincrona.setAutenticazione((InvocazioneServizioTipoAutenticazione)InvocazioneServizioTipoAutenticazione.toEnumConstantFromString((String)obj.getAutenticazione()));
        rispostaAsincrona.setInvioPerRiferimento((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getInvioPerRiferimento()));
        rispostaAsincrona.setRispostaPerRiferimento((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRispostaPerRiferimento()));
        return rispostaAsincrona;
    }

    private GestioneErrore convert(org.openspcoop.dao.config.GestioneErrore obj) {
        GestioneErrore gestioneErrore = new GestioneErrore();
        if (obj.getCodiceTrasportoList() != null && obj.getCodiceTrasportoList().length > 0) {
            for (org.openspcoop.dao.config.GestioneErroreCodiceTrasporto gestioneErroreCodiceTrasporto : obj.getCodiceTrasportoList()) {
                gestioneErrore.addCodiceTrasporto(this.convert(gestioneErroreCodiceTrasporto));
            }
        }
        if (obj.getSoapFaultList() != null && obj.getSoapFaultList().length > 0) {
            for (org.openspcoop.dao.config.GestioneErroreCodiceTrasporto gestioneErroreCodiceTrasporto : obj.getSoapFaultList()) {
                gestioneErrore.addSoapFault(this.convert((GestioneErroreSoapFault)gestioneErroreCodiceTrasporto));
            }
        }
        gestioneErrore.setNome(obj.getNome());
        gestioneErrore.setComportamento((GestioneErroreComportamento)GestioneErroreComportamento.toEnumConstantFromString((String)obj.getComportamento()));
        gestioneErrore.setCadenzaRispedizione(obj.getCadenzaRispedizione());
        return gestioneErrore;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreSoapFault convert(GestioneErroreSoapFault obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreSoapFault fault = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreSoapFault();
        fault.setFaultActor(obj.getFaultActor());
        fault.setFaultCode(obj.getFaultCode());
        fault.setFaultString(obj.getFaultString());
        fault.setComportamento((GestioneErroreComportamento)GestioneErroreComportamento.toEnumConstantFromString((String)obj.getComportamento()));
        fault.setCadenzaRispedizione(obj.getCadenzaRispedizione());
        return fault;
    }

    private GestioneErroreCodiceTrasporto convert(org.openspcoop.dao.config.GestioneErroreCodiceTrasporto obj) {
        GestioneErroreCodiceTrasporto trasporto = new GestioneErroreCodiceTrasporto();
        trasporto.setValoreMinimo(Integer.valueOf(obj.getValoreMinimo().intValue()));
        trasporto.setValoreMassimo(Integer.valueOf(obj.getValoreMassimo().intValue()));
        trasporto.setComportamento((GestioneErroreComportamento)GestioneErroreComportamento.toEnumConstantFromString((String)obj.getComportamento()));
        trasporto.setCadenzaRispedizione(obj.getCadenzaRispedizione());
        return trasporto;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio convert(InvocazioneServizio obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio inv = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio();
        if (obj.getCredenziali() != null) {
            inv.setCredenziali(this.convertToInvocazioneCredenziali(obj.getCredenziali()));
        }
        inv.setConnettore(this.convert(obj.getConnettore()));
        if (obj.getGestioneErrore() != null) {
            inv.setGestioneErrore(this.convert(obj.getGestioneErrore()));
        }
        inv.setSbustamentoSoap(obj.getSbustamentoSoap() ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        inv.setGetMessage((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getGetMessage()));
        inv.setAutenticazione((InvocazioneServizioTipoAutenticazione)InvocazioneServizioTipoAutenticazione.toEnumConstantFromString((String)obj.getAutenticazione()));
        inv.setInvioPerRiferimento((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getInvioPerRiferimento()));
        inv.setRispostaPerRiferimento((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRispostaPerRiferimento()));
        return inv;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta convert(InvocazionePorta obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta invPorta = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta();
        if (obj.getCredenzialiList() != null && obj.getCredenzialiList().length > 0) {
            for (org.openspcoop.dao.config.Credenziali cred : obj.getCredenzialiList()) {
                invPorta.addCredenziali(this.convert(cred));
            }
        }
        if (obj.getGestioneErrore() != null) {
            invPorta.setGestioneErrore(this.convert(obj.getGestioneErrore()));
        }
        invPorta.setInvioPerRiferimento((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getInvioPerRiferimento()));
        return invPorta;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore convert(InvocazionePortaGestioneErrore obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore gestioneErrore = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore();
        gestioneErrore.setFault((FaultIntegrazioneTipo)FaultIntegrazioneTipo.toEnumConstantFromString((String)obj.getFault()));
        gestioneErrore.setFaultActor(obj.getFaultActor());
        gestioneErrore.setGenericFaultCode((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getGenericFaultCode()));
        gestioneErrore.setPrefixFaultCode(obj.getPrefixFaultCode());
        return gestioneErrore;
    }

    private Credenziali convert(org.openspcoop.dao.config.Credenziali obj) {
        Credenziali cred = new Credenziali();
        cred.setTipo(CredenzialeTipo.toEnumConstant((String)obj.getTipo()));
        cred.setUser(obj.getUser());
        cred.setPassword(obj.getPassword());
        cred.setSubject(obj.getSubject());
        return cred;
    }

    private InvocazioneCredenziali convertToInvocazioneCredenziali(org.openspcoop.dao.config.Credenziali obj) {
        InvocazioneCredenziali cred = new InvocazioneCredenziali();
        cred.setUser(obj.getUser());
        cred.setPassword(obj.getPassword());
        return cred;
    }

    public PortaApplicativaV2Wrapper convert(PortaApplicativaV1Wrapper obj) {
        PortaApplicativaV2Wrapper wrapper = new PortaApplicativaV2Wrapper();
        wrapper.setPortaApplicativa(this.convert(obj.getPortaApplicativa()));
        return wrapper;
    }

    public PortaDelegataV2Wrapper convert(PortaDelegataV1Wrapper obj) {
        PortaDelegataV2Wrapper wrapper = new PortaDelegataV2Wrapper();
        wrapper.setPortaDelegata(this.convert(obj.getPortaDelegata()));
        return wrapper;
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa convert(PortaApplicativa obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa porta = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa();
        if (obj.getSoggettoVirtuale() != null) {
            porta.setSoggettoVirtuale(this.convert(obj.getSoggettoVirtuale()));
        }
        porta.setServizio(this.convert(obj.getServizio()));
        if (obj.getAzione() != null) {
            porta.setAzione(this.convert(obj.getAzione()));
        }
        if (obj.getServizioApplicativoList() != null && obj.getServizioApplicativoList().length > 0) {
            for (ServizioApplicativo sa : obj.getServizioApplicativoList()) {
                porta.addServizioApplicativo(this.convert(sa));
            }
        }
        if (obj.getSetSpcoopPropertyList() != null && obj.getSetSpcoopPropertyList().length > 0) {
            for (int i = 0; i < obj.getSetSpcoopPropertyList().length; ++i) {
                porta.addProprietaProtocollo(this.convert(obj.getSetSpcoopPropertyList()[i]));
            }
        }
        if (obj.getWsSecurity() != null) {
            porta.setMessageSecurity(this.convert(obj.getWsSecurity()));
        }
        if (obj.getValidazioneContenutiApplicativi() != null) {
            porta.setValidazioneContenutiApplicativi(this.convert(obj.getValidazioneContenutiApplicativi()));
        }
        porta.setIdSoggetto(obj.getIdSoggetto());
        porta.setIdAccordo(obj.getIdAccordo());
        porta.setIdPortType(obj.getIdPortType());
        porta.setTipoSoggettoProprietario(obj.getTipoSoggettoProprietario());
        porta.setNomeSoggettoProprietario(obj.getNomeSoggettoProprietario());
        porta.setStatoMessageSecurity(obj.getStatoWSSecurity());
        porta.setNome(obj.getNome());
        porta.setDescrizione(obj.getDescrizione());
        porta.setRicevutaAsincronaSimmetrica((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRicevutaAsincronaSimmetrica()));
        porta.setRicevutaAsincronaAsimmetrica((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRicevutaAsincronaAsimmetrica()));
        porta.setIntegrazione(this.convertIntegrazione(obj.getIntegrazione()));
        porta.setAllegaBody((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getAllegaBody()));
        porta.setScartaBody((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getScartaBody()));
        porta.setGestioneManifest((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getGestioneManifest()));
        porta.setStateless((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getStateless()));
        return porta;
    }

    private String convertIntegrazione(String oldIntegrazione) {
        if (oldIntegrazione != null && !"".equals(oldIntegrazione)) {
            String[] tipiIntegrazione = null;
            tipiIntegrazione = oldIntegrazione.contains(",") ? oldIntegrazione.split(",") : new String[]{oldIntegrazione};
            if (tipiIntegrazione != null && tipiIntegrazione.length > 0) {
                StringBuffer bf = new StringBuffer();
                for (int i = 0; i < tipiIntegrazione.length; ++i) {
                    tipiIntegrazione[i] = tipiIntegrazione[i].trim();
                    if ("trasporto".equals(tipiIntegrazione[i])) {
                        tipiIntegrazione[i] = "trasportoOpV1";
                    } else if ("urlBased".equals(tipiIntegrazione[i])) {
                        tipiIntegrazione[i] = "urlBasedOpV1";
                    } else if ("soap".equals(tipiIntegrazione[i])) {
                        tipiIntegrazione[i] = "soapOpV1";
                    } else if ("wsa".equals(tipiIntegrazione[i])) {
                        tipiIntegrazione[i] = "wsaOpV1";
                    }
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(tipiIntegrazione[i]);
                }
                return bf.toString();
            }
        }
        return null;
    }

    private ProprietaProtocollo convert(SetSpcoopProperty obj) {
        ProprietaProtocollo prop = new ProprietaProtocollo();
        prop.setNome(obj.getNome());
        prop.setValore(obj.getValore());
        return prop;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa convert(CorrelazioneApplicativa obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa corr = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa();
        if (obj.getElementoList() != null && obj.getElementoList().length > 0) {
            for (org.openspcoop.dao.config.CorrelazioneApplicativaElemento elem : obj.getElementoList()) {
                corr.addElemento(this.convert(elem));
            }
        }
        corr.setScadenza(obj.getScadenza());
        return corr;
    }

    private CorrelazioneApplicativaElemento convert(org.openspcoop.dao.config.CorrelazioneApplicativaElemento obj) {
        CorrelazioneApplicativaElemento elem = new CorrelazioneApplicativaElemento();
        elem.setNome(obj.getNome());
        elem.setIdentificazione((CorrelazioneApplicativaRichiestaIdentificazione)CorrelazioneApplicativaRichiestaIdentificazione.toEnumConstantFromString((String)obj.getIdentificazione()));
        elem.setPattern(obj.getPattern());
        elem.setIdentificazioneFallita((CorrelazioneApplicativaGestioneIdentificazioneFallita)CorrelazioneApplicativaGestioneIdentificazioneFallita.toEnumConstantFromString((String)obj.getIdentificazioneFallita()));
        return elem;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi convert(ValidazioneContenutiApplicativi obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi valid = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi();
        valid.setStato((StatoFunzionalitaConWarning)StatoFunzionalitaConWarning.toEnumConstantFromString((String)obj.getStato()));
        valid.setTipo((ValidazioneContenutiApplicativiTipo)ValidazioneContenutiApplicativiTipo.toEnumConstantFromString((String)obj.getTipo()));
        return valid;
    }

    private MessageSecurity convert(WsSecurity obj) {
        MessageSecurity ms = new MessageSecurity();
        if (obj.getRequestFlowList() != null && obj.getRequestFlowList().length > 0) {
            ms.setRequestFlow(this.convert(obj.getRequestFlowList()));
        }
        if (obj.getResponseFlowList() != null && obj.getResponseFlowList().length > 0) {
            ms.setResponseFlow(this.convert(obj.getResponseFlowList()));
        }
        return ms;
    }

    private MessageSecurityFlow convert(WsSecurityResponseFlowParameter[] obj) {
        MessageSecurityFlow flow = new MessageSecurityFlow();
        for (WsSecurityResponseFlowParameter paramObj : obj) {
            MessageSecurityFlowParameter param = new MessageSecurityFlowParameter();
            param.setNome(paramObj.getNome());
            param.setValore(paramObj.getValore());
            flow.addParameter(param);
        }
        return flow;
    }

    private MessageSecurityFlow convert(WsSecurityRequestFlowParameter[] obj) {
        MessageSecurityFlow flow = new MessageSecurityFlow();
        for (WsSecurityRequestFlowParameter paramObj : obj) {
            MessageSecurityFlowParameter param = new MessageSecurityFlowParameter();
            param.setNome(paramObj.getNome());
            param.setValore(paramObj.getValore());
            flow.addParameter(param);
        }
        return flow;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaAzione convert(PortaApplicativaAzione obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaAzione az = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaAzione();
        az.setNome(obj.getNome());
        return az;
    }

    private PortaApplicativaServizio convert(org.openspcoop.dao.config.PortaApplicativaServizio obj) {
        PortaApplicativaServizio serv = new PortaApplicativaServizio();
        serv.setNome(obj.getNome());
        serv.setTipo(obj.getTipo());
        return serv;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaSoggettoVirtuale convert(PortaApplicativaSoggettoVirtuale obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaSoggettoVirtuale soggettoVirtuale = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaSoggettoVirtuale();
        soggettoVirtuale.setNome(obj.getNome());
        soggettoVirtuale.setTipo(obj.getTipo());
        return soggettoVirtuale;
    }

    public PortaDelegata convert(org.openspcoop.dao.config.PortaDelegata obj) {
        PortaDelegata pd = new PortaDelegata();
        if (obj.getSoggettoSpcoopErogatore() != null) {
            pd.setSoggettoErogatore(this.convert(obj.getSoggettoSpcoopErogatore()));
        }
        if (obj.getServizio() != null) {
            pd.setServizio(this.convert(obj.getServizio()));
        }
        if (obj.getAzione() != null) {
            pd.setAzione(this.convert(obj.getAzione()));
        }
        if (obj.getServizioApplicativoList() != null && obj.getServizioApplicativoList().length > 0) {
            for (ServizioApplicativo sa : obj.getServizioApplicativoList()) {
                pd.addServizioApplicativo(this.convert(sa));
            }
        }
        if (obj.getWsSecurity() != null) {
            pd.setMessageSecurity(this.convert(obj.getWsSecurity()));
        }
        if (obj.getValidazioneContenutiApplicativi() != null) {
            pd.setValidazioneContenutiApplicativi(this.convert(obj.getValidazioneContenutiApplicativi()));
        }
        if (obj.getCorrelazioneApplicativa() != null) {
            pd.setCorrelazioneApplicativa(this.convert(obj.getCorrelazioneApplicativa()));
        }
        pd.setIdSoggetto(obj.getIdSoggetto());
        pd.setIdAccordo(obj.getIdAccordo());
        pd.setIdPortType(obj.getIdPortType());
        pd.setTipoSoggettoProprietario(obj.getTipoSoggettoProprietario());
        pd.setNomeSoggettoProprietario(obj.getNomeSoggettoProprietario());
        pd.setStatoMessageSecurity(obj.getStatoWSSecurity());
        pd.setNome(obj.getNome());
        pd.setDescrizione(obj.getDescrizione());
        pd.setLocation(obj.getLocation() != null && !"".equals(obj.getLocation()) ? obj.getLocation() : obj.getNome());
        pd.setAutenticazione(obj.getAutenticazione());
        pd.setAutorizzazione(obj.getAutorizzazione());
        pd.setRicevutaAsincronaSimmetrica((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRicevutaAsincronaSimmetrica()));
        pd.setRicevutaAsincronaAsimmetrica((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getRicevutaAsincronaAsimmetrica()));
        pd.setIntegrazione(this.convertIntegrazione(obj.getIntegrazione()));
        pd.setAllegaBody((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getAllegaBody()));
        pd.setScartaBody((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getScartaBody()));
        pd.setGestioneManifest((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getGestioneManifest()));
        pd.setStateless((StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString((String)obj.getStateless()));
        return pd;
    }

    private PortaDelegataSoggettoErogatore convert(PortaDelegataSoggettoSpcoopErogatore obj) {
        PortaDelegataSoggettoErogatore sogg = new PortaDelegataSoggettoErogatore();
        if (obj.getIdentificazione() != null) {
            sogg.setIdentificazione((PortaDelegataSoggettoErogatoreIdentificazione)PortaDelegataSoggettoErogatoreIdentificazione.toEnumConstantFromString((String)obj.getIdentificazione()));
        }
        sogg.setPattern(obj.getPattern());
        sogg.setTipo(obj.getTipo());
        sogg.setNome(obj.getNome());
        return sogg;
    }

    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataAzione convert(PortaDelegataAzione obj) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataAzione az = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataAzione();
        if (obj.getIdentificazione() != null) {
            az.setIdentificazione((PortaDelegataAzioneIdentificazione)PortaDelegataAzioneIdentificazione.toEnumConstantFromString((String)obj.getIdentificazione()));
        }
        az.setPattern(obj.getPattern());
        az.setNome(obj.getNome());
        return az;
    }

    private PortaDelegataServizio convert(org.openspcoop.dao.config.PortaDelegataServizio obj) {
        PortaDelegataServizio serv = new PortaDelegataServizio();
        if (obj.getIdentificazione() != null) {
            serv.setIdentificazione((PortaDelegataServizioIdentificazione)PortaDelegataServizioIdentificazione.toEnumConstantFromString((String)obj.getIdentificazione()));
        }
        serv.setNome(obj.getNome());
        serv.setPattern(obj.getPattern());
        serv.setTipo(obj.getTipo());
        return serv;
    }
}

