/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.wsaddressing;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingHeader;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingValue;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class WSAddressingUtilities {
    private Logger log;
    private static final boolean BUILD_VALUE_AS_EPR = true;
    private static final boolean BUILD_VALUE_RAW = false;
    private static HashMap<String, ValidatoreXSD> _validatoreXSDMap = new HashMap();

    public WSAddressingUtilities(Logger log) {
        this.log = log;
    }

    public WSAddressingHeader build(OpenSPCoop2SoapMessage msg, String actor, WSAddressingValue values) throws MessageException {
        return this.build(msg, actor, false, values);
    }

    public WSAddressingHeader build(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, WSAddressingValue values) throws MessageException {
        WSAddressingHeader hdr = new WSAddressingHeader();
        if (!StringUtils.isEmpty((String)values.getTo())) {
            hdr.setTo(WSAddressingUtilities.buildWSATo(msg, actor, mustUnderstand, values.getTo()));
        }
        if (!StringUtils.isEmpty((String)values.getFrom())) {
            hdr.setFrom(WSAddressingUtilities.buildWSAFrom(msg, actor, mustUnderstand, values.getFrom()));
        }
        if (!StringUtils.isEmpty((String)values.getAction())) {
            hdr.setAction(WSAddressingUtilities.buildWSAAction(msg, actor, mustUnderstand, values.getAction()));
        }
        if (!StringUtils.isEmpty((String)values.getId())) {
            hdr.setId(WSAddressingUtilities.buildWSAID(msg, actor, mustUnderstand, values.getId()));
        }
        if (!StringUtils.isEmpty((String)values.getRelatesTo())) {
            hdr.setRelatesTo(WSAddressingUtilities.buildWSARelatesTo(msg, actor, mustUnderstand, values.getRelatesTo()));
        }
        if (!StringUtils.isEmpty((String)values.getReplyTo())) {
            hdr.setReplyTo(WSAddressingUtilities.buildWSAReplyTo(msg, actor, mustUnderstand, values.getReplyTo()));
        }
        if (!StringUtils.isEmpty((String)values.getFaultTo())) {
            hdr.setFaultTo(WSAddressingUtilities.buildWSAFaultTo(msg, actor, mustUnderstand, values.getFaultTo()));
        }
        return hdr;
    }

    public void addHeader(WSAddressingHeader headerWSAddressing, OpenSPCoop2SoapMessage msg) throws MessageException {
        try {
            if (headerWSAddressing != null && msg != null) {
                SOAPHeader header = msg.getSOAPHeader();
                if (header == null) {
                    header = msg.getSOAPPart().getEnvelope().addHeader();
                }
                if (headerWSAddressing.getTo() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getTo());
                }
                if (headerWSAddressing.getFrom() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getFrom());
                }
                if (headerWSAddressing.getAction() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getAction());
                }
                if (headerWSAddressing.getId() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getId());
                }
                if (headerWSAddressing.getRelatesTo() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getRelatesTo());
                }
                if (headerWSAddressing.getReplyTo() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getReplyTo());
                }
                if (headerWSAddressing.getFaultTo() != null) {
                    msg.addHeaderElement(header, headerWSAddressing.getFaultTo());
                }
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public static SOAPHeaderElement buildWSATo(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, false);
        return header;
    }

    public static SOAPHeaderElement buildWSAFrom(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, true);
        return header;
    }

    public static SOAPHeaderElement buildWSAAction(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, false);
        return header;
    }

    public static SOAPHeaderElement buildWSAID(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "MessageID", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, false);
        return header;
    }

    public static SOAPHeaderElement buildWSARelatesTo(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, false);
        return header;
    }

    public static SOAPHeaderElement buildWSAReplyTo(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, true);
        return header;
    }

    public static SOAPHeaderElement buildWSAFaultTo(OpenSPCoop2SoapMessage msg, String actor, boolean mustUnderstand, String value) throws MessageException {
        QName name = new QName("http://www.w3.org/2005/08/addressing", "FaultTo", "wsa");
        SOAPHeaderElement header = WSAddressingUtilities.buildHeaderElement(msg, name, value, actor, mustUnderstand, true);
        return header;
    }

    private static SOAPHeaderElement buildHeaderElement(OpenSPCoop2SoapMessage msg, QName name, String value, String actor, boolean mustUnderstand, boolean epr) throws MessageException {
        try {
            SOAPHeader hdr = msg.getSOAPHeader();
            if (hdr == null) {
                hdr = msg.getSOAPPart().getEnvelope().addHeader();
            }
            SOAPHeaderElement element = msg.newSOAPHeaderElement(hdr, name);
            if (actor != null) {
                element.setActor(actor);
            }
            element.setMustUnderstand(mustUnderstand);
            if (!epr) {
                element.setValue(value);
            } else {
                QName nameAddressEPR = new QName("http://www.w3.org/2005/08/addressing", "Address", "wsa");
                element.addChildElement(nameAddressEPR).setValue(value);
            }
            return element;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private static synchronized void _initValidatore(OpenSPCoop2MessageFactory messageFactory, Logger log) {
        String key = messageFactory.getClass().getName();
        if (!_validatoreXSDMap.containsKey(key)) {
            try {
                ValidatoreXSD val = new ValidatoreXSD(messageFactory, log, WSAddressingUtilities.class.getResourceAsStream("/ws-addr.xsd"));
                _validatoreXSDMap.put(key, val);
            }
            catch (Exception e) {
                log.error("ws-addr.xsd, errore durante la costruzione del validatore xsd: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public ValidatoreXSD getValidatoreXSD(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!_validatoreXSDMap.containsKey(key)) {
            WSAddressingUtilities._initValidatore(messageFactory, this.log);
        }
        return _validatoreXSDMap.get(key);
    }

    public void validate(OpenSPCoop2SoapMessage message, WSAddressingHeader header) throws MessageException {
        this.log.debug("Validazione XSD...");
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getTo(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getFrom(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getAction(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getId(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getRelatesTo(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getReplyTo(), message);
        this._validaElementoWSA(this.getValidatoreXSD(message.getFactory()), header.getFaultTo(), message);
        this.log.debug("Validazione XSD effettuate");
    }

    private void _validaElementoWSA(ValidatoreXSD validatoreXSD, SOAPHeaderElement headerElement, OpenSPCoop2SoapMessage msg) throws MessageException {
        if (headerElement != null) {
            try {
                this.log.debug("Validazione XSD [" + headerElement.getLocalName() + "]...");
                if (validatoreXSD == null) {
                    throw new Exception("Validatore XSD non istanziato");
                }
                validatoreXSD.valida(new ByteArrayInputStream(msg.getAsByte((Node)headerElement, false)));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        }
    }

    public WSAddressingHeader read(OpenSPCoop2SoapMessage message, String actor) throws MessageException {
        return this.read(message, actor, false);
    }

    public WSAddressingHeader read(OpenSPCoop2SoapMessage message, String actor, boolean validate) throws MessageException {
        SOAPHeader header = null;
        try {
            header = message.getSOAPHeader();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        return this.read(message, header, actor, validate);
    }

    public WSAddressingHeader read(OpenSPCoop2SoapMessage message, SOAPHeader header, String actor) throws MessageException {
        return this.read(message, header, actor, false);
    }

    public WSAddressingHeader read(OpenSPCoop2SoapMessage message, SOAPHeader header, String actor, boolean validate) throws MessageException {
        try {
            if (header == null) {
                return null;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            SOAPHeaderElement wsaReplyTo = null;
            SOAPHeaderElement wsaFaultTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actorCheck = SoapUtils.getSoapActor(headerElement, message.getMessageType());
                boolean actorCompatible = false;
                actorCompatible = actor == null ? actorCheck == null : actor.equals(actorCheck);
                if (!actorCompatible || !"http://www.w3.org/2005/08/addressing".equals(namespace)) continue;
                if ("To".equals(headerElement.getLocalName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if ("From".equals(headerElement.getLocalName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if ("Action".equals(headerElement.getLocalName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if ("MessageID".equals(headerElement.getLocalName())) {
                    wsaID = headerElement;
                    continue;
                }
                if ("RelatesTo".equals(headerElement.getLocalName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                if ("ReplyTo".equals(headerElement.getLocalName())) {
                    wsaReplyTo = headerElement;
                    continue;
                }
                if (!"FaultTo".equals(headerElement.getLocalName())) continue;
                wsaFaultTo = headerElement;
            }
            WSAddressingHeader wsaHeader = new WSAddressingHeader();
            wsaHeader.setTo(wsaTO);
            wsaHeader.setFrom(wsaFROM);
            wsaHeader.setAction(wsaAction);
            wsaHeader.setId(wsaID);
            wsaHeader.setRelatesTo(wsaRelatesTo);
            wsaHeader.setReplyTo(wsaReplyTo);
            wsaHeader.setFaultTo(wsaFaultTo);
            if (validate) {
                this.validate(message, wsaHeader);
            }
            return wsaHeader;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public void delete(OpenSPCoop2SoapMessage message, String actor) throws MessageException {
        try {
            SOAPHeader header = message.getSOAPHeader();
            if (header == null) {
                return;
            }
            SOAPHeaderElement wsaTO = null;
            SOAPHeaderElement wsaFROM = null;
            SOAPHeaderElement wsaAction = null;
            SOAPHeaderElement wsaID = null;
            SOAPHeaderElement wsaRelatesTo = null;
            SOAPHeaderElement wsaReplyTo = null;
            SOAPHeaderElement wsaFaultTo = null;
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                String namespace = headerElement.getNamespaceURI();
                String actorCheck = SoapUtils.getSoapActor(headerElement, message.getMessageType());
                boolean actorCompatible = false;
                actorCompatible = actor == null ? actorCheck == null : actor.equals(actorCheck);
                if (!actorCompatible || !"http://www.w3.org/2005/08/addressing".equals(namespace)) continue;
                if ("To".equals(headerElement.getLocalName())) {
                    wsaTO = headerElement;
                    continue;
                }
                if ("From".equals(headerElement.getLocalName())) {
                    wsaFROM = headerElement;
                    continue;
                }
                if ("Action".equals(headerElement.getLocalName())) {
                    wsaAction = headerElement;
                    continue;
                }
                if ("MessageID".equals(headerElement.getLocalName())) {
                    wsaID = headerElement;
                    continue;
                }
                if ("RelatesTo".equals(headerElement.getLocalName())) {
                    wsaRelatesTo = headerElement;
                    continue;
                }
                if ("ReplyTo".equals(headerElement.getLocalName())) {
                    wsaReplyTo = headerElement;
                    continue;
                }
                if (!"FaultTo".equals(headerElement.getLocalName())) continue;
                wsaFaultTo = headerElement;
            }
            if (wsaTO == null && wsaFROM == null && wsaAction == null && wsaID == null && wsaRelatesTo == null && wsaReplyTo == null && wsaFaultTo == null) {
                return;
            }
            if (wsaTO != null) {
                header.removeChild(wsaTO);
            }
            if (wsaFROM != null) {
                header.removeChild(wsaFROM);
            }
            if (wsaAction != null) {
                header.removeChild(wsaAction);
            }
            if (wsaID != null) {
                header.removeChild(wsaID);
            }
            if (wsaRelatesTo != null) {
                header.removeChild(wsaRelatesTo);
            }
            if (wsaReplyTo != null) {
                header.removeChild(wsaReplyTo);
            }
            if (wsaFaultTo != null) {
                header.removeChild(wsaFaultTo);
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }
}

