/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPPart;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;
import org.w3c.dom.Attr;

public class WSSecurityUtils {
    public static SOAPElement getSecurityHeader(SOAPPart soapPart, MessageType msgType, String actor, boolean throwExceptionIfFoundMoreSecurityHeader) throws MessageException, MessageNotSupportedException {
        SOAPHeader hdr = null;
        try {
            hdr = soapPart != null && soapPart.getEnvelope() != null ? soapPart.getEnvelope().getHeader() : null;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        if (hdr == null) {
            return null;
        }
        boolean soap12 = MessageType.SOAP_12.equals(msgType);
        String actorLocal = "actor";
        String soapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        if (soap12) {
            actorLocal = "role";
            soapNamespace = "http://www.w3.org/2003/05/soap-envelope";
        }
        SOAPElement foundSecurityHeader = null;
        List<SOAPElement> childs = SoapUtils.getNotEmptyChildSOAPElement((SOAPElement)hdr);
        if (childs != null && !childs.isEmpty()) {
            for (SOAPElement currentChild : childs) {
                Attr attr;
                String hActor;
                if (!"Security".equals(currentChild.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2002/04/secext".equals(currentChild.getNamespaceURI()) || !WSSecurityUtils.isActorEqual(actor, hActor = (attr = currentChild.getAttributeNodeNS(soapNamespace, actorLocal)) != null ? attr.getValue() : null)) continue;
                if (foundSecurityHeader != null) {
                    throw new MessageException("Two or more security headers have the same actor name: '" + actor + "'");
                }
                foundSecurityHeader = currentChild;
                if (throwExceptionIfFoundMoreSecurityHeader) continue;
                break;
            }
        }
        return foundSecurityHeader;
    }

    private static boolean isActorEqual(String actor, String hActor) {
        if (!(hActor != null && hActor.length() != 0 || actor != null && actor.length() != 0)) {
            return true;
        }
        return hActor != null && actor != null && hActor.equalsIgnoreCase(actor);
    }
}

