/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.SoapUtils;

public enum SOAPFaultCode implements Serializable
{
    DataEncodingUnknown,
    MustUnderstand,
    Receiver,
    Sender,
    VersionMismatch;


    public QName toQName(MessageType messageType, String prefix) throws MessageException, MessageNotSupportedException {
        String namespace = SoapUtils.getSoapEnvelopeNS(messageType);
        if (prefix != null) {
            return new QName(namespace, this.toString(messageType), prefix);
        }
        return new QName(namespace, this.toString(messageType));
    }

    public String toString(MessageType messageType) throws MessageException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw new MessageException("Require SOAP Message Type, found " + messageType + " Type");
        }
        switch (this) {
            case DataEncodingUnknown: {
                return "DataEncodingUnknown";
            }
            case MustUnderstand: {
                return "MustUnderstand";
            }
            case Receiver: {
                return messageType.equals(MessageType.SOAP_11) ? "Server" : "Receiver";
            }
            case Sender: {
                return messageType.equals(MessageType.SOAP_11) ? "Client" : "Sender";
            }
            case VersionMismatch: {
                return "VersionMismatch";
            }
        }
        return messageType.equals(MessageType.SOAP_11) ? "Server" : "Receiver";
    }
}

